/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.layout.LayoutFormatter;

public class Ordinal
implements LayoutFormatter {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(1?\\d\\b)");

    @Override
    public String format(String fieldText) {
        if (fieldText == null) {
            return null;
        }
        Matcher m3 = NUMBER_PATTERN.matcher(fieldText);
        StringBuffer sb = new StringBuffer();
        while (m3.find()) {
            String ordinalString;
            String result = m3.group(1);
            int value = Integer.parseInt(result);
            switch (value) {
                case 1: {
                    ordinalString = "st";
                    break;
                }
                case 2: {
                    ordinalString = "nd";
                    break;
                }
                case 3: {
                    ordinalString = "rd";
                    break;
                }
                default: {
                    ordinalString = "th";
                }
            }
            m3.appendReplacement(sb, result + ordinalString);
        }
        m3.appendTail(sb);
        return sb.toString();
    }
}

