/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.jabref.model.FieldChange;
import org.jabref.model.cleanup.FieldFormatterCleanup;
import org.jabref.model.entry.BibEntry;

public class FieldFormatterCleanups {
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    private final List<FieldFormatterCleanup> actions;
    private final boolean enabled;

    public FieldFormatterCleanups(boolean enabled, List<FieldFormatterCleanup> actions2) {
        this.enabled = enabled;
        this.actions = Objects.requireNonNull(actions2);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<FieldFormatterCleanup> getConfiguredActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldFormatterCleanups that = (FieldFormatterCleanups)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        return this.actions.equals(that.actions);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.enabled);
    }

    public List<FieldChange> applySaveActions(BibEntry entry) {
        if (this.enabled) {
            return this.applyAllActions(entry);
        }
        return new ArrayList<FieldChange>();
    }

    private List<FieldChange> applyAllActions(BibEntry entry) {
        ArrayList<FieldChange> result = new ArrayList<FieldChange>();
        for (FieldFormatterCleanup action : this.actions) {
            result.addAll(action.cleanup(entry));
        }
        return result;
    }

    public List<String> getAsStringList(String newline) {
        ArrayList<String> stringRepresentation = new ArrayList<String>();
        if (this.enabled) {
            stringRepresentation.add(ENABLED);
        } else {
            stringRepresentation.add(DISABLED);
        }
        String formatterString = FieldFormatterCleanups.getMetaDataString(this.actions, newline);
        stringRepresentation.add(formatterString);
        return stringRepresentation;
    }

    private static String getMetaDataString(List<FieldFormatterCleanup> actionList, String newline) {
        HashMap groupedByField = new HashMap();
        for (FieldFormatterCleanup cleanup : actionList) {
            List formattersForKey;
            String key = cleanup.getField();
            if (!groupedByField.containsKey(key)) {
                groupedByField.put(key, new ArrayList());
            }
            if ((formattersForKey = (List)groupedByField.get(key)).contains(cleanup.getFormatter().getKey())) continue;
            formattersForKey.add(cleanup.getFormatter().getKey());
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : groupedByField.entrySet()) {
            result.append((String)entry.getKey());
            StringJoiner joiner = new StringJoiner(",", "[", "]" + newline);
            ((List)entry.getValue()).forEach(joiner::add);
            result.append(joiner.toString());
        }
        return result.toString();
    }
}

