/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorListParser;

public class AuthorList {
    private static final WeakHashMap<String, AuthorList> AUTHOR_CACHE = new WeakHashMap();
    private static final Collection<String> AVOID_TERMS_IN_LOWER_CASE = Arrays.asList("jr", "sr", "jnr", "snr", "von", "zu", "van", "der");
    private final List<Author> authors;
    private final String[] authorsFirstFirst = new String[4];
    private final String[] authorsLastOnly = new String[2];
    private final String[] authorLastFirstAnds = new String[2];
    private final String[] authorsLastFirst = new String[4];
    private final String[] authorsLastFirstFirstLast = new String[2];
    private String authorsNatbib;
    private String authorsFirstFirstAnds;
    private String authorsAlph;

    protected AuthorList(List<Author> authors) {
        this.authors = Objects.requireNonNull(authors);
    }

    protected AuthorList(Author author) {
        this(Collections.singletonList(author));
    }

    public AuthorList() {
        this(new ArrayList<Author>());
    }

    public static AuthorList parse(String authors) {
        AuthorList authorList;
        boolean authorsContainTwoOrMoreCommas;
        Objects.requireNonNull(authors);
        boolean authorsContainAND = authors.toUpperCase(Locale.ENGLISH).contains(" AND ");
        boolean authorsContainOpeningBrace = authors.contains("{");
        boolean authorsContainSemicolon = authors.contains(";");
        boolean bl = authorsContainTwoOrMoreCommas = authors.length() - authors.replace(",", "").length() >= 2;
        if (!authorsContainAND && !authorsContainOpeningBrace && !authorsContainSemicolon && authorsContainTwoOrMoreCommas) {
            boolean spaceInAllParts;
            List<String> arrayNameList = Arrays.asList(authors.split(","));
            arrayNameList.replaceAll(String::trim);
            boolean bl2 = spaceInAllParts = arrayNameList.stream().filter(name -> name.contains(" ")).collect(Collectors.toList()).size() == arrayNameList.size();
            if (spaceInAllParts) {
                authors = authors.replaceAll(",", " and");
            } else {
                int valuePartsCount = arrayNameList.size();
                HashSet<Integer> avoidIndex = new HashSet<Integer>();
                for (int i = 0; i < arrayNameList.size(); ++i) {
                    if (!AVOID_TERMS_IN_LOWER_CASE.contains(arrayNameList.get(i).toLowerCase(Locale.ROOT))) continue;
                    avoidIndex.add(i);
                    --valuePartsCount;
                }
                if (valuePartsCount % 2 == 0) {
                    authors = AuthorList.buildWithAffix(avoidIndex, arrayNameList).toString();
                }
            }
        }
        if ((authorList = AUTHOR_CACHE.get(authors)) == null) {
            AuthorListParser parser = new AuthorListParser();
            authorList = parser.parse(authors);
            AUTHOR_CACHE.put(authors, authorList);
        }
        return authorList;
    }

    public static String fixAuthorFirstNameFirstCommas(String authors, boolean abbr, boolean oxfordComma) {
        return AuthorList.parse(authors).getAsFirstLastNames(abbr, oxfordComma);
    }

    public static String fixAuthorFirstNameFirst(String authors) {
        return AuthorList.parse(authors).getAsFirstLastNamesWithAnd();
    }

    public static String fixAuthorLastNameFirstCommas(String authors, boolean abbr, boolean oxfordComma) {
        return AuthorList.parse(authors).getAsLastFirstNames(abbr, oxfordComma);
    }

    public static String fixAuthorLastNameFirst(String authors) {
        return AuthorList.parse(authors).getAsLastFirstNamesWithAnd(false);
    }

    public static String fixAuthorLastNameFirst(String authors, boolean abbreviate) {
        return AuthorList.parse(authors).getAsLastFirstNamesWithAnd(abbreviate);
    }

    public static String fixAuthorLastNameOnlyCommas(String authors, boolean oxfordComma) {
        return AuthorList.parse(authors).getAsLastNames(oxfordComma);
    }

    public static String fixAuthorForAlphabetization(String authors) {
        return AuthorList.parse(authors).getForAlphabetization();
    }

    public static String fixAuthorNatbib(String authors) {
        return AuthorList.parse(authors).getAsNatbib();
    }

    private static StringBuilder buildWithAffix(Collection<Integer> indexArray, List<String> nameList) {
        StringBuilder stringBuilder = new StringBuilder();
        int avoidedTimes = 0;
        for (int i = 0; i < nameList.size(); ++i) {
            if (indexArray.contains(i)) {
                stringBuilder.append(nameList.get(i));
                stringBuilder.append(',');
                ++avoidedTimes;
                continue;
            }
            stringBuilder.append(nameList.get(i));
            if ((i + avoidedTimes) % 2 == 0) {
                stringBuilder.append(',');
                continue;
            }
            stringBuilder.append(';');
        }
        return stringBuilder;
    }

    public int getNumberOfAuthors() {
        return this.authors.size();
    }

    public boolean isEmpty() {
        return this.authors.isEmpty();
    }

    public Author getAuthor(int i) {
        return this.authors.get(i);
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public String getAsNatbib() {
        if (this.authorsNatbib != null) {
            return this.authorsNatbib;
        }
        StringBuilder res = new StringBuilder();
        if (!this.isEmpty()) {
            res.append(this.getAuthor(0).getLastOnly());
            if (this.getNumberOfAuthors() == 2) {
                res.append(" and ");
                res.append(this.getAuthor(1).getLastOnly());
            } else if (this.getNumberOfAuthors() > 2) {
                res.append(" et al.");
            }
        }
        this.authorsNatbib = res.toString();
        return this.authorsNatbib;
    }

    public String getAsLastNames(boolean oxfordComma) {
        int abbrInt;
        int n = abbrInt = oxfordComma ? 0 : 1;
        if (this.authorsLastOnly[abbrInt] != null) {
            return this.authorsLastOnly[abbrInt];
        }
        StringBuilder result = new StringBuilder();
        if (!this.isEmpty()) {
            int i;
            result.append(this.getAuthor(0).getLastOnly());
            for (i = 1; i < this.getNumberOfAuthors() - 1; ++i) {
                result.append(", ");
                result.append(this.getAuthor(i).getLastOnly());
            }
            if (this.getNumberOfAuthors() > 2 && oxfordComma) {
                result.append(',');
            }
            if (this.getNumberOfAuthors() > 1) {
                result.append(" and ");
                result.append(this.getAuthor(i).getLastOnly());
            }
        }
        this.authorsLastOnly[abbrInt] = result.toString();
        return this.authorsLastOnly[abbrInt];
    }

    public String getAsLastFirstNames(boolean abbreviate, boolean oxfordComma) {
        int abbrInt = abbreviate ? 0 : 1;
        if (this.authorsLastFirst[abbrInt += oxfordComma ? 0 : 2] != null) {
            return this.authorsLastFirst[abbrInt];
        }
        StringBuilder result = new StringBuilder();
        if (!this.isEmpty()) {
            int i;
            result.append(this.getAuthor(0).getLastFirst(abbreviate));
            for (i = 1; i < this.getNumberOfAuthors() - 1; ++i) {
                result.append(", ");
                result.append(this.getAuthor(i).getLastFirst(abbreviate));
            }
            if (this.getNumberOfAuthors() > 2 && oxfordComma) {
                result.append(',');
            }
            if (this.getNumberOfAuthors() > 1) {
                result.append(" and ");
                result.append(this.getAuthor(i).getLastFirst(abbreviate));
            }
        }
        this.authorsLastFirst[abbrInt] = result.toString();
        return this.authorsLastFirst[abbrInt];
    }

    public String toString() {
        return this.authors.toString();
    }

    public String getAsLastFirstNamesWithAnd(boolean abbreviate) {
        int abbrInt;
        int n = abbrInt = abbreviate ? 0 : 1;
        if (this.authorLastFirstAnds[abbrInt] != null) {
            return this.authorLastFirstAnds[abbrInt];
        }
        this.authorLastFirstAnds[abbrInt] = this.getAuthors().stream().map(author -> author.getLastFirst(abbreviate)).collect(Collectors.joining(" and "));
        return this.authorLastFirstAnds[abbrInt];
    }

    public String getAsLastFirstFirstLastNamesWithAnd(boolean abbreviate) {
        int abbrInt;
        int n = abbrInt = abbreviate ? 0 : 1;
        if (this.authorsLastFirstFirstLast[abbrInt] != null) {
            return this.authorsLastFirstFirstLast[abbrInt];
        }
        StringBuilder result = new StringBuilder();
        if (!this.isEmpty()) {
            result.append(this.getAuthor(0).getLastFirst(abbreviate));
            for (int i = 1; i < this.getNumberOfAuthors(); ++i) {
                result.append(" and ");
                result.append(this.getAuthor(i).getFirstLast(abbreviate));
            }
        }
        this.authorsLastFirstFirstLast[abbrInt] = result.toString();
        return this.authorsLastFirstFirstLast[abbrInt];
    }

    public String getAsFirstLastNames(boolean abbr, boolean oxfordComma) {
        int abbrInt = abbr ? 0 : 1;
        if (this.authorsFirstFirst[abbrInt += oxfordComma ? 0 : 2] != null) {
            return this.authorsFirstFirst[abbrInt];
        }
        StringBuilder result = new StringBuilder();
        if (!this.isEmpty()) {
            int i;
            result.append(this.getAuthor(0).getFirstLast(abbr));
            for (i = 1; i < this.getNumberOfAuthors() - 1; ++i) {
                result.append(", ");
                result.append(this.getAuthor(i).getFirstLast(abbr));
            }
            if (this.getNumberOfAuthors() > 2 && oxfordComma) {
                result.append(',');
            }
            if (this.getNumberOfAuthors() > 1) {
                result.append(" and ");
                result.append(this.getAuthor(i).getFirstLast(abbr));
            }
        }
        this.authorsFirstFirst[abbrInt] = result.toString();
        return this.authorsFirstFirst[abbrInt];
    }

    public boolean equals(Object o) {
        if (!(o instanceof AuthorList)) {
            return false;
        }
        AuthorList a = (AuthorList)o;
        return this.authors.equals(a.authors);
    }

    public int hashCode() {
        return Objects.hash(this.authors);
    }

    public String getAsFirstLastNamesWithAnd() {
        if (this.authorsFirstFirstAnds != null) {
            return this.authorsFirstFirstAnds;
        }
        this.authorsFirstFirstAnds = this.getAuthors().stream().map(author -> author.getFirstLast(false)).collect(Collectors.joining(" and "));
        return this.authorsFirstFirstAnds;
    }

    public String getForAlphabetization() {
        if (this.authorsAlph != null) {
            return this.authorsAlph;
        }
        this.authorsAlph = this.getAuthors().stream().map(Author::getNameForAlphabetization).collect(Collectors.joining(" and "));
        return this.authorsAlph;
    }

    public void addAuthor(String first, String firstabbr, String von, String last, String jr) {
        this.authors.add(new Author(first, firstabbr, von, last, jr));
    }
}

