/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.pdfimport;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.jabref.Globals;
import org.jabref.gui.JabRefDialog;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.xmp.XmpUtilReader;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;

public class ImportDialog
extends JabRefDialog {
    public static final int NOMETA = 0;
    public static final int XMP = 1;
    public static final int CONTENT = 2;
    public static final int ONLYATTACH = 4;
    private final JCheckBox checkBoxDoNotShowAgain;
    private final JCheckBox useDefaultPDFImportStyle;
    private final JRadioButton radioButtonXmp;
    private final JRadioButton radioButtonPDFcontent;
    private final JRadioButton radioButtonNoMeta;
    private final JRadioButton radioButtononlyAttachPDF;
    private int result;

    public ImportDialog(boolean targetIsARow, String fileName) {
        super(ImportDialog.class);
        Boolean targetIsARow1 = targetIsARow;
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.setContentPane(contentPane);
        JPanel panel3 = new JPanel();
        panel3.setBackground(new Color(-1643275));
        JLabel labelHeadline = new JLabel(Localization.lang("Import metadata from:", new String[0]));
        labelHeadline.setFont(new Font(labelHeadline.getFont().getName(), 1, 14));
        JLabel labelSubHeadline = new JLabel(Localization.lang("Choose the source for the metadata import", new String[0]));
        labelSubHeadline.setFont(new Font(labelSubHeadline.getFont().getName(), labelSubHeadline.getFont().getStyle(), 13));
        JLabel labelFileName = new JLabel();
        labelFileName.setFont(new Font(labelHeadline.getFont().getName(), 1, 14));
        JPanel headLinePanel = new JPanel();
        headLinePanel.add(labelHeadline);
        headLinePanel.add(labelFileName);
        headLinePanel.setBackground(new Color(-1643275));
        GridLayout gl = new GridLayout(2, 1);
        gl.setVgap(10);
        gl.setHgap(10);
        panel3.setLayout(gl);
        panel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel3.add(headLinePanel);
        panel3.add(labelSubHeadline);
        this.radioButtonNoMeta = new JRadioButton(Localization.lang("Create blank entry linking the PDF", new String[0]));
        this.radioButtonXmp = new JRadioButton(Localization.lang("Create entry based on XMP-metadata", new String[0]));
        this.radioButtonPDFcontent = new JRadioButton(Localization.lang("Create entry based on content", new String[0]));
        this.radioButtononlyAttachPDF = new JRadioButton(Localization.lang("Only attach PDF", new String[0]));
        JButton buttonOK = new JButton(Localization.lang("OK", new String[0]));
        JButton buttonCancel = new JButton(Localization.lang("Cancel", new String[0]));
        this.checkBoxDoNotShowAgain = new JCheckBox(Localization.lang("Do not show this box again for this import", new String[0]));
        this.useDefaultPDFImportStyle = new JCheckBox(Localization.lang("Always use this PDF import style (and do not ask for each import)", new String[0]));
        DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("left:pref, 5dlu, left:pref:grow", ""));
        List<BibEntry> foundEntries = this.getEntriesFromXMP(fileName);
        JPanel entriesPanel = new JPanel();
        entriesPanel.setLayout(new BoxLayout(entriesPanel, 1));
        foundEntries.forEach(entry -> {
            JTextArea entryArea = new JTextArea(entry.toString());
            entryArea.setEditable(false);
            entriesPanel.add(entryArea);
        });
        b.appendSeparator(Localization.lang("Create new entry", new String[0]));
        b.append((Component)this.radioButtonNoMeta, 3);
        b.append((Component)this.radioButtonXmp, 3);
        b.append((Component)this.radioButtonPDFcontent, 3);
        b.appendSeparator(Localization.lang("Update existing entry", new String[0]));
        b.append((Component)this.radioButtononlyAttachPDF, 3);
        b.nextLine();
        b.append(this.checkBoxDoNotShowAgain);
        b.append(this.useDefaultPDFImportStyle);
        if (!foundEntries.isEmpty()) {
            b.appendSeparator(Localization.lang("XMP-metadata", new String[0]));
            b.append((Component)entriesPanel, 3);
        }
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)buttonOK);
        bb.addButton((JComponent)buttonCancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)panel3, "North");
        contentPane.add((Component)b.getPanel(), "Center");
        contentPane.add((Component)bb.getPanel(), "South");
        if (!targetIsARow1.booleanValue()) {
            this.radioButtononlyAttachPDF.setEnabled(false);
        }
        String name = new File(fileName).getName();
        labelFileName.setText(StringUtil.limitStringLength(name, 34));
        this.setTitle(Localization.lang("Import metadata from PDF", new String[0]));
        this.setModal(true);
        this.getRootPane().setDefaultButton(buttonOK);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioButtonNoMeta);
        bg.add(this.radioButtonXmp);
        bg.add(this.radioButtonPDFcontent);
        bg.add(this.radioButtononlyAttachPDF);
        buttonOK.addActionListener(e -> this.onOK());
        buttonCancel.addActionListener(e -> this.onCancel());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImportDialog.this.onCancel();
            }
        });
        contentPane.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        switch (Globals.prefs.getInt("importDefaultPDFimportStyle")) {
            case 0: {
                this.radioButtonNoMeta.setSelected(true);
                break;
            }
            case 1: {
                this.radioButtonXmp.setSelected(true);
                break;
            }
            case 2: {
                this.radioButtonPDFcontent.setSelected(true);
                break;
            }
            case 4: {
                this.radioButtononlyAttachPDF.setSelected(true);
                break;
            }
            default: {
                this.radioButtonPDFcontent.setSelected(true);
            }
        }
        this.setSize(555, 371);
    }

    private List<BibEntry> getEntriesFromXMP(String fileName) {
        ArrayList<BibEntry> foundEntries = new ArrayList();
        try {
            foundEntries = XmpUtilReader.readXmp(fileName, Globals.prefs.getXMPPreferences());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return foundEntries;
    }

    private void onOK() {
        this.result = 0;
        Globals.prefs.putInt("importDefaultPDFimportStyle", this.getChoice());
        if (this.useDefaultPDFImportStyle.isSelected()) {
            Globals.prefs.putBoolean("importAlwaysUsePDFImportStyle", true);
        }
        this.dispose();
    }

    private void onCancel() {
        this.result = 2;
        this.dispose();
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
    }

    public int getChoice() {
        if (this.radioButtonXmp.isSelected()) {
            return 1;
        }
        if (this.radioButtonPDFcontent.isSelected()) {
            return 2;
        }
        if (this.radioButtonNoMeta.isSelected()) {
            return 0;
        }
        if (this.radioButtononlyAttachPDF.isSelected()) {
            return 4;
        }
        throw new IllegalStateException();
    }

    public boolean isDoNotShowAgain() {
        return this.checkBoxDoNotShowAgain.isSelected();
    }

    public int getResult() {
        return this.result;
    }

    public void disableXMPChoice() {
        this.radioButtonXmp.setEnabled(false);
    }
}

