/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import org.reactfx.Subscription;
import org.reactfx.value.ProxyVal;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

class VarFromVal<T>
extends ProxyVal<T, T>
implements Var<T> {
    private final Consumer<T> setter;
    private Subscription binding = null;

    VarFromVal(Val<T> underlying, Consumer<T> setter2) {
        super(underlying);
        this.setter = setter2;
    }

    public T getValue() {
        return (T)((Val)this.getUnderlyingObservable()).getValue();
    }

    @Override
    protected Consumer<? super T> adaptObserver(Consumer<? super T> observer) {
        return observer;
    }

    public void bind(ObservableValue<? extends T> observable) {
        this.unbind();
        this.binding = Val.observeChanges(observable, (obs, oldVal, newVal) -> this.setValue(newVal));
        this.setValue(observable.getValue());
    }

    public void unbind() {
        if (this.binding != null) {
            this.binding.unsubscribe();
            this.binding = null;
        }
    }

    public boolean isBound() {
        return this.binding != null;
    }

    public void setValue(T value) {
        this.setter.accept(value);
    }
}

