/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l = 33039873230384L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1310175720 - 6064, 1310175720 + 13098, (int)l));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1310175720 - 6063, -1310175720 + -2833, (int)l));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l;
            block2: {
                l = 54325732285397L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.Q();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 != 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1308996090 + (char)-27163, 1308996090 + (char)-21976, (int)l) + string + WindowsNamedPipeAgentIpc.b(1308996090 + (char)-27164, -1308996090 + -((char)-23863), (int)l) + thread3 + WindowsNamedPipeAgentIpc.b(1308996090 + (char)-27169, 1308996090 + (char)-18400, (int)l) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l;
        block14: {
            block15: {
                l = 43831901315846L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    n2 = SshAgentIpcService.Q();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1760007960 + -((char)-22051), 1760007960 + 29664, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1760007960 + -((char)-22048), -1760007960 + -32759, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (n2 != 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1760007960 + -((char)-22049), 1760007960 + (char)-17015, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1760007960 + -((char)-22046), 1760007960 + (char)-14759, (int)l) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1760007960 + -((char)-22047), -1760007960 + -((char)-29496), (int)l));
            logger.info(WindowsNamedPipeAgentIpc.b(-1760007960 + -((char)-22049), 1760007960 + (char)-17015, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1760007960 + -((char)-22044), 1760007960 + (char)-14614, (int)l));
            if (ActionTimestamp.Q() == null) {
                SshAgentIpcService.Q(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l = 9153651091738L;
                    n3 = SshAgentIpcService.S();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 == 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 == 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l;
        block27: {
            block28: {
                l = 82606281804932L;
                int n3 = SshAgentIpcService.Q();
                this.assertConnectionThread();
                Object object3 = this.lock;
                n2 = n3;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 != 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1175828970 - -19057, -1175828970 - -20433, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1175828970 - -19061, 1175828970 - 16071, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1175828970 - -19050, 1175828970 - 16035, (int)l) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1175828970 - -19061, 1175828970 - 16071, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1175828970 - -19051, 1175828970 - (char)-23118, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1175828970 - -19057, -1175828970 - -20433, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1175828970 - -19061, 1175828970 - 16071, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1175828970 - -19052, 1175828970 - 17733, (int)l));
                    object2 = Kernel32.INSTANCE;
                    if (n2 != 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n4 = Kernel32.INSTANCE.GetLastError();
                if (n4 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1175828970 - -19057, -1175828970 - -20433, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1175828970 - -19061, 1175828970 - 16071, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1175828970 - -19053, 1175828970 - 25763, (int)l));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1175828970 - -19061, 1175828970 - 16071, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1175828970 - -19078, 1175828970 - 23574, (int)l) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n4)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 != 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1175828970 - -19061, 1175828970 - 16071, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1175828970 - -19051, 1175828970 - (char)-23118, (int)l) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1175828970 - -19057, -1175828970 - -20433, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-1175828970 - -19061, 1175828970 - 16071, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1175828970 - -19079, 1175828970 - 25886, (int)l));
        long l2 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l2);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l = 7650810629027L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1473882150 + 17827, 1473882150 + 4340, (int)l));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l = 55174097412979L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(947505030 + 32146, 947505030 + 18317, (int)l));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00adv\u00070}\u009b\u00a0\u00b7V\u001e\u00ff6/\u00bbNS\u00ac\u00d1=\u0014\u001e2q\u00be\u00a8\u0088gP,\u00e4u\u00bd\u00bc3\u00fd\u00c97DI\u00c7";
                        var4_3 = "\u00adv\u00070}\u009b\u00a0\u00b7V\u001e\u00ff6/\u00bbNS\u00ac\u00d1=\u0014\u001e2q\u00be\u00a8\u0088gP,\u00e4u\u00bd\u00bc3\u00fd\u00c97DI\u00c7".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 3;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 33;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 74;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 33;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 84;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 45;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 100;
                                        break;
                                    }
                                    default: {
                                        v11 = 31;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x666A) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 222;
                            case 1 -> 62;
                            case 2 -> 186;
                            case 3 -> 122;
                            case 4 -> 234;
                            case 5 -> 242;
                            case 6 -> 44;
                            case 7 -> 219;
                            case 8 -> 189;
                            case 9 -> 162;
                            case 10 -> 165;
                            case 11 -> 127;
                            case 12 -> 213;
                            case 13 -> 70;
                            case 14 -> 147;
                            case 15 -> 149;
                            case 16 -> 120;
                            case 17 -> 148;
                            case 18 -> 201;
                            case 19 -> 220;
                            case 20 -> 171;
                            case 21 -> 129;
                            case 22 -> 20;
                            case 23 -> 239;
                            case 24 -> 104;
                            case 25 -> 38;
                            case 26 -> 45;
                            case 27 -> 181;
                            case 28 -> 98;
                            case 29 -> 40;
                            case 30 -> 205;
                            case 31 -> 167;
                            case 32 -> 79;
                            case 33 -> 42;
                            case 34 -> 195;
                            case 35 -> 228;
                            case 36 -> 19;
                            case 37 -> 131;
                            case 38 -> 193;
                            case 39 -> 55;
                            case 40 -> 41;
                            case 41 -> 233;
                            case 42 -> 10;
                            case 43 -> 232;
                            case 44 -> 183;
                            case 45 -> 238;
                            case 46 -> 155;
                            case 47 -> 32;
                            case 48 -> 24;
                            case 49 -> 209;
                            case 50 -> 247;
                            case 51 -> 158;
                            case 52 -> 90;
                            case 53 -> 1;
                            case 54 -> 166;
                            case 55 -> 101;
                            case 56 -> 221;
                            case 57 -> 30;
                            case 58 -> 252;
                            case 59 -> 107;
                            case 60 -> 14;
                            case 61 -> 116;
                            case 62 -> 59;
                            case 63 -> 22;
                            case 64 -> 0;
                            case 65 -> 245;
                            case 66 -> 207;
                            case 67 -> 203;
                            case 68 -> 21;
                            case 69 -> 184;
                            case 70 -> 117;
                            case 71 -> 235;
                            case 72 -> 69;
                            case 73 -> 84;
                            case 74 -> 9;
                            case 75 -> 29;
                            case 76 -> 27;
                            case 77 -> 161;
                            case 78 -> 225;
                            case 79 -> 204;
                            case 80 -> 211;
                            case 81 -> 83;
                            case 82 -> 212;
                            case 83 -> 175;
                            case 84 -> 178;
                            case 85 -> 112;
                            case 86 -> 85;
                            case 87 -> 200;
                            case 88 -> 177;
                            case 89 -> 46;
                            case 90 -> 248;
                            case 91 -> 198;
                            case 92 -> 53;
                            case 93 -> 125;
                            case 94 -> 170;
                            case 95 -> 142;
                            case 96 -> 93;
                            case 97 -> 51;
                            case 98 -> 78;
                            case 99 -> 136;
                            case 100 -> 52;
                            case 101 -> 95;
                            case 102 -> 97;
                            case 103 -> 11;
                            case 104 -> 8;
                            case 105 -> 199;
                            case 106 -> 73;
                            case 107 -> 81;
                            case 108 -> 57;
                            case 109 -> 137;
                            case 110 -> 187;
                            case 111 -> 124;
                            case 112 -> 246;
                            case 113 -> 35;
                            case 114 -> 139;
                            case 115 -> 114;
                            case 116 -> 60;
                            case 117 -> 176;
                            case 118 -> 87;
                            case 119 -> 208;
                            case 120 -> 58;
                            case 121 -> 135;
                            case 122 -> 182;
                            case 123 -> 39;
                            case 124 -> 231;
                            case 125 -> 54;
                            case 126 -> 6;
                            case 127 -> 50;
                            case 128 -> 105;
                            case 129 -> 77;
                            case 130 -> 103;
                            case 131 -> 255;
                            case 132 -> 47;
                            case 133 -> 63;
                            case 134 -> 119;
                            case 135 -> 144;
                            case 136 -> 132;
                            case 137 -> 110;
                            case 138 -> 163;
                            case 139 -> 106;
                            case 140 -> 236;
                            case 141 -> 218;
                            case 142 -> 133;
                            case 143 -> 216;
                            case 144 -> 99;
                            case 145 -> 153;
                            case 146 -> 2;
                            case 147 -> 64;
                            case 148 -> 102;
                            case 149 -> 217;
                            case 150 -> 210;
                            case 151 -> 28;
                            case 152 -> 164;
                            case 153 -> 251;
                            case 154 -> 254;
                            case 155 -> 121;
                            case 156 -> 61;
                            case 157 -> 134;
                            case 158 -> 226;
                            case 159 -> 118;
                            case 160 -> 7;
                            case 161 -> 150;
                            case 162 -> 192;
                            case 163 -> 126;
                            case 164 -> 180;
                            case 165 -> 152;
                            case 166 -> 3;
                            case 167 -> 25;
                            case 168 -> 43;
                            case 169 -> 33;
                            case 170 -> 229;
                            case 171 -> 68;
                            case 172 -> 111;
                            case 173 -> 169;
                            case 174 -> 65;
                            case 175 -> 37;
                            case 176 -> 82;
                            case 177 -> 115;
                            case 178 -> 15;
                            case 179 -> 194;
                            case 180 -> 214;
                            case 181 -> 89;
                            case 182 -> 80;
                            case 183 -> 108;
                            case 184 -> 12;
                            case 185 -> 72;
                            case 186 -> 227;
                            case 187 -> 179;
                            case 188 -> 143;
                            case 189 -> 31;
                            case 190 -> 138;
                            case 191 -> 197;
                            case 192 -> 151;
                            case 193 -> 86;
                            case 194 -> 123;
                            case 195 -> 191;
                            case 196 -> 49;
                            case 197 -> 237;
                            case 198 -> 241;
                            case 199 -> 146;
                            case 200 -> 156;
                            case 201 -> 145;
                            case 202 -> 13;
                            case 203 -> 141;
                            case 204 -> 159;
                            case 205 -> 109;
                            case 206 -> 223;
                            case 207 -> 48;
                            case 208 -> 250;
                            case 209 -> 253;
                            case 210 -> 196;
                            case 211 -> 202;
                            case 212 -> 230;
                            case 213 -> 188;
                            case 214 -> 5;
                            case 215 -> 36;
                            case 216 -> 140;
                            case 217 -> 18;
                            case 218 -> 66;
                            case 219 -> 157;
                            case 220 -> 206;
                            case 221 -> 173;
                            case 222 -> 174;
                            case 223 -> 154;
                            case 224 -> 168;
                            case 225 -> 128;
                            case 226 -> 17;
                            case 227 -> 71;
                            case 228 -> 160;
                            case 229 -> 130;
                            case 230 -> 190;
                            case 231 -> 185;
                            case 232 -> 4;
                            case 233 -> 88;
                            case 234 -> 92;
                            case 235 -> 240;
                            case 236 -> 94;
                            case 237 -> 113;
                            case 238 -> 74;
                            case 239 -> 23;
                            case 240 -> 75;
                            case 241 -> 76;
                            case 242 -> 243;
                            case 243 -> 34;
                            case 244 -> 16;
                            case 245 -> 26;
                            case 246 -> 244;
                            case 247 -> 224;
                            case 248 -> 215;
                            case 249 -> 91;
                            case 250 -> 96;
                            case 251 -> 67;
                            case 252 -> 100;
                            case 253 -> 249;
                            case 254 -> 56;
                            default -> 172;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 != 0) {
                ActionTimestamp.Q(new int[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l2;
            block2: {
                block3: {
                    l2 = 66790593542803L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.Q();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 != 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(442885530 + 246, 442885530 - 426, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(442885530 + 258, -442885530 + -3378, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(442885530 + 239, -442885530 + -1843, (int)l2) + uLONG);
                    l = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(442885530 + 246, 442885530 - 426, (int)l2));
            logger.warn(WindowsNamedPipeAgentIpc.b(442885530 + 258, -442885530 + -3378, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(442885530 + 238, -442885530 - -5079, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n4));
            l = -1L;
        }
        long l3 = l;
        return l3;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l = 52240811475143L;
                        int n3 = SshAgentIpcService.Q();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1124318460 - -((char)-9769), -1124318460 - -((char)-5740), (int)l));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 != 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 != 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1124318460 - -((char)-9770), 1124318460 - (char)-14014, (int)l);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 != 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l;
        block25: {
            block26: {
                l = 47140964534018L;
                int n3 = SshAgentIpcService.S();
                this.assertConnectionThread();
                Object object2 = this.lock;
                n2 = n3;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 == 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 == 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(596499570 - 369, 596499570 + 495, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(596499570 - 357, -596499570 - -3351, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(596499570 - 342, 596499570 - 23165, (int)l));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(596499570 - 357, -596499570 - -3351, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(596499570 - 363, -596499570 - -15408, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(596499570 - 369, 596499570 + 495, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(596499570 - 357, -596499570 - -3351, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(596499570 - 341, 596499570 + 8081, (int)l));
                    object = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(596499570 - 369, 596499570 + 495, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(596499570 - 357, -596499570 - -3351, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(596499570 - 352, -596499570 + -6383, (int)l) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 == 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(596499570 - 369, 596499570 + 495, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(596499570 - 357, -596499570 - -3351, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(596499570 - 351, -596499570 - -10015, (int)l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l;
            block15: {
                int n3;
                block16: {
                    l = 54194826143624L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                n3 = SshAgentIpcService.Q();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 != 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-928762020 + -31697, -928762020 + -30833, (int)l));
                                logger.info(WindowsNamedPipeAgentIpc.b(-928762020 + -31701, 928762020 + (char)-30837, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-928762020 + -31682, 928762020 + (char)-26909, (int)l) + this.state + WindowsNamedPipeAgentIpc.b(-928762020 + -31681, 928762020 + 21204, (int)l));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-928762020 + -31697, -928762020 + -30833, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-928762020 + -31701, 928762020 + (char)-30837, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-928762020 + -31680, -928762020 + -((char)-32141), (int)l));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 != 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 != 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-928762020 + -31697, -928762020 + -30833, (int)l));
                        logger.info(WindowsNamedPipeAgentIpc.b(-928762020 + -31701, 928762020 + (char)-30837, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-928762020 + -31679, 928762020 + 15261, (int)l) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-928762020 + -31697, -928762020 + -30833, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-928762020 + -31701, 928762020 + (char)-30837, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-928762020 + -31678, -928762020 + -23412, (int)l));
                    if (n3 != 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-928762020 + -31697, -928762020 + -30833, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(-928762020 + -31701, 928762020 + (char)-30837, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-928762020 + -31677, 928762020 + (char)-24899, (int)l) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u0006\u00e9\u0006,(b\u0095\u00d6\u0014?\u0001\u0019\u00d65\u00b5\u00996=\u00fb\u0098\u0094\u0097\u00a5\u00d7\u0085\u00c7P\u0002\u00c5\u0006\u00bd\u00e3qm\u00ac\u000b\u0018Y\u00a1\u00b5\u00f2\"\u00f4y\u00de\u00e9\u009b\r\u00e8C\u00d5\u001f\tw\u00a8:GD=\u009c\u009b\t+2e1S\u0013Oj\u0013\u0005e\u00a6j\u00c5\u00d5\b#\u00a2\u00a24\u00eeGK\u0090\u0005W\u0089, \u001d\u001e\u00f6\u00a0\ra\u00a4B\u000br\u0002\u001a;_\u00c9\u0003\u00ec\u00b7\u00e8\u00ee\u001b{\u00cc\u0095\u0081CX&\u00db)\u008a\u0010\u0010\u00d4:\u00ad\u00f7\u00e7\u00a2\u0095\u0097\u00ac\u0014cc\u00c4\u00d1\u00e2r\t\u00fcHIo\u0085\u00ff\u00b3hb\u0010\u00a5N\u0083y\"s-\u00ad\u00bbS\u0081\u008b\u0098\u00cci\u00d1?O\u00d62\u00afN\u0092\u00d3\u0004h\u00053Gw\u00f6\u00060p{u\f\u008f)\u0092\u00b2*\u00f0\u0098G\u00d5\u008b\u00f5\u0017\u00da\u00f2\u00ad\u0081\u00ad\u0013\u00f6\u0087\u001e\u00e5\u00b6s\u007f}\u00e57\u00a0\u00c2\u00d9\u00bean\u00de#\u00bevO\u0082\u00a17M\b\u00fa\u00f3\u0099\u001e\u0089\u0002\u00a78\f\u00cc\u00b6O\u00adN\u0016\u00b1\u00bd\u0001\u0019\u0084\u00c6F\u0012\u0015\u0094\u00d95\u0098\u00del\u00ec/3\u00c4\u00e1\u008e\u00cb\u001959\u00dd\u00eb\u0088\u0087qU`'\"\u00b6=\u009c\u00d2\u00c9\u0002\u009ft\rL\u00cfa\u00d8\u007f\u001b\u0011WU|\u00f4je\u0091\u0007~U\u00e0N\u00e93[h\u009bv}\u00eb\u00fa\u00df3R!/\u00bb\u001f\u001b\u00b9\u00b0B\u0013&\u00fd\u00fe\u00dc\u008b\u00e0m\u00b2X\u0088m\u001f]\u0098\u00c7w\u0082!\n-\u00dfb\u00da\u00a0\u009fc\u000b\u00c2\u00ff\u008e\u0084v3\u00b6\u0019\u00e1\u0081\u0092\u0015\u00fb\u00e1\u00a9D\u0095C&j\u00cd\u000f\u00df6\u00eb\u009f\u00be\u00c3\"\u001c\u00e2\u0096\u000e)\u00ceI\n\\D\u00e5\u0017\u0086\u0081\u0084K\u008c\u00c3n8\u00aeV\u00adj~\u00d9\u00cd2\u00fb \u00a8\u0014LA\u00b9\u00ddS\u001di\u00f1^\u00e2\u00b8?\u009f\u0017\u0007\u0085ci\u0003\fS\u0085\u0007C\u008e\u00d5\u00d2|\u0086\u009d(\u00c6wG\u00ba]S\u00c2wKm8\u0087\u008e\u008e\u00d31,\u00f3\u008b\u00f6\u0084\u00e2\u00f6\u00d5(\u00d1\u00a3\u0018\u0080S>\u0017\u009a\u008a\u009f\u008f\u0095\u00ffB\u0084\u000f\u001fl2\u00f0\u001bv\u00af\u0010\u0093\f\u0082\u00fayu\u00b3\"\u008e\u0093\u0002\u0007E\u008e7\u00eb\u0085)\u00cb9\u00d0\u00d4>7}\u00b7\u0085\u007f\u00ce\u00edp\u00af\u00fbv\u00a2I\u00b3+!\u0006\u00ac0\u000e\u00f8\u00f3\u00ce\u0003\u0084\b\\\u00df\u00ed\u00f5M\u00c5\u008c\u0098\u001bh\u00ec\u00db\u00e5\u00dda\u00e2\u00aem\\\u00d0\u00f1o(\u00ef\u00be\u00ef,j\u0090\b$\u00db0\u00c5\u00e80\n\u00db,i\u00fa\u009ffyd\u00b5g\u0018S\u00b0\u00bcc0\r~}\u00e0\u00ef\u00a3\u0018\u00b8F\u00e9RX\u00b0KzT2\u000b\u00a1)F\u0085\u001b\u00c5f\u00d6S\u00e0\tHZ\u0015\u00e5Tc\u0092C_\u0017\u00e5L\u00ae\u00c9\u009b*6\u00c8s\u0089\u0002\u007f\u00b5lk\n\u008aC\u0006\u000bH\u0091";
                var4_3 = "\u0006\u00e9\u0006,(b\u0095\u00d6\u0014?\u0001\u0019\u00d65\u00b5\u00996=\u00fb\u0098\u0094\u0097\u00a5\u00d7\u0085\u00c7P\u0002\u00c5\u0006\u00bd\u00e3qm\u00ac\u000b\u0018Y\u00a1\u00b5\u00f2\"\u00f4y\u00de\u00e9\u009b\r\u00e8C\u00d5\u001f\tw\u00a8:GD=\u009c\u009b\t+2e1S\u0013Oj\u0013\u0005e\u00a6j\u00c5\u00d5\b#\u00a2\u00a24\u00eeGK\u0090\u0005W\u0089, \u001d\u001e\u00f6\u00a0\ra\u00a4B\u000br\u0002\u001a;_\u00c9\u0003\u00ec\u00b7\u00e8\u00ee\u001b{\u00cc\u0095\u0081CX&\u00db)\u008a\u0010\u0010\u00d4:\u00ad\u00f7\u00e7\u00a2\u0095\u0097\u00ac\u0014cc\u00c4\u00d1\u00e2r\t\u00fcHIo\u0085\u00ff\u00b3hb\u0010\u00a5N\u0083y\"s-\u00ad\u00bbS\u0081\u008b\u0098\u00cci\u00d1?O\u00d62\u00afN\u0092\u00d3\u0004h\u00053Gw\u00f6\u00060p{u\f\u008f)\u0092\u00b2*\u00f0\u0098G\u00d5\u008b\u00f5\u0017\u00da\u00f2\u00ad\u0081\u00ad\u0013\u00f6\u0087\u001e\u00e5\u00b6s\u007f}\u00e57\u00a0\u00c2\u00d9\u00bean\u00de#\u00bevO\u0082\u00a17M\b\u00fa\u00f3\u0099\u001e\u0089\u0002\u00a78\f\u00cc\u00b6O\u00adN\u0016\u00b1\u00bd\u0001\u0019\u0084\u00c6F\u0012\u0015\u0094\u00d95\u0098\u00del\u00ec/3\u00c4\u00e1\u008e\u00cb\u001959\u00dd\u00eb\u0088\u0087qU`'\"\u00b6=\u009c\u00d2\u00c9\u0002\u009ft\rL\u00cfa\u00d8\u007f\u001b\u0011WU|\u00f4je\u0091\u0007~U\u00e0N\u00e93[h\u009bv}\u00eb\u00fa\u00df3R!/\u00bb\u001f\u001b\u00b9\u00b0B\u0013&\u00fd\u00fe\u00dc\u008b\u00e0m\u00b2X\u0088m\u001f]\u0098\u00c7w\u0082!\n-\u00dfb\u00da\u00a0\u009fc\u000b\u00c2\u00ff\u008e\u0084v3\u00b6\u0019\u00e1\u0081\u0092\u0015\u00fb\u00e1\u00a9D\u0095C&j\u00cd\u000f\u00df6\u00eb\u009f\u00be\u00c3\"\u001c\u00e2\u0096\u000e)\u00ceI\n\\D\u00e5\u0017\u0086\u0081\u0084K\u008c\u00c3n8\u00aeV\u00adj~\u00d9\u00cd2\u00fb \u00a8\u0014LA\u00b9\u00ddS\u001di\u00f1^\u00e2\u00b8?\u009f\u0017\u0007\u0085ci\u0003\fS\u0085\u0007C\u008e\u00d5\u00d2|\u0086\u009d(\u00c6wG\u00ba]S\u00c2wKm8\u0087\u008e\u008e\u00d31,\u00f3\u008b\u00f6\u0084\u00e2\u00f6\u00d5(\u00d1\u00a3\u0018\u0080S>\u0017\u009a\u008a\u009f\u008f\u0095\u00ffB\u0084\u000f\u001fl2\u00f0\u001bv\u00af\u0010\u0093\f\u0082\u00fayu\u00b3\"\u008e\u0093\u0002\u0007E\u008e7\u00eb\u0085)\u00cb9\u00d0\u00d4>7}\u00b7\u0085\u007f\u00ce\u00edp\u00af\u00fbv\u00a2I\u00b3+!\u0006\u00ac0\u000e\u00f8\u00f3\u00ce\u0003\u0084\b\\\u00df\u00ed\u00f5M\u00c5\u008c\u0098\u001bh\u00ec\u00db\u00e5\u00dda\u00e2\u00aem\\\u00d0\u00f1o(\u00ef\u00be\u00ef,j\u0090\b$\u00db0\u00c5\u00e80\n\u00db,i\u00fa\u009ffyd\u00b5g\u0018S\u00b0\u00bcc0\r~}\u00e0\u00ef\u00a3\u0018\u00b8F\u00e9RX\u00b0KzT2\u000b\u00a1)F\u0085\u001b\u00c5f\u00d6S\u00e0\tHZ\u0015\u00e5Tc\u0092C_\u0017\u00e5L\u00ae\u00c9\u009b*6\u00c8s\u0089\u0002\u007f\u00b5lk\n\u008aC\u0006\u000bH\u0091".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 64;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "sB\f\u0084\u0093\u00f9\u0093Go\u001d\tOF(y\u00df\u0004uWN%a\u00ben\u00bca\f\u0099\u001a\r\f8\u0086#\u00dc\u00893u\u00d2";
                    var4_3 = "sB\f\u0084\u0093\u00f9\u0093Go\u001d\tOF(y\u00df\u0004uWN%a\u00ben\u00bca\f\u0099\u001a\r\f8\u0086#\u00dc\u00893u\u00d2".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 31;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 118;
                            break;
                        }
                        case 1: {
                            v15 = 1;
                            break;
                        }
                        case 2: {
                            v15 = 78;
                            break;
                        }
                        case 3: {
                            v15 = 88;
                            break;
                        }
                        case 4: {
                            v15 = 71;
                            break;
                        }
                        case 5: {
                            v15 = 12;
                            break;
                        }
                        default: {
                            v15 = 30;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFDC08) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 23;
                case 1 -> 121;
                case 2 -> 231;
                case 3 -> 80;
                case 4 -> 67;
                case 5 -> 234;
                case 6 -> 16;
                case 7 -> 170;
                case 8 -> 85;
                case 9 -> 247;
                case 10 -> 38;
                case 11 -> 214;
                case 12 -> 126;
                case 13 -> 91;
                case 14 -> 157;
                case 15 -> 25;
                case 16 -> 17;
                case 17 -> 10;
                case 18 -> 87;
                case 19 -> 215;
                case 20 -> 59;
                case 21 -> 200;
                case 22 -> 93;
                case 23 -> 44;
                case 24 -> 114;
                case 25 -> 49;
                case 26 -> 64;
                case 27 -> 201;
                case 28 -> 104;
                case 29 -> 158;
                case 30 -> 108;
                case 31 -> 22;
                case 32 -> 209;
                case 33 -> 79;
                case 34 -> 81;
                case 35 -> 33;
                case 36 -> 165;
                case 37 -> 208;
                case 38 -> 73;
                case 39 -> 137;
                case 40 -> 124;
                case 41 -> 238;
                case 42 -> 110;
                case 43 -> 102;
                case 44 -> 95;
                case 45 -> 57;
                case 46 -> 235;
                case 47 -> 159;
                case 48 -> 226;
                case 49 -> 205;
                case 50 -> 41;
                case 51 -> 188;
                case 52 -> 101;
                case 53 -> 82;
                case 54 -> 249;
                case 55 -> 142;
                case 56 -> 86;
                case 57 -> 177;
                case 58 -> 246;
                case 59 -> 60;
                case 60 -> 76;
                case 61 -> 206;
                case 62 -> 243;
                case 63 -> 94;
                case 64 -> 141;
                case 65 -> 138;
                case 66 -> 66;
                case 67 -> 181;
                case 68 -> 54;
                case 69 -> 30;
                case 70 -> 176;
                case 71 -> 192;
                case 72 -> 117;
                case 73 -> 51;
                case 74 -> 105;
                case 75 -> 182;
                case 76 -> 245;
                case 77 -> 135;
                case 78 -> 179;
                case 79 -> 9;
                case 80 -> 174;
                case 81 -> 68;
                case 82 -> 227;
                case 83 -> 219;
                case 84 -> 90;
                case 85 -> 242;
                case 86 -> 88;
                case 87 -> 146;
                case 88 -> 4;
                case 89 -> 58;
                case 90 -> 50;
                case 91 -> 5;
                case 92 -> 180;
                case 93 -> 222;
                case 94 -> 171;
                case 95 -> 185;
                case 96 -> 143;
                case 97 -> 150;
                case 98 -> 202;
                case 99 -> 166;
                case 100 -> 107;
                case 101 -> 2;
                case 102 -> 75;
                case 103 -> 35;
                case 104 -> 167;
                case 105 -> 26;
                case 106 -> 248;
                case 107 -> 183;
                case 108 -> 145;
                case 109 -> 163;
                case 110 -> 149;
                case 111 -> 153;
                case 112 -> 127;
                case 113 -> 194;
                case 114 -> 244;
                case 115 -> 136;
                case 116 -> 103;
                case 117 -> 119;
                case 118 -> 0;
                case 119 -> 148;
                case 120 -> 63;
                case 121 -> 128;
                case 122 -> 228;
                case 123 -> 36;
                case 124 -> 191;
                case 125 -> 53;
                case 126 -> 61;
                case 127 -> 213;
                case 128 -> 31;
                case 129 -> 216;
                case 130 -> 29;
                case 131 -> 129;
                case 132 -> 48;
                case 133 -> 77;
                case 134 -> 254;
                case 135 -> 139;
                case 136 -> 239;
                case 137 -> 109;
                case 138 -> 253;
                case 139 -> 252;
                case 140 -> 225;
                case 141 -> 112;
                case 142 -> 69;
                case 143 -> 162;
                case 144 -> 132;
                case 145 -> 32;
                case 146 -> 40;
                case 147 -> 111;
                case 148 -> 133;
                case 149 -> 168;
                case 150 -> 89;
                case 151 -> 106;
                case 152 -> 232;
                case 153 -> 46;
                case 154 -> 74;
                case 155 -> 155;
                case 156 -> 250;
                case 157 -> 21;
                case 158 -> 223;
                case 159 -> 45;
                case 160 -> 152;
                case 161 -> 255;
                case 162 -> 164;
                case 163 -> 84;
                case 164 -> 193;
                case 165 -> 19;
                case 166 -> 70;
                case 167 -> 72;
                case 168 -> 120;
                case 169 -> 7;
                case 170 -> 224;
                case 171 -> 140;
                case 172 -> 184;
                case 173 -> 1;
                case 174 -> 195;
                case 175 -> 144;
                case 176 -> 221;
                case 177 -> 230;
                case 178 -> 11;
                case 179 -> 156;
                case 180 -> 151;
                case 181 -> 56;
                case 182 -> 217;
                case 183 -> 34;
                case 184 -> 27;
                case 185 -> 203;
                case 186 -> 8;
                case 187 -> 251;
                case 188 -> 118;
                case 189 -> 211;
                case 190 -> 210;
                case 191 -> 55;
                case 192 -> 125;
                case 193 -> 71;
                case 194 -> 3;
                case 195 -> 233;
                case 196 -> 131;
                case 197 -> 65;
                case 198 -> 186;
                case 199 -> 62;
                case 200 -> 172;
                case 201 -> 15;
                case 202 -> 20;
                case 203 -> 175;
                case 204 -> 198;
                case 205 -> 169;
                case 206 -> 187;
                case 207 -> 6;
                case 208 -> 14;
                case 209 -> 18;
                case 210 -> 212;
                case 211 -> 115;
                case 212 -> 207;
                case 213 -> 173;
                case 214 -> 218;
                case 215 -> 241;
                case 216 -> 134;
                case 217 -> 196;
                case 218 -> 92;
                case 219 -> 116;
                case 220 -> 160;
                case 221 -> 37;
                case 222 -> 43;
                case 223 -> 99;
                case 224 -> 190;
                case 225 -> 199;
                case 226 -> 161;
                case 227 -> 24;
                case 228 -> 154;
                case 229 -> 204;
                case 230 -> 220;
                case 231 -> 98;
                case 232 -> 123;
                case 233 -> 42;
                case 234 -> 83;
                case 235 -> 229;
                case 236 -> 178;
                case 237 -> 47;
                case 238 -> 28;
                case 239 -> 52;
                case 240 -> 39;
                case 241 -> 130;
                case 242 -> 78;
                case 243 -> 100;
                case 244 -> 122;
                case 245 -> 240;
                case 246 -> 13;
                case 247 -> 237;
                case 248 -> 236;
                case 249 -> 12;
                case 250 -> 97;
                case 251 -> 147;
                case 252 -> 189;
                case 253 -> 113;
                case 254 -> 96;
                default -> 197;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l = 5849062919718L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(682481490 + (char)-22239, 682612560 - (char)-1696, (int)l));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l = 96004395644650L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.S();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 == 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 == 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1008321510 + 13528, -1008321510 + -12219, (int)l));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1008321510 + 13527, -1008321510 - -1925, (int)l) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1008321510 + 13526, 1008321510 - 11425, (int)l));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00f7\u00ad\u0091/\u00f9\u00ad\u0005'\u0010\u00dc]\u0005\u0090\u00d1\u00e1\u00f9\u00f7\u00d7\u00b1\u0087\u00f4\u00f7\u0089\u008c\u008f";
                    var4_3 = "\u00f7\u00ad\u0091/\u00f9\u00ad\u0005'\u0010\u00dc]\u0005\u0090\u00d1\u00e1\u00f9\u00f7\u00d7\u00b1\u0087\u00f4\u00f7\u0089\u008c\u008f".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 52;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00cf\u00d2\u00d1\u0087\u00c65\u0087\u00ab\u00cf\u00c4\u00d7\u0015f\u0085\u0014\u0003*%\u00f2\u001en\u00b0\u008dn9\u00d7\u00f7\u0098\u0080>\u00c5\u00aa\u0092\u00cbK\u009b\u0019\u009e\u00df\u0097\u00e4#\u00f0\u0083\u00d5\u009a\"\u0084\u00e9\u0006/\u00f4y|j\u0012\"o\u0097";
                        var4_3 = "\u00cf\u00d2\u00d1\u0087\u00c65\u0087\u00ab\u00cf\u00c4\u00d7\u0015f\u0085\u0014\u0003*%\u00f2\u001en\u00b0\u008dn9\u00d7\u00f7\u0098\u0080>\u00c5\u00aa\u0092\u00cbK\u009b\u0019\u009e\u00df\u0097\u00e4#\u00f0\u0083\u00d5\u009a\"\u0084\u00e9\u0006/\u00f4y|j\u0012\"o\u0097".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 23;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 78;
                                break;
                            }
                            case 1: {
                                v15 = 74;
                                break;
                            }
                            case 2: {
                                v15 = 26;
                                break;
                            }
                            case 3: {
                                v15 = 64;
                                break;
                            }
                            case 4: {
                                v15 = 20;
                                break;
                            }
                            case 5: {
                                v15 = 90;
                                break;
                            }
                            default: {
                                v15 = 36;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCE55) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 69;
                    case 1 -> 235;
                    case 2 -> 155;
                    case 3 -> 166;
                    case 4 -> 111;
                    case 5 -> 211;
                    case 6 -> 52;
                    case 7 -> 152;
                    case 8 -> 60;
                    case 9 -> 230;
                    case 10 -> 190;
                    case 11 -> 154;
                    case 12 -> 174;
                    case 13 -> 180;
                    case 14 -> 121;
                    case 15 -> 14;
                    case 16 -> 99;
                    case 17 -> 168;
                    case 18 -> 117;
                    case 19 -> 112;
                    case 20 -> 133;
                    case 21 -> 20;
                    case 22 -> 178;
                    case 23 -> 176;
                    case 24 -> 140;
                    case 25 -> 253;
                    case 26 -> 74;
                    case 27 -> 156;
                    case 28 -> 102;
                    case 29 -> 213;
                    case 30 -> 250;
                    case 31 -> 241;
                    case 32 -> 56;
                    case 33 -> 28;
                    case 34 -> 83;
                    case 35 -> 124;
                    case 36 -> 103;
                    case 37 -> 126;
                    case 38 -> 160;
                    case 39 -> 224;
                    case 40 -> 86;
                    case 41 -> 135;
                    case 42 -> 110;
                    case 43 -> 239;
                    case 44 -> 21;
                    case 45 -> 242;
                    case 46 -> 47;
                    case 47 -> 84;
                    case 48 -> 108;
                    case 49 -> 106;
                    case 50 -> 188;
                    case 51 -> 249;
                    case 52 -> 54;
                    case 53 -> 13;
                    case 54 -> 247;
                    case 55 -> 77;
                    case 56 -> 79;
                    case 57 -> 240;
                    case 58 -> 8;
                    case 59 -> 120;
                    case 60 -> 4;
                    case 61 -> 85;
                    case 62 -> 3;
                    case 63 -> 147;
                    case 64 -> 75;
                    case 65 -> 145;
                    case 66 -> 118;
                    case 67 -> 29;
                    case 68 -> 167;
                    case 69 -> 181;
                    case 70 -> 177;
                    case 71 -> 36;
                    case 72 -> 23;
                    case 73 -> 198;
                    case 74 -> 88;
                    case 75 -> 226;
                    case 76 -> 132;
                    case 77 -> 116;
                    case 78 -> 33;
                    case 79 -> 65;
                    case 80 -> 15;
                    case 81 -> 92;
                    case 82 -> 233;
                    case 83 -> 68;
                    case 84 -> 12;
                    case 85 -> 63;
                    case 86 -> 186;
                    case 87 -> 91;
                    case 88 -> 38;
                    case 89 -> 225;
                    case 90 -> 51;
                    case 91 -> 18;
                    case 92 -> 93;
                    case 93 -> 58;
                    case 94 -> 39;
                    case 95 -> 149;
                    case 96 -> 37;
                    case 97 -> 192;
                    case 98 -> 131;
                    case 99 -> 220;
                    case 100 -> 246;
                    case 101 -> 136;
                    case 102 -> 237;
                    case 103 -> 184;
                    case 104 -> 204;
                    case 105 -> 173;
                    case 106 -> 49;
                    case 107 -> 148;
                    case 108 -> 43;
                    case 109 -> 236;
                    case 110 -> 105;
                    case 111 -> 76;
                    case 112 -> 195;
                    case 113 -> 34;
                    case 114 -> 0;
                    case 115 -> 222;
                    case 116 -> 215;
                    case 117 -> 26;
                    case 118 -> 185;
                    case 119 -> 251;
                    case 120 -> 165;
                    case 121 -> 202;
                    case 122 -> 238;
                    case 123 -> 17;
                    case 124 -> 59;
                    case 125 -> 41;
                    case 126 -> 109;
                    case 127 -> 151;
                    case 128 -> 128;
                    case 129 -> 73;
                    case 130 -> 171;
                    case 131 -> 96;
                    case 132 -> 164;
                    case 133 -> 193;
                    case 134 -> 2;
                    case 135 -> 70;
                    case 136 -> 10;
                    case 137 -> 209;
                    case 138 -> 227;
                    case 139 -> 72;
                    case 140 -> 182;
                    case 141 -> 217;
                    case 142 -> 153;
                    case 143 -> 194;
                    case 144 -> 210;
                    case 145 -> 107;
                    case 146 -> 101;
                    case 147 -> 22;
                    case 148 -> 189;
                    case 149 -> 150;
                    case 150 -> 143;
                    case 151 -> 53;
                    case 152 -> 162;
                    case 153 -> 187;
                    case 154 -> 212;
                    case 155 -> 199;
                    case 156 -> 208;
                    case 157 -> 97;
                    case 158 -> 30;
                    case 159 -> 129;
                    case 160 -> 122;
                    case 161 -> 90;
                    case 162 -> 252;
                    case 163 -> 218;
                    case 164 -> 130;
                    case 165 -> 125;
                    case 166 -> 244;
                    case 167 -> 16;
                    case 168 -> 254;
                    case 169 -> 27;
                    case 170 -> 115;
                    case 171 -> 248;
                    case 172 -> 172;
                    case 173 -> 157;
                    case 174 -> 219;
                    case 175 -> 32;
                    case 176 -> 64;
                    case 177 -> 144;
                    case 178 -> 229;
                    case 179 -> 214;
                    case 180 -> 55;
                    case 181 -> 205;
                    case 182 -> 78;
                    case 183 -> 201;
                    case 184 -> 94;
                    case 185 -> 255;
                    case 186 -> 7;
                    case 187 -> 159;
                    case 188 -> 81;
                    case 189 -> 6;
                    case 190 -> 191;
                    case 191 -> 141;
                    case 192 -> 163;
                    case 193 -> 24;
                    case 194 -> 87;
                    case 195 -> 46;
                    case 196 -> 196;
                    case 197 -> 95;
                    case 198 -> 71;
                    case 199 -> 137;
                    case 200 -> 231;
                    case 201 -> 25;
                    case 202 -> 62;
                    case 203 -> 139;
                    case 204 -> 1;
                    case 205 -> 57;
                    case 206 -> 127;
                    case 207 -> 146;
                    case 208 -> 175;
                    case 209 -> 169;
                    case 210 -> 104;
                    case 211 -> 228;
                    case 212 -> 207;
                    case 213 -> 138;
                    case 214 -> 48;
                    case 215 -> 113;
                    case 216 -> 245;
                    case 217 -> 19;
                    case 218 -> 206;
                    case 219 -> 66;
                    case 220 -> 31;
                    case 221 -> 142;
                    case 222 -> 203;
                    case 223 -> 216;
                    case 224 -> 45;
                    case 225 -> 80;
                    case 226 -> 170;
                    case 227 -> 98;
                    case 228 -> 40;
                    case 229 -> 134;
                    case 230 -> 100;
                    case 231 -> 44;
                    case 232 -> 234;
                    case 233 -> 114;
                    case 234 -> 123;
                    case 235 -> 119;
                    case 236 -> 161;
                    case 237 -> 197;
                    case 238 -> 50;
                    case 239 -> 9;
                    case 240 -> 67;
                    case 241 -> 35;
                    case 242 -> 221;
                    case 243 -> 82;
                    case 244 -> 243;
                    case 245 -> 232;
                    case 246 -> 183;
                    case 247 -> 42;
                    case 248 -> 89;
                    case 249 -> 61;
                    case 250 -> 11;
                    case 251 -> 223;
                    case 252 -> 200;
                    case 253 -> 158;
                    case 254 -> 179;
                    default -> 5;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 33845802577782L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "(cE\u0012\\0pq\t/iV\u0018\u0011rmm/";
                    var5_4 = "(cE\u0012\\0pq\t/iV\u0018\u0011rmm/".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 23;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 84;
                                    break;
                                }
                                case 1: {
                                    v11 = 17;
                                    break;
                                }
                                case 2: {
                                    v11 = 32;
                                    break;
                                }
                                case 3: {
                                    v11 = 107;
                                    break;
                                }
                                case 4: {
                                    v11 = 46;
                                    break;
                                }
                                case 5: {
                                    v11 = 75;
                                    break;
                                }
                                default: {
                                    v11 = 84;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 102870089540372L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u007fUY1\u001beP\u0004yKU+\nuT^+\u0017gH_UW\tuT^+\u0017gHS_\rrRC&\u001djRSXD,\u001cc";
                    var5_4 = "\u007fUY1\u001beP\u0004yKU+\nuT^+\u0017gH_UW\tuT^+\u0017gHS_\rrRC&\u001djRSXD,\u001cc".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 12;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "Kia\b%Te\u0006Kia\b)^";
                        var5_4 = "Kia\b%Te\u0006Kia\b)^".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 50;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 58;
                                break;
                            }
                            case 1: {
                                v15 = 55;
                                break;
                            }
                            case 2: {
                                v15 = 60;
                                break;
                            }
                            case 3: {
                                v15 = 73;
                                break;
                            }
                            case 4: {
                                v15 = 126;
                                break;
                            }
                            case 5: {
                                v15 = 8;
                                break;
                            }
                            default: {
                                v15 = 48;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 62499554603883L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-809488320 + -10971, -809488320 - -15969, (int)l));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 32147791650497L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = ":\t\f\u00f7\u00ab\u0003\u00a9\u001b\u00ca\u0005{6\u0002\u00d4\u0089\r\u00bdK\u00ec1\u00a13\u00e5\u008a\u00eb\u0098k\u00ee\u00ff\u0010c\u001a\u00f0\u00f0\u001d\u009eY\u0002\u00b5\rC\u0011\u001c\f\u00ebI\u0005\u0099i^?\u00023\u007f\u0086\u0093\u00b5\u00a4r^\u008b(\u00c1{\u00a1\u00ddK\u00ff\u00be\u00ca{\u0093A{\u0011F\u00c2\u0019\u009f\u00d4E`\u00cf\u0006\u0086\u00c8\u0006\u0098'\u00b4\u0004\"UuYO\u00be\u00cf^>7u\u0016\u0000";
                    var4_3 = ":\t\f\u00f7\u00ab\u0003\u00a9\u001b\u00ca\u0005{6\u0002\u00d4\u0089\r\u00bdK\u00ec1\u00a13\u00e5\u008a\u00eb\u0098k\u00ee\u00ff\u0010c\u001a\u00f0\u00f0\u001d\u009eY\u0002\u00b5\rC\u0011\u001c\f\u00ebI\u0005\u0099i^?\u00023\u007f\u0086\u0093\u00b5\u00a4r^\u008b(\u00c1{\u00a1\u00ddK\u00ff\u00be\u00ca{\u0093A{\u0011F\u00c2\u0019\u009f\u00d4E`\u00cf\u0006\u0086\u00c8\u0006\u0098'\u00b4\u0004\"UuYO\u00be\u00cf^>7u\u0016\u0000".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 97;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00b0*\u001fcuy\u00c1k3\u00b5\u0006\u0093!\u00c9\u00d9dL\u009c\u00cam\u00b5\u0011k#G\u00e6\u00a3\u0010\u00e8\u00ed(\u00d3!\u00df\u00cc[\u00d4\u009fRe\u009d\u00cb\n>\u00a4R/:`\u00ca\u00a1<Z\u0087\u00e0\u00eb:\u00ef\u00dcF\u00e6n\u001eT\u0092_\u00038\t\u00e4\u0085\u00d8\u00aa\u00fd\u0086\u00d63b0\u009b\u00a1\u00b1f\u00f3.\u00fb\u000bG\u0095\u00a2e\u00f9v";
                        var4_3 = "\u00b0*\u001fcuy\u00c1k3\u00b5\u0006\u0093!\u00c9\u00d9dL\u009c\u00cam\u00b5\u0011k#G\u00e6\u00a3\u0010\u00e8\u00ed(\u00d3!\u00df\u00cc[\u00d4\u009fRe\u009d\u00cb\n>\u00a4R/:`\u00ca\u00a1<Z\u0087\u00e0\u00eb:\u00ef\u00dcF\u00e6n\u001eT\u0092_\u00038\t\u00e4\u0085\u00d8\u00aa\u00fd\u0086\u00d63b0\u009b\u00a1\u00b1f\u00f3.\u00fb\u000bG\u0095\u00a2e\u00f9v".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 63;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 67;
                                break;
                            }
                            case 1: {
                                v15 = 3;
                                break;
                            }
                            case 2: {
                                v15 = 70;
                                break;
                            }
                            case 3: {
                                v15 = 30;
                                break;
                            }
                            case 4: {
                                v15 = 18;
                                break;
                            }
                            case 5: {
                                v15 = 29;
                                break;
                            }
                            default: {
                                v15 = 34;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x360E) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 7;
                    case 1 -> 83;
                    case 2 -> 196;
                    case 3 -> 115;
                    case 4 -> 220;
                    case 5 -> 110;
                    case 6 -> 23;
                    case 7 -> 25;
                    case 8 -> 225;
                    case 9 -> 12;
                    case 10 -> 207;
                    case 11 -> 235;
                    case 12 -> 242;
                    case 13 -> 243;
                    case 14 -> 63;
                    case 15 -> 59;
                    case 16 -> 227;
                    case 17 -> 221;
                    case 18 -> 50;
                    case 19 -> 70;
                    case 20 -> 149;
                    case 21 -> 219;
                    case 22 -> 163;
                    case 23 -> 157;
                    case 24 -> 81;
                    case 25 -> 82;
                    case 26 -> 93;
                    case 27 -> 209;
                    case 28 -> 43;
                    case 29 -> 238;
                    case 30 -> 185;
                    case 31 -> 173;
                    case 32 -> 172;
                    case 33 -> 182;
                    case 34 -> 169;
                    case 35 -> 94;
                    case 36 -> 254;
                    case 37 -> 37;
                    case 38 -> 135;
                    case 39 -> 61;
                    case 40 -> 46;
                    case 41 -> 99;
                    case 42 -> 120;
                    case 43 -> 17;
                    case 44 -> 74;
                    case 45 -> 18;
                    case 46 -> 19;
                    case 47 -> 22;
                    case 48 -> 29;
                    case 49 -> 75;
                    case 50 -> 54;
                    case 51 -> 150;
                    case 52 -> 80;
                    case 53 -> 56;
                    case 54 -> 187;
                    case 55 -> 168;
                    case 56 -> 181;
                    case 57 -> 79;
                    case 58 -> 199;
                    case 59 -> 137;
                    case 60 -> 11;
                    case 61 -> 162;
                    case 62 -> 122;
                    case 63 -> 161;
                    case 64 -> 138;
                    case 65 -> 66;
                    case 66 -> 52;
                    case 67 -> 211;
                    case 68 -> 233;
                    case 69 -> 191;
                    case 70 -> 123;
                    case 71 -> 15;
                    case 72 -> 192;
                    case 73 -> 1;
                    case 74 -> 160;
                    case 75 -> 34;
                    case 76 -> 213;
                    case 77 -> 228;
                    case 78 -> 73;
                    case 79 -> 119;
                    case 80 -> 198;
                    case 81 -> 111;
                    case 82 -> 4;
                    case 83 -> 53;
                    case 84 -> 147;
                    case 85 -> 10;
                    case 86 -> 193;
                    case 87 -> 247;
                    case 88 -> 176;
                    case 89 -> 134;
                    case 90 -> 230;
                    case 91 -> 51;
                    case 92 -> 84;
                    case 93 -> 44;
                    case 94 -> 86;
                    case 95 -> 165;
                    case 96 -> 154;
                    case 97 -> 47;
                    case 98 -> 253;
                    case 99 -> 105;
                    case 100 -> 212;
                    case 101 -> 131;
                    case 102 -> 69;
                    case 103 -> 108;
                    case 104 -> 142;
                    case 105 -> 57;
                    case 106 -> 68;
                    case 107 -> 133;
                    case 108 -> 194;
                    case 109 -> 246;
                    case 110 -> 32;
                    case 111 -> 113;
                    case 112 -> 71;
                    case 113 -> 202;
                    case 114 -> 216;
                    case 115 -> 252;
                    case 116 -> 117;
                    case 117 -> 104;
                    case 118 -> 170;
                    case 119 -> 139;
                    case 120 -> 48;
                    case 121 -> 231;
                    case 122 -> 30;
                    case 123 -> 33;
                    case 124 -> 114;
                    case 125 -> 223;
                    case 126 -> 234;
                    case 127 -> 248;
                    case 128 -> 45;
                    case 129 -> 200;
                    case 130 -> 35;
                    case 131 -> 16;
                    case 132 -> 250;
                    case 133 -> 9;
                    case 134 -> 97;
                    case 135 -> 26;
                    case 136 -> 106;
                    case 137 -> 102;
                    case 138 -> 90;
                    case 139 -> 76;
                    case 140 -> 177;
                    case 141 -> 178;
                    case 142 -> 251;
                    case 143 -> 217;
                    case 144 -> 72;
                    case 145 -> 124;
                    case 146 -> 8;
                    case 147 -> 244;
                    case 148 -> 103;
                    case 149 -> 125;
                    case 150 -> 146;
                    case 151 -> 91;
                    case 152 -> 189;
                    case 153 -> 240;
                    case 154 -> 24;
                    case 155 -> 92;
                    case 156 -> 174;
                    case 157 -> 190;
                    case 158 -> 95;
                    case 159 -> 210;
                    case 160 -> 183;
                    case 161 -> 88;
                    case 162 -> 195;
                    case 163 -> 143;
                    case 164 -> 224;
                    case 165 -> 159;
                    case 166 -> 31;
                    case 167 -> 237;
                    case 168 -> 188;
                    case 169 -> 77;
                    case 170 -> 148;
                    case 171 -> 98;
                    case 172 -> 175;
                    case 173 -> 20;
                    case 174 -> 6;
                    case 175 -> 40;
                    case 176 -> 64;
                    case 177 -> 85;
                    case 178 -> 208;
                    case 179 -> 109;
                    case 180 -> 38;
                    case 181 -> 116;
                    case 182 -> 164;
                    case 183 -> 2;
                    case 184 -> 14;
                    case 185 -> 184;
                    case 186 -> 153;
                    case 187 -> 239;
                    case 188 -> 226;
                    case 189 -> 144;
                    case 190 -> 218;
                    case 191 -> 179;
                    case 192 -> 151;
                    case 193 -> 130;
                    case 194 -> 58;
                    case 195 -> 215;
                    case 196 -> 203;
                    case 197 -> 0;
                    case 198 -> 158;
                    case 199 -> 171;
                    case 200 -> 241;
                    case 201 -> 186;
                    case 202 -> 141;
                    case 203 -> 42;
                    case 204 -> 126;
                    case 205 -> 156;
                    case 206 -> 197;
                    case 207 -> 55;
                    case 208 -> 201;
                    case 209 -> 255;
                    case 210 -> 49;
                    case 211 -> 62;
                    case 212 -> 121;
                    case 213 -> 128;
                    case 214 -> 132;
                    case 215 -> 13;
                    case 216 -> 41;
                    case 217 -> 89;
                    case 218 -> 96;
                    case 219 -> 152;
                    case 220 -> 107;
                    case 221 -> 87;
                    case 222 -> 204;
                    case 223 -> 155;
                    case 224 -> 129;
                    case 225 -> 39;
                    case 226 -> 236;
                    case 227 -> 140;
                    case 228 -> 27;
                    case 229 -> 166;
                    case 230 -> 136;
                    case 231 -> 60;
                    case 232 -> 180;
                    case 233 -> 127;
                    case 234 -> 3;
                    case 235 -> 65;
                    case 236 -> 222;
                    case 237 -> 214;
                    case 238 -> 167;
                    case 239 -> 67;
                    case 240 -> 249;
                    case 241 -> 21;
                    case 242 -> 28;
                    case 243 -> 245;
                    case 244 -> 232;
                    case 245 -> 145;
                    case 246 -> 229;
                    case 247 -> 206;
                    case 248 -> 5;
                    case 249 -> 78;
                    case 250 -> 205;
                    case 251 -> 101;
                    case 252 -> 112;
                    case 253 -> 118;
                    case 254 -> 100;
                    default -> 36;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 22527920550413L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(817090380 - 14508, 817090380 + 3536, (int)l));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l = 15713574407060L;
                    int n3 = SshAgentIpcService.S();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1710856710 + -((char)-2366), 1710987780 - (char)-11183, (int)l));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 == 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 19623561280938L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "2:)\r1\u0003\u00ce<\u00e0";
                var4_3 = "2:)\r1\u0003\u00ce<\u00e0".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 35;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 98;
                                break;
                            }
                            case 1: {
                                v11 = 14;
                                break;
                            }
                            case 2: {
                                v11 = 76;
                                break;
                            }
                            case 3: {
                                v11 = 41;
                                break;
                            }
                            case 4: {
                                v11 = 103;
                                break;
                            }
                            case 5: {
                                v11 = 123;
                                break;
                            }
                            default: {
                                v11 = 56;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x24AD) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 91;
                    case 1 -> 232;
                    case 2 -> 50;
                    case 3 -> 160;
                    case 4 -> 17;
                    case 5 -> 55;
                    case 6 -> 252;
                    case 7 -> 84;
                    case 8 -> 31;
                    case 9 -> 190;
                    case 10 -> 74;
                    case 11 -> 80;
                    case 12 -> 96;
                    case 13 -> 48;
                    case 14 -> 102;
                    case 15 -> 23;
                    case 16 -> 183;
                    case 17 -> 34;
                    case 18 -> 209;
                    case 19 -> 14;
                    case 20 -> 104;
                    case 21 -> 163;
                    case 22 -> 150;
                    case 23 -> 60;
                    case 24 -> 54;
                    case 25 -> 56;
                    case 26 -> 62;
                    case 27 -> 121;
                    case 28 -> 113;
                    case 29 -> 81;
                    case 30 -> 32;
                    case 31 -> 192;
                    case 32 -> 21;
                    case 33 -> 70;
                    case 34 -> 198;
                    case 35 -> 230;
                    case 36 -> 16;
                    case 37 -> 202;
                    case 38 -> 58;
                    case 39 -> 52;
                    case 40 -> 201;
                    case 41 -> 5;
                    case 42 -> 188;
                    case 43 -> 123;
                    case 44 -> 28;
                    case 45 -> 184;
                    case 46 -> 47;
                    case 47 -> 237;
                    case 48 -> 254;
                    case 49 -> 79;
                    case 50 -> 144;
                    case 51 -> 33;
                    case 52 -> 240;
                    case 53 -> 176;
                    case 54 -> 203;
                    case 55 -> 167;
                    case 56 -> 98;
                    case 57 -> 251;
                    case 58 -> 42;
                    case 59 -> 100;
                    case 60 -> 119;
                    case 61 -> 229;
                    case 62 -> 93;
                    case 63 -> 115;
                    case 64 -> 244;
                    case 65 -> 239;
                    case 66 -> 86;
                    case 67 -> 182;
                    case 68 -> 142;
                    case 69 -> 157;
                    case 70 -> 199;
                    case 71 -> 71;
                    case 72 -> 67;
                    case 73 -> 205;
                    case 74 -> 90;
                    case 75 -> 154;
                    case 76 -> 63;
                    case 77 -> 185;
                    case 78 -> 226;
                    case 79 -> 131;
                    case 80 -> 61;
                    case 81 -> 178;
                    case 82 -> 10;
                    case 83 -> 177;
                    case 84 -> 138;
                    case 85 -> 137;
                    case 86 -> 213;
                    case 87 -> 234;
                    case 88 -> 73;
                    case 89 -> 36;
                    case 90 -> 243;
                    case 91 -> 108;
                    case 92 -> 194;
                    case 93 -> 159;
                    case 94 -> 224;
                    case 95 -> 200;
                    case 96 -> 46;
                    case 97 -> 220;
                    case 98 -> 132;
                    case 99 -> 134;
                    case 100 -> 120;
                    case 101 -> 238;
                    case 102 -> 248;
                    case 103 -> 173;
                    case 104 -> 41;
                    case 105 -> 140;
                    case 106 -> 186;
                    case 107 -> 29;
                    case 108 -> 45;
                    case 109 -> 99;
                    case 110 -> 135;
                    case 111 -> 7;
                    case 112 -> 72;
                    case 113 -> 35;
                    case 114 -> 195;
                    case 115 -> 255;
                    case 116 -> 158;
                    case 117 -> 217;
                    case 118 -> 249;
                    case 119 -> 30;
                    case 120 -> 4;
                    case 121 -> 242;
                    case 122 -> 169;
                    case 123 -> 250;
                    case 124 -> 97;
                    case 125 -> 233;
                    case 126 -> 15;
                    case 127 -> 66;
                    case 128 -> 125;
                    case 129 -> 44;
                    case 130 -> 117;
                    case 131 -> 57;
                    case 132 -> 83;
                    case 133 -> 207;
                    case 134 -> 2;
                    case 135 -> 53;
                    case 136 -> 197;
                    case 137 -> 215;
                    case 138 -> 95;
                    case 139 -> 8;
                    case 140 -> 179;
                    case 141 -> 114;
                    case 142 -> 51;
                    case 143 -> 43;
                    case 144 -> 9;
                    case 145 -> 11;
                    case 146 -> 162;
                    case 147 -> 38;
                    case 148 -> 39;
                    case 149 -> 85;
                    case 150 -> 122;
                    case 151 -> 25;
                    case 152 -> 126;
                    case 153 -> 166;
                    case 154 -> 171;
                    case 155 -> 187;
                    case 156 -> 165;
                    case 157 -> 105;
                    case 158 -> 223;
                    case 159 -> 155;
                    case 160 -> 18;
                    case 161 -> 112;
                    case 162 -> 211;
                    case 163 -> 210;
                    case 164 -> 65;
                    case 165 -> 141;
                    case 166 -> 19;
                    case 167 -> 128;
                    case 168 -> 245;
                    case 169 -> 13;
                    case 170 -> 92;
                    case 171 -> 3;
                    case 172 -> 110;
                    case 173 -> 206;
                    case 174 -> 228;
                    case 175 -> 241;
                    case 176 -> 216;
                    case 177 -> 191;
                    case 178 -> 82;
                    case 179 -> 247;
                    case 180 -> 103;
                    case 181 -> 130;
                    case 182 -> 180;
                    case 183 -> 236;
                    case 184 -> 89;
                    case 185 -> 218;
                    case 186 -> 37;
                    case 187 -> 225;
                    case 188 -> 87;
                    case 189 -> 151;
                    case 190 -> 101;
                    case 191 -> 27;
                    case 192 -> 129;
                    case 193 -> 214;
                    case 194 -> 20;
                    case 195 -> 227;
                    case 196 -> 88;
                    case 197 -> 196;
                    case 198 -> 76;
                    case 199 -> 212;
                    case 200 -> 24;
                    case 201 -> 59;
                    case 202 -> 118;
                    case 203 -> 143;
                    case 204 -> 1;
                    case 205 -> 161;
                    case 206 -> 136;
                    case 207 -> 149;
                    case 208 -> 133;
                    case 209 -> 181;
                    case 210 -> 111;
                    case 211 -> 6;
                    case 212 -> 175;
                    case 213 -> 69;
                    case 214 -> 139;
                    case 215 -> 145;
                    case 216 -> 49;
                    case 217 -> 231;
                    case 218 -> 148;
                    case 219 -> 40;
                    case 220 -> 146;
                    case 221 -> 107;
                    case 222 -> 246;
                    case 223 -> 94;
                    case 224 -> 12;
                    case 225 -> 22;
                    case 226 -> 68;
                    case 227 -> 109;
                    case 228 -> 26;
                    case 229 -> 208;
                    case 230 -> 75;
                    case 231 -> 124;
                    case 232 -> 174;
                    case 233 -> 0;
                    case 234 -> 221;
                    case 235 -> 219;
                    case 236 -> 168;
                    case 237 -> 106;
                    case 238 -> 235;
                    case 239 -> 147;
                    case 240 -> 170;
                    case 241 -> 204;
                    case 242 -> 156;
                    case 243 -> 153;
                    case 244 -> 127;
                    case 245 -> 164;
                    case 246 -> 116;
                    case 247 -> 78;
                    case 248 -> 64;
                    case 249 -> 193;
                    case 250 -> 222;
                    case 251 -> 253;
                    case 252 -> 152;
                    case 253 -> 77;
                    case 254 -> 172;
                    default -> 189;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

