/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.StubSharedIndexExtension;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public interface SharedIndexExtension<K, V> {
    @NotNull
    public FileBasedIndexExtension<K, V> getFileBasedIndexExtension();

    default public int getVersion() {
        return 0;
    }

    default public void openResources(@NotNull Path indexRoot, boolean readOnly, @NotNull SharedIndexInfrastructureVersion chunkVersion) {
        if (indexRoot == null) {
            SharedIndexExtension.$$$reportNull$$$0(0);
        }
        if (chunkVersion == null) {
            SharedIndexExtension.$$$reportNull$$$0(1);
        }
    }

    default public void closeResources() {
    }

    default public boolean acceptsInputFile(@NotNull IndexedFile file) {
        if (file == null) {
            SharedIndexExtension.$$$reportNull$$$0(2);
        }
        return true;
    }

    @NotNull
    public static <K, V> SharedIndexExtension<K, V> findExtensionAndOpen(@NotNull FileBasedIndexExtension<K, V> originalExtension, @NotNull Path indexRoot, boolean readOnly, @NotNull SharedIndexInfrastructureVersion chunkVersion) {
        if (originalExtension == null) {
            SharedIndexExtension.$$$reportNull$$$0(3);
        }
        if (indexRoot == null) {
            SharedIndexExtension.$$$reportNull$$$0(4);
        }
        if (chunkVersion == null) {
            SharedIndexExtension.$$$reportNull$$$0(5);
        }
        SharedIndexExtension<K, V> extension = SharedIndexExtension.findExtension(originalExtension);
        extension.openResources(indexRoot, readOnly, chunkVersion);
        SharedIndexExtension<K, V> sharedIndexExtension = extension;
        if (sharedIndexExtension == null) {
            SharedIndexExtension.$$$reportNull$$$0(6);
        }
        return sharedIndexExtension;
    }

    @NotNull
    public static <K, V> SharedIndexExtension<K, V> findExtension(@NotNull FileBasedIndexExtension<K, V> originalExtension) {
        if (originalExtension == null) {
            SharedIndexExtension.$$$reportNull$$$0(7);
        }
        return originalExtension.getName().equals(StubUpdatingIndex.INDEX_ID) ? new StubSharedIndexExtension() : new SharedIndexExtensionImpl<K, V>(originalExtension);
    }

    @NotNull
    public static Path getSharedIndexDir(@NotNull Path chunkRoot, @NotNull ID<?, ?> id) {
        if (chunkRoot == null) {
            SharedIndexExtension.$$$reportNull$$$0(8);
        }
        if (id == null) {
            SharedIndexExtension.$$$reportNull$$$0(9);
        }
        Path path = chunkRoot.resolve(id.getName());
        if (path == null) {
            SharedIndexExtension.$$$reportNull$$$0(10);
        }
        return path;
    }

    @NotNull
    public static String getFileBasedIndexVersion(@NotNull FileBasedIndexExtension<?, ?> fileBasedIndexExtension) {
        if (fileBasedIndexExtension == null) {
            SharedIndexExtension.$$$reportNull$$$0(11);
        }
        String string = fileBasedIndexExtension.getVersion() + ":" + SharedIndexExtension.findExtension(fileBasedIndexExtension).getVersion();
        if (string == null) {
            SharedIndexExtension.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexRoot";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalExtension";
                break;
            }
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/SharedIndexExtension";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndexExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/SharedIndexExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtensionAndOpen";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedIndexDir";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openResources";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInputFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionAndOpen";
                break;
            }
            case 6: 
            case 10: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSharedIndexDir";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileBasedIndexVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 12 -> new IllegalStateException(string);
        };
    }

    public static class SharedIndexExtensionImpl<K, V>
    implements SharedIndexExtension<K, V> {
        private final FileBasedIndexExtension<K, V> myOriginalExtension;

        SharedIndexExtensionImpl(@NotNull FileBasedIndexExtension<K, V> originalExtension) {
            if (originalExtension == null) {
                SharedIndexExtensionImpl.$$$reportNull$$$0(0);
            }
            this.myOriginalExtension = originalExtension;
        }

        @Override
        @NotNull
        public FileBasedIndexExtension<K, V> getFileBasedIndexExtension() {
            FileBasedIndexExtension<K, V> fileBasedIndexExtension = this.myOriginalExtension;
            if (fileBasedIndexExtension == null) {
                SharedIndexExtensionImpl.$$$reportNull$$$0(1);
            }
            return fileBasedIndexExtension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalExtension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/indexing/shared/platform/impl/SharedIndexExtension$SharedIndexExtensionImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/indexing/shared/platform/impl/SharedIndexExtension$SharedIndexExtensionImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileBasedIndexExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

