/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyPandasSeriesToListInspectionKt;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.types.PyLiteralStringType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyPandasSeriesToListInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "DSPandasSeriesToListQuickFix", "intellij.python.community.impl"})
public final class PyPandasSeriesToListInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/inspections/PyPandasSeriesToListInspection$DSPandasSeriesToListQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.python.community.impl"})
    private static final class DSPandasSeriesToListQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.pandas.series.values.replace.with.tolist", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            PyCallExpression pyCallExpression = element instanceof PyCallExpression ? (PyCallExpression)element : null;
            if (pyCallExpression == null) {
                return;
            }
            PyCallExpression functionCall = pyCallExpression;
            PyExpression[] pyExpressionArray = functionCall.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
            Object object = ArraysKt.singleOrNull((Object[])pyExpressionArray);
            PyQualifiedExpression pyQualifiedExpression = object instanceof PyQualifiedExpression ? (PyQualifiedExpression)object : null;
            if (pyQualifiedExpression == null) {
                return;
            }
            PyQualifiedExpression argument = pyQualifiedExpression;
            PyExpression pyExpression = argument.getQualifier();
            if (pyExpression == null) {
                return;
            }
            PyExpression argumentQualifier = pyExpression;
            String toListCallString = argumentQualifier.getText() + ".to_list()";
            Object object2 = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.forElement((PsiElement)((PsiElement)functionCall)), PyExpressionStatement.class, toListCallString);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"createFromText(...)");
            PyExpressionStatement toListCallStatement = (PyExpressionStatement)object2;
            functionCall.replace((PsiElement)toListCallStatement.getExpression());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/inspections/PyPandasSeriesToListInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyCallExpression", "", "node", "Lcom/jetbrains/python/psi/PyCallExpression;", "hasSeriesType", "", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "isQualifiedDataframeCall", "intellij.python.community.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)node))) {
                return;
            }
            PyExpression pyExpression = node.getCallee();
            if (!Intrinsics.areEqual((Object)(pyExpression != null ? pyExpression.getText() : null), (Object)"list") || node.getArguments().length != 1) {
                return;
            }
            PyExpression[] pyExpressionArray = node.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
            PyExpression argument = (PyExpression)ArraysKt.single((Object[])pyExpressionArray);
            if (!(argument instanceof PyQualifiedExpression)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)((PyQualifiedExpression)argument).getReferencedName(), (Object)"values")) {
                return;
            }
            PyExpression pyExpression2 = ((PyQualifiedExpression)argument).getQualifier();
            if (pyExpression2 == null) {
                return;
            }
            PyExpression qualifier = pyExpression2;
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (this.hasSeriesType(qualifier, typeEvalContext)) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new DSPandasSeriesToListQuickFix()};
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.pandas.series.values.replace.with.tolist", new Object[0]), localQuickFixArray);
            }
        }

        private final boolean hasSeriesType(PyExpression expression, TypeEvalContext context) {
            if (expression instanceof PySubscriptionExpression) {
                PyType type2 = PyPandasSeriesToListInspectionKt.access$getType(context, ((PySubscriptionExpression)expression).getIndexExpression());
                return PyPandasSeriesToListInspectionKt.access$isPyClassWithName(type2, "str") || type2 instanceof PyLiteralStringType;
            }
            PyType expressionType = context.getType(expression);
            if (PyPandasSeriesToListInspectionKt.access$isPyClassWithName(expressionType, "Series")) {
                return true;
            }
            if (expressionType != null) {
                return false;
            }
            return this.isQualifiedDataframeCall(expression, context);
        }

        private final boolean isQualifiedDataframeCall(PyExpression expression, TypeEvalContext context) {
            if (!(expression instanceof PyQualifiedExpression)) {
                return false;
            }
            return PyPandasSeriesToListInspectionKt.access$isPyClassWithName(PyPandasSeriesToListInspectionKt.access$getType(context, ((PyQualifiedExpression)expression).getQualifier()), "DataFrame");
        }
    }
}

