/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.diagnostic.PluginException;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewItemState;
import com.intellij.execution.services.ServiceViewLazyContributor;
import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.execution.serviceView.ServiceViewDragHelper;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullizer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

final class ServiceModel
implements Disposable,
InvokerSupplier {
    private static final Logger LOG = Logger.getInstance(ServiceModel.class);
    static final TreeTraversal NOT_LOADED_LAST_BFS = new TreeTraversal("NOT_LOADED_LAST_BFS"){

        @NotNull
        public <T> TreeTraversal.It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                1.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                1.$$$reportNull$$$0(1);
            }
            return new NotLoadedLastBfsIt<T>(roots, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/platform/execution/serviceView/ServiceModel$1";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final TreeTraversal ONLY_LOADED_BFS = new TreeTraversal("ONLY_LOADED_BFS"){

        @NotNull
        public <T> TreeTraversal.It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                2.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                2.$$$reportNull$$$0(1);
            }
            return new OnlyLoadedBfsIt<T>(roots, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/platform/execution/serviceView/ServiceModel$2";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final NotNullizer ourNotNullizer = new NotNullizer("ServiceViewTreeTraversal.NotNull");
    private final Project myProject;
    private final Invoker myInvoker;
    private final List<ServiceViewItem> myRoots;
    private final List<ServiceModelEventListener> myListeners;

    ServiceModel(@NotNull Project project) {
        if (project == null) {
            ServiceModel.$$$reportNull$$$0(0);
        }
        this.myInvoker = Invoker.forBackgroundThreadWithoutReadAction((Disposable)this);
        this.myRoots = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    public void dispose() {
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            ServiceModel.$$$reportNull$$$0(1);
        }
        return invoker;
    }

    void addEventListener(@NotNull ServiceModelEventListener listener) {
        if (listener == null) {
            ServiceModel.$$$reportNull$$$0(2);
        }
        this.myListeners.add(listener);
    }

    void removeEventListener(@NotNull ServiceModelEventListener listener) {
        if (listener == null) {
            ServiceModel.$$$reportNull$$$0(3);
        }
        this.myListeners.remove(listener);
    }

    @NotNull
    List<? extends ServiceViewItem> getRoots() {
        List<ServiceViewItem> list = this.myRoots;
        if (list == null) {
            ServiceModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    private JBIterable<ServiceViewItem> doFindItems(Condition<? super ServiceViewItem> visitChildrenCondition, Condition<? super ServiceViewItem> condition, boolean safe) {
        return ((JBTreeTraverser)JBTreeTraverser.from(node -> visitChildrenCondition.value(node) ? new ArrayList<ServiceViewItem>(node.getChildren()) : null).withRoots(this.myRoots)).traverse(safe ? ONLY_LOADED_BFS : NOT_LOADED_LAST_BFS).filter(condition);
    }

    private JBIterable<ServiceViewItem> findItems(Object service, Class<?> contributorClass, boolean safe) {
        Object value = service instanceof ServiceViewProvidingContributor ? ((ServiceViewProvidingContributor)service).asService() : service;
        return this.doFindItems((Condition<? super ServiceViewItem>)((Condition)node -> contributorClass.isInstance(node.getRootContributor())), (Condition<? super ServiceViewItem>)((Condition)node -> node.getValue().equals(value)), safe);
    }

    @Nullable
    ServiceViewItem findItem(Condition<? super ServiceViewItem> visitChildrenCondition, Condition<? super ServiceViewItem> condition) {
        return (ServiceViewItem)this.doFindItems(visitChildrenCondition, condition, false).first();
    }

    @Nullable
    ServiceViewItem findItem(Object service, Class<?> contributorClass) {
        return (ServiceViewItem)this.findItems(service, contributorClass, false).first();
    }

    @Nullable
    ServiceViewItem findItemSafe(Object service, Class<?> contributorClass) {
        return (ServiceViewItem)this.findItems(service, contributorClass, true).first();
    }

    @Nullable
    ServiceViewItem findItemById(List<String> ids, ServiceViewContributor<?> contributor) {
        if (ids.isEmpty()) {
            return null;
        }
        List roots = ContainerUtil.filter(this.getRoots(), item -> contributor.equals(item.getContributor()));
        if (roots.isEmpty()) {
            return null;
        }
        return ServiceModel.findItemById(new LinkedList<String>(ids), roots);
    }

    private static ServiceViewItem findItemById(Deque<String> path, List<? extends ServiceViewItem> roots) {
        String id = path.removeFirst();
        for (ServiceViewItem serviceViewItem : roots) {
            if (!id.equals(serviceViewItem.getViewDescriptor().getId())) continue;
            return path.isEmpty() ? serviceViewItem : ServiceModel.findItemById(path, serviceViewItem.getChildren());
        }
        return null;
    }

    @NotNull
    CancellablePromise<?> handle(@NotNull ServiceEventListener.ServiceEvent e) {
        if (e == null) {
            ServiceModel.$$$reportNull$$$0(5);
        }
        Runnable handler = () -> {
            LOG.debug("Handle event: " + e);
            switch (e.type) {
                case SERVICE_ADDED: {
                    this.addService(e);
                    break;
                }
                case SERVICE_REMOVED: {
                    this.removeService(e);
                    break;
                }
                case SERVICE_CHANGED: {
                    this.serviceChanged(e);
                    break;
                }
                case SERVICE_CHILDREN_CHANGED: {
                    this.serviceChildrenChanged(e);
                    break;
                }
                case SERVICE_STRUCTURE_CHANGED: {
                    this.serviceStructureChanged(e);
                    break;
                }
                case SERVICE_GROUP_CHANGED: {
                    this.serviceGroupChanged(e);
                    break;
                }
                case GROUP_CHANGED: {
                    this.groupChanged(e);
                    break;
                }
                default: {
                    this.reset(e.contributorClass);
                }
            }
            this.notifyListeners(e);
            LOG.debug("Event handled: " + e);
        };
        if (e.type != ServiceEventListener.EventType.UNLOAD_SYNC_RESET) {
            CancellablePromise cancellablePromise = this.getInvoker().invokeLater(handler);
            if (cancellablePromise == null) {
                ServiceModel.$$$reportNull$$$0(6);
            }
            return cancellablePromise;
        }
        handler.run();
        CancellablePromise cancellablePromise = Promises.resolvedCancellablePromise(null);
        if (cancellablePromise == null) {
            ServiceModel.$$$reportNull$$$0(7);
        }
        return cancellablePromise;
    }

    void notifyListeners(ServiceEventListener.ServiceEvent e) {
        for (ServiceModelEventListener listener : this.myListeners) {
            listener.eventProcessed(e);
        }
    }

    private void reset(Class<?> contributorClass) {
        int index = -1;
        if (this.myRoots.isEmpty()) {
            index = 0;
        } else {
            ServiceViewItem contributorNode = null;
            for (int i = 0; i < this.myRoots.size(); ++i) {
                ServiceViewItem child = this.myRoots.get(i);
                if (!contributorClass.isInstance(child.getContributor())) continue;
                contributorNode = child;
                index = i;
                break;
            }
            if (contributorNode != null) {
                this.myRoots.remove(contributorNode);
            } else {
                index = this.getContributorNodeIndex(contributorClass);
            }
        }
        ContributorNode newRoot = null;
        for (ServiceViewContributor contributor : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
            if (!contributorClass.isInstance(contributor)) continue;
            newRoot = new ContributorNode(this.myProject, contributor);
            newRoot.loadChildren();
            if (!newRoot.getChildren().isEmpty()) break;
            newRoot = null;
            break;
        }
        if (newRoot != null) {
            this.myRoots.add(index, newRoot);
        }
    }

    private int getContributorNodeIndex(Class<?> contributorClass) {
        ServiceViewContributor contributor;
        int index = -1;
        List contributors = ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList();
        List existingContributors = ContainerUtil.map(this.myRoots, ServiceViewItem::getContributor);
        for (int i = contributors.size() - 1; i >= 0 && !contributorClass.isInstance(contributor = (ServiceViewContributor)contributors.get(i)) && (index = existingContributors.indexOf(contributor)) != 0; --i) {
        }
        if (index < 0) {
            index = this.myRoots.size();
        }
        return index;
    }

    private void addService(ServiceEventListener.ServiceEvent e) {
        if (e.parent != null) {
            ServiceViewContributor<?> parentContributor;
            ServiceViewItem parent = this.findItemSafe(e.parent, e.contributorClass);
            ServiceViewContributor<?> serviceViewContributor = parentContributor = parent instanceof ServiceNode ? ((ServiceNode)parent).getProvidingContributor() : null;
            if (parentContributor == null) {
                LOG.debug("Parent not found; event: " + e);
                return;
            }
            if (!ServiceModel.hasChild(parent, e.target)) {
                ServiceModel.addService(e.target, parent.getChildren(), this.myProject, parent, parentContributor);
            }
            return;
        }
        ServiceViewItem contributorNode = null;
        for (ServiceViewItem child : this.myRoots) {
            if (!e.contributorClass.isInstance(child.getContributor())) continue;
            contributorNode = child;
            break;
        }
        if (contributorNode == null) {
            int index = this.getContributorNodeIndex(e.contributorClass);
            for (ServiceViewContributor contributor : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
                if (!e.contributorClass.isInstance(contributor)) continue;
                contributorNode = new ContributorNode(this.myProject, contributor);
                this.myRoots.add(index, contributorNode);
                break;
            }
            if (contributorNode == null) {
                return;
            }
        }
        if (!ServiceModel.hasChild(contributorNode, e.target)) {
            ServiceModel.addService(e.target, contributorNode.getChildren(), this.myProject, contributorNode, contributorNode.getContributor());
        }
    }

    private void removeService(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItemSafe(e.target, e.contributorClass);
        if (item == null) {
            return;
        }
        ServiceViewItem parent = item.getParent();
        while (parent instanceof ServiceGroupNode) {
            item.markRemoved();
            parent.getChildren().remove(item);
            if (!parent.getChildren().isEmpty()) {
                return;
            }
            item = parent;
            parent = parent.getParent();
        }
        if (parent instanceof ContributorNode) {
            item.markRemoved();
            parent.getChildren().remove(item);
            if (!parent.getChildren().isEmpty()) {
                return;
            }
            item = parent;
            parent = parent.getParent();
        }
        item.markRemoved();
        if (parent == null) {
            this.myRoots.remove(item);
        } else {
            parent.getChildren().remove(item);
        }
    }

    private void serviceChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItemSafe(e.target, e.contributorClass);
        if (item instanceof ServiceNode) {
            ServiceModel.updateServiceViewDescriptor((ServiceNode)item, e.target);
        }
    }

    private static void updateServiceViewDescriptor(ServiceNode node, Object target) {
        ServiceViewContributor<?> providingContributor = node.getProvidingContributor();
        if (providingContributor != null && !providingContributor.equals(target)) {
            node.setViewDescriptor(providingContributor.getViewDescriptor(node.myProject));
            return;
        }
        ServiceViewDescriptor viewDescriptor = node.getContributor().getServiceDescriptor(node.myProject, target);
        node.setViewDescriptor(viewDescriptor);
    }

    private void serviceChildrenChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItemSafe(e.target, e.contributorClass);
        if (item instanceof ServiceNode) {
            ServiceNode node = (ServiceNode)item;
            node.reloadChildren();
        }
    }

    private void serviceStructureChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItemSafe(e.target, e.contributorClass);
        if (item instanceof ServiceNode) {
            ServiceNode node = (ServiceNode)item;
            ServiceModel.updateServiceViewDescriptor(node, e.target);
            node.reloadChildren();
        }
    }

    private void serviceGroupChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItemSafe(e.target, e.contributorClass);
        if (!(item instanceof ServiceNode)) {
            return;
        }
        ServiceViewItem parent = item.getParent();
        if (parent == null) {
            return;
        }
        ServiceGroupNode group = null;
        if (parent instanceof ServiceGroupNode) {
            group = (ServiceGroupNode)parent;
            parent = group.getParent();
            while (parent instanceof ServiceGroupNode) {
                parent = parent.getParent();
            }
            if (parent == null) {
                return;
            }
        }
        if (group != null) {
            group.getChildren().remove(item);
        } else {
            parent.getChildren().remove(item);
        }
        ServiceViewContributor<?> value = e.target;
        ServiceViewContributor<?> providingContributor = ((ServiceNode)item).getProvidingContributor();
        if (providingContributor != null && !providingContributor.equals(e.target)) {
            value = providingContributor;
        }
        ServiceNode serviceNode = ServiceModel.addService(value, parent.getChildren(), this.myProject, parent, item.getContributor());
        serviceNode.moveChildren((ServiceNode)item);
        while (group != null && group.getChildren().isEmpty()) {
            ServiceViewItem groupParent = group.getParent();
            if (groupParent == null) {
                return;
            }
            groupParent.getChildren().remove(group);
            group = groupParent instanceof ServiceGroupNode ? (ServiceGroupNode)groupParent : null;
        }
    }

    private void groupChanged(ServiceEventListener.ServiceEvent e) {
        JBIterable groups = this.findItems(e.target, e.contributorClass, true).filter(ServiceGroupNode.class);
        ServiceGroupNode first = (ServiceGroupNode)groups.first();
        if (first == null) {
            return;
        }
        ServiceViewDescriptor viewDescriptor = ((ServiceViewGroupingContributor)first.getContributor()).getGroupDescriptor(e.target);
        for (ServiceViewItem group : groups) {
            group.setViewDescriptor(viewDescriptor);
            ServiceViewItem parent = group.getParent();
            if (parent == null) continue;
            List<ServiceViewItem> children = parent.getChildren();
            children.remove(group);
            ServiceModel.addGroupOrdered(children, (ServiceGroupNode)group);
        }
    }

    private static boolean hasChild(ServiceViewItem item, Object service) {
        for (ServiceViewItem child : item.getChildren()) {
            if (!child.getValue().equals(service)) continue;
            return true;
        }
        return false;
    }

    private static <T> List<ServiceViewItem> getContributorChildren(Project project, ServiceViewItem parent, ServiceViewContributor<T> contributor) {
        ArrayList<ServiceViewItem> children = new ArrayList<ServiceViewItem>();
        try {
            for (Object service : contributor.getServices(project)) {
                ServiceModel.addService(service, children, project, parent, contributor);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            PluginException.logPluginError((Logger)LOG, (String)("Failed to retrieve service view contributor children " + contributor.getClass()), (Throwable)e, contributor.getClass());
        }
        return children;
    }

    private static <T> ServiceNode addService(Object service, List<ServiceViewItem> children, Project project, ServiceViewItem parent, ServiceViewContributor<T> contributor) {
        ServiceNode serviceNode;
        Object value;
        Object typedService = service;
        Object object = value = service instanceof ServiceViewProvidingContributor ? ((ServiceViewProvidingContributor)service).asService() : service;
        if (contributor instanceof ServiceViewGroupingContributor && (serviceNode = ServiceModel.addGroupNode((ServiceViewGroupingContributor)contributor, typedService, value, parent, project, children)) != null) {
            return serviceNode;
        }
        serviceNode = new ServiceNode(value, parent, contributor, contributor.getServiceDescriptor(project, typedService), project, service instanceof ServiceViewContributor ? (ServiceViewContributor)service : null);
        ServiceModel.addServiceOrdered(children, serviceNode, contributor);
        return serviceNode;
    }

    private static <T, G> ServiceNode addGroupNode(ServiceViewGroupingContributor<T, G> groupingContributor, T service, Object value, ServiceViewItem parent, Project project, List<ServiceViewItem> children) {
        List groups = groupingContributor.getGroups(service);
        if (groups.isEmpty()) {
            return null;
        }
        List<ServiceViewItem> currentChildren = children;
        ServiceViewItem groupParent = parent;
        for (Object group : groups) {
            boolean found = false;
            for (ServiceViewItem child : currentChildren) {
                if (!child.getValue().equals(group)) continue;
                groupParent = child;
                currentChildren = groupParent.getChildren();
                found = true;
                break;
            }
            if (found) continue;
            ServiceGroupNode groupNode = new ServiceGroupNode(group, groupParent, (ServiceViewContributor<?>)groupingContributor, groupingContributor.getGroupDescriptor(group));
            ServiceModel.addGroupOrdered(currentChildren, groupNode);
            groupParent = groupNode;
            currentChildren = groupParent.getChildren();
        }
        ServiceNode serviceNode = new ServiceNode(value, groupParent, (ServiceViewContributor<?>)groupingContributor, groupingContributor.getServiceDescriptor(project, service), project, (ServiceViewContributor<?>)(service instanceof ServiceViewContributor ? (ServiceViewContributor)service : null));
        ServiceModel.addServiceOrdered(currentChildren, serviceNode, groupingContributor);
        return serviceNode;
    }

    private static void addServiceOrdered(List<ServiceViewItem> children, ServiceNode child, ServiceViewContributor<?> contributor) {
        if (!children.isEmpty() && contributor instanceof Comparator) {
            Comparator comparator = (Comparator)contributor;
            for (int i = 0; i < children.size(); ++i) {
                ServiceViewItem anchor = children.get(i);
                if (!(anchor instanceof ServiceNode) || comparator.compare(child.getService(), ((ServiceNode)anchor).getService()) >= 0) continue;
                children.add(i, child);
                return;
            }
        }
        children.add(child);
    }

    private static void addGroupOrdered(List<ServiceViewItem> children, ServiceGroupNode child) {
        if (!children.isEmpty()) {
            for (int i = 0; i < children.size(); ++i) {
                ServiceViewItem anchor = children.get(i);
                if (anchor instanceof ServiceNode) {
                    children.add(i, child);
                    return;
                }
                if (!(anchor instanceof ServiceGroupNode) || ServiceModel.compareGroups(child, (ServiceGroupNode)anchor) >= 0) continue;
                children.add(i, child);
                return;
            }
        }
        children.add(child);
    }

    private static int compareGroups(ServiceGroupNode group1, ServiceGroupNode group2) {
        ServiceViewDescriptor groupDescriptor1 = group1.getViewDescriptor();
        WeighedItem weighedItem1 = (WeighedItem)ObjectUtils.tryCast((Object)groupDescriptor1, WeighedItem.class);
        ServiceViewDescriptor groupDescriptor2 = group2.getViewDescriptor();
        WeighedItem weighedItem2 = (WeighedItem)ObjectUtils.tryCast((Object)groupDescriptor2, WeighedItem.class);
        if (weighedItem1 != null) {
            if (weighedItem2 == null) {
                return -1;
            }
            int diff = weighedItem1.getWeight() - weighedItem2.getWeight();
            if (diff != 0) {
                return diff;
            }
        } else if (weighedItem2 != null) {
            return 1;
        }
        String name1 = ServiceViewDragHelper.getDisplayName(groupDescriptor1.getPresentation());
        String name2 = ServiceViewDragHelper.getDisplayName(groupDescriptor2.getPresentation());
        return StringUtil.naturalCompare((String)name1, (String)name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "handle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addEventListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeEventListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7 -> new IllegalStateException(string);
        };
    }

    static abstract class ServiceViewItem
    implements ColoredItem {
        private final Object myValue;
        private volatile ServiceViewItem myParent;
        private final ServiceViewContributor<?> myContributor;
        private ServiceViewDescriptor myViewDescriptor;
        private final List<ServiceViewItem> myChildren;
        private volatile boolean myPresentationUpdated;
        private volatile boolean myRemoved;
        private PresentationData myPresentation;

        protected ServiceViewItem(@NotNull Object value, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor<?> contributor, @NotNull ServiceViewDescriptor viewDescriptor) {
            if (value == null) {
                ServiceViewItem.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ServiceViewItem.$$$reportNull$$$0(1);
            }
            if (viewDescriptor == null) {
                ServiceViewItem.$$$reportNull$$$0(2);
            }
            this.myChildren = new CopyOnWriteArrayList<ServiceViewItem>();
            this.myValue = value;
            this.myParent = parent;
            this.myContributor = contributor;
            this.myViewDescriptor = viewDescriptor;
        }

        @NotNull
        Object getValue() {
            Object object = this.myValue;
            if (object == null) {
                ServiceViewItem.$$$reportNull$$$0(3);
            }
            return object;
        }

        @NotNull
        ServiceViewContributor<?> getContributor() {
            ServiceViewContributor<?> serviceViewContributor = this.myContributor;
            if (serviceViewContributor == null) {
                ServiceViewItem.$$$reportNull$$$0(4);
            }
            return serviceViewContributor;
        }

        @NotNull
        ServiceViewContributor<?> getRootContributor() {
            ServiceViewContributor<?> serviceViewContributor = this.myParent == null ? this.myContributor : this.myParent.getRootContributor();
            if (serviceViewContributor == null) {
                ServiceViewItem.$$$reportNull$$$0(5);
            }
            return serviceViewContributor;
        }

        @NotNull
        ServiceViewDescriptor getViewDescriptor() {
            if (!this.myPresentationUpdated) {
                this.myPresentationUpdated = true;
                if (this.myValue instanceof NodeDescriptor) {
                    ((NodeDescriptor)this.myValue).update();
                }
            }
            ServiceViewDescriptor serviceViewDescriptor = this.myViewDescriptor;
            if (serviceViewDescriptor == null) {
                ServiceViewItem.$$$reportNull$$$0(6);
            }
            return serviceViewDescriptor;
        }

        private void setViewDescriptor(@NotNull ServiceViewDescriptor viewDescriptor) {
            if (viewDescriptor == null) {
                ServiceViewItem.$$$reportNull$$$0(7);
            }
            AppUIUtil.invokeOnEdt(() -> {
                this.myViewDescriptor = viewDescriptor;
                this.myPresentationUpdated = false;
            });
        }

        @Nullable
        ServiceViewItem getParent() {
            return this.myParent;
        }

        private void setParent(@Nullable ServiceViewItem parent) {
            this.myParent = parent;
        }

        @NotNull
        List<ServiceViewItem> getChildren() {
            List<ServiceViewItem> list = this.myChildren;
            if (list == null) {
                ServiceViewItem.$$$reportNull$$$0(8);
            }
            return list;
        }

        @Nullable
        public Color getColor() {
            ServiceViewDescriptor descriptor = this.getViewDescriptor();
            return descriptor instanceof ColoredItem ? ((ColoredItem)descriptor).getColor() : null;
        }

        private void markRemoved() {
            this.myRemoved = true;
        }

        boolean isRemoved() {
            return this.myRemoved || this.myParent != null && this.myParent.isRemoved();
        }

        ItemPresentation getItemPresentation(@Nullable ServiceViewOptions viewOptions, @NotNull ServiceViewItemState state) {
            if (state == null) {
                ServiceViewItem.$$$reportNull$$$0(9);
            }
            if (this.isRemoved()) {
                return this.myPresentation;
            }
            ItemPresentation presentation = viewOptions == null ? this.getViewDescriptor().getPresentation() : this.getViewDescriptor().getCustomPresentation(viewOptions, state);
            this.myPresentation = presentation instanceof PresentationData ? (PresentationData)presentation : new PresentationData(presentation.getPresentableText(), presentation.getLocationString(), presentation.getIcon(false), null);
            return this.myPresentation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceViewItem node = (ServiceViewItem)o;
            return this.myValue.equals(node.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }

        public String toString() {
            return this.myValue.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributor";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewDescriptor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceModel$ServiceViewItem";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceModel$ServiceViewItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContributor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootContributor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewDescriptor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setViewDescriptor";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getItemPresentation";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 8 -> new IllegalStateException(string);
            };
        }
    }

    static interface ServiceModelEventListener {
        public void eventProcessed(ServiceEventListener.ServiceEvent var1);
    }

    static final class ContributorNode
    extends ServiceViewItem {
        private final Project myProject;

        ContributorNode(@NotNull Project project, @NotNull ServiceViewContributor<?> contributor) {
            if (project == null) {
                ContributorNode.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ContributorNode.$$$reportNull$$$0(1);
            }
            super(contributor, null, contributor, contributor.getViewDescriptor(project));
            this.myProject = project;
        }

        private void loadChildren() {
            List<ServiceViewItem> children = this.getChildren();
            if (!children.isEmpty()) {
                children.clear();
            }
            children.addAll(ServiceModel.getContributorChildren(this.myProject, this, this.getContributor()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contributor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/platform/execution/serviceView/ServiceModel$ContributorNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ServiceNode
    extends ServiceViewItem {
        private final Project myProject;
        private final ServiceViewContributor<?> myProvidingContributor;
        private volatile boolean myChildrenInitialized;
        private volatile boolean myLoaded;

        ServiceNode(@NotNull Object service, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor<?> contributor, @NotNull ServiceViewDescriptor viewDescriptor, @NotNull Project project, @Nullable ServiceViewContributor<?> providingContributor) {
            if (service == null) {
                ServiceNode.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ServiceNode.$$$reportNull$$$0(1);
            }
            if (viewDescriptor == null) {
                ServiceNode.$$$reportNull$$$0(2);
            }
            if (project == null) {
                ServiceNode.$$$reportNull$$$0(3);
            }
            super(service, parent, contributor, viewDescriptor);
            this.myProject = project;
            this.myProvidingContributor = providingContributor;
            this.myChildrenInitialized = providingContributor == null;
            this.myLoaded = !(providingContributor instanceof ServiceViewLazyContributor);
        }

        @Override
        @NotNull
        List<ServiceViewItem> getChildren() {
            List<ServiceViewItem> children = super.getChildren();
            if (!this.myChildrenInitialized) {
                if (this.myProvidingContributor != null) {
                    children.addAll(ServiceModel.getContributorChildren(this.myProject, this, this.myProvidingContributor));
                }
                this.myChildrenInitialized = true;
                this.myLoaded = true;
            }
            List<ServiceViewItem> list = children;
            if (list == null) {
                ServiceNode.$$$reportNull$$$0(4);
            }
            return list;
        }

        boolean isChildrenInitialized() {
            return this.myChildrenInitialized;
        }

        boolean isLoaded() {
            return this.myLoaded;
        }

        private void reloadChildren() {
            super.getChildren().clear();
            if (this.myProvidingContributor != null) {
                this.myChildrenInitialized = false;
            }
        }

        private void moveChildren(ServiceNode node) {
            List<ServiceViewItem> children = super.getChildren();
            children.clear();
            List<ServiceViewItem> nodeChildren = node.myChildren;
            children.addAll(nodeChildren);
            nodeChildren.clear();
            for (ServiceViewItem child : children) {
                child.setParent(this);
            }
            this.myChildrenInitialized = node.myChildrenInitialized;
            this.myLoaded = node.myLoaded;
        }

        @Nullable
        ServiceViewContributor<?> getProvidingContributor() {
            return this.myProvidingContributor;
        }

        @NotNull
        private Object getService() {
            Object object = this.myProvidingContributor != null ? this.myProvidingContributor : this.getValue();
            if (object == null) {
                ServiceNode.$$$reportNull$$$0(5);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceModel$ServiceNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceModel$ServiceNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    static final class ServiceGroupNode
    extends ServiceViewItem {
        ServiceGroupNode(@NotNull Object group, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor<?> contributor, @NotNull ServiceViewDescriptor viewDescriptor) {
            if (group == null) {
                ServiceGroupNode.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ServiceGroupNode.$$$reportNull$$$0(1);
            }
            if (viewDescriptor == null) {
                ServiceGroupNode.$$$reportNull$$$0(2);
            }
            super(group, parent, contributor, viewDescriptor);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceGroupNode node = (ServiceGroupNode)o;
            return this.getValue().equals(node.getValue()) && Comparing.equal((Object)this.getParent(), (Object)node.getParent());
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            ServiceViewItem parent = this.getParent();
            result = 31 * result + (parent != null ? parent.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contributor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "viewDescriptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/platform/execution/serviceView/ServiceModel$ServiceGroupNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class OnlyLoadedBfsIt<T>
    extends TreeTraversal.It<T> {
        Deque<T> myQueue;
        T myTop;

        OnlyLoadedBfsIt(@NotNull Iterable<? extends T> roots, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                OnlyLoadedBfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.myQueue = new ArrayDeque<T>();
            JBIterable.from(roots).map(arg_0 -> ((NotNullizer)ourNotNullizer).notNullize(arg_0)).addAllTo(this.myQueue);
        }

        public T nextImpl() {
            if (this.myTop != null) {
                Iterable iterable;
                if ((!(this.myTop instanceof ServiceNode) || ((ServiceNode)this.myTop).isChildrenInitialized() || ((ServiceNode)this.myTop).isLoaded()) && (iterable = (Iterable)this.tree.fun(this.myTop)) != null) {
                    JBIterable.from((Iterable)iterable).map(arg_0 -> ((NotNullizer)ourNotNullizer).notNullize(arg_0)).addAllTo(this.myQueue);
                }
                this.myTop = null;
            }
            if (this.myQueue.isEmpty()) {
                return (T)this.stop();
            }
            this.myTop = ourNotNullizer.nullize(this.myQueue.remove());
            return this.myTop;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/platform/execution/serviceView/ServiceModel$OnlyLoadedBfsIt", "<init>"));
        }
    }

    private static final class NotLoadedLastBfsIt<T>
    extends TreeTraversal.It<T> {
        Deque<T> myQueue;
        Deque<T> myNotLoadedQueue;
        T myTop;

        NotLoadedLastBfsIt(@NotNull Iterable<? extends T> roots, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                NotLoadedLastBfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.myQueue = new ArrayDeque<T>();
            this.myNotLoadedQueue = new ArrayDeque<T>();
            JBIterable.from(roots).map(arg_0 -> ((NotNullizer)ourNotNullizer).notNullize(arg_0)).addAllTo(this.myQueue);
        }

        public T nextImpl() {
            if (this.myTop != null) {
                if (this.myTop instanceof ServiceNode && !((ServiceNode)this.myTop).isChildrenInitialized() && !((ServiceNode)this.myTop).isLoaded()) {
                    this.myNotLoadedQueue.add(this.myTop);
                } else {
                    Iterable iterable = (Iterable)this.tree.fun(this.myTop);
                    if (iterable != null) {
                        JBIterable.from((Iterable)iterable).map(arg_0 -> ((NotNullizer)ourNotNullizer).notNullize(arg_0)).addAllTo(this.myQueue);
                    }
                }
                this.myTop = null;
            }
            while (!this.myNotLoadedQueue.isEmpty() && this.myQueue.isEmpty()) {
                T notLoaded = this.myNotLoadedQueue.remove();
                Iterable iterable = (Iterable)this.tree.fun(notLoaded);
                if (iterable == null) continue;
                JBIterable.from((Iterable)iterable).map(arg_0 -> ((NotNullizer)ourNotNullizer).notNullize(arg_0)).addAllTo(this.myQueue);
            }
            if (this.myQueue.isEmpty()) {
                return (T)this.stop();
            }
            this.myTop = ourNotNullizer.nullize(this.myQueue.remove());
            return this.myTop;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/platform/execution/serviceView/ServiceModel$NotLoadedLastBfsIt", "<init>"));
        }
    }
}

