/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.ObjectByteAssociativeContainer;
import com.carrotsearch.hppc.ObjectByteHashMap;

public class ObjectByteIdentityHashMap<KType>
extends ObjectByteHashMap<KType> {
    public ObjectByteIdentityHashMap() {
        this(4);
    }

    public ObjectByteIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectByteIdentityHashMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor);
    }

    public ObjectByteIdentityHashMap(ObjectByteAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key2) {
        assert (key2 != null);
        return BitMixer.mixPhi(System.identityHashCode(key2));
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    public static <KType> ObjectByteIdentityHashMap<KType> from(KType[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectByteIdentityHashMap<KType> map = new ObjectByteIdentityHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

