/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.remote;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.GraziePlugin;
import com.intellij.grazie.ide.ui.components.dsl.SwingKTKt;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.GrazieRemote;
import com.intellij.grazie.remote.OfflineLanguageBundleSelectionDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001f\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00072\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001d\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/grazie/remote/LangDownloader;", "", "<init>", "()V", "download", "", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "project", "Lcom/intellij/openapi/project/Project;", "runDownload", "Ljava/nio/file/Path;", "language", "performDownload", "presentableName", "", "Lorg/jetbrains/annotations/Nls;", "promptToSelectLanguageBundleManually", "doDownload", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nLangDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangDownloader.kt\ncom/intellij/grazie/remote/LangDownloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1#2:78\n24#3:79\n1557#4:80\n1628#4,3:81\n*S KotlinDebug\n*F\n+ 1 LangDownloader.kt\ncom/intellij/grazie/remote/LangDownloader\n*L\n45#1:79\n73#1:80\n73#1:81,3\n*E\n"})
public final class LangDownloader {
    @NotNull
    public static final LangDownloader INSTANCE = new LangDownloader();

    private LangDownloader() {
    }

    public final boolean download(@NotNull Lang lang, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        if (GrazieRemote.INSTANCE.isAvailableLocally(lang)) {
            return true;
        }
        Path path = this.runDownload(lang, project);
        if (path == null) {
            return false;
        }
        Path result2 = path;
        if (!GrazieRemote.INSTANCE.isValidBundleForLanguage(lang, result2)) {
            boolean bl = false;
            String string2 = "Language bundle checksum became invalid right before loading it";
            throw new IllegalStateException(string2.toString());
        }
        UrlClassLoader urlClassLoader = UrlClassLoader.build().parent(GraziePlugin.INSTANCE.getClassLoader()).files(CollectionsKt.listOf((Object)result2)).get();
        Intrinsics.checkNotNullExpressionValue((Object)urlClassLoader, (String)"get(...)");
        UrlClassLoader classLoader = urlClassLoader;
        GrazieDynamic.INSTANCE.addDynClassLoader((ClassLoader)classLoader);
        GrazieConfig.Companion.update((Function1<? super GrazieConfig.State, GrazieConfig.State>)((Function1)LangDownloader::download$lambda$1));
        GrazieConfig.Companion.stateChanged(GrazieConfig.Companion.get(), GrazieConfig.Companion.get());
        return true;
    }

    private final Path runDownload(Lang language, Project project) {
        try {
            String[] stringArray = new String[]{language.getNativeName()};
            String presentableName = SwingKTKt.msg("grazie.settings.proofreading.languages.download.name", stringArray);
            return (Path)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> LangDownloader.runDownload$lambda$2(language, presentableName), presentableName, false, project);
        }
        catch (Throwable exception) {
            LangDownloader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LangDownloader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(exception);
            return this.promptToSelectLanguageBundleManually(project, language);
        }
    }

    private final Path performDownload(Lang language, String presentableName) throws IllegalStateException {
        Path bundle = this.doDownload(language, presentableName);
        if (!GrazieRemote.INSTANCE.isValidBundleForLanguage(language, bundle)) {
            FileUtil.delete((Path)bundle);
            throw new IllegalStateException("Failed to verify integrity of downloaded language bundle for language " + language.getNativeName() + ".");
        }
        return bundle;
    }

    private final Path promptToSelectLanguageBundleManually(Project project, Lang language) {
        Path path = OfflineLanguageBundleSelectionDialog.Companion.show(project, language);
        if (path == null) {
            return null;
        }
        Path selectedFile = path;
        Path targetPath = GrazieDynamic.INSTANCE.getDynamicFolder().resolve(language.getRemote().getFileName());
        Path path2 = selectedFile;
        Intrinsics.checkNotNull((Object)targetPath);
        Path path3 = targetPath;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        CopyOption[] copyOptionArray2 = copyOptionArray;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path3, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
        return targetPath;
    }

    /*
     * WARNING - void declaration
     */
    private final Path doDownload(Lang lang, String presentableName) {
        void $this$mapTo$iv$iv;
        DownloadableFileService downloaderService = DownloadableFileService.getInstance();
        FileDownloader fileDownloader = downloaderService.createDownloader(CollectionsKt.listOf((Object)downloaderService.createFileDescription(lang.getRemote().getUrl(), lang.getRemote().getFileName())), presentableName);
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"createDownloader(...)");
        FileDownloader downloader = fileDownloader;
        List list = downloader.download(GrazieDynamic.INSTANCE.getDynamicFolder().toFile());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"download(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((File)it.first).toPath());
        }
        List result2 = (List)destination$iv$iv;
        Object object = CollectionsKt.single((List)result2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
        return (Path)object;
    }

    private static final GrazieConfig.State download$lambda$1(GrazieConfig.State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GrazieConfig.State.copy$default(it, null, null, null, false, null, null, null, null, null, null, 1023, null);
    }

    private static final Path runDownload$lambda$2(Lang $language, String $presentableName) {
        return INSTANCE.performDownload($language, $presentableName);
    }
}

