/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.TerminalFocusModel;
import org.jetbrains.plugins.terminal.block.output.BlockDecoration;
import org.jetbrains.plugins.terminal.block.output.BlockDecorationState;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.CommandBlockImplKt;
import org.jetbrains.plugins.terminal.block.output.CommandBlockInfo;
import org.jetbrains.plugins.terminal.block.output.DefaultBlockDecorationState;
import org.jetbrains.plugins.terminal.block.output.ErrorBlockDecorationState;
import org.jetbrains.plugins.terminal.block.output.HoveredBlockDecorationState;
import org.jetbrains.plugins.terminal.block.output.HoveredErrorBlockDecorationState;
import org.jetbrains.plugins.terminal.block.output.InactiveSelectedBlockDecorationState;
import org.jetbrains.plugins.terminal.block.output.InactiveSelectedErrorBlockDecorationState;
import org.jetbrains.plugins.terminal.block.output.SelectedBlockDecorationState;
import org.jetbrains.plugins.terminal.block.output.SelectedErrorBlockDecorationState;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelKt;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionModel;
import org.jetbrains.plugins.terminal.block.ui.GradientTextureCache;
import org.jetbrains.plugins.terminal.block.ui.TerminalUi;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0003&'(B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0007J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0016\u0010\u0018\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u001dH\u0002J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalBlocksDecorator;", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModelListener;", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "focusModel", "Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;", "selectionModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/terminal/TerminalColorPalette;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "decorations", "", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "Lorg/jetbrains/plugins/terminal/block/output/BlockDecoration;", "hoveredGradientCache", "Lorg/jetbrains/plugins/terminal/block/ui/GradientTextureCache;", "installDecoration", "", "block", "updateDecorationState", "updateSelectionDecorationState", "selectedBlocks", "", "updateHoveredState", "calculateDecorationState", "Lorg/jetbrains/plugins/terminal/block/output/BlockDecorationState;", "calculateSelectionDecorationState", "calculateErrorSelectionDecorationState", "setDecorationState", "state", "addExitCodeInlay", "exitCode", "", "updateCommandToOutputInlay", "ExitCodeRenderer", "EmptyWidthInlayRenderer", "TerminalRightAreaRenderer", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalBlocksDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBlocksDecorator.kt\norg/jetbrains/plugins/terminal/block/output/TerminalBlocksDecorator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,312:1\n1#2:313\n*E\n"})
public final class TerminalBlocksDecorator
implements TerminalOutputModelListener {
    @NotNull
    private final TerminalColorPalette colorPalette;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalFocusModel focusModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final Map<CommandBlock, BlockDecoration> decorations;
    @NotNull
    private final GradientTextureCache hoveredGradientCache;

    public TerminalBlocksDecorator(@NotNull TerminalColorPalette colorPalette, @NotNull TerminalOutputModel outputModel, @NotNull TerminalFocusModel focusModel, @NotNull TerminalSelectionModel selectionModel, @NotNull EditorEx editor) {
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)focusModel, (String)"focusModel");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.colorPalette = colorPalette;
        this.outputModel = outputModel;
        this.focusModel = focusModel;
        this.selectionModel = selectionModel;
        this.editor = editor;
        this.decorations = new HashMap();
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        this.hoveredGradientCache = new GradientTextureCache(editorColorsScheme, BlockTerminalColors.HOVERED_BLOCK_BACKGROUND_START, BlockTerminalColors.HOVERED_BLOCK_BACKGROUND_END);
        TerminalOutputModel.addListener$default(this.outputModel, this, null, 2, null);
        EditorUtil.disposeWithEditor((Editor)((Editor)this.editor), (Disposable)this.hoveredGradientCache);
        RangeHighlighter $this$_init__u24lambda_u240 = rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(0, 0, 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        boolean bl = false;
        $this$_init__u24lambda_u240.setGreedyToLeft(true);
        $this$_init__u24lambda_u240.setGreedyToRight(true);
        $this$_init__u24lambda_u240.setCustomRenderer((CustomHighlighterRenderer)new TerminalRightAreaRenderer());
        TerminalOutputModel.addListener$default(this.outputModel, new TerminalOutputModelListener(){

            @Override
            public void blockFinalized(CommandBlock block) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                    BlockDecoration blockDecoration = (BlockDecoration)decorations.get(block);
                    if (blockDecoration == null) break block0;
                    BlockDecoration it = blockDecoration;
                    boolean bl = false;
                    it.getBackgroundHighlighter().setGreedyToRight(false);
                    it.getCornersHighlighter().setGreedyToRight(false);
                    Inlay<?> inlay = it.getBottomInlay();
                    Intrinsics.checkNotNull(inlay, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.RangeMarkerImpl");
                    ((RangeMarkerImpl)inlay).setStickingToRight(false);
                }
            }

            @Override
            public void blockRemoved(CommandBlock block) {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                    BlockDecoration blockDecoration = (BlockDecoration)decorations.get(block);
                    if (blockDecoration != null) {
                        Inlay<?> inlay;
                        BlockDecoration blockDecoration2 = blockDecoration;
                        TerminalBlocksDecorator terminalBlocksDecorator = this;
                        BlockDecoration it = blockDecoration2;
                        boolean bl = false;
                        Disposer.dispose((Disposable)((Disposable)it.getTopInlay()));
                        Disposer.dispose((Disposable)((Disposable)it.getBottomInlay()));
                        Inlay<?> inlay2 = it.getCommandToOutputInlay();
                        if (inlay2 != null) {
                            inlay = inlay2;
                            boolean bl2 = false;
                            Disposer.dispose((Disposable)((Disposable)inlay));
                        }
                        Inlay<?> inlay3 = it.getExitCodeInlay();
                        if (inlay3 != null) {
                            inlay = inlay3;
                            boolean bl3 = false;
                            Disposer.dispose((Disposable)((Disposable)inlay));
                        }
                        terminalBlocksDecorator.editor.getMarkupModel().removeHighlighter(it.getBackgroundHighlighter());
                        terminalBlocksDecorator.editor.getMarkupModel().removeHighlighter(it.getCornersHighlighter());
                    }
                    decorations.remove(block);
                    CommandBlock commandBlock = (CommandBlock)CollectionsKt.firstOrNull(outputModel.getBlocks());
                    if (commandBlock == null) {
                        return;
                    }
                    CommandBlock firstBlock = commandBlock;
                    Inlay<?> inlay = (Inlay<?>)decorations.get(firstBlock);
                    if (inlay == null || (inlay = inlay.getTopInlay()) == null) break block4;
                    inlay.update();
                }
            }

            @Override
            public void blockInfoUpdated(CommandBlock block, CommandBlockInfo newInfo) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Intrinsics.checkNotNullParameter((Object)newInfo, (String)"newInfo");
                this.updateDecorationState(block);
                if (newInfo.getExitCode() != 0) {
                    this.addExitCodeInlay(block, newInfo.getExitCode());
                }
                this.updateCommandToOutputInlay(block);
            }
        }, null, 2, null);
        TerminalSelectionModel.addListener$default(this.selectionModel, new TerminalSelectionModel.TerminalSelectionListener(){

            @Override
            public void selectionChanged(List<? extends CommandBlock> oldSelection, List<? extends CommandBlock> newSelection) {
                Intrinsics.checkNotNullParameter(oldSelection, (String)"oldSelection");
                Intrinsics.checkNotNullParameter(newSelection, (String)"newSelection");
                for (CommandBlock commandBlock : oldSelection) {
                    this.updateDecorationState(commandBlock);
                }
                this.updateSelectionDecorationState(newSelection);
            }

            @Override
            public void hoverChanged(CommandBlock oldHovered, CommandBlock newHovered) {
                if (oldHovered != null && decorations.containsKey(oldHovered)) {
                    this.updateDecorationState(oldHovered);
                }
                if (newHovered != null) {
                    this.updateHoveredState(newHovered);
                }
            }
        }, null, 2, null);
        TerminalFocusModel.addListener$default(this.focusModel, new TerminalFocusModel.TerminalFocusListener(){

            @Override
            public void activeStateChanged(boolean isActive) {
                EdtScheduler.Companion.getInstance().schedule(150, () -> 4.activeStateChanged$lambda$0(this));
            }

            private static final void activeStateChanged$lambda$0(TerminalBlocksDecorator this$0) {
                if (!this$0.editor.isDisposed()) {
                    this$0.updateSelectionDecorationState(this$0.selectionModel.getSelectedBlocks());
                }
            }
        }, null, 2, null);
    }

    @RequiresEdt
    public final void installDecoration(@NotNull CommandBlock block) {
        Inlay inlay;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (this.decorations.get(block) != null) {
            return;
        }
        EmptyWidthInlayRenderer topRenderer = new EmptyWidthInlayRenderer((Function0<Integer>)((Function0)() -> TerminalBlocksDecorator.installDecoration$lambda$1(this, block)));
        Inlay inlay2 = this.editor.getInlayModel().addBlockElement(block.getStartOffset(), false, true, 1, (EditorCustomElementRenderer)topRenderer);
        Intrinsics.checkNotNull((Object)inlay2);
        Inlay topInlay = inlay2;
        EmptyWidthInlayRenderer bottomRenderer = new EmptyWidthInlayRenderer(6);
        Inlay inlay3 = this.editor.getInlayModel().addBlockElement(block.getEndOffset(), true, false, 0, (EditorCustomElementRenderer)bottomRenderer);
        Intrinsics.checkNotNull((Object)inlay3);
        Inlay bottomInlay = inlay3;
        if (CommandBlockImplKt.getWithCommand(block)) {
            EmptyWidthInlayRenderer renderer = new EmptyWidthInlayRenderer(2);
            Inlay inlay4 = this.editor.getInlayModel().addBlockElement(block.getOutputStartOffset(), false, false, 0, (EditorCustomElementRenderer)renderer);
            inlay = inlay4;
            Intrinsics.checkNotNull((Object)inlay4);
        } else {
            inlay = null;
        }
        Inlay commandToOutputInlay = inlay;
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(block.getStartOffset(), block.getEndOffset(), 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter bgHighlighter = rangeHighlighter;
        bgHighlighter.setGreedyToRight(true);
        RangeHighlighter rangeHighlighter2 = this.editor.getMarkupModel().addRangeHighlighter(block.getStartOffset(), block.getEndOffset(), 900, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
        RangeHighlighter cornersHighlighter = rangeHighlighter2;
        cornersHighlighter.setGreedyToRight(true);
        BlockDecoration decoration = new BlockDecoration(bgHighlighter, cornersHighlighter, topInlay, bottomInlay, commandToOutputInlay, null, 32, null);
        this.decorations.put(block, decoration);
        this.setDecorationState(block, new DefaultBlockDecorationState());
    }

    private final void updateDecorationState(CommandBlock block) {
        BlockDecorationState state = this.calculateDecorationState(block);
        this.setDecorationState(block, state);
    }

    private final void updateSelectionDecorationState(List<? extends CommandBlock> selectedBlocks) {
        BlockDecorationState state = this.calculateSelectionDecorationState();
        BlockDecorationState errorState = this.calculateErrorSelectionDecorationState();
        for (CommandBlock commandBlock : selectedBlocks) {
            if (TerminalOutputModelKt.isErrorBlock(this.outputModel, commandBlock)) {
                this.setDecorationState(commandBlock, errorState);
                continue;
            }
            this.setDecorationState(commandBlock, state);
        }
    }

    private final void updateHoveredState(CommandBlock block) {
        HoveredBlockDecorationState state = TerminalOutputModelKt.isErrorBlock(this.outputModel, block) ? (HoveredBlockDecorationState)new HoveredErrorBlockDecorationState(this.hoveredGradientCache) : new HoveredBlockDecorationState(this.hoveredGradientCache);
        this.setDecorationState(block, state);
    }

    private final BlockDecorationState calculateDecorationState(CommandBlock block) {
        return this.selectionModel.getSelectedBlocks().contains(block) ? (TerminalOutputModelKt.isErrorBlock(this.outputModel, block) ? this.calculateErrorSelectionDecorationState() : this.calculateSelectionDecorationState()) : (TerminalOutputModelKt.isErrorBlock(this.outputModel, block) ? (BlockDecorationState)new ErrorBlockDecorationState() : (BlockDecorationState)new DefaultBlockDecorationState());
    }

    private final BlockDecorationState calculateSelectionDecorationState() {
        return this.focusModel.isActive() ? (BlockDecorationState)new SelectedBlockDecorationState() : (BlockDecorationState)new InactiveSelectedBlockDecorationState();
    }

    private final BlockDecorationState calculateErrorSelectionDecorationState() {
        return this.focusModel.isActive() ? (BlockDecorationState)new SelectedErrorBlockDecorationState() : (BlockDecorationState)new InactiveSelectedErrorBlockDecorationState();
    }

    private final void setDecorationState(CommandBlock block, BlockDecorationState state) {
        BlockDecoration decoration;
        BlockDecoration blockDecoration = this.decorations.get(block);
        if (blockDecoration == null) {
            throw new IllegalStateException("No decoration for block, installDecoration should be called first".toString());
        }
        BlockDecoration $this$setDecorationState_u24lambda_u242 = decoration = blockDecoration;
        boolean bl = false;
        $this$setDecorationState_u24lambda_u242.getBackgroundHighlighter().setCustomRenderer(state.getBackgroundRenderer());
        $this$setDecorationState_u24lambda_u242.getCornersHighlighter().setCustomRenderer(state.getCornersRenderer());
        $this$setDecorationState_u24lambda_u242.getCornersHighlighter().setLineMarkerRenderer(state.getLeftAreaRenderer());
        Rectangle bounds = TerminalOutputModelKt.getBlockBounds(this.outputModel, block);
        this.editor.getComponent().repaint(bounds);
    }

    private final void addExitCodeInlay(CommandBlock block, int exitCode) {
        BlockDecoration blockDecoration = this.decorations.get(block);
        if (blockDecoration == null) {
            throw new IllegalStateException("No decoration for block, installDecoration should be called first".toString());
        }
        BlockDecoration decoration = blockDecoration;
        JBFont jBFont = JBFont.label().deriveFont(this.editor.getColorsScheme().getEditorFontSize2D());
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"deriveFont(...)");
        ExitCodeRenderer renderer = new ExitCodeRenderer(exitCode, (Font)jBFont, this.colorPalette);
        Inlay inlay = this.editor.getInlayModel().addAfterLineEndElement(block.getEndOffset(), false, (EditorCustomElementRenderer)renderer);
        this.decorations.put(block, BlockDecoration.copy$default(decoration, null, null, null, null, null, inlay, 31, null));
    }

    private final void updateCommandToOutputInlay(CommandBlock block) {
        if (!CommandBlockImplKt.getWithOutput(block)) {
            BlockDecoration blockDecoration = this.decorations.get(block);
            if (blockDecoration == null) {
                return;
            }
            BlockDecoration decoration = blockDecoration;
            Inlay<?> inlay = decoration.getCommandToOutputInlay();
            if (inlay != null) {
                Inlay<?> it = inlay;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)it));
            }
            this.decorations.put(block, BlockDecoration.copy$default(decoration, null, null, null, null, null, null, 47, null));
        }
    }

    private static final int installDecoration$lambda$1(TerminalBlocksDecorator this$0, CommandBlock $block) {
        int additionalInset = this$0.outputModel.getBlocks().get(0) == $block ? 0 : 1;
        return 6 + additionalInset;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0014\u0010\t\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0014\u0010\f\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalBlocksDecorator$EmptyWidthInlayRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "heightSupplier", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "height", "(I)V", "calcWidthInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcHeightInPixels", "intellij.terminal"})
    private static final class EmptyWidthInlayRenderer
    implements EditorCustomElementRenderer {
        @NotNull
        private final Function0<Integer> heightSupplier;

        public EmptyWidthInlayRenderer(@NotNull Function0<Integer> heightSupplier) {
            Intrinsics.checkNotNullParameter(heightSupplier, (String)"heightSupplier");
            this.heightSupplier = heightSupplier;
        }

        public EmptyWidthInlayRenderer(int height) {
            this((Function0<Integer>)((Function0)() -> EmptyWidthInlayRenderer._init_$lambda$0(height)));
        }

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return 0;
        }

        public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return JBUI.scale((int)((Number)this.heightSupplier.invoke()).intValue());
        }

        private static final int _init_$lambda$0(int $height) {
            return $height;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u000f\u001a\u00020\u00032\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J,\u0010\u0012\u001a\u00020\u00132\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalBlocksDecorator$ExitCodeRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "exitCode", "", "font", "Ljava/awt/Font;", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "<init>", "(ILjava/awt/Font;Lcom/intellij/terminal/TerminalColorPalette;)V", "text", "", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "calcWidthInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.terminal"})
    private static final class ExitCodeRenderer
    implements EditorCustomElementRenderer {
        @NotNull
        private final Font font;
        @NotNull
        private final TerminalColorPalette colorPalette;
        @NotNull
        private final String text;
        @NotNull
        private final Icon icon;

        public ExitCodeRenderer(int exitCode, @NotNull Font font, @NotNull TerminalColorPalette colorPalette) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
            this.font = font;
            this.colorPalette = colorPalette;
            this.text = "Exit code " + exitCode;
            Icon icon = AllIcons.General.Error;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Error");
            this.icon = icon;
        }

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            FontMetrics fontMetrics = inlay.getEditor().getContentComponent().getFontMetrics(this.font);
            return fontMetrics.stringWidth(this.text) + JBUI.scale((int)4) + this.icon.getIconWidth();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            Graphics g2 = g.create();
            try {
                Rectangle rectangle = inlay.getEditor().getScrollingModel().getVisibleArea();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
                Rectangle visibleArea = rectangle;
                int textX = visibleArea.x + visibleArea.width - targetRegion.width - JBUI.scale((int)18);
                FontMetrics fontMetrics = g2.getFontMetrics(this.font);
                int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)targetRegion.height);
                g2.setFont(this.font);
                g2.setColor(TerminalUiUtils.INSTANCE.getAwtForegroundByIndex(this.colorPalette, 1));
                g2.drawString(this.text, textX, targetRegion.y + baseLine);
                int heightDiff = fontMetrics.getHeight() - this.icon.getIconHeight();
                int iconY = targetRegion.y + heightDiff / 2 + heightDiff % 2;
                int iconX = textX + targetRegion.width - this.icon.getIconWidth();
                this.icon.paintIcon(inlay.getEditor().getContentComponent(), g2, iconX, iconY);
            }
            finally {
                g2.dispose();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalBlocksDecorator$TerminalRightAreaRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "<init>", "()V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "intellij.terminal"})
    private static final class TerminalRightAreaRenderer
    implements CustomHighlighterRenderer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            int width = JBUI.scale((int)10);
            Color oldColor = g.getColor();
            try {
                g.setColor((Color)TerminalUi.INSTANCE.defaultBackground(editor));
                g.fillRect(visibleArea.width - width, visibleArea.y, width, visibleArea.height);
            }
            finally {
                g.setColor(oldColor);
            }
        }
    }
}

