/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.settingsSync.CloudConfigServerCommunicator;
import com.intellij.settingsSync.GitSettingsLog;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSyncBridge;
import com.intellij.settingsSync.SettingsSyncIdeMediator;
import com.intellij.settingsSync.SettingsSyncIdeMediatorImpl;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncUpdateChecker;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.ui.JBAccountInfoService;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\r\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0006\u0010\u000f\u001a\u00020\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain;", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "controls", "Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "getControls", "()Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "dispose", "", "getRemoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "getRemoteCommunicator$intellij_settingsSync", "disableSyncing", "Companion", "SettingsSyncControls", "intellij.settingsSync"})
@ApiStatus.Internal
public final class SettingsSyncMain
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsSyncControls controls;

    public SettingsSyncMain(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        Path appConfigPath = path;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        IComponentStore iComponentStore = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application));
        Intrinsics.checkNotNull((Object)iComponentStore, (String)"null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        ComponentStoreImpl componentStore = (ComponentStoreImpl)iComponentStore;
        SettingsSyncIdeMediatorImpl ideMediator = new SettingsSyncIdeMediatorImpl(componentStore, appConfigPath, (Function0<Boolean>)((Function0)SettingsSyncMain::_init_$lambda$0));
        Disposable disposable = this;
        Path path2 = appConfigPath.resolve("settingsSync");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this.controls = Companion.init$intellij_settingsSync(coroutineScope, disposable, path2, appConfigPath, new CloudConfigServerCommunicator(null, 1, null), ideMediator);
    }

    @NotNull
    public final SettingsSyncControls getControls() {
        return this.controls;
    }

    public void dispose() {
    }

    @NotNull
    public final SettingsSyncRemoteCommunicator getRemoteCommunicator$intellij_settingsSync() {
        return this.controls.getRemoteCommunicator();
    }

    public final void disableSyncing() {
        this.controls.getIdeMediator().removeStreamProvider();
    }

    private static final boolean _init_$lambda$0() {
        return SettingsSyncMainKt.isSettingsSyncEnabledByKey() && Companion.isAvailable() && SettingsSyncMainKt.isSettingsSyncEnabledInSettings();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J=\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain$Companion;", "", "<init>", "()V", "isAvailable", "", "getInstance", "Lcom/intellij/settingsSync/SettingsSyncMain;", "init", "Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "settingsSyncStorage", "Ljava/nio/file/Path;", "appConfigPath", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "ideMediator", "Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "init$intellij_settingsSync", "intellij.settingsSync"})
    @SourceDebugExtension(value={"SMAP\nSettingsSyncMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncMain.kt\ncom/intellij/settingsSync/SettingsSyncMain$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,88:1\n59#2:89\n40#3,3:90\n*S KotlinDebug\n*F\n+ 1 SettingsSyncMain.kt\ncom/intellij/settingsSync/SettingsSyncMain$Companion\n*L\n57#1:89\n60#1:90,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAvailable() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)application;
            boolean $i$f$serviceIfCreated = false;
            return $this$serviceIfCreated$iv.getServiceIfCreated(SettingsSyncMain.class) != null;
        }

        @NotNull
        public final SettingsSyncMain getInstance() {
            boolean $i$f$service = false;
            Class<SettingsSyncMain> serviceClass$iv = SettingsSyncMain.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (SettingsSyncMain)object;
        }

        @NotNull
        public final SettingsSyncControls init$intellij_settingsSync(@NotNull CoroutineScope coroutineScope, @NotNull Disposable parentDisposable, @NotNull Path settingsSyncStorage, @NotNull Path appConfigPath, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator, @NotNull SettingsSyncIdeMediator ideMediator) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
            Intrinsics.checkNotNullParameter((Object)appConfigPath, (String)"appConfigPath");
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)ideMediator, (String)"ideMediator");
            GitSettingsLog settingsLog2 = new GitSettingsLog(settingsSyncStorage, appConfigPath, parentDisposable, (Function0<JBAccountInfoService.JBAData>)((Function0)new Function0<JBAccountInfoService.JBAData>((Object)SettingsSyncAuthService.Companion.getInstance()){

                public final JBAccountInfoService.JBAData invoke() {
                    return ((SettingsSyncAuthService)this.receiver).getUserData();
                }
            }), (Function1<? super SettingsSnapshot, SettingsSnapshot>)((Function1)arg_0 -> Companion.init$lambda$0(ideMediator, appConfigPath, arg_0)));
            SettingsSyncUpdateChecker updateChecker = new SettingsSyncUpdateChecker(remoteCommunicator);
            SettingsSyncBridge bridge = new SettingsSyncBridge(coroutineScope, appConfigPath, settingsLog2, ideMediator, remoteCommunicator, updateChecker);
            return new SettingsSyncControls(ideMediator, updateChecker, bridge, remoteCommunicator, settingsSyncStorage);
        }

        private static final SettingsSnapshot init$lambda$0(SettingsSyncIdeMediator $ideMediator, Path $appConfigPath, SettingsSnapshot currentSnapshot) {
            Intrinsics.checkNotNullParameter((Object)currentSnapshot, (String)"currentSnapshot");
            return $ideMediator.getInitialSnapshot($appConfigPath, currentSnapshot);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "", "ideMediator", "Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "updateChecker", "Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "bridge", "Lcom/intellij/settingsSync/SettingsSyncBridge;", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "settingsSyncStorage", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/settingsSync/SettingsSyncIdeMediator;Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;Lcom/intellij/settingsSync/SettingsSyncBridge;Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;Ljava/nio/file/Path;)V", "getIdeMediator", "()Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "getUpdateChecker", "()Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "getBridge", "()Lcom/intellij/settingsSync/SettingsSyncBridge;", "getRemoteCommunicator", "()Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "getSettingsSyncStorage", "()Ljava/nio/file/Path;", "intellij.settingsSync"})
    public static final class SettingsSyncControls {
        @NotNull
        private final SettingsSyncIdeMediator ideMediator;
        @NotNull
        private final SettingsSyncUpdateChecker updateChecker;
        @NotNull
        private final SettingsSyncBridge bridge;
        @NotNull
        private final SettingsSyncRemoteCommunicator remoteCommunicator;
        @NotNull
        private final Path settingsSyncStorage;

        public SettingsSyncControls(@NotNull SettingsSyncIdeMediator ideMediator, @NotNull SettingsSyncUpdateChecker updateChecker, @NotNull SettingsSyncBridge bridge, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator, @NotNull Path settingsSyncStorage) {
            Intrinsics.checkNotNullParameter((Object)ideMediator, (String)"ideMediator");
            Intrinsics.checkNotNullParameter((Object)updateChecker, (String)"updateChecker");
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
            this.ideMediator = ideMediator;
            this.updateChecker = updateChecker;
            this.bridge = bridge;
            this.remoteCommunicator = remoteCommunicator;
            this.settingsSyncStorage = settingsSyncStorage;
        }

        @NotNull
        public final SettingsSyncIdeMediator getIdeMediator() {
            return this.ideMediator;
        }

        @NotNull
        public final SettingsSyncUpdateChecker getUpdateChecker() {
            return this.updateChecker;
        }

        @NotNull
        public final SettingsSyncBridge getBridge() {
            return this.bridge;
        }

        @NotNull
        public final SettingsSyncRemoteCommunicator getRemoteCommunicator() {
            return this.remoteCommunicator;
        }

        @NotNull
        public final Path getSettingsSyncStorage() {
            return this.settingsSyncStorage;
        }
    }
}

