/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.codeInspection.unused;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.RegexValidator;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnusedPropertyInspection
extends PropertiesInspectionBase {
    private static final ExtensionPointName<ImplicitPropertyUsageProvider> EP_NAME = new ExtensionPointName("com.intellij.properties.implicitPropertyUsageProvider");
    public static final String SHORT_NAME = "UnusedProperty";
    @NotNull
    @RegExp
    public String fileNameMask = ".*";

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.string((String)"fileNameMask", (String)PropertiesBundle.message("label.analyze.only.property.files.whose.name.matches", new Object[0]), (int)30, (StringValidator)new RegexValidator())});
        if (optPane == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValueSet("fileNameMask", value -> {
            if ("".equals(value)) {
                this.fileNameMask = ".*";
            }
        });
        if (optionController == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(1);
        }
        return optionController;
    }

    @Nullable
    private static GlobalSearchScope getWidestUseScope(@Nullable String key, @NotNull Project project, @NotNull Module ownModule) {
        if (project == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(2);
        }
        if (ownModule == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(3);
        }
        if (key == null) {
            return null;
        }
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        for (IProperty property : PropertiesImplUtil.findPropertiesByKey(project, key)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)property.getPsiElement());
            if (module == null) {
                return GlobalSearchScope.allScope((Project)project);
            }
            if (module == ownModule) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return null;
        }
        return GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])modules.stream().map(Module::getModuleWithDependentsScope).toArray(GlobalSearchScope[]::new)));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Module module;
        PsiFile file;
        block12: {
            if (holder == null) {
                UnusedPropertyInspection.$$$reportNull$$$0(4);
            }
            if (session == null) {
                UnusedPropertyInspection.$$$reportNull$$$0(5);
            }
            file = session.getFile();
            if (!this.fileNameMask.isEmpty()) {
                PsiElementVisitor psiElementVisitor;
                try {
                    Pattern p = Pattern.compile(this.fileNameMask);
                    if (p.matcher(file.getName()).matches()) break block12;
                    psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
                }
                catch (PatternSyntaxException p) {
                    // empty catch block
                }
                if (psiElementVisitor == null) {
                    UnusedPropertyInspection.$$$reportNull$$$0(6);
                }
                return psiElementVisitor;
            }
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UnusedPropertyInspection.$$$reportNull$$$0(7);
            }
            return psiElementVisitor;
        }
        if (InjectedLanguageManager.getInstance((Project)module.getProject()).isInjectedFragment(holder.getFile()) || holder.getFile().getUserData(FileContextUtil.INJECTED_IN_ELEMENT) != null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UnusedPropertyInspection.$$$reportNull$$$0(8);
            }
            return psiElementVisitor;
        }
        VirtualFile virtualFile = holder.getFile().getVirtualFile();
        if (virtualFile == null || !ProjectFileIndex.getInstance((Project)module.getProject()).isInSource(virtualFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UnusedPropertyInspection.$$$reportNull$$$0(9);
            }
            return psiElementVisitor;
        }
        final UnusedPropertiesSearchHelper helper = new UnusedPropertiesSearchHelper(module);
        final Set<PsiElement> propertiesBeingCommitted = UnusedPropertyInspection.getBeingCommittedProperties(file);
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof Property)) {
                    return;
                }
                Property property = (Property)element;
                if (propertiesBeingCommitted != null && !propertiesBeingCommitted.contains(property)) {
                    return;
                }
                if (UnusedPropertyInspection.isPropertyUsed(property, helper, isOnTheFly)) {
                    return;
                }
                ASTNode propertyNode = property.getNode();
                assert (propertyNode != null);
                ASTNode[] nodes = propertyNode.getChildren(null);
                Property key = nodes.length == 0 ? property : nodes[0].getPsi();
                LocalQuickFix fix = PropertiesQuickFixFactory.getInstance().createRemovePropertyLocalFix(property);
                holder.registerProblem((PsiElement)key, isOnTheFly ? PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]) : PropertiesBundle.message("unused.property.problem.descriptor.name.offline", property.getUnescapedKey()), new LocalQuickFix[]{fix});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/codeInspection/unused/UnusedPropertyInspection$1", "visitElement"));
            }
        };
    }

    @Nullable
    private static Set<PsiElement> getBeingCommittedProperties(@NotNull PsiFile file) {
        Map data;
        if (file == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(10);
        }
        if ((data = (Map)file.getUserData(InspectionProfileWrapper.PSI_ELEMENTS_BEING_COMMITTED)) == null) {
            return null;
        }
        return (Set)data.get(Property.class);
    }

    private static boolean isImplicitlyUsed(@NotNull Property property) {
        if (property == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(11);
        }
        for (ImplicitPropertyUsageProvider provider : EP_NAME.getIterable()) {
            if (!provider.isUsed(property)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyUsed(@NotNull Property property, @NotNull UnusedPropertiesSearchHelper helper, boolean isOnTheFly) {
        GlobalSearchScope widerScope;
        ProgressIndicator original;
        if (property == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(12);
        }
        if (helper == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(13);
        }
        if ((original = ProgressManager.getInstance().getProgressIndicator()) != null) {
            if (original.isCanceled()) {
                return true;
            }
            original.setText(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
        }
        if (UnusedPropertyInspection.isImplicitlyUsed(property)) {
            return true;
        }
        String name = property.getName();
        if (name == null) {
            return true;
        }
        PsiSearchHelper searchHelper = helper.getSearchHelper();
        if (UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, helper.getOwnUseScope(), isOnTheFly)) {
            return true;
        }
        GlobalSearchScope globalSearchScope = widerScope = isOnTheFly ? UnusedPropertyInspection.getWidestUseScope(property.getKey(), property.getProject(), helper.getModule()) : GlobalSearchScope.projectScope((Project)property.getProject());
        return widerScope != null && UnusedPropertyInspection.mayHaveUsages((PsiElement)property, name, searchHelper, widerScope, isOnTheFly);
    }

    private static boolean mayHaveUsages(@NotNull PsiElement property, @NotNull String name, @NotNull PsiSearchHelper psiSearchHelper, @NotNull GlobalSearchScope searchScope, boolean onTheFly) {
        if (property == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(14);
        }
        if (name == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(15);
        }
        if (psiSearchHelper == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(16);
        }
        if (searchScope == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(17);
        }
        GlobalSearchScope exceptPropertyFiles = UnusedPropertyInspection.createExceptPropertyFilesScope(searchScope);
        GlobalSearchScope newScope = searchScope.intersectWith(exceptPropertyFiles);
        if (onTheFly) {
            PsiSearchHelper.SearchCostResult cheapEnough = psiSearchHelper.isCheapEnoughToSearch(name, newScope, null);
            if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                return false;
            }
            if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return true;
            }
        }
        return ReferencesSearch.search((PsiElement)property, (SearchScope)newScope, (boolean)false).findFirst() != null;
    }

    @NotNull
    private static GlobalSearchScope createExceptPropertyFilesScope(@NotNull GlobalSearchScope origin) {
        if (origin == null) {
            UnusedPropertyInspection.$$$reportNull$$$0(18);
        }
        return new DelegatingGlobalSearchScope(origin){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return super.contains(file) && !FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PropertiesFileType.INSTANCE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/codeInspection/unused/UnusedPropertyInspection$2", "contains"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/codeInspection/unused/UnusedPropertyInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownModule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiSearchHelper";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/codeInspection/unused/UnusedPropertyInspection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWidestUseScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBeingCommittedProperties";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitlyUsed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyUsed";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveUsages";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createExceptPropertyFilesScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }

    public static class UnusedPropertiesSearchHelper {
        private final GlobalSearchScope myOwnUseScope;
        private final Module myModule;
        private final PsiSearchHelper mySearchHelper;

        public UnusedPropertiesSearchHelper(Module module) {
            this.myOwnUseScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
            this.myModule = module;
            this.mySearchHelper = PsiSearchHelper.getInstance((Project)module.getProject());
        }

        public Module getModule() {
            return this.myModule;
        }

        GlobalSearchScope getOwnUseScope() {
            return this.myOwnUseScope;
        }

        PsiSearchHelper getSearchHelper() {
            return this.mySearchHelper;
        }
    }
}

