/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class GitLogFullRecord
extends GitLogRecord {
    @NotNull
    private final List<VcsFileStatusInfo> myStatusInfo;

    GitLogFullRecord(@NotNull Map<GitLogParser.GitLogOption, String> options, @NotNull List<VcsFileStatusInfo> statusInfo, boolean supportsRawBody) {
        if (options == null) {
            GitLogFullRecord.$$$reportNull$$$0(0);
        }
        if (statusInfo == null) {
            GitLogFullRecord.$$$reportNull$$$0(1);
        }
        super(options, supportsRawBody);
        this.myStatusInfo = statusInfo;
    }

    @NotNull
    private Collection<String> getPaths() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (VcsFileStatusInfo info : this.myStatusInfo) {
            result2.add(info.getFirstPath());
            if (info.getSecondPath() == null) continue;
            result2.add(info.getSecondPath());
        }
        LinkedHashSet<String> linkedHashSet = result2;
        if (linkedHashSet == null) {
            GitLogFullRecord.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    @NotNull
    List<VcsFileStatusInfo> getStatusInfos() {
        List<VcsFileStatusInfo> list = this.myStatusInfo;
        if (list == null) {
            GitLogFullRecord.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    List<FilePath> getFilePaths(@NotNull VirtualFile root) {
        if (root == null) {
            GitLogFullRecord.$$$reportNull$$$0(4);
        }
        ArrayList<FilePath> res = new ArrayList<FilePath>();
        String prefix = root.getPath() + "/";
        for (String strPath : this.getPaths()) {
            res.add(VcsUtil.getFilePath((String)(prefix + strPath), (boolean)false));
        }
        ArrayList<FilePath> arrayList = res;
        if (arrayList == null) {
            GitLogFullRecord.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    List<Change> parseChanges(@NotNull Project project, @NotNull VirtualFile vcsRoot) {
        if (project == null) {
            GitLogFullRecord.$$$reportNull$$$0(6);
        }
        if (vcsRoot == null) {
            GitLogFullRecord.$$$reportNull$$$0(7);
        }
        String[] hashes = this.getParentsHashes();
        List<Change> list = GitChangesParser.parse(project, vcsRoot, this.myStatusInfo, this.getHash(), this.getDate(), hashes.length == 0 ? null : hashes[0]);
        if (list == null) {
            GitLogFullRecord.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public String toString() {
        return String.format("GitLogRecord{myOptions=%s, myStatusInfo=%s, mySupportsRawBody=%s, myHandler=%s}", this.myOptions, this.myStatusInfo, this.mySupportsRawBody, this.myHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusInfo";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogFullRecord";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogFullRecord";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusInfos";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFilePaths";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseChanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 8 -> new IllegalStateException(string);
        };
    }
}

