/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.info;

import com.intellij.ml.inline.completion.impl.diagnostic.AddCachedProposals;
import com.intellij.ml.inline.completion.impl.diagnostic.Analyzed;
import com.intellij.ml.inline.completion.impl.diagnostic.AnalyzedFilteringCompleted;
import com.intellij.ml.inline.completion.impl.diagnostic.ClientSelected;
import com.intellij.ml.inline.completion.impl.diagnostic.CloudFilterModel;
import com.intellij.ml.inline.completion.impl.diagnostic.CompletionInvoked;
import com.intellij.ml.inline.completion.impl.diagnostic.ContextMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.FilterModelMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.FilteredAnalyzed;
import com.intellij.ml.inline.completion.impl.diagnostic.FilteredRaw;
import com.intellij.ml.inline.completion.impl.diagnostic.Grouped;
import com.intellij.ml.inline.completion.impl.diagnostic.IncompatibleUxMode;
import com.intellij.ml.inline.completion.impl.diagnostic.Mapper;
import com.intellij.ml.inline.completion.impl.diagnostic.Mappings;
import com.intellij.ml.inline.completion.impl.diagnostic.ModelInferred;
import com.intellij.ml.inline.completion.impl.diagnostic.MultilineApplicability;
import com.intellij.ml.inline.completion.impl.diagnostic.PipelineStartsWith;
import com.intellij.ml.inline.completion.impl.diagnostic.ProposalForFilterModel;
import com.intellij.ml.inline.completion.impl.diagnostic.RawFilteringCompleted;
import com.intellij.ml.inline.completion.impl.diagnostic.ResultProposals;
import com.intellij.ml.inline.completion.impl.diagnostic.SessionMessagePayload;
import com.intellij.ml.inline.completion.impl.diagnostic.SilentCompletion;
import com.intellij.ml.inline.completion.impl.diagnostic.SkipReason;
import com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.components.SideTabs;
import com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.info.MLCompletionContextPanel;
import com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.info.MLCompletionMappersPanel;
import com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.info.MLCompletionProposalsList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\b\u0010\u001b\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/info/CompletionsWindowTabs;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "tabsPanel", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/components/SideTabs;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "composedContext", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/info/MLCompletionContextPanel;", "modelInference", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/info/MLCompletionProposalsList;", "mappingStep", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/info/MLCompletionMappersPanel;", "grouping", "filteredRaw", "analyzed", "filteredAnalyzed", "filterModelProcessing", "resultProposals", "addMessage", "", "message", "Lcom/intellij/ml/inline/completion/impl/diagnostic/SessionMessagePayload;", "dispose", "intellij.ml.inline.completion"})
public final class CompletionsWindowTabs
implements Disposable {
    @NotNull
    private final SideTabs tabsPanel;
    @NotNull
    private final JComponent component;
    @NotNull
    private final MLCompletionContextPanel composedContext;
    @NotNull
    private final MLCompletionProposalsList modelInference;
    @NotNull
    private final MLCompletionMappersPanel mappingStep;
    @NotNull
    private final MLCompletionProposalsList grouping;
    @NotNull
    private final MLCompletionProposalsList filteredRaw;
    @NotNull
    private final MLCompletionProposalsList analyzed;
    @NotNull
    private final MLCompletionProposalsList filteredAnalyzed;
    @NotNull
    private final MLCompletionProposalsList filterModelProcessing;
    @NotNull
    private final MLCompletionProposalsList resultProposals;

    public CompletionsWindowTabs(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.tabsPanel = new SideTabs();
        this.component = this.tabsPanel.getComponent();
        this.composedContext = new MLCompletionContextPanel("Model context", this);
        this.modelInference = new MLCompletionProposalsList("Model inference", this);
        this.mappingStep = new MLCompletionMappersPanel("Transform proposals", this);
        this.grouping = new MLCompletionProposalsList("Group similar proposal", this);
        this.filteredRaw = new MLCompletionProposalsList("Simple filters", this);
        this.analyzed = new MLCompletionProposalsList("Advanced analysis", this);
        this.filteredAnalyzed = new MLCompletionProposalsList("Advanced filters", this);
        this.filterModelProcessing = new MLCompletionProposalsList("Local filter model", this);
        this.resultProposals = new MLCompletionProposalsList("Result", this);
        this.tabsPanel.insert(this.composedContext);
        this.tabsPanel.insert(this.modelInference);
        this.tabsPanel.insert(this.mappingStep);
        this.tabsPanel.insert(this.grouping);
        this.tabsPanel.insert(this.filteredRaw);
        this.tabsPanel.insert(this.analyzed);
        this.tabsPanel.insert(this.filteredAnalyzed);
        this.tabsPanel.insert(this.filterModelProcessing);
        this.tabsPanel.insert(this.resultProposals);
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @RequiresEdt
    public final void addMessage(@NotNull SessionMessagePayload message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        SessionMessagePayload sessionMessagePayload = message;
        if (!(sessionMessagePayload instanceof CompletionInvoked) && !(sessionMessagePayload instanceof ClientSelected)) {
            if (sessionMessagePayload instanceof ContextMessage) {
                this.composedContext.addContext((ContextMessage)message);
            } else if (sessionMessagePayload instanceof ModelInferred) {
                this.modelInference.addWholeStepTime-LRDsOJo(((ModelInferred)message).getDuration-UwyO8pc());
            } else if (sessionMessagePayload instanceof CloudFilterModel) {
                this.modelInference.addCloudFilterModelMessage((CloudFilterModel)message);
            } else if (sessionMessagePayload instanceof PipelineStartsWith) {
                this.modelInference.add(((PipelineStartsWith)message).getProposals(), ((PipelineStartsWith)message).getPreviewContext());
            } else if (sessionMessagePayload instanceof Mappings) {
                this.mappingStep.afterTransformations(((Mappings)message).getBefore(), ((Mappings)message).getAfter());
                this.mappingStep.addWholeStepTime-LRDsOJo(((Mappings)message).getDuration-UwyO8pc());
            } else if (sessionMessagePayload instanceof Mapper) {
                this.mappingStep.addMapper(((Mapper)message).getMapperDiagnostics());
            } else if (sessionMessagePayload instanceof Grouped) {
                this.grouping.addGroups(((Grouped)message).getGroups());
                this.grouping.addWholeStepTime-LRDsOJo(((Grouped)message).getDuration-UwyO8pc());
            } else if (sessionMessagePayload instanceof FilteredRaw) {
                this.filteredRaw.addFiltered(((FilteredRaw)message).getItems());
            } else if (sessionMessagePayload instanceof RawFilteringCompleted) {
                this.filteredRaw.addWholeStepTime-LRDsOJo(((RawFilteringCompleted)message).getDuration-UwyO8pc());
            } else if (sessionMessagePayload instanceof Analyzed) {
                this.analyzed.addAnalyzed(((Analyzed)message).getProposals());
                this.analyzed.addWholeStepTime-LRDsOJo(DurationKt.toDuration((long)((Analyzed)message).getDuration(), (DurationUnit)DurationUnit.MILLISECONDS));
            } else if (sessionMessagePayload instanceof FilteredAnalyzed) {
                this.filteredAnalyzed.addFiltered(((FilteredAnalyzed)message).getItems());
            } else if (sessionMessagePayload instanceof AnalyzedFilteringCompleted) {
                this.filteredAnalyzed.addWholeStepTime-LRDsOJo(((AnalyzedFilteringCompleted)message).getDuration-UwyO8pc());
            } else if (sessionMessagePayload instanceof ResultProposals) {
                MLCompletionProposalsList.add$default(this.resultProposals, ((ResultProposals)message).getProposals(), null, 2, null);
            } else if (!(sessionMessagePayload instanceof AddCachedProposals)) {
                if (sessionMessagePayload instanceof FilterModelMessage) {
                    this.filterModelProcessing.addFilterModelResponse((FilterModelMessage)message);
                    this.filterModelProcessing.addWholeStepTime-LRDsOJo(((FilterModelMessage)message).getDuration-UwyO8pc());
                } else if (!(sessionMessagePayload instanceof SkipReason || sessionMessagePayload instanceof SilentCompletion || sessionMessagePayload instanceof ProposalForFilterModel || sessionMessagePayload instanceof IncompatibleUxMode)) {
                    if (sessionMessagePayload instanceof MultilineApplicability) {
                        this.modelInference.addMultiLineResult(((MultilineApplicability)message).getResult());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
        this.tabsPanel.selectLastEnabled();
    }

    public void dispose() {
    }
}

