/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/performancePlugin/utils/NotificationUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "disableAllBalloonNotifications", "", "disableBalloonNotificationsByGroupIdPattern", "groupIdsPattern", "", "intellij.performanceTesting"})
public final class NotificationUtils {
    @NotNull
    public static final NotificationUtils INSTANCE = new NotificationUtils();
    @NotNull
    private static final Logger LOG;

    private NotificationUtils() {
    }

    @JvmStatic
    public static final void disableAllBalloonNotifications() {
        NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS = false;
    }

    @JvmStatic
    public static final void disableBalloonNotificationsByGroupIdPattern(@NotNull String groupIdsPattern) {
        Intrinsics.checkNotNullParameter((Object)groupIdsPattern, (String)"groupIdsPattern");
        NotificationsConfiguration conf = NotificationsConfiguration.getNotificationsConfiguration();
        Regex regex = new Regex(groupIdsPattern);
        if (conf instanceof NotificationsConfigurationImpl) {
            Object[] allSettings = ((NotificationsConfigurationImpl)conf).getAllSettings();
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])allSettings);
            while (iterator2.hasNext()) {
                NotificationSettings setting = (NotificationSettings)iterator2.next();
                if (!regex.matches((CharSequence)setting.getGroupId())) continue;
                LOG.info("Disable notification group " + setting.getGroupId());
                ((NotificationsConfigurationImpl)conf).changeSettings(NotificationSettings.copy$default((NotificationSettings)setting, null, (NotificationDisplayType)NotificationDisplayType.NONE, (boolean)false, (boolean)false, (boolean)false, (int)29, null));
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(NotificationUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

