\page ExampleB4 Example B4

 This example simulates a simple Sampling Calorimeter setup.
 To demonstrate several possible ways of data scoring, the example
 is provided in four variants: %B4a, %B4b, %B4c, %B4d.
 (See also examples/extended/electromagnetic/TestEm3 or hadronic/Hadr05)

## GEOMETRY DEFINITION

   The geometry is constructed in B4::DetectorConstruction class
   (see also
    \link B4c::DetectorConstruction B4c \endlink,
    \link B4d::DetectorConstruction B4d \endlink variants).
   The calorimeter is a box made of a given number of layers. A layer
   consists of an absorber plate and of a detection gap. The layer is
   replicated.

   Four parameters define the geometry of the calorimeter :
    - the thickness of an absorber plate,
    - the thickness of a  gap,
    - the number of layers, and
    - the transverse size of the calorimeter (the entrance face is a square).

   In addition, a global, uniform, and transverse magnetic field can be
   applied using G4GlobalMagFieldMessenger, instantiated in
     B4::DetectorConstruction::ConstructSDandField()
    (see also
    \link B4c::DetectorConstruction::ConstructSDandField() B4c \endlink,
    \link B4d::DetectorConstruction::ConstructSDandField() B4d \endlink variants)
   with a non zero field value, or via interactive commands.
   For example:

```
/globalField/setValue 0.2 0 0 tesla
```

<pre>
        |<----layer 0---------->|<----layer 1---------->|<----layer 2---------->|
        |                       |                       |                       |
        ==========================================================================
        ||              |       ||              |       ||              |       ||
        ||              |       ||              |       ||              |       ||
 beam   ||   absorber   |  gap  ||   absorber   |  gap  ||   absorber   |  gap  ||
======> ||              |       ||              |       ||              |       ||
        ||              |       ||              |       ||              |       ||
        ==========================================================================

</pre>

   A more general version of this geometry can be found in:
   examples/extended/electromagnetic/TestEm3 or hadronic/Hadr05
   where all the geometry parameters, the absorber and gap materials
   can be modified interactively via the commands defined in the DetectorMessenger
   class.

## PHYSICS LIST

   The particle's type and the physic processes which will be available
   in this example are set in the FTFP_BERT physics list. This physics list
   requires data files for electromagnetic and hadronic processes.
   See more on installation of the datasets in
   <a href="http://geant4.web.cern.ch/geant4/UserDocumentation/UsersGuides/InstallationGuide/html/ch03s03.html">
   Geant4 Installation Guide, Chapter 3.3: Note On Geant4 Datasets </a>.
   The following datasets: G4LEDATA, G4LEVELGAMMADATA, G4SAIDXSDATA and
   G4ENSDFSTATEDATA are mandatory for this example.

   In addition the build-in interactive command:
```
/process/(in)activate processName
```
   allows to activate/inactivate the processes one by one.

## ACTION INITALIZATION

   A newly introduced class, B4a::ActionInitialization, (see also
    \link B4b::ActionInitialization B4b \endlink,
    \link B4c::ActionInitialization B4c \endlink,
    \link B4d::ActionInitialization B4d \endlink variants),
   instantiates and registers to Geant4 kernel all user action classes;

   While in sequential mode the action classes are instatiated just once,
   via invoking the method:
      B4a::ActionInitialization::Build()
   (see also
    \link B4b::ActionInitialization::Build() B4b \endlink,
    \link B4c::ActionInitialization::Build() B4c \endlink,
    \link B4d::ActionInitialization::Build() B4d \endlink variants),
   in multi-threading mode the same method is invoked for each thread worker
   and so all user action classes are defined thread-local.

    A run action class is instantiated both thread-local
   and global that's why its instance is created also in the method
      B4a::ActionInitialization::BuildForMaster()
   (see also
    \link B4b::ActionInitialization::BuildForMaster() B4b \endlink,
    \link B4c::ActionInitialization::BuildForMaster() B4c \endlink,
    \link B4d::ActionInitialization::BuildForMaster() B4d \endlink variants),
   which is invoked only in multi-threading mode.

## PRIMARY GENERATOR

   The primary beam consists of a single particle which hits the
   calorimeter perpendicular to the input face. The type of the particle
   and its energy are set in the B4::PrimaryGeneratorAction class, and can
   be changed via the G4 built-in commands of the G4ParticleGun class (see
   the macros provided with this example).

## RUNS and EVENTS

   A run is a set of events.

   The user can choose the frequency of printing via the Geant4 interactive
   command, for example:
```
/run/printProgress 100
```

## DETECTOR RESPONSE

   The energy deposit and track lengths of the charged particles are recorded on
   an event by event basis in the Absober and Gap layers.

   In order to demonstrate several possible ways of data scoring,
   the example is provided in four variants:

### Variant a: User Actions

   These 4 quantities are data members of the B4a::EventAction class.
   They are collected step by step in
   B4a::SteppingAction::UserSteppingAction(), and passed to the event action
   via two methods: B4a::EventAction::AddAbs() and B4a::EventAction::AddGap().

   In B4a::EventAction::EndOfEventAction(), these quantities are printed and
   filled in H1D histograms and ntuple to accumulate statistic and compute
   dispersion.

### Variant b: User data object

   In order to avoid dependencies between action classes, a user object
   B4b::RunData, derived from G4Run, is defined with data members needed
   for the accounted information.
   In order to reduce the number of data members a 2-dimensions array
   is introduced for each quantity.
   Then the quantities are collected step by step in user action classes:
   B4b::SteppingAction::UserSteppingAction() and
   B4b::EventAction::EndOfEventAction() in a similar way as in variant a.

### Variant c: Hits and Sensitive detectors

   In this option, the physics quantities are accounted using the hits
   and sensitive detectors framework defined in the Geant4 kernel.
   The physics quantities are stored in B4c::CalorHit via two B4c::CalorimeterSD
   objects, one associated with the Absorber volume and another one with Gap
   in B4c::DetectorConstruction::ConstructSDandField().

   In contrary to the B2 example (Tracker) where a new hit is created
   with each track passing the sensitive volume (in the calorimeter), only one
   hit is created for each calorimeter layer and one more hit to account for
   the total quantities in all layers. In addition to the variants a and b,
   the quantities per each layer are also available in addition to the total
   quantities.

### Variant d: Scorer

   In this option, the Geant4 scorers which are defined on the top of hits
   and sensitive detectors Geant4 framework are used.
   In practice this means that the user does not need to define hits and sensitive
   detector classes but rather uses the classes already defined
   in Geant4. In this example, the G4MultiFunctionalDetector with
   G4PSEnergyDeposit and G4PSTrackLength primitive scores are used (see
   B4d::DetectorConstruction::ConstructSDandField()).

   The scorers hits are saved in form of ntuples in a Root file using Geant4
   analysis tools. This feature is activated in the main() function with instantiating
   G4TScoreNtupleWriter.

   Also with this approach, the quantities per each layer are available
   in addition to the total quantities.

## HISTOGRAMS

   The analysis tools are used to accumulate statistics and compute the dispersion
   of the energy deposit and track lengths of the charged particles.
   H1D histograms are created in B4::RunAction::RunAction() (see also
   \link B4b::RunAction::RunAction() B4b \endlink variant) for the
   following quantities:
   - Energy deposit in absorber
   - Energy deposit in gap
   - Track length in absorber
   - Track length in gap

   The same values are also saved in an ntuple.

   The histograms and the ntuple are saved in the output file in a format
   according to a specified file extension, the default in this example
   is ROOT.

   The accumulated statistic and computed dispersion is printed at the end of
   run, in B4::RunAction::EndOfRunAction() ((see also
   \link B4b::RunAction::EndOfRunAction() B4b \endlink variant).
   When running in multi-threading mode, the histograms and the ntuple accumulated
   on threads are merged in a single output file. While merging of histograms is
   performed by default, merging of ntuples is explicitly activated in the B4::RunAction
   constructor.

   The ROOT histograms and ntuple can be plotted with ROOT using the plotHisto.C
   and plotNtuple.C macros.

## HOW TO RUN

   This example handles the program arguments in a new way.
   It can be run with the following optional arguments:
```
% exampleB4a [-m macro ] [-u UIsession] [-t nThreads] [-vDefault]
```

   The -vDefault option will activate using the default Geant4 stepping verbose
   class (G4SteppingVerbose) instead of the enhanced stepping verbose with best
   units (G4SteppingVerboseWithUnits) used in the example by default.

   The -t option is available only in multi-threading mode
   and it allows the user to override the Geant4 default number of
   threads. The number of threads can be also set via G4FORCENUMBEROFTHREADS
   environment variable which has the top priority.

   - Execute exampleB4a in the 'interactive mode' with visualization
```
% exampleB4a
and type in the commands from run1.mac line by line:
Idle> /tracking/verbose 1
Idle> /run/beamOn 1
Idle> ...
Idle> exit
```
     or
```
Idle> /control/execute run1.mac
....
Idle> exit
```

   - Execute exampleB4a in the 'batch' mode from macro files
     (without visualization)
```
% exampleB4a -m run2.mac
% exampleB4a -m exampleB4.in > exampleB4.out
```

   - Execute exampleB4a in the 'interactive mode' with a selected UI session,
     e.g. tcsh
```
% exampleB4a -u tcsh
```

<hr>

The following paragraphs are common to all basic examples

## VISUALISATION

   The visualization manager is set via the G4VisExecutive class
   in the main() function in exampleB4a.cc  (or exampleB4b.cc,  exampleB4c.cc,
   exampleB4d.cc).
   The initialisation of the drawing is done via a set of /vis/ commands
   in the macro vis.mac. This macro is automatically read from
   the main function when the example is used in interactive running mode.

   By default, vis.mac opens the default viewer (/vis/open).
   This chooses a graphics system (in order of priority):
   - by argument in G4VisExecutive construction.
   - by environment variable, G4VIS_DEFAULT_DRIVER.
   - by information in ~/.g4session.
   - by mode (batch/interactive) and if interactive, by your build flags.

   The user can change the initial viewer
   - with environment variable G4VIS_DEFAULT_DRIVER. The format is
     ```
     <graphics-system> [<window-size-hint>]
     ```
     Set this, e.g:
     - (bash) export G4VIS_DEFAULT_DRIVER=TSG
     - (tcsh) setenv G4VIS_DEFAULT_DRIVER OI
       - The window-size-hint can optionally be added, e.g:
       - (bash) export G4VIS_DEFAULT_DRIVER="RayTracerQt 1000x1000-0+0"
   - on the command line, precede the app invocation, e.g:
     - ```
       G4VIS_DEFAULT_DRIVER=Vtk ./<application-name>
       ```
   - with ~/.g4session.

   For other suggestions for G4VIS_DEFAULT_DRIVER (see list of registered
   graphics systems printed at the start):
   - DAWNFILE: to create a .prim file suitable for viewing in DAWN.
   - VRML2FILE: to create a .wrl file suitable for viewing in a VRML viewer.
   - "TSG_OFFSCREEN 1200x1200": to create an image file with TSG.
     - See the tsg_offscreen.mac in examples/basic/B5 for more commands
       to change the file format, file name, picture size, etc.

   See "Choosing a graphics viewer" in the Application Guide for details.

   Of course you can change the viewer by editing the /vis/open line in vis.mac.

   Also, after the initial viewer opens, you may open a different viewer by typing
   on the command line, e.g:
```
/vis/open DAWNFILE
```
   or
```
/vis/open RayTraceQt
```
   (if you are using the Qt GUI).

   The view parameters of the existing viewer are copied.

   The DAWNFILE and similar drivers are always available
   (since they require no external libraries), but the OGL driver requires
   that the Geant4 libraries have been built with the OpenGL option.

## USER INTERFACES

   The user command interface is set via the G4UIExecutive class
   in the main() function in exampleB4a.cc

   The selection of the user command interface is then done automatically
   according to the Geant4 configuration or it can be done explicitly via
   the third argument of the G4UIExecutive constructor (see exampleB4a.cc).

   The gui.mac macros are provided in examples B2, B4 and B5. This macro
   is automatically executed if Geant4 is built with any GUI session.
   It is also possible to customise the icons menu bar which is
   demonstrated in the icons.mac macro in example B5.


