//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file G4EmPenelopePhysicsMI.hh
/// \brief Definition of the G4EmPenelopePhysicsMI class

// customized by gpaterno for MI in Rayleigh Scattering, March 2019

#ifndef G4EmPenelopePhysicsMI_h
#define G4EmPenelopePhysicsMI_h 1

#include "G4EmParticleList.hh"
#include "G4VPhysicsConstructor.hh"
#include "globals.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

class G4EmPenelopePhysicsMI : public G4VPhysicsConstructor
{
  public:
    explicit G4EmPenelopePhysicsMI(G4int ver = 1, const G4String& name = "", G4bool useMI = true);

    virtual ~G4EmPenelopePhysicsMI();

    virtual void ConstructParticle();
    virtual void ConstructProcess();

  private:
    G4int fVerbose;
    G4EmParticleList fPartList;
    G4bool fUseMIFlag;
};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#endif
