//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file TrackingMessenger.cc
/// \brief Implementation of the TrackingMessenger class

#include "TrackingMessenger.hh"

#include "TrackingAction.hh"

#include "G4UIcmdWithABool.hh"
#include "G4UIdirectory.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

TrackingMessenger::TrackingMessenger(TrackingAction* trackA) : fTrackingAction(trackA)
{
  fTrackingDir = new G4UIdirectory("/testhadr/tracking/");
  fTrackingDir->SetGuidance("tracking commands");

  fCountCmd = new G4UIcmdWithABool("/testhadr/tracking/countParticles", this);
  fCountCmd->SetGuidance("count created particles");
  fCountCmd->SetParameterName("flag", false);
  fCountCmd->SetDefaultValue(true);
  fCountCmd->AvailableForStates(G4State_PreInit, G4State_Idle);

  fKillCmd = new G4UIcmdWithABool("/testhadr/tracking/killNeutrons", this);
  fKillCmd->SetGuidance("kill secondaries neutrons");
  fKillCmd->SetParameterName("flag", false);
  fKillCmd->SetDefaultValue(false);
  fKillCmd->AvailableForStates(G4State_PreInit, G4State_Idle);
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

TrackingMessenger::~TrackingMessenger()
{
  delete fCountCmd;
  delete fKillCmd;
  delete fTrackingDir;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void TrackingMessenger::SetNewValue(G4UIcommand* command, G4String newValue)
{
  if (command == fCountCmd) {
    fTrackingAction->SetParticleCount(fCountCmd->GetNewBoolValue(newValue));
  }

  if (command == fKillCmd) {
    fTrackingAction->SetKillNeutrons(fKillCmd->GetNewBoolValue(newValue));
  }
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
