/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.javamodularity.moduleplugin.shadow.javaparser.Position;
import org.javamodularity.moduleplugin.shadow.javaparser.Range;
import org.javamodularity.moduleplugin.shadow.javaparser.StaticJavaParser;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.CompilationUnit;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.ImportDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.PackageDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.MethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.VariableDeclarator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodCallExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.Statement;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.SwitchEntry;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Navigator;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;

public class SourceFileInfoExtractor {
    private final TypeSolver typeSolver;
    private int successes = 0;
    private int failures = 0;
    private int unsupported = 0;
    private boolean printFileName = true;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private boolean verbose = false;

    public SourceFileInfoExtractor(TypeSolver typeSolver) {
        this.typeSolver = typeSolver;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setPrintFileName(boolean printFileName) {
        this.printFileName = printFileName;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getUnsupported() {
        return this.unsupported;
    }

    public int getFailures() {
        return this.failures;
    }

    private void solveTypeDecl(ClassOrInterfaceDeclaration node) {
        ResolvedReferenceTypeDeclaration typeDeclaration = JavaParserFacade.get(this.typeSolver).getTypeDeclaration(node);
        if (typeDeclaration.isClass()) {
            this.out.println("\n[ Class " + typeDeclaration.getQualifiedName() + " ]");
            for (ResolvedReferenceType sc : typeDeclaration.asClass().getAllSuperClasses()) {
                this.out.println("  superclass: " + sc.getQualifiedName());
            }
            for (ResolvedReferenceType sc : typeDeclaration.asClass().getAllInterfaces()) {
                this.out.println("  interface: " + sc.getQualifiedName());
            }
        }
    }

    private void solve(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            this.solveTypeDecl((ClassOrInterfaceDeclaration)node);
        } else if (node instanceof Expression) {
            Node parentNode = Navigator.demandParentNode(node);
            if (parentNode instanceof ImportDeclaration || parentNode instanceof Expression || parentNode instanceof MethodDeclaration || parentNode instanceof PackageDeclaration) {
                return;
            }
            if (parentNode instanceof Statement || parentNode instanceof VariableDeclarator || parentNode instanceof SwitchEntry) {
                try {
                    ResolvedType ref = JavaParserFacade.get(this.typeSolver).getType(node);
                    this.out.println("  Line " + this.lineNr(node) + ") " + node + " ==> " + ref.describe());
                    ++this.successes;
                }
                catch (UnsupportedOperationException upe) {
                    ++this.unsupported;
                    this.err.println(upe.getMessage());
                    throw upe;
                }
                catch (RuntimeException re) {
                    ++this.failures;
                    this.err.println(re.getMessage());
                    throw re;
                }
            }
        }
    }

    private void solveMethodCalls(Node node) {
        if (node instanceof MethodCallExpr) {
            this.out.println("  Line " + this.lineNr(node) + ") " + node + " ==> " + this.toString((MethodCallExpr)node));
        }
        for (Node child : node.getChildNodes()) {
            this.solveMethodCalls(child);
        }
    }

    private String toString(MethodCallExpr node) {
        try {
            return this.toString(JavaParserFacade.get(this.typeSolver).solve(node));
        }
        catch (Exception e) {
            if (this.verbose) {
                System.err.println("Error resolving call at L" + this.lineNr(node) + ": " + node);
                e.printStackTrace();
            }
            return "ERROR";
        }
    }

    private String toString(SymbolReference<ResolvedMethodDeclaration> methodDeclarationSymbolReference) {
        if (methodDeclarationSymbolReference.isSolved()) {
            return methodDeclarationSymbolReference.getCorrespondingDeclaration().getQualifiedSignature();
        }
        return "UNSOLVED";
    }

    private List<Node> collectAllNodes(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        node.walk(nodes::add);
        nodes.sort(Comparator.comparing((Function<Node, Position> & Serializable)n -> n.getBegin().get()));
        return nodes;
    }

    public void solve(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".java")) {
                    if (SourceFileInfoExtractor.this.printFileName) {
                        SourceFileInfoExtractor.this.out.println("- parsing " + file.toAbsolutePath());
                    }
                    CompilationUnit cu = StaticJavaParser.parse(file);
                    List nodes = SourceFileInfoExtractor.this.collectAllNodes(cu);
                    nodes.forEach((Consumer<Node> & Serializable)n -> SourceFileInfoExtractor.this.solve(n));
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void solveMethodCalls(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".java")) {
                    if (SourceFileInfoExtractor.this.printFileName) {
                        SourceFileInfoExtractor.this.out.println("- parsing " + file.toAbsolutePath());
                    }
                    CompilationUnit cu = StaticJavaParser.parse(file);
                    SourceFileInfoExtractor.this.solveMethodCalls(cu);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private int lineNr(Node node) {
        return (Integer)node.getRange().map((Function<Range, Integer> & Serializable)range -> range.begin.line).orElseThrow(IllegalStateException::new);
    }
}

