/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.FunctionalInterfaceLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.NullType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionTypeParameter;

class ReflectionClassAdapter {
    private Class<?> clazz;
    private TypeSolver typeSolver;
    private ResolvedReferenceTypeDeclaration typeDeclaration;

    public ReflectionClassAdapter(Class<?> clazz, TypeSolver typeSolver, ResolvedReferenceTypeDeclaration typeDeclaration) {
        this.clazz = clazz;
        this.typeSolver = typeSolver;
        this.typeDeclaration = typeDeclaration;
    }

    public Optional<ReferenceTypeImpl> getSuperClass() {
        if (this.clazz.getGenericSuperclass() == null) {
            return Optional.empty();
        }
        Type superType = this.clazz.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)superType;
            List<ResolvedType> typeParameters = Arrays.stream(parameterizedType.getActualTypeArguments()).map((Function<Type, ResolvedType> & Serializable)t -> ReflectionFactory.typeUsageFor(t, this.typeSolver)).collect(Collectors.toList());
            return Optional.of(new ReferenceTypeImpl(new ReflectionClassDeclaration(this.clazz.getSuperclass(), this.typeSolver), typeParameters));
        }
        return Optional.of(new ReferenceTypeImpl(new ReflectionClassDeclaration(this.clazz.getSuperclass(), this.typeSolver)));
    }

    public List<ResolvedReferenceType> getInterfaces() {
        ArrayList<ResolvedReferenceType> interfaces = new ArrayList<ResolvedReferenceType>();
        for (Type superInterface : this.clazz.getGenericInterfaces()) {
            if (superInterface instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)superInterface;
                List<ResolvedType> typeParameters = Arrays.stream(parameterizedType.getActualTypeArguments()).map((Function<Type, ResolvedType> & Serializable)t -> ReflectionFactory.typeUsageFor(t, this.typeSolver)).collect(Collectors.toList());
                interfaces.add(new ReferenceTypeImpl(new ReflectionInterfaceDeclaration((Class)((ParameterizedType)superInterface).getRawType(), this.typeSolver), typeParameters));
                continue;
            }
            interfaces.add(new ReferenceTypeImpl(new ReflectionInterfaceDeclaration((Class)superInterface, this.typeSolver)));
        }
        return interfaces;
    }

    public List<ResolvedReferenceType> getAncestors() {
        LinkedList<ResolvedReferenceType> ancestors = new LinkedList<ResolvedReferenceType>();
        if (this.typeDeclaration.isClass() && !Object.class.getCanonicalName().equals(this.clazz.getCanonicalName())) {
            if (this.getSuperClass().isPresent()) {
                ReferenceTypeImpl superClass = this.getSuperClass().get();
                ancestors.add(superClass);
            } else {
                ReferenceTypeImpl object = new ReferenceTypeImpl(new ReflectionClassDeclaration(Object.class, this.typeSolver));
                ancestors.add(object);
            }
        }
        ancestors.addAll(this.getInterfaces());
        return ancestors;
    }

    public ResolvedFieldDeclaration getField(String name) {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return new ReflectionFieldDeclaration(field, this.typeSolver);
        }
        for (ResolvedReferenceType ancestor : this.typeDeclaration.getAllAncestors()) {
            ResolvedReferenceTypeDeclaration typeDeclaration;
            if (!ancestor.getTypeDeclaration().isPresent() || !(typeDeclaration = ancestor.getTypeDeclaration().get()).hasField(name)) continue;
            ReflectionFieldDeclaration reflectionFieldDeclaration = (ReflectionFieldDeclaration)typeDeclaration.getField(name);
            return reflectionFieldDeclaration.replaceType(ancestor.getFieldType(name).get());
        }
        throw new UnsolvedSymbolException(name, "Field in " + this);
    }

    public boolean hasField(String name) {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        for (ResolvedReferenceType ancestor : this.typeDeclaration.getAllAncestors()) {
            if (!ancestor.getTypeDeclaration().isPresent() || !ancestor.getTypeDeclaration().get().hasField(name)) continue;
            return true;
        }
        return false;
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        ArrayList<ResolvedFieldDeclaration> fields = new ArrayList<ResolvedFieldDeclaration>();
        for (Field field : this.clazz.getDeclaredFields()) {
            fields.add(new ReflectionFieldDeclaration(field, this.typeSolver));
        }
        for (ResolvedReferenceType ancestor : this.typeDeclaration.getAllAncestors()) {
            ancestor.getTypeDeclaration().ifPresent((Consumer<ResolvedReferenceTypeDeclaration> & Serializable)ancestorTypeDeclaration -> fields.addAll(ancestorTypeDeclaration.getAllFields()));
        }
        return fields;
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return Arrays.stream(this.clazz.getDeclaredMethods()).filter((Predicate<Method> & Serializable)m -> !m.isSynthetic() && !m.isBridge()).map((Function<Method, ReflectionMethodDeclaration> & Serializable)m -> new ReflectionMethodDeclaration((Method)m, this.typeSolver)).collect(Collectors.toSet());
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        ArrayList<ResolvedTypeParameterDeclaration> params = new ArrayList<ResolvedTypeParameterDeclaration>();
        for (TypeVariable<Class<?>> tv : this.clazz.getTypeParameters()) {
            params.add(new ReflectionTypeParameter(tv, true, this.typeSolver));
        }
        return params;
    }

    public boolean isAssignableBy(ResolvedType type) {
        ReferenceTypeImpl otherTypeDeclaration;
        if (type instanceof NullType) {
            return true;
        }
        if (type instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (type.isArray()) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.describe().equals(this.typeDeclaration.getQualifiedName())) {
            return true;
        }
        if (type instanceof ReferenceTypeImpl && (otherTypeDeclaration = (ReferenceTypeImpl)type).getTypeDeclaration().isPresent()) {
            return otherTypeDeclaration.getTypeDeclaration().get().canBeAssignedTo(this.typeDeclaration);
        }
        return false;
    }

    public boolean hasDirectlyAnnotation(String canonicalName) {
        for (Annotation a : this.clazz.getDeclaredAnnotations()) {
            if (!a.annotationType().getCanonicalName().equals(canonicalName)) continue;
            return true;
        }
        return false;
    }

    private final boolean isFunctionalInterface() {
        return FunctionalInterfaceLogic.getFunctionalMethod(this.typeDeclaration).isPresent();
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return Arrays.stream(this.clazz.getDeclaredConstructors()).filter((Predicate<Constructor> & Serializable)m -> !m.isSynthetic()).map((Function<Constructor, ReflectionConstructorDeclaration> & Serializable)m -> new ReflectionConstructorDeclaration((Constructor<?>)m, this.typeSolver)).collect(Collectors.toList());
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        Class<?> declaringClass = this.clazz.getDeclaringClass();
        return declaringClass == null ? Optional.empty() : Optional.of(ReflectionFactory.typeDeclarationFor(declaringClass, this.typeSolver));
    }
}

