/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.MethodResolutionLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedTypeVariable;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionMethodDeclaration;

class ReflectionMethodResolutionLogic {
    ReflectionMethodResolutionLogic() {
    }

    static SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> parameterTypes, boolean staticOnly, TypeSolver typeSolver, ResolvedReferenceTypeDeclaration scopeType, Class clazz) {
        ArrayList<ResolvedMethodDeclaration> methods = new ArrayList<ResolvedMethodDeclaration>();
        Predicate<Method> & Serializable staticOnlyCheck = (Predicate<Method> & Serializable)m -> !staticOnly || staticOnly && Modifier.isStatic(m.getModifiers());
        for (Method method : clazz.getMethods()) {
            if (method.isBridge() || method.isSynthetic() || !method.getName().equals(name) || !staticOnlyCheck.test(method)) continue;
            ReflectionMethodDeclaration methodDeclaration = new ReflectionMethodDeclaration(method, typeSolver);
            methods.add(methodDeclaration);
        }
        for (ResolvedReferenceType ancestor : scopeType.getAncestors()) {
            ancestor.getTypeDeclaration().ifPresent((Consumer<ResolvedReferenceTypeDeclaration> & Serializable)ancestorTypeDeclaration -> {
                SymbolReference<ResolvedMethodDeclaration> ref = MethodResolutionLogic.solveMethodInType(ancestorTypeDeclaration, name, parameterTypes, staticOnly);
                if (ref.isSolved()) {
                    methods.add(ref.getCorrespondingDeclaration());
                }
            });
        }
        if (scopeType.getAncestors().isEmpty()) {
            ReferenceTypeImpl objectClass = new ReferenceTypeImpl(new ReflectionClassDeclaration(Object.class, typeSolver));
            objectClass.getTypeDeclaration().ifPresent((Consumer<ResolvedReferenceTypeDeclaration> & Serializable)objectTypeDeclaration -> {
                SymbolReference<ResolvedMethodDeclaration> ref = MethodResolutionLogic.solveMethodInType(objectTypeDeclaration, name, parameterTypes, staticOnly);
                if (ref.isSolved()) {
                    methods.add(ref.getCorrespondingDeclaration());
                }
            });
        }
        return MethodResolutionLogic.findMostApplicable(methods, name, parameterTypes, typeSolver);
    }

    static Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, Context invokationContext, List<ResolvedType> typeParameterValues, ResolvedReferenceTypeDeclaration scopeType, Class clazz) {
        SymbolReference<ResolvedMethodDeclaration> ref;
        Optional<ResolvedReferenceTypeDeclaration> optionalObjectClass;
        if (typeParameterValues.size() != scopeType.getTypeParameters().size() && !scopeType.getTypeParameters().isEmpty()) {
            typeParameterValues = new ArrayList<ResolvedType>();
            for (int i = 0; i < scopeType.getTypeParameters().size(); ++i) {
                typeParameterValues.add(new ReferenceTypeImpl(new ReflectionClassDeclaration(Object.class, typeSolver)));
            }
        }
        ArrayList<MethodUsage> methods = new ArrayList<MethodUsage>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || method.isBridge() || method.isSynthetic()) continue;
            ReflectionMethodDeclaration methodDeclaration = new ReflectionMethodDeclaration(method, typeSolver);
            MethodUsage methodUsage = ReflectionMethodResolutionLogic.replaceParams(typeParameterValues, scopeType, methodDeclaration);
            methods.add(methodUsage);
        }
        List<ResolvedReferenceType> ancestors = scopeType.getAncestors();
        for (ResolvedReferenceType ancestor : ancestors) {
            ResolvedReferenceTypeDeclaration ancestorTypeDeclaration;
            SymbolReference<ResolvedMethodDeclaration> ref2;
            if (!ancestor.getTypeDeclaration().isPresent() || !(ref2 = MethodResolutionLogic.solveMethodInType(ancestorTypeDeclaration = ancestor.getTypeDeclaration().get(), name, argumentsTypes)).isSolved()) continue;
            ResolvedMethodDeclaration correspondingDeclaration = ref2.getCorrespondingDeclaration();
            MethodUsage methodUsage = ReflectionMethodResolutionLogic.replaceParams(typeParameterValues, ancestorTypeDeclaration, correspondingDeclaration);
            methods.add(methodUsage);
        }
        if (ancestors.isEmpty() && (optionalObjectClass = new ReferenceTypeImpl(new ReflectionClassDeclaration(Object.class, typeSolver)).getTypeDeclaration()).isPresent() && (ref = MethodResolutionLogic.solveMethodInType(optionalObjectClass.get(), name, argumentsTypes)).isSolved()) {
            MethodUsage usage = ReflectionMethodResolutionLogic.replaceParams(typeParameterValues, optionalObjectClass.get(), ref.getCorrespondingDeclaration());
            methods.add(usage);
        }
        List<ResolvedType> finalTypeParameterValues = typeParameterValues;
        argumentsTypes = argumentsTypes.stream().map((Function<ResolvedType, ResolvedType> & Serializable)pt -> {
            int i = 0;
            for (ResolvedTypeParameterDeclaration tp : scopeType.getTypeParameters()) {
                pt = pt.replaceTypeVariables(tp, (ResolvedType)finalTypeParameterValues.get(i));
                ++i;
            }
            return pt;
        }).collect(Collectors.toList());
        return MethodResolutionLogic.findMostApplicableUsage(methods, name, argumentsTypes, typeSolver);
    }

    private static MethodUsage replaceParams(List<ResolvedType> typeParameterValues, ResolvedReferenceTypeDeclaration typeParametrizable, ResolvedMethodDeclaration methodDeclaration) {
        MethodUsage methodUsage = new MethodUsage(methodDeclaration);
        int i = 0;
        if (typeParameterValues.size() == typeParametrizable.getTypeParameters().size()) {
            for (ResolvedTypeParameterDeclaration tp : typeParametrizable.getTypeParameters()) {
                methodUsage = methodUsage.replaceTypeParameter(tp, typeParameterValues.get(i));
                ++i;
            }
        }
        for (ResolvedTypeParameterDeclaration methodTypeParameter : methodDeclaration.getTypeParameters()) {
            methodUsage = methodUsage.replaceTypeParameter(methodTypeParameter, new ResolvedTypeVariable(methodTypeParameter));
        }
        return methodUsage;
    }
}

