/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.daterange;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Objects;

public class DateRange {
    private String title;
    private LocalDate startDate;
    private LocalDate endDate;

    public DateRange(String title, LocalDate startDate, LocalDate endDate) {
        this.title = title;
        this.startDate = Objects.requireNonNull(startDate);
        this.endDate = Objects.requireNonNull(endDate);
    }

    public DateRange(LocalDate startDate, LocalDate endDate) {
        this(null, startDate, endDate);
    }

    public DateRange(String title, LocalDate date) {
        this(title, date, date);
    }

    public DateRange(LocalDate date) {
        this(date, date);
    }

    public String getTitle() {
        return this.title;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public String toString() {
        if (this.getStartDate().equals(this.getEndDate())) {
            return DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).format(this.getStartDate());
        }
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).format(this.getStartDate()) + " - " + DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).format(this.getEndDate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateRange that = (DateRange)o;
        if (!this.startDate.equals(that.startDate)) {
            return false;
        }
        return this.endDate.equals(that.endDate);
    }

    public int hashCode() {
        int result = this.startDate.hashCode();
        result = 31 * result + this.endDate.hashCode();
        return result;
    }
}

