/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CircleProgressIndicator;
import com.dlsc.gemsfx.LimitedTextArea;
import com.dlsc.gemsfx.Spacer;
import com.dlsc.gemsfx.skins.ResizableTextAreaSkin;
import com.dlsc.gemsfx.util.IntegerRange;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class LimitedTextAreaSkin
extends ResizableTextAreaSkin {
    private static final PseudoClass ERROR_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"error");
    private static final PseudoClass WARNING_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"warning");
    private CircleProgressIndicator progressIndicator;
    private final VBox contentBox;
    private final ReadOnlyBooleanWrapper outOfRange;

    public LimitedTextAreaSkin(LimitedTextArea control, ReadOnlyBooleanWrapper outOfRange) {
        super(control);
        this.outOfRange = outOfRange;
        HBox bottomBox = this.initBottom(control);
        this.contentBox = new VBox(new Node[]{this.contentPane, bottomBox});
        this.contentBox.getStyleClass().add((Object)"content-box");
        VBox.setVgrow((Node)this.contentPane, (Priority)Priority.ALWAYS);
        this.getChildren().setAll((Object[])new Node[]{this.contentBox});
        this.updateProgress();
        this.updateTextAndPseudoClass();
        this.registerListener(control);
    }

    private HBox initBottom(LimitedTextArea control) {
        this.progressIndicator = this.createProgressIndicator(control);
        Label lengthLabel = this.createLengthLabel(control);
        StackPane lengthIndicator = new StackPane(new Node[]{lengthLabel, this.progressIndicator});
        lengthIndicator.getStyleClass().add((Object)"length-indicator");
        Label tips = new Label();
        tips.getStyleClass().add((Object)"tips");
        tips.setGraphic((Node)new FontIcon((Ikon)MaterialDesign.MDI_INFORMATION_OUTLINE));
        tips.textProperty().bind((ObservableValue)control.tipsProperty());
        tips.managedProperty().bind((ObservableValue)tips.visibleProperty());
        tips.visibleProperty().bind((ObservableValue)tips.textProperty().isNotEmpty());
        HBox bottomBox = new HBox(new Node[]{tips, new Spacer(), lengthIndicator});
        bottomBox.getStyleClass().add((Object)"bottom-box");
        bottomBox.setMaxHeight(Double.NEGATIVE_INFINITY);
        VBox.setVgrow((Node)bottomBox, (Priority)Priority.NEVER);
        bottomBox.addEventFilter(MouseEvent.ANY, Event::consume);
        bottomBox.managedProperty().bind((ObservableValue)bottomBox.visibleProperty());
        bottomBox.visibleProperty().bind((ObservableValue)control.showBottomProperty());
        return bottomBox;
    }

    private Label createLengthLabel(LimitedTextArea control) {
        Label lengthLabel = new Label();
        lengthLabel.getStyleClass().add((Object)"length-label");
        lengthLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            String text = control.getText();
            int textLen = text == null ? 0 : text.length();
            IntegerRange rangeLimit = control.getCharacterRangeLimit();
            if (rangeLimit == null || rangeLimit.getMax() <= 0) {
                return String.valueOf(textLen);
            }
            return String.valueOf(rangeLimit.getMax() - textLen);
        }, (Observable[])new Observable[]{control.textProperty(), control.characterRangeLimitProperty()}));
        lengthLabel.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            LimitedTextArea.LengthDisplayMode displayMode = control.getLengthDisplayMode();
            switch (displayMode) {
                case AUTO: {
                    IntegerRange limit = control.getCharacterRangeLimit();
                    double warningThreshold = control.getValidWarningThreshold();
                    if (limit != null && limit.getMax() > 0) {
                        int textLen = control.getText() == null ? 0 : control.getText().length();
                        int maximum = limit.getMax();
                        int minimum = limit.getMin();
                        boolean error = textLen > maximum || textLen < minimum;
                        boolean warning = (double)textLen >= (double)maximum * warningThreshold && textLen <= maximum;
                        return error || warning;
                    }
                    return false;
                }
                case ALWAYS_SHOW: {
                    return true;
                }
            }
            return false;
        }, (Observable[])new Observable[]{control.textProperty(), control.characterRangeLimitProperty(), control.lengthDisplayModeProperty()}));
        return lengthLabel;
    }

    private CircleProgressIndicator createProgressIndicator(LimitedTextArea control) {
        this.progressIndicator = new CircleProgressIndicator();
        this.progressIndicator.setConverter(null);
        this.progressIndicator.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            LimitedTextArea.LengthDisplayMode displayMode = control.getLengthDisplayMode();
            IntegerRange rangeLimit = control.getCharacterRangeLimit();
            if (displayMode == LimitedTextArea.LengthDisplayMode.ALWAYS_HIDE || rangeLimit == null || rangeLimit.getMax() <= 0) {
                return false;
            }
            int maxLength = rangeLimit.getMax();
            String text = control.getText();
            int textLen = text == null ? 0 : text.length();
            return textLen <= maxLength;
        }, (Observable[])new Observable[]{control.textProperty(), control.characterRangeLimitProperty(), control.lengthDisplayModeProperty()}));
        return this.progressIndicator;
    }

    private void registerListener(LimitedTextArea control) {
        control.getExcludedItems().addListener(it -> this.updateTextAndPseudoClass());
        this.registerChangeListener((ObservableValue)control.warningThresholdProperty(), it -> this.updatePseudoClass());
        this.registerChangeListener((ObservableValue)control.characterRangeLimitProperty(), it -> this.updatePseudoClass());
        this.registerChangeListener((ObservableValue)control.textProperty(), it -> {
            this.updateTextAndPseudoClass();
            this.updateProgress();
        });
    }

    private void updateProgress() {
        LimitedTextArea skinnable = (LimitedTextArea)this.getSkinnable();
        String text = skinnable.getText();
        IntegerRange rangeLimit = skinnable.getCharacterRangeLimit();
        if (rangeLimit == null || rangeLimit.getMax() <= 0) {
            this.progressIndicator.setProgress(0.0);
            return;
        }
        double progress = (double)(text == null ? 0 : text.length()) / (double)rangeLimit.getMax();
        this.progressIndicator.setProgress(Math.min(progress, 1.0));
    }

    private void updateTextAndPseudoClass() {
        LimitedTextArea control = (LimitedTextArea)this.getSkinnable();
        String content = control.getText() == null ? "" : control.getText();
        if (control.getExcludedItems().stream().anyMatch(content::contains)) {
            Platform.runLater(() -> {
                String result = content.replaceAll(String.join((CharSequence)"|", control.getExcludedItems()), "");
                control.setText(result);
                control.positionCaret(result.length());
            });
        }
        this.updatePseudoClass();
    }

    private void updatePseudoClass() {
        LimitedTextArea control = (LimitedTextArea)this.getSkinnable();
        IntegerRange limit = control.getCharacterRangeLimit();
        double warningThreshold = control.getValidWarningThreshold();
        if (limit != null && limit.getMax() > 0) {
            int textLen = control.getText() == null ? 0 : control.getText().length();
            int maximum = limit.getMax();
            int minimum = limit.getMin();
            boolean error = textLen > maximum || textLen < minimum;
            control.pseudoClassStateChanged(ERROR_PSEUDO_CLASS, error);
            if (error) {
                control.pseudoClassStateChanged(WARNING_PSEUDO_CLASS, false);
            } else {
                boolean warning = (double)textLen >= (double)maximum * warningThreshold;
                control.pseudoClassStateChanged(WARNING_PSEUDO_CLASS, warning);
            }
            this.outOfRange.set(error);
        } else {
            control.pseudoClassStateChanged(ERROR_PSEUDO_CLASS, false);
            control.pseudoClassStateChanged(WARNING_PSEUDO_CLASS, false);
            this.outOfRange.set(false);
        }
    }

    @Override
    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        this.layoutInArea((Node)this.contentBox, contentX, contentY, contentWidth, contentHeight, 0.0, HPos.LEFT, VPos.TOP);
    }
}

