/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.SVGImageView;
import com.dlsc.gemsfx.util.SVGUtil;
import java.net.URI;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class SVGImageViewSkin
extends SkinBase<SVGImageView> {
    private Service<Image> imageService;
    private final ImageView imageView = new ImageView();
    private final InvalidationListener listener = it -> this.loadingImage();
    private final WeakInvalidationListener weakListener = new WeakInvalidationListener(this.listener);

    public SVGImageViewSkin(SVGImageView svgImageView) {
        super((Control)svgImageView);
        svgImageView.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.imageView.fitWidthProperty().bind((ObservableValue)svgImageView.fitWidthProperty());
        this.imageView.fitHeightProperty().bind((ObservableValue)svgImageView.fitHeightProperty());
        this.imageView.preserveRatioProperty().bind((ObservableValue)svgImageView.preserveRatioProperty());
        this.imageView.smoothProperty().bind((ObservableValue)svgImageView.smoothProperty());
        svgImageView.svgUrlProperty().addListener((InvalidationListener)this.weakListener);
        svgImageView.fitWidthProperty().addListener((InvalidationListener)this.weakListener);
        svgImageView.fitHeightProperty().addListener((InvalidationListener)this.weakListener);
        this.loadingImage();
        this.getChildren().add((Object)this.imageView);
    }

    private void loadingImage() {
        SVGImageView skinnable;
        String url;
        if (this.imageService != null && this.imageService.isRunning()) {
            this.imageService.cancel();
            this.imageView.setImage(null);
        }
        if ((url = (skinnable = (SVGImageView)this.getSkinnable()).getSvgUrl()) == null || url.isEmpty()) {
            return;
        }
        if (!skinnable.isBackgroundLoading()) {
            try {
                Image image = SVGUtil.parseSVGFromUrl(new URI(url).toURL(), skinnable.getFitWidth(), skinnable.getFitHeight());
                this.imageView.setImage(image);
            }
            catch (Exception e) {
                this.imageView.setImage(null);
            }
        } else {
            if (this.imageService == null) {
                this.imageService = this.createLoadingImageService();
                this.imageService.setOnSucceeded(evt -> this.imageView.setImage((Image)this.imageService.getValue()));
            }
            this.imageService.restart();
        }
    }

    private Service<Image> createLoadingImageService() {
        final SVGImageView skinnable = (SVGImageView)this.getSkinnable();
        return new Service<Image>(){

            protected Task<Image> createTask() {
                return new Task<Image>(){

                    protected Image call() {
                        if (this.isCancelled()) {
                            return null;
                        }
                        try {
                            return SVGUtil.parseSVGFromUrl(new URI(skinnable.getSvgUrl()).toURL(), skinnable.getFitWidth(), skinnable.getFitHeight());
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                };
            }
        };
    }
}

