/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodLikeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionMethodDeclaration;

public class ReflectionTypeParameter
implements ResolvedTypeParameterDeclaration {
    private TypeVariable typeVariable;
    private TypeSolver typeSolver;
    private ResolvedTypeParametrizable container;

    public ReflectionTypeParameter(TypeVariable typeVariable, boolean declaredOnClass, TypeSolver typeSolver) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        if (genericDeclaration instanceof Class) {
            this.container = ReflectionFactory.typeDeclarationFor((Class)genericDeclaration, typeSolver);
        } else if (genericDeclaration instanceof Method) {
            this.container = new ReflectionMethodDeclaration((Method)genericDeclaration, typeSolver);
        } else if (genericDeclaration instanceof Constructor) {
            this.container = new ReflectionConstructorDeclaration((Constructor)genericDeclaration, typeSolver);
        }
        this.typeVariable = typeVariable;
        this.typeSolver = typeSolver;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedTypeParameterDeclaration)) {
            return false;
        }
        ResolvedTypeParameterDeclaration that = (ResolvedTypeParameterDeclaration)o;
        if (!this.getQualifiedName().equals(that.getQualifiedName())) {
            return false;
        }
        if (this.declaredOnType() != that.declaredOnType()) {
            return false;
        }
        return this.declaredOnMethod() == that.declaredOnMethod();
    }

    public int hashCode() {
        int result = this.typeVariable.hashCode();
        result = 31 * result + this.container.hashCode();
        return result;
    }

    @Override
    public String getName() {
        return this.typeVariable.getName();
    }

    @Override
    public String getContainerQualifiedName() {
        if (this.container instanceof ResolvedReferenceTypeDeclaration) {
            return ((ResolvedReferenceTypeDeclaration)this.container).getQualifiedName();
        }
        return ((ResolvedMethodLikeDeclaration)this.container).getQualifiedSignature();
    }

    @Override
    public String getContainerId() {
        if (this.container instanceof ResolvedReferenceTypeDeclaration) {
            return ((ResolvedReferenceTypeDeclaration)this.container).getId();
        }
        return ((ResolvedMethodLikeDeclaration)this.container).getQualifiedSignature();
    }

    @Override
    public ResolvedTypeParametrizable getContainer() {
        return this.container;
    }

    @Override
    public List<ResolvedTypeParameterDeclaration.Bound> getBounds() {
        return Arrays.stream(this.typeVariable.getBounds()).map(refB -> ResolvedTypeParameterDeclaration.Bound.extendsBound(ReflectionFactory.typeUsageFor(refB, this.typeSolver))).collect(Collectors.toList());
    }

    public String toString() {
        return "ReflectionTypeParameter{typeVariable=" + this.typeVariable + '}';
    }

    @Override
    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        if (this.container instanceof ResolvedReferenceTypeDeclaration) {
            return Optional.of((ResolvedReferenceTypeDeclaration)this.container);
        }
        return Optional.empty();
    }

    @Override
    public ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject());
    }
}

