// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package localauthorityv1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion7

// LocalAuthorityClient is the client API for LocalAuthority service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LocalAuthorityClient interface {
	// GetJWTAuthorityState returns the state of all locally configured
	// JWT authorities.
	GetJWTAuthorityState(ctx context.Context, in *GetJWTAuthorityStateRequest, opts ...grpc.CallOption) (*GetJWTAuthorityStateResponse, error)
	// PrepareJWTAuthority prepares a new JWT authority for use by
	// generating a new key and injecting it into the bundle. This action
	// will propagate the new public key cluster-wide.
	PrepareJWTAuthority(ctx context.Context, in *PrepareJWTAuthorityRequest, opts ...grpc.CallOption) (*PrepareJWTAuthorityResponse, error)
	// ActivateJWTAuthority activates a prepared JWT authority for use,
	// which will cause it to be used for all JWT signing operations
	// serviced by this server going forward. If a new JWT authority has
	// not already been prepared, a FailedPrecondition error will be returned.
	ActivateJWTAuthority(ctx context.Context, in *ActivateJWTAuthorityRequest, opts ...grpc.CallOption) (*ActivateJWTAuthorityResponse, error)
	// TaintJWTAuthority marks the previously active JWT authority as
	// being tainted. SPIRE Agents observing an authority to be tainted
	// will perform proactive rotations of any key material related to
	// the tainted authority. The result of this action will be observed
	// cluster-wide.
	// It can receive the Authority ID of an old JWT authority.
	//
	// If a previously active JWT authority does not exist (e.g. if one
	// has been prepared but not activated yet), a FailedPrecondition
	// error will be returned.
	TaintJWTAuthority(ctx context.Context, in *TaintJWTAuthorityRequest, opts ...grpc.CallOption) (*TaintJWTAuthorityResponse, error)
	// RevokeJWTAuthority revokes the previously active JWT authority by
	// removing it from the bundle and propagating this update throughout
	// the cluster.
	// It can receive the Authority ID of an old JWT authority.
	//
	// If a previously active JWT authority does not exist (e.g. if one
	// has been prepared but not activated yet), a FailedPrecondition
	// error will be returned.
	RevokeJWTAuthority(ctx context.Context, in *RevokeJWTAuthorityRequest, opts ...grpc.CallOption) (*RevokeJWTAuthorityResponse, error)
	// GetX509AuthorityState returns the state of all locally configured
	// X.509 authorities.
	GetX509AuthorityState(ctx context.Context, in *GetX509AuthorityStateRequest, opts ...grpc.CallOption) (*GetX509AuthorityStateResponse, error)
	// PrepareX509Authority prepares a new X.509 authority for use by
	// generating a new key and injecting the resulting CA certificate into
	// the bundle. This action will  propagate the new CA cluster-wide.
	PrepareX509Authority(ctx context.Context, in *PrepareX509AuthorityRequest, opts ...grpc.CallOption) (*PrepareX509AuthorityResponse, error)
	// ActivateX509Authority activates a prepared X.509 authority for use,
	// which will cause it to be used for all X.509 signing operations
	// serviced by this server going forward. If a new X.509 authority has
	// not already been prepared, a FailedPrecondition error will be returned.
	ActivateX509Authority(ctx context.Context, in *ActivateX509AuthorityRequest, opts ...grpc.CallOption) (*ActivateX509AuthorityResponse, error)
	// TaintX509Authority marks the previously active X.509 authority as
	// being tainted. SPIRE Agents observing an authority to be tainted
	// will perform proactive rotations of any key material related to
	// the tainted authority. The result of this action will be observed
	// cluster-wide.
	// It can receive the public key of an old X.509 authority.
	//
	// If a previously active X.509 authority does not exist (e.g. if one
	// has been prepared but not activated yet), a FailedPrecondition
	// error will be returned.
	TaintX509Authority(ctx context.Context, in *TaintX509AuthorityRequest, opts ...grpc.CallOption) (*TaintX509AuthorityResponse, error)
	// RevokeX509Authority revokes the previously active X.509 authority by
	// removing it from the bundle and propagating this update throughout
	// the cluster.
	// It can receive the public key of an old X.509 authority.
	//
	// If a previously active X.509 authority does not exist (e.g. if one
	// has been prepared but not activated yet), a FailedPrecondition
	// error will be returned.
	RevokeX509Authority(ctx context.Context, in *RevokeX509AuthorityRequest, opts ...grpc.CallOption) (*RevokeX509AuthorityResponse, error)
}

type localAuthorityClient struct {
	cc grpc.ClientConnInterface
}

func NewLocalAuthorityClient(cc grpc.ClientConnInterface) LocalAuthorityClient {
	return &localAuthorityClient{cc}
}

func (c *localAuthorityClient) GetJWTAuthorityState(ctx context.Context, in *GetJWTAuthorityStateRequest, opts ...grpc.CallOption) (*GetJWTAuthorityStateResponse, error) {
	out := new(GetJWTAuthorityStateResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.localauthority.v1.LocalAuthority/GetJWTAuthorityState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localAuthorityClient) PrepareJWTAuthority(ctx context.Context, in *PrepareJWTAuthorityRequest, opts ...grpc.CallOption) (*PrepareJWTAuthorityResponse, error) {
	out := new(PrepareJWTAuthorityResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.localauthority.v1.LocalAuthority/PrepareJWTAuthority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localAuthorityClient) ActivateJWTAuthority(ctx context.Context, in *ActivateJWTAuthorityRequest, opts ...grpc.CallOption) (*ActivateJWTAuthorityResponse, error) {
	out := new(ActivateJWTAuthorityResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.localauthority.v1.LocalAuthority/ActivateJWTAuthority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localAuthorityClient) TaintJWTAuthority(ctx context.Context, in *TaintJWTAuthorityRequest, opts ...grpc.CallOption) (*TaintJWTAuthorityResponse, error) {
	out := new(TaintJWTAuthorityResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.localauthority.v1.LocalAuthority/TaintJWTAuthority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localAuthorityClient) RevokeJWTAuthority(ctx context.Context, in *RevokeJWTAuthorityRequest, opts ...grpc.CallOption) (*RevokeJWTAuthorityResponse, error) {
	out := new(RevokeJWTAuthorityResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.localauthority.v1.LocalAuthority/RevokeJWTAuthority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localAuthorityClient) GetX509AuthorityState(ctx context.Context, in *GetX509AuthorityStateRequest, opts ...grpc.CallOption) (*GetX509AuthorityStateResponse, error) {
	out := new(GetX509AuthorityStateResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.localauthority.v1.LocalAuthority/GetX509AuthorityState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localAuthorityClient) PrepareX509Authority(ctx context.Context, in *PrepareX509AuthorityRequest, opts ...grpc.CallOption) (*PrepareX509AuthorityResponse, error) {
	out := new(PrepareX509AuthorityResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.localauthority.v1.LocalAuthority/PrepareX509Authority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localAuthorityClient) ActivateX509Authority(ctx context.Context, in *ActivateX509AuthorityRequest, opts ...grpc.CallOption) (*ActivateX509AuthorityResponse, error) {
	out := new(ActivateX509AuthorityResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.localauthority.v1.LocalAuthority/ActivateX509Authority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localAuthorityClient) TaintX509Authority(ctx context.Context, in *TaintX509AuthorityRequest, opts ...grpc.CallOption) (*TaintX509AuthorityResponse, error) {
	out := new(TaintX509AuthorityResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.localauthority.v1.LocalAuthority/TaintX509Authority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localAuthorityClient) RevokeX509Authority(ctx context.Context, in *RevokeX509AuthorityRequest, opts ...grpc.CallOption) (*RevokeX509AuthorityResponse, error) {
	out := new(RevokeX509AuthorityResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.localauthority.v1.LocalAuthority/RevokeX509Authority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LocalAuthorityServer is the server API for LocalAuthority service.
// All implementations must embed UnimplementedLocalAuthorityServer
// for forward compatibility
type LocalAuthorityServer interface {
	// GetJWTAuthorityState returns the state of all locally configured
	// JWT authorities.
	GetJWTAuthorityState(context.Context, *GetJWTAuthorityStateRequest) (*GetJWTAuthorityStateResponse, error)
	// PrepareJWTAuthority prepares a new JWT authority for use by
	// generating a new key and injecting it into the bundle. This action
	// will propagate the new public key cluster-wide.
	PrepareJWTAuthority(context.Context, *PrepareJWTAuthorityRequest) (*PrepareJWTAuthorityResponse, error)
	// ActivateJWTAuthority activates a prepared JWT authority for use,
	// which will cause it to be used for all JWT signing operations
	// serviced by this server going forward. If a new JWT authority has
	// not already been prepared, a FailedPrecondition error will be returned.
	ActivateJWTAuthority(context.Context, *ActivateJWTAuthorityRequest) (*ActivateJWTAuthorityResponse, error)
	// TaintJWTAuthority marks the previously active JWT authority as
	// being tainted. SPIRE Agents observing an authority to be tainted
	// will perform proactive rotations of any key material related to
	// the tainted authority. The result of this action will be observed
	// cluster-wide.
	// It can receive the Authority ID of an old JWT authority.
	//
	// If a previously active JWT authority does not exist (e.g. if one
	// has been prepared but not activated yet), a FailedPrecondition
	// error will be returned.
	TaintJWTAuthority(context.Context, *TaintJWTAuthorityRequest) (*TaintJWTAuthorityResponse, error)
	// RevokeJWTAuthority revokes the previously active JWT authority by
	// removing it from the bundle and propagating this update throughout
	// the cluster.
	// It can receive the Authority ID of an old JWT authority.
	//
	// If a previously active JWT authority does not exist (e.g. if one
	// has been prepared but not activated yet), a FailedPrecondition
	// error will be returned.
	RevokeJWTAuthority(context.Context, *RevokeJWTAuthorityRequest) (*RevokeJWTAuthorityResponse, error)
	// GetX509AuthorityState returns the state of all locally configured
	// X.509 authorities.
	GetX509AuthorityState(context.Context, *GetX509AuthorityStateRequest) (*GetX509AuthorityStateResponse, error)
	// PrepareX509Authority prepares a new X.509 authority for use by
	// generating a new key and injecting the resulting CA certificate into
	// the bundle. This action will  propagate the new CA cluster-wide.
	PrepareX509Authority(context.Context, *PrepareX509AuthorityRequest) (*PrepareX509AuthorityResponse, error)
	// ActivateX509Authority activates a prepared X.509 authority for use,
	// which will cause it to be used for all X.509 signing operations
	// serviced by this server going forward. If a new X.509 authority has
	// not already been prepared, a FailedPrecondition error will be returned.
	ActivateX509Authority(context.Context, *ActivateX509AuthorityRequest) (*ActivateX509AuthorityResponse, error)
	// TaintX509Authority marks the previously active X.509 authority as
	// being tainted. SPIRE Agents observing an authority to be tainted
	// will perform proactive rotations of any key material related to
	// the tainted authority. The result of this action will be observed
	// cluster-wide.
	// It can receive the public key of an old X.509 authority.
	//
	// If a previously active X.509 authority does not exist (e.g. if one
	// has been prepared but not activated yet), a FailedPrecondition
	// error will be returned.
	TaintX509Authority(context.Context, *TaintX509AuthorityRequest) (*TaintX509AuthorityResponse, error)
	// RevokeX509Authority revokes the previously active X.509 authority by
	// removing it from the bundle and propagating this update throughout
	// the cluster.
	// It can receive the public key of an old X.509 authority.
	//
	// If a previously active X.509 authority does not exist (e.g. if one
	// has been prepared but not activated yet), a FailedPrecondition
	// error will be returned.
	RevokeX509Authority(context.Context, *RevokeX509AuthorityRequest) (*RevokeX509AuthorityResponse, error)
	mustEmbedUnimplementedLocalAuthorityServer()
}

// UnimplementedLocalAuthorityServer must be embedded to have forward compatible implementations.
type UnimplementedLocalAuthorityServer struct {
}

func (UnimplementedLocalAuthorityServer) GetJWTAuthorityState(context.Context, *GetJWTAuthorityStateRequest) (*GetJWTAuthorityStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJWTAuthorityState not implemented")
}
func (UnimplementedLocalAuthorityServer) PrepareJWTAuthority(context.Context, *PrepareJWTAuthorityRequest) (*PrepareJWTAuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PrepareJWTAuthority not implemented")
}
func (UnimplementedLocalAuthorityServer) ActivateJWTAuthority(context.Context, *ActivateJWTAuthorityRequest) (*ActivateJWTAuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ActivateJWTAuthority not implemented")
}
func (UnimplementedLocalAuthorityServer) TaintJWTAuthority(context.Context, *TaintJWTAuthorityRequest) (*TaintJWTAuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TaintJWTAuthority not implemented")
}
func (UnimplementedLocalAuthorityServer) RevokeJWTAuthority(context.Context, *RevokeJWTAuthorityRequest) (*RevokeJWTAuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeJWTAuthority not implemented")
}
func (UnimplementedLocalAuthorityServer) GetX509AuthorityState(context.Context, *GetX509AuthorityStateRequest) (*GetX509AuthorityStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetX509AuthorityState not implemented")
}
func (UnimplementedLocalAuthorityServer) PrepareX509Authority(context.Context, *PrepareX509AuthorityRequest) (*PrepareX509AuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PrepareX509Authority not implemented")
}
func (UnimplementedLocalAuthorityServer) ActivateX509Authority(context.Context, *ActivateX509AuthorityRequest) (*ActivateX509AuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ActivateX509Authority not implemented")
}
func (UnimplementedLocalAuthorityServer) TaintX509Authority(context.Context, *TaintX509AuthorityRequest) (*TaintX509AuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TaintX509Authority not implemented")
}
func (UnimplementedLocalAuthorityServer) RevokeX509Authority(context.Context, *RevokeX509AuthorityRequest) (*RevokeX509AuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeX509Authority not implemented")
}
func (UnimplementedLocalAuthorityServer) mustEmbedUnimplementedLocalAuthorityServer() {}

// UnsafeLocalAuthorityServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LocalAuthorityServer will
// result in compilation errors.
type UnsafeLocalAuthorityServer interface {
	mustEmbedUnimplementedLocalAuthorityServer()
}

func RegisterLocalAuthorityServer(s grpc.ServiceRegistrar, srv LocalAuthorityServer) {
	s.RegisterService(&_LocalAuthority_serviceDesc, srv)
}

func _LocalAuthority_GetJWTAuthorityState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJWTAuthorityStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalAuthorityServer).GetJWTAuthorityState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.localauthority.v1.LocalAuthority/GetJWTAuthorityState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalAuthorityServer).GetJWTAuthorityState(ctx, req.(*GetJWTAuthorityStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalAuthority_PrepareJWTAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PrepareJWTAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalAuthorityServer).PrepareJWTAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.localauthority.v1.LocalAuthority/PrepareJWTAuthority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalAuthorityServer).PrepareJWTAuthority(ctx, req.(*PrepareJWTAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalAuthority_ActivateJWTAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateJWTAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalAuthorityServer).ActivateJWTAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.localauthority.v1.LocalAuthority/ActivateJWTAuthority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalAuthorityServer).ActivateJWTAuthority(ctx, req.(*ActivateJWTAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalAuthority_TaintJWTAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TaintJWTAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalAuthorityServer).TaintJWTAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.localauthority.v1.LocalAuthority/TaintJWTAuthority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalAuthorityServer).TaintJWTAuthority(ctx, req.(*TaintJWTAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalAuthority_RevokeJWTAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeJWTAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalAuthorityServer).RevokeJWTAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.localauthority.v1.LocalAuthority/RevokeJWTAuthority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalAuthorityServer).RevokeJWTAuthority(ctx, req.(*RevokeJWTAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalAuthority_GetX509AuthorityState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetX509AuthorityStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalAuthorityServer).GetX509AuthorityState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.localauthority.v1.LocalAuthority/GetX509AuthorityState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalAuthorityServer).GetX509AuthorityState(ctx, req.(*GetX509AuthorityStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalAuthority_PrepareX509Authority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PrepareX509AuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalAuthorityServer).PrepareX509Authority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.localauthority.v1.LocalAuthority/PrepareX509Authority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalAuthorityServer).PrepareX509Authority(ctx, req.(*PrepareX509AuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalAuthority_ActivateX509Authority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateX509AuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalAuthorityServer).ActivateX509Authority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.localauthority.v1.LocalAuthority/ActivateX509Authority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalAuthorityServer).ActivateX509Authority(ctx, req.(*ActivateX509AuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalAuthority_TaintX509Authority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TaintX509AuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalAuthorityServer).TaintX509Authority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.localauthority.v1.LocalAuthority/TaintX509Authority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalAuthorityServer).TaintX509Authority(ctx, req.(*TaintX509AuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalAuthority_RevokeX509Authority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeX509AuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalAuthorityServer).RevokeX509Authority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.localauthority.v1.LocalAuthority/RevokeX509Authority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalAuthorityServer).RevokeX509Authority(ctx, req.(*RevokeX509AuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LocalAuthority_serviceDesc = grpc.ServiceDesc{
	ServiceName: "spire.api.server.localauthority.v1.LocalAuthority",
	HandlerType: (*LocalAuthorityServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetJWTAuthorityState",
			Handler:    _LocalAuthority_GetJWTAuthorityState_Handler,
		},
		{
			MethodName: "PrepareJWTAuthority",
			Handler:    _LocalAuthority_PrepareJWTAuthority_Handler,
		},
		{
			MethodName: "ActivateJWTAuthority",
			Handler:    _LocalAuthority_ActivateJWTAuthority_Handler,
		},
		{
			MethodName: "TaintJWTAuthority",
			Handler:    _LocalAuthority_TaintJWTAuthority_Handler,
		},
		{
			MethodName: "RevokeJWTAuthority",
			Handler:    _LocalAuthority_RevokeJWTAuthority_Handler,
		},
		{
			MethodName: "GetX509AuthorityState",
			Handler:    _LocalAuthority_GetX509AuthorityState_Handler,
		},
		{
			MethodName: "PrepareX509Authority",
			Handler:    _LocalAuthority_PrepareX509Authority_Handler,
		},
		{
			MethodName: "ActivateX509Authority",
			Handler:    _LocalAuthority_ActivateX509Authority_Handler,
		},
		{
			MethodName: "TaintX509Authority",
			Handler:    _LocalAuthority_TaintX509Authority_Handler,
		},
		{
			MethodName: "RevokeX509Authority",
			Handler:    _LocalAuthority_RevokeX509Authority_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "spire/api/server/localauthority/v1/localauthority.proto",
}
