---
title: How to contribute
kind: contrib
weight: 1
---

Thanks for your interest in contributing to the Open Policy Agent project!

## Where to start?

* Ask for help on the [OPA Discussions Board](https://github.com/open-policy-agent/feedback/discussions)
* Use [#contributors](https://openpolicyagent.slack.com/archives/C02L1TLPN59) in Slack to talk to the OPA maintainers and other contributors.
* File a [GitHub Issue](https://github.com/open-policy-agent/opa/issues) to request features or report bugs.
* Join the OPA bi-weekly meetings every other Tuesday at 10:00 (Pacific Timezone):
    * [Meeting Notes](https://docs.google.com/document/d/1v6l2gmkRKAn5UIg3V2QdeeCcXMElxsNzEzDkVlWDVg8/edit?usp=sharing)
    * [Zoom](https://zoom.us/j/97827947600)
    * [Calendar Invite](https://calendar.google.com/event?action=TEMPLATE&tmeid=MnRvb2M4amtldXBuZ2E1azY0MTJndjh0ODRfMjAxODA5MThUMTcwMDAwWiBzdHlyYS5jb21fY28zOXVzc3VobnE2amUzN2l2dHQyYmNiZGdAZw&tmsrc=styra.com_co39ussuhnq6je37ivtt2bcbdg%40group.calendar.google.com&scp=ALL)


If you want to contribute code and you are new to the Go programming language, check out
the [development reference](../contrib-development/) for help getting started.

## Other types of contributions

We welcome contributions of all kinds. For example:

- [Documentation](../contrib-docs) including reference material and examples.
- Help out other members in the OPA Slack Org and on the [GitHub Discussions Board](https://github.com/open-policy-agent/feedback/discussions)
- Spreading the word about OPA by speaking at conferences
- Adding integrations to the OPA [ecosystem](https://www.openpolicyagent.org/ecosystem/)
- Creating Blog and Videos to show how your organization has implemented OPA

If you're interested in any non-code contributions, please reach out on the #help channel on [Slack](https://slack.openpolicyagent.org/)