// Translated from C++ to Rust. The original C++ code can be found at
// https://github.com/jk-jeon/dragonbox and carries the following license:
//
// Copyright 2020-2021 Junekey Jeon
//
// The contents of this file may be used under the terms of
// the Apache License v2.0 with LLVM Exceptions.
//
//    (See accompanying file LICENSE-Apache or copy at
//     https://llvm.org/foundation/relicensing/LICENSE.txt)
//
// Alternatively, the contents of this file may be used under the terms of
// the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE-Boost or copy at
//     https://www.boost.org/LICENSE_1_0.txt)
//
// Unless required by applicable law or agreed to in writing, this software
// is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.

pub(crate) type EntryType = u128;
const MIN_K: i32 = -292;
const MAX_K: i32 = 326;

pub(crate) unsafe fn get(k: i32) -> EntryType {
    debug_assert!(k >= MIN_K && k <= MAX_K);
    *CACHE.get_unchecked((k - MIN_K) as usize)
}

pub(crate) trait EntryTypeExt {
    fn high(&self) -> u64;
    fn low(&self) -> u64;
}

impl EntryTypeExt for EntryType {
    fn high(&self) -> u64 {
        (self >> 64) as u64
    }
    fn low(&self) -> u64 {
        *self as u64
    }
}

static CACHE: [EntryType; 619] = [
    0xff77b1fcbebcdc4f_25e8e89c13bb0f7b,
    0x9faacf3df73609b1_77b191618c54e9ad,
    0xc795830d75038c1d_d59df5b9ef6a2418,
    0xf97ae3d0d2446f25_4b0573286b44ad1e,
    0x9becce62836ac577_4ee367f9430aec33,
    0xc2e801fb244576d5_229c41f793cda740,
    0xf3a20279ed56d48a_6b43527578c11110,
    0x9845418c345644d6_830a13896b78aaaa,
    0xbe5691ef416bd60c_23cc986bc656d554,
    0xedec366b11c6cb8f_2cbfbe86b7ec8aa9,
    0x94b3a202eb1c3f39_7bf7d71432f3d6aa,
    0xb9e08a83a5e34f07_daf5ccd93fb0cc54,
    0xe858ad248f5c22c9_d1b3400f8f9cff69,
    0x91376c36d99995be_23100809b9c21fa2,
    0xb58547448ffffb2d_abd40a0c2832a78b,
    0xe2e69915b3fff9f9_16c90c8f323f516d,
    0x8dd01fad907ffc3b_ae3da7d97f6792e4,
    0xb1442798f49ffb4a_99cd11cfdf41779d,
    0xdd95317f31c7fa1d_40405643d711d584,
    0x8a7d3eef7f1cfc52_482835ea666b2573,
    0xad1c8eab5ee43b66_da3243650005eed0,
    0xd863b256369d4a40_90bed43e40076a83,
    0x873e4f75e2224e68_5a7744a6e804a292,
    0xa90de3535aaae202_711515d0a205cb37,
    0xd3515c2831559a83_0d5a5b44ca873e04,
    0x8412d9991ed58091_e858790afe9486c3,
    0xa5178fff668ae0b6_626e974dbe39a873,
    0xce5d73ff402d98e3_fb0a3d212dc81290,
    0x80fa687f881c7f8e_7ce66634bc9d0b9a,
    0xa139029f6a239f72_1c1fffc1ebc44e81,
    0xc987434744ac874e_a327ffb266b56221,
    0xfbe9141915d7a922_4bf1ff9f0062baa9,
    0x9d71ac8fada6c9b5_6f773fc3603db4aa,
    0xc4ce17b399107c22_cb550fb4384d21d4,
    0xf6019da07f549b2b_7e2a53a146606a49,
    0x99c102844f94e0fb_2eda7444cbfc426e,
    0xc0314325637a1939_fa911155fefb5309,
    0xf03d93eebc589f88_793555ab7eba27cb,
    0x96267c7535b763b5_4bc1558b2f3458df,
    0xbbb01b9283253ca2_9eb1aaedfb016f17,
    0xea9c227723ee8bcb_465e15a979c1cadd,
    0x92a1958a7675175f_0bfacd89ec191eca,
    0xb749faed14125d36_cef980ec671f667c,
    0xe51c79a85916f484_82b7e12780e7401b,
    0x8f31cc0937ae58d2_d1b2ecb8b0908811,
    0xb2fe3f0b8599ef07_861fa7e6dcb4aa16,
    0xdfbdcece67006ac9_67a791e093e1d49b,
    0x8bd6a141006042bd_e0c8bb2c5c6d24e1,
    0xaecc49914078536d_58fae9f773886e19,
    0xda7f5bf590966848_af39a475506a899f,
    0x888f99797a5e012d_6d8406c952429604,
    0xaab37fd7d8f58178_c8e5087ba6d33b84,
    0xd5605fcdcf32e1d6_fb1e4a9a90880a65,
    0x855c3be0a17fcd26_5cf2eea09a550680,
    0xa6b34ad8c9dfc06f_f42faa48c0ea481f,
    0xd0601d8efc57b08b_f13b94daf124da27,
    0x823c12795db6ce57_76c53d08d6b70859,
    0xa2cb1717b52481ed_54768c4b0c64ca6f,
    0xcb7ddcdda26da268_a9942f5dcf7dfd0a,
    0xfe5d54150b090b02_d3f93b35435d7c4d,
    0x9efa548d26e5a6e1_c47bc5014a1a6db0,
    0xc6b8e9b0709f109a_359ab6419ca1091c,
    0xf867241c8cc6d4c0_c30163d203c94b63,
    0x9b407691d7fc44f8_79e0de63425dcf1e,
    0xc21094364dfb5636_985915fc12f542e5,
    0xf294b943e17a2bc4_3e6f5b7b17b2939e,
    0x979cf3ca6cec5b5a_a705992ceecf9c43,
    0xbd8430bd08277231_50c6ff782a838354,
    0xece53cec4a314ebd_a4f8bf5635246429,
    0x940f4613ae5ed136_871b7795e136be9a,
    0xb913179899f68584_28e2557b59846e40,
    0xe757dd7ec07426e5_331aeada2fe589d0,
    0x9096ea6f3848984f_3ff0d2c85def7622,
    0xb4bca50b065abe63_0fed077a756b53aa,
    0xe1ebce4dc7f16dfb_d3e8495912c62895,
    0x8d3360f09cf6e4bd_64712dd7abbbd95d,
    0xb080392cc4349dec_bd8d794d96aacfb4,
    0xdca04777f541c567_ecf0d7a0fc5583a1,
    0x89e42caaf9491b60_f41686c49db57245,
    0xac5d37d5b79b6239_311c2875c522ced6,
    0xd77485cb25823ac7_7d633293366b828c,
    0x86a8d39ef77164bc_ae5dff9c02033198,
    0xa8530886b54dbdeb_d9f57f830283fdfd,
    0xd267caa862a12d66_d072df63c324fd7c,
    0x8380dea93da4bc60_4247cb9e59f71e6e,
    0xa46116538d0deb78_52d9be85f074e609,
    0xcd795be870516656_67902e276c921f8c,
    0x806bd9714632dff6_00ba1cd8a3db53b7,
    0xa086cfcd97bf97f3_80e8a40eccd228a5,
    0xc8a883c0fdaf7df0_6122cd128006b2ce,
    0xfad2a4b13d1b5d6c_796b805720085f82,
    0x9cc3a6eec6311a63_cbe3303674053bb1,
    0xc3f490aa77bd60fc_bedbfc4411068a9d,
    0xf4f1b4d515acb93b_ee92fb5515482d45,
    0x991711052d8bf3c5_751bdd152d4d1c4b,
    0xbf5cd54678eef0b6_d262d45a78a0635e,
    0xef340a98172aace4_86fb897116c87c35,
    0x9580869f0e7aac0e_d45d35e6ae3d4da1,
    0xbae0a846d2195712_8974836059cca10a,
    0xe998d258869facd7_2bd1a438703fc94c,
    0x91ff83775423cc06_7b6306a34627ddd0,
    0xb67f6455292cbf08_1a3bc84c17b1d543,
    0xe41f3d6a7377eeca_20caba5f1d9e4a94,
    0x8e938662882af53e_547eb47b7282ee9d,
    0xb23867fb2a35b28d_e99e619a4f23aa44,
    0xdec681f9f4c31f31_6405fa00e2ec94d5,
    0x8b3c113c38f9f37e_de83bc408dd3dd05,
    0xae0b158b4738705e_9624ab50b148d446,
    0xd98ddaee19068c76_3badd624dd9b0958,
    0x87f8a8d4cfa417c9_e54ca5d70a80e5d7,
    0xa9f6d30a038d1dbc_5e9fcf4ccd211f4d,
    0xd47487cc8470652b_7647c32000696720,
    0x84c8d4dfd2c63f3b_29ecd9f40041e074,
    0xa5fb0a17c777cf09_f468107100525891,
    0xcf79cc9db955c2cc_7182148d4066eeb5,
    0x81ac1fe293d599bf_c6f14cd848405531,
    0xa21727db38cb002f_b8ada00e5a506a7d,
    0xca9cf1d206fdc03b_a6d90811f0e4851d,
    0xfd442e4688bd304a_908f4a166d1da664,
    0x9e4a9cec15763e2e_9a598e4e043287ff,
    0xc5dd44271ad3cdba_40eff1e1853f29fe,
    0xf7549530e188c128_d12bee59e68ef47d,
    0x9a94dd3e8cf578b9_82bb74f8301958cf,
    0xc13a148e3032d6e7_e36a52363c1faf02,
    0xf18899b1bc3f8ca1_dc44e6c3cb279ac2,
    0x96f5600f15a7b7e5_29ab103a5ef8c0ba,
    0xbcb2b812db11a5de_7415d448f6b6f0e8,
    0xebdf661791d60f56_111b495b3464ad22,
    0x936b9fcebb25c995_cab10dd900beec35,
    0xb84687c269ef3bfb_3d5d514f40eea743,
    0xe65829b3046b0afa_0cb4a5a3112a5113,
    0x8ff71a0fe2c2e6dc_47f0e785eaba72ac,
    0xb3f4e093db73a093_59ed216765690f57,
    0xe0f218b8d25088b8_306869c13ec3532d,
    0x8c974f7383725573_1e414218c73a13fc,
    0xafbd2350644eeacf_e5d1929ef90898fb,
    0xdbac6c247d62a583_df45f746b74abf3a,
    0x894bc396ce5da772_6b8bba8c328eb784,
    0xab9eb47c81f5114f_066ea92f3f326565,
    0xd686619ba27255a2_c80a537b0efefebe,
    0x8613fd0145877585_bd06742ce95f5f37,
    0xa798fc4196e952e7_2c48113823b73705,
    0xd17f3b51fca3a7a0_f75a15862ca504c6,
    0x82ef85133de648c4_9a984d73dbe722fc,
    0xa3ab66580d5fdaf5_c13e60d0d2e0ebbb,
    0xcc963fee10b7d1b3_318df905079926a9,
    0xffbbcfe994e5c61f_fdf17746497f7053,
    0x9fd561f1fd0f9bd3_feb6ea8bedefa634,
    0xc7caba6e7c5382c8_fe64a52ee96b8fc1,
    0xf9bd690a1b68637b_3dfdce7aa3c673b1,
    0x9c1661a651213e2d_06bea10ca65c084f,
    0xc31bfa0fe5698db8_486e494fcff30a63,
    0xf3e2f893dec3f126_5a89dba3c3efccfb,
    0x986ddb5c6b3a76b7_f89629465a75e01d,
    0xbe89523386091465_f6bbb397f1135824,
    0xee2ba6c0678b597f_746aa07ded582e2d,
    0x94db483840b717ef_a8c2a44eb4571cdd,
    0xba121a4650e4ddeb_92f34d62616ce414,
    0xe896a0d7e51e1566_77b020baf9c81d18,
    0x915e2486ef32cd60_0ace1474dc1d122f,
    0xb5b5ada8aaff80b8_0d819992132456bb,
    0xe3231912d5bf60e6_10e1fff697ed6c6a,
    0x8df5efabc5979c8f_ca8d3ffa1ef463c2,
    0xb1736b96b6fd83b3_bd308ff8a6b17cb3,
    0xddd0467c64bce4a0_ac7cb3f6d05ddbdf,
    0x8aa22c0dbef60ee4_6bcdf07a423aa96c,
    0xad4ab7112eb3929d_86c16c98d2c953c7,
    0xd89d64d57a607744_e871c7bf077ba8b8,
    0x87625f056c7c4a8b_11471cd764ad4973,
    0xa93af6c6c79b5d2d_d598e40d3dd89bd0,
    0xd389b47879823479_4aff1d108d4ec2c4,
    0x843610cb4bf160cb_cedf722a585139bb,
    0xa54394fe1eedb8fe_c2974eb4ee658829,
    0xce947a3da6a9273e_733d226229feea33,
    0x811ccc668829b887_0806357d5a3f5260,
    0xa163ff802a3426a8_ca07c2dcb0cf26f8,
    0xc9bcff6034c13052_fc89b393dd02f0b6,
    0xfc2c3f3841f17c67_bbac2078d443ace3,
    0x9d9ba7832936edc0_d54b944b84aa4c0e,
    0xc5029163f384a931_0a9e795e65d4df12,
    0xf64335bcf065d37d_4d4617b5ff4a16d6,
    0x99ea0196163fa42e_504bced1bf8e4e46,
    0xc06481fb9bcf8d39_e45ec2862f71e1d7,
    0xf07da27a82c37088_5d767327bb4e5a4d,
    0x964e858c91ba2655_3a6a07f8d510f870,
    0xbbe226efb628afea_890489f70a55368c,
    0xeadab0aba3b2dbe5_2b45ac74ccea842f,
    0x92c8ae6b464fc96f_3b0b8bc90012929e,
    0xb77ada0617e3bbcb_09ce6ebb40173745,
    0xe55990879ddcaabd_cc420a6a101d0516,
    0x8f57fa54c2a9eab6_9fa946824a12232e,
    0xb32df8e9f3546564_47939822dc96abfa,
    0xdff9772470297ebd_59787e2b93bc56f8,
    0x8bfbea76c619ef36_57eb4edb3c55b65b,
    0xaefae51477a06b03_ede622920b6b23f2,
    0xdab99e59958885c4_e95fab368e45ecee,
    0x88b402f7fd75539b_11dbcb0218ebb415,
    0xaae103b5fcd2a881_d652bdc29f26a11a,
    0xd59944a37c0752a2_4be76d3346f04960,
    0x857fcae62d8493a5_6f70a4400c562ddc,
    0xa6dfbd9fb8e5b88e_cb4ccd500f6bb953,
    0xd097ad07a71f26b2_7e2000a41346a7a8,
    0x825ecc24c873782f_8ed400668c0c28c9,
    0xa2f67f2dfa90563b_728900802f0f32fb,
    0xcbb41ef979346bca_4f2b40a03ad2ffba,
    0xfea126b7d78186bc_e2f610c84987bfa9,
    0x9f24b832e6b0f436_0dd9ca7d2df4d7ca,
    0xc6ede63fa05d3143_91503d1c79720dbc,
    0xf8a95fcf88747d94_75a44c6397ce912b,
    0x9b69dbe1b548ce7c_c986afbe3ee11abb,
    0xc24452da229b021b_fbe85badce996169,
    0xf2d56790ab41c2a2_fae27299423fb9c4,
    0x97c560ba6b0919a5_dccd879fc967d41b,
    0xbdb6b8e905cb600f_5400e987bbc1c921,
    0xed246723473e3813_290123e9aab23b69,
    0x9436c0760c86e30b_f9a0b6720aaf6522,
    0xb94470938fa89bce_f808e40e8d5b3e6a,
    0xe7958cb87392c2c2_b60b1d1230b20e05,
    0x90bd77f3483bb9b9_b1c6f22b5e6f48c3,
    0xb4ecd5f01a4aa828_1e38aeb6360b1af4,
    0xe2280b6c20dd5232_25c6da63c38de1b1,
    0x8d590723948a535f_579c487e5a38ad0f,
    0xb0af48ec79ace837_2d835a9df0c6d852,
    0xdcdb1b2798182244_f8e431456cf88e66,
    0x8a08f0f8bf0f156b_1b8e9ecb641b5900,
    0xac8b2d36eed2dac5_e272467e3d222f40,
    0xd7adf884aa879177_5b0ed81dcc6abb10,
    0x86ccbb52ea94baea_98e947129fc2b4ea,
    0xa87fea27a539e9a5_3f2398d747b36225,
    0xd29fe4b18e88640e_8eec7f0d19a03aae,
    0x83a3eeeef9153e89_1953cf68300424ad,
    0xa48ceaaab75a8e2b_5fa8c3423c052dd8,
    0xcdb02555653131b6_3792f412cb06794e,
    0x808e17555f3ebf11_e2bbd88bbee40bd1,
    0xa0b19d2ab70e6ed6_5b6aceaeae9d0ec5,
    0xc8de047564d20a8b_f245825a5a445276,
    0xfb158592be068d2e_eed6e2f0f0d56713,
    0x9ced737bb6c4183d_55464dd69685606c,
    0xc428d05aa4751e4c_aa97e14c3c26b887,
    0xf53304714d9265df_d53dd99f4b3066a9,
    0x993fe2c6d07b7fab_e546a8038efe402a,
    0xbf8fdb78849a5f96_de98520472bdd034,
    0xef73d256a5c0f77c_963e66858f6d4441,
    0x95a8637627989aad_dde7001379a44aa9,
    0xbb127c53b17ec159_5560c018580d5d53,
    0xe9d71b689dde71af_aab8f01e6e10b4a7,
    0x9226712162ab070d_cab3961304ca70e9,
    0xb6b00d69bb55c8d1_3d607b97c5fd0d23,
    0xe45c10c42a2b3b05_8cb89a7db77c506b,
    0x8eb98a7a9a5b04e3_77f3608e92adb243,
    0xb267ed1940f1c61c_55f038b237591ed4,
    0xdf01e85f912e37a3_6b6c46dec52f6689,
    0x8b61313bbabce2c6_2323ac4b3b3da016,
    0xae397d8aa96c1b77_abec975e0a0d081b,
    0xd9c7dced53c72255_96e7bd358c904a22,
    0x881cea14545c7575_7e50d64177da2e55,
    0xaa242499697392d2_dde50bd1d5d0b9ea,
    0xd4ad2dbfc3d07787_955e4ec64b44e865,
    0x84ec3c97da624ab4_bd5af13bef0b113f,
    0xa6274bbdd0fadd61_ecb1ad8aeacdd58f,
    0xcfb11ead453994ba_67de18eda5814af3,
    0x81ceb32c4b43fcf4_80eacf948770ced8,
    0xa2425ff75e14fc31_a1258379a94d028e,
    0xcad2f7f5359a3b3e_096ee45813a04331,
    0xfd87b5f28300ca0d_8bca9d6e188853fd,
    0x9e74d1b791e07e48_775ea264cf55347e,
    0xc612062576589dda_95364afe032a819e,
    0xf79687aed3eec551_3a83ddbd83f52205,
    0x9abe14cd44753b52_c4926a9672793543,
    0xc16d9a0095928a27_75b7053c0f178294,
    0xf1c90080baf72cb1_5324c68b12dd6339,
    0x971da05074da7bee_d3f6fc16ebca5e04,
    0xbce5086492111aea_88f4bb1ca6bcf585,
    0xec1e4a7db69561a5_2b31e9e3d06c32e6,
    0x9392ee8e921d5d07_3aff322e62439fd0,
    0xb877aa3236a4b449_09befeb9fad487c3,
    0xe69594bec44de15b_4c2ebe687989a9b4,
    0x901d7cf73ab0acd9_0f9d37014bf60a11,
    0xb424dc35095cd80f_538484c19ef38c95,
    0xe12e13424bb40e13_2865a5f206b06fba,
    0x8cbccc096f5088cb_f93f87b7442e45d4,
    0xafebff0bcb24aafe_f78f69a51539d749,
    0xdbe6fecebdedd5be_b573440e5a884d1c,
    0x89705f4136b4a597_31680a88f8953031,
    0xabcc77118461cefc_fdc20d2b36ba7c3e,
    0xd6bf94d5e57a42bc_3d32907604691b4d,
    0x8637bd05af6c69b5_a63f9a49c2c1b110,
    0xa7c5ac471b478423_0fcf80dc33721d54,
    0xd1b71758e219652b_d3c36113404ea4a9,
    0x83126e978d4fdf3b_645a1cac083126ea,
    0xa3d70a3d70a3d70a_3d70a3d70a3d70a4,
    0xcccccccccccccccc_cccccccccccccccd,
    0x8000000000000000_0000000000000000,
    0xa000000000000000_0000000000000000,
    0xc800000000000000_0000000000000000,
    0xfa00000000000000_0000000000000000,
    0x9c40000000000000_0000000000000000,
    0xc350000000000000_0000000000000000,
    0xf424000000000000_0000000000000000,
    0x9896800000000000_0000000000000000,
    0xbebc200000000000_0000000000000000,
    0xee6b280000000000_0000000000000000,
    0x9502f90000000000_0000000000000000,
    0xba43b74000000000_0000000000000000,
    0xe8d4a51000000000_0000000000000000,
    0x9184e72a00000000_0000000000000000,
    0xb5e620f480000000_0000000000000000,
    0xe35fa931a0000000_0000000000000000,
    0x8e1bc9bf04000000_0000000000000000,
    0xb1a2bc2ec5000000_0000000000000000,
    0xde0b6b3a76400000_0000000000000000,
    0x8ac7230489e80000_0000000000000000,
    0xad78ebc5ac620000_0000000000000000,
    0xd8d726b7177a8000_0000000000000000,
    0x878678326eac9000_0000000000000000,
    0xa968163f0a57b400_0000000000000000,
    0xd3c21bcecceda100_0000000000000000,
    0x84595161401484a0_0000000000000000,
    0xa56fa5b99019a5c8_0000000000000000,
    0xcecb8f27f4200f3a_0000000000000000,
    0x813f3978f8940984_4000000000000000,
    0xa18f07d736b90be5_5000000000000000,
    0xc9f2c9cd04674ede_a400000000000000,
    0xfc6f7c4045812296_4d00000000000000,
    0x9dc5ada82b70b59d_f020000000000000,
    0xc5371912364ce305_6c28000000000000,
    0xf684df56c3e01bc6_c732000000000000,
    0x9a130b963a6c115c_3c7f400000000000,
    0xc097ce7bc90715b3_4b9f100000000000,
    0xf0bdc21abb48db20_1e86d40000000000,
    0x96769950b50d88f4_1314448000000000,
    0xbc143fa4e250eb31_17d955a000000000,
    0xeb194f8e1ae525fd_5dcfab0800000000,
    0x92efd1b8d0cf37be_5aa1cae500000000,
    0xb7abc627050305ad_f14a3d9e40000000,
    0xe596b7b0c643c719_6d9ccd05d0000000,
    0x8f7e32ce7bea5c6f_e4820023a2000000,
    0xb35dbf821ae4f38b_dda2802c8a800000,
    0xe0352f62a19e306e_d50b2037ad200000,
    0x8c213d9da502de45_4526f422cc340000,
    0xaf298d050e4395d6_9670b12b7f410000,
    0xdaf3f04651d47b4c_3c0cdd765f114000,
    0x88d8762bf324cd0f_a5880a69fb6ac800,
    0xab0e93b6efee0053_8eea0d047a457a00,
    0xd5d238a4abe98068_72a4904598d6d880,
    0x85a36366eb71f041_47a6da2b7f864750,
    0xa70c3c40a64e6c51_999090b65f67d924,
    0xd0cf4b50cfe20765_fff4b4e3f741cf6d,
    0x82818f1281ed449f_bff8f10e7a8921a4,
    0xa321f2d7226895c7_aff72d52192b6a0d,
    0xcbea6f8ceb02bb39_9bf4f8a69f764490,
    0xfee50b7025c36a08_02f236d04753d5b4,
    0x9f4f2726179a2245_01d762422c946590,
    0xc722f0ef9d80aad6_424d3ad2b7b97ef5,
    0xf8ebad2b84e0d58b_d2e0898765a7deb2,
    0x9b934c3b330c8577_63cc55f49f88eb2f,
    0xc2781f49ffcfa6d5_3cbf6b71c76b25fb,
    0xf316271c7fc3908a_8bef464e3945ef7a,
    0x97edd871cfda3a56_97758bf0e3cbb5ac,
    0xbde94e8e43d0c8ec_3d52eeed1cbea317,
    0xed63a231d4c4fb27_4ca7aaa863ee4bdd,
    0x945e455f24fb1cf8_8fe8caa93e74ef6a,
    0xb975d6b6ee39e436_b3e2fd538e122b44,
    0xe7d34c64a9c85d44_60dbbca87196b616,
    0x90e40fbeea1d3a4a_bc8955e946fe31cd,
    0xb51d13aea4a488dd_6babab6398bdbe41,
    0xe264589a4dcdab14_c696963c7eed2dd1,
    0x8d7eb76070a08aec_fc1e1de5cf543ca2,
    0xb0de65388cc8ada8_3b25a55f43294bcb,
    0xdd15fe86affad912_49ef0eb713f39ebe,
    0x8a2dbf142dfcc7ab_6e3569326c784337,
    0xacb92ed9397bf996_49c2c37f07965404,
    0xd7e77a8f87daf7fb_dc33745ec97be906,
    0x86f0ac99b4e8dafd_69a028bb3ded71a3,
    0xa8acd7c0222311bc_c40832ea0d68ce0c,
    0xd2d80db02aabd62b_f50a3fa490c30190,
    0x83c7088e1aab65db_792667c6da79e0fa,
    0xa4b8cab1a1563f52_577001b891185938,
    0xcde6fd5e09abcf26_ed4c0226b55e6f86,
    0x80b05e5ac60b6178_544f8158315b05b4,
    0xa0dc75f1778e39d6_696361ae3db1c721,
    0xc913936dd571c84c_03bc3a19cd1e38e9,
    0xfb5878494ace3a5f_04ab48a04065c723,
    0x9d174b2dcec0e47b_62eb0d64283f9c76,
    0xc45d1df942711d9a_3ba5d0bd324f8394,
    0xf5746577930d6500_ca8f44ec7ee36479,
    0x9968bf6abbe85f20_7e998b13cf4e1ecb,
    0xbfc2ef456ae276e8_9e3fedd8c321a67e,
    0xefb3ab16c59b14a2_c5cfe94ef3ea101e,
    0x95d04aee3b80ece5_bba1f1d158724a12,
    0xbb445da9ca61281f_2a8a6e45ae8edc97,
    0xea1575143cf97226_f52d09d71a3293bd,
    0x924d692ca61be758_593c2626705f9c56,
    0xb6e0c377cfa2e12e_6f8b2fb00c77836c,
    0xe498f455c38b997a_0b6dfb9c0f956447,
    0x8edf98b59a373fec_4724bd4189bd5eac,
    0xb2977ee300c50fe7_58edec91ec2cb657,
    0xdf3d5e9bc0f653e1_2f2967b66737e3ed,
    0x8b865b215899f46c_bd79e0d20082ee74,
    0xae67f1e9aec07187_ecd8590680a3aa11,
    0xda01ee641a708de9_e80e6f4820cc9495,
    0x884134fe908658b2_3109058d147fdcdd,
    0xaa51823e34a7eede_bd4b46f0599fd415,
    0xd4e5e2cdc1d1ea96_6c9e18ac7007c91a,
    0x850fadc09923329e_03e2cf6bc604ddb0,
    0xa6539930bf6bff45_84db8346b786151c,
    0xcfe87f7cef46ff16_e612641865679a63,
    0x81f14fae158c5f6e_4fcb7e8f3f60c07e,
    0xa26da3999aef7749_e3be5e330f38f09d,
    0xcb090c8001ab551c_5cadf5bfd3072cc5,
    0xfdcb4fa002162a63_73d9732fc7c8f7f6,
    0x9e9f11c4014dda7e_2867e7fddcdd9afa,
    0xc646d63501a1511d_b281e1fd541501b8,
    0xf7d88bc24209a565_1f225a7ca91a4226,
    0x9ae757596946075f_3375788de9b06958,
    0xc1a12d2fc3978937_0052d6b1641c83ae,
    0xf209787bb47d6b84_c0678c5dbd23a49a,
    0x9745eb4d50ce6332_f840b7ba963646e0,
    0xbd176620a501fbff_b650e5a93bc3d898,
    0xec5d3fa8ce427aff_a3e51f138ab4cebe,
    0x93ba47c980e98cdf_c66f336c36b10137,
    0xb8a8d9bbe123f017_b80b0047445d4184,
    0xe6d3102ad96cec1d_a60dc059157491e5,
    0x9043ea1ac7e41392_87c89837ad68db2f,
    0xb454e4a179dd1877_29babe4598c311fb,
    0xe16a1dc9d8545e94_f4296dd6fef3d67a,
    0x8ce2529e2734bb1d_1899e4a65f58660c,
    0xb01ae745b101e9e4_5ec05dcff72e7f8f,
    0xdc21a1171d42645d_76707543f4fa1f73,
    0x899504ae72497eba_6a06494a791c53a8,
    0xabfa45da0edbde69_0487db9d17636892,
    0xd6f8d7509292d603_45a9d2845d3c42b6,
    0x865b86925b9bc5c2_0b8a2392ba45a9b2,
    0xa7f26836f282b732_8e6cac7768d7141e,
    0xd1ef0244af2364ff_3207d795430cd926,
    0x8335616aed761f1f_7f44e6bd49e807b8,
    0xa402b9c5a8d3a6e7_5f16206c9c6209a6,
    0xcd036837130890a1_36dba887c37a8c0f,
    0x802221226be55a64_c2494954da2c9789,
    0xa02aa96b06deb0fd_f2db9baa10b7bd6c,
    0xc83553c5c8965d3d_6f92829494e5acc7,
    0xfa42a8b73abbf48c_cb772339ba1f17f9,
    0x9c69a97284b578d7_ff2a760414536efb,
    0xc38413cf25e2d70d_fef5138519684aba,
    0xf46518c2ef5b8cd1_7eb258665fc25d69,
    0x98bf2f79d5993802_ef2f773ffbd97a61,
    0xbeeefb584aff8603_aafb550ffacfd8fa,
    0xeeaaba2e5dbf6784_95ba2a53f983cf38,
    0x952ab45cfa97a0b2_dd945a747bf26183,
    0xba756174393d88df_94f971119aeef9e4,
    0xe912b9d1478ceb17_7a37cd5601aab85d,
    0x91abb422ccb812ee_ac62e055c10ab33a,
    0xb616a12b7fe617aa_577b986b314d6009,
    0xe39c49765fdf9d94_ed5a7e85fda0b80b,
    0x8e41ade9fbebc27d_14588f13be847307,
    0xb1d219647ae6b31c_596eb2d8ae258fc8,
    0xde469fbd99a05fe3_6fca5f8ed9aef3bb,
    0x8aec23d680043bee_25de7bb9480d5854,
    0xada72ccc20054ae9_af561aa79a10ae6a,
    0xd910f7ff28069da4_1b2ba1518094da04,
    0x87aa9aff79042286_90fb44d2f05d0842,
    0xa99541bf57452b28_353a1607ac744a53,
    0xd3fa922f2d1675f2_42889b8997915ce8,
    0x847c9b5d7c2e09b7_69956135febada11,
    0xa59bc234db398c25_43fab9837e699095,
    0xcf02b2c21207ef2e_94f967e45e03f4bb,
    0x8161afb94b44f57d_1d1be0eebac278f5,
    0xa1ba1ba79e1632dc_6462d92a69731732,
    0xca28a291859bbf93_7d7b8f7503cfdcfe,
    0xfcb2cb35e702af78_5cda735244c3d43e,
    0x9defbf01b061adab_3a0888136afa64a7,
    0xc56baec21c7a1916_088aaa1845b8fdd0,
    0xf6c69a72a3989f5b_8aad549e57273d45,
    0x9a3c2087a63f6399_36ac54e2f678864b,
    0xc0cb28a98fcf3c7f_84576a1bb416a7dd,
    0xf0fdf2d3f3c30b9f_656d44a2a11c51d5,
    0x969eb7c47859e743_9f644ae5a4b1b325,
    0xbc4665b596706114_873d5d9f0dde1fee,
    0xeb57ff22fc0c7959_a90cb506d155a7ea,
    0x9316ff75dd87cbd8_09a7f12442d588f2,
    0xb7dcbf5354e9bece_0c11ed6d538aeb2f,
    0xe5d3ef282a242e81_8f1668c8a86da5fa,
    0x8fa475791a569d10_f96e017d694487bc,
    0xb38d92d760ec4455_37c981dcc395a9ac,
    0xe070f78d3927556a_85bbe253f47b1417,
    0x8c469ab843b89562_93956d7478ccec8e,
    0xaf58416654a6babb_387ac8d1970027b2,
    0xdb2e51bfe9d0696a_06997b05fcc0319e,
    0x88fcf317f22241e2_441fece3bdf81f03,
    0xab3c2fddeeaad25a_d527e81cad7626c3,
    0xd60b3bd56a5586f1_8a71e223d8d3b074,
    0x85c7056562757456_f6872d5667844e49,
    0xa738c6bebb12d16c_b428f8ac016561db,
    0xd106f86e69d785c7_e13336d701beba52,
    0x82a45b450226b39c_ecc0024661173473,
    0xa34d721642b06084_27f002d7f95d0190,
    0xcc20ce9bd35c78a5_31ec038df7b441f4,
    0xff290242c83396ce_7e67047175a15271,
    0x9f79a169bd203e41_0f0062c6e984d386,
    0xc75809c42c684dd1_52c07b78a3e60868,
    0xf92e0c3537826145_a7709a56ccdf8a82,
    0x9bbcc7a142b17ccb_88a66076400bb691,
    0xc2abf989935ddbfe_6acff893d00ea435,
    0xf356f7ebf83552fe_0583f6b8c4124d43,
    0x98165af37b2153de_c3727a337a8b704a,
    0xbe1bf1b059e9a8d6_744f18c0592e4c5c,
    0xeda2ee1c7064130c_1162def06f79df73,
    0x9485d4d1c63e8be7_8addcb5645ac2ba8,
    0xb9a74a0637ce2ee1_6d953e2bd7173692,
    0xe8111c87c5c1ba99_c8fa8db6ccdd0437,
    0x910ab1d4db9914a0_1d9c9892400a22a2,
    0xb54d5e4a127f59c8_2503beb6d00cab4b,
    0xe2a0b5dc971f303a_2e44ae64840fd61d,
    0x8da471a9de737e24_5ceaecfed289e5d2,
    0xb10d8e1456105dad_7425a83e872c5f47,
    0xdd50f1996b947518_d12f124e28f77719,
    0x8a5296ffe33cc92f_82bd6b70d99aaa6f,
    0xace73cbfdc0bfb7b_636cc64d1001550b,
    0xd8210befd30efa5a_3c47f7e05401aa4e,
    0x8714a775e3e95c78_65acfaec34810a71,
    0xa8d9d1535ce3b396_7f1839a741a14d0d,
    0xd31045a8341ca07c_1ede48111209a050,
    0x83ea2b892091e44d_934aed0aab460432,
    0xa4e4b66b68b65d60_f81da84d5617853f,
    0xce1de40642e3f4b9_36251260ab9d668e,
    0x80d2ae83e9ce78f3_c1d72b7c6b426019,
    0xa1075a24e4421730_b24cf65b8612f81f,
    0xc94930ae1d529cfc_dee033f26797b627,
    0xfb9b7cd9a4a7443c_169840ef017da3b1,
    0x9d412e0806e88aa5_8e1f289560ee864e,
    0xc491798a08a2ad4e_f1a6f2bab92a27e2,
    0xf5b5d7ec8acb58a2_ae10af696774b1db,
    0x9991a6f3d6bf1765_acca6da1e0a8ef29,
    0xbff610b0cc6edd3f_17fd090a58d32af3,
    0xeff394dcff8a948e_ddfc4b4cef07f5b0,
    0x95f83d0a1fb69cd9_4abdaf101564f98e,
    0xbb764c4ca7a4440f_9d6d1ad41abe37f1,
    0xea53df5fd18d5513_84c86189216dc5ed,
    0x92746b9be2f8552c_32fd3cf5b4e49bb4,
    0xb7118682dbb66a77_3fbc8c33221dc2a1,
    0xe4d5e82392a40515_0fabaf3feaa5334a,
    0x8f05b1163ba6832d_29cb4d87f2a7400e,
    0xb2c71d5bca9023f8_743e20e9ef511012,
    0xdf78e4b2bd342cf6_914da9246b255416,
    0x8bab8eefb6409c1a_1ad089b6c2f7548e,
    0xae9672aba3d0c320_a184ac2473b529b1,
    0xda3c0f568cc4f3e8_c9e5d72d90a2741e,
    0x8865899617fb1871_7e2fa67c7a658892,
    0xaa7eebfb9df9de8d_ddbb901b98feeab7,
    0xd51ea6fa85785631_552a74227f3ea565,
    0x8533285c936b35de_d53a88958f87275f,
    0xa67ff273b8460356_8a892abaf368f137,
    0xd01fef10a657842c_2d2b7569b0432d85,
    0x8213f56a67f6b29b_9c3b29620e29fc73,
    0xa298f2c501f45f42_8349f3ba91b47b8f,
    0xcb3f2f7642717713_241c70a936219a73,
    0xfe0efb53d30dd4d7_ed238cd383aa0110,
    0x9ec95d1463e8a506_f4363804324a40aa,
    0xc67bb4597ce2ce48_b143c6053edcd0d5,
    0xf81aa16fdc1b81da_dd94b7868e94050a,
    0x9b10a4e5e9913128_ca7cf2b4191c8326,
    0xc1d4ce1f63f57d72_fd1c2f611f63a3f0,
    0xf24a01a73cf2dccf_bc633b39673c8cec,
    0x976e41088617ca01_d5be0503e085d813,
    0xbd49d14aa79dbc82_4b2d8644d8a74e18,
    0xec9c459d51852ba2_ddf8e7d60ed1219e,
    0x93e1ab8252f33b45_cabb90e5c942b503,
    0xb8da1662e7b00a17_3d6a751f3b936243,
    0xe7109bfba19c0c9d_0cc512670a783ad4,
    0x906a617d450187e2_27fb2b80668b24c5,
    0xb484f9dc9641e9da_b1f9f660802dedf6,
    0xe1a63853bbd26451_5e7873f8a0396973,
    0x8d07e33455637eb2_db0b487b6423e1e8,
    0xb049dc016abc5e5f_91ce1a9a3d2cda62,
    0xdc5c5301c56b75f7_7641a140cc7810fb,
    0x89b9b3e11b6329ba_a9e904c87fcb0a9d,
    0xac2820d9623bf429_546345fa9fbdcd44,
    0xd732290fbacaf133_a97c177947ad4095,
    0x867f59a9d4bed6c0_49ed8eabcccc485d,
    0xa81f301449ee8c70_5c68f256bfff5a74,
    0xd226fc195c6a2f8c_73832eec6fff3111,
    0x83585d8fd9c25db7_c831fd53c5ff7eab,
    0xa42e74f3d032f525_ba3e7ca8b77f5e55,
    0xcd3a1230c43fb26f_28ce1bd2e55f35eb,
    0x80444b5e7aa7cf85_7980d163cf5b81b3,
    0xa0555e361951c366_d7e105bcc332621f,
    0xc86ab5c39fa63440_8dd9472bf3fefaa7,
    0xfa856334878fc150_b14f98f6f0feb951,
    0x9c935e00d4b9d8d2_6ed1bf9a569f33d3,
    0xc3b8358109e84f07_0a862f80ec4700c8,
    0xf4a642e14c6262c8_cd27bb612758c0fa,
    0x98e7e9cccfbd7dbd_8038d51cb897789c,
    0xbf21e44003acdd2c_e0470a63e6bd56c3,
    0xeeea5d5004981478_1858ccfce06cac74,
    0x95527a5202df0ccb_0f37801e0c43ebc8,
    0xbaa718e68396cffd_d30560258f54e6ba,
    0xe950df20247c83fd_47c6b82ef32a2069,
    0x91d28b7416cdd27e_4cdc331d57fa5441,
    0xb6472e511c81471d_e0133fe4adf8e952,
    0xe3d8f9e563a198e5_58180fddd97723a6,
    0x8e679c2f5e44ff8f_570f09eaa7ea7648,
    0xb201833b35d63f73_2cd2cc6551e513da,
    0xde81e40a034bcf4f_f8077f7ea65e58d1,
    0x8b112e86420f6191_fb04afaf27faf782,
    0xadd57a27d29339f6_79c5db9af1f9b563,
    0xd94ad8b1c7380874_18375281ae7822bc,
    0x87cec76f1c830548_8f2293910d0b15b5,
    0xa9c2794ae3a3c69a_b2eb3875504ddb22,
    0xd433179d9c8cb841_5fa60692a46151eb,
    0x849feec281d7f328_dbc7c41ba6bcd333,
    0xa5c7ea73224deff3_12b9b522906c0800,
    0xcf39e50feae16bef_d768226b34870a00,
    0x81842f29f2cce375_e6a1158300d46640,
    0xa1e53af46f801c53_60495ae3c1097fd0,
    0xca5e89b18b602368_385bb19cb14bdfc4,
    0xfcf62c1dee382c42_46729e03dd9ed7b5,
    0x9e19db92b4e31ba9_6c07a2c26a8346d1,
    0xc5a05277621be293_c7098b7305241885,
    0xf70867153aa2db38_b8cbee4fc66d1ea7,
];
