/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;

public class ActionProducer
extends Thread
implements Action,
Waitable,
Timeoutable {
    private static final long ACTION_TIMEOUT = 10000L;
    private Action action;
    private boolean needWait = true;
    private Object parameter;
    private boolean finished;
    private Object result = null;
    private Timeouts timeouts;
    private Waiter waiter = new Waiter(this);
    private TestOut output;
    private Throwable exception;

    public ActionProducer(Action a) {
        this.action = a;
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.finished = false;
        this.exception = null;
    }

    public ActionProducer(Action a, boolean nw) {
        this.action = a;
        this.needWait = nw;
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.finished = false;
        this.exception = null;
    }

    protected ActionProducer() {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.finished = false;
        this.exception = null;
    }

    protected ActionProducer(boolean nw) {
        this.needWait = nw;
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.finished = false;
        this.exception = null;
    }

    @Override
    public void setTimeouts(Timeouts ts) {
        this.timeouts = ts;
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        this.waiter.setOutput(this.output);
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setActionPriority(int newPriority) {
        int priority = newPriority < 1 ? 1 : (newPriority > 10 ? 10 : newPriority);
        try {
            this.setPriority(priority);
        }
        catch (IllegalArgumentException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public Object getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFinished() {
        ActionProducer actionProducer = this;
        synchronized (actionProducer) {
            return this.finished;
        }
    }

    @Override
    public Object launch(Object obj) {
        return null;
    }

    @Override
    public String getDescription() {
        if (this.action != null) {
            return this.action.getDescription();
        }
        return "Unknown action";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object produceAction(Object obj, String actionTimeOrigin) throws InterruptedException {
        this.parameter = obj;
        ActionProducer actionProducer = this;
        synchronized (actionProducer) {
            this.finished = false;
        }
        this.start();
        if (this.needWait) {
            this.waiter.setTimeoutsToCloneOf(this.timeouts, "ActionProducer.MaxActionTime", actionTimeOrigin);
            try {
                this.waiter.waitAction(null);
            }
            catch (TimeoutExpiredException e) {
                this.output.printError("Timeout for \"" + this.getDescription() + "\" action has been expired. Thread has been interrupted.");
                this.interrupt();
                throw e;
            }
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.result = null;
        try {
            this.result = this.launchAction(this.parameter);
        }
        catch (Throwable e) {
            this.exception = e;
        }
        ActionProducer actionProducer = this;
        synchronized (actionProducer) {
            this.finished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object actionProduced(Object obj) {
        ActionProducer actionProducer = this;
        synchronized (actionProducer) {
            if (this.finished) {
                if (this.result == null) {
                    return new Integer(0);
                }
                return this.result;
            }
            return null;
        }
    }

    private Object launchAction(Object obj) {
        if (this.action != null) {
            return this.action.launch(obj);
        }
        return this.launch(obj);
    }

    static {
        Timeouts.initDefault("ActionProducer.MaxActionTime", 10000L);
    }
}

