// Copyright 2018 clair authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package timeutil

import (
	"testing"
	"time"
)

func TestExpBackoff(t *testing.T) {
	tests := []struct {
		prev, max, want time.Duration
	}{
		{time.Duration(0), 1 * time.Minute, 1 * time.Second},
		{1 * time.Second, 1 * time.Minute, 2 * time.Second},
		{16 * time.Second, 1 * time.Minute, 32 * time.Second},
		{32 * time.Second, 1 * time.Minute, 1 * time.Minute},
		{1 * time.Minute, 1 * time.Minute, 1 * time.Minute},
		{2 * time.Minute, 1 * time.Minute, 1 * time.Minute},
	}

	for i, tt := range tests {
		got := ExpBackoff(tt.prev, tt.max)
		if tt.want != got {
			t.Errorf("case %d: want=%v got=%v", i, tt.want, got)
		}
	}
}
