/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//#define _DEBUGMODE 1
 
//
// Implementation
//
#ifdef HAVE_CONFIG_H
#include <../config.h>
#endif

#include <iostream>
#include <cstdlib>

#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <stdarg.h>
#include "netclient.h"
#include "gldefs.h"
#include "common.h"
#include "netmonitor.h"

using namespace std;

/* main function - startup */
int main(int argc, char *argv[])
{
	int i;
	
	while ((i = getopt(argc, argv, "htv")) != EOF) {
		switch (i) {
			case 't': 	// terminate app
				signal_process(APP_NETCLN, SIGKILL);
				exit(EXIT_SUCCESS);
				break;
			
			case 'v':	// version
				printf("%s\n", NETCLN_VERSION_STRING);
				exit(EXIT_SUCCESS);
				break;
			
			case 'h':	// help message
			default:
				printf("%s\n", TXT_NETSERVICE_NAME);
				printf("%s\n", TXT_INF_NETCLN_PROGRAMUSAGE);
				exit(EXIT_SUCCESS);
				break;
		}
	}
	
	printf("%s\n", NETCLN_VERSION_STRING);
	
	if (!is_root()) {
		printf("In order to execute this software, it is necessary to have a superuser privileges.\n");
		exit(EXIT_SUCCESS);
	}
	
	pid_t childpid; /* variable to store the child's pid */
	int status;     /* parent process: child's exit status */
	static int retval = 0;

	/* now create new process */
#ifndef _DEBUGMODE
	childpid = fork();
	if (childpid == 0) {/* fork() returns 0 to the child process */
		retval=service_start();
	} else if (childpid<0) {
		console_report("Fork failure (%s)!", strerror(errno));
	}
#else /*_DEBUGMODE*/
	service_start();
#endif/*_DEBUGMODE*/
	
	return EXIT_SUCCESS;
}

