/***************************************************************************
 *   Property rights (C) 2004-2006 by EVER Sp. z o.o.                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STRUCTS_H_
#define _STRUCTS_H_

#include "gldefs.h"

typedef long long __int64;

/* 
 * Ups states
 */
#define	US_POWERON					0x00000001
#define	US_POWERFAIL				0x00000002
#define	US_STANDBY					0x00000004
#define	US_OVERLOAD					0x00000008	/* assume last active state */
#define	US_AVRUP					0x00000010	/* also us_poweron */
#define	US_AVRLOWER					0x00000020	/* also us_poweron */
#define	US_BATTERYLOW				0x00000040	/* also us_powerfail */
#define	US_BATTERYDEPLETED			0x00000080	/* battery depleted - assume any state before */
#define	US_BYPASS					0x00000100
#define	US_WATCH					0x00000200	/* online (but not visible) load batteries only */
#define	US_SHORT					0x00000400
#define	US_INTERNALERROR			0x00000800
#define	US_INVERTERFAILURE			0x00001000
#define	US_TEMPERATURETOOHIGH		0x00002000
#define	US_TEMPERATURETOOLOW		0x00004000
#define	US_BADEXTERNALMODULES		0x00008000
#define	US_RETROACTIVEPOWER			0x00010000
#define US_BATTERYCHARGING			0x00020000
// 2006-04-06 - dodanie trybu awaryjnego (notified by sgrajek).
#define	US_FAILURE					0x00080000	// emergency mode is activated whenever a critical error occurs

/* 
 * Ups parameters
 */
#define	UP_PST_UPPER				0x0000000000000001LL
#define	UP_PST_LOWER				0x0000000000000002LL
#define	UP_PST_AVRUP				0x0000000000000004LL
#define	UP_PST_AVRLOW				0x0000000000000008LL
#define	UP_FRQ_INPUT				0x0000000000000010LL
#define	UP_FRQ_OUTPUT				0x0000000000000020LL
#define	UP_VLT_INPUT				0x0000000000000040LL
#define	UP_VLT_OUTPUT				0x0000000000000080LL
#define	UP_VLT_BATTERYLOAD			0x0000000000000100LL
#define	UP_VLT_BATTERY				0x0000000000000200LL
#define	UP_PRC_BATTERYCAPACITY		0x0000000000000400LL
#define	UP_PRC_POWERWEIGHT			0x0000000000000800LL
#define	UP_SNS_VOLTAGE				0x0000000000001000LL
#define	UP_SNS_FREQUENCY			0x0000000000002000LL
#define	UP_TMV_AUTONOMY				0x0000000000004000LL
#define	UP_TMV_ONBATTERY			0x0000000000008000LL
#define	UP_TMP_INVERTER				0x0000000000010000LL
#define	UP_TMP_CASING				0x0000000000020000LL
#define	UP_TMP_BATTERY				0x0000000000040000LL
#define	UP_UID_FAMILY				0x0000000000080000LL
#define	UP_UID_VERSION				0x0000000000100000LL
#define	UP_UID_MODEL				0x0000000000200000LL
#define	UP_LOAD_OUTPUT				0x0000000000400000LL
#define	UP_OV_EXTMODULES			0x0000000000800000LL
#define	UP_BATTERYSTATE				0x0000000001000000LL
#define UP_PWR_EFFECTIVE			0x0000000002000000LL	// moc czynna wyjsciowa
#define UP_PWR_APPARENT				0x0000000004000000LL	// moc pozorna wyjsciowa
#define UP_PWR_REACTIVE				0x0000000008000000LL	// moc bierna wyjsciowa
#define UP_CUR_OUTPUT				0x0000000010000000LL	// prad wyjsciowy
#define UP_PWR_COEFFICIENT			0x0000000020000000LL	// wspolcz. mocy wyjsciowej
/*
 * Extended UPS Parameters
 * 2005-10-09
 */
#define UP_EX_PWR_INP_COEFF			0x0000000100000000LL	// wspolcz. mocy wejciowej
#define UP_EX_CUR_ACCU				0x0000000200000000LL	// prad akumulatora
#define UP_EX_CUR_INPUT				0x0000000400000000LL	// prad wejsciowy
#define UP_EX_PWR_INP_EFFECTIVE		0x0000000800000000LL	// moc czynna wejsciowa
#define UP_EX_PWR_INP_APPARENT		0x0000001000000000LL	// moc pozorna wejsciowa
#define UP_EX_PWR_INP_REACTIVE		0x0000002000000000LL	// moc bierna wejsciowa
#define UP_EX_TMP_INVERTER_LEFT		0x0000004000000000LL	// moc pozorna wejsciowa
#define UP_EX_TMP_INVERTER_RIGHT	0x0000008000000000LL	// moc bierna wejsciowa
// zarezerwowane
#define UP_EX_RESERVED0				0x0000010000000000LL
#define UP_EX_RESERVED1				0x0000020000000000LL
#define UP_EX_RESERVED2				0x0000040000000000LL
#define UP_EX_RESERVED3				0x0000080000000000LL
#define UP_EX_RESERVED4				0x0000100000000000LL
#define UP_EX_RESERVED5				0x0000200000000000LL
#define UP_EX_RESERVED6				0x0000400000000000LL
#define UP_EX_RESERVED7				0x0000800000000000LL
#define UP_EX_RESERVED8				0x0001000000000000LL
#define UP_EX_RESERVED9				0x0002000000000000LL


/* 
 * Ups setup parameters
 */
// power state switch tresholds
#define	UP_SET_PST_UPPER				0x00000001
#define	UP_SET_PST_LOWER				0x00000002
#define	UP_SET_PST_AVRUP				0x00000004
#define	UP_SET_PST_AVRLOW				0x00000008
// audible alarms
#define	UP_SET_AAL_ON					0x00000010
// timers
#define	UP_SET_TMR_POWERFAILTOSTANDBY	0x00000020
#define	UP_SET_TMR_PROGRAM_UP			0x00000040
#define	UP_SET_TMR_PROGRAM_DOWN			0x00000080
// frequency
#define	UP_SET_FRQ_INPUT				0x00000100
#define	UP_SET_FRQ_OUTPUT				0x00000200
// sensitivities
#define	UP_SET_SNS_VOLTAGE				0x00000400
#define	UP_SET_SNS_FREQUENCY			0x00000800
// ups identification
#define	UP_SET_UID_USERNAME				0x00001000
// capacity for standby to online mode switching
#define	UP_SET_CAP_STDBY2ONLINE			0x00002000

/* 
 * Ups characteristics fields flags
 */
#define	UC_POWEROUT_MAX				0x00000001
#define	UC_ACCUSCALE				0x00000002
#define	UC_ADDMOD_MAXCAP			0x00000004
#define	UC_PST_LOWER_MIN			0x00000008
#define	UC_PST_LOWER_MAX			0x00000010
#define	UC_PST_UPPER_MIN			0x00000020
#define	UC_PST_UPPER_MAX			0x00000040
#define	UC_PST_AVRUP_MIN			0x00000080
#define	UC_PST_AVRDOWN_MAX			0x00000100
#define	UC_INFREQ_MIN				0x00000200
#define	UC_INFREQ_MAX				0x00000400
#define	UC_OUTFREQ_MIN				0x00000800
#define	UC_OUTFREQ_MAX				0x00001000
#define	UC_OUTVOLTAGE				0x00002000
#define	UC_ACCUFULLCAPVOLTAGE		0x00004000

/* 
 * Ups info fields flags
 */
#define	UI_CHARACTERISTICS			0x00000001
#define	UI_PARAMETERS				0x00000002
#define	UI_SETUP_PARAMETERS			0x00000004
#define	UI_UPS_STATE				0x00000008
#define	UI_UPS_STATISTICS			0x00000010
#define	UI_UPS_SCHEDULER			0x00000020

/* 
 * Main program operational flags
 */
#define OF_POWERON_PASS				US_POWERON
#define OF_POWERFAIL_PASS			US_POWERFAIL
#define OF_STANDBY_PASS				US_STANDBY
#define OF_OVERLOAD_PASS			US_OVERLOAD
#define OF_AVRUP_PASS				US_AVRUP
#define OF_AVRLOWER_PASS			US_AVRLOWER
#define OF_BATTERYLOW_PASS			US_BATTERYLOW
#define OF_BATTERYDEPLETED_PASS		US_BATTERYDEPLETED
#define OF_BYPASS_PASS				US_BYPASS
#define OF_WATCH_PASS				US_WATCH
#define OF_SHORT_PASS				US_SHORT
#define OF_INTERNALERROR_PASS		US_INTERNALERROR
#define OF_INVERTERFAILURE_PASS		US_INVERTERFAILURE
#define OF_TEMPERATURETOOHIGH_PASS	US_TEMPERATURETOOHIGH
#define OF_TEMPERATURETOOLOW_PASS	US_TEMPERATURETOOLOW
#define OF_BADEXTERNALMODULES_PASS	US_BADEXTERNALMODULES
#define OF_RETROACTIVEPOWER_PASS	US_RETROACTIVEPOWER
#define OF_BATTERYCHARGING_PASS		US_BATTERYCHARGING
#define OF_FAILURE_PASS				US_FAILURE
#define OF_ALL						(	OF_POWERON_PASS |				\
										OF_POWERFAIL_PASS |				\
										OF_STANDBY_PASS |				\
										OF_OVERLOAD_PASS |				\
										OF_AVRUP_PASS |					\
										OF_AVRLOWER_PASS |				\
										OF_BATTERYLOW_PASS |			\
										OF_BATTERYDEPLETED_PASS |		\
										OF_BYPASS_PASS |				\
										OF_WATCH_PASS |					\
										OF_SHORT_PASS |					\
										OF_INTERNALERROR_PASS |			\
										OF_INVERTERFAILURE_PASS |		\
										OF_TEMPERATURETOOHIGH_PASS |	\
										OF_TEMPERATURETOOLOW_PASS |		\
										OF_BADEXTERNALMODULES_PASS |	\
										OF_RETROACTIVEPOWER_PASS |		\
										OF_BATTERYCHARGING_PASS |		\
										OF_FAILURE_PASS )

/* 
 * Main program action/reaction flags
 */
#define ACF_POWERON					US_POWERON
#define ACF_POWERFAIL				US_POWERFAIL
#define ACF_STANDBY					US_STANDBY
#define ACF_OVERLOAD				US_OVERLOAD
#define ACF_AVRUP					US_AVRUP
#define ACF_AVRLOWER				US_AVRLOWER
#define ACF_BATTERYLOW				US_BATTERYLOW
#define ACF_BATTERYDEPLETED			US_BATTERYDEPLETED
#define ACF_BYPASS					US_BYPASS
#define ACF_WATCH					US_WATCH
#define ACF_SHORT					US_SHORT
#define ACF_INTERNALERROR			US_INTERNALERROR
#define ACF_INVERTERFAILURE			US_INVERTERFAILURE
#define ACF_TEMPERATURETOOHIGH		US_TEMPERATURETOOHIGH
#define ACF_TEMPERATURETOOLOW		US_TEMPERATURETOOLOW
#define ACF_BADEXTERNALMODULES		US_BADEXTERNALMODULES
#define ACF_RETROACTIVEPOWER		US_RETROACTIVEPOWER
#define ACF_BATTERYCHARGING			US_BATTERYCHARGING
#define ACF_FAILURE					US_FAILURE
#define ACF_ALL						(	ACF_POWERON |				\
										ACF_POWERFAIL |				\
										ACF_STANDBY |				\
										ACF_OVERLOAD |				\
										ACF_AVRUP |					\
										ACF_AVRLOWER |				\
										ACF_BATTERYLOW |			\
										ACF_BATTERYDEPLETED |		\
										ACF_BYPASS |				\
										ACF_WATCH |					\
										ACF_SHORT |					\
										ACF_INTERNALERROR |			\
										ACF_INVERTERFAILURE |		\
										ACF_TEMPERATURETOOHIGH |	\
										ACF_TEMPERATURETOOLOW |		\
										ACF_BADEXTERNALMODULES |	\
										ACF_RETROACTIVEPOWER |		\
										ACF_BATTERYCHARGING |		\
										ACF_FAILURE	)

/* 
 * Action status flags
 */
#define ACSF_DONE					0x0001

/*
 * Application internal flags
 */
#define APPF_LINKLOSTSTATE			0x0001

/* 
 * Ups communication type enumerator
 */
typedef enum _eups_link_
{
	ul_serial,
	ul_parallel,
	ul_usb,
	ul_irda,
	ul_ethernet,
	ul_other
} eups_link;

/* 
 * System shutdown modes
 */
typedef enum _eshutdown_mode_
{
	sm_normal,
	sm_forced,
	sm_reboot,
	sm_hibernate,
	sm_poweroff
} eshutdown_mode;

/*
 * Battery states
 */
typedef enum _ebattery_state
{
	bs_charging,
	bs_full,
	bs_discharging,
	bs_discharged,
	bs_depleted
} ebattery_state;

/*
 * Ups characteristics structure
 */
typedef struct _sups_characteristic_
{
	unsigned long	ulSize;
	/* mask used to determine which fields of this struct. are used */
	unsigned long	ulMask;

	unsigned int	ui__powerout_max;
	unsigned int	ui__powerout_max_div;
	
	unsigned int	ui__accuscale;
	unsigned int	ui__accuscale_div;
	
	unsigned int	ui__addmod_maxcap;
	unsigned int	ui__addmod_maxcap_div;
	
	unsigned int	ui__pst_lower_min;
	unsigned int	ui__pst_lower_min_div;
	unsigned int	ui__pst_lower_max;
	unsigned int	ui__pst_lower_max_div;
	unsigned int	ui__pst_upper_min;
	unsigned int	ui__pst_upper_min_div;
	unsigned int	ui__pst_upper_max;
	unsigned int	ui__pst_upper_max_div;
	unsigned int	ui__pst_avrup_min;
	unsigned int	ui__pst_avrup_min_div;
	unsigned int	ui__pst_avrdown_max;
	unsigned int	ui__pst_avrdown_max_div;

	unsigned int	ui__infreq_min;
	unsigned int	ui__infreq_min_div;
	unsigned int	ui__infreq_max;
	unsigned int	ui__infreq_max_div;
	unsigned int	ui__outfreq_min;
	unsigned int	ui__outfreq_min_div;
	unsigned int	ui__outfreq_max;
	unsigned int	ui__outfreq_max_div;

	unsigned int	ui__outvoltage;
	unsigned int	ui__outvoltage_div;

	unsigned int	ui__accufullcapvoltage;
	unsigned int	ui__accufullcapvoltage_div;

} sups_characteristic, supsch, *lpsups_characteristic, *lpsupsch;

/* 
 * Ups parameters structure
 */
#pragma pack(push,8)
typedef struct _sups_parameters_
{
	// structure size
	unsigned long	ulSize;
	// mask used to determine which fields of this struct. are used
	__int64			iMask;
	// power state switch tresholds - obsolete: for future removal
	unsigned int	ui__pst_upper;
	unsigned int	ui__pst_upper_div;
	unsigned int	ui__pst_lower;
	unsigned int	ui__pst_lower_div;
	unsigned int	ui__pst_avrup;
	unsigned int	ui__pst_avrup_div;
	unsigned int	ui__pst_avrlow;
	unsigned int	ui__pst_avrlow_div;
	// frequency
	unsigned int	ui__frq_input;					// czestotliwosc wejsciowa
	unsigned int	ui__frq_input_div;
	unsigned int	ui__frq_output;					// czestotliwosc wyjsciowa
	unsigned int	ui__frq_output_div;
	unsigned int	ui__vlt_input;					// napiecie wejsciowe
	unsigned int	ui__vlt_input_div;
	unsigned int	ui__vlt_output;					// napiecie wyjsciowe
	unsigned int	ui__vlt_output_div;
	unsigned int	ui__vlt_batteryload;			// napiecie ladowania baterii
	unsigned int	ui__vlt_batteryload_div;
	unsigned int	ui__vlt_battery;				// napiecie baterii
	unsigned int	ui__vlt_battery_div;
	unsigned int	ui__prc_batterycapacity;		// procentowa pojemnosc baterii
	unsigned int	ui__prc_batterycapacity_div;
	unsigned int	ui__prc_powerweight;			// procentowa wartosc obciazenia
	unsigned int	ui__prc_powerweight_div;
	unsigned int	ui__sns_voltage;				// czuolosc napiecia
	unsigned int	ui__sns_voltage_div;
	unsigned int	ui__sns_frequency;				// czuolosc czestotliwosci
	unsigned int	ui__sns_frequency_div;
	unsigned int	ui__tmv_autonomy;				// czas podtrzymania
	unsigned int	ui__tmv_autonomy_div;
	unsigned int	ui__tmv_onbattery;				// czas na baterii
	unsigned int	ui__tmv_onbattery_div;
	unsigned int	ui__tmp_inverter;				// temperatura inwertera
	unsigned int	ui__tmp_inverter_div;
	unsigned int	ui__tmp_casing;					// temperatura wew. obudowy
	unsigned int	ui__tmp_casing_div;
	unsigned int	ui__tmp_battery;				// temperatura baterii
	unsigned int	ui__tmp_battery_div;
	char			sz__uid_family[64];				// ups identification
	char			sz__uid_version[64];
	char			sz__uid_model[64];
	unsigned int	ui__load_output;				// obciazenie wyjscia
	unsigned int	ui__load_output_div;
	unsigned int	ui__ov_extmodules;				// number of extended modules
	unsigned int	ui__ov_extmodules_div;
	unsigned int	ui__batterystate;				// status baterii (ladowanie, naladowana, rozladowywanie, rozladowane, do wymiany)
	unsigned int	ui__pwr_effective;				// moc czynna wyjsciowa
	unsigned int	ui__pwr_effective_div;
	unsigned int	ui__pwr_apparent;				// moc pozorna wyjsciowa
	unsigned int	ui__pwr_apparent_div;
	unsigned int	ui__pwr_reactive;				// moc bierna wyjsciowa
	unsigned int	ui__pwr_reactive_div;
	unsigned int	ui__cur_output;					// prad wyjsciowy
	unsigned int	ui__cur_output_div;
	unsigned int	ui__pwr_coefficient;			// wspolczynnik mocy wyjsciowej
	unsigned int	ui__pwr_coefficient_div;

	// 2005 - extended parameters

	unsigned int	ui_ex_pwr_inp_coeff;			// wsp?z. mocy wej.
	unsigned int	ui_ex_pwr_inp_coeff_div;
	unsigned int	ui_ex_cur_battery;				// prd akumulatora
	unsigned int	ui_ex_cur_battery_div;
	unsigned int	ui_ex_cur_input;				// prd wejciowy
	unsigned int	ui_ex_cur_input_div;
	unsigned int	ui_ex_pwr_inp_effective;		// moc czynna wejciowa
	unsigned int	ui_ex_pwr_inp_effective_div;
	unsigned int	ui_ex_pwr_inp_apparent;			// moc pozorna wejciowa
	unsigned int	ui_ex_pwr_inp_apparent_div;
	unsigned int	ui_ex_pwr_inp_reactive;			// moc bierna wejciowa
	unsigned int	ui_ex_pwr_inp_reactive_div;
	unsigned int	ui_ex_tmp_inverter_left;		// temperatura lewej strony inwertera
	unsigned int	ui_ex_tmp_inverter_left_div;
	unsigned int	ui_ex_tmp_inverter_right;		// temperatura prawej strony inwertera
	unsigned int	ui_ex_tmp_inverter_right_div;
	
	// parametry zarezerwowane na przyszlosc
	unsigned int	ui_ex_reserved0;
	unsigned int	ui_ex_reserved0_div;
	unsigned int	ui_ex_reserved1;
	unsigned int	ui_ex_reserved1_div;
	unsigned int	ui_ex_reserved2;
	unsigned int	ui_ex_reserved2_div;
	unsigned int	ui_ex_reserved3;
	unsigned int	ui_ex_reserved3_div;
	unsigned int	ui_ex_reserved4;
	unsigned int	ui_ex_reserved4_div;
	unsigned int	ui_ex_reserved5;
	unsigned int	ui_ex_reserved5_div;
	unsigned int	ui_ex_reserved6;
	unsigned int	ui_ex_reserved6_div;
	unsigned int	ui_ex_reserved7;
	unsigned int	ui_ex_reserved7_div;
	unsigned int	ui_ex_reserved8;
	unsigned int	ui_ex_reserved8_div;
	unsigned int	ui_ex_reserved9;
	unsigned int	ui_ex_reserved9_div;
} sups_parameters, supsp, *lpsups_parameters, *lpsupsp;
#pragma pack(pop)
/*
 * Ups setup parameters structure
 */
typedef struct _sups_setup_parameters_
{
	unsigned long	ulSize;
	/* mask used to determine which fields of this struct. are used */
	unsigned long	ulMask;
	/* power state switch tresholds */
	unsigned int	ui__set_pst_upper;
	unsigned int	ui__set_pst_upper_div;
	unsigned int	ui__set_pst_lower;
	unsigned int	ui__set_pst_lower_div;
	unsigned int	ui__set_pst_avrup;
	unsigned int	ui__set_pst_avrup_div;
	unsigned int	ui__set_pst_avrlow;
	unsigned int	ui__set_pst_avrlow_div;
	/* audible alarms */
	unsigned int	ui__set_aal_on;
	/* timers */
	unsigned int	ui__set_tmr_powerfailtostandby;
	unsigned int	ui__set_tmr_powerfailtostandby_div;
	unsigned int	ui__set_tmr_program_up;
	unsigned int	ui__set_tmr_program_up_div;
	unsigned int	ui__set_tmr_program_down;
	unsigned int	ui__set_tmr_program_down_div;
	/* frequency */
	unsigned int	ui__set_frq_input;
	unsigned int	ui__set_frq_input_div;
	unsigned int	ui__set_frq_output;
	unsigned int	ui__set_frq_output_div;
	/* sensitivities */
	unsigned int	ui__set_sns_voltage;
	unsigned int	ui__set_sns_voltage_div;
	unsigned int	ui__set_sns_frequency;
	unsigned int	ui__set_sns_frequency_div;
	/* ups identification */
	char			sz__set_uid_username[64];

} sups_setup_parameters, supssp, *lpsups_setup_parameters, *lpsupssp;

/*
 * Main ups information structure
 */
typedef struct _sups_info_
{
	/* structure size - used for version identification */
	unsigned long	ulSize;
	unsigned long	ulMask;
	
	/* flag register used to determine which UPS states are used 
	 * from _ups_state_ enumerator.
	 */
	unsigned long	ulUpsStateMask;
	unsigned long	ulUpsState;

	/* UPS characteristic structure*/
	supsch			sUpsCharacteristic;
	
	/* UPS parameters structure */
	supsp			sUpsParameters;
	
	/* UPS setup parameters structure */
	supssp			sUpsSetupParameters;

} sups_info, *lpsups_info;

/*
 * Events configuration structure
 */
typedef struct _smgm_eventscfg_
{
	/* identifier of event */
	unsigned long	ulId;
	/* event type */
	unsigned long	ulType;
	/* displayed name of event */
	char			szName[128];
	/* true - if event is signalled */
	bool			bState;
} smgm_eventscfg;

/*
 * Driver specification structure (RO)
 */
typedef struct _sdrv_info_
{
	/* structure size - used for version identification */
	unsigned long	ulSize;
	/* driver version (Major.Minor) */
	unsigned int	uiVersionMajor;
	unsigned int	uiVersionMinor;
	/* driver class name */
	char			szName[64];
	/* hardware family name */
	char			szFamily[64];
	/* Type of communication medium */
	eups_link		eLink;
	/* Config file name */
	char			szCfgFileName[MAX_PATHBUFF];
	/* UPS bitmap file name */
	char			szBmpFileName[MAX_PATHBUFF];

} sdrv_info, *lpsdrv_info;

/*
 * Message structure
 */
typedef struct _smessage_
{
	/* message is active if this flag is set */
	bool	bEnabled;
	/* message content */
	char	szContent[256];

} smessage, *lpsmessage;

/* 
 * Command structure
 */
typedef struct _scommand_
{
	/* command is active if this flag is set */
	bool	bEnabled;
	/* command path */
	char	szPath[ MAX_PATHBUFF ];
	/* command directory */
	char	szDirectory[ MAX_PATHBUFF ];
	/* command parameters */
	char	szParams[ MAX_PATHBUFF ];

} scommand, *lpscommand;

/* 
 * E-Mail message structure
 */
typedef struct _semailmsg_
{
	/* email message is active if this flag is set */
	char	bEnabled;
	/* recipient address */
	char	szRecipient[ 256 ];
	/* subject of message */
	char	szSubject[ 128 ];
	/* content of message */
	char	szContent[ 256 ];
	/* sender name = send from */
	char	szSender[ 256 ];

} semailmsg, *lpsemailmsg;

/* 
 * Shutdown structure
 */
typedef struct _sshutdown_
{
	/* shutdown is active if this flag is set */
	bool	bEnabled;
	/* how to shutdown */
	eshutdown_mode	esm;
	/* shutdown after this time (in seconds) */
	unsigned long	ulTimeoutSec;

} sshutdown, *lpsshutdown;

/* 
 * User Action structure
 */
typedef struct _saction_
{
	/* action - message box */
	smessage	smsg;
	/* action - execute command */
	scommand	scmd;
	/* action - send e-mail message */
	semailmsg	sem;
	/* action - shutdown system */
	sshutdown	ssd;
	/* action status flag */
	unsigned long	ulflag;

} saction, *lpsaction;

/* 
 * Network computer structure
 */
typedef struct _snetworkcomputer_
{
	/* is computer enabled */
	bool	bEnabled;
	/* computer name or IP address */
	char	szComputer[256];
} snetworkcomputer, *lpsnetworkcomputer;

/* 
 * Program event structure
 */
typedef struct _sprogramevent_
{
	/* event identifier */
	unsigned long	ulId;
	/* is event enabled */
	bool			bEnabled;
	/* full event name */
	char			szTitle[128];
	/* number of actions to do */
	/* unsigned long	ulActCnt; */
	/* number of network actions to do */
	/* unsigned long	ulActFlag; */
	/* action to do if event occur */
	saction			sa;
	/* network action to do if event occur */
	bool			bNetwork;
	/* number of network computers id's */
	int				iNetCompsIdsCnt;
	/* network computers id's */
	unsigned long	ulNetCompIds[ INT_MAX_NETCOMPUTERS ];

} sprogramevent, *lpsprogramevent;

/* 
 * User configuration
 */
typedef struct _suser_config_
{
	/* structure size */
	unsigned long	ulSize;
	/* do ups shutdown after system shutdown or not */
	unsigned long	ulUpsShutdown;
	/* e-mail parameters - smtp server address */
	char			szSMTPServer[128];
	/* e-mail parameters - sender e-mail address */
	char			szSenderAddress[128];
	/* SMTP authorization - user */
	char			szSMTPAuth_Name[128];
	/* SMTP authorization - password */
	char			szSMTPAuth_Password[128];
	/* shutdown command */
	char			szShutdownCmd[MAX_PATHBUFF];
	/* number of configured program events */
	int			iPeCount;
	/* user - program events */
	sprogramevent	spe[ INT_MAX_PROGRAMEVENTS ];
	/* number of network computers */
	int			iNcCount;
	/* network computers */
	snetworkcomputer	snc[ INT_MAX_NETCOMPUTERS ];

} suser_config, *lpsuser_config;

/* 
 * Configuration universal values for internal use
 */
#undef INT_STRINGVALUE_MAX
#define INT_STRINGVALUE_MAX	256
#undef INT_STRINGLIST_MAX
#define INT_STRINGLIST_MAX	48
#undef INT_LISTITEMS_MAX
#define INT_LISTITEMS_MAX	128
#undef INT_VALUENAME_MAX
#define INT_VALUENAME_MAX	64

/* Enumerator typow*/
typedef enum _ecfg_vtype_
{
	VT_INTEGER,
	VT_LONG,
	VT_STRING,
	VT_INTLIST,
	VT_STRINGPWD,
} ecfg_vtype;

typedef struct tagList{
	char szName[ INT_STRINGLIST_MAX ]; 
	int iValue;
};

typedef struct tagRange{ 
	long lMin; 
	long lMax;
};
	
/* Struktura uniwersalnej wartosci */
typedef struct _scfg_value_
{
	/* type of value */
	ecfg_vtype eType;
	/* value name */
	char szName[ INT_VALUENAME_MAX ];
	/* selected value buffer */
	union { 
		int iValue; long lValue; char szValue[ INT_STRINGVALUE_MAX ]; 
	} value;
	/* value ranges (only for long and integer type) */
	tagRange	range;

	/* output divider */
	double	dDivider;
	/* list values */
	int		iListItems;
	tagList	list[ INT_LISTITEMS_MAX ];

} scfg_value, *lpscfg_value;

/***********************************************************
 * main program structure
 ***********************************************************/
typedef struct _sapp_config_
{
	/* driver selected for communication with UPS */
	sdrv_info	sdrvcfg;
	/* complete informations about ups */
	sups_info	supsi;
	/* error counter */
	int				iErrorCounter;
	/* operational flag register */
	unsigned long	ulOpFlag;
	/* action/reaction flag register */
	unsigned long	ulActFlag;
	/* last configured driver index */
	int				iDriver;

} sapp_config, *lpsapp_config;

/* 
 * Struktura laczaca parametr z konkretnym wskaznikiem do danej
 */
typedef struct _sparams_binder_
{
	/* parameter - identifier */
	__int64 iId;
	/* parameter - name */
	char szName[128];
	/* pointer to parameter value */
	void * lpVarPtr;
	/* pointer to value divider */
	void * lpDivPtr;
	/* parameter - desc */
	char szDesc[16];
	/* type of data */
	bool bIntegral;

} sparams_binder, *lpsparams_binder;

/* 
 * Uniwersalna struktura laczaca
 */
typedef struct _sbinder_
{
	/* identifier */
	unsigned long ulId;
	/* text to bind to */
	char szText[256];
	/* flag register */
	unsigned long ulFlag;

} sbinder, *lpsbinder;

/* 
 * Struktura program PSMain
 */
typedef struct _spsmain_config_
{
	/* driver selected for communication with UPS */
	sdrv_info	sdrvcfg;
	/* complete informations about ups */
	sups_info	supsi;

} spsmain_config, *lpspsmain_config;

/*
 * Shutdown structure helper
 * contains trigger and main shutdown structure
 */
typedef struct _ssdownhlp_ {
	lpsshutdown	lpssd;					// main shutdown structure
	unsigned long	ulTriggerFlag;		// shutdown trigger flag
} ssdownhlp, *lpssdownhlp;

/*
 * flow control identifiers
 */
#define STATUS_INACTIVE		0
#define STATUS_ACTIVE		1
#define STATUS_HASSTOPPED	2

/*
 * Program flow-control structure
 */
typedef struct _sflow_ctl_ {
	/* flag used to control monitoring thread */
	bool	bMonitorActive;
	int		iMonitorStatus;	// 0-inactive, 1-active, 2-has stopped
	/* flag used to control action thread */
	bool	bActionActive;
	int		iActionStatus;	// 0-inactive, 1-active, 2-has stopped
	/* flag used to control net management thread */
	bool	bNetMgmtActive;
	int		iNetMgmtStatus;	// 0-inactive, 1-active, 2-has stopped
	/* flag used to control main event loop */
	bool	bMainLoop;
	/* flag used to determine if debug mode is enabled */
	bool	bDebugMode;
	/* flag used to determine if update to UPS settings is needed */
	bool	bConfigUpdate;
	/* application internal flags */
	bool	bUpsStateReading;
	bool	bUpsOperationActive;
	bool	bShutdownProcActive;
	bool	bNetShutdownProcActive;
	bool	bUpsShutdownNow;
	long	lShutdownTimeout;
} sflow_ctl, *lpsflow_ctl;


/* shared memory segments */
#define AFLOWCTL_OFFSET	(0)
#define APPCFG_OFFSET	(AFLOWCTL_OFFSET+sizeof(sflow_ctl))
#define USRCFG_OFFSET	(APPCFG_OFFSET+sizeof(sapp_config))

#define PS_SHM_SIZE		(sizeof(sflow_ctl)+sizeof(sapp_config)+sizeof(suser_config))


#endif /*_STRUCTS_H_*/

