//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cPistol.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cPistol.hpp"

#include "cWorld.hpp"
#include "cBullet.hpp"
#include "cMixer.hpp"

//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================

//==============================================================================
//! Constructor
//------------------------------------------------------------------------------
cPistol::cPistol (void):
cWeapon (8, 300, 1000),
mSound (cMixer::GetInstance ().LoadSound ("pistol.wav")),
mReloadSound (cMixer::GetInstance ().LoadSound ("reload.wav"))
{
	SetAmmo (8, 4);
};
//==============================================================================

//==============================================================================
//! Destructor
//------------------------------------------------------------------------------
cPistol::~cPistol (void)
{
	// Empty
};
//==============================================================================

//==============================================================================
void 
cPistol::Fire (const cVector2f &position, float angle)
{
	cMixer::GetInstance ().PlaySound (mSound);
	
	SpawnSuuliekki ();
	
	// Spawn a bullet object
	cBullet *pBullet = new cBullet;
	pBullet->SetPosition (position);
	pBullet->SetRotation (angle);
	pBullet->SetOwner (GetOwner ());
	
	pBullet->Rotate (-2.5f + 5.0f * rand () / (RAND_MAX + 1.0f));
	pBullet->Move (0.0f, 16.0f);
	pBullet->SetVelocity (pBullet->GetDirection () * 2.0f);
	pBullet->SetDamage (5);
	cWorld::GetInstance ().SpawnObject (pBullet);
}

void cPistol::EndReload (void) 
{
	cMixer::GetInstance ().PlaySound (mReloadSound);
}
//==============================================================================

//==============================================================================
// EOF
//==============================================================================
