/* icd.h

    icdprog - an open source PIC programmer for use with the Microchip ICD(1)
    Copyright (C) 2001-2004  Geir Thomassen, Andrew Ferry.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/

/* Programmer mode & target memory 
 */
#define READ 2
#define VERIFY 1
#define PROGRAM 0
#define CONFIG 2
#define EEPROM 1
#define FLASH 0

/* ICD commands */
#define ICD_EN_VPP 		0x7000
#define ICD_DIS_VPP 		0x7001
#define ICD_READ 		0x7002
#define ICD_INC_ADDR 		0x7003
#define ICD_PROG_FLASH 		0x7005
#define ICD_PROG_EEPROM 	0x7006
#define ICD_ERASE 		0x7007

#define ICD_GET_VCC 		0x701C
#define ICD_GET_VPP 		0x701D
#define ICD_GET_CONTROLLER_TYPE 0x7020
#define ICD_GET_VER_MINOR 	0x7021
#define ICD_GET_VER_MAJOR 	0x7F00
#define ICD_EXT_ADDR 		0xC000 

/* ICD commands with ORed paramter 
*/
#define ICD_SET_ADDR 		0x2000  //| addr
#define ICD_WRITE 		0x8000  //| data

typedef struct {
	int type;
	int flash_max;
	int eeprom_max;
} controller;

int icd_init(char *dev);
controller icd_controller_type();
int icd_erase();
int icd_prog (int *mem, int prog_cmd, int start, int finish, int mode);        
int icd_prog_ext(int *mem, int start, int finish, int mode);
