/* -*-c++-*- 
*
*  OpenSceneGraph example, osghangglide.
*
*  Permission is hereby granted, free of charge, to any person obtaining a copy
*  of this software and associated documentation files (the "Software"), to deal
*  in the Software without restriction, including without limitation the rights
*  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*  copies of the Software, and to permit persons to whom the Software is
*  furnished to do so, subject to the following conditions:
*
*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*  THE SOFTWARE.
*/

#if defined(_WIN32) && !(defined(__CYGWIN__) || defined(__MINGW32__))
    // disable the double to float errors.
    #pragma warning( disable : 4305 )
#endif

static float normal[][3] = {
    {  -0.2560,  -0.1125,   0.9600 },
    {  -0.2850,  -0.1272,   0.9501 },
    {  -0.3146,  -0.0941,   0.9440 },
    {  -0.3295,  -0.0626,   0.9419 },
    {  -0.3154,  -0.0315,   0.9474 },
    {  -0.2560,   0.0162,   0.9644 },
    {  -0.1784,   0.0328,   0.9801 },
    {  -0.1145,   0.0493,   0.9887 },
    {  -0.0488,   0.0494,   0.9908 },
    {   0.0001,   0.0497,   0.9964 },
    {   0.0331,   0.0666,   0.9950 },
    {   0.0825,   0.0828,   0.9918 },
    {   0.0824,   0.0988,   0.9905 },
    {   0.0662,   0.0826,   0.9937 },
    {   0.0166,   0.0663,   0.9975 },
    {  -0.0166,   0.0500,   0.9983 },
    {  -0.0665,   0.0334,   0.9972 },
    {  -0.1157,   0.0000,   0.9926 },
    {  -0.1794,  -0.0812,   0.9791 },
    {  -0.1626,  -0.1459,   0.9757 },
    {  -0.1135,  -0.1954,   0.9734 },
    {  -0.0161,  -0.2432,   0.9696 },
    {   0.0810,  -0.2098,   0.9731 },
    {   0.1469,  -0.1302,   0.9799 },
    {   0.1639,  -0.0653,   0.9838 },
    {   0.1321,  -0.0165,   0.9910 },
    {   0.0665,   0.0166,   0.9975 },
    {   0.0167,   0.0332,   0.9992 },
    {  -0.0166,   0.0498,   0.9983 },
    {  -0.0166,   0.0663,   0.9975 },
    {  -0.0166,   0.0500,   0.9983 },
    {  -0.0167,   0.0334,   0.9992 },
    {  -0.0333,   0.0166,   0.9992 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0499,   0.0168,   0.9983 },
    {  -0.0665,   0.0334,   0.9972 },
    {  -0.0829,   0.0331,   0.9959 },
    {  -0.0992,   0.0000,   0.9940 },
    {  -0.2244,  -0.1451,   0.9630 },
    {  -0.2539,  -0.1595,   0.9535 },
    {  -0.2693,  -0.1266,   0.9531 },
    {  -0.2847,  -0.0792,   0.9533 },
    {  -0.2698,  -0.0159,   0.9586 },
    {  -0.2396,   0.0647,   0.9650 },
    {  -0.1939,   0.0978,   0.9741 },
    {  -0.1470,   0.0981,   0.9831 },
    {  -0.0981,   0.1147,   0.9862 },
    {  -0.0330,   0.1154,   0.9921 },
    {   0.0000,   0.1163,   0.9925 },
    {   0.0331,   0.1163,   0.9925 },
    {   0.0497,   0.0991,   0.9937 },
    {   0.0332,   0.0662,   0.9967 },
    {   0.0167,   0.0332,   0.9992 },
    {  -0.0166,   0.0166,   0.9994 },
    {  -0.0665,  -0.0166,   0.9975 },
    {  -0.1318,  -0.0657,   0.9886 },
    {  -0.1794,  -0.0976,   0.9788 },
    {  -0.1633,  -0.1140,   0.9798 },
    {  -0.1310,  -0.1315,   0.9826 },
    {  -0.0495,  -0.1325,   0.9898 },
    {   0.0494,  -0.1153,   0.9907 },
    {   0.1148,  -0.0985,   0.9873 },
    {   0.1314,  -0.0820,   0.9873 },
    {   0.0991,  -0.0664,   0.9923 },
    {   0.0498,  -0.0502,   0.9972 },
    {   0.0167,   0.0000,   0.9992 },
    {   0.0000,   0.0498,   0.9986 },
    {  -0.0166,   0.0663,   0.9975 },
    {  -0.0166,   0.0500,   0.9983 },
    {  -0.0167,   0.0168,   0.9994 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0499,   0.0000,   0.9986 },
    {  -0.0499,   0.0000,   0.9986 },
    {  -0.0830,   0.0000,   0.9964 },
    {  -0.0995,   0.0000,   0.9950 },
    {  -0.1481,  -0.0328,   0.9877 },
    {  -0.1934,  -0.1619,   0.9671 },
    {  -0.1927,  -0.1776,   0.9644 },
    {  -0.1781,  -0.1294,   0.9738 },
    {  -0.1630,  -0.0652,   0.9818 },
    {  -0.1146,   0.0164,   0.9887 },
    {  -0.0818,   0.0993,   0.9877 },
    {  -0.0491,   0.1321,   0.9866 },
    {  -0.0164,   0.1474,   0.9854 },
    {   0.0163,   0.1638,   0.9851 },
    {   0.0492,   0.1475,   0.9865 },
    {   0.0658,   0.1323,   0.9885 },
    {   0.0658,   0.1323,   0.9885 },
    {   0.0825,   0.0987,   0.9910 },
    {   0.0498,   0.0497,   0.9972 },
    {   0.0333,   0.0166,   0.9992 },
    {   0.0000,  -0.0336,   0.9989 },
    {  -0.0497,  -0.0831,   0.9950 },
    {  -0.1150,  -0.1148,   0.9864 },
    {  -0.1633,  -0.1140,   0.9798 },
    {  -0.1794,  -0.0976,   0.9788 },
    {  -0.1635,  -0.0821,   0.9825 },
    {  -0.1152,  -0.0663,   0.9899 },
    {  -0.0496,  -0.0497,   0.9962 },
    {  -0.0164,  -0.0496,   0.9951 },
    {   0.0165,  -0.0825,   0.9929 },
    {   0.0166,  -0.0998,   0.9936 },
    {   0.0166,  -0.0669,   0.9969 },
    {   0.0167,  -0.0166,   0.9994 },
    {   0.0000,   0.0166,   0.9997 },
    {  -0.0166,   0.0498,   0.9983 },
    {  -0.0333,   0.0500,   0.9981 },
    {  -0.0333,   0.0168,   0.9992 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0499,  -0.0166,   0.9983 },
    {  -0.0665,  -0.0166,   0.9975 },
    {  -0.0830,  -0.0168,   0.9961 },
    {  -0.0995,  -0.0167,   0.9948 },
    {  -0.1318,  -0.0329,   0.9897 },
    {  -0.1638,  -0.0817,   0.9830 },
    {  -0.1619,  -0.1628,   0.9728 },
    {  -0.0977,  -0.1479,   0.9819 },
    {  -0.0491,  -0.0986,   0.9900 },
    {   0.0001,  -0.0165,   0.9937 },
    {   0.0494,   0.0659,   0.9926 },
    {   0.0815,   0.1318,   0.9840 },
    {   0.0976,   0.1639,   0.9795 },
    {   0.1139,   0.1627,   0.9789 },
    {   0.1293,   0.1779,   0.9733 },
    {   0.1301,   0.1623,   0.9771 },
    {   0.1308,   0.1315,   0.9821 },
    {   0.1308,   0.1315,   0.9821 },
    {   0.0990,   0.0821,   0.9905 },
    {   0.0830,   0.0166,   0.9961 },
    {   0.0499,  -0.0166,   0.9983 },
    {   0.0000,  -0.0669,   0.9972 },
    {  -0.0330,  -0.1322,   0.9902 },
    {  -0.0816,  -0.1792,   0.9802 },
    {  -0.1138,  -0.1625,   0.9784 },
    {  -0.1468,  -0.1141,   0.9812 },
    {  -0.1474,  -0.0657,   0.9852 },
    {  -0.1154,  -0.0167,   0.9918 },
    {  -0.0830,  -0.0166,   0.9961 },
    {  -0.0663,  -0.0331,   0.9967 },
    {  -0.0498,  -0.0497,   0.9972 },
    {  -0.0332,  -0.0667,   0.9972 },
    {  -0.0166,  -0.0502,   0.9983 },
    {  -0.0167,  -0.0166,   0.9994 },
    {  -0.0167,   0.0166,   0.9994 },
    {  -0.0167,   0.0332,   0.9992 },
    {  -0.0166,   0.0334,   0.9992 },
    {  -0.0333,   0.0168,   0.9992 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0499,  -0.0332,   0.9981 },
    {  -0.0665,  -0.0332,   0.9972 },
    {  -0.0994,  -0.0333,   0.9945 },
    {  -0.1157,  -0.0497,   0.9918 },
    {  -0.1479,  -0.0656,   0.9867 },
    {  -0.1477,  -0.0819,   0.9854 },
    {  -0.1315,  -0.0987,   0.9859 },
    {  -0.0663,  -0.0666,   0.9950 },
    {   0.0000,  -0.0332,   0.9983 },
    {   0.0664,   0.0331,   0.9961 },
    {   0.0989,   0.0985,   0.9891 },
    {   0.1306,   0.1476,   0.9797 },
    {   0.1623,   0.1628,   0.9732 },
    {   0.1775,   0.1769,   0.9678 },
    {   0.1931,   0.1764,   0.9651 },
    {   0.1627,   0.1459,   0.9757 },
    {   0.1631,   0.1309,   0.9779 },
    {   0.1313,   0.0990,   0.9853 },
    {   0.0830,   0.0496,   0.9950 },
    {   0.0664,   0.0000,   0.9967 },
    {   0.0498,  -0.0661,   0.9959 },
    {   0.0166,  -0.1164,   0.9928 },
    {   0.0164,  -0.1644,   0.9845 },
    {   0.0322,  -0.1946,   0.9755 },
    {   0.0482,  -0.1784,   0.9760 },
    {   0.0479,  -0.1300,   0.9789 },
    {   0.0638,  -0.0489,   0.9821 },
    {   0.0648,   0.0000,   0.9892 },
    {   0.0648,   0.0000,   0.9892 },
    {   0.0656,  -0.0165,   0.9926 },
    {   0.0494,  -0.0496,   0.9940 },
    {   0.0493,  -0.0665,   0.9931 },
    {   0.0331,  -0.0501,   0.9958 },
    {   0.0166,  -0.0166,   0.9983 },
    {   0.0000,   0.0166,   0.9992 },
    {  -0.0166,   0.0498,   0.9983 },
    {  -0.0166,   0.0332,   0.9986 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0499,  -0.0497,   0.9972 },
    {  -0.0664,  -0.0662,   0.9956 },
    {  -0.0829,  -0.0665,   0.9942 },
    {  -0.0992,  -0.0664,   0.9923 },
    {  -0.1157,  -0.0659,   0.9910 },
    {  -0.1155,  -0.0822,   0.9896 },
    {  -0.1318,  -0.0659,   0.9886 },
    {  -0.1158,  -0.0167,   0.9929 },
    {  -0.0663,   0.0331,   0.9962 },
    {  -0.0165,   0.0827,   0.9951 },
    {   0.0330,   0.1315,   0.9897 },
    {   0.0814,   0.1961,   0.9765 },
    {   0.1290,   0.2107,   0.9683 },
    {   0.1611,   0.1930,   0.9674 },
    {   0.1619,   0.1615,   0.9725 },
    {   0.1470,   0.1304,   0.9804 },
    {   0.1149,   0.0987,   0.9867 },
    {   0.0829,   0.0500,   0.9950 },
    {   0.0499,   0.0166,   0.9983 },
    {   0.0167,  -0.0166,   0.9994 },
    {   0.0166,  -0.0662,   0.9970 },
    {   0.0331,  -0.0998,   0.9945 },
    {   0.0661,  -0.1159,   0.9909 },
    {   0.1307,  -0.1466,   0.9804 },
    {   0.1783,  -0.1455,   0.9729 },
    {   0.2257,  -0.0965,   0.9684 },
    {   0.2421,  -0.0485,   0.9688 },
    {   0.2268,  -0.0164,   0.9732 },
    {   0.2268,  -0.0162,   0.9732 },
    {   0.1955,  -0.0488,   0.9788 },
    {   0.1793,  -0.0652,   0.9805 },
    {   0.1477,  -0.0825,   0.9853 },
    {   0.1154,  -0.0829,   0.9896 },
    {   0.0992,  -0.0495,   0.9932 },
    {   0.0664,  -0.0166,   0.9970 },
    {   0.0332,   0.0166,   0.9986 },
    {  -0.0167,   0.0166,   0.9994 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0498,  -0.0331,   0.9975 },
    {  -0.0664,  -0.0662,   0.9956 },
    {  -0.0664,  -0.0662,   0.9956 },
    {  -0.0828,  -0.0665,   0.9942 },
    {  -0.0827,  -0.0829,   0.9929 },
    {  -0.0827,  -0.0825,   0.9929 },
    {  -0.0991,  -0.0824,   0.9915 },
    {  -0.0658,  -0.0662,   0.9929 },
    {  -0.0493,  -0.0002,   0.9948 },
    {  -0.0164,   0.0660,   0.9937 },
    {   0.0001,   0.1313,   0.9886 },
    {   0.0326,   0.1951,   0.9792 },
    {   0.0805,   0.2426,   0.9665 },
    {   0.0965,   0.2423,   0.9652 },
    {   0.0971,   0.2100,   0.9722 },
    {   0.0979,   0.1629,   0.9807 },
    {   0.0822,   0.0986,   0.9900 },
    {   0.0498,   0.0667,   0.9964 },
    {   0.0332,   0.0336,   0.9978 },
    {   0.0166,  -0.0166,   0.9994 },
    {   0.0000,  -0.0332,   0.9994 },
    {   0.0000,  -0.0498,   0.9986 },
    {   0.0332,  -0.0667,   0.9972 },
    {   0.0498,  -0.0667,   0.9964 },
    {   0.0989,  -0.0823,   0.9910 },
    {   0.1635,  -0.0816,   0.9825 },
    {   0.2105,  -0.0648,   0.9743 },
    {   0.2265,  -0.0487,   0.9721 },
    {   0.2268,  -0.0164,   0.9732 },
    {   0.2107,  -0.0324,   0.9753 },
    {   0.1953,  -0.0650,   0.9781 },
    {   0.1787,  -0.0974,   0.9774 },
    {   0.1470,  -0.1312,   0.9803 },
    {   0.1314,  -0.0991,   0.9858 },
    {   0.0991,  -0.0660,   0.9923 },
    {   0.0663,  -0.0497,   0.9959 },
    {   0.0332,  -0.0332,   0.9983 },
    {  -0.0167,  -0.0334,   0.9992 },
    {  -0.0499,  -0.0334,   0.9981 },
    {  -0.0829,  -0.0496,   0.9950 },
    {  -0.0828,  -0.0661,   0.9942 },
    {  -0.0827,  -0.0825,   0.9929 },
    {  -0.0991,  -0.0828,   0.9915 },
    {  -0.0993,  -0.0665,   0.9928 },
    {  -0.0827,  -0.0825,   0.9929 },
    {  -0.0827,  -0.0825,   0.9929 },
    {   0.0660,  -0.0165,   0.9953 },
    {   0.1145,   0.0328,   0.9890 },
    {   0.1308,   0.0819,   0.9857 },
    {   0.1455,   0.1298,   0.9770 },
    {   0.1282,   0.2083,   0.9664 },
    {   0.1119,   0.2570,   0.9598 },
    {   0.0968,   0.2268,   0.9685 },
    {   0.0652,   0.1952,   0.9786 },
    {   0.0329,   0.1473,   0.9868 },
    {   0.0000,   0.0828,   0.9959 },
    {   0.0000,   0.0500,   0.9981 },
    {  -0.0166,   0.0168,   0.9994 },
    {  -0.0166,  -0.0166,   0.9994 },
    {  -0.0166,  -0.0332,   0.9992 },
    {  -0.0166,  -0.0332,   0.9992 },
    {   0.0000,  -0.0502,   0.9980 },
    {   0.0166,  -0.0502,   0.9983 },
    {   0.0499,  -0.0332,   0.9981 },
    {   0.0827,  -0.0331,   0.9948 },
    {   0.1154,  -0.0330,   0.9915 },
    {   0.1313,  -0.0331,   0.9886 },
    {   0.1313,  -0.0331,   0.9886 },
    {   0.1153,  -0.0494,   0.9907 },
    {   0.1151,  -0.0821,   0.9886 },
    {   0.0822,  -0.1150,   0.9886 },
    {   0.0491,  -0.1321,   0.9866 },
    {   0.0163,  -0.1318,   0.9845 },
    {  -0.0325,  -0.1149,   0.9878 },
    {  -0.0652,  -0.0822,   0.9894 },
    {  -0.0819,  -0.0659,   0.9911 },
    {  -0.0825,  -0.0665,   0.9931 },
    {  -0.0828,  -0.0665,   0.9942 },
    {  -0.0993,  -0.0660,   0.9929 },
    {  -0.0993,  -0.0660,   0.9929 },
    {  -0.0991,  -0.0824,   0.9915 },
    {  -0.0991,  -0.0828,   0.9915 },
    {  -0.0993,  -0.0665,   0.9928 },
    {  -0.0993,  -0.0660,   0.9929 },
    {  -0.0989,  -0.0823,   0.9910 },
    {   0.1638,   0.0658,   0.9838 },
    {   0.2112,   0.0653,   0.9751 },
    {   0.2257,   0.0965,   0.9684 },
    {   0.2404,   0.1279,   0.9621 },
    {   0.2239,   0.1595,   0.9605 },
    {   0.1605,   0.2097,   0.9638 },
    {   0.0975,   0.1958,   0.9752 },
    {   0.0493,   0.1477,   0.9875 },
    {   0.0000,   0.0991,   0.9945 },
    {  -0.0332,   0.0663,   0.9972 },
    {  -0.0499,   0.0499,   0.9972 },
    {  -0.0499,   0.0168,   0.9983 },
    {  -0.0499,  -0.0166,   0.9983 },
    {  -0.0499,  -0.0332,   0.9981 },
    {  -0.0499,  -0.0332,   0.9981 },
    {  -0.0333,  -0.0334,   0.9989 },
    {  -0.0167,  -0.0168,   0.9994 },
    {   0.0000,  -0.0166,   0.9992 },
    {   0.0166,  -0.0166,   0.9994 },
    {   0.0332,  -0.0166,   0.9986 },
    {   0.0499,  -0.0334,   0.9981 },
    {   0.0499,  -0.0334,   0.9981 },
    {   0.0332,  -0.0497,   0.9975 },
    {   0.0165,  -0.0990,   0.9932 },
    {   0.0000,  -0.1636,   0.9854 },
    {  -0.0489,  -0.1966,   0.9791 },
    {  -0.1139,  -0.1798,   0.9768 },
    {  -0.1467,  -0.1463,   0.9780 },
    {  -0.1793,  -0.0975,   0.9783 },
    {  -0.1642,  -0.0491,   0.9851 },
    {  -0.1321,  -0.0332,   0.9907 },
    {  -0.0994,  -0.0498,   0.9937 },
    {  -0.0828,  -0.0661,   0.9942 },
    {  -0.0828,  -0.0661,   0.9942 },
    {  -0.0991,  -0.0824,   0.9915 },
    {  -0.0827,  -0.0829,   0.9929 },
    {  -0.0993,  -0.0665,   0.9928 },
    {  -0.0991,  -0.0824,   0.9915 },
    {  -0.1315,  -0.0984,   0.9864 },
    {   0.1953,   0.0980,   0.9758 },
    {   0.2108,   0.0976,   0.9725 },
    {   0.2410,   0.1121,   0.9638 },
    {   0.2252,   0.1284,   0.9653 },
    {   0.2094,   0.1288,   0.9682 },
    {   0.1466,   0.1311,   0.9793 },
    {   0.0660,   0.1161,   0.9903 },
    {   0.0166,   0.0992,   0.9948 },
    {  -0.0166,   0.0662,   0.9970 },
    {  -0.0333,   0.0332,   0.9989 },
    {  -0.0499,   0.0334,   0.9981 },
    {  -0.0665,   0.0168,   0.9975 },
    {  -0.0665,  -0.0166,   0.9975 },
    {  -0.0499,  -0.0332,   0.9981 },
    {  -0.0499,  -0.0166,   0.9983 },
    {  -0.0333,  -0.0168,   0.9992 },
    {  -0.0333,  -0.0168,   0.9992 },
    {  -0.0333,   0.0000,   0.9994 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0167,  -0.0168,   0.9994 },
    {   0.0166,  -0.0500,   0.9983 },
    {  -0.0166,  -0.0828,   0.9962 },
    {  -0.0331,  -0.1155,   0.9926 },
    {  -0.0491,  -0.1790,   0.9813 },
    {  -0.0806,  -0.2426,   0.9665 },
    {  -0.1288,  -0.2260,   0.9650 },
    {  -0.1619,  -0.1774,   0.9706 },
    {  -0.1631,  -0.0972,   0.9791 },
    {  -0.1483,  -0.0164,   0.9885 },
    {  -0.1159,   0.0000,   0.9931 },
    {  -0.0830,  -0.0166,   0.9961 },
    {  -0.0665,  -0.0497,   0.9964 },
    {  -0.0498,  -0.0827,   0.9951 },
    {  -0.0662,  -0.0826,   0.9937 },
    {  -0.0498,  -0.0833,   0.9950 },
    {  -0.0662,  -0.0832,   0.9936 },
    {  -0.0826,  -0.0987,   0.9910 },
    {  -0.0985,  -0.1311,   0.9859 },
    {   0.1786,   0.1301,   0.9746 },
    {   0.1948,   0.1140,   0.9741 },
    {   0.1945,   0.1133,   0.9737 },
    {   0.1634,   0.0979,   0.9812 },
    {   0.1315,   0.0820,   0.9872 },
    {   0.0993,   0.0665,   0.9928 },
    {   0.0498,   0.0667,   0.9964 },
    {   0.0166,   0.0663,   0.9975 },
    {  -0.0333,   0.0498,   0.9981 },
    {  -0.0333,   0.0332,   0.9989 },
    {  -0.0499,   0.0166,   0.9983 },
    {  -0.0499,   0.0000,   0.9986 },
    {  -0.0499,   0.0000,   0.9986 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0333,  -0.0168,   0.9992 },
    {  -0.0333,  -0.0168,   0.9992 },
    {  -0.0167,   0.0166,   0.9994 },
    {   0.0000,   0.0166,   0.9997 },
    {   0.0000,   0.0000,   1.0000 },
    {  -0.0166,  -0.0168,   0.9994 },
    {  -0.0331,  -0.0664,   0.9962 },
    {  -0.0496,  -0.0991,   0.9937 },
    {  -0.0658,  -0.1313,   0.9881 },
    {  -0.0970,  -0.2094,   0.9713 },
    {  -0.1114,  -0.2718,   0.9556 },
    {  -0.1432,  -0.2557,   0.9554 },
    {  -0.1616,  -0.1769,   0.9697 },
    {  -0.1476,  -0.0816,   0.9843 },
    {  -0.1321,   0.0000,   0.9907 },
    {  -0.0994,   0.0333,   0.9945 },
    {  -0.0829,   0.0002,   0.9959 },
    {  -0.0499,  -0.0332,   0.9981 },
    {  -0.0332,  -0.0662,   0.9967 },
    {  -0.0166,  -0.0828,   0.9962 },
    {  -0.0166,  -0.0834,   0.9961 },
    {  -0.0166,  -0.0999,   0.9947 },
    {  -0.0331,  -0.1154,   0.9921 },
    {  -0.0492,  -0.1635,   0.9846 },
    {   0.1783,   0.1464,   0.9728 },
    {   0.1790,   0.1145,   0.9769 },
    {   0.1477,   0.0819,   0.9854 },
    {   0.1319,   0.0658,   0.9891 },
    {   0.1156,   0.0659,   0.9910 },
    {   0.0829,   0.0498,   0.9950 },
    {   0.0499,   0.0334,   0.9981 },
    {   0.0166,   0.0166,   0.9994 },
    {  -0.0166,   0.0166,   0.9994 },
    {  -0.0333,   0.0166,   0.9992 },
    {  -0.0332,   0.0168,   0.9986 },
    {  -0.0333,   0.0168,   0.9992 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0333,  -0.0168,   0.9992 },
    {  -0.0166,  -0.0002,   0.9992 },
    {  -0.0167,   0.0332,   0.9992 },
    {  -0.0167,   0.0166,   0.9994 },
    {  -0.0167,  -0.0166,   0.9994 },
    {  -0.0333,  -0.0502,   0.9980 },
    {  -0.0663,  -0.0830,   0.9942 },
    {  -0.0661,  -0.1153,   0.9910 },
    {  -0.0981,  -0.1629,   0.9812 },
    {  -0.1287,  -0.2245,   0.9654 },
    {  -0.1420,  -0.2852,   0.9472 },
    {  -0.1581,  -0.2695,   0.9487 },
    {  -0.1616,  -0.1769,   0.9697 },
    {  -0.1637,  -0.0650,   0.9822 },
    {  -0.1481,   0.0328,   0.9877 },
    {  -0.1157,   0.0497,   0.9918 },
    {  -0.0994,   0.0333,   0.9945 },
    {  -0.0499,   0.0000,   0.9981 },
    {  -0.0499,  -0.0497,   0.9972 },
    {  -0.0166,  -0.0663,   0.9975 },
    {  -0.0166,  -0.0834,   0.9961 },
    {   0.0000,  -0.0999,   0.9950 },
    {   0.0000,  -0.1316,   0.9908 },
    {  -0.0164,  -0.1798,   0.9833 },
    {   0.1302,   0.1309,   0.9802 },
    {   0.0985,   0.0829,   0.9894 },
    {   0.0660,   0.0661,   0.9934 },
    {   0.0660,   0.0661,   0.9934 },
    {   0.0494,   0.0330,   0.9942 },
    {   0.0166,   0.0000,   0.9986 },
    {   0.0000,   0.0000,   0.9994 },
    {  -0.0166,   0.0000,   0.9997 },
    {  -0.0166,   0.0000,   0.9997 },
    {  -0.0333,   0.0166,   0.9992 },
    {  -0.0166,   0.0166,   0.9994 },
    {  -0.0167,   0.0000,   0.9997 },
    {  -0.0167,   0.0000,   0.9997 },
    {  -0.0167,  -0.0166,   0.9994 },
    {  -0.0167,  -0.0166,   0.9994 },
    {  -0.0167,   0.0000,   0.9997 },
    {  -0.0166,   0.0000,   0.9997 },
    {  -0.0167,   0.0166,   0.9994 },
    {  -0.0333,   0.0166,   0.9992 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0332,  -0.0668,   0.9966 },
    {  -0.0662,  -0.0997,   0.9928 },
    {  -0.0822,  -0.1312,   0.9873 },
    {  -0.0975,  -0.1944,   0.9755 },
    {  -0.1119,  -0.2550,   0.9598 },
    {  -0.1259,  -0.3004,   0.9448 },
    {  -0.1269,  -0.2706,   0.9526 },
    {  -0.1297,  -0.1776,   0.9738 },
    {  -0.1476,  -0.0652,   0.9846 },
    {  -0.1316,   0.0492,   0.9883 },
    {  -0.1154,   0.0827,   0.9896 },
    {  -0.0993,   0.0665,   0.9928 },
    {  -0.0992,   0.0165,   0.9932 },
    {  -0.0829,  -0.0331,   0.9959 },
    {  -0.0826,  -0.0496,   0.9940 },
    {  -0.0662,  -0.0666,   0.9950 },
    {  -0.0495,  -0.0830,   0.9940 },
    {  -0.0492,  -0.1313,   0.9884 },
    {  -0.0327,  -0.1796,   0.9825 },
    {  -0.0165,   0.0829,   0.9928 },
    {  -0.0494,   0.0500,   0.9939 },
    {  -0.0660,   0.0496,   0.9942 },
    {  -0.0821,   0.0494,   0.9918 },
    {  -0.0989,   0.0165,   0.9926 },
    {  -0.0828,   0.0000,   0.9953 },
    {  -0.0664,   0.0000,   0.9972 },
    {  -0.0499,   0.0000,   0.9986 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0333,   0.0166,   0.9992 },
    {  -0.0333,   0.0334,   0.9989 },
    {  -0.0167,   0.0168,   0.9994 },
    {  -0.0167,   0.0000,   0.9997 },
    {  -0.0167,  -0.0166,   0.9994 },
    {  -0.0167,  -0.0166,   0.9994 },
    {  -0.0167,  -0.0168,   0.9994 },
    {  -0.0166,  -0.0002,   0.9992 },
    {  -0.0167,   0.0166,   0.9994 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0497,  -0.0833,   0.9939 },
    {  -0.0495,  -0.1325,   0.9898 },
    {  -0.0821,  -0.1474,   0.9854 },
    {  -0.0975,  -0.1944,   0.9755 },
    {  -0.0961,  -0.2555,   0.9615 },
    {  -0.0791,  -0.3020,   0.9498 },
    {  -0.0638,  -0.2723,   0.9584 },
    {  -0.0651,  -0.1948,   0.9776 },
    {  -0.0821,  -0.0651,   0.9884 },
    {  -0.0828,   0.0660,   0.9937 },
    {  -0.0827,   0.0829,   0.9929 },
    {  -0.0993,   0.0500,   0.9937 },
    {  -0.1158,   0.0165,   0.9929 },
    {  -0.1157,  -0.0329,   0.9921 },
    {  -0.1481,  -0.0492,   0.9875 },
    {  -0.1476,  -0.0496,   0.9864 },
    {  -0.1473,  -0.0822,   0.9843 },
    {  -0.1468,  -0.1141,   0.9812 },
    {  -0.1299,  -0.1463,   0.9784 },
    {  -0.0664,   0.0168,   0.9970 },
    {  -0.1158,   0.0332,   0.9926 },
    {  -0.1483,   0.0329,   0.9883 },
    {  -0.1803,   0.0327,   0.9829 },
    {  -0.1803,   0.0327,   0.9829 },
    {  -0.1642,   0.0330,   0.9854 },
    {  -0.1158,   0.0332,   0.9926 },
    {  -0.0830,   0.0331,   0.9959 },
    {  -0.0499,   0.0166,   0.9983 },
    {  -0.0333,   0.0166,   0.9992 },
    {  -0.0333,   0.0334,   0.9989 },
    {  -0.0333,   0.0168,   0.9992 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0167,   0.0000,   0.9997 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0499,  -0.0331,   0.9975 },
    {  -0.0498,  -0.0833,   0.9950 },
    {  -0.0495,  -0.1321,   0.9893 },
    {  -0.0655,  -0.1794,   0.9815 },
    {  -0.0812,  -0.2104,   0.9740 },
    {  -0.0645,  -0.2412,   0.9677 },
    {  -0.0480,  -0.2732,   0.9605 },
    {  -0.0161,  -0.2583,   0.9652 },
    {   0.0000,  -0.1952,   0.9797 },
    {   0.0000,  -0.0819,   0.9927 },
    {  -0.0166,   0.0496,   0.9962 },
    {  -0.0498,   0.0664,   0.9959 },
    {  -0.0830,   0.0333,   0.9959 },
    {  -0.0995,   0.0000,   0.9945 },
    {  -0.1480,  -0.0655,   0.9861 },
    {  -0.1797,  -0.0814,   0.9801 },
    {  -0.2114,  -0.0653,   0.9751 },
    {  -0.2263,  -0.0810,   0.9701 },
    {  -0.2256,  -0.1125,   0.9671 },
    {  -0.2096,  -0.1446,   0.9668 },
    {  -0.0333,  -0.0168,   0.9992 },
    {  -0.0830,  -0.0333,   0.9959 },
    {  -0.1319,  -0.0165,   0.9904 },
    {  -0.1802,   0.0163,   0.9832 },
    {  -0.1960,   0.0326,   0.9801 },
    {  -0.1798,   0.0658,   0.9808 },
    {  -0.1477,   0.0825,   0.9853 },
    {  -0.1156,   0.0659,   0.9910 },
    {  -0.0829,   0.0496,   0.9951 },
    {  -0.0499,   0.0332,   0.9981 },
    {  -0.0333,   0.0334,   0.9989 },
    {  -0.0333,   0.0168,   0.9992 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0499,   0.0000,   0.9986 },
    {  -0.0333,   0.0000,   0.9994 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0499,  -0.0332,   0.9981 },
    {  -0.0497,  -0.0833,   0.9939 },
    {  -0.0658,  -0.1484,   0.9866 },
    {  -0.0816,  -0.1792,   0.9802 },
    {  -0.0652,  -0.1952,   0.9786 },
    {  -0.0646,  -0.2257,   0.9710 },
    {  -0.0482,  -0.2583,   0.9647 },
    {  -0.0162,  -0.2278,   0.9729 },
    {   0.0000,  -0.1797,   0.9830 },
    {   0.0166,  -0.0820,   0.9930 },
    {   0.0000,   0.0166,   0.9992 },
    {  -0.0499,   0.0166,   0.9983 },
    {  -0.0665,   0.0000,   0.9978 },
    {  -0.1155,  -0.0493,   0.9907 },
    {  -0.1790,  -0.1137,   0.9770 },
    {  -0.2254,  -0.1125,   0.9671 },
    {  -0.2704,  -0.0961,   0.9568 },
    {  -0.2995,  -0.0952,   0.9483 },
    {  -0.2856,  -0.0951,   0.9531 },
    {  -0.2408,  -0.1121,   0.9638 },
    {  -0.0499,  -0.0170,   0.9972 },
    {  -0.0664,  -0.0666,   0.9956 },
    {  -0.0993,  -0.0660,   0.9929 },
    {  -0.1481,  -0.0328,   0.9878 },
    {  -0.1639,   0.0327,   0.9849 },
    {  -0.1477,   0.0825,   0.9853 },
    {  -0.1313,   0.0990,   0.9859 },
    {  -0.1152,   0.0986,   0.9883 },
    {  -0.0991,   0.0824,   0.9915 },
    {  -0.0664,   0.0662,   0.9956 },
    {  -0.0333,   0.0500,   0.9981 },
    {  -0.0333,   0.0168,   0.9992 },
    {  -0.0166,   0.0000,   0.9997 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0499,  -0.0168,   0.9983 },
    {  -0.0499,  -0.0002,   0.9981 },
    {  -0.0499,   0.0166,   0.9983 },
    {  -0.0499,  -0.0166,   0.9983 },
    {  -0.0499,  -0.0497,   0.9972 },
    {  -0.0661,  -0.0997,   0.9922 },
    {  -0.0818,  -0.1640,   0.9824 },
    {  -0.0979,  -0.1789,   0.9788 },
    {  -0.1132,  -0.1938,   0.9728 },
    {  -0.1129,  -0.2252,   0.9676 },
    {  -0.1125,  -0.2264,   0.9663 },
    {  -0.0967,  -0.2111,   0.9704 },
    {  -0.1132,  -0.1621,   0.9764 },
    {  -0.0977,  -0.0817,   0.9858 },
    {  -0.0989,  -0.0165,   0.9926 },
    {  -0.1155,   0.0000,   0.9921 },
    {  -0.1312,  -0.0328,   0.9881 },
    {  -0.1629,  -0.1136,   0.9784 },
    {  -0.2083,  -0.1758,   0.9619 },
    {  -0.2683,  -0.1732,   0.9474 },
    {  -0.3130,  -0.1413,   0.9391 },
    {  -0.3285,  -0.0944,   0.9391 },
    {  -0.3014,  -0.0475,   0.9521 },
    {  -0.2575,  -0.0321,   0.9657 },
    {  -0.0828,  -0.0004,   0.9942 },
    {  -0.0663,  -0.0830,   0.9942 },
    {  -0.0990,  -0.0988,   0.9902 },
    {  -0.0991,  -0.0494,   0.9921 },
    {  -0.0992,   0.0330,   0.9934 },
    {  -0.0823,   0.0995,   0.9898 },
    {  -0.0660,   0.1161,   0.9903 },
    {  -0.0495,   0.0990,   0.9926 },
    {  -0.0495,   0.0990,   0.9926 },
    {  -0.0331,   0.0991,   0.9940 },
    {  -0.0332,   0.0664,   0.9967 },
    {  -0.0333,   0.0334,   0.9989 },
    {  -0.0166,   0.0000,   0.9992 },
    {  -0.0333,  -0.0332,   0.9989 },
    {  -0.0333,  -0.0332,   0.9989 },
    {  -0.0499,  -0.0166,   0.9983 },
    {  -0.0499,   0.0000,   0.9986 },
    {  -0.0665,   0.0000,   0.9978 },
    {  -0.0499,  -0.0166,   0.9983 },
    {  -0.0499,  -0.0497,   0.9972 },
    {  -0.0660,  -0.1160,   0.9898 },
    {  -0.0979,  -0.1800,   0.9787 },
    {  -0.1132,  -0.2098,   0.9709 },
    {  -0.1607,  -0.2084,   0.9646 },
    {  -0.1899,  -0.2218,   0.9539 },
    {  -0.2049,  -0.2378,   0.9482 },
    {  -0.2344,  -0.2210,   0.9436 },
    {  -0.2520,  -0.1731,   0.9490 },
    {  -0.2690,  -0.0633,   0.9559 },
    {  -0.2678,   0.0000,   0.9575 },
    {  -0.2402,  -0.0163,   0.9673 },
    {  -0.2414,  -0.0485,   0.9680 },
    {  -0.2392,  -0.1271,   0.9594 },
    {  -0.2650,  -0.2180,   0.9377 },
    {  -0.2803,  -0.2173,   0.9345 },
    {  -0.3121,  -0.1564,   0.9366 },
    {  -0.3148,  -0.0792,   0.9446 },
    {  -0.2872,  -0.0159,   0.9576 },
    {  -0.2576,   0.0000,   0.9662 },
    {  -0.1155,   0.0326,   0.9904 },
    {  -0.0826,  -0.0825,   0.9918 },
    {  -0.0494,  -0.0988,   0.9921 },
    {  -0.0165,  -0.0331,   0.9975 },
    {   0.0001,   0.0495,   0.9953 },
    {   0.0165,   0.1162,   0.9917 },
    {   0.0165,   0.1325,   0.9898 },
    {   0.0331,   0.1154,   0.9921 },
    {   0.0331,   0.0991,   0.9940 },
    {   0.0166,   0.0828,   0.9962 },
    {  -0.0166,   0.0500,   0.9983 },
    {  -0.0166,   0.0334,   0.9992 },
    {  -0.0333,   0.0000,   0.9989 },
    {  -0.0333,  -0.0332,   0.9989 },
    {  -0.0333,  -0.0332,   0.9989 },
    {  -0.0499,  -0.0334,   0.9981 },
    {  -0.0665,  -0.0168,   0.9975 },
    {  -0.0665,   0.0166,   0.9975 },
    {  -0.0664,   0.0000,   0.9967 },
    {  -0.0662,  -0.0661,   0.9945 },
    {  -0.0820,  -0.1482,   0.9842 },
    {  -0.1132,  -0.2110,   0.9707 },
    {  -0.1439,  -0.2393,   0.9600 },
    {  -0.1887,  -0.2668,   0.9445 },
    {  -0.2338,  -0.2643,   0.9354 },
    {  -0.2768,  -0.2628,   0.9237 },
    {  -0.3200,  -0.2448,   0.9146 },
    {  -0.3378,  -0.1838,   0.9222 },
    {  -0.3686,  -0.0917,   0.9226 },
    {  -0.3709,   0.0154,   0.9274 },
    {  -0.3434,   0.0311,   0.9377 },
    {  -0.3290,  -0.0313,   0.9422 },
    {  -0.3118,  -0.1392,   0.9363 },
    {  -0.3087,  -0.2156,   0.9264 },
    {  -0.2946,  -0.2166,   0.9306 },
    {  -0.2969,  -0.1720,   0.9381 },
    {  -0.3005,  -0.0637,   0.9494 },
    {  -0.2872,   0.0159,   0.9576 },
    {  -0.2575,   0.0321,   0.9657 },
    {  -0.1156,   0.0493,   0.9907 },
    {  -0.0664,  -0.0166,   0.9970 },
    {   0.0333,  -0.0332,   0.9983 },
    {   0.1147,   0.0000,   0.9895 },
    {   0.1466,   0.0653,   0.9832 },
    {   0.1460,   0.1148,   0.9791 },
    {   0.1303,   0.1313,   0.9806 },
    {   0.0987,   0.1149,   0.9878 },
    {   0.0828,   0.0825,   0.9929 },
    {   0.0333,   0.0498,   0.9981 },
    {   0.0000,   0.0334,   0.9994 },
    {  -0.0167,   0.0168,   0.9994 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0333,  -0.0332,   0.9989 },
    {  -0.0499,  -0.0497,   0.9972 },
    {  -0.0665,  -0.0499,   0.9964 },
    {  -0.0665,  -0.0168,   0.9975 },
    {  -0.0831,   0.0000,   0.9964 },
    {  -0.1159,  -0.0165,   0.9929 },
    {  -0.1317,  -0.0656,   0.9880 },
    {  -0.1300,  -0.1629,   0.9753 },
    {  -0.1440,  -0.2407,   0.9596 },
    {  -0.1730,  -0.2819,   0.9431 },
    {  -0.1872,  -0.2956,   0.9362 },
    {  -0.2014,  -0.3086,   0.9290 },
    {  -0.2576,  -0.3198,   0.9106 },
    {  -0.3037,  -0.2744,   0.9114 },
    {  -0.3497,  -0.2120,   0.9119 },
    {  -0.3680,  -0.0910,   0.9204 },
    {  -0.3712,   0.0308,   0.9275 },
    {  -0.3712,   0.0308,   0.9275 },
    {  -0.3579,  -0.0155,   0.9334 },
    {  -0.3414,  -0.1076,   0.9306 },
    {  -0.3099,  -0.2008,   0.9292 },
    {  -0.2957,  -0.2017,   0.9335 },
    {  -0.2838,  -0.1578,   0.9453 },
    {  -0.2863,  -0.0640,   0.9538 },
    {  -0.2872,   0.0318,   0.9568 },
    {  -0.2721,   0.0638,   0.9600 },
    {  -0.1314,   0.0825,   0.9872 },
    {  -0.0498,   0.0667,   0.9964 },
    {   0.0497,   0.0827,   0.9951 },
    {   0.1309,   0.0819,   0.9857 },
    {   0.1951,   0.0812,   0.9768 },
    {   0.1788,   0.0982,   0.9778 },
    {   0.1473,   0.0824,   0.9843 },
    {   0.0826,   0.0660,   0.9932 },
    {   0.0331,   0.0331,   0.9961 },
    {   0.0000,   0.0000,   0.9994 },
    {   0.0166,   0.0000,   0.9997 },
    {  -0.0167,   0.0000,   0.9997 },
    {  -0.0333,  -0.0166,   0.9992 },
    {  -0.0498,  -0.0497,   0.9972 },
    {  -0.0664,  -0.0662,   0.9956 },
    {  -0.0664,  -0.0499,   0.9964 },
    {  -0.0829,  -0.0333,   0.9959 },
    {  -0.1157,  -0.0330,   0.9926 },
    {  -0.1480,  -0.0492,   0.9875 },
    {  -0.1638,  -0.0817,   0.9830 },
    {  -0.1775,  -0.1618,   0.9684 },
    {  -0.1742,  -0.2541,   0.9508 },
    {  -0.1729,  -0.2823,   0.9435 },
    {  -0.1415,  -0.2980,   0.9438 },
    {  -0.1544,  -0.3388,   0.9272 },
    {  -0.1672,  -0.3670,   0.9139 },
    {  -0.2127,  -0.3366,   0.9148 },
    {  -0.2461,  -0.2467,   0.9310 },
    {  -0.2832,  -0.1096,   0.9476 },
    {  -0.3141,   0.0157,   0.9462 },
    {  -0.3141,   0.0474,   0.9462 },
    {  -0.3156,   0.0002,   0.9479 },
    {  -0.3138,  -0.0936,   0.9423 },
    {  -0.2826,  -0.1724,   0.9430 },
    {  -0.2822,  -0.1877,   0.9408 },
    {  -0.2689,  -0.1585,   0.9494 },
    {  -0.2562,  -0.0645,   0.9618 },
    {  -0.2722,   0.0319,   0.9611 },
    {  -0.2719,   0.0638,   0.9601 },
    {  -0.1471,   0.1149,   0.9810 },
    {  -0.0980,   0.1642,   0.9810 },
    {  -0.0165,   0.1477,   0.9875 },
    {   0.0329,   0.1477,   0.9878 },
    {   0.0815,   0.1144,   0.9855 },
    {   0.0825,   0.0665,   0.9931 },
    {   0.0496,   0.0335,   0.9964 },
    {   0.0166,   0.0000,   0.9997 },
    {  -0.0166,   0.0000,   0.9997 },
    {  -0.0166,   0.0332,   0.9986 },
    {   0.0000,   0.0163,   0.9981 },
    {  -0.0167,  -0.0334,   0.9992 },
    {  -0.0499,  -0.0497,   0.9972 },
    {  -0.0664,  -0.0662,   0.9956 },
    {  -0.0664,  -0.0662,   0.9956 },
    {  -0.0664,  -0.0666,   0.9956 },
    {  -0.0993,  -0.0665,   0.9928 },
    {  -0.1156,  -0.0659,   0.9910 },
    {  -0.1479,  -0.0656,   0.9867 },
    {  -0.1635,  -0.0978,   0.9812 },
    {  -0.1771,  -0.1778,   0.9666 },
    {  -0.1593,  -0.2400,   0.9570 },
    {  -0.1434,  -0.2544,   0.9563 },
    {  -0.1266,  -0.2840,   0.9500 },
    {  -0.1088,  -0.3409,   0.9332 },
    {  -0.0917,  -0.3840,   0.9181 },
    {  -0.0767,  -0.3562,   0.9270 },
    {  -0.0787,  -0.2845,   0.9517 },
    {  -0.1116,  -0.1597,   0.9697 },
    {  -0.1451,   0.0000,   0.9808 },
    {  -0.1946,   0.0325,   0.9777 },
    {  -0.2416,  -0.0161,   0.9690 },
    {  -0.2713,  -0.0794,   0.9579 },
    {  -0.2681,  -0.1727,   0.9465 },
    {  -0.2675,  -0.1882,   0.9444 },
    {  -0.2403,  -0.1284,   0.9616 },
    {  -0.2418,  -0.0649,   0.9675 },
    {  -0.2573,   0.0160,   0.9650 },
    {  -0.2721,   0.0479,   0.9608 },
    {  -0.0986,   0.1156,   0.9866 },
    {  -0.0811,   0.1955,   0.9756 },
    {  -0.0488,   0.2109,   0.9760 },
    {   0.0000,   0.1798,   0.9836 },
    {   0.0165,   0.1316,   0.9905 },
    {   0.0332,   0.0664,   0.9967 },
    {   0.0000,   0.0168,   0.9997 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0166,   0.9997 },
    {  -0.0499,  -0.0002,   0.9981 },
    {  -0.0498,  -0.0499,   0.9972 },
    {  -0.0498,  -0.0663,   0.9964 },
    {  -0.0498,  -0.0663,   0.9964 },
    {  -0.0664,  -0.0662,   0.9956 },
    {  -0.0663,  -0.0833,   0.9942 },
    {  -0.0662,  -0.0832,   0.9936 },
    {  -0.0827,  -0.0825,   0.9929 },
    {  -0.0989,  -0.0987,   0.9896 },
    {  -0.1311,  -0.1145,   0.9841 },
    {  -0.1301,  -0.1635,   0.9768 },
    {  -0.1128,  -0.2261,   0.9670 },
    {  -0.1120,  -0.2554,   0.9602 },
    {  -0.1115,  -0.2701,   0.9561 },
    {  -0.0944,  -0.3137,   0.9444 },
    {  -0.0469,  -0.3450,   0.9373 },
    {   0.0157,  -0.3314,   0.9431 },
    {   0.0318,  -0.2860,   0.9567 },
    {   0.0326,  -0.1780,   0.9797 },
    {  -0.0166,  -0.0662,   0.9970 },
    {  -0.1157,  -0.0499,   0.9918 },
    {  -0.1954,  -0.0816,   0.9772 },
    {  -0.2554,  -0.1273,   0.9579 },
    {  -0.2683,  -0.1732,   0.9474 },
    {  -0.2392,  -0.1590,   0.9572 },
    {  -0.2253,  -0.1293,   0.9657 },
    {  -0.2413,  -0.0809,   0.9657 },
    {  -0.2423,   0.0000,   0.9695 },
    {  -0.2723,   0.0320,   0.9615 },
    {   0.0001,   0.1319,   0.9868 },
    {   0.0163,   0.2121,   0.9758 },
    {   0.0162,   0.2264,   0.9727 },
    {   0.0325,   0.2109,   0.9763 },
    {   0.0656,   0.1470,   0.9852 },
    {   0.0166,   0.0496,   0.9973 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {  -0.0167,  -0.0166,   0.9994 },
    {  -0.0499,  -0.0334,   0.9981 },
    {  -0.0499,  -0.0334,   0.9981 },
    {  -0.0333,  -0.0498,   0.9981 },
    {  -0.0332,  -0.0828,   0.9959 },
    {  -0.0497,  -0.0827,   0.9951 },
    {  -0.0498,  -0.0667,   0.9964 },
    {  -0.0332,  -0.0832,   0.9959 },
    {  -0.0497,  -0.0991,   0.9937 },
    {  -0.0496,  -0.1154,   0.9918 },
    {  -0.0658,  -0.1315,   0.9886 },
    {  -0.0818,  -0.1644,   0.9823 },
    {  -0.0969,  -0.2265,   0.9687 },
    {  -0.1120,  -0.2554,   0.9602 },
    {  -0.1115,  -0.2701,   0.9561 },
    {  -0.1110,  -0.2849,   0.9520 },
    {  -0.0793,  -0.2872,   0.9534 },
    {  -0.0629,  -0.2865,   0.9513 },
    {  -0.0472,  -0.2699,   0.9552 },
    {  -0.0634,  -0.2083,   0.9663 },
    {  -0.0971,  -0.1465,   0.9795 },
    {  -0.1616,  -0.1467,   0.9736 },
    {  -0.1935,  -0.1619,   0.9676 },
    {  -0.2239,  -0.1597,   0.9609 },
    {  -0.2239,  -0.1597,   0.9609 },
    {  -0.2094,  -0.1446,   0.9668 },
    {  -0.2253,  -0.1293,   0.9657 },
    {  -0.2107,  -0.0815,   0.9728 },
    {  -0.2271,  -0.0162,   0.9736 },
    {  -0.2424,   0.0000,   0.9701 },
    {   0.0982,   0.1479,   0.9823 },
    {   0.0972,   0.2113,   0.9719 },
    {   0.0969,   0.2255,   0.9689 },
    {   0.0969,   0.2255,   0.9689 },
    {   0.0491,   0.1131,   0.9846 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,  -0.0166,   0.9997 },
    {  -0.0333,  -0.0332,   0.9989 },
    {  -0.0333,  -0.0334,   0.9989 },
    {  -0.0499,  -0.0334,   0.9981 },
    {  -0.0499,  -0.0497,   0.9972 },
    {  -0.0498,  -0.0827,   0.9951 },
    {  -0.0332,  -0.0828,   0.9959 },
    {  -0.0333,  -0.0667,   0.9972 },
    {  -0.0332,  -0.0832,   0.9959 },
    {  -0.0332,  -0.0992,   0.9945 },
    {  -0.0496,  -0.1154,   0.9918 },
    {  -0.0494,  -0.1477,   0.9875 },
    {  -0.0652,  -0.1963,   0.9778 },
    {  -0.0962,  -0.2569,   0.9612 },
    {  -0.1116,  -0.2701,   0.9561 },
    {  -0.1273,  -0.2696,   0.9544 },
    {  -0.1268,  -0.2843,   0.9503 },
    {  -0.1567,  -0.2991,   0.9406 },
    {  -0.1871,  -0.2975,   0.9356 },
    {  -0.2027,  -0.2804,   0.9371 },
    {  -0.2211,  -0.2197,   0.9477 },
    {  -0.2241,  -0.1597,   0.9609 },
    {  -0.2095,  -0.1454,   0.9667 },
    {  -0.1784,  -0.1464,   0.9728 },
    {  -0.1621,  -0.1617,   0.9729 },
    {  -0.1621,  -0.1617,   0.9729 },
    {  -0.1780,  -0.1613,   0.9706 },
    {  -0.2099,  -0.1293,   0.9685 },
    {  -0.2111,  -0.0816,   0.9738 },
    {  -0.2271,  -0.0323,   0.9728 },
    {  -0.2274,   0.0000,   0.9738 },
    {   0.1775,   0.1462,   0.9708 },
    {   0.1604,   0.2095,   0.9639 },
    {   0.1445,   0.2243,   0.9636 },
    {   0.1141,   0.1619,   0.9780 },
    {   0.0000,   0.0496,   0.9975 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,  -0.0332,   0.9989 },
    {  -0.0166,  -0.0498,   0.9983 },
    {  -0.0333,  -0.0502,   0.9980 },
    {  -0.0499,  -0.0502,   0.9972 },
    {  -0.0664,  -0.0497,   0.9964 },
    {  -0.0664,  -0.0662,   0.9956 },
    {  -0.0332,  -0.0663,   0.9972 },
    {  -0.0332,  -0.0667,   0.9972 },
    {  -0.0332,  -0.0832,   0.9959 },
    {  -0.0331,  -0.1155,   0.9926 },
    {  -0.0495,  -0.1316,   0.9899 },
    {  -0.0658,  -0.1476,   0.9867 },
    {  -0.0649,  -0.2116,   0.9740 },
    {  -0.0799,  -0.2725,   0.9586 },
    {  -0.0954,  -0.2854,   0.9537 },
    {  -0.1110,  -0.2849,   0.9520 },
    {  -0.1255,  -0.3126,   0.9411 },
    {  -0.1695,  -0.3404,   0.9247 },
    {  -0.2002,  -0.3247,   0.9241 },
    {  -0.2318,  -0.2928,   0.9274 },
    {  -0.2361,  -0.2190,   0.9446 },
    {  -0.2249,  -0.1282,   0.9649 },
    {  -0.1633,  -0.0985,   0.9811 },
    {  -0.1311,  -0.1151,   0.9840 },
    {  -0.0983,  -0.1471,   0.9836 },
    {  -0.1140,  -0.1786,   0.9770 },
    {  -0.1613,  -0.1931,   0.9678 },
    {  -0.1934,  -0.1615,   0.9672 },
    {  -0.2411,  -0.0970,   0.9650 },
    {  -0.2421,  -0.0322,   0.9690 },
    {  -0.2424,   0.0000,   0.9701 },
    {   0.2406,   0.1128,   0.9627 },
    {   0.1930,   0.1775,   0.9649 },
    {   0.1617,   0.1774,   0.9706 },
    {   0.0494,   0.0818,   0.9908 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,  -0.0332,   0.9989 },
    {   0.0000,  -0.0663,   0.9978 },
    {  -0.0332,  -0.0667,   0.9972 },
    {  -0.0498,  -0.0667,   0.9964 },
    {  -0.0664,  -0.0662,   0.9956 },
    {  -0.0664,  -0.0497,   0.9964 },
    {  -0.0499,  -0.0497,   0.9972 },
    {  -0.0332,  -0.0667,   0.9972 },
    {  -0.0332,  -0.0832,   0.9959 },
    {  -0.0331,  -0.1155,   0.9926 },
    {  -0.0494,  -0.1477,   0.9875 },
    {  -0.0492,  -0.1638,   0.9851 },
    {  -0.0649,  -0.2116,   0.9740 },
    {  -0.0795,  -0.2869,   0.9541 },
    {  -0.0949,  -0.2997,   0.9492 },
    {  -0.1105,  -0.2992,   0.9475 },
    {  -0.1394,  -0.3396,   0.9296 },
    {  -0.1676,  -0.3673,   0.9147 },
    {  -0.1834,  -0.3530,   0.9173 },
    {  -0.2161,  -0.3076,   0.9262 },
    {  -0.2217,  -0.2041,   0.9504 },
    {  -0.2107,  -0.0807,   0.9729 },
    {  -0.1639,  -0.0495,   0.9846 },
    {  -0.1315,  -0.0825,   0.9872 },
    {  -0.1141,  -0.1463,   0.9802 },
    {  -0.1440,  -0.2237,   0.9623 },
    {  -0.1902,  -0.2373,   0.9520 },
    {  -0.2219,  -0.2070,   0.9522 },
    {  -0.2550,  -0.1279,   0.9563 },
    {  -0.2574,  -0.0321,   0.9653 },
    {  -0.2576,   0.0161,   0.9660 },
    {   0.2100,   0.0975,   0.9716 },
    {   0.1786,   0.1301,   0.9746 },
    {   0.0817,   0.0814,   0.9866 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,  -0.0332,   0.9989 },
    {   0.0331,  -0.0827,   0.9953 },
    {  -0.0331,  -0.0998,   0.9945 },
    {  -0.0497,  -0.0833,   0.9950 },
    {  -0.0664,  -0.0662,   0.9956 },
    {  -0.0664,  -0.0497,   0.9964 },
    {  -0.0665,  -0.0332,   0.9972 },
    {  -0.0498,  -0.0502,   0.9972 },
    {  -0.0497,  -0.0831,   0.9950 },
    {  -0.0494,  -0.1314,   0.9894 },
    {  -0.0658,  -0.1476,   0.9867 },
    {  -0.0654,  -0.1633,   0.9833 },
    {  -0.0804,  -0.2421,   0.9656 },
    {  -0.0949,  -0.3014,   0.9487 },
    {  -0.1100,  -0.3135,   0.9431 },
    {  -0.1401,  -0.3262,   0.9346 },
    {  -0.1677,  -0.3648,   0.9153 },
    {  -0.1814,  -0.3793,   0.9072 },
    {  -0.1970,  -0.3653,   0.9097 },
    {  -0.2002,  -0.3219,   0.9242 },
    {  -0.2065,  -0.2048,   0.9535 },
    {  -0.1950,  -0.0646,   0.9760 },
    {  -0.1802,  -0.0166,   0.9832 },
    {  -0.1639,  -0.0656,   0.9838 },
    {  -0.1619,  -0.1608,   0.9715 },
    {  -0.1897,  -0.2520,   0.9485 },
    {  -0.2190,  -0.2653,   0.9389 },
    {  -0.2657,  -0.2194,   0.9382 },
    {  -0.2840,  -0.1268,   0.9478 },
    {  -0.2866,  -0.0318,   0.9565 },
    {  -0.2576,   0.0161,   0.9660 },
    {   0.1313,   0.0990,   0.9859 },
    {   0.1151,   0.0499,   0.9896 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {  -0.0326,  -0.0973,   0.9850 },
    {  -0.0493,  -0.1479,   0.9865 },
    {  -0.0497,  -0.0998,   0.9936 },
    {  -0.0663,  -0.0826,   0.9942 },
    {  -0.0664,  -0.0497,   0.9964 },
    {  -0.0665,  -0.0332,   0.9972 },
    {  -0.0829,  -0.0500,   0.9950 },
    {  -0.0827,  -0.0829,   0.9928 },
    {  -0.0984,  -0.1309,   0.9854 },
    {  -0.0980,  -0.1631,   0.9812 },
    {  -0.1298,  -0.1782,   0.9747 },
    {  -0.1433,  -0.2401,   0.9577 },
    {  -0.1404,  -0.3133,   0.9377 },
    {  -0.1692,  -0.3382,   0.9246 },
    {  -0.1977,  -0.3496,   0.9146 },
    {  -0.2103,  -0.3749,   0.9023 },
    {  -0.1948,  -0.3912,   0.8993 },
    {  -0.1969,  -0.3650,   0.9093 },
    {  -0.1712,  -0.3104,   0.9345 },
    {  -0.1761,  -0.1900,   0.9611 },
    {  -0.1479,  -0.0491,   0.9864 },
    {  -0.1319,  -0.0167,   0.9904 },
    {  -0.1151,  -0.0659,   0.9894 },
    {  -0.1132,  -0.1768,   0.9733 },
    {  -0.1417,  -0.2831,   0.9469 },
    {  -0.2013,  -0.3090,   0.9294 },
    {  -0.2479,  -0.2639,   0.9307 },
    {  -0.2978,  -0.1413,   0.9407 },
    {  -0.2863,   0.0000,   0.9555 },
    {  -0.2571,   0.0641,   0.9643 },
    {   0.0329,   0.0992,   0.9918 },
    {   0.0332,   0.0004,   0.9967 },
    {   0.0000,  -0.0332,   0.9989 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,  -0.0659,   0.9956 },
    {  -0.1149,  -0.1309,   0.9846 },
    {  -0.0661,  -0.1159,   0.9909 },
    {  -0.0827,  -0.0995,   0.9915 },
    {  -0.0828,  -0.0825,   0.9929 },
    {  -0.0830,  -0.0496,   0.9950 },
    {  -0.0830,  -0.0496,   0.9950 },
    {  -0.0993,  -0.0665,   0.9928 },
    {  -0.1153,  -0.0988,   0.9877 },
    {  -0.1468,  -0.1463,   0.9780 },
    {  -0.1616,  -0.1773,   0.9701 },
    {  -0.1917,  -0.2071,   0.9587 },
    {  -0.2196,  -0.2520,   0.9414 },
    {  -0.2289,  -0.3213,   0.9169 },
    {  -0.2539,  -0.3581,   0.8975 },
    {  -0.2682,  -0.3568,   0.8944 },
    {  -0.2682,  -0.3568,   0.8944 },
    {  -0.2401,  -0.3616,   0.9004 },
    {  -0.1992,  -0.3382,   0.9191 },
    {  -0.1722,  -0.2965,   0.9391 },
    {  -0.1610,  -0.1743,   0.9651 },
    {  -0.1482,  -0.0164,   0.9875 },
    {  -0.1320,   0.0165,   0.9904 },
    {  -0.1311,  -0.0491,   0.9868 },
    {  -0.1284,  -0.1910,   0.9664 },
    {  -0.1390,  -0.3380,   0.9279 },
    {  -0.1827,  -0.3639,   0.9129 },
    {  -0.2013,  -0.3103,   0.9286 },
    {  -0.2369,  -0.1570,   0.9493 },
    {  -0.2267,   0.0161,   0.9721 },
    {  -0.1944,   0.0810,   0.9754 },
    {  -0.0331,   0.0998,   0.9945 },
    {  -0.0166,   0.0171,   0.9961 },
    {   0.0000,  -0.0332,   0.9989 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {  -0.1121,  -0.1119,   0.9744 },
    {  -0.0980,  -0.1622,   0.9798 },
    {  -0.0824,  -0.1160,   0.9895 },
    {  -0.0824,  -0.1160,   0.9895 },
    {  -0.0991,  -0.0824,   0.9915 },
    {  -0.0994,  -0.0495,   0.9937 },
    {  -0.1156,  -0.0494,   0.9918 },
    {  -0.1314,  -0.0827,   0.9872 },
    {  -0.1469,  -0.1308,   0.9798 },
    {  -0.1774,  -0.1769,   0.9679 },
    {  -0.2070,  -0.2065,   0.9560 },
    {  -0.2356,  -0.2350,   0.9428 },
    {  -0.2472,  -0.2792,   0.9273 },
    {  -0.2694,  -0.3448,   0.8983 },
    {  -0.2805,  -0.3682,   0.8862 },
    {  -0.2821,  -0.3555,   0.8910 },
    {  -0.2835,  -0.3423,   0.8956 },
    {  -0.2723,  -0.3188,   0.9078 },
    {  -0.2459,  -0.2935,   0.9232 },
    {  -0.2187,  -0.2651,   0.9385 },
    {  -0.1924,  -0.1586,   0.9632 },
    {  -0.2107,  -0.0162,   0.9751 },
    {  -0.2109,  -0.0002,   0.9758 },
    {  -0.2262,  -0.0647,   0.9709 },
    {  -0.2218,  -0.1881,   0.9517 },
    {  -0.2135,  -0.3337,   0.9159 },
    {  -0.1826,  -0.3639,   0.9129 },
    {  -0.1712,  -0.3121,   0.9340 },
    {  -0.1607,  -0.1596,   0.9650 },
    {  -0.1472,   0.0487,   0.9833 },
    {  -0.1313,   0.1145,   0.9846 },
    {   0.0000,   0.0668,   0.9966 },
    {  -0.0332,   0.0336,   0.9966 },
    {   0.0000,  -0.0166,   0.9997 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,  -0.1133,   0.9870 },
    {  -0.1770,  -0.1602,   0.9678 },
    {  -0.1153,  -0.0986,   0.9883 },
    {  -0.0990,  -0.0994,   0.9901 },
    {  -0.0824,  -0.1158,   0.9896 },
    {  -0.0825,  -0.0987,   0.9910 },
    {  -0.0993,  -0.0660,   0.9929 },
    {  -0.1317,  -0.0821,   0.9878 },
    {  -0.1636,  -0.0985,   0.9816 },
    {  -0.1781,  -0.1457,   0.9719 },
    {  -0.1918,  -0.2072,   0.9592 },
    {  -0.2056,  -0.2367,   0.9493 },
    {  -0.2042,  -0.2513,   0.9450 },
    {  -0.2013,  -0.2958,   0.9315 },
    {  -0.2252,  -0.3622,   0.9031 },
    {  -0.2242,  -0.3735,   0.8990 },
    {  -0.2255,  -0.3607,   0.9040 },
    {  -0.2413,  -0.3463,   0.9060 },
    {  -0.2581,  -0.3201,   0.9114 },
    {  -0.2759,  -0.2770,   0.9199 },
    {  -0.2928,  -0.2310,   0.9267 },
    {  -0.2951,  -0.1553,   0.9378 },
    {  -0.3002,  -0.0315,   0.9502 },
    {  -0.3008,  -0.0002,   0.9521 },
    {  -0.2862,  -0.0636,   0.9550 },
    {  -0.2665,  -0.1861,   0.9411 },
    {  -0.2306,  -0.3065,   0.9229 },
    {  -0.1855,  -0.3238,   0.9277 },
    {  -0.1575,  -0.2843,   0.9453 },
    {  -0.1299,  -0.1290,   0.9744 },
    {  -0.1155,   0.0493,   0.9907 },
    {  -0.1476,   0.0981,   0.9840 },
    {   0.0663,  -0.0163,   0.9959 },
    {   0.0166,   0.0168,   0.9983 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {  -0.1536,  -0.1678,   0.9461 },
    {  -0.1121,  -0.2200,   0.9609 },
    {  -0.1317,  -0.0821,   0.9878 },
    {  -0.1314,  -0.0827,   0.9872 },
    {  -0.1313,  -0.0990,   0.9859 },
    {  -0.1306,  -0.0982,   0.9844 },
    {  -0.1470,  -0.0981,   0.9831 },
    {  -0.1785,  -0.1135,   0.9761 },
    {  -0.1787,  -0.1305,   0.9751 },
    {  -0.2088,  -0.1609,   0.9640 },
    {  -0.1918,  -0.2072,   0.9592 },
    {  -0.1600,  -0.2236,   0.9609 },
    {  -0.1121,  -0.2401,   0.9629 },
    {  -0.1094,  -0.3137,   0.9400 },
    {  -0.1061,  -0.3824,   0.9146 },
    {  -0.1062,  -0.3804,   0.9155 },
    {  -0.1215,  -0.3801,   0.9148 },
    {  -0.1513,  -0.3785,   0.9110 },
    {  -0.1825,  -0.3523,   0.9159 },
    {  -0.2288,  -0.3223,   0.9173 },
    {  -0.3037,  -0.2726,   0.9120 },
    {  -0.3383,  -0.1522,   0.9237 },
    {  -0.3438,  -0.0156,   0.9378 },
    {  -0.3301,   0.0157,   0.9436 },
    {  -0.3159,  -0.0315,   0.9478 },
    {  -0.2836,  -0.1406,   0.9454 },
    {  -0.2336,  -0.2636,   0.9347 },
    {  -0.2022,  -0.2948,   0.9337 },
    {  -0.1742,  -0.2541,   0.9508 },
    {  -0.1463,  -0.1135,   0.9759 },
    {  -0.1639,   0.0327,   0.9849 },
    {  -0.1796,   0.0814,   0.9801 },
    {   0.1316,  -0.0492,   0.9883 },
    {   0.0829,  -0.0331,   0.9953 },
    {   0.0822,  -0.0329,   0.9921 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {   0.0000,   0.0000,   1.0000 },
    {  -0.0957,  -0.1564,   0.9654 },
    {  -0.1537,  -0.2183,   0.9466 },
    {  -0.0658,  -0.1315,   0.9886 },
    {  -0.0986,  -0.1149,   0.9878 },
    {  -0.1636,  -0.0985,   0.9816 },
    {  -0.1945,  -0.1139,   0.9736 },
    {  -0.2402,  -0.1120,   0.9630 },
    {  -0.2546,  -0.1115,   0.9585 },
    {  -0.2556,  -0.1116,   0.9597 },
    {  -0.2539,  -0.1281,   0.9562 },
    {  -0.2540,  -0.1595,   0.9535 },
    {  -0.1935,  -0.1609,   0.9678 },
    {  -0.1304,  -0.1626,   0.9780 },
    {  -0.0649,  -0.2101,   0.9744 },
    {  -0.0158,  -0.3019,   0.9509 },
    {   0.0154,  -0.3716,   0.9267 },
    {   0.0153,  -0.3963,   0.9169 },
    {   0.0000,  -0.4086,   0.9106 },
    {   0.0001,  -0.4077,   0.9085 },
    {  -0.0453,  -0.3974,   0.9134 },
    {  -0.0901,  -0.3957,   0.9095 },
    {  -0.1509,  -0.3353,   0.9202 },
    {  -0.2192,  -0.1875,   0.9485 },
    {  -0.2373,  -0.0159,   0.9619 },
    {  -0.2558,   0.0320,   0.9637 },
    {  -0.2560,  -0.0160,   0.9644 },
    {  -0.2548,  -0.1106,   0.9569 },
    {  -0.2354,  -0.2344,   0.9420 },
    {  -0.2190,  -0.2653,   0.9389 },
    {  -0.1910,  -0.2234,   0.9554 },
    {  -0.1939,  -0.1134,   0.9705 },
    {  -0.2114,   0.0162,   0.9759 },
    {  -0.2264,   0.0646,   0.9714 },
    {   0.1316,  -0.0825,   0.9872 },
    {   0.1158,  -0.0334,   0.9920 },
    {   0.1312,  -0.0812,   0.9841 },
    {   0.0975,  -0.0812,   0.9837 },
    {   0.0661,   0.0000,   0.9956 },
    {   0.0165,  -0.0990,   0.9898 },
    {  -0.0640,  -0.1632,   0.9753 },
    {   0.0165,  -0.1479,   0.9886 },
    {   0.0000,  -0.1639,   0.9859 },
    {  -0.0327,  -0.1796,   0.9825 },
    {  -0.1137,  -0.1795,   0.9759 },
    {  -0.1769,  -0.1778,   0.9667 },
    {  -0.2387,  -0.1588,   0.9564 },
    {  -0.2702,  -0.1111,   0.9551 },
    {  -0.2857,  -0.1107,   0.9518 },
    {  -0.3139,  -0.1260,   0.9411 },
    {  -0.3004,  -0.0953,   0.9484 },
    {  -0.2411,  -0.0803,   0.9659 },
    {  -0.1635,  -0.0979,   0.9812 },
    {  -0.0823,  -0.1312,   0.9873 },
    {   0.0161,  -0.2415,   0.9668 },
    {   0.0466,  -0.3575,   0.9317 },
    {   0.0763,  -0.3955,   0.9152 },
    {   0.0913,  -0.3949,   0.9137 },
    {   0.1199,  -0.4183,   0.8995 },
    {   0.1036,  -0.4329,   0.8924 },
    {   0.0747,  -0.4219,   0.9005 },
    {   0.0603,  -0.3939,   0.9122 },
    {   0.0000,  -0.2331,   0.9541 },
    {  -0.0328,  -0.0494,   0.9921 },
    {  -0.0981,   0.0000,   0.9903 },
    {  -0.1313,  -0.0328,   0.9881 },
    {  -0.1779,  -0.1288,   0.9723 },
    {  -0.1902,  -0.2366,   0.9512 },
    {  -0.2049,  -0.2512,   0.9454 },
    {  -0.2214,  -0.2223,   0.9490 },
    {  -0.2395,  -0.1276,   0.9575 },
    {  -0.2718,   0.0000,   0.9607 },
    {  -0.2870,   0.0318,   0.9569 },
    {   0.0988,  -0.0661,   0.9921 },
    {   0.0994,  -0.0333,   0.9939 },
    {   0.0911,  -0.0496,   0.9944 },
    {   0.1475,  -0.0655,   0.9857 },
    {   0.1072,  -0.0823,   0.9903 },
    {   0.0653,  -0.1322,   0.9877 },
    {   0.0985,  -0.1641,   0.9810 },
    {   0.0816,  -0.1632,   0.9820 },
    {   0.0572,  -0.1794,   0.9816 },
    {   0.0322,  -0.2260,   0.9723 },
    {  -0.0090,  -0.2429,   0.9683 },
    {  -0.0554,  -0.2422,   0.9657 },
    {  -0.1204,  -0.2084,   0.9662 },
    {  -0.1933,  -0.1608,   0.9674 },
    {  -0.2691,  -0.1579,   0.9500 },
    {  -0.3063,  -0.1416,   0.9411 },
    {  -0.3069,  -0.0797,   0.9466 },
    {  -0.2798,  -0.0160,   0.9597 },
    {  -0.2417,   0.0000,   0.9692 },
    {  -0.1929,  -0.0325,   0.9752 },
    {  -0.1321,  -0.1761,   0.9566 },
    {  -0.0613,  -0.3148,   0.9419 },
    {   0.0077,  -0.3557,   0.9305 },
    {   0.0615,  -0.3692,   0.9253 },
    {   0.0907,  -0.3938,   0.9120 },
    {   0.1393,  -0.4319,   0.8901 },
    {   0.1710,  -0.4299,   0.8860 },
    {   0.2001,  -0.4005,   0.8926 },
    {   0.2097,  -0.2705,   0.9252 },
    {   0.1062,  -0.1142,   0.9852 },
    {  -0.0168,  -0.0668,   0.9975 },
    {  -0.0985,  -0.0990,   0.9889 },
    {  -0.1688,  -0.1767,   0.9671 },
    {  -0.1958,  -0.2657,   0.9415 },
    {  -0.2095,  -0.2943,   0.9320 },
    {  -0.2501,  -0.2499,   0.9347 },
    {  -0.2527,  -0.1594,   0.9511 },
    {  -0.3003,  -0.0320,   0.9501 },
    {  -0.3434,  -0.0002,   0.9380 },
    {   0.0331,  -0.0334,   0.9983 },
    {   0.0332,  -0.0332,   0.9983 },
    {   0.0414,  -0.0497,   0.9968 },
    {   0.0743,  -0.0825,   0.9928 },
    {   0.0909,  -0.1158,   0.9886 },
    {   0.1221,  -0.1476,   0.9813 },
    {   0.1620,  -0.1617,   0.9729 },
    {   0.2068,  -0.1908,   0.9577 },
    {   0.1823,  -0.2376,   0.9531 },
    {   0.1357,  -0.2709,   0.9525 },
    {   0.1027,  -0.2720,   0.9563 },
    {   0.0560,  -0.2714,   0.9606 },
    {  -0.0001,  -0.2566,   0.9658 },
    {  -0.1045,  -0.2405,   0.9645 },
    {  -0.1904,  -0.2234,   0.9552 },
    {  -0.3126,  -0.1261,   0.9383 },
    {  -0.3562,  -0.0007,   0.9314 },
    {  -0.3690,   0.0306,   0.9264 },
    {  -0.3598,  -0.0155,   0.9280 },
    {  -0.3370,  -0.1083,   0.9200 },
    {  -0.3128,  -0.2418,   0.9067 },
    {  -0.2683,  -0.3017,   0.9074 },
    {  -0.2271,  -0.3055,   0.9188 },
    {  -0.1652,  -0.3350,   0.9169 },
    {  -0.0818,  -0.3826,   0.9146 },
    {  -0.0090,  -0.3853,   0.9210 },
    {   0.0851,  -0.3556,   0.9303 },
    {   0.1563,  -0.2810,   0.9435 },
    {   0.1760,  -0.1919,   0.9636 },
    {   0.1210,  -0.1789,   0.9721 },
    {   0.0155,  -0.1962,   0.9771 },
    {  -0.0720,  -0.2394,   0.9625 },
    {  -0.1398,  -0.3110,   0.9362 },
    {  -0.1843,  -0.3374,   0.9226 },
    {  -0.2234,  -0.2943,   0.9277 },
    {  -0.2956,  -0.1877,   0.9334 },
    {  -0.3137,  -0.0632,   0.9439 },
    {  -0.3089,  -0.0158,   0.9507 },
    {  -0.3368,  -0.0469,   0.9402 },
    {  -0.0166,  -0.0334,   0.9992 },
    {  -0.0166,  -0.0332,   0.9992 },
    {  -0.0166,  -0.0332,   0.9992 },
    {  -0.0165,  -0.0497,   0.9972 },
    {   0.0332,  -0.0667,   0.9967 },
    {   0.0825,  -0.0828,   0.9918 },
    {   0.1634,  -0.0979,   0.9812 },
    {   0.2072,  -0.1741,   0.9583 },
    {   0.1878,  -0.2810,   0.9401 },
    {   0.1408,  -0.3142,   0.9387 },
    {   0.1099,  -0.3154,   0.9424 },
    {   0.0471,  -0.3291,   0.9429 },
    {  -0.0156,  -0.3434,   0.9389 },
    {  -0.1094,  -0.3275,   0.9383 },
    {  -0.1863,  -0.3118,   0.9317 },
    {  -0.2794,  -0.2010,   0.9322 },
    {  -0.3434,  -0.0622,   0.9366 },
    {  -0.4100,  -0.0303,   0.9115 },
    {  -0.4467,  -0.0445,   0.8935 },
    {  -0.4787,  -0.1021,   0.8708 },
    {  -0.4502,  -0.1890,   0.8716 },
    {  -0.3862,  -0.2371,   0.8914 },
    {  -0.3190,  -0.2576,   0.9118 },
    {  -0.2622,  -0.2621,   0.9275 },
    {  -0.1888,  -0.2687,   0.9444 },
    {  -0.1111,  -0.2716,   0.9547 },
    {  -0.0474,  -0.2401,   0.9630 },
    {   0.0001,  -0.2520,   0.9485 },
    {  -0.0154,  -0.2690,   0.9522 },
    {  -0.0783,  -0.2711,   0.9528 },
    {  -0.1408,  -0.2846,   0.9450 },
    {  -0.1861,  -0.3094,   0.9316 },
    {  -0.2140,  -0.3355,   0.9174 },
    {  -0.1993,  -0.3365,   0.9202 },
    {  -0.2002,  -0.3246,   0.9242 },
    {  -0.2194,  -0.2197,   0.9439 },
    {  -0.2562,  -0.0797,   0.9616 },
    {  -0.3014,  -0.0475,   0.9521 },
    {  -0.3435,  -0.0623,   0.9371 },
};

static float texcoord[][2] = {
#ifdef _ORIGINAL_ /* [ */
    {   0.1121,   0.0171 },
    {   0.1094,   0.0411 },
    {   0.1066,   0.0654 },
    {   0.1038,   0.0898 },
    {   0.1010,   0.1141 },
    {   0.0982,   0.1384 },
    {   0.0954,   0.1624 },
    {   0.0926,   0.1868 },
    {   0.0898,   0.2111 },
    {   0.0870,   0.2354 },
    {   0.0842,   0.2598 },
    {   0.0815,   0.2838 },
    {   0.0787,   0.3081 },
    {   0.0759,   0.3325 },
    {   0.0731,   0.3568 },
    {   0.0703,   0.3811 },
    {   0.0675,   0.4052 },
    {   0.0647,   0.4295 },
    {   0.0619,   0.4538 },
    {   0.0591,   0.4782 },
    {   0.0564,   0.5025 },
    {   0.0536,   0.5265 },
    {   0.0508,   0.5508 },
    {   0.0480,   0.5752 },
    {   0.0452,   0.5995 },
    {   0.0424,   0.6239 },
    {   0.0397,   0.6479 },
    {   0.0369,   0.6722 },
    {   0.0341,   0.6965 },
    {   0.0313,   0.7209 },
    {   0.0285,   0.7452 },
    {   0.0257,   0.7692 },
    {   0.0229,   0.7936 },
    {   0.0201,   0.8179 },
    {   0.0173,   0.8422 },
    {   0.0145,   0.8666 },
    {   0.0118,   0.8906 },
    {   0.0090,   0.9149 },
    {   0.0062,   0.9393 },
    {   0.1364,   0.0199 },
    {   0.1336,   0.0439 },
    {   0.1309,   0.0682 },
    {   0.1281,   0.0925 },
    {   0.1253,   0.1169 },
    {   0.1225,   0.1412 },
    {   0.1197,   0.1652 },
    {   0.1169,   0.1896 },
    {   0.1141,   0.2139 },
    {   0.1113,   0.2382 },
    {   0.1085,   0.2626 },
    {   0.1058,   0.2866 },
    {   0.1030,   0.3109 },
    {   0.1002,   0.3353 },
    {   0.0974,   0.3596 },
    {   0.0946,   0.3839 },
    {   0.0918,   0.4079 },
    {   0.0890,   0.4323 },
    {   0.0862,   0.4566 },
    {   0.0834,   0.4810 },
    {   0.0806,   0.5053 },
    {   0.0779,   0.5293 },
    {   0.0751,   0.5536 },
    {   0.0723,   0.5780 },
    {   0.0695,   0.6023 },
    {   0.0667,   0.6266 },
    {   0.0640,   0.6507 },
    {   0.0612,   0.6750 },
    {   0.0584,   0.6993 },
    {   0.0556,   0.7237 },
    {   0.0528,   0.7480 },
    {   0.0500,   0.7720 },
    {   0.0472,   0.7964 },
    {   0.0444,   0.8207 },
    {   0.0416,   0.8450 },
    {   0.0388,   0.8694 },
    {   0.0361,   0.8934 },
    {   0.0333,   0.9177 },
    {   0.0305,   0.9420 },
    {   0.1607,   0.0226 },
    {   0.1579,   0.0467 },
    {   0.1551,   0.0710 },
    {   0.1523,   0.0953 },
    {   0.1495,   0.1197 },
    {   0.1467,   0.1440 },
    {   0.1440,   0.1680 },
    {   0.1412,   0.1924 },
    {   0.1384,   0.2167 },
    {   0.1356,   0.2410 },
    {   0.1328,   0.2654 },
    {   0.1300,   0.2894 },
    {   0.1272,   0.3137 },
    {   0.1244,   0.3380 },
    {   0.1216,   0.3624 },
    {   0.1188,   0.3867 },
    {   0.1161,   0.4107 },
    {   0.1133,   0.4351 },
    {   0.1105,   0.4594 },
    {   0.1077,   0.4837 },
    {   0.1049,   0.5081 },
    {   0.1021,   0.5321 },
    {   0.0994,   0.5564 },
    {   0.0966,   0.5808 },
    {   0.0938,   0.6051 },
    {   0.0910,   0.6294 },
    {   0.0882,   0.6534 },
    {   0.0854,   0.6778 },
    {   0.0826,   0.7021 },
    {   0.0798,   0.7265 },
    {   0.0770,   0.7508 },
    {   0.0743,   0.7748 },
    {   0.0715,   0.7991 },
    {   0.0687,   0.8235 },
    {   0.0659,   0.8478 },
    {   0.0631,   0.8721 },
    {   0.0603,   0.8962 },
    {   0.0575,   0.9205 },
    {   0.0547,   0.9448 },
    {   0.1850,   0.0254 },
    {   0.1822,   0.0495 },
    {   0.1794,   0.0738 },
    {   0.1766,   0.0981 },
    {   0.1738,   0.1225 },
    {   0.1710,   0.1468 },
    {   0.1683,   0.1708 },
    {   0.1655,   0.1951 },
    {   0.1627,   0.2195 },
    {   0.1599,   0.2438 },
    {   0.1571,   0.2681 },
    {   0.1543,   0.2922 },
    {   0.1515,   0.3165 },
    {   0.1487,   0.3408 },
    {   0.1459,   0.3652 },
    {   0.1431,   0.3895 },
    {   0.1404,   0.4135 },
    {   0.1376,   0.4379 },
    {   0.1348,   0.4622 },
    {   0.1320,   0.4865 },
    {   0.1292,   0.5109 },
    {   0.1264,   0.5349 },
    {   0.1236,   0.5592 },
    {   0.1209,   0.5835 },
    {   0.1181,   0.6079 },
    {   0.1153,   0.6322 },
    {   0.1125,   0.6562 },
    {   0.1097,   0.6806 },
    {   0.1069,   0.7049 },
    {   0.1041,   0.7292 },
    {   0.1013,   0.7536 },
    {   0.0986,   0.7776 },
    {   0.0958,   0.8019 },
    {   0.0930,   0.8263 },
    {   0.0902,   0.8506 },
    {   0.0874,   0.8749 },
    {   0.0846,   0.8990 },
    {   0.0818,   0.9233 },
    {   0.0790,   0.9476 },
    {   0.2092,   0.0282 },
    {   0.2065,   0.0522 },
    {   0.2037,   0.0766 },
    {   0.2009,   0.1009 },
    {   0.1981,   0.1252 },
    {   0.1953,   0.1496 },
    {   0.1925,   0.1736 },
    {   0.1897,   0.1979 },
    {   0.1869,   0.2223 },
    {   0.1841,   0.2466 },
    {   0.1813,   0.2709 },
    {   0.1786,   0.2950 },
    {   0.1758,   0.3193 },
    {   0.1730,   0.3436 },
    {   0.1702,   0.3680 },
    {   0.1674,   0.3923 },
    {   0.1646,   0.4163 },
    {   0.1618,   0.4406 },
    {   0.1590,   0.4650 },
    {   0.1563,   0.4893 },
    {   0.1535,   0.5136 },
    {   0.1507,   0.5377 },
    {   0.1479,   0.5620 },
    {   0.1451,   0.5863 },
    {   0.1423,   0.6107 },
    {   0.1395,   0.6350 },
    {   0.1368,   0.6590 },
    {   0.1340,   0.6834 },
    {   0.1312,   0.7077 },
    {   0.1284,   0.7320 },
    {   0.1256,   0.7564 },
    {   0.1228,   0.7804 },
    {   0.1200,   0.8047 },
    {   0.1172,   0.8290 },
    {   0.1144,   0.8534 },
    {   0.1116,   0.8777 },
    {   0.1089,   0.9017 },
    {   0.1061,   0.9261 },
    {   0.1033,   0.9504 },
    {   0.2335,   0.0310 },
    {   0.2307,   0.0550 },
    {   0.2279,   0.0794 },
    {   0.2251,   0.1037 },
    {   0.2223,   0.1280 },
    {   0.2195,   0.1524 },
    {   0.2168,   0.1764 },
    {   0.2140,   0.2007 },
    {   0.2112,   0.2251 },
    {   0.2084,   0.2494 },
    {   0.2056,   0.2737 },
    {   0.2028,   0.2977 },
    {   0.2000,   0.3221 },
    {   0.1972,   0.3464 },
    {   0.1944,   0.3707 },
    {   0.1916,   0.3951 },
    {   0.1889,   0.4191 },
    {   0.1861,   0.4434 },
    {   0.1833,   0.4678 },
    {   0.1805,   0.4921 },
    {   0.1777,   0.5164 },
    {   0.1750,   0.5405 },
    {   0.1722,   0.5648 },
    {   0.1694,   0.5891 },
    {   0.1666,   0.6135 },
    {   0.1638,   0.6378 },
    {   0.1610,   0.6618 },
    {   0.1582,   0.6861 },
    {   0.1554,   0.7105 },
    {   0.1526,   0.7348 },
    {   0.1498,   0.7591 },
    {   0.1471,   0.7832 },
    {   0.1443,   0.8075 },
    {   0.1415,   0.8318 },
    {   0.1387,   0.8562 },
    {   0.1359,   0.8805 },
    {   0.1331,   0.9045 },
    {   0.1303,   0.9289 },
    {   0.1275,   0.9532 },
    {   0.2578,   0.0338 },
    {   0.2550,   0.0578 },
    {   0.2522,   0.0822 },
    {   0.2494,   0.1065 },
    {   0.2466,   0.1308 },
    {   0.2438,   0.1552 },
    {   0.2411,   0.1792 },
    {   0.2383,   0.2035 },
    {   0.2355,   0.2278 },
    {   0.2327,   0.2522 },
    {   0.2299,   0.2765 },
    {   0.2271,   0.3005 },
    {   0.2243,   0.3249 },
    {   0.2215,   0.3492 },
    {   0.2187,   0.3735 },
    {   0.2159,   0.3979 },
    {   0.2132,   0.4219 },
    {   0.2104,   0.4462 },
    {   0.2076,   0.4706 },
    {   0.2048,   0.4949 },
    {   0.2020,   0.5192 },
    {   0.1992,   0.5432 },
    {   0.1965,   0.5676 },
    {   0.1937,   0.5919 },
    {   0.1909,   0.6162 },
    {   0.1881,   0.6406 },
    {   0.1853,   0.6646 },
    {   0.1825,   0.6889 },
    {   0.1797,   0.7133 },
    {   0.1769,   0.7376 },
    {   0.1741,   0.7619 },
    {   0.1714,   0.7860 },
    {   0.1686,   0.8103 },
    {   0.1658,   0.8346 },
    {   0.1630,   0.8590 },
    {   0.1602,   0.8833 },
    {   0.1574,   0.9073 },
    {   0.1546,   0.9316 },
    {   0.1518,   0.9560 },
    {   0.2820,   0.0366 },
    {   0.2793,   0.0606 },
    {   0.2765,   0.0849 },
    {   0.2737,   0.1093 },
    {   0.2709,   0.1336 },
    {   0.2681,   0.1579 },
    {   0.2653,   0.1820 },
    {   0.2625,   0.2063 },
    {   0.2597,   0.2306 },
    {   0.2569,   0.2550 },
    {   0.2541,   0.2793 },
    {   0.2514,   0.3033 },
    {   0.2486,   0.3277 },
    {   0.2458,   0.3520 },
    {   0.2430,   0.3763 },
    {   0.2402,   0.4007 },
    {   0.2374,   0.4247 },
    {   0.2346,   0.4490 },
    {   0.2319,   0.4733 },
    {   0.2291,   0.4977 },
    {   0.2263,   0.5220 },
    {   0.2235,   0.5460 },
    {   0.2207,   0.5704 },
    {   0.2179,   0.5947 },
    {   0.2151,   0.6190 },
    {   0.2123,   0.6434 },
    {   0.2096,   0.6674 },
    {   0.2068,   0.6917 },
    {   0.2040,   0.7161 },
    {   0.2012,   0.7404 },
    {   0.1984,   0.7647 },
    {   0.1956,   0.7887 },
    {   0.1928,   0.8131 },
    {   0.1900,   0.8374 },
    {   0.1872,   0.8617 },
    {   0.1844,   0.8861 },
    {   0.1817,   0.9101 },
    {   0.1789,   0.9344 },
    {   0.1761,   0.9588 },
    {   0.3063,   0.0394 },
    {   0.3036,   0.0634 },
    {   0.3008,   0.0877 },
    {   0.2980,   0.1121 },
    {   0.2952,   0.1364 },
    {   0.2924,   0.1607 },
    {   0.2896,   0.1848 },
    {   0.2868,   0.2091 },
    {   0.2840,   0.2334 },
    {   0.2812,   0.2578 },
    {   0.2784,   0.2821 },
    {   0.2757,   0.3061 },
    {   0.2729,   0.3304 },
    {   0.2701,   0.3548 },
    {   0.2673,   0.3791 },
    {   0.2645,   0.4034 },
    {   0.2617,   0.4275 },
    {   0.2589,   0.4518 },
    {   0.2561,   0.4761 },
    {   0.2534,   0.5005 },
    {   0.2506,   0.5248 },
    {   0.2478,   0.5488 },
    {   0.2450,   0.5732 },
    {   0.2422,   0.5975 },
    {   0.2394,   0.6218 },
    {   0.2366,   0.6462 },
    {   0.2339,   0.6702 },
    {   0.2311,   0.6945 },
    {   0.2283,   0.7188 },
    {   0.2255,   0.7432 },
    {   0.2227,   0.7675 },
    {   0.2199,   0.7915 },
    {   0.2171,   0.8159 },
    {   0.2143,   0.8402 },
    {   0.2115,   0.8645 },
    {   0.2087,   0.8889 },
    {   0.2060,   0.9129 },
    {   0.2032,   0.9372 },
    {   0.2004,   0.9616 },
    {   0.3306,   0.0422 },
    {   0.3278,   0.0662 },
    {   0.3250,   0.0905 },
    {   0.3222,   0.1148 },
    {   0.3194,   0.1392 },
    {   0.3166,   0.1635 },
    {   0.3139,   0.1875 },
    {   0.3111,   0.2119 },
    {   0.3083,   0.2362 },
    {   0.3055,   0.2605 },
    {   0.3027,   0.2849 },
    {   0.2999,   0.3089 },
    {   0.2971,   0.3332 },
    {   0.2943,   0.3576 },
    {   0.2915,   0.3819 },
    {   0.2888,   0.4062 },
    {   0.2860,   0.4302 },
    {   0.2832,   0.4546 },
    {   0.2804,   0.4789 },
    {   0.2776,   0.5033 },
    {   0.2748,   0.5276 },
    {   0.2721,   0.5516 },
    {   0.2693,   0.5759 },
    {   0.2665,   0.6003 },
    {   0.2637,   0.6246 },
    {   0.2609,   0.6489 },
    {   0.2581,   0.6730 },
    {   0.2553,   0.6973 },
    {   0.2525,   0.7216 },
    {   0.2497,   0.7460 },
    {   0.2469,   0.7703 },
    {   0.2442,   0.7943 },
    {   0.2414,   0.8187 },
    {   0.2386,   0.8430 },
    {   0.2358,   0.8673 },
    {   0.2330,   0.8917 },
    {   0.2302,   0.9157 },
    {   0.2274,   0.9400 },
    {   0.2246,   0.9643 },
    {   0.3548,   0.0449 },
    {   0.3521,   0.0690 },
    {   0.3493,   0.0933 },
    {   0.3465,   0.1176 },
    {   0.3437,   0.1420 },
    {   0.3409,   0.1663 },
    {   0.3381,   0.1903 },
    {   0.3353,   0.2147 },
    {   0.3325,   0.2390 },
    {   0.3297,   0.2633 },
    {   0.3269,   0.2877 },
    {   0.3242,   0.3117 },
    {   0.3214,   0.3360 },
    {   0.3186,   0.3603 },
    {   0.3158,   0.3847 },
    {   0.3130,   0.4090 },
    {   0.3102,   0.4330 },
    {   0.3075,   0.4574 },
    {   0.3047,   0.4817 },
    {   0.3019,   0.5060 },
    {   0.2991,   0.5304 },
    {   0.2963,   0.5544 },
    {   0.2935,   0.5787 },
    {   0.2907,   0.6031 },
    {   0.2879,   0.6274 },
    {   0.2851,   0.6517 },
    {   0.2824,   0.6757 },
    {   0.2796,   0.7001 },
    {   0.2768,   0.7244 },
    {   0.2740,   0.7488 },
    {   0.2712,   0.7731 },
    {   0.2684,   0.7971 },
    {   0.2656,   0.8214 },
    {   0.2628,   0.8458 },
    {   0.2600,   0.8701 },
    {   0.2573,   0.8944 },
    {   0.2545,   0.9185 },
    {   0.2517,   0.9428 },
    {   0.2489,   0.9671 },
    {   0.3791,   0.0477 },
    {   0.3764,   0.0718 },
    {   0.3736,   0.0961 },
    {   0.3708,   0.1204 },
    {   0.3680,   0.1448 },
    {   0.3652,   0.1691 },
    {   0.3624,   0.1931 },
    {   0.3596,   0.2174 },
    {   0.3568,   0.2418 },
    {   0.3540,   0.2661 },
    {   0.3512,   0.2905 },
    {   0.3485,   0.3145 },
    {   0.3457,   0.3388 },
    {   0.3429,   0.3631 },
    {   0.3401,   0.3875 },
    {   0.3373,   0.4118 },
    {   0.3345,   0.4358 },
    {   0.3317,   0.4602 },
    {   0.3290,   0.4845 },
    {   0.3262,   0.5088 },
    {   0.3234,   0.5332 },
    {   0.3206,   0.5572 },
    {   0.3178,   0.5815 },
    {   0.3150,   0.6059 },
    {   0.3122,   0.6302 },
    {   0.3094,   0.6545 },
    {   0.3067,   0.6785 },
    {   0.3039,   0.7029 },
    {   0.3011,   0.7272 },
    {   0.2983,   0.7515 },
    {   0.2955,   0.7759 },
    {   0.2927,   0.7999 },
    {   0.2899,   0.8242 },
    {   0.2871,   0.8486 },
    {   0.2843,   0.8729 },
    {   0.2815,   0.8972 },
    {   0.2788,   0.9213 },
    {   0.2760,   0.9456 },
    {   0.2732,   0.9699 },
    {   0.4034,   0.0505 },
    {   0.4006,   0.0745 },
    {   0.3978,   0.0989 },
    {   0.3950,   0.1232 },
    {   0.3922,   0.1475 },
    {   0.3894,   0.1719 },
    {   0.3867,   0.1959 },
    {   0.3839,   0.2202 },
    {   0.3811,   0.2446 },
    {   0.3783,   0.2689 },
    {   0.3755,   0.2932 },
    {   0.3727,   0.3173 },
    {   0.3699,   0.3416 },
    {   0.3671,   0.3659 },
    {   0.3644,   0.3903 },
    {   0.3616,   0.4146 },
    {   0.3588,   0.4386 },
    {   0.3560,   0.4629 },
    {   0.3532,   0.4873 },
    {   0.3504,   0.5116 },
    {   0.3476,   0.5359 },
    {   0.3449,   0.5600 },
    {   0.3421,   0.5843 },
    {   0.3393,   0.6086 },
    {   0.3365,   0.6330 },
    {   0.3337,   0.6573 },
    {   0.3309,   0.6813 },
    {   0.3281,   0.7057 },
    {   0.3253,   0.7300 },
    {   0.3225,   0.7543 },
    {   0.3197,   0.7787 },
    {   0.3170,   0.8027 },
    {   0.3142,   0.8270 },
    {   0.3114,   0.8513 },
    {   0.3086,   0.8757 },
    {   0.3058,   0.9000 },
    {   0.3030,   0.9240 },
    {   0.3002,   0.9484 },
    {   0.2975,   0.9727 },
    {   0.4277,   0.0533 },
    {   0.4249,   0.0773 },
    {   0.4221,   0.1017 },
    {   0.4193,   0.1260 },
    {   0.4165,   0.1503 },
    {   0.4137,   0.1747 },
    {   0.4110,   0.1987 },
    {   0.4082,   0.2230 },
    {   0.4054,   0.2474 },
    {   0.4026,   0.2717 },
    {   0.3998,   0.2960 },
    {   0.3970,   0.3200 },
    {   0.3942,   0.3444 },
    {   0.3914,   0.3687 },
    {   0.3886,   0.3930 },
    {   0.3859,   0.4174 },
    {   0.3831,   0.4414 },
    {   0.3803,   0.4657 },
    {   0.3775,   0.4901 },
    {   0.3747,   0.5144 },
    {   0.3719,   0.5387 },
    {   0.3692,   0.5628 },
    {   0.3664,   0.5871 },
    {   0.3636,   0.6114 },
    {   0.3608,   0.6358 },
    {   0.3580,   0.6601 },
    {   0.3552,   0.6841 },
    {   0.3524,   0.7084 },
    {   0.3496,   0.7328 },
    {   0.3468,   0.7571 },
    {   0.3440,   0.7815 },
    {   0.3413,   0.8055 },
    {   0.3385,   0.8298 },
    {   0.3357,   0.8541 },
    {   0.3329,   0.8785 },
    {   0.3301,   0.9028 },
    {   0.3273,   0.9268 },
    {   0.3245,   0.9512 },
    {   0.3217,   0.9755 },
    {   0.4519,   0.0561 },
    {   0.4492,   0.0801 },
    {   0.4464,   0.1045 },
    {   0.4436,   0.1288 },
    {   0.4408,   0.1531 },
    {   0.4380,   0.1775 },
    {   0.4352,   0.2015 },
    {   0.4324,   0.2258 },
    {   0.4296,   0.2501 },
    {   0.4268,   0.2745 },
    {   0.4240,   0.2988 },
    {   0.4213,   0.3228 },
    {   0.4185,   0.3472 },
    {   0.4157,   0.3715 },
    {   0.4129,   0.3958 },
    {   0.4101,   0.4202 },
    {   0.4073,   0.4442 },
    {   0.4046,   0.4685 },
    {   0.4018,   0.4929 },
    {   0.3990,   0.5172 },
    {   0.3962,   0.5415 },
    {   0.3934,   0.5655 },
    {   0.3906,   0.5899 },
    {   0.3878,   0.6142 },
    {   0.3850,   0.6385 },
    {   0.3822,   0.6629 },
    {   0.3795,   0.6869 },
    {   0.3767,   0.7112 },
    {   0.3739,   0.7356 },
    {   0.3711,   0.7599 },
    {   0.3683,   0.7842 },
    {   0.3655,   0.8083 },
    {   0.3627,   0.8326 },
    {   0.3599,   0.8569 },
    {   0.3571,   0.8813 },
    {   0.3544,   0.9056 },
    {   0.3516,   0.9296 },
    {   0.3488,   0.9539 },
    {   0.3460,   0.9783 },
    {   0.4762,   0.0589 },
    {   0.4734,   0.0829 },
    {   0.4706,   0.1072 },
    {   0.4678,   0.1316 },
    {   0.4650,   0.1559 },
    {   0.4622,   0.1802 },
    {   0.4595,   0.2043 },
    {   0.4567,   0.2286 },
    {   0.4539,   0.2529 },
    {   0.4511,   0.2773 },
    {   0.4483,   0.3016 },
    {   0.4455,   0.3256 },
    {   0.4427,   0.3500 },
    {   0.4400,   0.3743 },
    {   0.4372,   0.3986 },
    {   0.4344,   0.4230 },
    {   0.4316,   0.4470 },
    {   0.4288,   0.4713 },
    {   0.4260,   0.4956 },
    {   0.4232,   0.5200 },
    {   0.4204,   0.5443 },
    {   0.4177,   0.5683 },
    {   0.4149,   0.5927 },
    {   0.4121,   0.6170 },
    {   0.4093,   0.6413 },
    {   0.4065,   0.6657 },
    {   0.4037,   0.6897 },
    {   0.4009,   0.7140 },
    {   0.3981,   0.7384 },
    {   0.3953,   0.7627 },
    {   0.3925,   0.7870 },
    {   0.3898,   0.8110 },
    {   0.3870,   0.8354 },
    {   0.3842,   0.8597 },
    {   0.3814,   0.8840 },
    {   0.3786,   0.9084 },
    {   0.3758,   0.9324 },
    {   0.3731,   0.9567 },
    {   0.3703,   0.9811 },
    {   0.5005,   0.0617 },
    {   0.4977,   0.0857 },
    {   0.4949,   0.1100 },
    {   0.4921,   0.1344 },
    {   0.4893,   0.1587 },
    {   0.4865,   0.1830 },
    {   0.4838,   0.2071 },
    {   0.4810,   0.2314 },
    {   0.4782,   0.2557 },
    {   0.4754,   0.2801 },
    {   0.4726,   0.3044 },
    {   0.4698,   0.3284 },
    {   0.4670,   0.3527 },
    {   0.4642,   0.3771 },
    {   0.4615,   0.4014 },
    {   0.4587,   0.4257 },
    {   0.4559,   0.4498 },
    {   0.4531,   0.4741 },
    {   0.4503,   0.4984 },
    {   0.4475,   0.5228 },
    {   0.4447,   0.5471 },
    {   0.4420,   0.5711 },
    {   0.4392,   0.5955 },
    {   0.4364,   0.6198 },
    {   0.4336,   0.6441 },
    {   0.4308,   0.6685 },
    {   0.4280,   0.6925 },
    {   0.4252,   0.7168 },
    {   0.4224,   0.7411 },
    {   0.4196,   0.7655 },
    {   0.4168,   0.7898 },
    {   0.4141,   0.8138 },
    {   0.4113,   0.8382 },
    {   0.4085,   0.8625 },
    {   0.4057,   0.8868 },
    {   0.4029,   0.9112 },
    {   0.4001,   0.9352 },
    {   0.3973,   0.9595 },
    {   0.3946,   0.9839 },
    {   0.5247,   0.0645 },
    {   0.5220,   0.0885 },
    {   0.5192,   0.1128 },
    {   0.5164,   0.1371 },
    {   0.5136,   0.1615 },
    {   0.5108,   0.1858 },
    {   0.5080,   0.2098 },
    {   0.5052,   0.2342 },
    {   0.5024,   0.2585 },
    {   0.4996,   0.2828 },
    {   0.4969,   0.3072 },
    {   0.4941,   0.3312 },
    {   0.4913,   0.3555 },
    {   0.4885,   0.3799 },
    {   0.4857,   0.4042 },
    {   0.4829,   0.4285 },
    {   0.4802,   0.4526 },
    {   0.4774,   0.4769 },
    {   0.4746,   0.5012 },
    {   0.4718,   0.5256 },
    {   0.4690,   0.5499 },
    {   0.4662,   0.5739 },
    {   0.4634,   0.5982 },
    {   0.4606,   0.6226 },
    {   0.4578,   0.6469 },
    {   0.4550,   0.6712 },
    {   0.4523,   0.6953 },
    {   0.4495,   0.7196 },
    {   0.4467,   0.7439 },
    {   0.4439,   0.7683 },
    {   0.4411,   0.7926 },
    {   0.4383,   0.8166 },
    {   0.4355,   0.8410 },
    {   0.4327,   0.8653 },
    {   0.4300,   0.8896 },
    {   0.4272,   0.9140 },
    {   0.4244,   0.9380 },
    {   0.4216,   0.9623 },
    {   0.4188,   0.9866 },
    {   0.5490,   0.0673 },
    {   0.5463,   0.0913 },
    {   0.5435,   0.1156 },
    {   0.5407,   0.1399 },
    {   0.5379,   0.1643 },
    {   0.5351,   0.1886 },
    {   0.5323,   0.2126 },
    {   0.5295,   0.2370 },
    {   0.5267,   0.2613 },
    {   0.5239,   0.2856 },
    {   0.5211,   0.3100 },
    {   0.5184,   0.3340 },
    {   0.5156,   0.3583 },
    {   0.5128,   0.3827 },
    {   0.5100,   0.4070 },
    {   0.5072,   0.4313 },
    {   0.5044,   0.4553 },
    {   0.5017,   0.4797 },
    {   0.4989,   0.5040 },
    {   0.4961,   0.5283 },
    {   0.4933,   0.5527 },
    {   0.4905,   0.5767 },
    {   0.4877,   0.6010 },
    {   0.4849,   0.6254 },
    {   0.4821,   0.6497 },
    {   0.4793,   0.6740 },
    {   0.4766,   0.6981 },
    {   0.4738,   0.7224 },
    {   0.4710,   0.7467 },
    {   0.4682,   0.7711 },
    {   0.4654,   0.7954 },
    {   0.4626,   0.8194 },
    {   0.4598,   0.8437 },
    {   0.4570,   0.8681 },
    {   0.4542,   0.8924 },
    {   0.4515,   0.9167 },
    {   0.4487,   0.9408 },
    {   0.4459,   0.9651 },
    {   0.4431,   0.9894 },
    {   0.5733,   0.0700 },
    {   0.5705,   0.0941 },
    {   0.5677,   0.1184 },
    {   0.5649,   0.1427 },
    {   0.5621,   0.1671 },
    {   0.5593,   0.1914 },
    {   0.5566,   0.2154 },
    {   0.5538,   0.2397 },
    {   0.5510,   0.2641 },
    {   0.5482,   0.2884 },
    {   0.5454,   0.3128 },
    {   0.5426,   0.3368 },
    {   0.5398,   0.3611 },
    {   0.5371,   0.3854 },
    {   0.5343,   0.4098 },
    {   0.5315,   0.4341 },
    {   0.5287,   0.4581 },
    {   0.5259,   0.4825 },
    {   0.5231,   0.5068 },
    {   0.5203,   0.5311 },
    {   0.5175,   0.5555 },
    {   0.5148,   0.5795 },
    {   0.5120,   0.6038 },
    {   0.5092,   0.6282 },
    {   0.5064,   0.6525 },
    {   0.5036,   0.6768 },
    {   0.5008,   0.7008 },
    {   0.4980,   0.7252 },
    {   0.4952,   0.7495 },
    {   0.4924,   0.7738 },
    {   0.4896,   0.7982 },
    {   0.4869,   0.8222 },
    {   0.4841,   0.8465 },
    {   0.4813,   0.8709 },
    {   0.4785,   0.8952 },
    {   0.4757,   0.9195 },
    {   0.4729,   0.9436 },
    {   0.4702,   0.9679 },
    {   0.4674,   0.9922 },
    {   0.5975,   0.0728 },
    {   0.5948,   0.0968 },
    {   0.5920,   0.1212 },
    {   0.5892,   0.1455 },
    {   0.5864,   0.1698 },
    {   0.5836,   0.1942 },
    {   0.5808,   0.2182 },
    {   0.5780,   0.2425 },
    {   0.5752,   0.2669 },
    {   0.5725,   0.2912 },
    {   0.5697,   0.3155 },
    {   0.5669,   0.3396 },
    {   0.5641,   0.3639 },
    {   0.5613,   0.3882 },
    {   0.5585,   0.4126 },
    {   0.5557,   0.4369 },
    {   0.5530,   0.4609 },
    {   0.5502,   0.4852 },
    {   0.5474,   0.5096 },
    {   0.5446,   0.5339 },
    {   0.5418,   0.5583 },
    {   0.5390,   0.5823 },
    {   0.5362,   0.6066 },
    {   0.5334,   0.6309 },
    {   0.5306,   0.6553 },
    {   0.5278,   0.6796 },
    {   0.5251,   0.7036 },
    {   0.5223,   0.7280 },
    {   0.5195,   0.7523 },
    {   0.5167,   0.7766 },
    {   0.5139,   0.8010 },
    {   0.5111,   0.8250 },
    {   0.5083,   0.8493 },
    {   0.5056,   0.8737 },
    {   0.5028,   0.8980 },
    {   0.5000,   0.9223 },
    {   0.4972,   0.9463 },
    {   0.4944,   0.9707 },
    {   0.4916,   0.9950 },
    {   0.6218,   0.0756 },
    {   0.6191,   0.0996 },
    {   0.6163,   0.1240 },
    {   0.6135,   0.1483 },
    {   0.6107,   0.1726 },
    {   0.6079,   0.1970 },
    {   0.6051,   0.2210 },
    {   0.6023,   0.2453 },
    {   0.5995,   0.2697 },
    {   0.5967,   0.2940 },
    {   0.5940,   0.3183 },
    {   0.5912,   0.3423 },
    {   0.5884,   0.3667 },
    {   0.5856,   0.3910 },
    {   0.5828,   0.4153 },
    {   0.5800,   0.4397 },
    {   0.5773,   0.4637 },
    {   0.5745,   0.4880 },
    {   0.5717,   0.5124 },
    {   0.5689,   0.5367 },
    {   0.5661,   0.5610 },
    {   0.5633,   0.5851 },
    {   0.5605,   0.6094 },
    {   0.5577,   0.6337 },
    {   0.5549,   0.6581 },
    {   0.5521,   0.6824 },
    {   0.5494,   0.7064 },
    {   0.5466,   0.7308 },
    {   0.5438,   0.7551 },
    {   0.5410,   0.7794 },
    {   0.5382,   0.8038 },
    {   0.5354,   0.8278 },
    {   0.5326,   0.8521 },
    {   0.5298,   0.8764 },
    {   0.5271,   0.9008 },
    {   0.5243,   0.9251 },
    {   0.5215,   0.9491 },
    {   0.5187,   0.9735 },
    {   0.5159,   0.9978 },
    {   0.6461,   0.0784 },
    {   0.6433,   0.1024 },
    {   0.6405,   0.1268 },
    {   0.6377,   0.1511 },
    {   0.6349,   0.1754 },
    {   0.6321,   0.1998 },
    {   0.6294,   0.2238 },
    {   0.6266,   0.2481 },
    {   0.6238,   0.2724 },
    {   0.6210,   0.2968 },
    {   0.6182,   0.3211 },
    {   0.6154,   0.3451 },
    {   0.6127,   0.3695 },
    {   0.6099,   0.3938 },
    {   0.6071,   0.4181 },
    {   0.6043,   0.4425 },
    {   0.6015,   0.4665 },
    {   0.5987,   0.4908 },
    {   0.5959,   0.5152 },
    {   0.5931,   0.5395 },
    {   0.5903,   0.5638 },
    {   0.5876,   0.5878 },
    {   0.5848,   0.6122 },
    {   0.5820,   0.6365 },
    {   0.5792,   0.6608 },
    {   0.5764,   0.6852 },
    {   0.5736,   0.7092 },
    {   0.5708,   0.7335 },
    {   0.5680,   0.7579 },
    {   0.5652,   0.7822 },
    {   0.5625,   0.8065 },
    {   0.5597,   0.8306 },
    {   0.5569,   0.8549 },
    {   0.5541,   0.8792 },
    {   0.5513,   0.9036 },
    {   0.5485,   0.9279 },
    {   0.5458,   0.9519 },
    {   0.5430,   0.9762 },
    {   0.5402,   1.0006 },
    {   0.6704,   0.0812 },
    {   0.6676,   0.1052 },
    {   0.6648,   0.1295 },
    {   0.6620,   0.1539 },
    {   0.6592,   0.1782 },
    {   0.6564,   0.2025 },
    {   0.6537,   0.2266 },
    {   0.6509,   0.2509 },
    {   0.6481,   0.2752 },
    {   0.6453,   0.2996 },
    {   0.6425,   0.3239 },
    {   0.6397,   0.3479 },
    {   0.6369,   0.3723 },
    {   0.6342,   0.3966 },
    {   0.6314,   0.4209 },
    {   0.6286,   0.4453 },
    {   0.6258,   0.4693 },
    {   0.6230,   0.4936 },
    {   0.6202,   0.5179 },
    {   0.6174,   0.5423 },
    {   0.6146,   0.5666 },
    {   0.6119,   0.5906 },
    {   0.6091,   0.6150 },
    {   0.6063,   0.6393 },
    {   0.6035,   0.6636 },
    {   0.6007,   0.6880 },
    {   0.5979,   0.7120 },
    {   0.5951,   0.7363 },
    {   0.5923,   0.7607 },
    {   0.5895,   0.7850 },
    {   0.5867,   0.8093 },
    {   0.5840,   0.8333 },
    {   0.5812,   0.8577 },
    {   0.5784,   0.8820 },
    {   0.5756,   0.9064 },
    {   0.5728,   0.9307 },
    {   0.5701,   0.9547 },
    {   0.5673,   0.9790 },
    {   0.5645,   1.0034 },
    {   0.6946,   0.0840 },
    {   0.6919,   0.1080 },
    {   0.6891,   0.1323 },
    {   0.6863,   0.1567 },
    {   0.6835,   0.1810 },
    {   0.6807,   0.2053 },
    {   0.6779,   0.2294 },
    {   0.6751,   0.2537 },
    {   0.6723,   0.2780 },
    {   0.6696,   0.3024 },
    {   0.6668,   0.3267 },
    {   0.6640,   0.3507 },
    {   0.6612,   0.3750 },
    {   0.6584,   0.3994 },
    {   0.6556,   0.4237 },
    {   0.6528,   0.4480 },
    {   0.6501,   0.4721 },
    {   0.6473,   0.4964 },
    {   0.6445,   0.5207 },
    {   0.6417,   0.5451 },
    {   0.6389,   0.5694 },
    {   0.6361,   0.5934 },
    {   0.6333,   0.6178 },
    {   0.6305,   0.6421 },
    {   0.6277,   0.6664 },
    {   0.6249,   0.6908 },
    {   0.6222,   0.7148 },
    {   0.6194,   0.7391 },
    {   0.6166,   0.7634 },
    {   0.6138,   0.7878 },
    {   0.6110,   0.8121 },
    {   0.6082,   0.8361 },
    {   0.6055,   0.8605 },
    {   0.6027,   0.8848 },
    {   0.5999,   0.9091 },
    {   0.5971,   0.9335 },
    {   0.5943,   0.9575 },
    {   0.5915,   0.9818 },
    {   0.5887,   1.0062 },
    {   0.7189,   0.0868 },
    {   0.7161,   0.1108 },
    {   0.7133,   0.1351 },
    {   0.7105,   0.1595 },
    {   0.7077,   0.1838 },
    {   0.7050,   0.2081 },
    {   0.7022,   0.2321 },
    {   0.6994,   0.2565 },
    {   0.6966,   0.2808 },
    {   0.6938,   0.3051 },
    {   0.6910,   0.3295 },
    {   0.6883,   0.3535 },
    {   0.6855,   0.3778 },
    {   0.6827,   0.4022 },
    {   0.6799,   0.4265 },
    {   0.6771,   0.4508 },
    {   0.6743,   0.4749 },
    {   0.6715,   0.4992 },
    {   0.6687,   0.5235 },
    {   0.6659,   0.5479 },
    {   0.6631,   0.5722 },
    {   0.6604,   0.5962 },
    {   0.6576,   0.6205 },
    {   0.6548,   0.6449 },
    {   0.6520,   0.6692 },
    {   0.6492,   0.6935 },
    {   0.6464,   0.7176 },
    {   0.6436,   0.7419 },
    {   0.6408,   0.7662 },
    {   0.6381,   0.7906 },
    {   0.6353,   0.8149 },
    {   0.6325,   0.8389 },
    {   0.6297,   0.8633 },
    {   0.6269,   0.8876 },
    {   0.6241,   0.9119 },
    {   0.6213,   0.9363 },
    {   0.6186,   0.9603 },
    {   0.6158,   0.9846 },
    {   0.6130,   1.0089 },
    {   0.7432,   0.0896 },
    {   0.7404,   0.1136 },
    {   0.7376,   0.1379 },
    {   0.7348,   0.1622 },
    {   0.7320,   0.1866 },
    {   0.7292,   0.2109 },
    {   0.7265,   0.2349 },
    {   0.7237,   0.2593 },
    {   0.7209,   0.2836 },
    {   0.7181,   0.3079 },
    {   0.7153,   0.3323 },
    {   0.7126,   0.3563 },
    {   0.7098,   0.3806 },
    {   0.7070,   0.4050 },
    {   0.7042,   0.4293 },
    {   0.7014,   0.4536 },
    {   0.6986,   0.4776 },
    {   0.6958,   0.5020 },
    {   0.6930,   0.5263 },
    {   0.6902,   0.5506 },
    {   0.6874,   0.5750 },
    {   0.6847,   0.5990 },
    {   0.6819,   0.6233 },
    {   0.6791,   0.6477 },
    {   0.6763,   0.6720 },
    {   0.6735,   0.6963 },
    {   0.6707,   0.7204 },
    {   0.6679,   0.7447 },
    {   0.6651,   0.7690 },
    {   0.6623,   0.7934 },
    {   0.6596,   0.8177 },
    {   0.6568,   0.8417 },
    {   0.6540,   0.8660 },
    {   0.6512,   0.8904 },
    {   0.6484,   0.9147 },
    {   0.6456,   0.9390 },
    {   0.6429,   0.9631 },
    {   0.6401,   0.9874 },
    {   0.6373,   1.0117 },
    {   0.7674,   0.0923 },
    {   0.7647,   0.1164 },
    {   0.7619,   0.1407 },
    {   0.7591,   0.1650 },
    {   0.7563,   0.1894 },
    {   0.7535,   0.2137 },
    {   0.7507,   0.2377 },
    {   0.7479,   0.2620 },
    {   0.7452,   0.2864 },
    {   0.7424,   0.3107 },
    {   0.7396,   0.3351 },
    {   0.7368,   0.3591 },
    {   0.7340,   0.3834 },
    {   0.7312,   0.4077 },
    {   0.7284,   0.4321 },
    {   0.7256,   0.4564 },
    {   0.7229,   0.4804 },
    {   0.7201,   0.5048 },
    {   0.7173,   0.5291 },
    {   0.7145,   0.5534 },
    {   0.7117,   0.5778 },
    {   0.7089,   0.6018 },
    {   0.7061,   0.6261 },
    {   0.7033,   0.6505 },
    {   0.7005,   0.6748 },
    {   0.6977,   0.6991 },
    {   0.6950,   0.7231 },
    {   0.6922,   0.7475 },
    {   0.6894,   0.7718 },
    {   0.6866,   0.7961 },
    {   0.6838,   0.8205 },
    {   0.6811,   0.8445 },
    {   0.6783,   0.8688 },
    {   0.6755,   0.8932 },
    {   0.6727,   0.9175 },
    {   0.6699,   0.9418 },
    {   0.6671,   0.9659 },
    {   0.6643,   0.9902 },
    {   0.6615,   1.0145 },
    {   0.7917,   0.0951 },
    {   0.7890,   0.1191 },
    {   0.7862,   0.1435 },
    {   0.7834,   0.1678 },
    {   0.7806,   0.1922 },
    {   0.7778,   0.2165 },
    {   0.7750,   0.2405 },
    {   0.7722,   0.2648 },
    {   0.7694,   0.2892 },
    {   0.7667,   0.3135 },
    {   0.7639,   0.3378 },
    {   0.7611,   0.3619 },
    {   0.7583,   0.3862 },
    {   0.7555,   0.4105 },
    {   0.7527,   0.4349 },
    {   0.7499,   0.4592 },
    {   0.7472,   0.4832 },
    {   0.7444,   0.5076 },
    {   0.7416,   0.5319 },
    {   0.7388,   0.5562 },
    {   0.7360,   0.5806 },
    {   0.7332,   0.6046 },
    {   0.7304,   0.6289 },
    {   0.7276,   0.6532 },
    {   0.7248,   0.6776 },
    {   0.7220,   0.7019 },
    {   0.7193,   0.7259 },
    {   0.7165,   0.7503 },
    {   0.7137,   0.7746 },
    {   0.7109,   0.7989 },
    {   0.7081,   0.8233 },
    {   0.7053,   0.8473 },
    {   0.7026,   0.8716 },
    {   0.6998,   0.8960 },
    {   0.6970,   0.9203 },
    {   0.6942,   0.9446 },
    {   0.6914,   0.9686 },
    {   0.6886,   0.9930 },
    {   0.6858,   1.0173 },
    {   0.8160,   0.0979 },
    {   0.8132,   0.1219 },
    {   0.8104,   0.1463 },
    {   0.8076,   0.1706 },
    {   0.8048,   0.1949 },
    {   0.8021,   0.2193 },
    {   0.7993,   0.2433 },
    {   0.7965,   0.2676 },
    {   0.7937,   0.2920 },
    {   0.7909,   0.3163 },
    {   0.7881,   0.3406 },
    {   0.7854,   0.3646 },
    {   0.7826,   0.3890 },
    {   0.7798,   0.4133 },
    {   0.7770,   0.4377 },
    {   0.7742,   0.4620 },
    {   0.7714,   0.4860 },
    {   0.7686,   0.5103 },
    {   0.7658,   0.5347 },
    {   0.7630,   0.5590 },
    {   0.7602,   0.5833 },
    {   0.7575,   0.6074 },
    {   0.7547,   0.6317 },
    {   0.7519,   0.6560 },
    {   0.7491,   0.6804 },
    {   0.7463,   0.7047 },
    {   0.7435,   0.7287 },
    {   0.7407,   0.7531 },
    {   0.7380,   0.7774 },
    {   0.7352,   0.8017 },
    {   0.7324,   0.8261 },
    {   0.7296,   0.8501 },
    {   0.7268,   0.8744 },
    {   0.7240,   0.8987 },
    {   0.7212,   0.9231 },
    {   0.7184,   0.9474 },
    {   0.7157,   0.9714 },
    {   0.7129,   0.9958 },
    {   0.7101,   1.0201 },
    {   0.8402,   0.1007 },
    {   0.8375,   0.1247 },
    {   0.8347,   0.1491 },
    {   0.8319,   0.1734 },
    {   0.8291,   0.1977 },
    {   0.8263,   0.2221 },
    {   0.8236,   0.2461 },
    {   0.8208,   0.2704 },
    {   0.8180,   0.2947 },
    {   0.8152,   0.3191 },
    {   0.8124,   0.3434 },
    {   0.8096,   0.3674 },
    {   0.8068,   0.3918 },
    {   0.8040,   0.4161 },
    {   0.8012,   0.4404 },
    {   0.7984,   0.4648 },
    {   0.7957,   0.4888 },
    {   0.7929,   0.5131 },
    {   0.7901,   0.5375 },
    {   0.7873,   0.5618 },
    {   0.7845,   0.5861 },
    {   0.7817,   0.6101 },
    {   0.7789,   0.6345 },
    {   0.7761,   0.6588 },
    {   0.7733,   0.6831 },
    {   0.7706,   0.7075 },
    {   0.7678,   0.7315 },
    {   0.7650,   0.7558 },
    {   0.7622,   0.7802 },
    {   0.7594,   0.8045 },
    {   0.7566,   0.8288 },
    {   0.7539,   0.8529 },
    {   0.7511,   0.8772 },
    {   0.7483,   0.9015 },
    {   0.7455,   0.9259 },
    {   0.7427,   0.9502 },
    {   0.7399,   0.9742 },
    {   0.7371,   0.9986 },
    {   0.7343,   1.0229 },
    {   0.8645,   0.1035 },
    {   0.8618,   0.1275 },
    {   0.8590,   0.1518 },
    {   0.8562,   0.1762 },
    {   0.8534,   0.2005 },
    {   0.8506,   0.2248 },
    {   0.8478,   0.2489 },
    {   0.8451,   0.2732 },
    {   0.8423,   0.2975 },
    {   0.8395,   0.3219 },
    {   0.8367,   0.3462 },
    {   0.8339,   0.3702 },
    {   0.8311,   0.3946 },
    {   0.8283,   0.4189 },
    {   0.8255,   0.4432 },
    {   0.8227,   0.4676 },
    {   0.8200,   0.4916 },
    {   0.8172,   0.5159 },
    {   0.8144,   0.5402 },
    {   0.8116,   0.5646 },
    {   0.8088,   0.5889 },
    {   0.8060,   0.6129 },
    {   0.8032,   0.6373 },
    {   0.8004,   0.6616 },
    {   0.7976,   0.6859 },
    {   0.7948,   0.7103 },
    {   0.7921,   0.7343 },
    {   0.7893,   0.7586 },
    {   0.7865,   0.7830 },
    {   0.7837,   0.8073 },
    {   0.7809,   0.8316 },
    {   0.7782,   0.8556 },
    {   0.7754,   0.8800 },
    {   0.7726,   0.9043 },
    {   0.7698,   0.9287 },
    {   0.7670,   0.9530 },
    {   0.7642,   0.9770 },
    {   0.7614,   1.0013 },
    {   0.7586,   1.0257 },
    {   0.8888,   0.1063 },
    {   0.8860,   0.1303 },
    {   0.8832,   0.1546 },
    {   0.8805,   0.1790 },
    {   0.8777,   0.2033 },
    {   0.8749,   0.2276 },
    {   0.8721,   0.2517 },
    {   0.8693,   0.2760 },
    {   0.8665,   0.3003 },
    {   0.8637,   0.3247 },
    {   0.8609,   0.3490 },
    {   0.8582,   0.3730 },
    {   0.8554,   0.3973 },
    {   0.8526,   0.4217 },
    {   0.8498,   0.4460 },
    {   0.8470,   0.4703 },
    {   0.8442,   0.4944 },
    {   0.8414,   0.5187 },
    {   0.8386,   0.5430 },
    {   0.8358,   0.5674 },
    {   0.8330,   0.5917 },
    {   0.8303,   0.6157 },
    {   0.8275,   0.6401 },
    {   0.8247,   0.6644 },
    {   0.8219,   0.6887 },
    {   0.8191,   0.7131 },
    {   0.8163,   0.7371 },
    {   0.8136,   0.7614 },
    {   0.8108,   0.7857 },
    {   0.8080,   0.8101 },
    {   0.8052,   0.8344 },
    {   0.8024,   0.8584 },
    {   0.7996,   0.8828 },
    {   0.7968,   0.9071 },
    {   0.7940,   0.9314 },
    {   0.7912,   0.9558 },
    {   0.7885,   0.9798 },
    {   0.7857,   1.0041 },
    {   0.7829,   1.0285 },
    {   0.9131,   0.1091 },
    {   0.9103,   0.1331 },
    {   0.9075,   0.1574 },
    {   0.9047,   0.1818 },
    {   0.9020,   0.2061 },
    {   0.8992,   0.2304 },
    {   0.8964,   0.2544 },
    {   0.8936,   0.2788 },
    {   0.8908,   0.3031 },
    {   0.8880,   0.3274 },
    {   0.8852,   0.3518 },
    {   0.8825,   0.3758 },
    {   0.8797,   0.4001 },
    {   0.8769,   0.4245 },
    {   0.8741,   0.4488 },
    {   0.8713,   0.4731 },
    {   0.8685,   0.4972 },
    {   0.8657,   0.5215 },
    {   0.8629,   0.5458 },
    {   0.8601,   0.5702 },
    {   0.8573,   0.5945 },
    {   0.8546,   0.6185 },
    {   0.8518,   0.6428 },
    {   0.8490,   0.6672 },
    {   0.8462,   0.6915 },
    {   0.8434,   0.7159 },
    {   0.8406,   0.7399 },
    {   0.8378,   0.7642 },
    {   0.8351,   0.7885 },
    {   0.8323,   0.8129 },
    {   0.8295,   0.8372 },
    {   0.8267,   0.8612 },
    {   0.8239,   0.8856 },
    {   0.8211,   0.9099 },
    {   0.8183,   0.9342 },
    {   0.8155,   0.9586 },
    {   0.8128,   0.9826 },
    {   0.8100,   1.0069 },
    {   0.8072,   1.0313 },
    {   0.9373,   0.1119 },
    {   0.9346,   0.1359 },
    {   0.9318,   0.1602 },
    {   0.9290,   0.1845 },
    {   0.9262,   0.2089 },
    {   0.9234,   0.2332 },
    {   0.9207,   0.2572 },
    {   0.9179,   0.2816 },
    {   0.9151,   0.3059 },
    {   0.9123,   0.3302 },
    {   0.9095,   0.3546 },
    {   0.9067,   0.3786 },
    {   0.9039,   0.4029 },
    {   0.9011,   0.4273 },
    {   0.8983,   0.4516 },
    {   0.8955,   0.4759 },
    {   0.8928,   0.4999 },
    {   0.8900,   0.5243 },
    {   0.8872,   0.5486 },
    {   0.8844,   0.5729 },
    {   0.8816,   0.5973 },
    {   0.8788,   0.6213 },
    {   0.8760,   0.6456 },
    {   0.8732,   0.6700 },
    {   0.8705,   0.6943 },
    {   0.8677,   0.7186 },
    {   0.8649,   0.7427 },
    {   0.8621,   0.7670 },
    {   0.8593,   0.7913 },
    {   0.8565,   0.8157 },
    {   0.8537,   0.8400 },
    {   0.8510,   0.8640 },
    {   0.8482,   0.8883 },
    {   0.8454,   0.9127 },
    {   0.8426,   0.9370 },
    {   0.8398,   0.9614 },
    {   0.8370,   0.9854 },
    {   0.8342,   1.0097 },
    {   0.8314,   1.0340 },
    {   0.9616,   0.1146 },
    {   0.9588,   0.1387 },
    {   0.9561,   0.1630 },
    {   0.9533,   0.1873 },
    {   0.9505,   0.2117 },
    {   0.9477,   0.2360 },
    {   0.9449,   0.2600 },
    {   0.9421,   0.2844 },
    {   0.9393,   0.3087 },
    {   0.9365,   0.3330 },
    {   0.9337,   0.3574 },
    {   0.9310,   0.3814 },
    {   0.9282,   0.4057 },
    {   0.9254,   0.4300 },
    {   0.9226,   0.4544 },
    {   0.9198,   0.4787 },
    {   0.9170,   0.5027 },
    {   0.9142,   0.5271 },
    {   0.9114,   0.5514 },
    {   0.9086,   0.5757 },
    {   0.9058,   0.6001 },
    {   0.9031,   0.6241 },
    {   0.9003,   0.6484 },
    {   0.8975,   0.6728 },
    {   0.8947,   0.6971 },
    {   0.8919,   0.7214 },
    {   0.8892,   0.7454 },
    {   0.8864,   0.7698 },
    {   0.8836,   0.7941 },
    {   0.8808,   0.8184 },
    {   0.8780,   0.8428 },
    {   0.8752,   0.8668 },
    {   0.8724,   0.8911 },
    {   0.8696,   0.9155 },
    {   0.8668,   0.9398 },
    {   0.8640,   0.9641 },
    {   0.8613,   0.9882 },
    {   0.8585,   1.0125 },
    {   0.8557,   1.0368 },
    {   0.9831,   0.1414 },
    {   0.9803,   0.1658 },
    {   0.9776,   0.1901 },
    {   0.9748,   0.2145 },
    {   0.9720,   0.2388 },
    {   0.9692,   0.2628 },
    {   0.9664,   0.2871 },
    {   0.9636,   0.3115 },
    {   0.9608,   0.3358 },
    {   0.9580,   0.3601 },
    {   0.9553,   0.3842 },
    {   0.9525,   0.4085 },
    {   0.9497,   0.4328 },
    {   0.9469,   0.4572 },
    {   0.9441,   0.4815 },
    {   0.9413,   0.5055 },
    {   0.9385,   0.5299 },
    {   0.9357,   0.5542 },
    {   0.9329,   0.5785 },
    {   0.9301,   0.6029 },
    {   0.9274,   0.6269 },
    {   0.9246,   0.6512 },
    {   0.9218,   0.6755 },
    {   0.9190,   0.6999 },
    {   0.9162,   0.7242 },
    {   0.9134,   0.7482 },
    {   0.9107,   0.7726 },
    {   0.9079,   0.7969 },
    {   0.9051,   0.8212 },
    {   0.9023,   0.8456 },
    {   0.8995,   0.8696 },
    {   0.8967,   0.8939 },
    {   0.8939,   0.9183 },
    {   0.8911,   0.9426 },
    {   0.8883,   0.9669 },
    {   0.8856,   0.9909 },
    {   0.8828,   1.0153 },
    {   0.8800,   1.0396 },
    {   0.8772,   1.0639 },
    {   1.0074,   0.1442 },
    {   1.0046,   0.1686 },
    {   1.0018,   0.1929 },
    {   0.9990,   0.2172 },
    {   0.9962,   0.2416 },
    {   0.9935,   0.2656 },
    {   0.9907,   0.2899 },
    {   0.9879,   0.3143 },
    {   0.9851,   0.3386 },
    {   0.9823,   0.3629 },
    {   0.9795,   0.3869 },
    {   0.9767,   0.4113 },
    {   0.9739,   0.4356 },
    {   0.9711,   0.4600 },
    {   0.9683,   0.4843 },
    {   0.9656,   0.5083 },
    {   0.9628,   0.5326 },
    {   0.9600,   0.5570 },
    {   0.9572,   0.5813 },
    {   0.9544,   0.6056 },
    {   0.9516,   0.6297 },
    {   0.9488,   0.6540 },
    {   0.9461,   0.6783 },
    {   0.9433,   0.7027 },
    {   0.9405,   0.7270 },
    {   0.9377,   0.7510 },
    {   0.9349,   0.7754 },
    {   0.9321,   0.7997 },
    {   0.9293,   0.8240 },
    {   0.9265,   0.8484 },
    {   0.9238,   0.8724 },
    {   0.9210,   0.8967 },
    {   0.9182,   0.9210 },
    {   0.9154,   0.9454 },
    {   0.9126,   0.9697 },
    {   0.9098,   0.9937 },
    {   0.9070,   1.0181 },
    {   0.9042,   1.0424 },
    {   0.9014,   1.0667 },
#endif /* ]  */

	{   0.0871,   0.0171 },
	{   0.0844,   0.0411 },
	{   0.0816,   0.0654 },
	{   0.0788,   0.0898 },
	{   0.0760,   0.1141 },
	{   0.0732,   0.1384 },
	{   0.0704,   0.1624 },
	{   0.0676,   0.1868 },
	{   0.0648,   0.2111 },
	{   0.0620,   0.2354 },
	{   0.0592,   0.2598 },
	{   0.0565,   0.2838 },
	{   0.0537,   0.3081 },
	{   0.0509,   0.3325 },
	{   0.0481,   0.3568 },
	{   0.0453,   0.3811 },
	{   0.0425,   0.4052 },
	{   0.0397,   0.4295 },
	{   0.0369,   0.4538 },
	{   0.0341,   0.4782 },
	{   0.0314,   0.5025 },
	{   0.0286,   0.5265 },
	{   0.0258,   0.5508 },
	{   0.0230,   0.5752 },
	{   0.0202,   0.5995 },
	{   0.0174,   0.6239 },
	{   0.0147,   0.6479 },
	{   0.0119,   0.6722 },
	{   0.0091,   0.6965 },
	{   0.0063,   0.7209 },
	{   0.0035,   0.7452 },
	{   0.0007,   0.7692 },
	{  -0.0021,   0.7936 },
	{  -0.0049,   0.8179 },
	{  -0.0077,   0.8422 },
	{  -0.0105,   0.8666 },
	{  -0.0132,   0.8906 },
	{  -0.0160,   0.9149 },
	{  -0.0188,   0.9393 },
	{   0.1114,   0.0199 },
	{   0.1086,   0.0439 },
	{   0.1059,   0.0682 },
	{   0.1031,   0.0925 },
	{   0.1003,   0.1169 },
	{   0.0975,   0.1412 },
	{   0.0947,   0.1652 },
	{   0.0919,   0.1896 },
	{   0.0891,   0.2139 },
	{   0.0863,   0.2382 },
	{   0.0835,   0.2626 },
	{   0.0808,   0.2866 },
	{   0.0780,   0.3109 },
	{   0.0752,   0.3353 },
	{   0.0724,   0.3596 },
	{   0.0696,   0.3839 },
	{   0.0668,   0.4079 },
	{   0.0640,   0.4323 },
	{   0.0612,   0.4566 },
	{   0.0584,   0.4810 },
	{   0.0556,   0.5053 },
	{   0.0529,   0.5293 },
	{   0.0501,   0.5536 },
	{   0.0473,   0.5780 },
	{   0.0445,   0.6023 },
	{   0.0417,   0.6266 },
	{   0.0390,   0.6507 },
	{   0.0362,   0.6750 },
	{   0.0334,   0.6993 },
	{   0.0306,   0.7237 },
	{   0.0278,   0.7480 },
	{   0.0250,   0.7720 },
	{   0.0222,   0.7964 },
	{   0.0194,   0.8207 },
	{   0.0166,   0.8450 },
	{   0.0138,   0.8694 },
	{   0.0111,   0.8934 },
	{   0.0083,   0.9177 },
	{   0.0055,   0.9420 },
	{   0.1357,   0.0226 },
	{   0.1329,   0.0467 },
	{   0.1301,   0.0710 },
	{   0.1273,   0.0953 },
	{   0.1245,   0.1197 },
	{   0.1217,   0.1440 },
	{   0.1190,   0.1680 },
	{   0.1162,   0.1924 },
	{   0.1134,   0.2167 },
	{   0.1106,   0.2410 },
	{   0.1078,   0.2654 },
	{   0.1050,   0.2894 },
	{   0.1022,   0.3137 },
	{   0.0994,   0.3380 },
	{   0.0966,   0.3624 },
	{   0.0938,   0.3867 },
	{   0.0911,   0.4107 },
	{   0.0883,   0.4351 },
	{   0.0855,   0.4594 },
	{   0.0827,   0.4837 },
	{   0.0799,   0.5081 },
	{   0.0771,   0.5321 },
	{   0.0744,   0.5564 },
	{   0.0716,   0.5808 },
	{   0.0688,   0.6051 },
	{   0.0660,   0.6294 },
	{   0.0632,   0.6534 },
	{   0.0604,   0.6778 },
	{   0.0576,   0.7021 },
	{   0.0548,   0.7265 },
	{   0.0520,   0.7508 },
	{   0.0493,   0.7748 },
	{   0.0465,   0.7991 },
	{   0.0437,   0.8235 },
	{   0.0409,   0.8478 },
	{   0.0381,   0.8721 },
	{   0.0353,   0.8962 },
	{   0.0325,   0.9205 },
	{   0.0297,   0.9448 },
	{   0.1600,   0.0254 },
	{   0.1572,   0.0495 },
	{   0.1544,   0.0738 },
	{   0.1516,   0.0981 },
	{   0.1488,   0.1225 },
	{   0.1460,   0.1468 },
	{   0.1433,   0.1708 },
	{   0.1405,   0.1951 },
	{   0.1377,   0.2195 },
	{   0.1349,   0.2438 },
	{   0.1321,   0.2681 },
	{   0.1293,   0.2922 },
	{   0.1265,   0.3165 },
	{   0.1237,   0.3408 },
	{   0.1209,   0.3652 },
	{   0.1181,   0.3895 },
	{   0.1154,   0.4135 },
	{   0.1126,   0.4379 },
	{   0.1098,   0.4622 },
	{   0.1070,   0.4865 },
	{   0.1042,   0.5109 },
	{   0.1014,   0.5349 },
	{   0.0986,   0.5592 },
	{   0.0959,   0.5835 },
	{   0.0931,   0.6079 },
	{   0.0903,   0.6322 },
	{   0.0875,   0.6562 },
	{   0.0847,   0.6806 },
	{   0.0819,   0.7049 },
	{   0.0791,   0.7292 },
	{   0.0763,   0.7536 },
	{   0.0736,   0.7776 },
	{   0.0708,   0.8019 },
	{   0.0680,   0.8263 },
	{   0.0652,   0.8506 },
	{   0.0624,   0.8749 },
	{   0.0596,   0.8990 },
	{   0.0568,   0.9233 },
	{   0.0540,   0.9476 },
	{   0.1842,   0.0282 },
	{   0.1815,   0.0522 },
	{   0.1787,   0.0766 },
	{   0.1759,   0.1009 },
	{   0.1731,   0.1252 },
	{   0.1703,   0.1496 },
	{   0.1675,   0.1736 },
	{   0.1647,   0.1979 },
	{   0.1619,   0.2223 },
	{   0.1591,   0.2466 },
	{   0.1563,   0.2709 },
	{   0.1536,   0.2950 },
	{   0.1508,   0.3193 },
	{   0.1480,   0.3436 },
	{   0.1452,   0.3680 },
	{   0.1424,   0.3923 },
	{   0.1396,   0.4163 },
	{   0.1368,   0.4406 },
	{   0.1340,   0.4650 },
	{   0.1313,   0.4893 },
	{   0.1285,   0.5136 },
	{   0.1257,   0.5377 },
	{   0.1229,   0.5620 },
	{   0.1201,   0.5863 },
	{   0.1173,   0.6107 },
	{   0.1145,   0.6350 },
	{   0.1118,   0.6590 },
	{   0.1090,   0.6834 },
	{   0.1062,   0.7077 },
	{   0.1034,   0.7320 },
	{   0.1006,   0.7564 },
	{   0.0978,   0.7804 },
	{   0.0950,   0.8047 },
	{   0.0922,   0.8290 },
	{   0.0894,   0.8534 },
	{   0.0866,   0.8777 },
	{   0.0839,   0.9017 },
	{   0.0811,   0.9261 },
	{   0.0783,   0.9504 },
	{   0.2085,   0.0310 },
	{   0.2057,   0.0550 },
	{   0.2029,   0.0794 },
	{   0.2001,   0.1037 },
	{   0.1973,   0.1280 },
	{   0.1945,   0.1524 },
	{   0.1918,   0.1764 },
	{   0.1890,   0.2007 },
	{   0.1862,   0.2251 },
	{   0.1834,   0.2494 },
	{   0.1806,   0.2737 },
	{   0.1778,   0.2977 },
	{   0.1750,   0.3221 },
	{   0.1722,   0.3464 },
	{   0.1694,   0.3707 },
	{   0.1666,   0.3951 },
	{   0.1639,   0.4191 },
	{   0.1611,   0.4434 },
	{   0.1583,   0.4678 },
	{   0.1555,   0.4921 },
	{   0.1527,   0.5164 },
	{   0.1500,   0.5405 },
	{   0.1472,   0.5648 },
	{   0.1444,   0.5891 },
	{   0.1416,   0.6135 },
	{   0.1388,   0.6378 },
	{   0.1360,   0.6618 },
	{   0.1332,   0.6861 },
	{   0.1304,   0.7105 },
	{   0.1276,   0.7348 },
	{   0.1248,   0.7591 },
	{   0.1221,   0.7832 },
	{   0.1193,   0.8075 },
	{   0.1165,   0.8318 },
	{   0.1137,   0.8562 },
	{   0.1109,   0.8805 },
	{   0.1081,   0.9045 },
	{   0.1053,   0.9289 },
	{   0.1025,   0.9532 },
	{   0.2328,   0.0338 },
	{   0.2300,   0.0578 },
	{   0.2272,   0.0822 },
	{   0.2244,   0.1065 },
	{   0.2216,   0.1308 },
	{   0.2188,   0.1552 },
	{   0.2161,   0.1792 },
	{   0.2133,   0.2035 },
	{   0.2105,   0.2278 },
	{   0.2077,   0.2522 },
	{   0.2049,   0.2765 },
	{   0.2021,   0.3005 },
	{   0.1993,   0.3249 },
	{   0.1965,   0.3492 },
	{   0.1937,   0.3735 },
	{   0.1909,   0.3979 },
	{   0.1882,   0.4219 },
	{   0.1854,   0.4462 },
	{   0.1826,   0.4706 },
	{   0.1798,   0.4949 },
	{   0.1770,   0.5192 },
	{   0.1742,   0.5432 },
	{   0.1715,   0.5676 },
	{   0.1687,   0.5919 },
	{   0.1659,   0.6162 },
	{   0.1631,   0.6406 },
	{   0.1603,   0.6646 },
	{   0.1575,   0.6889 },
	{   0.1547,   0.7133 },
	{   0.1519,   0.7376 },
	{   0.1491,   0.7619 },
	{   0.1464,   0.7860 },
	{   0.1436,   0.8103 },
	{   0.1408,   0.8346 },
	{   0.1380,   0.8590 },
	{   0.1352,   0.8833 },
	{   0.1324,   0.9073 },
	{   0.1296,   0.9316 },
	{   0.1268,   0.9560 },
	{   0.2570,   0.0366 },
	{   0.2543,   0.0606 },
	{   0.2515,   0.0849 },
	{   0.2487,   0.1093 },
	{   0.2459,   0.1336 },
	{   0.2431,   0.1579 },
	{   0.2403,   0.1820 },
	{   0.2375,   0.2063 },
	{   0.2347,   0.2306 },
	{   0.2319,   0.2550 },
	{   0.2291,   0.2793 },
	{   0.2264,   0.3033 },
	{   0.2236,   0.3277 },
	{   0.2208,   0.3520 },
	{   0.2180,   0.3763 },
	{   0.2152,   0.4007 },
	{   0.2124,   0.4247 },
	{   0.2096,   0.4490 },
	{   0.2069,   0.4733 },
	{   0.2041,   0.4977 },
	{   0.2013,   0.5220 },
	{   0.1985,   0.5460 },
	{   0.1957,   0.5704 },
	{   0.1929,   0.5947 },
	{   0.1901,   0.6190 },
	{   0.1873,   0.6434 },
	{   0.1846,   0.6674 },
	{   0.1818,   0.6917 },
	{   0.1790,   0.7161 },
	{   0.1762,   0.7404 },
	{   0.1734,   0.7647 },
	{   0.1706,   0.7887 },
	{   0.1678,   0.8131 },
	{   0.1650,   0.8374 },
	{   0.1622,   0.8617 },
	{   0.1594,   0.8861 },
	{   0.1567,   0.9101 },
	{   0.1539,   0.9344 },
	{   0.1511,   0.9588 },
	{   0.2813,   0.0394 },
	{   0.2786,   0.0634 },
	{   0.2758,   0.0877 },
	{   0.2730,   0.1121 },
	{   0.2702,   0.1364 },
	{   0.2674,   0.1607 },
	{   0.2646,   0.1848 },
	{   0.2618,   0.2091 },
	{   0.2590,   0.2334 },
	{   0.2562,   0.2578 },
	{   0.2534,   0.2821 },
	{   0.2507,   0.3061 },
	{   0.2479,   0.3304 },
	{   0.2451,   0.3548 },
	{   0.2423,   0.3791 },
	{   0.2395,   0.4034 },
	{   0.2367,   0.4275 },
	{   0.2339,   0.4518 },
	{   0.2311,   0.4761 },
	{   0.2284,   0.5005 },
	{   0.2256,   0.5248 },
	{   0.2228,   0.5488 },
	{   0.2200,   0.5732 },
	{   0.2172,   0.5975 },
	{   0.2144,   0.6218 },
	{   0.2116,   0.6462 },
	{   0.2089,   0.6702 },
	{   0.2061,   0.6945 },
	{   0.2033,   0.7188 },
	{   0.2005,   0.7432 },
	{   0.1977,   0.7675 },
	{   0.1949,   0.7915 },
	{   0.1921,   0.8159 },
	{   0.1893,   0.8402 },
	{   0.1865,   0.8645 },
	{   0.1837,   0.8889 },
	{   0.1810,   0.9129 },
	{   0.1782,   0.9372 },
	{   0.1754,   0.9616 },
	{   0.3056,   0.0422 },
	{   0.3028,   0.0662 },
	{   0.3000,   0.0905 },
	{   0.2972,   0.1148 },
	{   0.2944,   0.1392 },
	{   0.2916,   0.1635 },
	{   0.2889,   0.1875 },
	{   0.2861,   0.2119 },
	{   0.2833,   0.2362 },
	{   0.2805,   0.2605 },
	{   0.2777,   0.2849 },
	{   0.2749,   0.3089 },
	{   0.2721,   0.3332 },
	{   0.2693,   0.3576 },
	{   0.2665,   0.3819 },
	{   0.2638,   0.4062 },
	{   0.2610,   0.4302 },
	{   0.2582,   0.4546 },
	{   0.2554,   0.4789 },
	{   0.2526,   0.5033 },
	{   0.2498,   0.5276 },
	{   0.2471,   0.5516 },
	{   0.2443,   0.5759 },
	{   0.2415,   0.6003 },
	{   0.2387,   0.6246 },
	{   0.2359,   0.6489 },
	{   0.2331,   0.6730 },
	{   0.2303,   0.6973 },
	{   0.2275,   0.7216 },
	{   0.2247,   0.7460 },
	{   0.2219,   0.7703 },
	{   0.2192,   0.7943 },
	{   0.2164,   0.8187 },
	{   0.2136,   0.8430 },
	{   0.2108,   0.8673 },
	{   0.2080,   0.8917 },
	{   0.2052,   0.9157 },
	{   0.2024,   0.9400 },
	{   0.1996,   0.9643 },
	{   0.3298,   0.0449 },
	{   0.3271,   0.0690 },
	{   0.3243,   0.0933 },
	{   0.3215,   0.1176 },
	{   0.3187,   0.1420 },
	{   0.3159,   0.1663 },
	{   0.3131,   0.1903 },
	{   0.3103,   0.2147 },
	{   0.3075,   0.2390 },
	{   0.3047,   0.2633 },
	{   0.3019,   0.2877 },
	{   0.2992,   0.3117 },
	{   0.2964,   0.3360 },
	{   0.2936,   0.3603 },
	{   0.2908,   0.3847 },
	{   0.2880,   0.4090 },
	{   0.2852,   0.4330 },
	{   0.2825,   0.4574 },
	{   0.2797,   0.4817 },
	{   0.2769,   0.5060 },
	{   0.2741,   0.5304 },
	{   0.2713,   0.5544 },
	{   0.2685,   0.5787 },
	{   0.2657,   0.6031 },
	{   0.2629,   0.6274 },
	{   0.2601,   0.6517 },
	{   0.2574,   0.6757 },
	{   0.2546,   0.7001 },
	{   0.2518,   0.7244 },
	{   0.2490,   0.7488 },
	{   0.2462,   0.7731 },
	{   0.2434,   0.7971 },
	{   0.2406,   0.8214 },
	{   0.2378,   0.8458 },
	{   0.2350,   0.8701 },
	{   0.2323,   0.8944 },
	{   0.2295,   0.9185 },
	{   0.2267,   0.9428 },
	{   0.2239,   0.9671 },
	{   0.3541,   0.0477 },
	{   0.3514,   0.0718 },
	{   0.3486,   0.0961 },
	{   0.3458,   0.1204 },
	{   0.3430,   0.1448 },
	{   0.3402,   0.1691 },
	{   0.3374,   0.1931 },
	{   0.3346,   0.2174 },
	{   0.3318,   0.2418 },
	{   0.3290,   0.2661 },
	{   0.3262,   0.2905 },
	{   0.3235,   0.3145 },
	{   0.3207,   0.3388 },
	{   0.3179,   0.3631 },
	{   0.3151,   0.3875 },
	{   0.3123,   0.4118 },
	{   0.3095,   0.4358 },
	{   0.3067,   0.4602 },
	{   0.3040,   0.4845 },
	{   0.3012,   0.5088 },
	{   0.2984,   0.5332 },
	{   0.2956,   0.5572 },
	{   0.2928,   0.5815 },
	{   0.2900,   0.6059 },
	{   0.2872,   0.6302 },
	{   0.2844,   0.6545 },
	{   0.2817,   0.6785 },
	{   0.2789,   0.7029 },
	{   0.2761,   0.7272 },
	{   0.2733,   0.7515 },
	{   0.2705,   0.7759 },
	{   0.2677,   0.7999 },
	{   0.2649,   0.8242 },
	{   0.2621,   0.8486 },
	{   0.2593,   0.8729 },
	{   0.2565,   0.8972 },
	{   0.2538,   0.9213 },
	{   0.2510,   0.9456 },
	{   0.2482,   0.9699 },
	{   0.3784,   0.0505 },
	{   0.3756,   0.0745 },
	{   0.3728,   0.0989 },
	{   0.3700,   0.1232 },
	{   0.3672,   0.1475 },
	{   0.3644,   0.1719 },
	{   0.3617,   0.1959 },
	{   0.3589,   0.2202 },
	{   0.3561,   0.2446 },
	{   0.3533,   0.2689 },
	{   0.3505,   0.2932 },
	{   0.3477,   0.3173 },
	{   0.3449,   0.3416 },
	{   0.3421,   0.3659 },
	{   0.3394,   0.3903 },
	{   0.3366,   0.4146 },
	{   0.3338,   0.4386 },
	{   0.3310,   0.4629 },
	{   0.3282,   0.4873 },
	{   0.3254,   0.5116 },
	{   0.3226,   0.5359 },
	{   0.3199,   0.5600 },
	{   0.3171,   0.5843 },
	{   0.3143,   0.6086 },
	{   0.3115,   0.6330 },
	{   0.3087,   0.6573 },
	{   0.3059,   0.6813 },
	{   0.3031,   0.7057 },
	{   0.3003,   0.7300 },
	{   0.2975,   0.7543 },
	{   0.2947,   0.7787 },
	{   0.2920,   0.8027 },
	{   0.2892,   0.8270 },
	{   0.2864,   0.8513 },
	{   0.2836,   0.8757 },
	{   0.2808,   0.9000 },
	{   0.2780,   0.9240 },
	{   0.2752,   0.9484 },
	{   0.2725,   0.9727 },
	{   0.4027,   0.0533 },
	{   0.3999,   0.0773 },
	{   0.3971,   0.1017 },
	{   0.3943,   0.1260 },
	{   0.3915,   0.1503 },
	{   0.3887,   0.1747 },
	{   0.3860,   0.1987 },
	{   0.3832,   0.2230 },
	{   0.3804,   0.2474 },
	{   0.3776,   0.2717 },
	{   0.3748,   0.2960 },
	{   0.3720,   0.3200 },
	{   0.3692,   0.3444 },
	{   0.3664,   0.3687 },
	{   0.3636,   0.3930 },
	{   0.3609,   0.4174 },
	{   0.3581,   0.4414 },
	{   0.3553,   0.4657 },
	{   0.3525,   0.4901 },
	{   0.3497,   0.5144 },
	{   0.3469,   0.5387 },
	{   0.3442,   0.5628 },
	{   0.3414,   0.5871 },
	{   0.3386,   0.6114 },
	{   0.3358,   0.6358 },
	{   0.3330,   0.6601 },
	{   0.3302,   0.6841 },
	{   0.3274,   0.7084 },
	{   0.3246,   0.7328 },
	{   0.3218,   0.7571 },
	{   0.3190,   0.7815 },
	{   0.3163,   0.8055 },
	{   0.3135,   0.8298 },
	{   0.3107,   0.8541 },
	{   0.3079,   0.8785 },
	{   0.3051,   0.9028 },
	{   0.3023,   0.9268 },
	{   0.2995,   0.9512 },
	{   0.2967,   0.9755 },
	{   0.4269,   0.0561 },
	{   0.4242,   0.0801 },
	{   0.4214,   0.1045 },
	{   0.4186,   0.1288 },
	{   0.4158,   0.1531 },
	{   0.4130,   0.1775 },
	{   0.4102,   0.2015 },
	{   0.4074,   0.2258 },
	{   0.4046,   0.2501 },
	{   0.4018,   0.2745 },
	{   0.3990,   0.2988 },
	{   0.3963,   0.3228 },
	{   0.3935,   0.3472 },
	{   0.3907,   0.3715 },
	{   0.3879,   0.3958 },
	{   0.3851,   0.4202 },
	{   0.3823,   0.4442 },
	{   0.3796,   0.4685 },
	{   0.3768,   0.4929 },
	{   0.3740,   0.5172 },
	{   0.3712,   0.5415 },
	{   0.3684,   0.5655 },
	{   0.3656,   0.5899 },
	{   0.3628,   0.6142 },
	{   0.3600,   0.6385 },
	{   0.3572,   0.6629 },
	{   0.3545,   0.6869 },
	{   0.3517,   0.7112 },
	{   0.3489,   0.7356 },
	{   0.3461,   0.7599 },
	{   0.3433,   0.7842 },
	{   0.3405,   0.8083 },
	{   0.3377,   0.8326 },
	{   0.3349,   0.8569 },
	{   0.3321,   0.8813 },
	{   0.3294,   0.9056 },
	{   0.3266,   0.9296 },
	{   0.3238,   0.9539 },
	{   0.3210,   0.9783 },
	{   0.4512,   0.0589 },
	{   0.4484,   0.0829 },
	{   0.4456,   0.1072 },
	{   0.4428,   0.1316 },
	{   0.4400,   0.1559 },
	{   0.4372,   0.1802 },
	{   0.4345,   0.2043 },
	{   0.4317,   0.2286 },
	{   0.4289,   0.2529 },
	{   0.4261,   0.2773 },
	{   0.4233,   0.3016 },
	{   0.4205,   0.3256 },
	{   0.4177,   0.3500 },
	{   0.4150,   0.3743 },
	{   0.4122,   0.3986 },
	{   0.4094,   0.4230 },
	{   0.4066,   0.4470 },
	{   0.4038,   0.4713 },
	{   0.4010,   0.4956 },
	{   0.3982,   0.5200 },
	{   0.3954,   0.5443 },
	{   0.3927,   0.5683 },
	{   0.3899,   0.5927 },
	{   0.3871,   0.6170 },
	{   0.3843,   0.6413 },
	{   0.3815,   0.6657 },
	{   0.3787,   0.6897 },
	{   0.3759,   0.7140 },
	{   0.3731,   0.7384 },
	{   0.3703,   0.7627 },
	{   0.3675,   0.7870 },
	{   0.3648,   0.8110 },
	{   0.3620,   0.8354 },
	{   0.3592,   0.8597 },
	{   0.3564,   0.8840 },
	{   0.3536,   0.9084 },
	{   0.3508,   0.9324 },
	{   0.3481,   0.9567 },
	{   0.3453,   0.9811 },
	{   0.4755,   0.0617 },
	{   0.4727,   0.0857 },
	{   0.4699,   0.1100 },
	{   0.4671,   0.1344 },
	{   0.4643,   0.1587 },
	{   0.4615,   0.1830 },
	{   0.4588,   0.2071 },
	{   0.4560,   0.2314 },
	{   0.4532,   0.2557 },
	{   0.4504,   0.2801 },
	{   0.4476,   0.3044 },
	{   0.4448,   0.3284 },
	{   0.4420,   0.3527 },
	{   0.4392,   0.3771 },
	{   0.4365,   0.4014 },
	{   0.4337,   0.4257 },
	{   0.4309,   0.4498 },
	{   0.4281,   0.4741 },
	{   0.4253,   0.4984 },
	{   0.4225,   0.5228 },
	{   0.4197,   0.5471 },
	{   0.4170,   0.5711 },
	{   0.4142,   0.5955 },
	{   0.4114,   0.6198 },
	{   0.4086,   0.6441 },
	{   0.4058,   0.6685 },
	{   0.4030,   0.6925 },
	{   0.4002,   0.7168 },
	{   0.3974,   0.7411 },
	{   0.3946,   0.7655 },
	{   0.3918,   0.7898 },
	{   0.3891,   0.8138 },
	{   0.3863,   0.8382 },
	{   0.3835,   0.8625 },
	{   0.3807,   0.8868 },
	{   0.3779,   0.9112 },
	{   0.3751,   0.9352 },
	{   0.3723,   0.9595 },
	{   0.3696,   0.9839 },
	{   0.4997,   0.0645 },
	{   0.4970,   0.0885 },
	{   0.4942,   0.1128 },
	{   0.4914,   0.1371 },
	{   0.4886,   0.1615 },
	{   0.4858,   0.1858 },
	{   0.4830,   0.2098 },
	{   0.4802,   0.2342 },
	{   0.4774,   0.2585 },
	{   0.4746,   0.2828 },
	{   0.4719,   0.3072 },
	{   0.4691,   0.3312 },
	{   0.4663,   0.3555 },
	{   0.4635,   0.3799 },
	{   0.4607,   0.4042 },
	{   0.4579,   0.4285 },
	{   0.4552,   0.4526 },
	{   0.4524,   0.4769 },
	{   0.4496,   0.5012 },
	{   0.4468,   0.5256 },
	{   0.4440,   0.5499 },
	{   0.4412,   0.5739 },
	{   0.4384,   0.5982 },
	{   0.4356,   0.6226 },
	{   0.4328,   0.6469 },
	{   0.4300,   0.6712 },
	{   0.4273,   0.6953 },
	{   0.4245,   0.7196 },
	{   0.4217,   0.7439 },
	{   0.4189,   0.7683 },
	{   0.4161,   0.7926 },
	{   0.4133,   0.8166 },
	{   0.4105,   0.8410 },
	{   0.4077,   0.8653 },
	{   0.4050,   0.8896 },
	{   0.4022,   0.9140 },
	{   0.3994,   0.9380 },
	{   0.3966,   0.9623 },
	{   0.3938,   0.9866 },
	{   0.5240,   0.0673 },
	{   0.5213,   0.0913 },
	{   0.5185,   0.1156 },
	{   0.5157,   0.1399 },
	{   0.5129,   0.1643 },
	{   0.5101,   0.1886 },
	{   0.5073,   0.2126 },
	{   0.5045,   0.2370 },
	{   0.5017,   0.2613 },
	{   0.4989,   0.2856 },
	{   0.4961,   0.3100 },
	{   0.4934,   0.3340 },
	{   0.4906,   0.3583 },
	{   0.4878,   0.3827 },
	{   0.4850,   0.4070 },
	{   0.4822,   0.4313 },
	{   0.4794,   0.4553 },
	{   0.4767,   0.4797 },
	{   0.4739,   0.5040 },
	{   0.4711,   0.5283 },
	{   0.4683,   0.5527 },
	{   0.4655,   0.5767 },
	{   0.4627,   0.6010 },
	{   0.4599,   0.6254 },
	{   0.4571,   0.6497 },
	{   0.4543,   0.6740 },
	{   0.4516,   0.6981 },
	{   0.4488,   0.7224 },
	{   0.4460,   0.7467 },
	{   0.4432,   0.7711 },
	{   0.4404,   0.7954 },
	{   0.4376,   0.8194 },
	{   0.4348,   0.8437 },
	{   0.4320,   0.8681 },
	{   0.4292,   0.8924 },
	{   0.4265,   0.9167 },
	{   0.4237,   0.9408 },
	{   0.4209,   0.9651 },
	{   0.4181,   0.9894 },
	{   0.5483,   0.0700 },
	{   0.5455,   0.0941 },
	{   0.5427,   0.1184 },
	{   0.5399,   0.1427 },
	{   0.5371,   0.1671 },
	{   0.5343,   0.1914 },
	{   0.5316,   0.2154 },
	{   0.5288,   0.2397 },
	{   0.5260,   0.2641 },
	{   0.5232,   0.2884 },
	{   0.5204,   0.3128 },
	{   0.5176,   0.3368 },
	{   0.5148,   0.3611 },
	{   0.5121,   0.3854 },
	{   0.5093,   0.4098 },
	{   0.5065,   0.4341 },
	{   0.5037,   0.4581 },
	{   0.5009,   0.4825 },
	{   0.4981,   0.5068 },
	{   0.4953,   0.5311 },
	{   0.4925,   0.5555 },
	{   0.4898,   0.5795 },
	{   0.4870,   0.6038 },
	{   0.4842,   0.6282 },
	{   0.4814,   0.6525 },
	{   0.4786,   0.6768 },
	{   0.4758,   0.7008 },
	{   0.4730,   0.7252 },
	{   0.4702,   0.7495 },
	{   0.4674,   0.7738 },
	{   0.4646,   0.7982 },
	{   0.4619,   0.8222 },
	{   0.4591,   0.8465 },
	{   0.4563,   0.8709 },
	{   0.4535,   0.8952 },
	{   0.4507,   0.9195 },
	{   0.4479,   0.9436 },
	{   0.4452,   0.9679 },
	{   0.4424,   0.9922 },
	{   0.5725,   0.0728 },
	{   0.5698,   0.0968 },
	{   0.5670,   0.1212 },
	{   0.5642,   0.1455 },
	{   0.5614,   0.1698 },
	{   0.5586,   0.1942 },
	{   0.5558,   0.2182 },
	{   0.5530,   0.2425 },
	{   0.5502,   0.2669 },
	{   0.5475,   0.2912 },
	{   0.5447,   0.3155 },
	{   0.5419,   0.3396 },
	{   0.5391,   0.3639 },
	{   0.5363,   0.3882 },
	{   0.5335,   0.4126 },
	{   0.5307,   0.4369 },
	{   0.5280,   0.4609 },
	{   0.5252,   0.4852 },
	{   0.5224,   0.5096 },
	{   0.5196,   0.5339 },
	{   0.5168,   0.5583 },
	{   0.5140,   0.5823 },
	{   0.5112,   0.6066 },
	{   0.5084,   0.6309 },
	{   0.5056,   0.6553 },
	{   0.5028,   0.6796 },
	{   0.5001,   0.7036 },
	{   0.4973,   0.7280 },
	{   0.4945,   0.7523 },
	{   0.4917,   0.7766 },
	{   0.4889,   0.8010 },
	{   0.4861,   0.8250 },
	{   0.4833,   0.8493 },
	{   0.4806,   0.8737 },
	{   0.4778,   0.8980 },
	{   0.4750,   0.9223 },
	{   0.4722,   0.9463 },
	{   0.4694,   0.9707 },
	{   0.4666,   0.9950 },
	{   0.5968,   0.0756 },
	{   0.5941,   0.0996 },
	{   0.5913,   0.1240 },
	{   0.5885,   0.1483 },
	{   0.5857,   0.1726 },
	{   0.5829,   0.1970 },
	{   0.5801,   0.2210 },
	{   0.5773,   0.2453 },
	{   0.5745,   0.2697 },
	{   0.5717,   0.2940 },
	{   0.5690,   0.3183 },
	{   0.5662,   0.3423 },
	{   0.5634,   0.3667 },
	{   0.5606,   0.3910 },
	{   0.5578,   0.4153 },
	{   0.5550,   0.4397 },
	{   0.5523,   0.4637 },
	{   0.5495,   0.4880 },
	{   0.5467,   0.5124 },
	{   0.5439,   0.5367 },
	{   0.5411,   0.5610 },
	{   0.5383,   0.5851 },
	{   0.5355,   0.6094 },
	{   0.5327,   0.6337 },
	{   0.5299,   0.6581 },
	{   0.5271,   0.6824 },
	{   0.5244,   0.7064 },
	{   0.5216,   0.7308 },
	{   0.5188,   0.7551 },
	{   0.5160,   0.7794 },
	{   0.5132,   0.8038 },
	{   0.5104,   0.8278 },
	{   0.5076,   0.8521 },
	{   0.5048,   0.8764 },
	{   0.5021,   0.9008 },
	{   0.4993,   0.9251 },
	{   0.4965,   0.9491 },
	{   0.4937,   0.9735 },
	{   0.4909,   0.9978 },
	{   0.6211,   0.0784 },
	{   0.6183,   0.1024 },
	{   0.6155,   0.1268 },
	{   0.6127,   0.1511 },
	{   0.6099,   0.1754 },
	{   0.6071,   0.1998 },
	{   0.6044,   0.2238 },
	{   0.6016,   0.2481 },
	{   0.5988,   0.2724 },
	{   0.5960,   0.2968 },
	{   0.5932,   0.3211 },
	{   0.5904,   0.3451 },
	{   0.5877,   0.3695 },
	{   0.5849,   0.3938 },
	{   0.5821,   0.4181 },
	{   0.5793,   0.4425 },
	{   0.5765,   0.4665 },
	{   0.5737,   0.4908 },
	{   0.5709,   0.5152 },
	{   0.5681,   0.5395 },
	{   0.5653,   0.5638 },
	{   0.5626,   0.5878 },
	{   0.5598,   0.6122 },
	{   0.5570,   0.6365 },
	{   0.5542,   0.6608 },
	{   0.5514,   0.6852 },
	{   0.5486,   0.7092 },
	{   0.5458,   0.7335 },
	{   0.5430,   0.7579 },
	{   0.5402,   0.7822 },
	{   0.5375,   0.8065 },
	{   0.5347,   0.8306 },
	{   0.5319,   0.8549 },
	{   0.5291,   0.8792 },
	{   0.5263,   0.9036 },
	{   0.5235,   0.9279 },
	{   0.5208,   0.9519 },
	{   0.5180,   0.9762 },
	{   0.5152,   1.0006 },
	{   0.6454,   0.0812 },
	{   0.6426,   0.1052 },
	{   0.6398,   0.1295 },
	{   0.6370,   0.1539 },
	{   0.6342,   0.1782 },
	{   0.6314,   0.2025 },
	{   0.6287,   0.2266 },
	{   0.6259,   0.2509 },
	{   0.6231,   0.2752 },
	{   0.6203,   0.2996 },
	{   0.6175,   0.3239 },
	{   0.6147,   0.3479 },
	{   0.6119,   0.3723 },
	{   0.6092,   0.3966 },
	{   0.6064,   0.4209 },
	{   0.6036,   0.4453 },
	{   0.6008,   0.4693 },
	{   0.5980,   0.4936 },
	{   0.5952,   0.5179 },
	{   0.5924,   0.5423 },
	{   0.5896,   0.5666 },
	{   0.5869,   0.5906 },
	{   0.5841,   0.6150 },
	{   0.5813,   0.6393 },
	{   0.5785,   0.6636 },
	{   0.5757,   0.6880 },
	{   0.5729,   0.7120 },
	{   0.5701,   0.7363 },
	{   0.5673,   0.7607 },
	{   0.5645,   0.7850 },
	{   0.5617,   0.8093 },
	{   0.5590,   0.8333 },
	{   0.5562,   0.8577 },
	{   0.5534,   0.8820 },
	{   0.5506,   0.9064 },
	{   0.5478,   0.9307 },
	{   0.5451,   0.9547 },
	{   0.5423,   0.9790 },
	{   0.5395,   1.0034 },
	{   0.6696,   0.0840 },
	{   0.6669,   0.1080 },
	{   0.6641,   0.1323 },
	{   0.6613,   0.1567 },
	{   0.6585,   0.1810 },
	{   0.6557,   0.2053 },
	{   0.6529,   0.2294 },
	{   0.6501,   0.2537 },
	{   0.6473,   0.2780 },
	{   0.6446,   0.3024 },
	{   0.6418,   0.3267 },
	{   0.6390,   0.3507 },
	{   0.6362,   0.3750 },
	{   0.6334,   0.3994 },
	{   0.6306,   0.4237 },
	{   0.6278,   0.4480 },
	{   0.6251,   0.4721 },
	{   0.6223,   0.4964 },
	{   0.6195,   0.5207 },
	{   0.6167,   0.5451 },
	{   0.6139,   0.5694 },
	{   0.6111,   0.5934 },
	{   0.6083,   0.6178 },
	{   0.6055,   0.6421 },
	{   0.6027,   0.6664 },
	{   0.5999,   0.6908 },
	{   0.5972,   0.7148 },
	{   0.5944,   0.7391 },
	{   0.5916,   0.7634 },
	{   0.5888,   0.7878 },
	{   0.5860,   0.8121 },
	{   0.5832,   0.8361 },
	{   0.5805,   0.8605 },
	{   0.5777,   0.8848 },
	{   0.5749,   0.9091 },
	{   0.5721,   0.9335 },
	{   0.5693,   0.9575 },
	{   0.5665,   0.9818 },
	{   0.5637,   1.0062 },
	{   0.6939,   0.0868 },
	{   0.6911,   0.1108 },
	{   0.6883,   0.1351 },
	{   0.6855,   0.1595 },
	{   0.6827,   0.1838 },
	{   0.6800,   0.2081 },
	{   0.6772,   0.2321 },
	{   0.6744,   0.2565 },
	{   0.6716,   0.2808 },
	{   0.6688,   0.3051 },
	{   0.6660,   0.3295 },
	{   0.6633,   0.3535 },
	{   0.6605,   0.3778 },
	{   0.6577,   0.4022 },
	{   0.6549,   0.4265 },
	{   0.6521,   0.4508 },
	{   0.6493,   0.4749 },
	{   0.6465,   0.4992 },
	{   0.6437,   0.5235 },
	{   0.6409,   0.5479 },
	{   0.6381,   0.5722 },
	{   0.6354,   0.5962 },
	{   0.6326,   0.6205 },
	{   0.6298,   0.6449 },
	{   0.6270,   0.6692 },
	{   0.6242,   0.6935 },
	{   0.6214,   0.7176 },
	{   0.6186,   0.7419 },
	{   0.6158,   0.7662 },
	{   0.6131,   0.7906 },
	{   0.6103,   0.8149 },
	{   0.6075,   0.8389 },
	{   0.6047,   0.8633 },
	{   0.6019,   0.8876 },
	{   0.5991,   0.9119 },
	{   0.5963,   0.9363 },
	{   0.5936,   0.9603 },
	{   0.5908,   0.9846 },
	{   0.5880,   1.0089 },
	{   0.7182,   0.0896 },
	{   0.7154,   0.1136 },
	{   0.7126,   0.1379 },
	{   0.7098,   0.1622 },
	{   0.7070,   0.1866 },
	{   0.7042,   0.2109 },
	{   0.7015,   0.2349 },
	{   0.6987,   0.2593 },
	{   0.6959,   0.2836 },
	{   0.6931,   0.3079 },
	{   0.6903,   0.3323 },
	{   0.6876,   0.3563 },
	{   0.6848,   0.3806 },
	{   0.6820,   0.4050 },
	{   0.6792,   0.4293 },
	{   0.6764,   0.4536 },
	{   0.6736,   0.4776 },
	{   0.6708,   0.5020 },
	{   0.6680,   0.5263 },
	{   0.6652,   0.5506 },
	{   0.6624,   0.5750 },
	{   0.6597,   0.5990 },
	{   0.6569,   0.6233 },
	{   0.6541,   0.6477 },
	{   0.6513,   0.6720 },
	{   0.6485,   0.6963 },
	{   0.6457,   0.7204 },
	{   0.6429,   0.7447 },
	{   0.6401,   0.7690 },
	{   0.6373,   0.7934 },
	{   0.6346,   0.8177 },
	{   0.6318,   0.8417 },
	{   0.6290,   0.8660 },
	{   0.6262,   0.8904 },
	{   0.6234,   0.9147 },
	{   0.6206,   0.9390 },
	{   0.6179,   0.9631 },
	{   0.6151,   0.9874 },
	{   0.6123,   1.0117 },
	{   0.7424,   0.0923 },
	{   0.7397,   0.1164 },
	{   0.7369,   0.1407 },
	{   0.7341,   0.1650 },
	{   0.7313,   0.1894 },
	{   0.7285,   0.2137 },
	{   0.7257,   0.2377 },
	{   0.7229,   0.2620 },
	{   0.7202,   0.2864 },
	{   0.7174,   0.3107 },
	{   0.7146,   0.3351 },
	{   0.7118,   0.3591 },
	{   0.7090,   0.3834 },
	{   0.7062,   0.4077 },
	{   0.7034,   0.4321 },
	{   0.7006,   0.4564 },
	{   0.6979,   0.4804 },
	{   0.6951,   0.5048 },
	{   0.6923,   0.5291 },
	{   0.6895,   0.5534 },
	{   0.6867,   0.5778 },
	{   0.6839,   0.6018 },
	{   0.6811,   0.6261 },
	{   0.6783,   0.6505 },
	{   0.6755,   0.6748 },
	{   0.6727,   0.6991 },
	{   0.6700,   0.7231 },
	{   0.6672,   0.7475 },
	{   0.6644,   0.7718 },
	{   0.6616,   0.7961 },
	{   0.6588,   0.8205 },
	{   0.6561,   0.8445 },
	{   0.6533,   0.8688 },
	{   0.6505,   0.8932 },
	{   0.6477,   0.9175 },
	{   0.6449,   0.9418 },
	{   0.6421,   0.9659 },
	{   0.6393,   0.9902 },
	{   0.6365,   1.0145 },
	{   0.7667,   0.0951 },
	{   0.7640,   0.1191 },
	{   0.7612,   0.1435 },
	{   0.7584,   0.1678 },
	{   0.7556,   0.1922 },
	{   0.7528,   0.2165 },
	{   0.7500,   0.2405 },
	{   0.7472,   0.2648 },
	{   0.7444,   0.2892 },
	{   0.7417,   0.3135 },
	{   0.7389,   0.3378 },
	{   0.7361,   0.3619 },
	{   0.7333,   0.3862 },
	{   0.7305,   0.4105 },
	{   0.7277,   0.4349 },
	{   0.7249,   0.4592 },
	{   0.7222,   0.4832 },
	{   0.7194,   0.5076 },
	{   0.7166,   0.5319 },
	{   0.7138,   0.5562 },
	{   0.7110,   0.5806 },
	{   0.7082,   0.6046 },
	{   0.7054,   0.6289 },
	{   0.7026,   0.6532 },
	{   0.6998,   0.6776 },
	{   0.6970,   0.7019 },
	{   0.6943,   0.7259 },
	{   0.6915,   0.7503 },
	{   0.6887,   0.7746 },
	{   0.6859,   0.7989 },
	{   0.6831,   0.8233 },
	{   0.6803,   0.8473 },
	{   0.6776,   0.8716 },
	{   0.6748,   0.8960 },
	{   0.6720,   0.9203 },
	{   0.6692,   0.9446 },
	{   0.6664,   0.9686 },
	{   0.6636,   0.9930 },
	{   0.6608,   1.0173 },
	{   0.7910,   0.0979 },
	{   0.7882,   0.1219 },
	{   0.7854,   0.1463 },
	{   0.7826,   0.1706 },
	{   0.7798,   0.1949 },
	{   0.7771,   0.2193 },
	{   0.7743,   0.2433 },
	{   0.7715,   0.2676 },
	{   0.7687,   0.2920 },
	{   0.7659,   0.3163 },
	{   0.7631,   0.3406 },
	{   0.7604,   0.3646 },
	{   0.7576,   0.3890 },
	{   0.7548,   0.4133 },
	{   0.7520,   0.4377 },
	{   0.7492,   0.4620 },
	{   0.7464,   0.4860 },
	{   0.7436,   0.5103 },
	{   0.7408,   0.5347 },
	{   0.7380,   0.5590 },
	{   0.7352,   0.5833 },
	{   0.7325,   0.6074 },
	{   0.7297,   0.6317 },
	{   0.7269,   0.6560 },
	{   0.7241,   0.6804 },
	{   0.7213,   0.7047 },
	{   0.7185,   0.7287 },
	{   0.7157,   0.7531 },
	{   0.7130,   0.7774 },
	{   0.7102,   0.8017 },
	{   0.7074,   0.8261 },
	{   0.7046,   0.8501 },
	{   0.7018,   0.8744 },
	{   0.6990,   0.8987 },
	{   0.6962,   0.9231 },
	{   0.6934,   0.9474 },
	{   0.6907,   0.9714 },
	{   0.6879,   0.9958 },
	{   0.6851,   1.0201 },
	{   0.8152,   0.1007 },
	{   0.8125,   0.1247 },
	{   0.8097,   0.1491 },
	{   0.8069,   0.1734 },
	{   0.8041,   0.1977 },
	{   0.8013,   0.2221 },
	{   0.7986,   0.2461 },
	{   0.7958,   0.2704 },
	{   0.7930,   0.2947 },
	{   0.7902,   0.3191 },
	{   0.7874,   0.3434 },
	{   0.7846,   0.3674 },
	{   0.7818,   0.3918 },
	{   0.7790,   0.4161 },
	{   0.7762,   0.4404 },
	{   0.7734,   0.4648 },
	{   0.7707,   0.4888 },
	{   0.7679,   0.5131 },
	{   0.7651,   0.5375 },
	{   0.7623,   0.5618 },
	{   0.7595,   0.5861 },
	{   0.7567,   0.6101 },
	{   0.7539,   0.6345 },
	{   0.7511,   0.6588 },
	{   0.7483,   0.6831 },
	{   0.7456,   0.7075 },
	{   0.7428,   0.7315 },
	{   0.7400,   0.7558 },
	{   0.7372,   0.7802 },
	{   0.7344,   0.8045 },
	{   0.7316,   0.8288 },
	{   0.7289,   0.8529 },
	{   0.7261,   0.8772 },
	{   0.7233,   0.9015 },
	{   0.7205,   0.9259 },
	{   0.7177,   0.9502 },
	{   0.7149,   0.9742 },
	{   0.7121,   0.9986 },
	{   0.7093,   1.0229 },
	{   0.8395,   0.1035 },
	{   0.8368,   0.1275 },
	{   0.8340,   0.1518 },
	{   0.8312,   0.1762 },
	{   0.8284,   0.2005 },
	{   0.8256,   0.2248 },
	{   0.8228,   0.2489 },
	{   0.8201,   0.2732 },
	{   0.8173,   0.2975 },
	{   0.8145,   0.3219 },
	{   0.8117,   0.3462 },
	{   0.8089,   0.3702 },
	{   0.8061,   0.3946 },
	{   0.8033,   0.4189 },
	{   0.8005,   0.4432 },
	{   0.7977,   0.4676 },
	{   0.7950,   0.4916 },
	{   0.7922,   0.5159 },
	{   0.7894,   0.5402 },
	{   0.7866,   0.5646 },
	{   0.7838,   0.5889 },
	{   0.7810,   0.6129 },
	{   0.7782,   0.6373 },
	{   0.7754,   0.6616 },
	{   0.7726,   0.6859 },
	{   0.7698,   0.7103 },
	{   0.7671,   0.7343 },
	{   0.7643,   0.7586 },
	{   0.7615,   0.7830 },
	{   0.7587,   0.8073 },
	{   0.7559,   0.8316 },
	{   0.7532,   0.8556 },
	{   0.7504,   0.8800 },
	{   0.7476,   0.9043 },
	{   0.7448,   0.9287 },
	{   0.7420,   0.9530 },
	{   0.7392,   0.9770 },
	{   0.7364,   1.0013 },
	{   0.7336,   1.0257 },
	{   0.8638,   0.1063 },
	{   0.8610,   0.1303 },
	{   0.8582,   0.1546 },
	{   0.8555,   0.1790 },
	{   0.8527,   0.2033 },
	{   0.8499,   0.2276 },
	{   0.8471,   0.2517 },
	{   0.8443,   0.2760 },
	{   0.8415,   0.3003 },
	{   0.8387,   0.3247 },
	{   0.8359,   0.3490 },
	{   0.8332,   0.3730 },
	{   0.8304,   0.3973 },
	{   0.8276,   0.4217 },
	{   0.8248,   0.4460 },
	{   0.8220,   0.4703 },
	{   0.8192,   0.4944 },
	{   0.8164,   0.5187 },
	{   0.8136,   0.5430 },
	{   0.8108,   0.5674 },
	{   0.8080,   0.5917 },
	{   0.8053,   0.6157 },
	{   0.8025,   0.6401 },
	{   0.7997,   0.6644 },
	{   0.7969,   0.6887 },
	{   0.7941,   0.7131 },
	{   0.7913,   0.7371 },
	{   0.7886,   0.7614 },
	{   0.7858,   0.7857 },
	{   0.7830,   0.8101 },
	{   0.7802,   0.8344 },
	{   0.7774,   0.8584 },
	{   0.7746,   0.8828 },
	{   0.7718,   0.9071 },
	{   0.7690,   0.9314 },
	{   0.7662,   0.9558 },
	{   0.7635,   0.9798 },
	{   0.7607,   1.0041 },
	{   0.7579,   1.0285 },
	{   0.8881,   0.1091 },
	{   0.8853,   0.1331 },
	{   0.8825,   0.1574 },
	{   0.8797,   0.1818 },
	{   0.8770,   0.2061 },
	{   0.8742,   0.2304 },
	{   0.8714,   0.2544 },
	{   0.8686,   0.2788 },
	{   0.8658,   0.3031 },
	{   0.8630,   0.3274 },
	{   0.8602,   0.3518 },
	{   0.8575,   0.3758 },
	{   0.8547,   0.4001 },
	{   0.8519,   0.4245 },
	{   0.8491,   0.4488 },
	{   0.8463,   0.4731 },
	{   0.8435,   0.4972 },
	{   0.8407,   0.5215 },
	{   0.8379,   0.5458 },
	{   0.8351,   0.5702 },
	{   0.8323,   0.5945 },
	{   0.8296,   0.6185 },
	{   0.8268,   0.6428 },
	{   0.8240,   0.6672 },
	{   0.8212,   0.6915 },
	{   0.8184,   0.7159 },
	{   0.8156,   0.7399 },
	{   0.8128,   0.7642 },
	{   0.8101,   0.7885 },
	{   0.8073,   0.8129 },
	{   0.8045,   0.8372 },
	{   0.8017,   0.8612 },
	{   0.7989,   0.8856 },
	{   0.7961,   0.9099 },
	{   0.7933,   0.9342 },
	{   0.7905,   0.9586 },
	{   0.7878,   0.9826 },
	{   0.7850,   1.0069 },
	{   0.7822,   1.0313 },
	{   0.9123,   0.1119 },
	{   0.9096,   0.1359 },
	{   0.9068,   0.1602 },
	{   0.9040,   0.1845 },
	{   0.9012,   0.2089 },
	{   0.8984,   0.2332 },
	{   0.8957,   0.2572 },
	{   0.8929,   0.2816 },
	{   0.8901,   0.3059 },
	{   0.8873,   0.3302 },
	{   0.8845,   0.3546 },
	{   0.8817,   0.3786 },
	{   0.8789,   0.4029 },
	{   0.8761,   0.4273 },
	{   0.8733,   0.4516 },
	{   0.8705,   0.4759 },
	{   0.8678,   0.4999 },
	{   0.8650,   0.5243 },
	{   0.8622,   0.5486 },
	{   0.8594,   0.5729 },
	{   0.8566,   0.5973 },
	{   0.8538,   0.6213 },
	{   0.8510,   0.6456 },
	{   0.8482,   0.6700 },
	{   0.8455,   0.6943 },
	{   0.8427,   0.7186 },
	{   0.8399,   0.7427 },
	{   0.8371,   0.7670 },
	{   0.8343,   0.7913 },
	{   0.8315,   0.8157 },
	{   0.8287,   0.8400 },
	{   0.8260,   0.8640 },
	{   0.8232,   0.8883 },
	{   0.8204,   0.9127 },
	{   0.8176,   0.9370 },
	{   0.8148,   0.9614 },
	{   0.8120,   0.9854 },
	{   0.8092,   1.0097 },
	{   0.8064,   1.0340 },
	{   0.9366,   0.1146 },
	{   0.9338,   0.1387 },
	{   0.9311,   0.1630 },
	{   0.9283,   0.1873 },
	{   0.9255,   0.2117 },
	{   0.9227,   0.2360 },
	{   0.9199,   0.2600 },
	{   0.9171,   0.2844 },
	{   0.9143,   0.3087 },
	{   0.9115,   0.3330 },
	{   0.9087,   0.3574 },
	{   0.9060,   0.3814 },
	{   0.9032,   0.4057 },
	{   0.9004,   0.4300 },
	{   0.8976,   0.4544 },
	{   0.8948,   0.4787 },
	{   0.8920,   0.5027 },
	{   0.8892,   0.5271 },
	{   0.8864,   0.5514 },
	{   0.8836,   0.5757 },
	{   0.8808,   0.6001 },
	{   0.8781,   0.6241 },
	{   0.8753,   0.6484 },
	{   0.8725,   0.6728 },
	{   0.8697,   0.6971 },
	{   0.8669,   0.7214 },
	{   0.8642,   0.7454 },
	{   0.8614,   0.7698 },
	{   0.8586,   0.7941 },
	{   0.8558,   0.8184 },
	{   0.8530,   0.8428 },
	{   0.8502,   0.8668 },
	{   0.8474,   0.8911 },
	{   0.8446,   0.9155 },
	{   0.8418,   0.9398 },
	{   0.8390,   0.9641 },
	{   0.8363,   0.9882 },
	{   0.8335,   1.0125 },
	{   0.8307,   1.0368 },
	{   0.9581,   0.1414 },
	{   0.9553,   0.1658 },
	{   0.9526,   0.1901 },
	{   0.9498,   0.2145 },
	{   0.9470,   0.2388 },
	{   0.9442,   0.2628 },
	{   0.9414,   0.2871 },
	{   0.9386,   0.3115 },
	{   0.9358,   0.3358 },
	{   0.9330,   0.3601 },
	{   0.9303,   0.3842 },
	{   0.9275,   0.4085 },
	{   0.9247,   0.4328 },
	{   0.9219,   0.4572 },
	{   0.9191,   0.4815 },
	{   0.9163,   0.5055 },
	{   0.9135,   0.5299 },
	{   0.9107,   0.5542 },
	{   0.9079,   0.5785 },
	{   0.9051,   0.6029 },
	{   0.9024,   0.6269 },
	{   0.8996,   0.6512 },
	{   0.8968,   0.6755 },
	{   0.8940,   0.6999 },
	{   0.8912,   0.7242 },
	{   0.8884,   0.7482 },
	{   0.8857,   0.7726 },
	{   0.8829,   0.7969 },
	{   0.8801,   0.8212 },
	{   0.8773,   0.8456 },
	{   0.8745,   0.8696 },
	{   0.8717,   0.8939 },
	{   0.8689,   0.9183 },
	{   0.8661,   0.9426 },
	{   0.8633,   0.9669 },
	{   0.8606,   0.9909 },
	{   0.8578,   1.0153 },
	{   0.8550,   1.0396 },
	{   0.8522,   1.0639 },
};

