---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab alias set`

Set an alias for a longer command.

## Synopsis

Declare a word as an alias for a longer command.

Your expansion might include arguments and flags. If your expansion
includes positional placeholders such as '$1' or '$2', any extra
arguments that follow the invocation of an alias are inserted
appropriately.

Specify '--shell' in your alias to run it through 'sh', a shell
converter. Shell conversion enables you to compose commands with "|"
or redirect with ">", with these caveats:

- Any extra arguments following the alias are not passed to the
  expanded expression arguments by default.
- You must explicitly accept the arguments using '$1', '$2', and so on.
- Use '$@' to accept all arguments.

For Windows users only:

- On Windows, shell aliases are executed with 'sh' as installed by
  Git For Windows. If you installed Git in some other way in Windows,
  shell aliases might not work for you.
- Always use quotation marks when defining a command, as in the examples.

```plaintext
glab alias set <alias name> '<command>' [flags]
```

## Examples

```console
$ glab alias set mrv 'mr view'
$ glab mrv -w 123
> glab mr view -w 123

$ glab alias set createissue 'glab create issue --title "$1"'
$ glab createissue "My Issue" --description "Something is broken."
> glab create issue --title "My Issue" --description "Something is broken."

$ glab alias set --shell igrep 'glab issue list --assignee="$1" | grep $2'
$ glab igrep user foo
> glab issue list --assignee="user" | grep "foo"

```

## Options

```plaintext
  -s, --shell   Declare an alias to be passed through a shell interpreter.
```

## Options inherited from parent commands

```plaintext
      --help   Show help for this command.
```
