
/******************************************/
/* Begin Kernel                           */
/******************************************/
.amdgcn_target "amdgcn-amd-amdhsa--gfx942"
.text
.protected CustomGSUs_Cijk_Ailk_Bljk_F8NH_HHS_BH_MT128x16x128_MI16x16x1_10_Freesize_gfx942
.globl CustomGSUs_Cijk_Ailk_Bljk_F8NH_HHS_BH_MT128x16x128_MI16x16x1_10_Freesize_gfx942
.p2align 8
.type CustomGSUs_Cijk_Ailk_Bljk_F8NH_HHS_BH_MT128x16x128_MI16x16x1_10_Freesize_gfx942,@function
.section .rodata,#alloc
.p2align 6
.amdhsa_kernel CustomGSUs_Cijk_Ailk_Bljk_F8NH_HHS_BH_MT128x16x128_MI16x16x1_10_Freesize_gfx942
  .amdhsa_user_sgpr_kernarg_segment_ptr 1
  .amdhsa_accum_offset 256 // accvgpr offset
  .amdhsa_next_free_vgpr 264 // vgprs
  .amdhsa_next_free_sgpr 77 // sgprs
  .amdhsa_group_segment_fixed_size 38400 // lds bytes
  .amdhsa_private_segment_fixed_size 0
  .amdhsa_system_sgpr_workgroup_id_x 1
  .amdhsa_system_sgpr_workgroup_id_y 1
  .amdhsa_system_sgpr_workgroup_id_z 1
  .amdhsa_system_vgpr_workitem_id 0
  .amdhsa_float_denorm_mode_32 3
  .amdhsa_float_denorm_mode_16_64 3
.end_amdhsa_kernel
.text
/* Num VGPR   =256 */
/* Num AccVGPR=8 */
/* Num SGPR   =77 */

/******************************************/
/* Optimizations and Config:              */
/******************************************/
/* ThreadTile= 8 x 1 */
/* SubGroup= 16 x 16 */
/* VectorWidthA=2 */
/* VectorWidthB=1 */
/* GlobalReadVectorWidthA=8, GlobalReadVectorWidthB=8 */
/* DirectToLdsA=False */
/* DirectToLdsB=False */
/* UseSgprForGRO=False */
.amdgpu_metadata
---
custom.config:
   InternalSupportParams:
      KernArgsVersion: 0
      SupportUserGSU: True
      SupportCustomWGM: True
      SupportCustomStaggerU: False
      UseUniversalArgs: False
amdhsa.version:
  - 1
  - 1
amdhsa.kernels:
  - .name: CustomGSUs_Cijk_Ailk_Bljk_F8NH_HHS_BH_MT128x16x128_MI16x16x1_10_Freesize_gfx942
    .symbol: 'CustomGSUs_Cijk_Ailk_Bljk_F8NH_HHS_BH_MT128x16x128_MI16x16x1_10_Freesize_gfx942.kd'
    .language:                   OpenCL C
    .language_version:
      - 2
      - 0
    .args:
      - .name:            SizesFree0
        .size:            4
        .offset:          0
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesFree1
        .size:            4
        .offset:          4
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesFree2
        .size:            4
        .offset:          8
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesSum0
        .size:            4
        .offset:          12
        .value_kind:      by_value
        .value_type:      u32
      - .name:            D
        .size:            8
        .offset:          16
        .value_kind:      global_buffer
        .value_type:      f16
        .address_space:   generic
      - .name:            C
        .size:            8
        .offset:          24
        .value_kind:      global_buffer
        .value_type:      f16
        .address_space:   generic
      - .name:            A
        .size:            8
        .offset:          32
        .value_kind:      global_buffer
        .value_type:      f16
        .address_space:   generic
      - .name:            B
        .size:            8
        .offset:          40
        .value_kind:      global_buffer
        .value_type:      f16
        .address_space:   generic
      - .name:            strideD0
        .size:            4
        .offset:          48
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideD1
        .size:            4
        .offset:          52
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideC0
        .size:            4
        .offset:          56
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideC1
        .size:            4
        .offset:          60
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideA0
        .size:            4
        .offset:          64
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideA1
        .size:            4
        .offset:          68
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideB0
        .size:            4
        .offset:          72
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideB1
        .size:            4
        .offset:          76
        .value_kind:      by_value
        .value_type:      u32
      - .name:            alpha
        .size:            4
        .offset:          80
        .value_kind:      by_value
        .value_type:      f32
      - .name:            beta
        .size:            4
        .offset:          84
        .value_kind:      by_value
        .value_type:      f32
      - .name:            internalArgs
        .size:            4
        .offset:          88
        .value_kind:      by_value
        .value_type:      u32
      - .name:            dstD
        .size:            8
        .offset:          92
        .value_kind:      global_buffer
        .value_type:      f16
        .address_space:   generic
      - .name:            Synchronizer
        .size:            8
        .offset:          100
        .value_kind:      global_buffer
        .value_type:      f32
        .address_space:   generic
      - .name:            GSUSync
        .size:            4
        .offset:          108
        .value_kind:      by_value
        .value_type:      u32
    .group_segment_fixed_size:   38400
    .kernarg_segment_align:      8
    .kernarg_segment_size:       112
    .max_flat_workgroup_size:    256
    .private_segment_fixed_size: 0
    .sgpr_count:                 77
    .sgpr_spill_count:           0
    .vgpr_count:                 256
    .vgpr_spill_count:           0
    .wavefront_size:             64
...
.end_amdgpu_metadata
CustomGSUs_Cijk_Ailk_Bljk_F8NH_HHS_BH_MT128x16x128_MI16x16x1_10_Freesize_gfx942:
.long 0xC0120700, 0x00000000
.long 0xC00A0B00, 0x00000040
.long 0xC0060C00, 0x00000050
.long 0xC0020C80, 0x00000058
.long 0xBEC700FF, 0x05040100
.long 0xBEC800FF, 0x07060302
.long 0xBEFC00FF, 0x00009600
.long 0x7ECC0300
.long 0x2602CCBF
.long 0x2600028F
.long 0x20020284
.long 0x26020280
.long 0x24020284
.long 0x68000101
.long 0x24000081
.long 0x2602CCBF
.long 0x20020284
.long 0x2402028A
.long 0x68000101
.long 0x2002CC86
.long 0x26020283
.long 0x24020285
.long 0x68000101
.long 0x2604CCBF
.long 0x2602048F
.long 0x24020287
.long 0x20040484
.long 0x26040480
.long 0x2404048B
.long 0x68020302
.long 0x2604CCBF
.long 0x20040484
.long 0x24040483
.long 0x68020302
.long 0x2004CC88
.long 0xBEC900FF, 0x00000080
.long 0xD2850002, 0x00020449
.long 0xD1FE0064, 0x02060102
.long 0x2006C88B
.long 0x24060686
.long 0x68C8C903
.long 0x2000CC88
.long 0xBEC90090
.long 0xD2850000, 0x00020049
.long 0xD1FE0065, 0x02060300
.long 0x2004CA88
.long 0x24040485
.long 0x68CACB02
.long 0x32CACAFF, 0x00008400
.long 0x2608CCBF
.long 0x20020884
.long 0x2600088F
.long 0x2008CC86
.long 0x7E0A02A0
.long 0xD2850001, 0x00020305
.long 0x68020304
.long 0x24000083
.long 0x7E080301
.long 0x260ACCBF
.long 0x20040A84
.long 0x26060A8F
.long 0x7E920566
.long 0x8F498649
.long 0x92498449
.long 0x68040449
.long 0x24060683
.long 0x7E0A0303
.long 0x106808FF, 0x00000080
.long 0xD1FE0034, 0x02066900
.long 0x200C688B
.long 0x240C0C86
.long 0x68686906
.long 0x106A04FF, 0x00000080
.long 0xD1FE0035, 0x02066B05
.long 0x200C6A88
.long 0x240C0C85
.long 0x686A6B06
.long 0x326A6AFF, 0x00008400
.long 0xBF8CC07F
.long 0x8609FF32, 0x0000FF00
.long 0x8F098809
.long 0x8633FF32, 0xFFFF0000
.long 0x8F339033
.long 0x8632FF32, 0x000000FF
.long 0x7E1002FF, 0x00000080
.long 0x7E0E021C
.long 0x7E0C0D08
.long 0x7E0C4706
.long 0x7E120D07
.long 0x0A0C1306
.long 0x7E0C0F06
.long 0x10121106
.long 0x6A121307
.long 0xD0CD006A, 0x00010109
.long 0xD11C6A06, 0x01A90106
.long 0x7E100290
.long 0x7E0E021D
.long 0x7E280506
.long 0x7E0C0D08
.long 0x7E0C4706
.long 0x7E120D07
.long 0x0A0C1306
.long 0x7E0C0F06
.long 0x10121106
.long 0x6A121307
.long 0xD0CD006A, 0x00010109
.long 0xD11C6A06, 0x01A90106
.long 0xBF800000
.long 0x7E2A0506
.long 0x80A48824
.long 0x82A58025
.long 0x80A69026
.long 0x82A78027
.long 0xD042006A, 0x00010030
.long 0xBF860001
.long 0xBE9F0080
.long 0xBF068132
.long 0xBF850012
.long 0x7E0C0C32
.long 0x7E0C4706
.long 0x7E0E0C03
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00006506
.long 0x6A0E0E03
.long 0xD0DA007E, 0x00006507
.long 0x680C0C81
.long 0x7E0E0280
.long 0xBEFE01C1
.long 0x7E060506
.long 0x7E0C0507
.long 0xBE850081
.long 0xBE880082
.long 0xBF820003
.long 0xBE860180
.long 0xBE850081
.long 0xBE880081
.long 0xBF0B8109
.long 0xBF850035
.long 0x7E0C0C09
.long 0x7E0C4706
.long 0x7E0E0C03
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00001306
.long 0x6A0E0E03
.long 0xD0DA007E, 0x00001307
.long 0x680C0C81
.long 0xBEFE01C1
.long 0x7E980506
.long 0x924D094C
.long 0x80CD4D03
.long 0x924D144D
.long 0x804D024D
.long 0x7E0C0C09
.long 0x7E0C4706
.long 0x7E0E0C15
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00001306
.long 0x6A0E0E15
.long 0xD0DA007E, 0x00001307
.long 0x680C0C81
.long 0xBEFE01C1
.long 0x7E940506
.long 0x924B4A09
.long 0x80C94B15
.long 0xBF068049
.long 0xBEC90209
.long 0xBF094A4C
.long 0x854A0949
.long 0x7E0C0C4A
.long 0x7E0C4706
.long 0x7E0E0C4D
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00009506
.long 0x6A0E0E4D
.long 0xD0DA007E, 0x00009507
.long 0x680C0C81
.long 0x7E0E0280
.long 0xBEFE01C1
.long 0x7E040506
.long 0x7E060507
.long 0x924C094C
.long 0x80034C03
.long 0x7E0C0300
.long 0x7E0E0302
.long 0x7E100301
.long 0x32121084
.long 0x32141284
.long 0x32161484
.long 0x32181684
.long 0x321A1884
.long 0x321C1A84
.long 0x321E1C84
.long 0x7E200303
.long 0x9249FF02, 0x00000080
.long 0x80C9491C
.long 0x80C98849
.long 0x7E220249
.long 0x180C0D11
.long 0xD2850011, 0x0002102C
.long 0x326C2306
.long 0x686C6C88
.long 0xD2850011, 0x0002122C
.long 0x326E2306
.long 0x686E6E88
.long 0xD2850011, 0x0002142C
.long 0x32702306
.long 0x68707088
.long 0xD2850011, 0x0002162C
.long 0x32722306
.long 0x68727288
.long 0xD2850011, 0x0002182C
.long 0x32742306
.long 0x68747488
.long 0xD2850011, 0x00021A2C
.long 0x32762306
.long 0x68767688
.long 0xD2850011, 0x00021C2C
.long 0x32782306
.long 0x68787888
.long 0xD2850011, 0x00021E2C
.long 0x327A2306
.long 0x687A7A88
.long 0xD2850008, 0x00020E2E
.long 0x327C1110
.long 0x687C7C88
.long 0x247C7C81
.long 0x964DFF02, 0x00000080
.long 0x924CFF02, 0x00000080
.long 0x964B06FF, 0x00000080
.long 0x924A06FF, 0x00000080
.long 0x964B2C4A
.long 0x924A2C4A
.long 0x804C4A4C
.long 0x824D4B4D
.long 0xBEBC0081
.long 0xBEBD0080
.long 0x80CA811C
.long 0x964B4A81
.long 0x924A4A81
.long 0x803C4A3C
.long 0x823D4B3D
.long 0x80CA811F
.long 0x964B4A2C
.long 0x924A4A2C
.long 0x803C4A3C
.long 0x823D4B3D
.long 0x80BC4C3C
.long 0x82BD4D3D
.long 0x803C883C
.long 0x823D803D
.long 0xBF06803D
.long 0x8536C13C
.long 0x964B042D
.long 0x924A042D
.long 0x804C4A4C
.long 0x824D4B4D
.long 0x80344C24
.long 0x82354D25
.long 0xBEB700FF, 0x00020000
.long 0x964D9003
.long 0x924C9003
.long 0x964D2E4C
.long 0x924C2E4C
.long 0x964B06FF, 0x00000080
.long 0x924A06FF, 0x00000080
.long 0x804C4A4C
.long 0x824D4B4D
.long 0xBEBE0081
.long 0xBEBF0080
.long 0x80CA811F
.long 0x964B4A81
.long 0x924A4A81
.long 0x803E4A3E
.long 0x823F4B3F
.long 0x80CA811D
.long 0x964B4A2E
.long 0x924A4A2E
.long 0x803E4A3E
.long 0x823F4B3F
.long 0x80BE4C3E
.long 0x82BF4D3F
.long 0x8EBE813E
.long 0x803E903E
.long 0x823F803F
.long 0xBF06803F
.long 0x853AC13E
.long 0x964B042F
.long 0x924A042F
.long 0x804C4A4C
.long 0x824D4B4D
.long 0x8ECC814C
.long 0x80384C26
.long 0x82394D27
.long 0xBEBB00FF, 0x00020000
.long 0x9249FF32, 0x00000080
.long 0x92452C49
.long 0x9249FF32, 0x00000100
.long 0xBEC60049
.long 0x8F0A871F
.long 0xBF068132
.long 0xBF850012
.long 0x7E000C32
.long 0x7E004700
.long 0x7E020C0A
.long 0x0A000300
.long 0x7E000F00
.long 0xD1080001, 0x00006500
.long 0x6A02020A
.long 0xD0DA007E, 0x00006501
.long 0x68000081
.long 0x7E020280
.long 0xBEFE01C1
.long 0x7E140500
.long 0x7E0E0501
.long 0x804A0A81
.long 0xBF0A0706
.long 0xBE8A024A
.long 0xBE8B000A
.long 0x864CFF33, 0x00001F00
.long 0x8F4C884C
.long 0x864DFF33, 0x0000E000
.long 0x8633FF33, 0x000000FF
.long 0xBECA0033
.long 0x8E4B4C4A
.long 0xBF094B0B
.long 0xBF850002
.long 0x8F4A814A
.long 0xBF82FFFB
.long 0x80CB814A
.long 0xBF09814A
.long 0x8540804B
.long 0xBF06804D
.long 0xBF850002
.long 0xBECA0002
.long 0xBF820016
.long 0xBF06FF4D, 0x00002000
.long 0xBF850002
.long 0xBECA0003
.long 0xBF820011
.long 0xBF06FF4D, 0x00004000
.long 0xBF850002
.long 0xBECA00C1
.long 0xBF82000C
.long 0xBF06FF4D, 0x00006000
.long 0xBF850004
.long 0x924B0314
.long 0x804A4B4A
.long 0x804A024A
.long 0xBF820005
.long 0xBF06FF4D, 0x00008000
.long 0xBF850002
.long 0xBECA00C1
.long 0xBF820000
.long 0x86404A40
.long 0x8E404C40
.long 0x96CB4540
.long 0x924A4540
.long 0x96C2450A
.long 0x9241450A
.long 0x80C14145
.long 0x82C24280
.long 0x80344A34
.long 0x82354B35
.long 0x80BC4A3C
.long 0x82BD4B3D
.long 0xBF06803D
.long 0x8536C13C
.long 0x96CB4640
.long 0x924A4640
.long 0x96C4460A
.long 0x9243460A
.long 0x80C34346
.long 0x82C44480
.long 0x80384A38
.long 0x82394B39
.long 0x80BE4A3E
.long 0x82BF4B3F
.long 0xBF06803F
.long 0x853AC13E
.long 0x80408240
.long 0xBF06800A
.long 0xBF850026
.long 0xE0541000, 0x800D4236
.long 0xE0541000, 0x800D4637
.long 0xE0541000, 0x800D4A38
.long 0xE0541000, 0x800D4E39
.long 0xE0541000, 0x800D523A
.long 0xE0541000, 0x800D563B
.long 0xE0541000, 0x800D5A3C
.long 0xE0541000, 0x800D5E3D
.long 0xE05C1000, 0x800E603E
.long 0x804C810A
.long 0xBF064C40
.long 0x854A4541
.long 0x854B8042
.long 0x80344A34
.long 0x82354B35
.long 0x80BC4A3C
.long 0x82BD4B3D
.long 0xBF06803D
.long 0x8536C13C
.long 0x804C810A
.long 0xBF064C40
.long 0x854A4643
.long 0x854B8044
.long 0x80384A38
.long 0x82394B39
.long 0x80BE4A3E
.long 0x82BF4B3F
.long 0xBF06803F
.long 0x853AC13E
.long 0xBE8C0020
.long 0xBE8D0021
.long 0xBE8E00FF, 0x80000000
.long 0xBE8F00FF, 0x00020000
.long 0xBE900022
.long 0xBE910023
.long 0xBE9200FF, 0x80000000
.long 0xBE9300FF, 0x00020000
.long 0x924C0390
.long 0x964B2A4C
.long 0x924A2A4C
.long 0x8ECA054A
.long 0x80104A22
.long 0x82114B23
.long 0x964B284C
.long 0x924A284C
.long 0x8ECA084A
.long 0x800C4A20
.long 0x820D4B21
.long 0x964B2B04
.long 0x924A2B04
.long 0x8ECA054A
.long 0x80104A10
.long 0x82114B11
.long 0x964B2904
.long 0x924A2904
.long 0x8ECA084A
.long 0x800C4A0C
.long 0x820D4B0D
.long 0xBE96000C
.long 0xBE97000D
.long 0xBF068132
.long 0xBF850011
.long 0x964B061C
.long 0x924A061C
.long 0x80CD811D
.long 0x924D064D
.long 0x964C2A4D
.long 0x92492A4D
.long 0x804A494A
.long 0x824B4C4B
.long 0x80CD811E
.long 0x924D064D
.long 0x964C2B4D
.long 0x92492B4D
.long 0x804A494A
.long 0x824B4C4B
.long 0x8ECA824A
.long 0x800C4A0C
.long 0x820D4B0D
.long 0xD3D94000, 0x18000080
.long 0xD3D94001, 0x18000080
.long 0xD3D94002, 0x18000080
.long 0xD3D94003, 0x18000080
.long 0xD3D94004, 0x18000080
.long 0xD3D94005, 0x18000080
.long 0xD3D94006, 0x18000080
.long 0xD3D94007, 0x18000080
.long 0xBF06800A
.long 0xBF840006
.long 0xBECA1C00
.long 0x814C84FF, 0x000017F8
.long 0x804A4C4A
.long 0x824B804B
.long 0xBE801D4A
.long 0xBF8C0F70
.long 0x7ED0ACF9, 0x00040642
.long 0x7E8014F9, 0x00061468
.long 0x7E8014F9, 0x00061569
.long 0x7ED0ACF9, 0x00050642
.long 0x7E8214F9, 0x00061468
.long 0x7E8214F9, 0x00061569
.long 0x7ED0ACF9, 0x00040643
.long 0x7E8414F9, 0x00061468
.long 0x7E8414F9, 0x00061569
.long 0x7ED0ACF9, 0x00050643
.long 0x7E8614F9, 0x00061468
.long 0x7E8614F9, 0x00061569
.long 0xD9BE0000, 0x00004034
.long 0x7ED0ACF9, 0x00040646
.long 0x7E8814F9, 0x00061468
.long 0x7E8814F9, 0x00061569
.long 0x7ED0ACF9, 0x00050646
.long 0x7E8A14F9, 0x00061468
.long 0x7E8A14F9, 0x00061569
.long 0x7ED0ACF9, 0x00040647
.long 0x7E8C14F9, 0x00061468
.long 0x7E8C14F9, 0x00061569
.long 0x7ED0ACF9, 0x00050647
.long 0x7E8E14F9, 0x00061468
.long 0x7E8E14F9, 0x00061569
.long 0xD9BE0400, 0x00004434
.long 0x7ED0ACF9, 0x0004064A
.long 0x7E9014F9, 0x00061468
.long 0x7E9014F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064A
.long 0x7E9214F9, 0x00061468
.long 0x7E9214F9, 0x00061569
.long 0x7ED0ACF9, 0x0004064B
.long 0x7E9414F9, 0x00061468
.long 0x7E9414F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064B
.long 0x7E9614F9, 0x00061468
.long 0x7E9614F9, 0x00061569
.long 0xD9BE0840, 0x00004834
.long 0x7ED0ACF9, 0x0004064E
.long 0x7E9814F9, 0x00061468
.long 0x7E9814F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064E
.long 0x7E9A14F9, 0x00061468
.long 0x7E9A14F9, 0x00061569
.long 0x7ED0ACF9, 0x0004064F
.long 0x7E9C14F9, 0x00061468
.long 0x7E9C14F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064F
.long 0x7E9E14F9, 0x00061468
.long 0x7E9E14F9, 0x00061569
.long 0xD9BE0C40, 0x00004C34
.long 0x7ED0ACF9, 0x00040652
.long 0x7EA014F9, 0x00061468
.long 0x7EA014F9, 0x00061569
.long 0x7ED0ACF9, 0x00050652
.long 0x7EA214F9, 0x00061468
.long 0x7EA214F9, 0x00061569
.long 0x7ED0ACF9, 0x00040653
.long 0x7EA414F9, 0x00061468
.long 0x7EA414F9, 0x00061569
.long 0x7ED0ACF9, 0x00050653
.long 0x7EA614F9, 0x00061468
.long 0x7EA614F9, 0x00061569
.long 0xD9BE1080, 0x00005034
.long 0x7ED0ACF9, 0x00040656
.long 0x7EA814F9, 0x00061468
.long 0x7EA814F9, 0x00061569
.long 0x7ED0ACF9, 0x00050656
.long 0x7EAA14F9, 0x00061468
.long 0x7EAA14F9, 0x00061569
.long 0x7ED0ACF9, 0x00040657
.long 0x7EAC14F9, 0x00061468
.long 0x7EAC14F9, 0x00061569
.long 0x7ED0ACF9, 0x00050657
.long 0x7EAE14F9, 0x00061468
.long 0x7EAE14F9, 0x00061569
.long 0xD9BE1480, 0x00005434
.long 0x7ED0ACF9, 0x0004065A
.long 0x7EB014F9, 0x00061468
.long 0x7EB014F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065A
.long 0x7EB214F9, 0x00061468
.long 0x7EB214F9, 0x00061569
.long 0x7ED0ACF9, 0x0004065B
.long 0x7EB414F9, 0x00061468
.long 0x7EB414F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065B
.long 0x7EB614F9, 0x00061468
.long 0x7EB614F9, 0x00061569
.long 0xD9BE18C0, 0x00005834
.long 0x7ED0ACF9, 0x0004065E
.long 0x7EB814F9, 0x00061468
.long 0x7EB814F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065E
.long 0x7EBA14F9, 0x00061468
.long 0x7EBA14F9, 0x00061569
.long 0x7ED0ACF9, 0x0004065F
.long 0x7EBC14F9, 0x00061468
.long 0x7EBC14F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065F
.long 0x7EBE14F9, 0x00061468
.long 0x7EBE14F9, 0x00061569
.long 0xD9BE1CC0, 0x00005C34
.long 0xD9BE0000, 0x00006035
.long 0xBF06810A
.long 0xBF850012
.long 0xE0541000, 0x800D4236
.long 0xE0541000, 0x800D4637
.long 0xE0541000, 0x800D4A38
.long 0xE0541000, 0x800D4E39
.long 0xE0541000, 0x800D523A
.long 0xE0541000, 0x800D563B
.long 0xE0541000, 0x800D5A3C
.long 0xE0541000, 0x800D5E3D
.long 0xE05C1000, 0x800E603E
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD86C0000, 0x04000064
.long 0xD86C0100, 0x0C000064
.long 0xD86C0200, 0x14000064
.long 0xD86C0300, 0x1C000064
.long 0xD9FE0000, 0x24000065
.long 0xBF06810A
.long 0xBF850359
.long 0xBF0B820A
.long 0xBF8501B6
.long 0xBF8CC07F
.long 0xD1ED0000, 0x011E090C
.long 0xD1ED0001, 0x011E291C
.long 0xD1ED0002, 0x0122090C
.long 0xD1ED0003, 0x0122291C
.long 0xD3CD8000, 0x04024900
.long 0xD86C0400, 0x05000064
.long 0xD86C0500, 0x0D000064
.long 0xD86C0600, 0x15000064
.long 0xD86C0700, 0x1D000064
.long 0xD9FE0040, 0x28000065
.long 0xBF06400A
.long 0x854A4541
.long 0x854B8042
.long 0x80344A34
.long 0x82354B35
.long 0x80BC4A3C
.long 0x82BD4B3D
.long 0xBF06803D
.long 0xD3CD8004, 0x04124902
.long 0xD86C2100, 0x06000064
.long 0xD86C2200, 0x0E000064
.long 0xD86C2300, 0x16000064
.long 0x8536C13C
.long 0xBF8CC37F
.long 0xD1ED0000, 0x011E0B0D
.long 0xD1ED0001, 0x011E2B1D
.long 0xD1ED0002, 0x01220B0D
.long 0xD1ED0003, 0x01222B1D
.long 0xD3CD8000, 0x04024D00
.long 0xD86C2400, 0x1E000064
.long 0xD9FE0080, 0x2C000065
.long 0xBF06400A
.long 0xD3CD8004, 0x04124D02
.long 0xD86C2500, 0x07000064
.long 0xD86C2600, 0x0F000064
.long 0xD86C2700, 0x17000064
.long 0x854A4643
.long 0xBF8CC37F
.long 0xD1ED0000, 0x011E0D0E
.long 0xD1ED0001, 0x011E2D1E
.long 0xD1ED0002, 0x01220D0E
.long 0xD1ED0003, 0x01222D1E
.long 0xD3CD8000, 0x04025100
.long 0xD86C2800, 0x1F000064
.long 0xD9FE00C0, 0x30000065
.long 0x854B8044
.long 0xD3CD8004, 0x04125102
.long 0xD86C4200, 0x08000064
.long 0xD86C4300, 0x10000064
.long 0x80384A38
.long 0xBF8CC27F
.long 0xD1ED0000, 0x011E0F0F
.long 0xD1ED0001, 0x011E2F1F
.long 0xD1ED0002, 0x01220F0F
.long 0xD1ED0003, 0x01222F1F
.long 0xD3CD8000, 0x04025500
.long 0xD86C4400, 0x18000064
.long 0xD86C4500, 0x20000064
.long 0x82394B39
.long 0xD3CD8004, 0x04125502
.long 0xD86C4600, 0x09000064
.long 0xD86C4700, 0x11000064
.long 0x80BE4A3E
.long 0xBF8CC27F
.long 0xD1ED0000, 0x011E1110
.long 0xD1ED0001, 0x011E3120
.long 0xD1ED0002, 0x01221110
.long 0xD1ED0003, 0x01223120
.long 0xD3CD8000, 0x04025900
.long 0xD86C4800, 0x19000064
.long 0xD86C4900, 0x21000064
.long 0x82BF4B3F
.long 0xD3CD8004, 0x04125902
.long 0xD86C6300, 0x0A000064
.long 0xD86C6400, 0x12000064
.long 0xD86C6500, 0x1A000064
.long 0xD86C6600, 0x22000064
.long 0xD86C6700, 0x0B000064
.long 0xD86C6800, 0x13000064
.long 0xD86C6900, 0x1B000064
.long 0xD86C6A00, 0x23000064
.long 0xBF06803F
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xBF8CC87F
.long 0xD1ED0000, 0x011E1311
.long 0xD1ED0001, 0x011E3321
.long 0xD1ED0002, 0x01221311
.long 0xD1ED0003, 0x01223321
.long 0xD3CD8000, 0x04025D00
.long 0x853AC13E
.long 0xBF8C0F78
.long 0x7ED0ACF9, 0x00040642
.long 0x7E8014F9, 0x00061468
.long 0x7E8014F9, 0x00061569
.long 0x7ED0ACF9, 0x00050642
.long 0x7E8214F9, 0x00061468
.long 0x7E8214F9, 0x00061569
.long 0x7ED0ACF9, 0x00040643
.long 0x7E8414F9, 0x00061468
.long 0x7E8414F9, 0x00061569
.long 0x7ED0ACF9, 0x00050643
.long 0x7E8614F9, 0x00061468
.long 0x7E8614F9, 0x00061569
.long 0xD9BE0000, 0x00004034
.long 0xE0541000, 0x800D4236
.long 0xBF8C0F78
.long 0x7ED0ACF9, 0x00040646
.long 0x7E8814F9, 0x00061468
.long 0x7E8814F9, 0x00061569
.long 0x7ED0ACF9, 0x00050646
.long 0x7E8A14F9, 0x00061468
.long 0x7E8A14F9, 0x00061569
.long 0x7ED0ACF9, 0x00040647
.long 0x7E8C14F9, 0x00061468
.long 0x7E8C14F9, 0x00061569
.long 0x7ED0ACF9, 0x00050647
.long 0x7E8E14F9, 0x00061468
.long 0x7E8E14F9, 0x00061569
.long 0xD9BE0400, 0x00004434
.long 0xE0541000, 0x800D4637
.long 0xBF8C0F78
.long 0x7ED0ACF9, 0x0004064A
.long 0x7E9014F9, 0x00061468
.long 0x7E9014F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064A
.long 0x7E9214F9, 0x00061468
.long 0x7E9214F9, 0x00061569
.long 0x7ED0ACF9, 0x0004064B
.long 0x7E9414F9, 0x00061468
.long 0x7E9414F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064B
.long 0x7E9614F9, 0x00061468
.long 0x7E9614F9, 0x00061569
.long 0xD9BE0840, 0x00004834
.long 0xE0541000, 0x800D4A38
.long 0xBF8C0F78
.long 0x7ED0ACF9, 0x0004064E
.long 0x7E9814F9, 0x00061468
.long 0x7E9814F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064E
.long 0x7E9A14F9, 0x00061468
.long 0x7E9A14F9, 0x00061569
.long 0x7ED0ACF9, 0x0004064F
.long 0x7E9C14F9, 0x00061468
.long 0x7E9C14F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064F
.long 0x7E9E14F9, 0x00061468
.long 0x7E9E14F9, 0x00061569
.long 0xD9BE0C40, 0x00004C34
.long 0xE0541000, 0x800D4E39
.long 0xBF8C0F78
.long 0x7ED0ACF9, 0x00040652
.long 0x7EA014F9, 0x00061468
.long 0x7EA014F9, 0x00061569
.long 0x7ED0ACF9, 0x00050652
.long 0x7EA214F9, 0x00061468
.long 0x7EA214F9, 0x00061569
.long 0x7ED0ACF9, 0x00040653
.long 0x7EA414F9, 0x00061468
.long 0x7EA414F9, 0x00061569
.long 0x7ED0ACF9, 0x00050653
.long 0x7EA614F9, 0x00061468
.long 0x7EA614F9, 0x00061569
.long 0xD9BE1080, 0x00005034
.long 0xE0541000, 0x800D523A
.long 0xBF8C0F78
.long 0x7ED0ACF9, 0x00040656
.long 0x7EA814F9, 0x00061468
.long 0x7EA814F9, 0x00061569
.long 0x7ED0ACF9, 0x00050656
.long 0x7EAA14F9, 0x00061468
.long 0x7EAA14F9, 0x00061569
.long 0x7ED0ACF9, 0x00040657
.long 0x7EAC14F9, 0x00061468
.long 0x7EAC14F9, 0x00061569
.long 0x7ED0ACF9, 0x00050657
.long 0x7EAE14F9, 0x00061468
.long 0x7EAE14F9, 0x00061569
.long 0xD9BE1480, 0x00005434
.long 0xE0541000, 0x800D563B
.long 0xBF8C0F78
.long 0x7ED0ACF9, 0x0004065A
.long 0x7EB014F9, 0x00061468
.long 0x7EB014F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065A
.long 0x7EB214F9, 0x00061468
.long 0x7EB214F9, 0x00061569
.long 0x7ED0ACF9, 0x0004065B
.long 0x7EB414F9, 0x00061468
.long 0x7EB414F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065B
.long 0x7EB614F9, 0x00061468
.long 0x7EB614F9, 0x00061569
.long 0xD9BE18C0, 0x00005834
.long 0xE0541000, 0x800D5A3C
.long 0xBF8C0F78
.long 0x7ED0ACF9, 0x0004065E
.long 0x7EB814F9, 0x00061468
.long 0x7EB814F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065E
.long 0x7EBA14F9, 0x00061468
.long 0x7EBA14F9, 0x00061569
.long 0x7ED0ACF9, 0x0004065F
.long 0x7EBC14F9, 0x00061468
.long 0x7EBC14F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065F
.long 0x7EBE14F9, 0x00061468
.long 0x7EBE14F9, 0x00061569
.long 0xD9BE1CC0, 0x00005C34
.long 0xE0541000, 0x800D5E3D
.long 0xBF8C0F78
.long 0xD9BE0000, 0x00006035
.long 0xE05C1000, 0x800E603E
.long 0xD3CD8004, 0x04125D02
.long 0xBF8CCD7F
.long 0xD1ED0000, 0x011E1512
.long 0xD1ED0001, 0x011E3522
.long 0xD1ED0002, 0x01221512
.long 0xD1ED0003, 0x01223522
.long 0xD3CD8000, 0x04026100
.long 0xD3CD8004, 0x04126102
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xBF8CC07F
.long 0xD1ED0000, 0x011E1713
.long 0xD1ED0001, 0x011E3723
.long 0xD1ED0002, 0x01221713
.long 0xD1ED0003, 0x01223723
.long 0xD3CD8000, 0x04026500
.long 0xD86C0000, 0x04000064
.long 0xD86C0100, 0x0C000064
.long 0xD86C0200, 0x14000064
.long 0xD86C0300, 0x1C000064
.long 0xD9FE0000, 0x24000065
.long 0xD3CD8004, 0x04126502
.long 0x808A810A
.long 0xBF00820A
.long 0xBF84FE4A
.long 0xBF8CC07F
.long 0xD1ED0000, 0x011E090C
.long 0xD1ED0001, 0x011E291C
.long 0xD1ED0002, 0x0122090C
.long 0xD1ED0003, 0x0122291C
.long 0xD3CD8000, 0x04024900
.long 0xD86C0400, 0x05000064
.long 0xD86C0500, 0x0D000064
.long 0xD86C0600, 0x15000064
.long 0xD86C0700, 0x1D000064
.long 0xD9FE0040, 0x28000065
.long 0xBF06400A
.long 0x854A4541
.long 0x854B8042
.long 0x80344A34
.long 0x82354B35
.long 0x80BC4A3C
.long 0x82BD4B3D
.long 0xBF06803D
.long 0xD3CD8004, 0x04124902
.long 0xD86C2100, 0x06000064
.long 0xD86C2200, 0x0E000064
.long 0xD86C2300, 0x16000064
.long 0x8536C13C
.long 0xBF8CC37F
.long 0xD1ED0000, 0x011E0B0D
.long 0xD1ED0001, 0x011E2B1D
.long 0xD1ED0002, 0x01220B0D
.long 0xD1ED0003, 0x01222B1D
.long 0xD3CD8000, 0x04024D00
.long 0xD86C2400, 0x1E000064
.long 0xD9FE0080, 0x2C000065
.long 0xBF06400A
.long 0xD3CD8004, 0x04124D02
.long 0xD86C2500, 0x07000064
.long 0xD86C2600, 0x0F000064
.long 0xD86C2700, 0x17000064
.long 0x854A4643
.long 0xBF8CC37F
.long 0xD1ED0000, 0x011E0D0E
.long 0xD1ED0001, 0x011E2D1E
.long 0xD1ED0002, 0x01220D0E
.long 0xD1ED0003, 0x01222D1E
.long 0xD3CD8000, 0x04025100
.long 0xD86C2800, 0x1F000064
.long 0xD9FE00C0, 0x30000065
.long 0x854B8044
.long 0xD3CD8004, 0x04125102
.long 0xD86C4200, 0x08000064
.long 0xD86C4300, 0x10000064
.long 0x80384A38
.long 0xBF8CC27F
.long 0xD1ED0000, 0x011E0F0F
.long 0xD1ED0001, 0x011E2F1F
.long 0xD1ED0002, 0x01220F0F
.long 0xD1ED0003, 0x01222F1F
.long 0xD3CD8000, 0x04025500
.long 0xD86C4400, 0x18000064
.long 0xD86C4500, 0x20000064
.long 0x82394B39
.long 0xD3CD8004, 0x04125502
.long 0xD86C4600, 0x09000064
.long 0xD86C4700, 0x11000064
.long 0x80BE4A3E
.long 0xBF8CC27F
.long 0xD1ED0000, 0x011E1110
.long 0xD1ED0001, 0x011E3120
.long 0xD1ED0002, 0x01221110
.long 0xD1ED0003, 0x01223120
.long 0xD3CD8000, 0x04025900
.long 0xD86C4800, 0x19000064
.long 0xD86C4900, 0x21000064
.long 0x82BF4B3F
.long 0xD3CD8004, 0x04125902
.long 0xD86C6300, 0x0A000064
.long 0xD86C6400, 0x12000064
.long 0xD86C6500, 0x1A000064
.long 0xD86C6600, 0x22000064
.long 0xD86C6700, 0x0B000064
.long 0xD86C6800, 0x13000064
.long 0xD86C6900, 0x1B000064
.long 0xD86C6A00, 0x23000064
.long 0xBF06803F
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xBF8CC87F
.long 0xD1ED0000, 0x011E1311
.long 0xD1ED0001, 0x011E3321
.long 0xD1ED0002, 0x01221311
.long 0xD1ED0003, 0x01223321
.long 0xD3CD8000, 0x04025D00
.long 0x853AC13E
.long 0xBF8C0F78
.long 0x7ED0ACF9, 0x00040642
.long 0x7E8014F9, 0x00061468
.long 0x7E8014F9, 0x00061569
.long 0x7ED0ACF9, 0x00050642
.long 0x7E8214F9, 0x00061468
.long 0x7E8214F9, 0x00061569
.long 0x7ED0ACF9, 0x00040643
.long 0x7E8414F9, 0x00061468
.long 0x7E8414F9, 0x00061569
.long 0x7ED0ACF9, 0x00050643
.long 0x7E8614F9, 0x00061468
.long 0x7E8614F9, 0x00061569
.long 0xD9BE0000, 0x00004034
.long 0xBF8C0F77
.long 0x7ED0ACF9, 0x00040646
.long 0x7E8814F9, 0x00061468
.long 0x7E8814F9, 0x00061569
.long 0x7ED0ACF9, 0x00050646
.long 0x7E8A14F9, 0x00061468
.long 0x7E8A14F9, 0x00061569
.long 0x7ED0ACF9, 0x00040647
.long 0x7E8C14F9, 0x00061468
.long 0x7E8C14F9, 0x00061569
.long 0x7ED0ACF9, 0x00050647
.long 0x7E8E14F9, 0x00061468
.long 0x7E8E14F9, 0x00061569
.long 0xD9BE0400, 0x00004434
.long 0xBF8C0F76
.long 0x7ED0ACF9, 0x0004064A
.long 0x7E9014F9, 0x00061468
.long 0x7E9014F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064A
.long 0x7E9214F9, 0x00061468
.long 0x7E9214F9, 0x00061569
.long 0x7ED0ACF9, 0x0004064B
.long 0x7E9414F9, 0x00061468
.long 0x7E9414F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064B
.long 0x7E9614F9, 0x00061468
.long 0x7E9614F9, 0x00061569
.long 0xD9BE0840, 0x00004834
.long 0xBF8C0F75
.long 0x7ED0ACF9, 0x0004064E
.long 0x7E9814F9, 0x00061468
.long 0x7E9814F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064E
.long 0x7E9A14F9, 0x00061468
.long 0x7E9A14F9, 0x00061569
.long 0x7ED0ACF9, 0x0004064F
.long 0x7E9C14F9, 0x00061468
.long 0x7E9C14F9, 0x00061569
.long 0x7ED0ACF9, 0x0005064F
.long 0x7E9E14F9, 0x00061468
.long 0x7E9E14F9, 0x00061569
.long 0xD9BE0C40, 0x00004C34
.long 0xBF8C0F74
.long 0x7ED0ACF9, 0x00040652
.long 0x7EA014F9, 0x00061468
.long 0x7EA014F9, 0x00061569
.long 0x7ED0ACF9, 0x00050652
.long 0x7EA214F9, 0x00061468
.long 0x7EA214F9, 0x00061569
.long 0x7ED0ACF9, 0x00040653
.long 0x7EA414F9, 0x00061468
.long 0x7EA414F9, 0x00061569
.long 0x7ED0ACF9, 0x00050653
.long 0x7EA614F9, 0x00061468
.long 0x7EA614F9, 0x00061569
.long 0xD9BE1080, 0x00005034
.long 0xBF8C0F73
.long 0x7ED0ACF9, 0x00040656
.long 0x7EA814F9, 0x00061468
.long 0x7EA814F9, 0x00061569
.long 0x7ED0ACF9, 0x00050656
.long 0x7EAA14F9, 0x00061468
.long 0x7EAA14F9, 0x00061569
.long 0x7ED0ACF9, 0x00040657
.long 0x7EAC14F9, 0x00061468
.long 0x7EAC14F9, 0x00061569
.long 0x7ED0ACF9, 0x00050657
.long 0x7EAE14F9, 0x00061468
.long 0x7EAE14F9, 0x00061569
.long 0xD9BE1480, 0x00005434
.long 0xBF8C0F72
.long 0x7ED0ACF9, 0x0004065A
.long 0x7EB014F9, 0x00061468
.long 0x7EB014F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065A
.long 0x7EB214F9, 0x00061468
.long 0x7EB214F9, 0x00061569
.long 0x7ED0ACF9, 0x0004065B
.long 0x7EB414F9, 0x00061468
.long 0x7EB414F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065B
.long 0x7EB614F9, 0x00061468
.long 0x7EB614F9, 0x00061569
.long 0xD9BE18C0, 0x00005834
.long 0xBF8C0F71
.long 0x7ED0ACF9, 0x0004065E
.long 0x7EB814F9, 0x00061468
.long 0x7EB814F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065E
.long 0x7EBA14F9, 0x00061468
.long 0x7EBA14F9, 0x00061569
.long 0x7ED0ACF9, 0x0004065F
.long 0x7EBC14F9, 0x00061468
.long 0x7EBC14F9, 0x00061569
.long 0x7ED0ACF9, 0x0005065F
.long 0x7EBE14F9, 0x00061468
.long 0x7EBE14F9, 0x00061569
.long 0xD9BE1CC0, 0x00005C34
.long 0xBF8C0F70
.long 0xD9BE0000, 0x00006035
.long 0xD3CD8004, 0x04125D02
.long 0xBF8CCD7F
.long 0xD1ED0000, 0x011E1512
.long 0xD1ED0001, 0x011E3522
.long 0xD1ED0002, 0x01221512
.long 0xD1ED0003, 0x01223522
.long 0xD3CD8000, 0x04026100
.long 0xD3CD8004, 0x04126102
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xBF8CC07F
.long 0xD1ED0000, 0x011E1713
.long 0xD1ED0001, 0x011E3723
.long 0xD1ED0002, 0x01221713
.long 0xD1ED0003, 0x01223723
.long 0xD3CD8000, 0x04026500
.long 0xD86C0000, 0x04000064
.long 0xD86C0100, 0x0C000064
.long 0xD86C0200, 0x14000064
.long 0xD86C0300, 0x1C000064
.long 0xD9FE0000, 0x24000065
.long 0xD3CD8004, 0x04126502
.long 0xBF068132
.long 0xBF840102
.long 0xB4310000
.long 0xBF840100
.long 0xBF06F230
.long 0xBF8400FE
.long 0x864A1CFF, 0x0000007F
.long 0x804B14C1
.long 0xBF094B02
.long 0x854A804A
.long 0xB54A0000
.long 0xBF8500F7
.long 0x864A1D8F
.long 0x804B15C1
.long 0xBF094B03
.long 0x854A804A
.long 0xB54A0000
.long 0xBF8500F1
.long 0x864B1FFF, 0x0000007F
.long 0xBF06804B
.long 0xBF8400ED
.long 0xBF8CC07F
.long 0xD1ED0000, 0x011E090C
.long 0xD1ED0001, 0x011E291C
.long 0xD1ED0002, 0x0122090C
.long 0xD1ED0003, 0x0122291C
.long 0xD3CD8000, 0x04024900
.long 0xD86C0400, 0x05000064
.long 0xD86C0500, 0x0D000064
.long 0xD86C0600, 0x15000064
.long 0xD86C0700, 0x1D000064
.long 0xD9FE0040, 0x28000065
.long 0xD3CD8004, 0x04124902
.long 0xD86C2100, 0x06000064
.long 0xD86C2200, 0x0E000064
.long 0xD86C2300, 0x16000064
.long 0xBF8CC37F
.long 0xD1ED0000, 0x011E0B0D
.long 0xD1ED0001, 0x011E2B1D
.long 0xD1ED0002, 0x01220B0D
.long 0xD1ED0003, 0x01222B1D
.long 0xD3CD8000, 0x04024D00
.long 0xD86C2400, 0x1E000064
.long 0xD9FE0080, 0x2C000065
.long 0xD3CD8004, 0x04124D02
.long 0xD86C2500, 0x07000064
.long 0xD86C2600, 0x0F000064
.long 0xD86C2700, 0x17000064
.long 0xBF8CC37F
.long 0xD1ED0000, 0x011E0D0E
.long 0xD1ED0001, 0x011E2D1E
.long 0xD1ED0002, 0x01220D0E
.long 0xD1ED0003, 0x01222D1E
.long 0xD3CD8000, 0x04025100
.long 0xD86C2800, 0x1F000064
.long 0xD9FE00C0, 0x30000065
.long 0xD3CD8004, 0x04125102
.long 0xD86C4200, 0x08000064
.long 0xD86C4300, 0x10000064
.long 0xBF8CC27F
.long 0xD1ED0000, 0x011E0F0F
.long 0xD1ED0001, 0x011E2F1F
.long 0xD1ED0002, 0x01220F0F
.long 0xD1ED0003, 0x01222F1F
.long 0xD3CD8000, 0x04025500
.long 0xD86C4400, 0x18000064
.long 0xD86C4500, 0x20000064
.long 0xD3CD8004, 0x04125502
.long 0xD86C4600, 0x09000064
.long 0xD86C4700, 0x11000064
.long 0xBF8CC27F
.long 0xD1ED0000, 0x011E1110
.long 0xD1ED0001, 0x011E3120
.long 0xD1ED0002, 0x01221110
.long 0xD1ED0003, 0x01223120
.long 0xD3CD8000, 0x04025900
.long 0xD86C4800, 0x19000064
.long 0xD86C4900, 0x21000064
.long 0xD3CD8004, 0x04125902
.long 0xD86C6300, 0x0A000064
.long 0xD86C6400, 0x12000064
.long 0xD86C6500, 0x1A000064
.long 0xD86C6600, 0x22000064
.long 0xD86C6700, 0x0B000064
.long 0xD86C6800, 0x13000064
.long 0xD86C6900, 0x1B000064
.long 0xD86C6A00, 0x23000064
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xBF8CC87F
.long 0xD1ED0000, 0x011E1311
.long 0xD1ED0001, 0x011E3321
.long 0xD1ED0002, 0x01221311
.long 0xD1ED0003, 0x01223321
.long 0xD3CD8000, 0x04025D00
.long 0xD3CD8004, 0x04125D02
.long 0xBF8CC47F
.long 0xD1ED0000, 0x011E1512
.long 0xD1ED0001, 0x011E3522
.long 0xD1ED0002, 0x01221512
.long 0xD1ED0003, 0x01223522
.long 0xD3CD8000, 0x04026100
.long 0xD3CD8004, 0x04126102
.long 0xBF8CC07F
.long 0xD1ED0000, 0x011E1713
.long 0xD1ED0001, 0x011E3723
.long 0xD1ED0002, 0x01221713
.long 0xD1ED0003, 0x01223723
.long 0xD3CD8000, 0x04026500
.long 0xD3CD8004, 0x04126502
.long 0xC00A0D00, 0x0000005C
.long 0x2008CC86
.long 0x20020882
.long 0xD2850001, 0x00020290
.long 0x260ACC8F
.long 0xD1FE0001, 0x02020305
.long 0xD2850002, 0x00005501
.long 0xD2850003, 0x00005101
.long 0x260A0883
.long 0xD2850005, 0x00020A90
.long 0x2600CCBF
.long 0x20000084
.long 0x24000082
.long 0xD1FE0000, 0x02060105
.long 0x923302FF, 0x00000080
.long 0x68000033
.long 0x92330390
.long 0x68020233
.long 0xBF8CC07F
.long 0xD1FE0006, 0x02060103
.long 0xD3D84008, 0x18000100
.long 0xD3D84009, 0x18000104
.long 0xD3D8400A, 0x18000101
.long 0xD3D8400B, 0x18000105
.long 0xD3D8400C, 0x18000102
.long 0xD3D8400D, 0x18000106
.long 0xD3D8400E, 0x18000103
.long 0xD3D8400F, 0x18000107
.long 0xBF800001
.long 0xBF800000
.long 0x7E101508
.long 0x7E121509
.long 0xD2A00008, 0x00021308
.long 0x7E14150A
.long 0x7E16150B
.long 0xD2A00009, 0x0002170A
.long 0x7E18150C
.long 0x7E1A150D
.long 0xD2A0000A, 0x00021B0C
.long 0x7E1C150E
.long 0x7E1E150F
.long 0xD2A0000B, 0x00021F0E
.long 0xE07CD000, 0x80030806
.long 0xBF800000
.long 0xBF800000
.long 0xBF820000
.long 0xBF810000
.long 0xBF8CC07F
.long 0xD1ED0000, 0x011E090C
.long 0xD1ED0001, 0x011E291C
.long 0xD1ED0002, 0x0122090C
.long 0xD1ED0003, 0x0122291C
.long 0xD3CD8000, 0x04024900
.long 0xD86C0400, 0x05000064
.long 0xD86C0500, 0x0D000064
.long 0xD86C0600, 0x15000064
.long 0xD86C0700, 0x1D000064
.long 0xD9FE0040, 0x28000065
.long 0xD3CD8004, 0x04124902
.long 0xD86C2100, 0x06000064
.long 0xD86C2200, 0x0E000064
.long 0xD86C2300, 0x16000064
.long 0xBF8CC37F
.long 0xD1ED0000, 0x011E0B0D
.long 0xD1ED0001, 0x011E2B1D
.long 0xD1ED0002, 0x01220B0D
.long 0xD1ED0003, 0x01222B1D
.long 0xD3CD8000, 0x04024D00
.long 0xD86C2400, 0x1E000064
.long 0xD9FE0080, 0x2C000065
.long 0xD3CD8004, 0x04124D02
.long 0xD86C2500, 0x07000064
.long 0xD86C2600, 0x0F000064
.long 0xD86C2700, 0x17000064
.long 0xBF8CC37F
.long 0xD1ED0000, 0x011E0D0E
.long 0xD1ED0001, 0x011E2D1E
.long 0xD1ED0002, 0x01220D0E
.long 0xD1ED0003, 0x01222D1E
.long 0xD3CD8000, 0x04025100
.long 0xD86C2800, 0x1F000064
.long 0xD9FE00C0, 0x30000065
.long 0xD3CD8004, 0x04125102
.long 0xD86C4200, 0x08000064
.long 0xD86C4300, 0x10000064
.long 0xBF8CC27F
.long 0xD1ED0000, 0x011E0F0F
.long 0xD1ED0001, 0x011E2F1F
.long 0xD1ED0002, 0x01220F0F
.long 0xD1ED0003, 0x01222F1F
.long 0xD3CD8000, 0x04025500
.long 0xD86C4400, 0x18000064
.long 0xD86C4500, 0x20000064
.long 0xD3CD8004, 0x04125502
.long 0xD86C4600, 0x09000064
.long 0xD86C4700, 0x11000064
.long 0xBF8CC27F
.long 0xD1ED0000, 0x011E1110
.long 0xD1ED0001, 0x011E3120
.long 0xD1ED0002, 0x01221110
.long 0xD1ED0003, 0x01223120
.long 0xD3CD8000, 0x04025900
.long 0xD86C4800, 0x19000064
.long 0xD86C4900, 0x21000064
.long 0xD3CD8004, 0x04125902
.long 0xD86C6300, 0x0A000064
.long 0xD86C6400, 0x12000064
.long 0xD86C6500, 0x1A000064
.long 0xD86C6600, 0x22000064
.long 0xD86C6700, 0x0B000064
.long 0xD86C6800, 0x13000064
.long 0xD86C6900, 0x1B000064
.long 0xD86C6A00, 0x23000064
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xBF8CC87F
.long 0xD1ED0000, 0x011E1311
.long 0xD1ED0001, 0x011E3321
.long 0xD1ED0002, 0x01221311
.long 0xD1ED0003, 0x01223321
.long 0xD3CD8000, 0x04025D00
.long 0xD3CD8004, 0x04125D02
.long 0xBF8CC47F
.long 0xD1ED0000, 0x011E1512
.long 0xD1ED0001, 0x011E3522
.long 0xD1ED0002, 0x01221512
.long 0xD1ED0003, 0x01223522
.long 0xD3CD8000, 0x04026100
.long 0xD3CD8004, 0x04126102
.long 0xBF8CC07F
.long 0xD1ED0000, 0x011E1713
.long 0xD1ED0001, 0x011E3723
.long 0xD1ED0002, 0x01221713
.long 0xD1ED0003, 0x01223723
.long 0xD3CD8000, 0x04026500
.long 0xD3CD8004, 0x04126502
.long 0x860A1FFF, 0x0000007F
.long 0xBF070706
.long 0xBE8A0280
.long 0xBF06800A
.long 0xBE8B0080
.long 0xBF85027D
.long 0x81CA4083
.long 0x96CB454A
.long 0x924A454A
.long 0x80CA414A
.long 0x82CB424B
.long 0x80344A34
.long 0x82354B35
.long 0x80BC4A3C
.long 0x82BD4B3D
.long 0xBF06803D
.long 0x8536C13C
.long 0x81CA4083
.long 0x96CB464A
.long 0x924A464A
.long 0x80CA434A
.long 0x82CB444B
.long 0x80384A38
.long 0x82394B39
.long 0x80BE4A3E
.long 0x82BF4B3F
.long 0xBF06803F
.long 0x853AC13E
.long 0xE0801000, 0x800D4236
.long 0xE0801001, 0x800D0036
.long 0xE0841002, 0x800D0136
.long 0xE0841003, 0x800D0236
.long 0xE0801004, 0x800D4336
.long 0xE0801005, 0x800D0436
.long 0xE0841006, 0x800D0536
.long 0xE0841007, 0x800D0636
.long 0xBF8C0F76
.long 0x24000088
.long 0x28840142
.long 0xBF8C0F75
.long 0x28840342
.long 0xBF8C0F74
.long 0x24040488
.long 0x28840542
.long 0xBF8C0F72
.long 0x24080888
.long 0x28860943
.long 0xBF8C0F71
.long 0x28860B43
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x28860D43
.long 0xE0801000, 0x800D4637
.long 0xE0801001, 0x800D0037
.long 0xE0841002, 0x800D0137
.long 0xE0841003, 0x800D0237
.long 0xE0801004, 0x800D4737
.long 0xE0801005, 0x800D0437
.long 0xE0841006, 0x800D0537
.long 0xE0841007, 0x800D0637
.long 0xBF8C0F76
.long 0x24000088
.long 0x288C0146
.long 0xBF8C0F75
.long 0x288C0346
.long 0xBF8C0F74
.long 0x24040488
.long 0x288C0546
.long 0xBF8C0F72
.long 0x24080888
.long 0x288E0947
.long 0xBF8C0F71
.long 0x288E0B47
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x288E0D47
.long 0xE0801000, 0x800D4A38
.long 0xE0801001, 0x800D0038
.long 0xE0841002, 0x800D0138
.long 0xE0841003, 0x800D0238
.long 0xE0801004, 0x800D4B38
.long 0xE0801005, 0x800D0438
.long 0xE0841006, 0x800D0538
.long 0xE0841007, 0x800D0638
.long 0xBF8C0F76
.long 0x24000088
.long 0x2894014A
.long 0xBF8C0F75
.long 0x2894034A
.long 0xBF8C0F74
.long 0x24040488
.long 0x2894054A
.long 0xBF8C0F72
.long 0x24080888
.long 0x2896094B
.long 0xBF8C0F71
.long 0x28960B4B
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x28960D4B
.long 0xE0801000, 0x800D4E39
.long 0xE0801001, 0x800D0039
.long 0xE0841002, 0x800D0139
.long 0xE0841003, 0x800D0239
.long 0xE0801004, 0x800D4F39
.long 0xE0801005, 0x800D0439
.long 0xE0841006, 0x800D0539
.long 0xE0841007, 0x800D0639
.long 0xBF8C0F76
.long 0x24000088
.long 0x289C014E
.long 0xBF8C0F75
.long 0x289C034E
.long 0xBF8C0F74
.long 0x24040488
.long 0x289C054E
.long 0xBF8C0F72
.long 0x24080888
.long 0x289E094F
.long 0xBF8C0F71
.long 0x289E0B4F
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x289E0D4F
.long 0xE0801000, 0x800D523A
.long 0xE0801001, 0x800D003A
.long 0xE0841002, 0x800D013A
.long 0xE0841003, 0x800D023A
.long 0xE0801004, 0x800D533A
.long 0xE0801005, 0x800D043A
.long 0xE0841006, 0x800D053A
.long 0xE0841007, 0x800D063A
.long 0xBF8C0F76
.long 0x24000088
.long 0x28A40152
.long 0xBF8C0F75
.long 0x28A40352
.long 0xBF8C0F74
.long 0x24040488
.long 0x28A40552
.long 0xBF8C0F72
.long 0x24080888
.long 0x28A60953
.long 0xBF8C0F71
.long 0x28A60B53
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x28A60D53
.long 0xE0801000, 0x800D563B
.long 0xE0801001, 0x800D003B
.long 0xE0841002, 0x800D013B
.long 0xE0841003, 0x800D023B
.long 0xE0801004, 0x800D573B
.long 0xE0801005, 0x800D043B
.long 0xE0841006, 0x800D053B
.long 0xE0841007, 0x800D063B
.long 0xBF8C0F76
.long 0x24000088
.long 0x28AC0156
.long 0xBF8C0F75
.long 0x28AC0356
.long 0xBF8C0F74
.long 0x24040488
.long 0x28AC0556
.long 0xBF8C0F72
.long 0x24080888
.long 0x28AE0957
.long 0xBF8C0F71
.long 0x28AE0B57
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x28AE0D57
.long 0xE0801000, 0x800D5A3C
.long 0xE0801001, 0x800D003C
.long 0xE0841002, 0x800D013C
.long 0xE0841003, 0x800D023C
.long 0xE0801004, 0x800D5B3C
.long 0xE0801005, 0x800D043C
.long 0xE0841006, 0x800D053C
.long 0xE0841007, 0x800D063C
.long 0xBF8C0F76
.long 0x24000088
.long 0x28B4015A
.long 0xBF8C0F75
.long 0x28B4035A
.long 0xBF8C0F74
.long 0x24040488
.long 0x28B4055A
.long 0xBF8C0F72
.long 0x24080888
.long 0x28B6095B
.long 0xBF8C0F71
.long 0x28B60B5B
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x28B60D5B
.long 0xE0801000, 0x800D5E3D
.long 0xE0801001, 0x800D003D
.long 0xE0841002, 0x800D013D
.long 0xE0841003, 0x800D023D
.long 0xE0801004, 0x800D5F3D
.long 0xE0801005, 0x800D043D
.long 0xE0841006, 0x800D053D
.long 0xE0841007, 0x800D063D
.long 0xBF8C0F76
.long 0x24000088
.long 0x28BC015E
.long 0xBF8C0F75
.long 0x28BC035E
.long 0xBF8C0F74
.long 0x24040488
.long 0x28BC055E
.long 0xBF8C0F72
.long 0x24080888
.long 0x28BE095F
.long 0xBF8C0F71
.long 0x28BE0B5F
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x28BE0D5F
.long 0xE0901000, 0x800E603E
.long 0xE0941002, 0x800E003E
.long 0xBF8C0F70
.long 0x28C00160
.long 0xE0901004, 0x800E613E
.long 0xE0941006, 0x800E003E
.long 0xBF8C0F70
.long 0x28C20161
.long 0xE0901008, 0x800E623E
.long 0xE094100A, 0x800E003E
.long 0xBF8C0F70
.long 0x28C40162
.long 0xE090100C, 0x800E633E
.long 0xE094100E, 0x800E003E
.long 0xBF8C0F70
.long 0x28C60163
.long 0xBF8C0F70
.long 0xBF8A0000
.long 0x7E00ACF9, 0x00040642
.long 0x7E8014F9, 0x00061400
.long 0x7E8014F9, 0x00061501
.long 0x7E00ACF9, 0x00050642
.long 0x7E8214F9, 0x00061400
.long 0x7E8214F9, 0x00061501
.long 0x7E00ACF9, 0x00040643
.long 0x7E8414F9, 0x00061400
.long 0x7E8414F9, 0x00061501
.long 0x7E00ACF9, 0x00050643
.long 0x7E8614F9, 0x00061400
.long 0x7E8614F9, 0x00061501
.long 0xD9BE0000, 0x00004034
.long 0x7E00ACF9, 0x00040646
.long 0x7E8814F9, 0x00061400
.long 0x7E8814F9, 0x00061501
.long 0x7E00ACF9, 0x00050646
.long 0x7E8A14F9, 0x00061400
.long 0x7E8A14F9, 0x00061501
.long 0x7E00ACF9, 0x00040647
.long 0x7E8C14F9, 0x00061400
.long 0x7E8C14F9, 0x00061501
.long 0x7E00ACF9, 0x00050647
.long 0x7E8E14F9, 0x00061400
.long 0x7E8E14F9, 0x00061501
.long 0xD9BE0400, 0x00004434
.long 0x7E00ACF9, 0x0004064A
.long 0x7E9014F9, 0x00061400
.long 0x7E9014F9, 0x00061501
.long 0x7E00ACF9, 0x0005064A
.long 0x7E9214F9, 0x00061400
.long 0x7E9214F9, 0x00061501
.long 0x7E00ACF9, 0x0004064B
.long 0x7E9414F9, 0x00061400
.long 0x7E9414F9, 0x00061501
.long 0x7E00ACF9, 0x0005064B
.long 0x7E9614F9, 0x00061400
.long 0x7E9614F9, 0x00061501
.long 0xD9BE0840, 0x00004834
.long 0x7E00ACF9, 0x0004064E
.long 0x7E9814F9, 0x00061400
.long 0x7E9814F9, 0x00061501
.long 0x7E00ACF9, 0x0005064E
.long 0x7E9A14F9, 0x00061400
.long 0x7E9A14F9, 0x00061501
.long 0x7E00ACF9, 0x0004064F
.long 0x7E9C14F9, 0x00061400
.long 0x7E9C14F9, 0x00061501
.long 0x7E00ACF9, 0x0005064F
.long 0x7E9E14F9, 0x00061400
.long 0x7E9E14F9, 0x00061501
.long 0xD9BE0C40, 0x00004C34
.long 0x7E00ACF9, 0x00040652
.long 0x7EA014F9, 0x00061400
.long 0x7EA014F9, 0x00061501
.long 0x7E00ACF9, 0x00050652
.long 0x7EA214F9, 0x00061400
.long 0x7EA214F9, 0x00061501
.long 0x7E00ACF9, 0x00040653
.long 0x7EA414F9, 0x00061400
.long 0x7EA414F9, 0x00061501
.long 0x7E00ACF9, 0x00050653
.long 0x7EA614F9, 0x00061400
.long 0x7EA614F9, 0x00061501
.long 0xD9BE1080, 0x00005034
.long 0x7E00ACF9, 0x00040656
.long 0x7EA814F9, 0x00061400
.long 0x7EA814F9, 0x00061501
.long 0x7E00ACF9, 0x00050656
.long 0x7EAA14F9, 0x00061400
.long 0x7EAA14F9, 0x00061501
.long 0x7E00ACF9, 0x00040657
.long 0x7EAC14F9, 0x00061400
.long 0x7EAC14F9, 0x00061501
.long 0x7E00ACF9, 0x00050657
.long 0x7EAE14F9, 0x00061400
.long 0x7EAE14F9, 0x00061501
.long 0xD9BE1480, 0x00005434
.long 0x7E00ACF9, 0x0004065A
.long 0x7EB014F9, 0x00061400
.long 0x7EB014F9, 0x00061501
.long 0x7E00ACF9, 0x0005065A
.long 0x7EB214F9, 0x00061400
.long 0x7EB214F9, 0x00061501
.long 0x7E00ACF9, 0x0004065B
.long 0x7EB414F9, 0x00061400
.long 0x7EB414F9, 0x00061501
.long 0x7E00ACF9, 0x0005065B
.long 0x7EB614F9, 0x00061400
.long 0x7EB614F9, 0x00061501
.long 0xD9BE18C0, 0x00005834
.long 0x7E00ACF9, 0x0004065E
.long 0x7EB814F9, 0x00061400
.long 0x7EB814F9, 0x00061501
.long 0x7E00ACF9, 0x0005065E
.long 0x7EBA14F9, 0x00061400
.long 0x7EBA14F9, 0x00061501
.long 0x7E00ACF9, 0x0004065F
.long 0x7EBC14F9, 0x00061400
.long 0x7EBC14F9, 0x00061501
.long 0x7E00ACF9, 0x0005065F
.long 0x7EBE14F9, 0x00061400
.long 0x7EBE14F9, 0x00061501
.long 0xD9BE1CC0, 0x00005C34
.long 0xD9BE0000, 0x00006035
.long 0x2602CCBF
.long 0x2600028F
.long 0x20020284
.long 0x26020280
.long 0x24020284
.long 0x68000101
.long 0x24000081
.long 0x2602CCBF
.long 0x20020284
.long 0x24020289
.long 0x68000101
.long 0x2002CC86
.long 0x26020283
.long 0x24020285
.long 0x68000101
.long 0x2604CCBF
.long 0x2602048F
.long 0x24020287
.long 0x20040484
.long 0x26040480
.long 0x2404048B
.long 0x68020302
.long 0x2604CCBF
.long 0x20040484
.long 0x24040482
.long 0x68020302
.long 0x2004CC88
.long 0xBE8500FF, 0x00000080
.long 0xD2850002, 0x00020405
.long 0xD1FE0064, 0x02060102
.long 0x2006C88B
.long 0x24060686
.long 0x68C8C903
.long 0x2000CC88
.long 0xBE850090
.long 0xD2850000, 0x00020005
.long 0xD1FE0065, 0x02060300
.long 0x2004CA88
.long 0x24040485
.long 0x68CACB02
.long 0x32CACAFF, 0x00008400
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD86C0000, 0x04000064
.long 0xD86C0100, 0x0C000064
.long 0xD86C0200, 0x14000064
.long 0xD86C0300, 0x1C000064
.long 0xD8EC0000, 0x24000065
.long 0xBE8500FF, 0x00001080
.long 0x32C8C805
.long 0xBE8500A0
.long 0x32CACA05
.long 0xBF8CC07F
.long 0xD1ED0000, 0x011E090C
.long 0xD1ED0001, 0x011E291C
.long 0xD1ED0002, 0x0122090C
.long 0xD1ED0003, 0x0122291C
.long 0x2668CCBF
.long 0x20686884
.long 0x24686882
.long 0xD0C6004A, 0x00001534
.long 0xD1000000, 0x01290100
.long 0xD1000002, 0x01290102
.long 0xD1000001, 0x01290101
.long 0xD1000003, 0x01290103
.long 0xD1000024, 0x01290124
.long 0xD1000025, 0x01290125
.long 0x6A68680A
.long 0xD0C1004A, 0x00010934
.long 0x8649830A
.long 0x80C94984
.long 0x8E498449
.long 0xD28F0036, 0x00020049
.long 0xD1000000, 0x012A6D00
.long 0xD1000001, 0x012A6F01
.long 0xD28F0036, 0x00020449
.long 0xD1000002, 0x012A6D02
.long 0xD1000003, 0x012A6F03
.long 0xD28F0036, 0x00024849
.long 0xD1000024, 0x012A6D24
.long 0xD1000025, 0x012A6F25
.long 0xBF800001
.long 0xD3CD8000, 0x04024900
.long 0xD3CD8004, 0x04124902
.long 0x818A900A
.long 0x800B900B
.long 0xBF05800A
.long 0xBF84FFB6
.long 0xC00A0D00, 0x0000005C
.long 0x7E060202
.long 0x0C0606FF, 0xFFFFFF80
.long 0x3206061C
.long 0x7E0802FF, 0x00000080
.long 0xD0C9003C, 0x00020903
.long 0xD1000003, 0x00F20704
.long 0x200ACC86
.long 0x260A0A83
.long 0x200C0685
.long 0x260C0C83
.long 0xD0CA003C, 0x00020B06
.long 0xD1000003, 0x00F20704
.long 0x20080685
.long 0x240C0A80
.long 0x6A080D04
.long 0x200C0683
.long 0x200ECC84
.long 0x260E0E83
.long 0x240E0E83
.long 0x200E0E83
.long 0x240A0A82
.long 0x320E0F05
.long 0x6A0C0F06
.long 0x260A0687
.long 0x200A0A83
.long 0x260E0687
.long 0xD0CA006A, 0x00010307
.long 0xBF870013
.long 0xD0CA006A, 0x00010507
.long 0xBF870013
.long 0xD0CA006A, 0x00010707
.long 0xBF870013
.long 0xD0CA006A, 0x00010907
.long 0xBF870013
.long 0xD0CA006A, 0x00010B07
.long 0xBF870013
.long 0xD0CA006A, 0x00010D07
.long 0xBF870013
.long 0xD0CA006A, 0x00010F07
.long 0xBF870013
.long 0xBF8200D9
.long 0xD0CA006A, 0x00010104
.long 0xBF870012
.long 0xD0CA006A, 0x00010104
.long 0xBF870012
.long 0xD0CA006A, 0x00010104
.long 0xBF870012
.long 0xD0CA006A, 0x00010104
.long 0xBF870012
.long 0xD0CA006A, 0x00010104
.long 0xBF870012
.long 0xD0CA006A, 0x00010104
.long 0xBF870012
.long 0xD0CA006A, 0x00010104
.long 0xBF870012
.long 0xD0CA006A, 0x00010105
.long 0xBF870012
.long 0xD0CA006A, 0x00010105
.long 0xBF87001C
.long 0xD0CA006A, 0x00010105
.long 0xBF87002A
.long 0xD0CA006A, 0x00010105
.long 0xBF87003C
.long 0xD0CA006A, 0x00010105
.long 0xBF870052
.long 0xD0CA006A, 0x00010105
.long 0xBF87006C
.long 0xD0CA006A, 0x00010105
.long 0xBF87008A
.long 0xBEBC0080
.long 0xD0DA003C, 0x00007906
.long 0x2600CCBF
.long 0x24000082
.long 0xD3D84007, 0x18000107
.long 0xBF800001
.long 0xD3D94000, 0x18000107
.long 0xBEBC01C1
.long 0xBEEA213C
.long 0xBF8200A2
.long 0xBEBC0080
.long 0xD0DA003C, 0x00007906
.long 0x2600CCBF
.long 0x24000082
.long 0xD3D84007, 0x18000103
.long 0xD3D84008, 0x18000107
.long 0xBF800001
.long 0xD3D94000, 0x18000107
.long 0xD3D94004, 0x18000108
.long 0xBEBC01C1
.long 0xBEEA213C
.long 0xBF820091
.long 0xBEBC0080
.long 0xD0DA003C, 0x00007906
.long 0x2600CCBF
.long 0x24000082
.long 0xD3D84007, 0x18000106
.long 0xD3D84008, 0x18000103
.long 0xD3D84009, 0x18000107
.long 0xBF800001
.long 0xD3D94000, 0x18000107
.long 0xD3D94004, 0x18000108
.long 0xD3D94001, 0x18000109
.long 0xBEBC01C1
.long 0xBEEA213C
.long 0xBF82007C
.long 0xBEBC0080
.long 0xD0DA003C, 0x00007906
.long 0x2600CCBF
.long 0x24000082
.long 0xD3D84007, 0x18000102
.long 0xD3D84008, 0x18000106
.long 0xD3D84009, 0x18000103
.long 0xD3D8400A, 0x18000107
.long 0xBF800001
.long 0xD3D94000, 0x18000107
.long 0xD3D94004, 0x18000108
.long 0xD3D94001, 0x18000109
.long 0xD3D94005, 0x1800010A
.long 0xBEBC01C1
.long 0xBEEA213C
.long 0xBF820063
.long 0xBEBC0080
.long 0xD0DA003C, 0x00007906
.long 0x2600CCBF
.long 0x24000082
.long 0xD3D84007, 0x18000105
.long 0xD3D84008, 0x18000102
.long 0xD3D84009, 0x18000106
.long 0xD3D8400A, 0x18000103
.long 0xD3D8400B, 0x18000107
.long 0xBF800001
.long 0xD3D94000, 0x18000107
.long 0xD3D94004, 0x18000108
.long 0xD3D94001, 0x18000109
.long 0xD3D94005, 0x1800010A
.long 0xD3D94002, 0x1800010B
.long 0xBEBC01C1
.long 0xBEEA213C
.long 0xBF820046
.long 0xBEBC0080
.long 0xD0DA003C, 0x00007906
.long 0x2600CCBF
.long 0x24000082
.long 0xD3D84007, 0x18000101
.long 0xD3D84008, 0x18000105
.long 0xD3D84009, 0x18000102
.long 0xD3D8400A, 0x18000106
.long 0xD3D8400B, 0x18000103
.long 0xD3D8400C, 0x18000107
.long 0xBF800001
.long 0xD3D94000, 0x18000107
.long 0xD3D94004, 0x18000108
.long 0xD3D94001, 0x18000109
.long 0xD3D94005, 0x1800010A
.long 0xD3D94002, 0x1800010B
.long 0xD3D94006, 0x1800010C
.long 0xBEBC01C1
.long 0xBEEA213C
.long 0xBF820025
.long 0xBEBC0080
.long 0xD0DA003C, 0x00007906
.long 0x2600CCBF
.long 0x24000082
.long 0xD3D84007, 0x18000104
.long 0xD3D84008, 0x18000101
.long 0xD3D84009, 0x18000105
.long 0xD3D8400A, 0x18000102
.long 0xD3D8400B, 0x18000106
.long 0xD3D8400C, 0x18000103
.long 0xD3D8400D, 0x18000107
.long 0xBF800001
.long 0xD3D94000, 0x18000107
.long 0xD3D94004, 0x18000108
.long 0xD3D94001, 0x18000109
.long 0xD3D94005, 0x1800010A
.long 0xD3D94002, 0x1800010B
.long 0xD3D94006, 0x1800010C
.long 0xD3D94003, 0x1800010D
.long 0xBEBC01C1
.long 0xBEEA213C
.long 0xBF820000
.long 0x2008CC86
.long 0x20020882
.long 0xD2850001, 0x00020290
.long 0x260ACC8F
.long 0xD1FE0001, 0x02020305
.long 0xD2850002, 0x00005501
.long 0xD2850003, 0x00005101
.long 0x260A0883
.long 0xD2850005, 0x00020A90
.long 0x2600CCBF
.long 0x20000084
.long 0x24000082
.long 0xD1FE0000, 0x02060105
.long 0x923302FF, 0x00000080
.long 0x68000033
.long 0x92330390
.long 0x68020233
.long 0xBF8CC07F
.long 0xBF068132
.long 0xBF840006
.long 0xBEBC1C00
.long 0x813E84FF, 0x0000BFD8
.long 0x803C3E3C
.long 0x823D803D
.long 0xBE801D3C
.long 0xBEBB00FF, 0x00020000
.long 0xBEBA00FF, 0x80000000
.long 0x92330390
.long 0x963D2A33
.long 0x923C2A33
.long 0x8EBC813C
.long 0x80383C34
.long 0x82393D35
.long 0x963D042B
.long 0x923C042B
.long 0x8EBC813C
.long 0x80383C38
.long 0x82393D39
.long 0xB4310000
.long 0xBF8417E3
.long 0x863C1CFF, 0x0000007F
.long 0x803D14C1
.long 0xBF093D02
.long 0x853C803C
.long 0xB53C0000
.long 0xBF85063D
.long 0x863C1D8F
.long 0x803D15C1
.long 0xBF093D03
.long 0x853C803C
.long 0xB53C0000
.long 0xBF850637
.long 0xD1FE0006, 0x020A0103
.long 0xD1FE0007, 0x02060103
.long 0xD3D84010, 0x18000100
.long 0xD3D84011, 0x18000104
.long 0xD3D84012, 0x18000101
.long 0xD3D84013, 0x18000105
.long 0xD3D84014, 0x18000102
.long 0xD3D84015, 0x18000106
.long 0xD3D84016, 0x18000103
.long 0xD3D84017, 0x18000107
.long 0xBF800001
.long 0xE07CD000, 0x80031006
.long 0xE07CD010, 0x80031406
.long 0xBF800000
.long 0x923F1415
.long 0x9233043F
.long 0x923E1403
.long 0x803E023E
.long 0x803E333E
.long 0x7E660566
.long 0x923F1E3F
.long 0x8F338633
.long 0x9233333F
.long 0x803E3E33
.long 0x8E3E823E
.long 0x80183E36
.long 0x82198037
.long 0xBF8C0000
.long 0x80B38132
.long 0xC2330CCC, 0x00000000
.long 0x9645811C
.long 0x9244811C
.long 0x80C8811D
.long 0x92488148
.long 0x96472A48
.long 0x92462A48
.long 0x80444644
.long 0x82454745
.long 0x80C8811E
.long 0x92488148
.long 0x96472B48
.long 0x92462B48
.long 0x80444644
.long 0x82454745
.long 0x8EC08244
.long 0x7E1202FF, 0x80000000
.long 0xBEC40016
.long 0xBEC50017
.long 0xBEC6000E
.long 0xBEC7000F
.long 0xBF8CC07F
.long 0xBF068133
.long 0xBF8405F2
.long 0x2008CC86
.long 0x20020882
.long 0xD2850001, 0x00020290
.long 0x260ACCBF
.long 0x200A0A83
.long 0x68020305
.long 0xD2850002, 0x00005501
.long 0xD2850003, 0x00005101
.long 0x260A0883
.long 0xD2850005, 0x00020AA0
.long 0x2600CC87
.long 0x24000082
.long 0x68000105
.long 0x923302FF, 0x00000080
.long 0x68000033
.long 0x92330390
.long 0x68020233
.long 0xD1FE0006, 0x020A0103
.long 0xD1FE0007, 0x02060103
.long 0xD2850008, 0x000050A0
.long 0x68100D08
.long 0xE05CD000, 0x80111006
.long 0xE05CD000, 0x80111408
.long 0xBE850032
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8505AB
.long 0xE05CD000, 0x80116806
.long 0xE05CD000, 0x80116C08
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850598
.long 0xE05CD000, 0x80117006
.long 0xE05CD000, 0x80117408
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85057C
.long 0xE05CD000, 0x80117806
.long 0xE05CD000, 0x80117C08
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850557
.long 0xE05CD000, 0x80118006
.long 0xE05CD000, 0x80118408
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850529
.long 0xE05CD000, 0x80118806
.long 0xE05CD000, 0x80118C08
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8504F2
.long 0xE05CD000, 0x80119006
.long 0xE05CD000, 0x80119408
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8504B2
.long 0xE05CD000, 0x80119806
.long 0xE05CD000, 0x80119C08
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850469
.long 0xE05CD000, 0x8011A006
.long 0xE05CD000, 0x8011A408
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850417
.long 0xE05CD000, 0x8011A806
.long 0xE05CD000, 0x8011AC08
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8503BC
.long 0xE05CD000, 0x8011B006
.long 0xE05CD000, 0x8011B408
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850358
.long 0xE05CD000, 0x8011B806
.long 0xE05CD000, 0x8011BC08
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8502EB
.long 0xE05CD000, 0x8011C006
.long 0xE05CD000, 0x8011C408
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850275
.long 0xE05CD000, 0x8011C806
.long 0xE05CD000, 0x8011CC08
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8501F6
.long 0xE05CD000, 0x8011D006
.long 0xE05CD000, 0x8011D408
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85016E
.long 0xE05CD000, 0x8011D806
.long 0xE05CD000, 0x8011DC08
.long 0xBF8C4F7C
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85051D
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011680A
.long 0xE05CD000, 0x80116C0B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850505
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011700A
.long 0xE05CD000, 0x8011740B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8504ED
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011780A
.long 0xE05CD000, 0x80117C0B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8504D5
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011800A
.long 0xE05CD000, 0x8011840B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8504BD
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011880A
.long 0xE05CD000, 0x80118C0B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x18032110
.long 0xD3B24012, 0x18032512
.long 0xD3B24014, 0x18032914
.long 0xD3B24016, 0x18032D16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8504A5
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011900A
.long 0xE05CD000, 0x8011940B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x18033110
.long 0xD3B24012, 0x18033512
.long 0xD3B24014, 0x18033914
.long 0xD3B24016, 0x18033D16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85048D
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011980A
.long 0xE05CD000, 0x80119C0B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x18034110
.long 0xD3B24012, 0x18034512
.long 0xD3B24014, 0x18034914
.long 0xD3B24016, 0x18034D16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850475
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011A00A
.long 0xE05CD000, 0x8011A40B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x18035110
.long 0xD3B24012, 0x18035512
.long 0xD3B24014, 0x18035914
.long 0xD3B24016, 0x18035D16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85045D
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011A80A
.long 0xE05CD000, 0x8011AC0B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x18036110
.long 0xD3B24012, 0x18036512
.long 0xD3B24014, 0x18036914
.long 0xD3B24016, 0x18036D16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850445
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011B00A
.long 0xE05CD000, 0x8011B40B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x18037110
.long 0xD3B24012, 0x18037512
.long 0xD3B24014, 0x18037914
.long 0xD3B24016, 0x18037D16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85042D
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011B80A
.long 0xE05CD000, 0x8011BC0B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x18038110
.long 0xD3B24012, 0x18038512
.long 0xD3B24014, 0x18038914
.long 0xD3B24016, 0x18038D16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850415
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011C00A
.long 0xE05CD000, 0x8011C40B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x18039110
.long 0xD3B24012, 0x18039512
.long 0xD3B24014, 0x18039914
.long 0xD3B24016, 0x18039D16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8503FD
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011C80A
.long 0xE05CD000, 0x8011CC0B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x1803A110
.long 0xD3B24012, 0x1803A512
.long 0xD3B24014, 0x1803A914
.long 0xD3B24016, 0x1803AD16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8503E5
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011D00A
.long 0xE05CD000, 0x8011D40B
.long 0xBF8C4F7C
.long 0xD3B24010, 0x1803B110
.long 0xD3B24012, 0x1803B512
.long 0xD3B24014, 0x1803B914
.long 0xD3B24016, 0x1803BD16
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8503CD
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xD100000B, 0x010A1308
.long 0xE05CD000, 0x8011D80A
.long 0xE05CD000, 0x8011DC0B
.long 0xBF02CE05
.long 0xBF85FE96
.long 0xBF8C4F7A
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C4F78
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C4F76
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C4F74
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF8C4F72
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0xBF8C4F70
.long 0xD3B24010, 0x18032110
.long 0xD3B24012, 0x18032512
.long 0xD3B24014, 0x18032914
.long 0xD3B24016, 0x18032D16
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18033110
.long 0xD3B24012, 0x18033512
.long 0xD3B24014, 0x18033914
.long 0xD3B24016, 0x18033D16
.long 0xBF8C0F7C
.long 0xD3B24010, 0x18034110
.long 0xD3B24012, 0x18034512
.long 0xD3B24014, 0x18034914
.long 0xD3B24016, 0x18034D16
.long 0xBF8C0F7A
.long 0xD3B24010, 0x18035110
.long 0xD3B24012, 0x18035512
.long 0xD3B24014, 0x18035914
.long 0xD3B24016, 0x18035D16
.long 0xBF8C0F78
.long 0xD3B24010, 0x18036110
.long 0xD3B24012, 0x18036512
.long 0xD3B24014, 0x18036914
.long 0xD3B24016, 0x18036D16
.long 0xBF8C0F76
.long 0xD3B24010, 0x18037110
.long 0xD3B24012, 0x18037512
.long 0xD3B24014, 0x18037914
.long 0xD3B24016, 0x18037D16
.long 0xBF8C0F74
.long 0xD3B24010, 0x18038110
.long 0xD3B24012, 0x18038512
.long 0xD3B24014, 0x18038914
.long 0xD3B24016, 0x18038D16
.long 0xBF8C0F72
.long 0xD3B24010, 0x18039110
.long 0xD3B24012, 0x18039512
.long 0xD3B24014, 0x18039914
.long 0xD3B24016, 0x18039D16
.long 0xBF8C0F70
.long 0xD3B24010, 0x1803A110
.long 0xD3B24012, 0x1803A512
.long 0xD3B24014, 0x1803A914
.long 0xD3B24016, 0x1803AD16
.long 0xBF820340
.long 0xBF8C4F78
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C4F76
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C4F74
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C4F72
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF8C4F70
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18032110
.long 0xD3B24012, 0x18032512
.long 0xD3B24014, 0x18032914
.long 0xD3B24016, 0x18032D16
.long 0xBF8C0F7C
.long 0xD3B24010, 0x18033110
.long 0xD3B24012, 0x18033512
.long 0xD3B24014, 0x18033914
.long 0xD3B24016, 0x18033D16
.long 0xBF8C0F7A
.long 0xD3B24010, 0x18034110
.long 0xD3B24012, 0x18034512
.long 0xD3B24014, 0x18034914
.long 0xD3B24016, 0x18034D16
.long 0xBF8C0F78
.long 0xD3B24010, 0x18035110
.long 0xD3B24012, 0x18035512
.long 0xD3B24014, 0x18035914
.long 0xD3B24016, 0x18035D16
.long 0xBF8C0F76
.long 0xD3B24010, 0x18036110
.long 0xD3B24012, 0x18036512
.long 0xD3B24014, 0x18036914
.long 0xD3B24016, 0x18036D16
.long 0xBF8C0F74
.long 0xD3B24010, 0x18037110
.long 0xD3B24012, 0x18037512
.long 0xD3B24014, 0x18037914
.long 0xD3B24016, 0x18037D16
.long 0xBF8C0F72
.long 0xD3B24010, 0x18038110
.long 0xD3B24012, 0x18038512
.long 0xD3B24014, 0x18038914
.long 0xD3B24016, 0x18038D16
.long 0xBF8C0F70
.long 0xD3B24010, 0x18039110
.long 0xD3B24012, 0x18039512
.long 0xD3B24014, 0x18039914
.long 0xD3B24016, 0x18039D16
.long 0xBF8202CA
.long 0xBF8C4F76
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C4F74
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C4F72
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C4F70
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0xBF8C0F7C
.long 0xD3B24010, 0x18032110
.long 0xD3B24012, 0x18032512
.long 0xD3B24014, 0x18032914
.long 0xD3B24016, 0x18032D16
.long 0xBF8C0F7A
.long 0xD3B24010, 0x18033110
.long 0xD3B24012, 0x18033512
.long 0xD3B24014, 0x18033914
.long 0xD3B24016, 0x18033D16
.long 0xBF8C0F78
.long 0xD3B24010, 0x18034110
.long 0xD3B24012, 0x18034512
.long 0xD3B24014, 0x18034914
.long 0xD3B24016, 0x18034D16
.long 0xBF8C0F76
.long 0xD3B24010, 0x18035110
.long 0xD3B24012, 0x18035512
.long 0xD3B24014, 0x18035914
.long 0xD3B24016, 0x18035D16
.long 0xBF8C0F74
.long 0xD3B24010, 0x18036110
.long 0xD3B24012, 0x18036512
.long 0xD3B24014, 0x18036914
.long 0xD3B24016, 0x18036D16
.long 0xBF8C0F72
.long 0xD3B24010, 0x18037110
.long 0xD3B24012, 0x18037512
.long 0xD3B24014, 0x18037914
.long 0xD3B24016, 0x18037D16
.long 0xBF8C0F70
.long 0xD3B24010, 0x18038110
.long 0xD3B24012, 0x18038512
.long 0xD3B24014, 0x18038914
.long 0xD3B24016, 0x18038D16
.long 0xBF82025D
.long 0xBF8C4F74
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C4F72
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C4F70
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF8C0F7C
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0xBF8C0F7A
.long 0xD3B24010, 0x18032110
.long 0xD3B24012, 0x18032512
.long 0xD3B24014, 0x18032914
.long 0xD3B24016, 0x18032D16
.long 0xBF8C0F78
.long 0xD3B24010, 0x18033110
.long 0xD3B24012, 0x18033512
.long 0xD3B24014, 0x18033914
.long 0xD3B24016, 0x18033D16
.long 0xBF8C0F76
.long 0xD3B24010, 0x18034110
.long 0xD3B24012, 0x18034512
.long 0xD3B24014, 0x18034914
.long 0xD3B24016, 0x18034D16
.long 0xBF8C0F74
.long 0xD3B24010, 0x18035110
.long 0xD3B24012, 0x18035512
.long 0xD3B24014, 0x18035914
.long 0xD3B24016, 0x18035D16
.long 0xBF8C0F72
.long 0xD3B24010, 0x18036110
.long 0xD3B24012, 0x18036512
.long 0xD3B24014, 0x18036914
.long 0xD3B24016, 0x18036D16
.long 0xBF8C0F70
.long 0xD3B24010, 0x18037110
.long 0xD3B24012, 0x18037512
.long 0xD3B24014, 0x18037914
.long 0xD3B24016, 0x18037D16
.long 0xBF8201F9
.long 0xBF8C4F72
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C4F70
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C0F7C
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF8C0F7A
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0xBF8C0F78
.long 0xD3B24010, 0x18032110
.long 0xD3B24012, 0x18032512
.long 0xD3B24014, 0x18032914
.long 0xD3B24016, 0x18032D16
.long 0xBF8C0F76
.long 0xD3B24010, 0x18033110
.long 0xD3B24012, 0x18033512
.long 0xD3B24014, 0x18033914
.long 0xD3B24016, 0x18033D16
.long 0xBF8C0F74
.long 0xD3B24010, 0x18034110
.long 0xD3B24012, 0x18034512
.long 0xD3B24014, 0x18034914
.long 0xD3B24016, 0x18034D16
.long 0xBF8C0F72
.long 0xD3B24010, 0x18035110
.long 0xD3B24012, 0x18035512
.long 0xD3B24014, 0x18035914
.long 0xD3B24016, 0x18035D16
.long 0xBF8C0F70
.long 0xD3B24010, 0x18036110
.long 0xD3B24012, 0x18036512
.long 0xD3B24014, 0x18036914
.long 0xD3B24016, 0x18036D16
.long 0xBF82019E
.long 0xBF8C4F70
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C0F7A
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF8C0F78
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0xBF8C0F76
.long 0xD3B24010, 0x18032110
.long 0xD3B24012, 0x18032512
.long 0xD3B24014, 0x18032914
.long 0xD3B24016, 0x18032D16
.long 0xBF8C0F74
.long 0xD3B24010, 0x18033110
.long 0xD3B24012, 0x18033512
.long 0xD3B24014, 0x18033914
.long 0xD3B24016, 0x18033D16
.long 0xBF8C0F72
.long 0xD3B24010, 0x18034110
.long 0xD3B24012, 0x18034512
.long 0xD3B24014, 0x18034914
.long 0xD3B24016, 0x18034D16
.long 0xBF8C0F70
.long 0xD3B24010, 0x18035110
.long 0xD3B24012, 0x18035512
.long 0xD3B24014, 0x18035914
.long 0xD3B24016, 0x18035D16
.long 0xBF82014C
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C0F78
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF8C0F76
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0xBF8C0F74
.long 0xD3B24010, 0x18032110
.long 0xD3B24012, 0x18032512
.long 0xD3B24014, 0x18032914
.long 0xD3B24016, 0x18032D16
.long 0xBF8C0F72
.long 0xD3B24010, 0x18033110
.long 0xD3B24012, 0x18033512
.long 0xD3B24014, 0x18033914
.long 0xD3B24016, 0x18033D16
.long 0xBF8C0F70
.long 0xD3B24010, 0x18034110
.long 0xD3B24012, 0x18034512
.long 0xD3B24014, 0x18034914
.long 0xD3B24016, 0x18034D16
.long 0xBF820103
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C0F76
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF8C0F74
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0xBF8C0F72
.long 0xD3B24010, 0x18032110
.long 0xD3B24012, 0x18032512
.long 0xD3B24014, 0x18032914
.long 0xD3B24016, 0x18032D16
.long 0xBF8C0F70
.long 0xD3B24010, 0x18033110
.long 0xD3B24012, 0x18033512
.long 0xD3B24014, 0x18033914
.long 0xD3B24016, 0x18033D16
.long 0xBF8200C3
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C0F74
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF8C0F72
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0xBF8C0F70
.long 0xD3B24010, 0x18032110
.long 0xD3B24012, 0x18032512
.long 0xD3B24014, 0x18032914
.long 0xD3B24016, 0x18032D16
.long 0xBF82008C
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C0F72
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF8C0F70
.long 0xD3B24010, 0x18031110
.long 0xD3B24012, 0x18031512
.long 0xD3B24014, 0x18031914
.long 0xD3B24016, 0x18031D16
.long 0xBF82005E
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF8C0F70
.long 0xD3B24010, 0x18030110
.long 0xD3B24012, 0x18030512
.long 0xD3B24014, 0x18030914
.long 0xD3B24016, 0x18030D16
.long 0xBF820039
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802F110
.long 0xD3B24012, 0x1802F512
.long 0xD3B24014, 0x1802F914
.long 0xD3B24016, 0x1802FD16
.long 0xBF82001D
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802E110
.long 0xD3B24012, 0x1802E512
.long 0xD3B24014, 0x1802E914
.long 0xD3B24016, 0x1802ED16
.long 0xBF82000A
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802D110
.long 0xD3B24012, 0x1802D512
.long 0xD3B24014, 0x1802D914
.long 0xD3B24016, 0x1802DD16
.long 0xBF820000
.long 0x0A202030
.long 0x0A222230
.long 0x0A242430
.long 0x0A262630
.long 0x0A282830
.long 0x0A2A2A30
.long 0x0A2C2C30
.long 0x0A2E2E30
.long 0x7E201510
.long 0x7E221511
.long 0xD2A00010, 0x00022310
.long 0x7E241512
.long 0x7E261513
.long 0xD2A00011, 0x00022712
.long 0xE074D000, 0x800E1007
.long 0xD2850008, 0x00005090
.long 0x680E0F08
.long 0x7E281514
.long 0x7E2A1515
.long 0xD2A00012, 0x00022B14
.long 0x7E2C1516
.long 0x7E2E1517
.long 0xD2A00013, 0x00022F16
.long 0xE074D000, 0x800E1207
.long 0xBF800000
.long 0xBF800000
.long 0xBF822997
.long 0x7E3C02FF, 0x80000000
.long 0xD0C9003C, 0x00003900
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0006, 0x020A0103
.long 0xD1000006, 0x01020D1E
.long 0xD1FE0007, 0x02060103
.long 0xD1000007, 0x01020F1E
.long 0xD1196A04, 0x00010300
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0009, 0x020A0903
.long 0xD1000009, 0x0102131E
.long 0xD1FE000A, 0x02060903
.long 0xD100000A, 0x0102151E
.long 0xD1196A04, 0x00010500
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000C, 0x020A0903
.long 0xD100000C, 0x0102191E
.long 0xD1FE000D, 0x02060903
.long 0xD100000D, 0x01021B1E
.long 0xD1196A04, 0x00010700
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000F, 0x020A0903
.long 0xD100000F, 0x01021F1E
.long 0xD1FE0010, 0x02060903
.long 0xD1000010, 0x0102211E
.long 0xD1196A04, 0x00010900
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0012, 0x020A0903
.long 0xD1000012, 0x0102251E
.long 0xD1FE0013, 0x02060903
.long 0xD1000013, 0x0102271E
.long 0xD1196A04, 0x00010B00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0015, 0x020A0903
.long 0xD1000015, 0x01022B1E
.long 0xD1FE0016, 0x02060903
.long 0xD1000016, 0x01022D1E
.long 0xD1196A04, 0x00010D00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0018, 0x020A0903
.long 0xD1000018, 0x0102311E
.long 0xD1FE0019, 0x02060903
.long 0xD1000019, 0x0102331E
.long 0xD1196A04, 0x00010F00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE001B, 0x020A0903
.long 0xD100001B, 0x0102371E
.long 0xD1FE001C, 0x02060903
.long 0xD100001C, 0x0102391E
.long 0xD3D84008, 0x18000100
.long 0xD3D8400B, 0x18000104
.long 0xD3D8400E, 0x18000101
.long 0xD3D84011, 0x18000105
.long 0xD3D84014, 0x18000102
.long 0xD3D84017, 0x18000106
.long 0xD3D8401A, 0x18000103
.long 0xD3D8401D, 0x18000107
.long 0xBF800001
.long 0xE070D000, 0x80030806
.long 0xE070D000, 0x80030B09
.long 0xE070D000, 0x80030E0C
.long 0xE070D000, 0x8003110F
.long 0xE070D000, 0x80031412
.long 0xE070D000, 0x80031715
.long 0xE070D000, 0x80031A18
.long 0xE070D000, 0x80031D1B
.long 0xBF800000
.long 0x92431415
.long 0x92330443
.long 0x92421403
.long 0x80420242
.long 0x80423342
.long 0x7E660566
.long 0x92431E43
.long 0x8F338633
.long 0x92333343
.long 0x80424233
.long 0x8E428242
.long 0x80184236
.long 0x82198037
.long 0xBF8C0000
.long 0x80B38132
.long 0xC2330CCC, 0x00000000
.long 0x9649811C
.long 0x9248811C
.long 0x80CC811D
.long 0x924C814C
.long 0x964B2A4C
.long 0x924A2A4C
.long 0x80484A48
.long 0x82494B49
.long 0x80CC811E
.long 0x924C814C
.long 0x964B2B4C
.long 0x924A2B4C
.long 0x80484A48
.long 0x82494B49
.long 0x8EC48248
.long 0x7E3C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xBF8CC07F
.long 0xBF068133
.long 0xBF8410DA
.long 0xE050D000, 0x80120806
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x80126806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x80127006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x80127806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x80128006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x80128806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x80129006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x80129806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D806
.long 0xBF8C0F7E
.long 0x0210D108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012681F
.long 0xBF8C0F7E
.long 0x0210E108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012701F
.long 0xBF8C0F7E
.long 0x0210F108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012781F
.long 0xBF8C0F7E
.long 0x02110108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012801F
.long 0xBF8C0F7E
.long 0x02111108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012881F
.long 0xBF8C0F7E
.long 0x02112108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012901F
.long 0xBF8C0F7E
.long 0x02113108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012981F
.long 0xBF8C0F7E
.long 0x02114108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012A01F
.long 0xBF8C0F7E
.long 0x02115108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012A81F
.long 0xBF8C0F7E
.long 0x02116108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012B01F
.long 0xBF8C0F7E
.long 0x02117108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012B81F
.long 0xBF8C0F7E
.long 0x02118108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012C01F
.long 0xBF8C0F7E
.long 0x02119108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012C81F
.long 0xBF8C0F7E
.long 0x0211A108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012D01F
.long 0xBF8C0F7E
.long 0x0211B108
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D06
.long 0xE050D000, 0x8012D81F
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x0210D108
.long 0xBF8C0F7C
.long 0x0210E108
.long 0xBF8C0F7B
.long 0x0210F108
.long 0xBF8C0F7A
.long 0x02110108
.long 0xBF8C0F79
.long 0x02111108
.long 0xBF8C0F78
.long 0x02112108
.long 0xBF8C0F77
.long 0x02113108
.long 0xBF8C0F76
.long 0x02114108
.long 0xBF8C0F75
.long 0x02115108
.long 0xBF8C0F74
.long 0x02116108
.long 0xBF8C0F73
.long 0x02117108
.long 0xBF8C0F72
.long 0x02118108
.long 0xBF8C0F71
.long 0x02119108
.long 0xBF8C0F70
.long 0x0211A108
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x0210D108
.long 0xBF8C0F7B
.long 0x0210E108
.long 0xBF8C0F7A
.long 0x0210F108
.long 0xBF8C0F79
.long 0x02110108
.long 0xBF8C0F78
.long 0x02111108
.long 0xBF8C0F77
.long 0x02112108
.long 0xBF8C0F76
.long 0x02113108
.long 0xBF8C0F75
.long 0x02114108
.long 0xBF8C0F74
.long 0x02115108
.long 0xBF8C0F73
.long 0x02116108
.long 0xBF8C0F72
.long 0x02117108
.long 0xBF8C0F71
.long 0x02118108
.long 0xBF8C0F70
.long 0x02119108
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x0210D108
.long 0xBF8C0F7A
.long 0x0210E108
.long 0xBF8C0F79
.long 0x0210F108
.long 0xBF8C0F78
.long 0x02110108
.long 0xBF8C0F77
.long 0x02111108
.long 0xBF8C0F76
.long 0x02112108
.long 0xBF8C0F75
.long 0x02113108
.long 0xBF8C0F74
.long 0x02114108
.long 0xBF8C0F73
.long 0x02115108
.long 0xBF8C0F72
.long 0x02116108
.long 0xBF8C0F71
.long 0x02117108
.long 0xBF8C0F70
.long 0x02118108
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x0210D108
.long 0xBF8C0F79
.long 0x0210E108
.long 0xBF8C0F78
.long 0x0210F108
.long 0xBF8C0F77
.long 0x02110108
.long 0xBF8C0F76
.long 0x02111108
.long 0xBF8C0F75
.long 0x02112108
.long 0xBF8C0F74
.long 0x02113108
.long 0xBF8C0F73
.long 0x02114108
.long 0xBF8C0F72
.long 0x02115108
.long 0xBF8C0F71
.long 0x02116108
.long 0xBF8C0F70
.long 0x02117108
.long 0xBF820078
.long 0xBF8C0F79
.long 0x0210D108
.long 0xBF8C0F78
.long 0x0210E108
.long 0xBF8C0F77
.long 0x0210F108
.long 0xBF8C0F76
.long 0x02110108
.long 0xBF8C0F75
.long 0x02111108
.long 0xBF8C0F74
.long 0x02112108
.long 0xBF8C0F73
.long 0x02113108
.long 0xBF8C0F72
.long 0x02114108
.long 0xBF8C0F71
.long 0x02115108
.long 0xBF8C0F70
.long 0x02116108
.long 0xBF820063
.long 0xBF8C0F78
.long 0x0210D108
.long 0xBF8C0F77
.long 0x0210E108
.long 0xBF8C0F76
.long 0x0210F108
.long 0xBF8C0F75
.long 0x02110108
.long 0xBF8C0F74
.long 0x02111108
.long 0xBF8C0F73
.long 0x02112108
.long 0xBF8C0F72
.long 0x02113108
.long 0xBF8C0F71
.long 0x02114108
.long 0xBF8C0F70
.long 0x02115108
.long 0xBF820050
.long 0xBF8C0F77
.long 0x0210D108
.long 0xBF8C0F76
.long 0x0210E108
.long 0xBF8C0F75
.long 0x0210F108
.long 0xBF8C0F74
.long 0x02110108
.long 0xBF8C0F73
.long 0x02111108
.long 0xBF8C0F72
.long 0x02112108
.long 0xBF8C0F71
.long 0x02113108
.long 0xBF8C0F70
.long 0x02114108
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x0210D108
.long 0xBF8C0F75
.long 0x0210E108
.long 0xBF8C0F74
.long 0x0210F108
.long 0xBF8C0F73
.long 0x02110108
.long 0xBF8C0F72
.long 0x02111108
.long 0xBF8C0F71
.long 0x02112108
.long 0xBF8C0F70
.long 0x02113108
.long 0xBF820030
.long 0xBF8C0F75
.long 0x0210D108
.long 0xBF8C0F74
.long 0x0210E108
.long 0xBF8C0F73
.long 0x0210F108
.long 0xBF8C0F72
.long 0x02110108
.long 0xBF8C0F71
.long 0x02111108
.long 0xBF8C0F70
.long 0x02112108
.long 0xBF820023
.long 0xBF8C0F74
.long 0x0210D108
.long 0xBF8C0F73
.long 0x0210E108
.long 0xBF8C0F72
.long 0x0210F108
.long 0xBF8C0F71
.long 0x02110108
.long 0xBF8C0F70
.long 0x02111108
.long 0xBF820018
.long 0xBF8C0F73
.long 0x0210D108
.long 0xBF8C0F72
.long 0x0210E108
.long 0xBF8C0F71
.long 0x0210F108
.long 0xBF8C0F70
.long 0x02110108
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x0210D108
.long 0xBF8C0F71
.long 0x0210E108
.long 0xBF8C0F70
.long 0x0210F108
.long 0xBF820008
.long 0xBF8C0F71
.long 0x0210D108
.long 0xBF8C0F70
.long 0x0210E108
.long 0xBF820003
.long 0xBF8C0F70
.long 0x0210D108
.long 0xBF820000
.long 0x7E3C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80120B09
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x80126809
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x80127009
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x80127809
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x80128009
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x80128809
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x80129009
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x80129809
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A009
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A809
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B009
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B809
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C009
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C809
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D009
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D809
.long 0xBF8C0F7E
.long 0x0216D10B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012681F
.long 0xBF8C0F7E
.long 0x0216E10B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012701F
.long 0xBF8C0F7E
.long 0x0216F10B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012781F
.long 0xBF8C0F7E
.long 0x0217010B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012801F
.long 0xBF8C0F7E
.long 0x0217110B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012881F
.long 0xBF8C0F7E
.long 0x0217210B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012901F
.long 0xBF8C0F7E
.long 0x0217310B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012981F
.long 0xBF8C0F7E
.long 0x0217410B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012A01F
.long 0xBF8C0F7E
.long 0x0217510B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012A81F
.long 0xBF8C0F7E
.long 0x0217610B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012B01F
.long 0xBF8C0F7E
.long 0x0217710B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012B81F
.long 0xBF8C0F7E
.long 0x0217810B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012C01F
.long 0xBF8C0F7E
.long 0x0217910B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012C81F
.long 0xBF8C0F7E
.long 0x0217A10B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012D01F
.long 0xBF8C0F7E
.long 0x0217B10B
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D09
.long 0xE050D000, 0x8012D81F
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x0216D10B
.long 0xBF8C0F7C
.long 0x0216E10B
.long 0xBF8C0F7B
.long 0x0216F10B
.long 0xBF8C0F7A
.long 0x0217010B
.long 0xBF8C0F79
.long 0x0217110B
.long 0xBF8C0F78
.long 0x0217210B
.long 0xBF8C0F77
.long 0x0217310B
.long 0xBF8C0F76
.long 0x0217410B
.long 0xBF8C0F75
.long 0x0217510B
.long 0xBF8C0F74
.long 0x0217610B
.long 0xBF8C0F73
.long 0x0217710B
.long 0xBF8C0F72
.long 0x0217810B
.long 0xBF8C0F71
.long 0x0217910B
.long 0xBF8C0F70
.long 0x0217A10B
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x0216D10B
.long 0xBF8C0F7B
.long 0x0216E10B
.long 0xBF8C0F7A
.long 0x0216F10B
.long 0xBF8C0F79
.long 0x0217010B
.long 0xBF8C0F78
.long 0x0217110B
.long 0xBF8C0F77
.long 0x0217210B
.long 0xBF8C0F76
.long 0x0217310B
.long 0xBF8C0F75
.long 0x0217410B
.long 0xBF8C0F74
.long 0x0217510B
.long 0xBF8C0F73
.long 0x0217610B
.long 0xBF8C0F72
.long 0x0217710B
.long 0xBF8C0F71
.long 0x0217810B
.long 0xBF8C0F70
.long 0x0217910B
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x0216D10B
.long 0xBF8C0F7A
.long 0x0216E10B
.long 0xBF8C0F79
.long 0x0216F10B
.long 0xBF8C0F78
.long 0x0217010B
.long 0xBF8C0F77
.long 0x0217110B
.long 0xBF8C0F76
.long 0x0217210B
.long 0xBF8C0F75
.long 0x0217310B
.long 0xBF8C0F74
.long 0x0217410B
.long 0xBF8C0F73
.long 0x0217510B
.long 0xBF8C0F72
.long 0x0217610B
.long 0xBF8C0F71
.long 0x0217710B
.long 0xBF8C0F70
.long 0x0217810B
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x0216D10B
.long 0xBF8C0F79
.long 0x0216E10B
.long 0xBF8C0F78
.long 0x0216F10B
.long 0xBF8C0F77
.long 0x0217010B
.long 0xBF8C0F76
.long 0x0217110B
.long 0xBF8C0F75
.long 0x0217210B
.long 0xBF8C0F74
.long 0x0217310B
.long 0xBF8C0F73
.long 0x0217410B
.long 0xBF8C0F72
.long 0x0217510B
.long 0xBF8C0F71
.long 0x0217610B
.long 0xBF8C0F70
.long 0x0217710B
.long 0xBF820078
.long 0xBF8C0F79
.long 0x0216D10B
.long 0xBF8C0F78
.long 0x0216E10B
.long 0xBF8C0F77
.long 0x0216F10B
.long 0xBF8C0F76
.long 0x0217010B
.long 0xBF8C0F75
.long 0x0217110B
.long 0xBF8C0F74
.long 0x0217210B
.long 0xBF8C0F73
.long 0x0217310B
.long 0xBF8C0F72
.long 0x0217410B
.long 0xBF8C0F71
.long 0x0217510B
.long 0xBF8C0F70
.long 0x0217610B
.long 0xBF820063
.long 0xBF8C0F78
.long 0x0216D10B
.long 0xBF8C0F77
.long 0x0216E10B
.long 0xBF8C0F76
.long 0x0216F10B
.long 0xBF8C0F75
.long 0x0217010B
.long 0xBF8C0F74
.long 0x0217110B
.long 0xBF8C0F73
.long 0x0217210B
.long 0xBF8C0F72
.long 0x0217310B
.long 0xBF8C0F71
.long 0x0217410B
.long 0xBF8C0F70
.long 0x0217510B
.long 0xBF820050
.long 0xBF8C0F77
.long 0x0216D10B
.long 0xBF8C0F76
.long 0x0216E10B
.long 0xBF8C0F75
.long 0x0216F10B
.long 0xBF8C0F74
.long 0x0217010B
.long 0xBF8C0F73
.long 0x0217110B
.long 0xBF8C0F72
.long 0x0217210B
.long 0xBF8C0F71
.long 0x0217310B
.long 0xBF8C0F70
.long 0x0217410B
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x0216D10B
.long 0xBF8C0F75
.long 0x0216E10B
.long 0xBF8C0F74
.long 0x0216F10B
.long 0xBF8C0F73
.long 0x0217010B
.long 0xBF8C0F72
.long 0x0217110B
.long 0xBF8C0F71
.long 0x0217210B
.long 0xBF8C0F70
.long 0x0217310B
.long 0xBF820030
.long 0xBF8C0F75
.long 0x0216D10B
.long 0xBF8C0F74
.long 0x0216E10B
.long 0xBF8C0F73
.long 0x0216F10B
.long 0xBF8C0F72
.long 0x0217010B
.long 0xBF8C0F71
.long 0x0217110B
.long 0xBF8C0F70
.long 0x0217210B
.long 0xBF820023
.long 0xBF8C0F74
.long 0x0216D10B
.long 0xBF8C0F73
.long 0x0216E10B
.long 0xBF8C0F72
.long 0x0216F10B
.long 0xBF8C0F71
.long 0x0217010B
.long 0xBF8C0F70
.long 0x0217110B
.long 0xBF820018
.long 0xBF8C0F73
.long 0x0216D10B
.long 0xBF8C0F72
.long 0x0216E10B
.long 0xBF8C0F71
.long 0x0216F10B
.long 0xBF8C0F70
.long 0x0217010B
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x0216D10B
.long 0xBF8C0F71
.long 0x0216E10B
.long 0xBF8C0F70
.long 0x0216F10B
.long 0xBF820008
.long 0xBF8C0F71
.long 0x0216D10B
.long 0xBF8C0F70
.long 0x0216E10B
.long 0xBF820003
.long 0xBF8C0F70
.long 0x0216D10B
.long 0xBF820000
.long 0x7E3C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80120E0C
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x8012680C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x8012700C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x8012780C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x8012800C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x8012880C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x8012900C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x8012980C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A00C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A80C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B00C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B80C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C00C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C80C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D00C
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D80C
.long 0xBF8C0F7E
.long 0x021CD10E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012681F
.long 0xBF8C0F7E
.long 0x021CE10E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012701F
.long 0xBF8C0F7E
.long 0x021CF10E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012781F
.long 0xBF8C0F7E
.long 0x021D010E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012801F
.long 0xBF8C0F7E
.long 0x021D110E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012881F
.long 0xBF8C0F7E
.long 0x021D210E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012901F
.long 0xBF8C0F7E
.long 0x021D310E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012981F
.long 0xBF8C0F7E
.long 0x021D410E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012A01F
.long 0xBF8C0F7E
.long 0x021D510E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012A81F
.long 0xBF8C0F7E
.long 0x021D610E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012B01F
.long 0xBF8C0F7E
.long 0x021D710E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012B81F
.long 0xBF8C0F7E
.long 0x021D810E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012C01F
.long 0xBF8C0F7E
.long 0x021D910E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012C81F
.long 0xBF8C0F7E
.long 0x021DA10E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012D01F
.long 0xBF8C0F7E
.long 0x021DB10E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0C
.long 0xE050D000, 0x8012D81F
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x021CD10E
.long 0xBF8C0F7C
.long 0x021CE10E
.long 0xBF8C0F7B
.long 0x021CF10E
.long 0xBF8C0F7A
.long 0x021D010E
.long 0xBF8C0F79
.long 0x021D110E
.long 0xBF8C0F78
.long 0x021D210E
.long 0xBF8C0F77
.long 0x021D310E
.long 0xBF8C0F76
.long 0x021D410E
.long 0xBF8C0F75
.long 0x021D510E
.long 0xBF8C0F74
.long 0x021D610E
.long 0xBF8C0F73
.long 0x021D710E
.long 0xBF8C0F72
.long 0x021D810E
.long 0xBF8C0F71
.long 0x021D910E
.long 0xBF8C0F70
.long 0x021DA10E
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x021CD10E
.long 0xBF8C0F7B
.long 0x021CE10E
.long 0xBF8C0F7A
.long 0x021CF10E
.long 0xBF8C0F79
.long 0x021D010E
.long 0xBF8C0F78
.long 0x021D110E
.long 0xBF8C0F77
.long 0x021D210E
.long 0xBF8C0F76
.long 0x021D310E
.long 0xBF8C0F75
.long 0x021D410E
.long 0xBF8C0F74
.long 0x021D510E
.long 0xBF8C0F73
.long 0x021D610E
.long 0xBF8C0F72
.long 0x021D710E
.long 0xBF8C0F71
.long 0x021D810E
.long 0xBF8C0F70
.long 0x021D910E
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x021CD10E
.long 0xBF8C0F7A
.long 0x021CE10E
.long 0xBF8C0F79
.long 0x021CF10E
.long 0xBF8C0F78
.long 0x021D010E
.long 0xBF8C0F77
.long 0x021D110E
.long 0xBF8C0F76
.long 0x021D210E
.long 0xBF8C0F75
.long 0x021D310E
.long 0xBF8C0F74
.long 0x021D410E
.long 0xBF8C0F73
.long 0x021D510E
.long 0xBF8C0F72
.long 0x021D610E
.long 0xBF8C0F71
.long 0x021D710E
.long 0xBF8C0F70
.long 0x021D810E
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x021CD10E
.long 0xBF8C0F79
.long 0x021CE10E
.long 0xBF8C0F78
.long 0x021CF10E
.long 0xBF8C0F77
.long 0x021D010E
.long 0xBF8C0F76
.long 0x021D110E
.long 0xBF8C0F75
.long 0x021D210E
.long 0xBF8C0F74
.long 0x021D310E
.long 0xBF8C0F73
.long 0x021D410E
.long 0xBF8C0F72
.long 0x021D510E
.long 0xBF8C0F71
.long 0x021D610E
.long 0xBF8C0F70
.long 0x021D710E
.long 0xBF820078
.long 0xBF8C0F79
.long 0x021CD10E
.long 0xBF8C0F78
.long 0x021CE10E
.long 0xBF8C0F77
.long 0x021CF10E
.long 0xBF8C0F76
.long 0x021D010E
.long 0xBF8C0F75
.long 0x021D110E
.long 0xBF8C0F74
.long 0x021D210E
.long 0xBF8C0F73
.long 0x021D310E
.long 0xBF8C0F72
.long 0x021D410E
.long 0xBF8C0F71
.long 0x021D510E
.long 0xBF8C0F70
.long 0x021D610E
.long 0xBF820063
.long 0xBF8C0F78
.long 0x021CD10E
.long 0xBF8C0F77
.long 0x021CE10E
.long 0xBF8C0F76
.long 0x021CF10E
.long 0xBF8C0F75
.long 0x021D010E
.long 0xBF8C0F74
.long 0x021D110E
.long 0xBF8C0F73
.long 0x021D210E
.long 0xBF8C0F72
.long 0x021D310E
.long 0xBF8C0F71
.long 0x021D410E
.long 0xBF8C0F70
.long 0x021D510E
.long 0xBF820050
.long 0xBF8C0F77
.long 0x021CD10E
.long 0xBF8C0F76
.long 0x021CE10E
.long 0xBF8C0F75
.long 0x021CF10E
.long 0xBF8C0F74
.long 0x021D010E
.long 0xBF8C0F73
.long 0x021D110E
.long 0xBF8C0F72
.long 0x021D210E
.long 0xBF8C0F71
.long 0x021D310E
.long 0xBF8C0F70
.long 0x021D410E
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x021CD10E
.long 0xBF8C0F75
.long 0x021CE10E
.long 0xBF8C0F74
.long 0x021CF10E
.long 0xBF8C0F73
.long 0x021D010E
.long 0xBF8C0F72
.long 0x021D110E
.long 0xBF8C0F71
.long 0x021D210E
.long 0xBF8C0F70
.long 0x021D310E
.long 0xBF820030
.long 0xBF8C0F75
.long 0x021CD10E
.long 0xBF8C0F74
.long 0x021CE10E
.long 0xBF8C0F73
.long 0x021CF10E
.long 0xBF8C0F72
.long 0x021D010E
.long 0xBF8C0F71
.long 0x021D110E
.long 0xBF8C0F70
.long 0x021D210E
.long 0xBF820023
.long 0xBF8C0F74
.long 0x021CD10E
.long 0xBF8C0F73
.long 0x021CE10E
.long 0xBF8C0F72
.long 0x021CF10E
.long 0xBF8C0F71
.long 0x021D010E
.long 0xBF8C0F70
.long 0x021D110E
.long 0xBF820018
.long 0xBF8C0F73
.long 0x021CD10E
.long 0xBF8C0F72
.long 0x021CE10E
.long 0xBF8C0F71
.long 0x021CF10E
.long 0xBF8C0F70
.long 0x021D010E
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x021CD10E
.long 0xBF8C0F71
.long 0x021CE10E
.long 0xBF8C0F70
.long 0x021CF10E
.long 0xBF820008
.long 0xBF8C0F71
.long 0x021CD10E
.long 0xBF8C0F70
.long 0x021CE10E
.long 0xBF820003
.long 0xBF8C0F70
.long 0x021CD10E
.long 0xBF820000
.long 0x7E3C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x8012110F
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x8012680F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x8012700F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x8012780F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x8012800F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x8012880F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x8012900F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x8012980F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A00F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A80F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B00F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B80F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C00F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C80F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D00F
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D80F
.long 0xBF8C0F7E
.long 0x0222D111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012681F
.long 0xBF8C0F7E
.long 0x0222E111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012701F
.long 0xBF8C0F7E
.long 0x0222F111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012781F
.long 0xBF8C0F7E
.long 0x02230111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012801F
.long 0xBF8C0F7E
.long 0x02231111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012881F
.long 0xBF8C0F7E
.long 0x02232111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012901F
.long 0xBF8C0F7E
.long 0x02233111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012981F
.long 0xBF8C0F7E
.long 0x02234111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012A01F
.long 0xBF8C0F7E
.long 0x02235111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012A81F
.long 0xBF8C0F7E
.long 0x02236111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012B01F
.long 0xBF8C0F7E
.long 0x02237111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012B81F
.long 0xBF8C0F7E
.long 0x02238111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012C01F
.long 0xBF8C0F7E
.long 0x02239111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012C81F
.long 0xBF8C0F7E
.long 0x0223A111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012D01F
.long 0xBF8C0F7E
.long 0x0223B111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D0F
.long 0xE050D000, 0x8012D81F
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x0222D111
.long 0xBF8C0F7C
.long 0x0222E111
.long 0xBF8C0F7B
.long 0x0222F111
.long 0xBF8C0F7A
.long 0x02230111
.long 0xBF8C0F79
.long 0x02231111
.long 0xBF8C0F78
.long 0x02232111
.long 0xBF8C0F77
.long 0x02233111
.long 0xBF8C0F76
.long 0x02234111
.long 0xBF8C0F75
.long 0x02235111
.long 0xBF8C0F74
.long 0x02236111
.long 0xBF8C0F73
.long 0x02237111
.long 0xBF8C0F72
.long 0x02238111
.long 0xBF8C0F71
.long 0x02239111
.long 0xBF8C0F70
.long 0x0223A111
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x0222D111
.long 0xBF8C0F7B
.long 0x0222E111
.long 0xBF8C0F7A
.long 0x0222F111
.long 0xBF8C0F79
.long 0x02230111
.long 0xBF8C0F78
.long 0x02231111
.long 0xBF8C0F77
.long 0x02232111
.long 0xBF8C0F76
.long 0x02233111
.long 0xBF8C0F75
.long 0x02234111
.long 0xBF8C0F74
.long 0x02235111
.long 0xBF8C0F73
.long 0x02236111
.long 0xBF8C0F72
.long 0x02237111
.long 0xBF8C0F71
.long 0x02238111
.long 0xBF8C0F70
.long 0x02239111
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x0222D111
.long 0xBF8C0F7A
.long 0x0222E111
.long 0xBF8C0F79
.long 0x0222F111
.long 0xBF8C0F78
.long 0x02230111
.long 0xBF8C0F77
.long 0x02231111
.long 0xBF8C0F76
.long 0x02232111
.long 0xBF8C0F75
.long 0x02233111
.long 0xBF8C0F74
.long 0x02234111
.long 0xBF8C0F73
.long 0x02235111
.long 0xBF8C0F72
.long 0x02236111
.long 0xBF8C0F71
.long 0x02237111
.long 0xBF8C0F70
.long 0x02238111
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x0222D111
.long 0xBF8C0F79
.long 0x0222E111
.long 0xBF8C0F78
.long 0x0222F111
.long 0xBF8C0F77
.long 0x02230111
.long 0xBF8C0F76
.long 0x02231111
.long 0xBF8C0F75
.long 0x02232111
.long 0xBF8C0F74
.long 0x02233111
.long 0xBF8C0F73
.long 0x02234111
.long 0xBF8C0F72
.long 0x02235111
.long 0xBF8C0F71
.long 0x02236111
.long 0xBF8C0F70
.long 0x02237111
.long 0xBF820078
.long 0xBF8C0F79
.long 0x0222D111
.long 0xBF8C0F78
.long 0x0222E111
.long 0xBF8C0F77
.long 0x0222F111
.long 0xBF8C0F76
.long 0x02230111
.long 0xBF8C0F75
.long 0x02231111
.long 0xBF8C0F74
.long 0x02232111
.long 0xBF8C0F73
.long 0x02233111
.long 0xBF8C0F72
.long 0x02234111
.long 0xBF8C0F71
.long 0x02235111
.long 0xBF8C0F70
.long 0x02236111
.long 0xBF820063
.long 0xBF8C0F78
.long 0x0222D111
.long 0xBF8C0F77
.long 0x0222E111
.long 0xBF8C0F76
.long 0x0222F111
.long 0xBF8C0F75
.long 0x02230111
.long 0xBF8C0F74
.long 0x02231111
.long 0xBF8C0F73
.long 0x02232111
.long 0xBF8C0F72
.long 0x02233111
.long 0xBF8C0F71
.long 0x02234111
.long 0xBF8C0F70
.long 0x02235111
.long 0xBF820050
.long 0xBF8C0F77
.long 0x0222D111
.long 0xBF8C0F76
.long 0x0222E111
.long 0xBF8C0F75
.long 0x0222F111
.long 0xBF8C0F74
.long 0x02230111
.long 0xBF8C0F73
.long 0x02231111
.long 0xBF8C0F72
.long 0x02232111
.long 0xBF8C0F71
.long 0x02233111
.long 0xBF8C0F70
.long 0x02234111
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x0222D111
.long 0xBF8C0F75
.long 0x0222E111
.long 0xBF8C0F74
.long 0x0222F111
.long 0xBF8C0F73
.long 0x02230111
.long 0xBF8C0F72
.long 0x02231111
.long 0xBF8C0F71
.long 0x02232111
.long 0xBF8C0F70
.long 0x02233111
.long 0xBF820030
.long 0xBF8C0F75
.long 0x0222D111
.long 0xBF8C0F74
.long 0x0222E111
.long 0xBF8C0F73
.long 0x0222F111
.long 0xBF8C0F72
.long 0x02230111
.long 0xBF8C0F71
.long 0x02231111
.long 0xBF8C0F70
.long 0x02232111
.long 0xBF820023
.long 0xBF8C0F74
.long 0x0222D111
.long 0xBF8C0F73
.long 0x0222E111
.long 0xBF8C0F72
.long 0x0222F111
.long 0xBF8C0F71
.long 0x02230111
.long 0xBF8C0F70
.long 0x02231111
.long 0xBF820018
.long 0xBF8C0F73
.long 0x0222D111
.long 0xBF8C0F72
.long 0x0222E111
.long 0xBF8C0F71
.long 0x0222F111
.long 0xBF8C0F70
.long 0x02230111
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x0222D111
.long 0xBF8C0F71
.long 0x0222E111
.long 0xBF8C0F70
.long 0x0222F111
.long 0xBF820008
.long 0xBF8C0F71
.long 0x0222D111
.long 0xBF8C0F70
.long 0x0222E111
.long 0xBF820003
.long 0xBF8C0F70
.long 0x0222D111
.long 0xBF820000
.long 0x7E3C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80121412
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x80126812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x80127012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x80127812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x80128012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x80128812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x80129012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x80129812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D812
.long 0xBF8C0F7E
.long 0x0228D114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012681F
.long 0xBF8C0F7E
.long 0x0228E114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012701F
.long 0xBF8C0F7E
.long 0x0228F114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012781F
.long 0xBF8C0F7E
.long 0x02290114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012801F
.long 0xBF8C0F7E
.long 0x02291114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012881F
.long 0xBF8C0F7E
.long 0x02292114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012901F
.long 0xBF8C0F7E
.long 0x02293114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012981F
.long 0xBF8C0F7E
.long 0x02294114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012A01F
.long 0xBF8C0F7E
.long 0x02295114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012A81F
.long 0xBF8C0F7E
.long 0x02296114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012B01F
.long 0xBF8C0F7E
.long 0x02297114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012B81F
.long 0xBF8C0F7E
.long 0x02298114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012C01F
.long 0xBF8C0F7E
.long 0x02299114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012C81F
.long 0xBF8C0F7E
.long 0x0229A114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012D01F
.long 0xBF8C0F7E
.long 0x0229B114
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D12
.long 0xE050D000, 0x8012D81F
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x0228D114
.long 0xBF8C0F7C
.long 0x0228E114
.long 0xBF8C0F7B
.long 0x0228F114
.long 0xBF8C0F7A
.long 0x02290114
.long 0xBF8C0F79
.long 0x02291114
.long 0xBF8C0F78
.long 0x02292114
.long 0xBF8C0F77
.long 0x02293114
.long 0xBF8C0F76
.long 0x02294114
.long 0xBF8C0F75
.long 0x02295114
.long 0xBF8C0F74
.long 0x02296114
.long 0xBF8C0F73
.long 0x02297114
.long 0xBF8C0F72
.long 0x02298114
.long 0xBF8C0F71
.long 0x02299114
.long 0xBF8C0F70
.long 0x0229A114
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x0228D114
.long 0xBF8C0F7B
.long 0x0228E114
.long 0xBF8C0F7A
.long 0x0228F114
.long 0xBF8C0F79
.long 0x02290114
.long 0xBF8C0F78
.long 0x02291114
.long 0xBF8C0F77
.long 0x02292114
.long 0xBF8C0F76
.long 0x02293114
.long 0xBF8C0F75
.long 0x02294114
.long 0xBF8C0F74
.long 0x02295114
.long 0xBF8C0F73
.long 0x02296114
.long 0xBF8C0F72
.long 0x02297114
.long 0xBF8C0F71
.long 0x02298114
.long 0xBF8C0F70
.long 0x02299114
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x0228D114
.long 0xBF8C0F7A
.long 0x0228E114
.long 0xBF8C0F79
.long 0x0228F114
.long 0xBF8C0F78
.long 0x02290114
.long 0xBF8C0F77
.long 0x02291114
.long 0xBF8C0F76
.long 0x02292114
.long 0xBF8C0F75
.long 0x02293114
.long 0xBF8C0F74
.long 0x02294114
.long 0xBF8C0F73
.long 0x02295114
.long 0xBF8C0F72
.long 0x02296114
.long 0xBF8C0F71
.long 0x02297114
.long 0xBF8C0F70
.long 0x02298114
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x0228D114
.long 0xBF8C0F79
.long 0x0228E114
.long 0xBF8C0F78
.long 0x0228F114
.long 0xBF8C0F77
.long 0x02290114
.long 0xBF8C0F76
.long 0x02291114
.long 0xBF8C0F75
.long 0x02292114
.long 0xBF8C0F74
.long 0x02293114
.long 0xBF8C0F73
.long 0x02294114
.long 0xBF8C0F72
.long 0x02295114
.long 0xBF8C0F71
.long 0x02296114
.long 0xBF8C0F70
.long 0x02297114
.long 0xBF820078
.long 0xBF8C0F79
.long 0x0228D114
.long 0xBF8C0F78
.long 0x0228E114
.long 0xBF8C0F77
.long 0x0228F114
.long 0xBF8C0F76
.long 0x02290114
.long 0xBF8C0F75
.long 0x02291114
.long 0xBF8C0F74
.long 0x02292114
.long 0xBF8C0F73
.long 0x02293114
.long 0xBF8C0F72
.long 0x02294114
.long 0xBF8C0F71
.long 0x02295114
.long 0xBF8C0F70
.long 0x02296114
.long 0xBF820063
.long 0xBF8C0F78
.long 0x0228D114
.long 0xBF8C0F77
.long 0x0228E114
.long 0xBF8C0F76
.long 0x0228F114
.long 0xBF8C0F75
.long 0x02290114
.long 0xBF8C0F74
.long 0x02291114
.long 0xBF8C0F73
.long 0x02292114
.long 0xBF8C0F72
.long 0x02293114
.long 0xBF8C0F71
.long 0x02294114
.long 0xBF8C0F70
.long 0x02295114
.long 0xBF820050
.long 0xBF8C0F77
.long 0x0228D114
.long 0xBF8C0F76
.long 0x0228E114
.long 0xBF8C0F75
.long 0x0228F114
.long 0xBF8C0F74
.long 0x02290114
.long 0xBF8C0F73
.long 0x02291114
.long 0xBF8C0F72
.long 0x02292114
.long 0xBF8C0F71
.long 0x02293114
.long 0xBF8C0F70
.long 0x02294114
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x0228D114
.long 0xBF8C0F75
.long 0x0228E114
.long 0xBF8C0F74
.long 0x0228F114
.long 0xBF8C0F73
.long 0x02290114
.long 0xBF8C0F72
.long 0x02291114
.long 0xBF8C0F71
.long 0x02292114
.long 0xBF8C0F70
.long 0x02293114
.long 0xBF820030
.long 0xBF8C0F75
.long 0x0228D114
.long 0xBF8C0F74
.long 0x0228E114
.long 0xBF8C0F73
.long 0x0228F114
.long 0xBF8C0F72
.long 0x02290114
.long 0xBF8C0F71
.long 0x02291114
.long 0xBF8C0F70
.long 0x02292114
.long 0xBF820023
.long 0xBF8C0F74
.long 0x0228D114
.long 0xBF8C0F73
.long 0x0228E114
.long 0xBF8C0F72
.long 0x0228F114
.long 0xBF8C0F71
.long 0x02290114
.long 0xBF8C0F70
.long 0x02291114
.long 0xBF820018
.long 0xBF8C0F73
.long 0x0228D114
.long 0xBF8C0F72
.long 0x0228E114
.long 0xBF8C0F71
.long 0x0228F114
.long 0xBF8C0F70
.long 0x02290114
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x0228D114
.long 0xBF8C0F71
.long 0x0228E114
.long 0xBF8C0F70
.long 0x0228F114
.long 0xBF820008
.long 0xBF8C0F71
.long 0x0228D114
.long 0xBF8C0F70
.long 0x0228E114
.long 0xBF820003
.long 0xBF8C0F70
.long 0x0228D114
.long 0xBF820000
.long 0x7E3C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80121715
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x80126815
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x80127015
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x80127815
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x80128015
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x80128815
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x80129015
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x80129815
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A015
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A815
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B015
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B815
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C015
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C815
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D015
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D815
.long 0xBF8C0F7E
.long 0x022ED117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012681F
.long 0xBF8C0F7E
.long 0x022EE117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012701F
.long 0xBF8C0F7E
.long 0x022EF117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012781F
.long 0xBF8C0F7E
.long 0x022F0117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012801F
.long 0xBF8C0F7E
.long 0x022F1117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012881F
.long 0xBF8C0F7E
.long 0x022F2117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012901F
.long 0xBF8C0F7E
.long 0x022F3117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012981F
.long 0xBF8C0F7E
.long 0x022F4117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012A01F
.long 0xBF8C0F7E
.long 0x022F5117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012A81F
.long 0xBF8C0F7E
.long 0x022F6117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012B01F
.long 0xBF8C0F7E
.long 0x022F7117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012B81F
.long 0xBF8C0F7E
.long 0x022F8117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012C01F
.long 0xBF8C0F7E
.long 0x022F9117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012C81F
.long 0xBF8C0F7E
.long 0x022FA117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012D01F
.long 0xBF8C0F7E
.long 0x022FB117
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D15
.long 0xE050D000, 0x8012D81F
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x022ED117
.long 0xBF8C0F7C
.long 0x022EE117
.long 0xBF8C0F7B
.long 0x022EF117
.long 0xBF8C0F7A
.long 0x022F0117
.long 0xBF8C0F79
.long 0x022F1117
.long 0xBF8C0F78
.long 0x022F2117
.long 0xBF8C0F77
.long 0x022F3117
.long 0xBF8C0F76
.long 0x022F4117
.long 0xBF8C0F75
.long 0x022F5117
.long 0xBF8C0F74
.long 0x022F6117
.long 0xBF8C0F73
.long 0x022F7117
.long 0xBF8C0F72
.long 0x022F8117
.long 0xBF8C0F71
.long 0x022F9117
.long 0xBF8C0F70
.long 0x022FA117
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x022ED117
.long 0xBF8C0F7B
.long 0x022EE117
.long 0xBF8C0F7A
.long 0x022EF117
.long 0xBF8C0F79
.long 0x022F0117
.long 0xBF8C0F78
.long 0x022F1117
.long 0xBF8C0F77
.long 0x022F2117
.long 0xBF8C0F76
.long 0x022F3117
.long 0xBF8C0F75
.long 0x022F4117
.long 0xBF8C0F74
.long 0x022F5117
.long 0xBF8C0F73
.long 0x022F6117
.long 0xBF8C0F72
.long 0x022F7117
.long 0xBF8C0F71
.long 0x022F8117
.long 0xBF8C0F70
.long 0x022F9117
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x022ED117
.long 0xBF8C0F7A
.long 0x022EE117
.long 0xBF8C0F79
.long 0x022EF117
.long 0xBF8C0F78
.long 0x022F0117
.long 0xBF8C0F77
.long 0x022F1117
.long 0xBF8C0F76
.long 0x022F2117
.long 0xBF8C0F75
.long 0x022F3117
.long 0xBF8C0F74
.long 0x022F4117
.long 0xBF8C0F73
.long 0x022F5117
.long 0xBF8C0F72
.long 0x022F6117
.long 0xBF8C0F71
.long 0x022F7117
.long 0xBF8C0F70
.long 0x022F8117
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x022ED117
.long 0xBF8C0F79
.long 0x022EE117
.long 0xBF8C0F78
.long 0x022EF117
.long 0xBF8C0F77
.long 0x022F0117
.long 0xBF8C0F76
.long 0x022F1117
.long 0xBF8C0F75
.long 0x022F2117
.long 0xBF8C0F74
.long 0x022F3117
.long 0xBF8C0F73
.long 0x022F4117
.long 0xBF8C0F72
.long 0x022F5117
.long 0xBF8C0F71
.long 0x022F6117
.long 0xBF8C0F70
.long 0x022F7117
.long 0xBF820078
.long 0xBF8C0F79
.long 0x022ED117
.long 0xBF8C0F78
.long 0x022EE117
.long 0xBF8C0F77
.long 0x022EF117
.long 0xBF8C0F76
.long 0x022F0117
.long 0xBF8C0F75
.long 0x022F1117
.long 0xBF8C0F74
.long 0x022F2117
.long 0xBF8C0F73
.long 0x022F3117
.long 0xBF8C0F72
.long 0x022F4117
.long 0xBF8C0F71
.long 0x022F5117
.long 0xBF8C0F70
.long 0x022F6117
.long 0xBF820063
.long 0xBF8C0F78
.long 0x022ED117
.long 0xBF8C0F77
.long 0x022EE117
.long 0xBF8C0F76
.long 0x022EF117
.long 0xBF8C0F75
.long 0x022F0117
.long 0xBF8C0F74
.long 0x022F1117
.long 0xBF8C0F73
.long 0x022F2117
.long 0xBF8C0F72
.long 0x022F3117
.long 0xBF8C0F71
.long 0x022F4117
.long 0xBF8C0F70
.long 0x022F5117
.long 0xBF820050
.long 0xBF8C0F77
.long 0x022ED117
.long 0xBF8C0F76
.long 0x022EE117
.long 0xBF8C0F75
.long 0x022EF117
.long 0xBF8C0F74
.long 0x022F0117
.long 0xBF8C0F73
.long 0x022F1117
.long 0xBF8C0F72
.long 0x022F2117
.long 0xBF8C0F71
.long 0x022F3117
.long 0xBF8C0F70
.long 0x022F4117
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x022ED117
.long 0xBF8C0F75
.long 0x022EE117
.long 0xBF8C0F74
.long 0x022EF117
.long 0xBF8C0F73
.long 0x022F0117
.long 0xBF8C0F72
.long 0x022F1117
.long 0xBF8C0F71
.long 0x022F2117
.long 0xBF8C0F70
.long 0x022F3117
.long 0xBF820030
.long 0xBF8C0F75
.long 0x022ED117
.long 0xBF8C0F74
.long 0x022EE117
.long 0xBF8C0F73
.long 0x022EF117
.long 0xBF8C0F72
.long 0x022F0117
.long 0xBF8C0F71
.long 0x022F1117
.long 0xBF8C0F70
.long 0x022F2117
.long 0xBF820023
.long 0xBF8C0F74
.long 0x022ED117
.long 0xBF8C0F73
.long 0x022EE117
.long 0xBF8C0F72
.long 0x022EF117
.long 0xBF8C0F71
.long 0x022F0117
.long 0xBF8C0F70
.long 0x022F1117
.long 0xBF820018
.long 0xBF8C0F73
.long 0x022ED117
.long 0xBF8C0F72
.long 0x022EE117
.long 0xBF8C0F71
.long 0x022EF117
.long 0xBF8C0F70
.long 0x022F0117
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x022ED117
.long 0xBF8C0F71
.long 0x022EE117
.long 0xBF8C0F70
.long 0x022EF117
.long 0xBF820008
.long 0xBF8C0F71
.long 0x022ED117
.long 0xBF8C0F70
.long 0x022EE117
.long 0xBF820003
.long 0xBF8C0F70
.long 0x022ED117
.long 0xBF820000
.long 0x7E3C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80121A18
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x80126818
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x80127018
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x80127818
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x80128018
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x80128818
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x80129018
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x80129818
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A018
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A818
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B018
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B818
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C018
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C818
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D018
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D818
.long 0xBF8C0F7E
.long 0x0234D11A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012681F
.long 0xBF8C0F7E
.long 0x0234E11A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012701F
.long 0xBF8C0F7E
.long 0x0234F11A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012781F
.long 0xBF8C0F7E
.long 0x0235011A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012801F
.long 0xBF8C0F7E
.long 0x0235111A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012881F
.long 0xBF8C0F7E
.long 0x0235211A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012901F
.long 0xBF8C0F7E
.long 0x0235311A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012981F
.long 0xBF8C0F7E
.long 0x0235411A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012A01F
.long 0xBF8C0F7E
.long 0x0235511A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012A81F
.long 0xBF8C0F7E
.long 0x0235611A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012B01F
.long 0xBF8C0F7E
.long 0x0235711A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012B81F
.long 0xBF8C0F7E
.long 0x0235811A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012C01F
.long 0xBF8C0F7E
.long 0x0235911A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012C81F
.long 0xBF8C0F7E
.long 0x0235A11A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012D01F
.long 0xBF8C0F7E
.long 0x0235B11A
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D18
.long 0xE050D000, 0x8012D81F
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x0234D11A
.long 0xBF8C0F7C
.long 0x0234E11A
.long 0xBF8C0F7B
.long 0x0234F11A
.long 0xBF8C0F7A
.long 0x0235011A
.long 0xBF8C0F79
.long 0x0235111A
.long 0xBF8C0F78
.long 0x0235211A
.long 0xBF8C0F77
.long 0x0235311A
.long 0xBF8C0F76
.long 0x0235411A
.long 0xBF8C0F75
.long 0x0235511A
.long 0xBF8C0F74
.long 0x0235611A
.long 0xBF8C0F73
.long 0x0235711A
.long 0xBF8C0F72
.long 0x0235811A
.long 0xBF8C0F71
.long 0x0235911A
.long 0xBF8C0F70
.long 0x0235A11A
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x0234D11A
.long 0xBF8C0F7B
.long 0x0234E11A
.long 0xBF8C0F7A
.long 0x0234F11A
.long 0xBF8C0F79
.long 0x0235011A
.long 0xBF8C0F78
.long 0x0235111A
.long 0xBF8C0F77
.long 0x0235211A
.long 0xBF8C0F76
.long 0x0235311A
.long 0xBF8C0F75
.long 0x0235411A
.long 0xBF8C0F74
.long 0x0235511A
.long 0xBF8C0F73
.long 0x0235611A
.long 0xBF8C0F72
.long 0x0235711A
.long 0xBF8C0F71
.long 0x0235811A
.long 0xBF8C0F70
.long 0x0235911A
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x0234D11A
.long 0xBF8C0F7A
.long 0x0234E11A
.long 0xBF8C0F79
.long 0x0234F11A
.long 0xBF8C0F78
.long 0x0235011A
.long 0xBF8C0F77
.long 0x0235111A
.long 0xBF8C0F76
.long 0x0235211A
.long 0xBF8C0F75
.long 0x0235311A
.long 0xBF8C0F74
.long 0x0235411A
.long 0xBF8C0F73
.long 0x0235511A
.long 0xBF8C0F72
.long 0x0235611A
.long 0xBF8C0F71
.long 0x0235711A
.long 0xBF8C0F70
.long 0x0235811A
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x0234D11A
.long 0xBF8C0F79
.long 0x0234E11A
.long 0xBF8C0F78
.long 0x0234F11A
.long 0xBF8C0F77
.long 0x0235011A
.long 0xBF8C0F76
.long 0x0235111A
.long 0xBF8C0F75
.long 0x0235211A
.long 0xBF8C0F74
.long 0x0235311A
.long 0xBF8C0F73
.long 0x0235411A
.long 0xBF8C0F72
.long 0x0235511A
.long 0xBF8C0F71
.long 0x0235611A
.long 0xBF8C0F70
.long 0x0235711A
.long 0xBF820078
.long 0xBF8C0F79
.long 0x0234D11A
.long 0xBF8C0F78
.long 0x0234E11A
.long 0xBF8C0F77
.long 0x0234F11A
.long 0xBF8C0F76
.long 0x0235011A
.long 0xBF8C0F75
.long 0x0235111A
.long 0xBF8C0F74
.long 0x0235211A
.long 0xBF8C0F73
.long 0x0235311A
.long 0xBF8C0F72
.long 0x0235411A
.long 0xBF8C0F71
.long 0x0235511A
.long 0xBF8C0F70
.long 0x0235611A
.long 0xBF820063
.long 0xBF8C0F78
.long 0x0234D11A
.long 0xBF8C0F77
.long 0x0234E11A
.long 0xBF8C0F76
.long 0x0234F11A
.long 0xBF8C0F75
.long 0x0235011A
.long 0xBF8C0F74
.long 0x0235111A
.long 0xBF8C0F73
.long 0x0235211A
.long 0xBF8C0F72
.long 0x0235311A
.long 0xBF8C0F71
.long 0x0235411A
.long 0xBF8C0F70
.long 0x0235511A
.long 0xBF820050
.long 0xBF8C0F77
.long 0x0234D11A
.long 0xBF8C0F76
.long 0x0234E11A
.long 0xBF8C0F75
.long 0x0234F11A
.long 0xBF8C0F74
.long 0x0235011A
.long 0xBF8C0F73
.long 0x0235111A
.long 0xBF8C0F72
.long 0x0235211A
.long 0xBF8C0F71
.long 0x0235311A
.long 0xBF8C0F70
.long 0x0235411A
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x0234D11A
.long 0xBF8C0F75
.long 0x0234E11A
.long 0xBF8C0F74
.long 0x0234F11A
.long 0xBF8C0F73
.long 0x0235011A
.long 0xBF8C0F72
.long 0x0235111A
.long 0xBF8C0F71
.long 0x0235211A
.long 0xBF8C0F70
.long 0x0235311A
.long 0xBF820030
.long 0xBF8C0F75
.long 0x0234D11A
.long 0xBF8C0F74
.long 0x0234E11A
.long 0xBF8C0F73
.long 0x0234F11A
.long 0xBF8C0F72
.long 0x0235011A
.long 0xBF8C0F71
.long 0x0235111A
.long 0xBF8C0F70
.long 0x0235211A
.long 0xBF820023
.long 0xBF8C0F74
.long 0x0234D11A
.long 0xBF8C0F73
.long 0x0234E11A
.long 0xBF8C0F72
.long 0x0234F11A
.long 0xBF8C0F71
.long 0x0235011A
.long 0xBF8C0F70
.long 0x0235111A
.long 0xBF820018
.long 0xBF8C0F73
.long 0x0234D11A
.long 0xBF8C0F72
.long 0x0234E11A
.long 0xBF8C0F71
.long 0x0234F11A
.long 0xBF8C0F70
.long 0x0235011A
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x0234D11A
.long 0xBF8C0F71
.long 0x0234E11A
.long 0xBF8C0F70
.long 0x0234F11A
.long 0xBF820008
.long 0xBF8C0F71
.long 0x0234D11A
.long 0xBF8C0F70
.long 0x0234E11A
.long 0xBF820003
.long 0xBF8C0F70
.long 0x0234D11A
.long 0xBF820000
.long 0x7E3C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80121D1B
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x8012681B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x8012701B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x8012781B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x8012801B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x8012881B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x8012901B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x8012981B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A01B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A81B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B01B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B81B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C01B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C81B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D01B
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D81B
.long 0xBF8C0F7E
.long 0x023AD11D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012681F
.long 0xBF8C0F7E
.long 0x023AE11D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012701F
.long 0xBF8C0F7E
.long 0x023AF11D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012781F
.long 0xBF8C0F7E
.long 0x023B011D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012801F
.long 0xBF8C0F7E
.long 0x023B111D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012881F
.long 0xBF8C0F7E
.long 0x023B211D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012901F
.long 0xBF8C0F7E
.long 0x023B311D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012981F
.long 0xBF8C0F7E
.long 0x023B411D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012A01F
.long 0xBF8C0F7E
.long 0x023B511D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012A81F
.long 0xBF8C0F7E
.long 0x023B611D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012B01F
.long 0xBF8C0F7E
.long 0x023B711D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012B81F
.long 0xBF8C0F7E
.long 0x023B811D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012C01F
.long 0xBF8C0F7E
.long 0x023B911D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012C81F
.long 0xBF8C0F7E
.long 0x023BA11D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012D01F
.long 0xBF8C0F7E
.long 0x023BB11D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100001F, 0x011A3D1B
.long 0xE050D000, 0x8012D81F
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x023AD11D
.long 0xBF8C0F7C
.long 0x023AE11D
.long 0xBF8C0F7B
.long 0x023AF11D
.long 0xBF8C0F7A
.long 0x023B011D
.long 0xBF8C0F79
.long 0x023B111D
.long 0xBF8C0F78
.long 0x023B211D
.long 0xBF8C0F77
.long 0x023B311D
.long 0xBF8C0F76
.long 0x023B411D
.long 0xBF8C0F75
.long 0x023B511D
.long 0xBF8C0F74
.long 0x023B611D
.long 0xBF8C0F73
.long 0x023B711D
.long 0xBF8C0F72
.long 0x023B811D
.long 0xBF8C0F71
.long 0x023B911D
.long 0xBF8C0F70
.long 0x023BA11D
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x023AD11D
.long 0xBF8C0F7B
.long 0x023AE11D
.long 0xBF8C0F7A
.long 0x023AF11D
.long 0xBF8C0F79
.long 0x023B011D
.long 0xBF8C0F78
.long 0x023B111D
.long 0xBF8C0F77
.long 0x023B211D
.long 0xBF8C0F76
.long 0x023B311D
.long 0xBF8C0F75
.long 0x023B411D
.long 0xBF8C0F74
.long 0x023B511D
.long 0xBF8C0F73
.long 0x023B611D
.long 0xBF8C0F72
.long 0x023B711D
.long 0xBF8C0F71
.long 0x023B811D
.long 0xBF8C0F70
.long 0x023B911D
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x023AD11D
.long 0xBF8C0F7A
.long 0x023AE11D
.long 0xBF8C0F79
.long 0x023AF11D
.long 0xBF8C0F78
.long 0x023B011D
.long 0xBF8C0F77
.long 0x023B111D
.long 0xBF8C0F76
.long 0x023B211D
.long 0xBF8C0F75
.long 0x023B311D
.long 0xBF8C0F74
.long 0x023B411D
.long 0xBF8C0F73
.long 0x023B511D
.long 0xBF8C0F72
.long 0x023B611D
.long 0xBF8C0F71
.long 0x023B711D
.long 0xBF8C0F70
.long 0x023B811D
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x023AD11D
.long 0xBF8C0F79
.long 0x023AE11D
.long 0xBF8C0F78
.long 0x023AF11D
.long 0xBF8C0F77
.long 0x023B011D
.long 0xBF8C0F76
.long 0x023B111D
.long 0xBF8C0F75
.long 0x023B211D
.long 0xBF8C0F74
.long 0x023B311D
.long 0xBF8C0F73
.long 0x023B411D
.long 0xBF8C0F72
.long 0x023B511D
.long 0xBF8C0F71
.long 0x023B611D
.long 0xBF8C0F70
.long 0x023B711D
.long 0xBF820078
.long 0xBF8C0F79
.long 0x023AD11D
.long 0xBF8C0F78
.long 0x023AE11D
.long 0xBF8C0F77
.long 0x023AF11D
.long 0xBF8C0F76
.long 0x023B011D
.long 0xBF8C0F75
.long 0x023B111D
.long 0xBF8C0F74
.long 0x023B211D
.long 0xBF8C0F73
.long 0x023B311D
.long 0xBF8C0F72
.long 0x023B411D
.long 0xBF8C0F71
.long 0x023B511D
.long 0xBF8C0F70
.long 0x023B611D
.long 0xBF820063
.long 0xBF8C0F78
.long 0x023AD11D
.long 0xBF8C0F77
.long 0x023AE11D
.long 0xBF8C0F76
.long 0x023AF11D
.long 0xBF8C0F75
.long 0x023B011D
.long 0xBF8C0F74
.long 0x023B111D
.long 0xBF8C0F73
.long 0x023B211D
.long 0xBF8C0F72
.long 0x023B311D
.long 0xBF8C0F71
.long 0x023B411D
.long 0xBF8C0F70
.long 0x023B511D
.long 0xBF820050
.long 0xBF8C0F77
.long 0x023AD11D
.long 0xBF8C0F76
.long 0x023AE11D
.long 0xBF8C0F75
.long 0x023AF11D
.long 0xBF8C0F74
.long 0x023B011D
.long 0xBF8C0F73
.long 0x023B111D
.long 0xBF8C0F72
.long 0x023B211D
.long 0xBF8C0F71
.long 0x023B311D
.long 0xBF8C0F70
.long 0x023B411D
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x023AD11D
.long 0xBF8C0F75
.long 0x023AE11D
.long 0xBF8C0F74
.long 0x023AF11D
.long 0xBF8C0F73
.long 0x023B011D
.long 0xBF8C0F72
.long 0x023B111D
.long 0xBF8C0F71
.long 0x023B211D
.long 0xBF8C0F70
.long 0x023B311D
.long 0xBF820030
.long 0xBF8C0F75
.long 0x023AD11D
.long 0xBF8C0F74
.long 0x023AE11D
.long 0xBF8C0F73
.long 0x023AF11D
.long 0xBF8C0F72
.long 0x023B011D
.long 0xBF8C0F71
.long 0x023B111D
.long 0xBF8C0F70
.long 0x023B211D
.long 0xBF820023
.long 0xBF8C0F74
.long 0x023AD11D
.long 0xBF8C0F73
.long 0x023AE11D
.long 0xBF8C0F72
.long 0x023AF11D
.long 0xBF8C0F71
.long 0x023B011D
.long 0xBF8C0F70
.long 0x023B111D
.long 0xBF820018
.long 0xBF8C0F73
.long 0x023AD11D
.long 0xBF8C0F72
.long 0x023AE11D
.long 0xBF8C0F71
.long 0x023AF11D
.long 0xBF8C0F70
.long 0x023B011D
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x023AD11D
.long 0xBF8C0F71
.long 0x023AE11D
.long 0xBF8C0F70
.long 0x023AF11D
.long 0xBF820008
.long 0xBF8C0F71
.long 0x023AD11D
.long 0xBF8C0F70
.long 0x023AE11D
.long 0xBF820003
.long 0xBF8C0F70
.long 0x023AD11D
.long 0xBF820000
.long 0x0A101030
.long 0x0A161630
.long 0x0A1C1C30
.long 0x0A222230
.long 0x0A282830
.long 0x0A2E2E30
.long 0x0A343430
.long 0x0A3A3A30
.long 0x7E101508
.long 0xE068D000, 0x800E0807
.long 0xBF800000
.long 0x7E16150B
.long 0xE068D000, 0x800E0B0A
.long 0xBF800000
.long 0x7E1C150E
.long 0xE068D000, 0x800E0E0D
.long 0xBF800000
.long 0x7E221511
.long 0xE068D000, 0x800E1110
.long 0xBF800000
.long 0x7E281514
.long 0xE068D000, 0x800E1413
.long 0xBF800000
.long 0x7E2E1517
.long 0xE068D000, 0x800E1716
.long 0xBF800000
.long 0x7E34151A
.long 0xE068D000, 0x800E1A19
.long 0xBF800000
.long 0x7E3A151D
.long 0xE068D000, 0x800E1D1C
.long 0xBF800000
.long 0xBF800000
.long 0xBF8217F8
.long 0x863C1CFF, 0x0000007F
.long 0x803D14C1
.long 0xBF093D02
.long 0x853C803C
.long 0xB53C0000
.long 0xBF850611
.long 0x863C1D8F
.long 0x803D15C1
.long 0xBF093D03
.long 0x853C803C
.long 0xB53C0000
.long 0xBF85060B
.long 0xD1FE0008, 0x02060102
.long 0xE05C1000, 0x80041008
.long 0xD1FE0006, 0x020A0103
.long 0xD1FE0007, 0x02060103
.long 0xD3D84018, 0x18000100
.long 0xD3D84019, 0x18000104
.long 0xD3D8401A, 0x18000101
.long 0xD3D8401B, 0x18000105
.long 0xD3D8401C, 0x18000102
.long 0xD3D8401D, 0x18000106
.long 0xD3D8401E, 0x18000103
.long 0xD3D8401F, 0x18000107
.long 0xBF800001
.long 0xE07CD000, 0x80031806
.long 0xE07CD010, 0x80031C06
.long 0xBF800000
.long 0x923F1415
.long 0x9233043F
.long 0x923E1403
.long 0x803E023E
.long 0x803E333E
.long 0x7E660566
.long 0x923F1E3F
.long 0x8F338633
.long 0x9233333F
.long 0x803E3E33
.long 0x8E3E823E
.long 0x80183E36
.long 0x82198037
.long 0xBF8C0000
.long 0x80B38132
.long 0xC2330CCC, 0x00000000
.long 0x9645811C
.long 0x9244811C
.long 0x80C8811D
.long 0x92488148
.long 0x96472A48
.long 0x92462A48
.long 0x80444644
.long 0x82454745
.long 0x80C8811E
.long 0x92488148
.long 0x96472B48
.long 0x92462B48
.long 0x80444644
.long 0x82454745
.long 0x8EC08244
.long 0x7E1202FF, 0x80000000
.long 0xBEC40016
.long 0xBEC50017
.long 0xBEC6000E
.long 0xBEC7000F
.long 0xBF8CC07F
.long 0xBF068133
.long 0xBF8405C2
.long 0xE05CD000, 0x80111806
.long 0xE05CD010, 0x80111C06
.long 0xBE850032
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85058D
.long 0xE05CD000, 0x80116806
.long 0xE05CD010, 0x80116C06
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85057A
.long 0xE05CD000, 0x80117006
.long 0xE05CD010, 0x80117406
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85055E
.long 0xE05CD000, 0x80117806
.long 0xE05CD010, 0x80117C06
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850539
.long 0xE05CD000, 0x80118006
.long 0xE05CD010, 0x80118406
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85050B
.long 0xE05CD000, 0x80118806
.long 0xE05CD010, 0x80118C06
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8504D4
.long 0xE05CD000, 0x80119006
.long 0xE05CD010, 0x80119406
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850494
.long 0xE05CD000, 0x80119806
.long 0xE05CD010, 0x80119C06
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85044B
.long 0xE05CD000, 0x8011A006
.long 0xE05CD010, 0x8011A406
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8503F9
.long 0xE05CD000, 0x8011A806
.long 0xE05CD010, 0x8011AC06
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85039E
.long 0xE05CD000, 0x8011B006
.long 0xE05CD010, 0x8011B406
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85033A
.long 0xE05CD000, 0x8011B806
.long 0xE05CD010, 0x8011BC06
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8502CD
.long 0xE05CD000, 0x8011C006
.long 0xE05CD010, 0x8011C406
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850257
.long 0xE05CD000, 0x8011C806
.long 0xE05CD010, 0x8011CC06
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8501D8
.long 0xE05CD000, 0x8011D006
.long 0xE05CD010, 0x8011D406
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850150
.long 0xE05CD000, 0x8011D806
.long 0xE05CD010, 0x8011DC06
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8504FF
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011680A
.long 0xE05CD010, 0x80116C0A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8504E9
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011700A
.long 0xE05CD010, 0x8011740A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8504D3
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011780A
.long 0xE05CD010, 0x80117C0A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8504BD
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011800A
.long 0xE05CD010, 0x8011840A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8504A7
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011880A
.long 0xE05CD010, 0x80118C0A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18032118
.long 0xD3B2401A, 0x1803251A
.long 0xD3B2401C, 0x1803291C
.long 0xD3B2401E, 0x18032D1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850491
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011900A
.long 0xE05CD010, 0x8011940A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18033118
.long 0xD3B2401A, 0x1803351A
.long 0xD3B2401C, 0x1803391C
.long 0xD3B2401E, 0x18033D1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85047B
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011980A
.long 0xE05CD010, 0x80119C0A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18034118
.long 0xD3B2401A, 0x1803451A
.long 0xD3B2401C, 0x1803491C
.long 0xD3B2401E, 0x18034D1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850465
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011A00A
.long 0xE05CD010, 0x8011A40A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18035118
.long 0xD3B2401A, 0x1803551A
.long 0xD3B2401C, 0x1803591C
.long 0xD3B2401E, 0x18035D1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85044F
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011A80A
.long 0xE05CD010, 0x8011AC0A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18036118
.long 0xD3B2401A, 0x1803651A
.long 0xD3B2401C, 0x1803691C
.long 0xD3B2401E, 0x18036D1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850439
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011B00A
.long 0xE05CD010, 0x8011B40A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18037118
.long 0xD3B2401A, 0x1803751A
.long 0xD3B2401C, 0x1803791C
.long 0xD3B2401E, 0x18037D1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850423
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011B80A
.long 0xE05CD010, 0x8011BC0A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18038118
.long 0xD3B2401A, 0x1803851A
.long 0xD3B2401C, 0x1803891C
.long 0xD3B2401E, 0x18038D1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85040D
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011C00A
.long 0xE05CD010, 0x8011C40A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18039118
.long 0xD3B2401A, 0x1803951A
.long 0xD3B2401C, 0x1803991C
.long 0xD3B2401E, 0x18039D1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8503F7
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011C80A
.long 0xE05CD010, 0x8011CC0A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1803A118
.long 0xD3B2401A, 0x1803A51A
.long 0xD3B2401C, 0x1803A91C
.long 0xD3B2401E, 0x1803AD1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8503E1
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011D00A
.long 0xE05CD010, 0x8011D40A
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1803B118
.long 0xD3B2401A, 0x1803B51A
.long 0xD3B2401C, 0x1803B91C
.long 0xD3B2401E, 0x1803BD1E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8503CB
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000A, 0x010A1306
.long 0xE05CD000, 0x8011D80A
.long 0xE05CD010, 0x8011DC0A
.long 0xBF02CE05
.long 0xBF85FEB4
.long 0xBF8C0F7D
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F7C
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F7A
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF8C0F79
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0xBF8C0F78
.long 0xD3B24018, 0x18032118
.long 0xD3B2401A, 0x1803251A
.long 0xD3B2401C, 0x1803291C
.long 0xD3B2401E, 0x18032D1E
.long 0xBF8C0F77
.long 0xD3B24018, 0x18033118
.long 0xD3B2401A, 0x1803351A
.long 0xD3B2401C, 0x1803391C
.long 0xD3B2401E, 0x18033D1E
.long 0xBF8C0F76
.long 0xD3B24018, 0x18034118
.long 0xD3B2401A, 0x1803451A
.long 0xD3B2401C, 0x1803491C
.long 0xD3B2401E, 0x18034D1E
.long 0xBF8C0F75
.long 0xD3B24018, 0x18035118
.long 0xD3B2401A, 0x1803551A
.long 0xD3B2401C, 0x1803591C
.long 0xD3B2401E, 0x18035D1E
.long 0xBF8C0F74
.long 0xD3B24018, 0x18036118
.long 0xD3B2401A, 0x1803651A
.long 0xD3B2401C, 0x1803691C
.long 0xD3B2401E, 0x18036D1E
.long 0xBF8C0F73
.long 0xD3B24018, 0x18037118
.long 0xD3B2401A, 0x1803751A
.long 0xD3B2401C, 0x1803791C
.long 0xD3B2401E, 0x18037D1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x18038118
.long 0xD3B2401A, 0x1803851A
.long 0xD3B2401C, 0x1803891C
.long 0xD3B2401E, 0x18038D1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18039118
.long 0xD3B2401A, 0x1803951A
.long 0xD3B2401C, 0x1803991C
.long 0xD3B2401E, 0x18039D1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x1803A118
.long 0xD3B2401A, 0x1803A51A
.long 0xD3B2401C, 0x1803A91C
.long 0xD3B2401E, 0x1803AD1E
.long 0xBF820340
.long 0xBF8C0F7C
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F79
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF8C0F78
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0xBF8C0F77
.long 0xD3B24018, 0x18032118
.long 0xD3B2401A, 0x1803251A
.long 0xD3B2401C, 0x1803291C
.long 0xD3B2401E, 0x18032D1E
.long 0xBF8C0F76
.long 0xD3B24018, 0x18033118
.long 0xD3B2401A, 0x1803351A
.long 0xD3B2401C, 0x1803391C
.long 0xD3B2401E, 0x18033D1E
.long 0xBF8C0F75
.long 0xD3B24018, 0x18034118
.long 0xD3B2401A, 0x1803451A
.long 0xD3B2401C, 0x1803491C
.long 0xD3B2401E, 0x18034D1E
.long 0xBF8C0F74
.long 0xD3B24018, 0x18035118
.long 0xD3B2401A, 0x1803551A
.long 0xD3B2401C, 0x1803591C
.long 0xD3B2401E, 0x18035D1E
.long 0xBF8C0F73
.long 0xD3B24018, 0x18036118
.long 0xD3B2401A, 0x1803651A
.long 0xD3B2401C, 0x1803691C
.long 0xD3B2401E, 0x18036D1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x18037118
.long 0xD3B2401A, 0x1803751A
.long 0xD3B2401C, 0x1803791C
.long 0xD3B2401E, 0x18037D1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18038118
.long 0xD3B2401A, 0x1803851A
.long 0xD3B2401C, 0x1803891C
.long 0xD3B2401E, 0x18038D1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18039118
.long 0xD3B2401A, 0x1803951A
.long 0xD3B2401C, 0x1803991C
.long 0xD3B2401E, 0x18039D1E
.long 0xBF8202CA
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F78
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF8C0F77
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0xBF8C0F76
.long 0xD3B24018, 0x18032118
.long 0xD3B2401A, 0x1803251A
.long 0xD3B2401C, 0x1803291C
.long 0xD3B2401E, 0x18032D1E
.long 0xBF8C0F75
.long 0xD3B24018, 0x18033118
.long 0xD3B2401A, 0x1803351A
.long 0xD3B2401C, 0x1803391C
.long 0xD3B2401E, 0x18033D1E
.long 0xBF8C0F74
.long 0xD3B24018, 0x18034118
.long 0xD3B2401A, 0x1803451A
.long 0xD3B2401C, 0x1803491C
.long 0xD3B2401E, 0x18034D1E
.long 0xBF8C0F73
.long 0xD3B24018, 0x18035118
.long 0xD3B2401A, 0x1803551A
.long 0xD3B2401C, 0x1803591C
.long 0xD3B2401E, 0x18035D1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x18036118
.long 0xD3B2401A, 0x1803651A
.long 0xD3B2401C, 0x1803691C
.long 0xD3B2401E, 0x18036D1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18037118
.long 0xD3B2401A, 0x1803751A
.long 0xD3B2401C, 0x1803791C
.long 0xD3B2401E, 0x18037D1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18038118
.long 0xD3B2401A, 0x1803851A
.long 0xD3B2401C, 0x1803891C
.long 0xD3B2401E, 0x18038D1E
.long 0xBF82025D
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F77
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF8C0F76
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0xBF8C0F75
.long 0xD3B24018, 0x18032118
.long 0xD3B2401A, 0x1803251A
.long 0xD3B2401C, 0x1803291C
.long 0xD3B2401E, 0x18032D1E
.long 0xBF8C0F74
.long 0xD3B24018, 0x18033118
.long 0xD3B2401A, 0x1803351A
.long 0xD3B2401C, 0x1803391C
.long 0xD3B2401E, 0x18033D1E
.long 0xBF8C0F73
.long 0xD3B24018, 0x18034118
.long 0xD3B2401A, 0x1803451A
.long 0xD3B2401C, 0x1803491C
.long 0xD3B2401E, 0x18034D1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x18035118
.long 0xD3B2401A, 0x1803551A
.long 0xD3B2401C, 0x1803591C
.long 0xD3B2401E, 0x18035D1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18036118
.long 0xD3B2401A, 0x1803651A
.long 0xD3B2401C, 0x1803691C
.long 0xD3B2401E, 0x18036D1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18037118
.long 0xD3B2401A, 0x1803751A
.long 0xD3B2401C, 0x1803791C
.long 0xD3B2401E, 0x18037D1E
.long 0xBF8201F9
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F76
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF8C0F75
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0xBF8C0F74
.long 0xD3B24018, 0x18032118
.long 0xD3B2401A, 0x1803251A
.long 0xD3B2401C, 0x1803291C
.long 0xD3B2401E, 0x18032D1E
.long 0xBF8C0F73
.long 0xD3B24018, 0x18033118
.long 0xD3B2401A, 0x1803351A
.long 0xD3B2401C, 0x1803391C
.long 0xD3B2401E, 0x18033D1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x18034118
.long 0xD3B2401A, 0x1803451A
.long 0xD3B2401C, 0x1803491C
.long 0xD3B2401E, 0x18034D1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18035118
.long 0xD3B2401A, 0x1803551A
.long 0xD3B2401C, 0x1803591C
.long 0xD3B2401E, 0x18035D1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18036118
.long 0xD3B2401A, 0x1803651A
.long 0xD3B2401C, 0x1803691C
.long 0xD3B2401E, 0x18036D1E
.long 0xBF82019E
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F75
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF8C0F74
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0xBF8C0F73
.long 0xD3B24018, 0x18032118
.long 0xD3B2401A, 0x1803251A
.long 0xD3B2401C, 0x1803291C
.long 0xD3B2401E, 0x18032D1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x18033118
.long 0xD3B2401A, 0x1803351A
.long 0xD3B2401C, 0x1803391C
.long 0xD3B2401E, 0x18033D1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18034118
.long 0xD3B2401A, 0x1803451A
.long 0xD3B2401C, 0x1803491C
.long 0xD3B2401E, 0x18034D1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18035118
.long 0xD3B2401A, 0x1803551A
.long 0xD3B2401C, 0x1803591C
.long 0xD3B2401E, 0x18035D1E
.long 0xBF82014C
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F74
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF8C0F73
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x18032118
.long 0xD3B2401A, 0x1803251A
.long 0xD3B2401C, 0x1803291C
.long 0xD3B2401E, 0x18032D1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18033118
.long 0xD3B2401A, 0x1803351A
.long 0xD3B2401C, 0x1803391C
.long 0xD3B2401E, 0x18033D1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18034118
.long 0xD3B2401A, 0x1803451A
.long 0xD3B2401C, 0x1803491C
.long 0xD3B2401E, 0x18034D1E
.long 0xBF820103
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F73
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18032118
.long 0xD3B2401A, 0x1803251A
.long 0xD3B2401C, 0x1803291C
.long 0xD3B2401E, 0x18032D1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18033118
.long 0xD3B2401A, 0x1803351A
.long 0xD3B2401C, 0x1803391C
.long 0xD3B2401E, 0x18033D1E
.long 0xBF8200C3
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18032118
.long 0xD3B2401A, 0x1803251A
.long 0xD3B2401C, 0x1803291C
.long 0xD3B2401E, 0x18032D1E
.long 0xBF82008C
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18031118
.long 0xD3B2401A, 0x1803151A
.long 0xD3B2401C, 0x1803191C
.long 0xD3B2401E, 0x18031D1E
.long 0xBF82005E
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18030118
.long 0xD3B2401A, 0x1803051A
.long 0xD3B2401C, 0x1803091C
.long 0xD3B2401E, 0x18030D1E
.long 0xBF820039
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802F118
.long 0xD3B2401A, 0x1802F51A
.long 0xD3B2401C, 0x1802F91C
.long 0xD3B2401E, 0x1802FD1E
.long 0xBF82001D
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802E118
.long 0xD3B2401A, 0x1802E51A
.long 0xD3B2401C, 0x1802E91C
.long 0xD3B2401E, 0x1802ED1E
.long 0xBF82000A
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802D118
.long 0xD3B2401A, 0x1802D51A
.long 0xD3B2401C, 0x1802D91C
.long 0xD3B2401E, 0x1802DD1E
.long 0xBF820000
.long 0x0A303030
.long 0x0A323230
.long 0x0A343430
.long 0x0A363630
.long 0x0A383830
.long 0x0A3A3A30
.long 0x0A3C3C30
.long 0x0A3E3E30
.long 0xD3A00018, 0x14622031
.long 0xD3A01019, 0x14662031
.long 0xD3A0001A, 0x146A2231
.long 0xD3A0101B, 0x146E2231
.long 0xD3A0001C, 0x14722431
.long 0xD3A0101D, 0x14762431
.long 0xD3A0001E, 0x147A2631
.long 0xD3A0101F, 0x147E2631
.long 0x7E301518
.long 0x7E321519
.long 0xD2A00018, 0x00023318
.long 0x7E34151A
.long 0x7E36151B
.long 0xD2A00019, 0x0002371A
.long 0x7E38151C
.long 0x7E3A151D
.long 0xD2A0001A, 0x00023B1C
.long 0x7E3C151E
.long 0x7E3E151F
.long 0xD2A0001B, 0x00023F1E
.long 0xE07CD000, 0x800E1807
.long 0xBF800000
.long 0xBF800000
.long 0xBF8211E0
.long 0x7E4C02FF, 0x80000000
.long 0xD0C9003C, 0x00003900
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0006, 0x02060102
.long 0xD1000006, 0x01020D26
.long 0xE0901000, 0x80040806
.long 0xD1FE0006, 0x020A0103
.long 0xD1000006, 0x01020D26
.long 0xD1FE0007, 0x02060103
.long 0xD1000007, 0x01020F26
.long 0xD1196A04, 0x00010300
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000A, 0x02060902
.long 0xD100000A, 0x01021526
.long 0xE0941000, 0x80040C0A
.long 0xD1FE000A, 0x020A0903
.long 0xD100000A, 0x01021526
.long 0xD1FE000B, 0x02060903
.long 0xD100000B, 0x01021726
.long 0xD1196A04, 0x00010500
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000E, 0x02060902
.long 0xD100000E, 0x01021D26
.long 0xE0901000, 0x8004100E
.long 0xD1FE000E, 0x020A0903
.long 0xD100000E, 0x01021D26
.long 0xD1FE000F, 0x02060903
.long 0xD100000F, 0x01021F26
.long 0xD1196A04, 0x00010700
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0012, 0x02060902
.long 0xD1000012, 0x01022526
.long 0xE0941000, 0x80041412
.long 0xD1FE0012, 0x020A0903
.long 0xD1000012, 0x01022526
.long 0xD1FE0013, 0x02060903
.long 0xD1000013, 0x01022726
.long 0xD1196A04, 0x00010900
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0016, 0x02060902
.long 0xD1000016, 0x01022D26
.long 0xE0901000, 0x80041816
.long 0xD1FE0016, 0x020A0903
.long 0xD1000016, 0x01022D26
.long 0xD1FE0017, 0x02060903
.long 0xD1000017, 0x01022F26
.long 0xD1196A04, 0x00010B00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE001A, 0x02060902
.long 0xD100001A, 0x01023526
.long 0xE0941000, 0x80041C1A
.long 0xD1FE001A, 0x020A0903
.long 0xD100001A, 0x01023526
.long 0xD1FE001B, 0x02060903
.long 0xD100001B, 0x01023726
.long 0xD1196A04, 0x00010D00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE001E, 0x02060902
.long 0xD100001E, 0x01023D26
.long 0xE0901000, 0x8004201E
.long 0xD1FE001E, 0x020A0903
.long 0xD100001E, 0x01023D26
.long 0xD1FE001F, 0x02060903
.long 0xD100001F, 0x01023F26
.long 0xD1196A04, 0x00010F00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0022, 0x02060902
.long 0xD1000022, 0x01024526
.long 0xE0941000, 0x80042422
.long 0xD1FE0022, 0x020A0903
.long 0xD1000022, 0x01024526
.long 0xD1FE0023, 0x02060903
.long 0xD1000023, 0x01024726
.long 0xD3D84009, 0x18000100
.long 0xD3D8400D, 0x18000104
.long 0xD3D84011, 0x18000101
.long 0xD3D84015, 0x18000105
.long 0xD3D84019, 0x18000102
.long 0xD3D8401D, 0x18000106
.long 0xD3D84021, 0x18000103
.long 0xD3D84025, 0x18000107
.long 0xBF800001
.long 0xE070D000, 0x80030906
.long 0xE070D000, 0x80030D0A
.long 0xE070D000, 0x8003110E
.long 0xE070D000, 0x80031512
.long 0xE070D000, 0x80031916
.long 0xE070D000, 0x80031D1A
.long 0xE070D000, 0x8003211E
.long 0xE070D000, 0x80032522
.long 0xBF800000
.long 0x92431415
.long 0x92330443
.long 0x92421403
.long 0x80420242
.long 0x80423342
.long 0x7E660566
.long 0x92431E43
.long 0x8F338633
.long 0x92333343
.long 0x80424233
.long 0x8E428242
.long 0x80184236
.long 0x82198037
.long 0xBF8C0000
.long 0x80B38132
.long 0xC2330CCC, 0x00000000
.long 0x9649811C
.long 0x9248811C
.long 0x80CC811D
.long 0x924C814C
.long 0x964B2A4C
.long 0x924A2A4C
.long 0x80484A48
.long 0x82494B49
.long 0x80CC811E
.long 0x924C814C
.long 0x964B2B4C
.long 0x924A2B4C
.long 0x80484A48
.long 0x82494B49
.long 0x8EC48248
.long 0x7E4C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xBF8CC07F
.long 0xBF068133
.long 0xBF8410EB
.long 0xE050D000, 0x80120906
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x80126806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x80127006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x80127806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x80128006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x80128806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x80129006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x80129806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C806
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D006
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D806
.long 0xBF8C0F7E
.long 0x0212D109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x80126827
.long 0xBF8C0F7E
.long 0x0212E109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x80127027
.long 0xBF8C0F7E
.long 0x0212F109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x80127827
.long 0xBF8C0F7E
.long 0x02130109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x80128027
.long 0xBF8C0F7E
.long 0x02131109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x80128827
.long 0xBF8C0F7E
.long 0x02132109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x80129027
.long 0xBF8C0F7E
.long 0x02133109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x80129827
.long 0xBF8C0F7E
.long 0x02134109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x8012A027
.long 0xBF8C0F7E
.long 0x02135109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x8012A827
.long 0xBF8C0F7E
.long 0x02136109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x8012B027
.long 0xBF8C0F7E
.long 0x02137109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x8012B827
.long 0xBF8C0F7E
.long 0x02138109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x8012C027
.long 0xBF8C0F7E
.long 0x02139109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x8012C827
.long 0xBF8C0F7E
.long 0x0213A109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x8012D027
.long 0xBF8C0F7E
.long 0x0213B109
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D06
.long 0xE050D000, 0x8012D827
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x0212D109
.long 0xBF8C0F7C
.long 0x0212E109
.long 0xBF8C0F7B
.long 0x0212F109
.long 0xBF8C0F7A
.long 0x02130109
.long 0xBF8C0F79
.long 0x02131109
.long 0xBF8C0F78
.long 0x02132109
.long 0xBF8C0F77
.long 0x02133109
.long 0xBF8C0F76
.long 0x02134109
.long 0xBF8C0F75
.long 0x02135109
.long 0xBF8C0F74
.long 0x02136109
.long 0xBF8C0F73
.long 0x02137109
.long 0xBF8C0F72
.long 0x02138109
.long 0xBF8C0F71
.long 0x02139109
.long 0xBF8C0F70
.long 0x0213A109
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x0212D109
.long 0xBF8C0F7B
.long 0x0212E109
.long 0xBF8C0F7A
.long 0x0212F109
.long 0xBF8C0F79
.long 0x02130109
.long 0xBF8C0F78
.long 0x02131109
.long 0xBF8C0F77
.long 0x02132109
.long 0xBF8C0F76
.long 0x02133109
.long 0xBF8C0F75
.long 0x02134109
.long 0xBF8C0F74
.long 0x02135109
.long 0xBF8C0F73
.long 0x02136109
.long 0xBF8C0F72
.long 0x02137109
.long 0xBF8C0F71
.long 0x02138109
.long 0xBF8C0F70
.long 0x02139109
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x0212D109
.long 0xBF8C0F7A
.long 0x0212E109
.long 0xBF8C0F79
.long 0x0212F109
.long 0xBF8C0F78
.long 0x02130109
.long 0xBF8C0F77
.long 0x02131109
.long 0xBF8C0F76
.long 0x02132109
.long 0xBF8C0F75
.long 0x02133109
.long 0xBF8C0F74
.long 0x02134109
.long 0xBF8C0F73
.long 0x02135109
.long 0xBF8C0F72
.long 0x02136109
.long 0xBF8C0F71
.long 0x02137109
.long 0xBF8C0F70
.long 0x02138109
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x0212D109
.long 0xBF8C0F79
.long 0x0212E109
.long 0xBF8C0F78
.long 0x0212F109
.long 0xBF8C0F77
.long 0x02130109
.long 0xBF8C0F76
.long 0x02131109
.long 0xBF8C0F75
.long 0x02132109
.long 0xBF8C0F74
.long 0x02133109
.long 0xBF8C0F73
.long 0x02134109
.long 0xBF8C0F72
.long 0x02135109
.long 0xBF8C0F71
.long 0x02136109
.long 0xBF8C0F70
.long 0x02137109
.long 0xBF820078
.long 0xBF8C0F79
.long 0x0212D109
.long 0xBF8C0F78
.long 0x0212E109
.long 0xBF8C0F77
.long 0x0212F109
.long 0xBF8C0F76
.long 0x02130109
.long 0xBF8C0F75
.long 0x02131109
.long 0xBF8C0F74
.long 0x02132109
.long 0xBF8C0F73
.long 0x02133109
.long 0xBF8C0F72
.long 0x02134109
.long 0xBF8C0F71
.long 0x02135109
.long 0xBF8C0F70
.long 0x02136109
.long 0xBF820063
.long 0xBF8C0F78
.long 0x0212D109
.long 0xBF8C0F77
.long 0x0212E109
.long 0xBF8C0F76
.long 0x0212F109
.long 0xBF8C0F75
.long 0x02130109
.long 0xBF8C0F74
.long 0x02131109
.long 0xBF8C0F73
.long 0x02132109
.long 0xBF8C0F72
.long 0x02133109
.long 0xBF8C0F71
.long 0x02134109
.long 0xBF8C0F70
.long 0x02135109
.long 0xBF820050
.long 0xBF8C0F77
.long 0x0212D109
.long 0xBF8C0F76
.long 0x0212E109
.long 0xBF8C0F75
.long 0x0212F109
.long 0xBF8C0F74
.long 0x02130109
.long 0xBF8C0F73
.long 0x02131109
.long 0xBF8C0F72
.long 0x02132109
.long 0xBF8C0F71
.long 0x02133109
.long 0xBF8C0F70
.long 0x02134109
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x0212D109
.long 0xBF8C0F75
.long 0x0212E109
.long 0xBF8C0F74
.long 0x0212F109
.long 0xBF8C0F73
.long 0x02130109
.long 0xBF8C0F72
.long 0x02131109
.long 0xBF8C0F71
.long 0x02132109
.long 0xBF8C0F70
.long 0x02133109
.long 0xBF820030
.long 0xBF8C0F75
.long 0x0212D109
.long 0xBF8C0F74
.long 0x0212E109
.long 0xBF8C0F73
.long 0x0212F109
.long 0xBF8C0F72
.long 0x02130109
.long 0xBF8C0F71
.long 0x02131109
.long 0xBF8C0F70
.long 0x02132109
.long 0xBF820023
.long 0xBF8C0F74
.long 0x0212D109
.long 0xBF8C0F73
.long 0x0212E109
.long 0xBF8C0F72
.long 0x0212F109
.long 0xBF8C0F71
.long 0x02130109
.long 0xBF8C0F70
.long 0x02131109
.long 0xBF820018
.long 0xBF8C0F73
.long 0x0212D109
.long 0xBF8C0F72
.long 0x0212E109
.long 0xBF8C0F71
.long 0x0212F109
.long 0xBF8C0F70
.long 0x02130109
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x0212D109
.long 0xBF8C0F71
.long 0x0212E109
.long 0xBF8C0F70
.long 0x0212F109
.long 0xBF820008
.long 0xBF8C0F71
.long 0x0212D109
.long 0xBF8C0F70
.long 0x0212E109
.long 0xBF820003
.long 0xBF8C0F70
.long 0x0212D109
.long 0xBF820000
.long 0x7E4C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80120D0A
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x8012680A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x8012700A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x8012780A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x8012800A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x8012880A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x8012900A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x8012980A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A00A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A80A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B00A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B80A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C00A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C80A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D00A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D80A
.long 0xBF8C0F7E
.long 0x021AD10D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x80126827
.long 0xBF8C0F7E
.long 0x021AE10D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x80127027
.long 0xBF8C0F7E
.long 0x021AF10D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x80127827
.long 0xBF8C0F7E
.long 0x021B010D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x80128027
.long 0xBF8C0F7E
.long 0x021B110D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x80128827
.long 0xBF8C0F7E
.long 0x021B210D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x80129027
.long 0xBF8C0F7E
.long 0x021B310D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x80129827
.long 0xBF8C0F7E
.long 0x021B410D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x8012A027
.long 0xBF8C0F7E
.long 0x021B510D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x8012A827
.long 0xBF8C0F7E
.long 0x021B610D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x8012B027
.long 0xBF8C0F7E
.long 0x021B710D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x8012B827
.long 0xBF8C0F7E
.long 0x021B810D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x8012C027
.long 0xBF8C0F7E
.long 0x021B910D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x8012C827
.long 0xBF8C0F7E
.long 0x021BA10D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x8012D027
.long 0xBF8C0F7E
.long 0x021BB10D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0A
.long 0xE050D000, 0x8012D827
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x021AD10D
.long 0xBF8C0F7C
.long 0x021AE10D
.long 0xBF8C0F7B
.long 0x021AF10D
.long 0xBF8C0F7A
.long 0x021B010D
.long 0xBF8C0F79
.long 0x021B110D
.long 0xBF8C0F78
.long 0x021B210D
.long 0xBF8C0F77
.long 0x021B310D
.long 0xBF8C0F76
.long 0x021B410D
.long 0xBF8C0F75
.long 0x021B510D
.long 0xBF8C0F74
.long 0x021B610D
.long 0xBF8C0F73
.long 0x021B710D
.long 0xBF8C0F72
.long 0x021B810D
.long 0xBF8C0F71
.long 0x021B910D
.long 0xBF8C0F70
.long 0x021BA10D
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x021AD10D
.long 0xBF8C0F7B
.long 0x021AE10D
.long 0xBF8C0F7A
.long 0x021AF10D
.long 0xBF8C0F79
.long 0x021B010D
.long 0xBF8C0F78
.long 0x021B110D
.long 0xBF8C0F77
.long 0x021B210D
.long 0xBF8C0F76
.long 0x021B310D
.long 0xBF8C0F75
.long 0x021B410D
.long 0xBF8C0F74
.long 0x021B510D
.long 0xBF8C0F73
.long 0x021B610D
.long 0xBF8C0F72
.long 0x021B710D
.long 0xBF8C0F71
.long 0x021B810D
.long 0xBF8C0F70
.long 0x021B910D
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x021AD10D
.long 0xBF8C0F7A
.long 0x021AE10D
.long 0xBF8C0F79
.long 0x021AF10D
.long 0xBF8C0F78
.long 0x021B010D
.long 0xBF8C0F77
.long 0x021B110D
.long 0xBF8C0F76
.long 0x021B210D
.long 0xBF8C0F75
.long 0x021B310D
.long 0xBF8C0F74
.long 0x021B410D
.long 0xBF8C0F73
.long 0x021B510D
.long 0xBF8C0F72
.long 0x021B610D
.long 0xBF8C0F71
.long 0x021B710D
.long 0xBF8C0F70
.long 0x021B810D
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x021AD10D
.long 0xBF8C0F79
.long 0x021AE10D
.long 0xBF8C0F78
.long 0x021AF10D
.long 0xBF8C0F77
.long 0x021B010D
.long 0xBF8C0F76
.long 0x021B110D
.long 0xBF8C0F75
.long 0x021B210D
.long 0xBF8C0F74
.long 0x021B310D
.long 0xBF8C0F73
.long 0x021B410D
.long 0xBF8C0F72
.long 0x021B510D
.long 0xBF8C0F71
.long 0x021B610D
.long 0xBF8C0F70
.long 0x021B710D
.long 0xBF820078
.long 0xBF8C0F79
.long 0x021AD10D
.long 0xBF8C0F78
.long 0x021AE10D
.long 0xBF8C0F77
.long 0x021AF10D
.long 0xBF8C0F76
.long 0x021B010D
.long 0xBF8C0F75
.long 0x021B110D
.long 0xBF8C0F74
.long 0x021B210D
.long 0xBF8C0F73
.long 0x021B310D
.long 0xBF8C0F72
.long 0x021B410D
.long 0xBF8C0F71
.long 0x021B510D
.long 0xBF8C0F70
.long 0x021B610D
.long 0xBF820063
.long 0xBF8C0F78
.long 0x021AD10D
.long 0xBF8C0F77
.long 0x021AE10D
.long 0xBF8C0F76
.long 0x021AF10D
.long 0xBF8C0F75
.long 0x021B010D
.long 0xBF8C0F74
.long 0x021B110D
.long 0xBF8C0F73
.long 0x021B210D
.long 0xBF8C0F72
.long 0x021B310D
.long 0xBF8C0F71
.long 0x021B410D
.long 0xBF8C0F70
.long 0x021B510D
.long 0xBF820050
.long 0xBF8C0F77
.long 0x021AD10D
.long 0xBF8C0F76
.long 0x021AE10D
.long 0xBF8C0F75
.long 0x021AF10D
.long 0xBF8C0F74
.long 0x021B010D
.long 0xBF8C0F73
.long 0x021B110D
.long 0xBF8C0F72
.long 0x021B210D
.long 0xBF8C0F71
.long 0x021B310D
.long 0xBF8C0F70
.long 0x021B410D
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x021AD10D
.long 0xBF8C0F75
.long 0x021AE10D
.long 0xBF8C0F74
.long 0x021AF10D
.long 0xBF8C0F73
.long 0x021B010D
.long 0xBF8C0F72
.long 0x021B110D
.long 0xBF8C0F71
.long 0x021B210D
.long 0xBF8C0F70
.long 0x021B310D
.long 0xBF820030
.long 0xBF8C0F75
.long 0x021AD10D
.long 0xBF8C0F74
.long 0x021AE10D
.long 0xBF8C0F73
.long 0x021AF10D
.long 0xBF8C0F72
.long 0x021B010D
.long 0xBF8C0F71
.long 0x021B110D
.long 0xBF8C0F70
.long 0x021B210D
.long 0xBF820023
.long 0xBF8C0F74
.long 0x021AD10D
.long 0xBF8C0F73
.long 0x021AE10D
.long 0xBF8C0F72
.long 0x021AF10D
.long 0xBF8C0F71
.long 0x021B010D
.long 0xBF8C0F70
.long 0x021B110D
.long 0xBF820018
.long 0xBF8C0F73
.long 0x021AD10D
.long 0xBF8C0F72
.long 0x021AE10D
.long 0xBF8C0F71
.long 0x021AF10D
.long 0xBF8C0F70
.long 0x021B010D
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x021AD10D
.long 0xBF8C0F71
.long 0x021AE10D
.long 0xBF8C0F70
.long 0x021AF10D
.long 0xBF820008
.long 0xBF8C0F71
.long 0x021AD10D
.long 0xBF8C0F70
.long 0x021AE10D
.long 0xBF820003
.long 0xBF8C0F70
.long 0x021AD10D
.long 0xBF820000
.long 0x7E4C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x8012110E
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x8012680E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x8012700E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x8012780E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x8012800E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x8012880E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x8012900E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x8012980E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A00E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A80E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B00E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B80E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C00E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C80E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D00E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D80E
.long 0xBF8C0F7E
.long 0x0222D111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x80126827
.long 0xBF8C0F7E
.long 0x0222E111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x80127027
.long 0xBF8C0F7E
.long 0x0222F111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x80127827
.long 0xBF8C0F7E
.long 0x02230111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x80128027
.long 0xBF8C0F7E
.long 0x02231111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x80128827
.long 0xBF8C0F7E
.long 0x02232111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x80129027
.long 0xBF8C0F7E
.long 0x02233111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x80129827
.long 0xBF8C0F7E
.long 0x02234111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x8012A027
.long 0xBF8C0F7E
.long 0x02235111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x8012A827
.long 0xBF8C0F7E
.long 0x02236111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x8012B027
.long 0xBF8C0F7E
.long 0x02237111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x8012B827
.long 0xBF8C0F7E
.long 0x02238111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x8012C027
.long 0xBF8C0F7E
.long 0x02239111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x8012C827
.long 0xBF8C0F7E
.long 0x0223A111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x8012D027
.long 0xBF8C0F7E
.long 0x0223B111
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D0E
.long 0xE050D000, 0x8012D827
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x0222D111
.long 0xBF8C0F7C
.long 0x0222E111
.long 0xBF8C0F7B
.long 0x0222F111
.long 0xBF8C0F7A
.long 0x02230111
.long 0xBF8C0F79
.long 0x02231111
.long 0xBF8C0F78
.long 0x02232111
.long 0xBF8C0F77
.long 0x02233111
.long 0xBF8C0F76
.long 0x02234111
.long 0xBF8C0F75
.long 0x02235111
.long 0xBF8C0F74
.long 0x02236111
.long 0xBF8C0F73
.long 0x02237111
.long 0xBF8C0F72
.long 0x02238111
.long 0xBF8C0F71
.long 0x02239111
.long 0xBF8C0F70
.long 0x0223A111
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x0222D111
.long 0xBF8C0F7B
.long 0x0222E111
.long 0xBF8C0F7A
.long 0x0222F111
.long 0xBF8C0F79
.long 0x02230111
.long 0xBF8C0F78
.long 0x02231111
.long 0xBF8C0F77
.long 0x02232111
.long 0xBF8C0F76
.long 0x02233111
.long 0xBF8C0F75
.long 0x02234111
.long 0xBF8C0F74
.long 0x02235111
.long 0xBF8C0F73
.long 0x02236111
.long 0xBF8C0F72
.long 0x02237111
.long 0xBF8C0F71
.long 0x02238111
.long 0xBF8C0F70
.long 0x02239111
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x0222D111
.long 0xBF8C0F7A
.long 0x0222E111
.long 0xBF8C0F79
.long 0x0222F111
.long 0xBF8C0F78
.long 0x02230111
.long 0xBF8C0F77
.long 0x02231111
.long 0xBF8C0F76
.long 0x02232111
.long 0xBF8C0F75
.long 0x02233111
.long 0xBF8C0F74
.long 0x02234111
.long 0xBF8C0F73
.long 0x02235111
.long 0xBF8C0F72
.long 0x02236111
.long 0xBF8C0F71
.long 0x02237111
.long 0xBF8C0F70
.long 0x02238111
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x0222D111
.long 0xBF8C0F79
.long 0x0222E111
.long 0xBF8C0F78
.long 0x0222F111
.long 0xBF8C0F77
.long 0x02230111
.long 0xBF8C0F76
.long 0x02231111
.long 0xBF8C0F75
.long 0x02232111
.long 0xBF8C0F74
.long 0x02233111
.long 0xBF8C0F73
.long 0x02234111
.long 0xBF8C0F72
.long 0x02235111
.long 0xBF8C0F71
.long 0x02236111
.long 0xBF8C0F70
.long 0x02237111
.long 0xBF820078
.long 0xBF8C0F79
.long 0x0222D111
.long 0xBF8C0F78
.long 0x0222E111
.long 0xBF8C0F77
.long 0x0222F111
.long 0xBF8C0F76
.long 0x02230111
.long 0xBF8C0F75
.long 0x02231111
.long 0xBF8C0F74
.long 0x02232111
.long 0xBF8C0F73
.long 0x02233111
.long 0xBF8C0F72
.long 0x02234111
.long 0xBF8C0F71
.long 0x02235111
.long 0xBF8C0F70
.long 0x02236111
.long 0xBF820063
.long 0xBF8C0F78
.long 0x0222D111
.long 0xBF8C0F77
.long 0x0222E111
.long 0xBF8C0F76
.long 0x0222F111
.long 0xBF8C0F75
.long 0x02230111
.long 0xBF8C0F74
.long 0x02231111
.long 0xBF8C0F73
.long 0x02232111
.long 0xBF8C0F72
.long 0x02233111
.long 0xBF8C0F71
.long 0x02234111
.long 0xBF8C0F70
.long 0x02235111
.long 0xBF820050
.long 0xBF8C0F77
.long 0x0222D111
.long 0xBF8C0F76
.long 0x0222E111
.long 0xBF8C0F75
.long 0x0222F111
.long 0xBF8C0F74
.long 0x02230111
.long 0xBF8C0F73
.long 0x02231111
.long 0xBF8C0F72
.long 0x02232111
.long 0xBF8C0F71
.long 0x02233111
.long 0xBF8C0F70
.long 0x02234111
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x0222D111
.long 0xBF8C0F75
.long 0x0222E111
.long 0xBF8C0F74
.long 0x0222F111
.long 0xBF8C0F73
.long 0x02230111
.long 0xBF8C0F72
.long 0x02231111
.long 0xBF8C0F71
.long 0x02232111
.long 0xBF8C0F70
.long 0x02233111
.long 0xBF820030
.long 0xBF8C0F75
.long 0x0222D111
.long 0xBF8C0F74
.long 0x0222E111
.long 0xBF8C0F73
.long 0x0222F111
.long 0xBF8C0F72
.long 0x02230111
.long 0xBF8C0F71
.long 0x02231111
.long 0xBF8C0F70
.long 0x02232111
.long 0xBF820023
.long 0xBF8C0F74
.long 0x0222D111
.long 0xBF8C0F73
.long 0x0222E111
.long 0xBF8C0F72
.long 0x0222F111
.long 0xBF8C0F71
.long 0x02230111
.long 0xBF8C0F70
.long 0x02231111
.long 0xBF820018
.long 0xBF8C0F73
.long 0x0222D111
.long 0xBF8C0F72
.long 0x0222E111
.long 0xBF8C0F71
.long 0x0222F111
.long 0xBF8C0F70
.long 0x02230111
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x0222D111
.long 0xBF8C0F71
.long 0x0222E111
.long 0xBF8C0F70
.long 0x0222F111
.long 0xBF820008
.long 0xBF8C0F71
.long 0x0222D111
.long 0xBF8C0F70
.long 0x0222E111
.long 0xBF820003
.long 0xBF8C0F70
.long 0x0222D111
.long 0xBF820000
.long 0x7E4C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80121512
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x80126812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x80127012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x80127812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x80128012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x80128812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x80129012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x80129812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C812
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D012
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D812
.long 0xBF8C0F7E
.long 0x022AD115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x80126827
.long 0xBF8C0F7E
.long 0x022AE115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x80127027
.long 0xBF8C0F7E
.long 0x022AF115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x80127827
.long 0xBF8C0F7E
.long 0x022B0115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x80128027
.long 0xBF8C0F7E
.long 0x022B1115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x80128827
.long 0xBF8C0F7E
.long 0x022B2115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x80129027
.long 0xBF8C0F7E
.long 0x022B3115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x80129827
.long 0xBF8C0F7E
.long 0x022B4115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x8012A027
.long 0xBF8C0F7E
.long 0x022B5115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x8012A827
.long 0xBF8C0F7E
.long 0x022B6115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x8012B027
.long 0xBF8C0F7E
.long 0x022B7115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x8012B827
.long 0xBF8C0F7E
.long 0x022B8115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x8012C027
.long 0xBF8C0F7E
.long 0x022B9115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x8012C827
.long 0xBF8C0F7E
.long 0x022BA115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x8012D027
.long 0xBF8C0F7E
.long 0x022BB115
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D12
.long 0xE050D000, 0x8012D827
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x022AD115
.long 0xBF8C0F7C
.long 0x022AE115
.long 0xBF8C0F7B
.long 0x022AF115
.long 0xBF8C0F7A
.long 0x022B0115
.long 0xBF8C0F79
.long 0x022B1115
.long 0xBF8C0F78
.long 0x022B2115
.long 0xBF8C0F77
.long 0x022B3115
.long 0xBF8C0F76
.long 0x022B4115
.long 0xBF8C0F75
.long 0x022B5115
.long 0xBF8C0F74
.long 0x022B6115
.long 0xBF8C0F73
.long 0x022B7115
.long 0xBF8C0F72
.long 0x022B8115
.long 0xBF8C0F71
.long 0x022B9115
.long 0xBF8C0F70
.long 0x022BA115
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x022AD115
.long 0xBF8C0F7B
.long 0x022AE115
.long 0xBF8C0F7A
.long 0x022AF115
.long 0xBF8C0F79
.long 0x022B0115
.long 0xBF8C0F78
.long 0x022B1115
.long 0xBF8C0F77
.long 0x022B2115
.long 0xBF8C0F76
.long 0x022B3115
.long 0xBF8C0F75
.long 0x022B4115
.long 0xBF8C0F74
.long 0x022B5115
.long 0xBF8C0F73
.long 0x022B6115
.long 0xBF8C0F72
.long 0x022B7115
.long 0xBF8C0F71
.long 0x022B8115
.long 0xBF8C0F70
.long 0x022B9115
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x022AD115
.long 0xBF8C0F7A
.long 0x022AE115
.long 0xBF8C0F79
.long 0x022AF115
.long 0xBF8C0F78
.long 0x022B0115
.long 0xBF8C0F77
.long 0x022B1115
.long 0xBF8C0F76
.long 0x022B2115
.long 0xBF8C0F75
.long 0x022B3115
.long 0xBF8C0F74
.long 0x022B4115
.long 0xBF8C0F73
.long 0x022B5115
.long 0xBF8C0F72
.long 0x022B6115
.long 0xBF8C0F71
.long 0x022B7115
.long 0xBF8C0F70
.long 0x022B8115
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x022AD115
.long 0xBF8C0F79
.long 0x022AE115
.long 0xBF8C0F78
.long 0x022AF115
.long 0xBF8C0F77
.long 0x022B0115
.long 0xBF8C0F76
.long 0x022B1115
.long 0xBF8C0F75
.long 0x022B2115
.long 0xBF8C0F74
.long 0x022B3115
.long 0xBF8C0F73
.long 0x022B4115
.long 0xBF8C0F72
.long 0x022B5115
.long 0xBF8C0F71
.long 0x022B6115
.long 0xBF8C0F70
.long 0x022B7115
.long 0xBF820078
.long 0xBF8C0F79
.long 0x022AD115
.long 0xBF8C0F78
.long 0x022AE115
.long 0xBF8C0F77
.long 0x022AF115
.long 0xBF8C0F76
.long 0x022B0115
.long 0xBF8C0F75
.long 0x022B1115
.long 0xBF8C0F74
.long 0x022B2115
.long 0xBF8C0F73
.long 0x022B3115
.long 0xBF8C0F72
.long 0x022B4115
.long 0xBF8C0F71
.long 0x022B5115
.long 0xBF8C0F70
.long 0x022B6115
.long 0xBF820063
.long 0xBF8C0F78
.long 0x022AD115
.long 0xBF8C0F77
.long 0x022AE115
.long 0xBF8C0F76
.long 0x022AF115
.long 0xBF8C0F75
.long 0x022B0115
.long 0xBF8C0F74
.long 0x022B1115
.long 0xBF8C0F73
.long 0x022B2115
.long 0xBF8C0F72
.long 0x022B3115
.long 0xBF8C0F71
.long 0x022B4115
.long 0xBF8C0F70
.long 0x022B5115
.long 0xBF820050
.long 0xBF8C0F77
.long 0x022AD115
.long 0xBF8C0F76
.long 0x022AE115
.long 0xBF8C0F75
.long 0x022AF115
.long 0xBF8C0F74
.long 0x022B0115
.long 0xBF8C0F73
.long 0x022B1115
.long 0xBF8C0F72
.long 0x022B2115
.long 0xBF8C0F71
.long 0x022B3115
.long 0xBF8C0F70
.long 0x022B4115
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x022AD115
.long 0xBF8C0F75
.long 0x022AE115
.long 0xBF8C0F74
.long 0x022AF115
.long 0xBF8C0F73
.long 0x022B0115
.long 0xBF8C0F72
.long 0x022B1115
.long 0xBF8C0F71
.long 0x022B2115
.long 0xBF8C0F70
.long 0x022B3115
.long 0xBF820030
.long 0xBF8C0F75
.long 0x022AD115
.long 0xBF8C0F74
.long 0x022AE115
.long 0xBF8C0F73
.long 0x022AF115
.long 0xBF8C0F72
.long 0x022B0115
.long 0xBF8C0F71
.long 0x022B1115
.long 0xBF8C0F70
.long 0x022B2115
.long 0xBF820023
.long 0xBF8C0F74
.long 0x022AD115
.long 0xBF8C0F73
.long 0x022AE115
.long 0xBF8C0F72
.long 0x022AF115
.long 0xBF8C0F71
.long 0x022B0115
.long 0xBF8C0F70
.long 0x022B1115
.long 0xBF820018
.long 0xBF8C0F73
.long 0x022AD115
.long 0xBF8C0F72
.long 0x022AE115
.long 0xBF8C0F71
.long 0x022AF115
.long 0xBF8C0F70
.long 0x022B0115
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x022AD115
.long 0xBF8C0F71
.long 0x022AE115
.long 0xBF8C0F70
.long 0x022AF115
.long 0xBF820008
.long 0xBF8C0F71
.long 0x022AD115
.long 0xBF8C0F70
.long 0x022AE115
.long 0xBF820003
.long 0xBF8C0F70
.long 0x022AD115
.long 0xBF820000
.long 0x7E4C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80121916
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x80126816
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x80127016
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x80127816
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x80128016
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x80128816
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x80129016
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x80129816
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A016
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A816
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B016
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B816
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C016
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C816
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D016
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D816
.long 0xBF8C0F7E
.long 0x0232D119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x80126827
.long 0xBF8C0F7E
.long 0x0232E119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x80127027
.long 0xBF8C0F7E
.long 0x0232F119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x80127827
.long 0xBF8C0F7E
.long 0x02330119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x80128027
.long 0xBF8C0F7E
.long 0x02331119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x80128827
.long 0xBF8C0F7E
.long 0x02332119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x80129027
.long 0xBF8C0F7E
.long 0x02333119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x80129827
.long 0xBF8C0F7E
.long 0x02334119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x8012A027
.long 0xBF8C0F7E
.long 0x02335119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x8012A827
.long 0xBF8C0F7E
.long 0x02336119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x8012B027
.long 0xBF8C0F7E
.long 0x02337119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x8012B827
.long 0xBF8C0F7E
.long 0x02338119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x8012C027
.long 0xBF8C0F7E
.long 0x02339119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x8012C827
.long 0xBF8C0F7E
.long 0x0233A119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x8012D027
.long 0xBF8C0F7E
.long 0x0233B119
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D16
.long 0xE050D000, 0x8012D827
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x0232D119
.long 0xBF8C0F7C
.long 0x0232E119
.long 0xBF8C0F7B
.long 0x0232F119
.long 0xBF8C0F7A
.long 0x02330119
.long 0xBF8C0F79
.long 0x02331119
.long 0xBF8C0F78
.long 0x02332119
.long 0xBF8C0F77
.long 0x02333119
.long 0xBF8C0F76
.long 0x02334119
.long 0xBF8C0F75
.long 0x02335119
.long 0xBF8C0F74
.long 0x02336119
.long 0xBF8C0F73
.long 0x02337119
.long 0xBF8C0F72
.long 0x02338119
.long 0xBF8C0F71
.long 0x02339119
.long 0xBF8C0F70
.long 0x0233A119
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x0232D119
.long 0xBF8C0F7B
.long 0x0232E119
.long 0xBF8C0F7A
.long 0x0232F119
.long 0xBF8C0F79
.long 0x02330119
.long 0xBF8C0F78
.long 0x02331119
.long 0xBF8C0F77
.long 0x02332119
.long 0xBF8C0F76
.long 0x02333119
.long 0xBF8C0F75
.long 0x02334119
.long 0xBF8C0F74
.long 0x02335119
.long 0xBF8C0F73
.long 0x02336119
.long 0xBF8C0F72
.long 0x02337119
.long 0xBF8C0F71
.long 0x02338119
.long 0xBF8C0F70
.long 0x02339119
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x0232D119
.long 0xBF8C0F7A
.long 0x0232E119
.long 0xBF8C0F79
.long 0x0232F119
.long 0xBF8C0F78
.long 0x02330119
.long 0xBF8C0F77
.long 0x02331119
.long 0xBF8C0F76
.long 0x02332119
.long 0xBF8C0F75
.long 0x02333119
.long 0xBF8C0F74
.long 0x02334119
.long 0xBF8C0F73
.long 0x02335119
.long 0xBF8C0F72
.long 0x02336119
.long 0xBF8C0F71
.long 0x02337119
.long 0xBF8C0F70
.long 0x02338119
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x0232D119
.long 0xBF8C0F79
.long 0x0232E119
.long 0xBF8C0F78
.long 0x0232F119
.long 0xBF8C0F77
.long 0x02330119
.long 0xBF8C0F76
.long 0x02331119
.long 0xBF8C0F75
.long 0x02332119
.long 0xBF8C0F74
.long 0x02333119
.long 0xBF8C0F73
.long 0x02334119
.long 0xBF8C0F72
.long 0x02335119
.long 0xBF8C0F71
.long 0x02336119
.long 0xBF8C0F70
.long 0x02337119
.long 0xBF820078
.long 0xBF8C0F79
.long 0x0232D119
.long 0xBF8C0F78
.long 0x0232E119
.long 0xBF8C0F77
.long 0x0232F119
.long 0xBF8C0F76
.long 0x02330119
.long 0xBF8C0F75
.long 0x02331119
.long 0xBF8C0F74
.long 0x02332119
.long 0xBF8C0F73
.long 0x02333119
.long 0xBF8C0F72
.long 0x02334119
.long 0xBF8C0F71
.long 0x02335119
.long 0xBF8C0F70
.long 0x02336119
.long 0xBF820063
.long 0xBF8C0F78
.long 0x0232D119
.long 0xBF8C0F77
.long 0x0232E119
.long 0xBF8C0F76
.long 0x0232F119
.long 0xBF8C0F75
.long 0x02330119
.long 0xBF8C0F74
.long 0x02331119
.long 0xBF8C0F73
.long 0x02332119
.long 0xBF8C0F72
.long 0x02333119
.long 0xBF8C0F71
.long 0x02334119
.long 0xBF8C0F70
.long 0x02335119
.long 0xBF820050
.long 0xBF8C0F77
.long 0x0232D119
.long 0xBF8C0F76
.long 0x0232E119
.long 0xBF8C0F75
.long 0x0232F119
.long 0xBF8C0F74
.long 0x02330119
.long 0xBF8C0F73
.long 0x02331119
.long 0xBF8C0F72
.long 0x02332119
.long 0xBF8C0F71
.long 0x02333119
.long 0xBF8C0F70
.long 0x02334119
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x0232D119
.long 0xBF8C0F75
.long 0x0232E119
.long 0xBF8C0F74
.long 0x0232F119
.long 0xBF8C0F73
.long 0x02330119
.long 0xBF8C0F72
.long 0x02331119
.long 0xBF8C0F71
.long 0x02332119
.long 0xBF8C0F70
.long 0x02333119
.long 0xBF820030
.long 0xBF8C0F75
.long 0x0232D119
.long 0xBF8C0F74
.long 0x0232E119
.long 0xBF8C0F73
.long 0x0232F119
.long 0xBF8C0F72
.long 0x02330119
.long 0xBF8C0F71
.long 0x02331119
.long 0xBF8C0F70
.long 0x02332119
.long 0xBF820023
.long 0xBF8C0F74
.long 0x0232D119
.long 0xBF8C0F73
.long 0x0232E119
.long 0xBF8C0F72
.long 0x0232F119
.long 0xBF8C0F71
.long 0x02330119
.long 0xBF8C0F70
.long 0x02331119
.long 0xBF820018
.long 0xBF8C0F73
.long 0x0232D119
.long 0xBF8C0F72
.long 0x0232E119
.long 0xBF8C0F71
.long 0x0232F119
.long 0xBF8C0F70
.long 0x02330119
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x0232D119
.long 0xBF8C0F71
.long 0x0232E119
.long 0xBF8C0F70
.long 0x0232F119
.long 0xBF820008
.long 0xBF8C0F71
.long 0x0232D119
.long 0xBF8C0F70
.long 0x0232E119
.long 0xBF820003
.long 0xBF8C0F70
.long 0x0232D119
.long 0xBF820000
.long 0x7E4C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80121D1A
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x8012681A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x8012701A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x8012781A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x8012801A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x8012881A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x8012901A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x8012981A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A01A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A81A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B01A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B81A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C01A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C81A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D01A
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D81A
.long 0xBF8C0F7E
.long 0x023AD11D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x80126827
.long 0xBF8C0F7E
.long 0x023AE11D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x80127027
.long 0xBF8C0F7E
.long 0x023AF11D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x80127827
.long 0xBF8C0F7E
.long 0x023B011D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x80128027
.long 0xBF8C0F7E
.long 0x023B111D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x80128827
.long 0xBF8C0F7E
.long 0x023B211D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x80129027
.long 0xBF8C0F7E
.long 0x023B311D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x80129827
.long 0xBF8C0F7E
.long 0x023B411D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x8012A027
.long 0xBF8C0F7E
.long 0x023B511D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x8012A827
.long 0xBF8C0F7E
.long 0x023B611D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x8012B027
.long 0xBF8C0F7E
.long 0x023B711D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x8012B827
.long 0xBF8C0F7E
.long 0x023B811D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x8012C027
.long 0xBF8C0F7E
.long 0x023B911D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x8012C827
.long 0xBF8C0F7E
.long 0x023BA11D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x8012D027
.long 0xBF8C0F7E
.long 0x023BB11D
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1A
.long 0xE050D000, 0x8012D827
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x023AD11D
.long 0xBF8C0F7C
.long 0x023AE11D
.long 0xBF8C0F7B
.long 0x023AF11D
.long 0xBF8C0F7A
.long 0x023B011D
.long 0xBF8C0F79
.long 0x023B111D
.long 0xBF8C0F78
.long 0x023B211D
.long 0xBF8C0F77
.long 0x023B311D
.long 0xBF8C0F76
.long 0x023B411D
.long 0xBF8C0F75
.long 0x023B511D
.long 0xBF8C0F74
.long 0x023B611D
.long 0xBF8C0F73
.long 0x023B711D
.long 0xBF8C0F72
.long 0x023B811D
.long 0xBF8C0F71
.long 0x023B911D
.long 0xBF8C0F70
.long 0x023BA11D
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x023AD11D
.long 0xBF8C0F7B
.long 0x023AE11D
.long 0xBF8C0F7A
.long 0x023AF11D
.long 0xBF8C0F79
.long 0x023B011D
.long 0xBF8C0F78
.long 0x023B111D
.long 0xBF8C0F77
.long 0x023B211D
.long 0xBF8C0F76
.long 0x023B311D
.long 0xBF8C0F75
.long 0x023B411D
.long 0xBF8C0F74
.long 0x023B511D
.long 0xBF8C0F73
.long 0x023B611D
.long 0xBF8C0F72
.long 0x023B711D
.long 0xBF8C0F71
.long 0x023B811D
.long 0xBF8C0F70
.long 0x023B911D
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x023AD11D
.long 0xBF8C0F7A
.long 0x023AE11D
.long 0xBF8C0F79
.long 0x023AF11D
.long 0xBF8C0F78
.long 0x023B011D
.long 0xBF8C0F77
.long 0x023B111D
.long 0xBF8C0F76
.long 0x023B211D
.long 0xBF8C0F75
.long 0x023B311D
.long 0xBF8C0F74
.long 0x023B411D
.long 0xBF8C0F73
.long 0x023B511D
.long 0xBF8C0F72
.long 0x023B611D
.long 0xBF8C0F71
.long 0x023B711D
.long 0xBF8C0F70
.long 0x023B811D
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x023AD11D
.long 0xBF8C0F79
.long 0x023AE11D
.long 0xBF8C0F78
.long 0x023AF11D
.long 0xBF8C0F77
.long 0x023B011D
.long 0xBF8C0F76
.long 0x023B111D
.long 0xBF8C0F75
.long 0x023B211D
.long 0xBF8C0F74
.long 0x023B311D
.long 0xBF8C0F73
.long 0x023B411D
.long 0xBF8C0F72
.long 0x023B511D
.long 0xBF8C0F71
.long 0x023B611D
.long 0xBF8C0F70
.long 0x023B711D
.long 0xBF820078
.long 0xBF8C0F79
.long 0x023AD11D
.long 0xBF8C0F78
.long 0x023AE11D
.long 0xBF8C0F77
.long 0x023AF11D
.long 0xBF8C0F76
.long 0x023B011D
.long 0xBF8C0F75
.long 0x023B111D
.long 0xBF8C0F74
.long 0x023B211D
.long 0xBF8C0F73
.long 0x023B311D
.long 0xBF8C0F72
.long 0x023B411D
.long 0xBF8C0F71
.long 0x023B511D
.long 0xBF8C0F70
.long 0x023B611D
.long 0xBF820063
.long 0xBF8C0F78
.long 0x023AD11D
.long 0xBF8C0F77
.long 0x023AE11D
.long 0xBF8C0F76
.long 0x023AF11D
.long 0xBF8C0F75
.long 0x023B011D
.long 0xBF8C0F74
.long 0x023B111D
.long 0xBF8C0F73
.long 0x023B211D
.long 0xBF8C0F72
.long 0x023B311D
.long 0xBF8C0F71
.long 0x023B411D
.long 0xBF8C0F70
.long 0x023B511D
.long 0xBF820050
.long 0xBF8C0F77
.long 0x023AD11D
.long 0xBF8C0F76
.long 0x023AE11D
.long 0xBF8C0F75
.long 0x023AF11D
.long 0xBF8C0F74
.long 0x023B011D
.long 0xBF8C0F73
.long 0x023B111D
.long 0xBF8C0F72
.long 0x023B211D
.long 0xBF8C0F71
.long 0x023B311D
.long 0xBF8C0F70
.long 0x023B411D
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x023AD11D
.long 0xBF8C0F75
.long 0x023AE11D
.long 0xBF8C0F74
.long 0x023AF11D
.long 0xBF8C0F73
.long 0x023B011D
.long 0xBF8C0F72
.long 0x023B111D
.long 0xBF8C0F71
.long 0x023B211D
.long 0xBF8C0F70
.long 0x023B311D
.long 0xBF820030
.long 0xBF8C0F75
.long 0x023AD11D
.long 0xBF8C0F74
.long 0x023AE11D
.long 0xBF8C0F73
.long 0x023AF11D
.long 0xBF8C0F72
.long 0x023B011D
.long 0xBF8C0F71
.long 0x023B111D
.long 0xBF8C0F70
.long 0x023B211D
.long 0xBF820023
.long 0xBF8C0F74
.long 0x023AD11D
.long 0xBF8C0F73
.long 0x023AE11D
.long 0xBF8C0F72
.long 0x023AF11D
.long 0xBF8C0F71
.long 0x023B011D
.long 0xBF8C0F70
.long 0x023B111D
.long 0xBF820018
.long 0xBF8C0F73
.long 0x023AD11D
.long 0xBF8C0F72
.long 0x023AE11D
.long 0xBF8C0F71
.long 0x023AF11D
.long 0xBF8C0F70
.long 0x023B011D
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x023AD11D
.long 0xBF8C0F71
.long 0x023AE11D
.long 0xBF8C0F70
.long 0x023AF11D
.long 0xBF820008
.long 0xBF8C0F71
.long 0x023AD11D
.long 0xBF8C0F70
.long 0x023AE11D
.long 0xBF820003
.long 0xBF8C0F70
.long 0x023AD11D
.long 0xBF820000
.long 0x7E4C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x8012211E
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x8012681E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x8012701E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x8012781E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x8012801E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x8012881E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x8012901E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x8012981E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A01E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A81E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B01E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B81E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C01E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C81E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D01E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D81E
.long 0xBF8C0F7E
.long 0x0242D121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x80126827
.long 0xBF8C0F7E
.long 0x0242E121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x80127027
.long 0xBF8C0F7E
.long 0x0242F121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x80127827
.long 0xBF8C0F7E
.long 0x02430121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x80128027
.long 0xBF8C0F7E
.long 0x02431121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x80128827
.long 0xBF8C0F7E
.long 0x02432121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x80129027
.long 0xBF8C0F7E
.long 0x02433121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x80129827
.long 0xBF8C0F7E
.long 0x02434121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x8012A027
.long 0xBF8C0F7E
.long 0x02435121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x8012A827
.long 0xBF8C0F7E
.long 0x02436121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x8012B027
.long 0xBF8C0F7E
.long 0x02437121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x8012B827
.long 0xBF8C0F7E
.long 0x02438121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x8012C027
.long 0xBF8C0F7E
.long 0x02439121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x8012C827
.long 0xBF8C0F7E
.long 0x0243A121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x8012D027
.long 0xBF8C0F7E
.long 0x0243B121
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D1E
.long 0xE050D000, 0x8012D827
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x0242D121
.long 0xBF8C0F7C
.long 0x0242E121
.long 0xBF8C0F7B
.long 0x0242F121
.long 0xBF8C0F7A
.long 0x02430121
.long 0xBF8C0F79
.long 0x02431121
.long 0xBF8C0F78
.long 0x02432121
.long 0xBF8C0F77
.long 0x02433121
.long 0xBF8C0F76
.long 0x02434121
.long 0xBF8C0F75
.long 0x02435121
.long 0xBF8C0F74
.long 0x02436121
.long 0xBF8C0F73
.long 0x02437121
.long 0xBF8C0F72
.long 0x02438121
.long 0xBF8C0F71
.long 0x02439121
.long 0xBF8C0F70
.long 0x0243A121
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x0242D121
.long 0xBF8C0F7B
.long 0x0242E121
.long 0xBF8C0F7A
.long 0x0242F121
.long 0xBF8C0F79
.long 0x02430121
.long 0xBF8C0F78
.long 0x02431121
.long 0xBF8C0F77
.long 0x02432121
.long 0xBF8C0F76
.long 0x02433121
.long 0xBF8C0F75
.long 0x02434121
.long 0xBF8C0F74
.long 0x02435121
.long 0xBF8C0F73
.long 0x02436121
.long 0xBF8C0F72
.long 0x02437121
.long 0xBF8C0F71
.long 0x02438121
.long 0xBF8C0F70
.long 0x02439121
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x0242D121
.long 0xBF8C0F7A
.long 0x0242E121
.long 0xBF8C0F79
.long 0x0242F121
.long 0xBF8C0F78
.long 0x02430121
.long 0xBF8C0F77
.long 0x02431121
.long 0xBF8C0F76
.long 0x02432121
.long 0xBF8C0F75
.long 0x02433121
.long 0xBF8C0F74
.long 0x02434121
.long 0xBF8C0F73
.long 0x02435121
.long 0xBF8C0F72
.long 0x02436121
.long 0xBF8C0F71
.long 0x02437121
.long 0xBF8C0F70
.long 0x02438121
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x0242D121
.long 0xBF8C0F79
.long 0x0242E121
.long 0xBF8C0F78
.long 0x0242F121
.long 0xBF8C0F77
.long 0x02430121
.long 0xBF8C0F76
.long 0x02431121
.long 0xBF8C0F75
.long 0x02432121
.long 0xBF8C0F74
.long 0x02433121
.long 0xBF8C0F73
.long 0x02434121
.long 0xBF8C0F72
.long 0x02435121
.long 0xBF8C0F71
.long 0x02436121
.long 0xBF8C0F70
.long 0x02437121
.long 0xBF820078
.long 0xBF8C0F79
.long 0x0242D121
.long 0xBF8C0F78
.long 0x0242E121
.long 0xBF8C0F77
.long 0x0242F121
.long 0xBF8C0F76
.long 0x02430121
.long 0xBF8C0F75
.long 0x02431121
.long 0xBF8C0F74
.long 0x02432121
.long 0xBF8C0F73
.long 0x02433121
.long 0xBF8C0F72
.long 0x02434121
.long 0xBF8C0F71
.long 0x02435121
.long 0xBF8C0F70
.long 0x02436121
.long 0xBF820063
.long 0xBF8C0F78
.long 0x0242D121
.long 0xBF8C0F77
.long 0x0242E121
.long 0xBF8C0F76
.long 0x0242F121
.long 0xBF8C0F75
.long 0x02430121
.long 0xBF8C0F74
.long 0x02431121
.long 0xBF8C0F73
.long 0x02432121
.long 0xBF8C0F72
.long 0x02433121
.long 0xBF8C0F71
.long 0x02434121
.long 0xBF8C0F70
.long 0x02435121
.long 0xBF820050
.long 0xBF8C0F77
.long 0x0242D121
.long 0xBF8C0F76
.long 0x0242E121
.long 0xBF8C0F75
.long 0x0242F121
.long 0xBF8C0F74
.long 0x02430121
.long 0xBF8C0F73
.long 0x02431121
.long 0xBF8C0F72
.long 0x02432121
.long 0xBF8C0F71
.long 0x02433121
.long 0xBF8C0F70
.long 0x02434121
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x0242D121
.long 0xBF8C0F75
.long 0x0242E121
.long 0xBF8C0F74
.long 0x0242F121
.long 0xBF8C0F73
.long 0x02430121
.long 0xBF8C0F72
.long 0x02431121
.long 0xBF8C0F71
.long 0x02432121
.long 0xBF8C0F70
.long 0x02433121
.long 0xBF820030
.long 0xBF8C0F75
.long 0x0242D121
.long 0xBF8C0F74
.long 0x0242E121
.long 0xBF8C0F73
.long 0x0242F121
.long 0xBF8C0F72
.long 0x02430121
.long 0xBF8C0F71
.long 0x02431121
.long 0xBF8C0F70
.long 0x02432121
.long 0xBF820023
.long 0xBF8C0F74
.long 0x0242D121
.long 0xBF8C0F73
.long 0x0242E121
.long 0xBF8C0F72
.long 0x0242F121
.long 0xBF8C0F71
.long 0x02430121
.long 0xBF8C0F70
.long 0x02431121
.long 0xBF820018
.long 0xBF8C0F73
.long 0x0242D121
.long 0xBF8C0F72
.long 0x0242E121
.long 0xBF8C0F71
.long 0x0242F121
.long 0xBF8C0F70
.long 0x02430121
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x0242D121
.long 0xBF8C0F71
.long 0x0242E121
.long 0xBF8C0F70
.long 0x0242F121
.long 0xBF820008
.long 0xBF8C0F71
.long 0x0242D121
.long 0xBF8C0F70
.long 0x0242E121
.long 0xBF820003
.long 0xBF8C0F70
.long 0x0242D121
.long 0xBF820000
.long 0x7E4C02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE050D000, 0x80122522
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xE050D000, 0x80126822
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501FF
.long 0xE050D000, 0x80127022
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501F3
.long 0xE050D000, 0x80127822
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501E5
.long 0xE050D000, 0x80128022
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501D5
.long 0xE050D000, 0x80128822
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501C3
.long 0xE050D000, 0x80129022
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8501AF
.long 0xE050D000, 0x80129822
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850199
.long 0xE050D000, 0x8012A022
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850181
.long 0xE050D000, 0x8012A822
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850167
.long 0xE050D000, 0x8012B022
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85014B
.long 0xE050D000, 0x8012B822
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85012D
.long 0xE050D000, 0x8012C022
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85010D
.long 0xE050D000, 0x8012C822
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500EB
.long 0xE050D000, 0x8012D022
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8500C7
.long 0xE050D000, 0x8012D822
.long 0xBF8C0F7E
.long 0x024AD125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8501A0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x80126827
.long 0xBF8C0F7E
.long 0x024AE125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850193
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x80127027
.long 0xBF8C0F7E
.long 0x024AF125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850186
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x80127827
.long 0xBF8C0F7E
.long 0x024B0125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850179
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x80128027
.long 0xBF8C0F7E
.long 0x024B1125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85016C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x80128827
.long 0xBF8C0F7E
.long 0x024B2125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85015F
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x80129027
.long 0xBF8C0F7E
.long 0x024B3125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850152
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x80129827
.long 0xBF8C0F7E
.long 0x024B4125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850145
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x8012A027
.long 0xBF8C0F7E
.long 0x024B5125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850138
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x8012A827
.long 0xBF8C0F7E
.long 0x024B6125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85012B
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x8012B027
.long 0xBF8C0F7E
.long 0x024B7125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85011E
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x8012B827
.long 0xBF8C0F7E
.long 0x024B8125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850111
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x8012C027
.long 0xBF8C0F7E
.long 0x024B9125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850104
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x8012C827
.long 0xBF8C0F7E
.long 0x024BA125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500F7
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x8012D027
.long 0xBF8C0F7E
.long 0x024BB125
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8500EA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD1000027, 0x011A4D22
.long 0xE050D000, 0x8012D827
.long 0xBF02CE05
.long 0xBF85FF3B
.long 0xBF8C0F7D
.long 0x024AD125
.long 0xBF8C0F7C
.long 0x024AE125
.long 0xBF8C0F7B
.long 0x024AF125
.long 0xBF8C0F7A
.long 0x024B0125
.long 0xBF8C0F79
.long 0x024B1125
.long 0xBF8C0F78
.long 0x024B2125
.long 0xBF8C0F77
.long 0x024B3125
.long 0xBF8C0F76
.long 0x024B4125
.long 0xBF8C0F75
.long 0x024B5125
.long 0xBF8C0F74
.long 0x024B6125
.long 0xBF8C0F73
.long 0x024B7125
.long 0xBF8C0F72
.long 0x024B8125
.long 0xBF8C0F71
.long 0x024B9125
.long 0xBF8C0F70
.long 0x024BA125
.long 0xBF8200C3
.long 0xBF8C0F7C
.long 0x024AD125
.long 0xBF8C0F7B
.long 0x024AE125
.long 0xBF8C0F7A
.long 0x024AF125
.long 0xBF8C0F79
.long 0x024B0125
.long 0xBF8C0F78
.long 0x024B1125
.long 0xBF8C0F77
.long 0x024B2125
.long 0xBF8C0F76
.long 0x024B3125
.long 0xBF8C0F75
.long 0x024B4125
.long 0xBF8C0F74
.long 0x024B5125
.long 0xBF8C0F73
.long 0x024B6125
.long 0xBF8C0F72
.long 0x024B7125
.long 0xBF8C0F71
.long 0x024B8125
.long 0xBF8C0F70
.long 0x024B9125
.long 0xBF8200A8
.long 0xBF8C0F7B
.long 0x024AD125
.long 0xBF8C0F7A
.long 0x024AE125
.long 0xBF8C0F79
.long 0x024AF125
.long 0xBF8C0F78
.long 0x024B0125
.long 0xBF8C0F77
.long 0x024B1125
.long 0xBF8C0F76
.long 0x024B2125
.long 0xBF8C0F75
.long 0x024B3125
.long 0xBF8C0F74
.long 0x024B4125
.long 0xBF8C0F73
.long 0x024B5125
.long 0xBF8C0F72
.long 0x024B6125
.long 0xBF8C0F71
.long 0x024B7125
.long 0xBF8C0F70
.long 0x024B8125
.long 0xBF82008F
.long 0xBF8C0F7A
.long 0x024AD125
.long 0xBF8C0F79
.long 0x024AE125
.long 0xBF8C0F78
.long 0x024AF125
.long 0xBF8C0F77
.long 0x024B0125
.long 0xBF8C0F76
.long 0x024B1125
.long 0xBF8C0F75
.long 0x024B2125
.long 0xBF8C0F74
.long 0x024B3125
.long 0xBF8C0F73
.long 0x024B4125
.long 0xBF8C0F72
.long 0x024B5125
.long 0xBF8C0F71
.long 0x024B6125
.long 0xBF8C0F70
.long 0x024B7125
.long 0xBF820078
.long 0xBF8C0F79
.long 0x024AD125
.long 0xBF8C0F78
.long 0x024AE125
.long 0xBF8C0F77
.long 0x024AF125
.long 0xBF8C0F76
.long 0x024B0125
.long 0xBF8C0F75
.long 0x024B1125
.long 0xBF8C0F74
.long 0x024B2125
.long 0xBF8C0F73
.long 0x024B3125
.long 0xBF8C0F72
.long 0x024B4125
.long 0xBF8C0F71
.long 0x024B5125
.long 0xBF8C0F70
.long 0x024B6125
.long 0xBF820063
.long 0xBF8C0F78
.long 0x024AD125
.long 0xBF8C0F77
.long 0x024AE125
.long 0xBF8C0F76
.long 0x024AF125
.long 0xBF8C0F75
.long 0x024B0125
.long 0xBF8C0F74
.long 0x024B1125
.long 0xBF8C0F73
.long 0x024B2125
.long 0xBF8C0F72
.long 0x024B3125
.long 0xBF8C0F71
.long 0x024B4125
.long 0xBF8C0F70
.long 0x024B5125
.long 0xBF820050
.long 0xBF8C0F77
.long 0x024AD125
.long 0xBF8C0F76
.long 0x024AE125
.long 0xBF8C0F75
.long 0x024AF125
.long 0xBF8C0F74
.long 0x024B0125
.long 0xBF8C0F73
.long 0x024B1125
.long 0xBF8C0F72
.long 0x024B2125
.long 0xBF8C0F71
.long 0x024B3125
.long 0xBF8C0F70
.long 0x024B4125
.long 0xBF82003F
.long 0xBF8C0F76
.long 0x024AD125
.long 0xBF8C0F75
.long 0x024AE125
.long 0xBF8C0F74
.long 0x024AF125
.long 0xBF8C0F73
.long 0x024B0125
.long 0xBF8C0F72
.long 0x024B1125
.long 0xBF8C0F71
.long 0x024B2125
.long 0xBF8C0F70
.long 0x024B3125
.long 0xBF820030
.long 0xBF8C0F75
.long 0x024AD125
.long 0xBF8C0F74
.long 0x024AE125
.long 0xBF8C0F73
.long 0x024AF125
.long 0xBF8C0F72
.long 0x024B0125
.long 0xBF8C0F71
.long 0x024B1125
.long 0xBF8C0F70
.long 0x024B2125
.long 0xBF820023
.long 0xBF8C0F74
.long 0x024AD125
.long 0xBF8C0F73
.long 0x024AE125
.long 0xBF8C0F72
.long 0x024AF125
.long 0xBF8C0F71
.long 0x024B0125
.long 0xBF8C0F70
.long 0x024B1125
.long 0xBF820018
.long 0xBF8C0F73
.long 0x024AD125
.long 0xBF8C0F72
.long 0x024AE125
.long 0xBF8C0F71
.long 0x024AF125
.long 0xBF8C0F70
.long 0x024B0125
.long 0xBF82000F
.long 0xBF8C0F72
.long 0x024AD125
.long 0xBF8C0F71
.long 0x024AE125
.long 0xBF8C0F70
.long 0x024AF125
.long 0xBF820008
.long 0xBF8C0F71
.long 0x024AD125
.long 0xBF8C0F70
.long 0x024AE125
.long 0xBF820003
.long 0xBF8C0F70
.long 0x024AD125
.long 0xBF820000
.long 0x0A121230
.long 0x0A1A1A30
.long 0x0A222230
.long 0x0A2A2A30
.long 0x0A323230
.long 0x0A3A3A30
.long 0x0A424230
.long 0x0A4A4A30
.long 0xBF8C0F70
.long 0xD3A00009, 0x14261031
.long 0x7E121509
.long 0xE068D000, 0x800E0907
.long 0xBF800000
.long 0xD3A0100D, 0x14361831
.long 0x7E1A150D
.long 0xE068D000, 0x800E0D0B
.long 0xBF800000
.long 0xD3A00011, 0x14462031
.long 0x7E221511
.long 0xE068D000, 0x800E110F
.long 0xBF800000
.long 0xD3A01015, 0x14562831
.long 0x7E2A1515
.long 0xE068D000, 0x800E1513
.long 0xBF800000
.long 0xD3A00019, 0x14663031
.long 0x7E321519
.long 0xE068D000, 0x800E1917
.long 0xBF800000
.long 0xD3A0101D, 0x14763831
.long 0x7E3A151D
.long 0xE068D000, 0x800E1D1B
.long 0xBF800000
.long 0xD3A00021, 0x14864031
.long 0x7E421521
.long 0xE068D000, 0x800E211F
.long 0xBF800000
.long 0xD3A01025, 0x14964831
.long 0x7E4A1525
.long 0xE068D000, 0x800E2523
.long 0xBF800000
.long 0xBF800000
.long 0xBF820000
.long 0xBEBC1C00
.long 0x813E84FF, 0x00000800
.long 0x803C3E3C
.long 0x823D803D
.long 0xBE801D3C
.long 0xB4310000
.long 0xBF8400D2
.long 0x863C1CFF, 0x0000007F
.long 0x803D14C1
.long 0xBF093D02
.long 0x853C803C
.long 0xB53C0000
.long 0xBF850037
.long 0x863C1D8F
.long 0x803D15C1
.long 0xBF093D03
.long 0x853C803C
.long 0xB53C0000
.long 0xBF850031
.long 0xD1FE0006, 0x02060103
.long 0xD3D84008, 0x18000100
.long 0xD3D84009, 0x18000104
.long 0xD3D8400A, 0x18000101
.long 0xD3D8400B, 0x18000105
.long 0xD3D8400C, 0x18000102
.long 0xD3D8400D, 0x18000106
.long 0xD3D8400E, 0x18000103
.long 0xD3D8400F, 0x18000107
.long 0xBF800001
.long 0xBF800000
.long 0x0A101030
.long 0x0A121230
.long 0x0A141430
.long 0x0A161630
.long 0x0A181830
.long 0x0A1A1A30
.long 0x0A1C1C30
.long 0x0A1E1E30
.long 0x7E101508
.long 0x7E121509
.long 0xD2A00008, 0x00021308
.long 0x7E14150A
.long 0x7E16150B
.long 0xD2A00009, 0x0002170A
.long 0x7E18150C
.long 0x7E1A150D
.long 0xD2A0000A, 0x00021B0C
.long 0x7E1C150E
.long 0x7E1E150F
.long 0xD2A0000B, 0x00021F0E
.long 0xE07CD000, 0x80030806
.long 0xBF800000
.long 0xBF800000
.long 0xBF8201BC
.long 0x7E2C02FF, 0x80000000
.long 0xD0C9003C, 0x00003900
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0006, 0x02060103
.long 0xD1000006, 0x01020D16
.long 0xD1196A04, 0x00010300
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0008, 0x02060903
.long 0xD1000008, 0x01021116
.long 0xD1196A04, 0x00010500
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000A, 0x02060903
.long 0xD100000A, 0x01021516
.long 0xD1196A04, 0x00010700
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000C, 0x02060903
.long 0xD100000C, 0x01021916
.long 0xD1196A04, 0x00010900
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000E, 0x02060903
.long 0xD100000E, 0x01021D16
.long 0xD1196A04, 0x00010B00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0010, 0x02060903
.long 0xD1000010, 0x01022116
.long 0xD1196A04, 0x00010D00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0012, 0x02060903
.long 0xD1000012, 0x01022516
.long 0xD1196A04, 0x00010F00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0014, 0x02060903
.long 0xD1000014, 0x01022916
.long 0xD3D84007, 0x18000100
.long 0xD3D84009, 0x18000104
.long 0xD3D8400B, 0x18000101
.long 0xD3D8400D, 0x18000105
.long 0xD3D8400F, 0x18000102
.long 0xD3D84011, 0x18000106
.long 0xD3D84013, 0x18000103
.long 0xD3D84015, 0x18000107
.long 0xBF800001
.long 0xBF800000
.long 0x0A0E0E30
.long 0x0A121230
.long 0x0A161630
.long 0x0A1A1A30
.long 0x0A1E1E30
.long 0x0A222230
.long 0x0A262630
.long 0x0A2A2A30
.long 0x7E0E1507
.long 0xE068D000, 0x80030706
.long 0xBF800000
.long 0x7E121509
.long 0xE068D000, 0x80030908
.long 0xBF800000
.long 0x7E16150B
.long 0xE068D000, 0x80030B0A
.long 0xBF800000
.long 0x7E1A150D
.long 0xE068D000, 0x80030D0C
.long 0xBF800000
.long 0x7E1E150F
.long 0xE068D000, 0x80030F0E
.long 0xBF800000
.long 0x7E221511
.long 0xE068D000, 0x80031110
.long 0xBF800000
.long 0x7E261513
.long 0xE068D000, 0x80031312
.long 0xBF800000
.long 0x7E2A1515
.long 0xE068D000, 0x80031514
.long 0xBF800000
.long 0xBF800000
.long 0xBF820128
.long 0x863C1CFF, 0x0000007F
.long 0x803D14C1
.long 0xBF093D02
.long 0x853C803C
.long 0xB53C0000
.long 0xBF85004C
.long 0x863C1D8F
.long 0x803D15C1
.long 0xBF093D03
.long 0x853C803C
.long 0xB53C0000
.long 0xBF850046
.long 0xD1FE0007, 0x02060102
.long 0xE05C1000, 0x80040807
.long 0xD1FE0006, 0x02060103
.long 0xD3D84010, 0x18000100
.long 0xD3D84011, 0x18000104
.long 0xD3D84012, 0x18000101
.long 0xD3D84013, 0x18000105
.long 0xD3D84014, 0x18000102
.long 0xD3D84015, 0x18000106
.long 0xD3D84016, 0x18000103
.long 0xD3D84017, 0x18000107
.long 0xBF800001
.long 0xBF800000
.long 0x0A202030
.long 0x0A222230
.long 0x0A242430
.long 0x0A262630
.long 0x0A282830
.long 0x0A2A2A30
.long 0x0A2C2C30
.long 0x0A2E2E30
.long 0xBF8C0F70
.long 0xD3A00010, 0x14421031
.long 0xD3A01011, 0x14461031
.long 0xD3A00012, 0x144A1231
.long 0xD3A01013, 0x144E1231
.long 0xD3A00014, 0x14521431
.long 0xD3A01015, 0x14561431
.long 0xD3A00016, 0x145A1631
.long 0xD3A01017, 0x145E1631
.long 0x7E201510
.long 0x7E221511
.long 0xD2A00010, 0x00022310
.long 0x7E241512
.long 0x7E261513
.long 0xD2A00011, 0x00022712
.long 0x7E281514
.long 0x7E2A1515
.long 0xD2A00012, 0x00022B14
.long 0x7E2C1516
.long 0x7E2E1517
.long 0xD2A00013, 0x00022F16
.long 0xE07CD000, 0x80031006
.long 0xBF800000
.long 0xBF800000
.long 0xBF8200D5
.long 0x7E3C02FF, 0x80000000
.long 0xD0C9003C, 0x00003900
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0006, 0x02060102
.long 0xD1000006, 0x01020D1E
.long 0xE0901000, 0x80040706
.long 0xD1FE0006, 0x02060103
.long 0xD1000006, 0x01020D1E
.long 0xD1196A04, 0x00010300
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0009, 0x02060902
.long 0xD1000009, 0x0102131E
.long 0xE0941000, 0x80040A09
.long 0xD1FE0009, 0x02060903
.long 0xD1000009, 0x0102131E
.long 0xD1196A04, 0x00010500
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000C, 0x02060902
.long 0xD100000C, 0x0102191E
.long 0xE0901000, 0x80040D0C
.long 0xD1FE000C, 0x02060903
.long 0xD100000C, 0x0102191E
.long 0xD1196A04, 0x00010700
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000F, 0x02060902
.long 0xD100000F, 0x01021F1E
.long 0xE0941000, 0x8004100F
.long 0xD1FE000F, 0x02060903
.long 0xD100000F, 0x01021F1E
.long 0xD1196A04, 0x00010900
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0012, 0x02060902
.long 0xD1000012, 0x0102251E
.long 0xE0901000, 0x80041312
.long 0xD1FE0012, 0x02060903
.long 0xD1000012, 0x0102251E
.long 0xD1196A04, 0x00010B00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0015, 0x02060902
.long 0xD1000015, 0x01022B1E
.long 0xE0941000, 0x80041615
.long 0xD1FE0015, 0x02060903
.long 0xD1000015, 0x01022B1E
.long 0xD1196A04, 0x00010D00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE0018, 0x02060902
.long 0xD1000018, 0x0102311E
.long 0xE0901000, 0x80041918
.long 0xD1FE0018, 0x02060903
.long 0xD1000018, 0x0102311E
.long 0xD1196A04, 0x00010F00
.long 0xD0C9003C, 0x00003904
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE001B, 0x02060902
.long 0xD100001B, 0x0102371E
.long 0xE0941000, 0x80041C1B
.long 0xD1FE001B, 0x02060903
.long 0xD100001B, 0x0102371E
.long 0xD3D84008, 0x18000100
.long 0xD3D8400B, 0x18000104
.long 0xD3D8400E, 0x18000101
.long 0xD3D84011, 0x18000105
.long 0xD3D84014, 0x18000102
.long 0xD3D84017, 0x18000106
.long 0xD3D8401A, 0x18000103
.long 0xD3D8401D, 0x18000107
.long 0xBF800001
.long 0xBF800000
.long 0x0A101030
.long 0x0A161630
.long 0x0A1C1C30
.long 0x0A222230
.long 0x0A282830
.long 0x0A2E2E30
.long 0x0A343430
.long 0x0A3A3A30
.long 0xBF8C0F70
.long 0xD3A00008, 0x14220E31
.long 0x7E101508
.long 0xE068D000, 0x80030806
.long 0xBF800000
.long 0xD3A0100B, 0x142E1431
.long 0x7E16150B
.long 0xE068D000, 0x80030B09
.long 0xBF800000
.long 0xD3A0000E, 0x143A1A31
.long 0x7E1C150E
.long 0xE068D000, 0x80030E0C
.long 0xBF800000
.long 0xD3A01011, 0x14462031
.long 0x7E221511
.long 0xE068D000, 0x8003110F
.long 0xBF800000
.long 0xD3A00014, 0x14522631
.long 0x7E281514
.long 0xE068D000, 0x80031412
.long 0xBF800000
.long 0xD3A01017, 0x145E2C31
.long 0x7E2E1517
.long 0xE068D000, 0x80031715
.long 0xBF800000
.long 0xD3A0001A, 0x146A3231
.long 0x7E34151A
.long 0xE068D000, 0x80031A18
.long 0xBF800000
.long 0xD3A0101D, 0x14763831
.long 0x7E3A151D
.long 0xE068D000, 0x80031D1B
.long 0xBF800000
.long 0xBF800000
.long 0xBF820000
.long 0xBF810000
