/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import org.jhotdraw.contrib.PolygonFigure;
import org.jhotdraw.contrib.TriangleRotationHandle;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class TriangleFigure
extends RectangleFigure {
    static double[] rotations = new double[]{-1.5707963267948966, -0.7853981633974483, 0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, -2.356194490192345};
    private int fRotation = 0;

    public TriangleFigure() {
        super(new Point(0, 0), new Point(0, 0));
    }

    public TriangleFigure(Point point, Point point2) {
        super(point, point2);
    }

    public HandleEnumeration handles() {
        List list = super.handles().toList();
        list.add(new TriangleRotationHandle(this));
        return new HandleEnumerator(list);
    }

    public void rotate(double d) {
        this.willChange();
        double d2 = Double.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < rotations.length; ++i) {
            double d3 = Math.abs(d - rotations[i]);
            if (!(d3 < d2)) continue;
            d2 = d3;
            n = i;
        }
        this.fRotation = n;
        this.changed();
    }

    public Polygon getPolygon() {
        Rectangle rectangle = this.displayBox();
        Polygon polygon = new Polygon();
        switch (this.fRotation) {
            case 0: {
                polygon.addPoint(rectangle.x + rectangle.width / 2, rectangle.y);
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
                break;
            }
            case 1: {
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                polygon.addPoint(rectangle.x, rectangle.y);
                break;
            }
            case 2: {
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
                polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
                polygon.addPoint(rectangle.x, rectangle.y);
                break;
            }
            case 3: {
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
                break;
            }
            case 4: {
                polygon.addPoint(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
                polygon.addPoint(rectangle.x, rectangle.y);
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
                break;
            }
            case 5: {
                polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
                polygon.addPoint(rectangle.x, rectangle.y);
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                break;
            }
            case 6: {
                polygon.addPoint(rectangle.x, rectangle.y + rectangle.height / 2);
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                break;
            }
            case 7: {
                polygon.addPoint(rectangle.x, rectangle.y);
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
                polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
            }
        }
        return polygon;
    }

    public void draw(Graphics graphics) {
        Polygon polygon = this.getPolygon();
        graphics.setColor(this.getFillColor());
        graphics.fillPolygon(polygon);
        graphics.setColor(this.getFrameColor());
        graphics.drawPolygon(polygon);
    }

    public Insets connectionInsets() {
        Rectangle rectangle = this.displayBox();
        switch (this.fRotation) {
            case 0: {
                return new Insets(rectangle.height, rectangle.width / 2, 0, rectangle.width / 2);
            }
            case 1: {
                return new Insets(0, rectangle.width, rectangle.height, 0);
            }
            case 2: {
                return new Insets(rectangle.height / 2, 0, rectangle.height / 2, rectangle.width);
            }
            case 3: {
                return new Insets(rectangle.height, rectangle.width, 0, 0);
            }
            case 4: {
                return new Insets(0, rectangle.width / 2, rectangle.height, rectangle.width / 2);
            }
            case 5: {
                return new Insets(rectangle.height, 0, 0, rectangle.width);
            }
            case 6: {
                return new Insets(rectangle.height / 2, rectangle.width, rectangle.height / 2, 0);
            }
            case 7: {
                return new Insets(0, 0, rectangle.height, rectangle.width);
            }
        }
        return null;
    }

    public boolean containsPoint(int n, int n2) {
        return this.getPolygon().contains(n, n2);
    }

    public Point center() {
        return PolygonFigure.center(this.getPolygon());
    }

    public Point chop(Point point) {
        return PolygonFigure.chop(this.getPolygon(), point);
    }

    public Object clone() {
        TriangleFigure triangleFigure = (TriangleFigure)super.clone();
        triangleFigure.fRotation = this.fRotation;
        return triangleFigure;
    }

    public double getRotationAngle() {
        return rotations[this.fRotation];
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fRotation);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fRotation = storableInput.readInt();
    }
}

