/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.figures.NumberTextFigure;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.samples.pert.PertDependency;
import org.jhotdraw.standard.CompositeFigure;
import org.jhotdraw.standard.ConnectionHandle;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Storable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class PertFigure
extends CompositeFigure {
    private static final int BORDER = 3;
    private Rectangle fDisplayBox;
    private List fPreTasks;
    private List fPostTasks;
    private static final long serialVersionUID = -7877776240236946511L;
    private int pertFigureSerializedDataVersion = 1;

    public PertFigure() {
        this.initialize();
    }

    public int start() {
        int n = 0;
        Iterator iterator = this.fPreTasks.iterator();
        while (iterator.hasNext()) {
            PertFigure pertFigure = (PertFigure)iterator.next();
            n = Math.max(n, pertFigure.end());
        }
        return n;
    }

    public int end() {
        return this.asInt(2);
    }

    public int duration() {
        return this.asInt(1);
    }

    public void setEnd(int n) {
        this.setInt(2, n);
    }

    public void addPreTask(PertFigure pertFigure) {
        if (!this.fPreTasks.contains(pertFigure)) {
            this.fPreTasks.add(pertFigure);
        }
    }

    public void addPostTask(PertFigure pertFigure) {
        if (!this.fPostTasks.contains(pertFigure)) {
            this.fPostTasks.add(pertFigure);
        }
    }

    public void removePreTask(PertFigure pertFigure) {
        this.fPreTasks.remove(pertFigure);
    }

    public void removePostTask(PertFigure pertFigure) {
        this.fPostTasks.remove(pertFigure);
    }

    private int asInt(int n) {
        NumberTextFigure numberTextFigure = (NumberTextFigure)this.figureAt(n);
        return numberTextFigure.getValue();
    }

    private String taskName() {
        TextFigure textFigure = (TextFigure)this.figureAt(0);
        return textFigure.getText();
    }

    private void setInt(int n, int n2) {
        NumberTextFigure numberTextFigure = (NumberTextFigure)this.figureAt(n);
        numberTextFigure.setValue(n2);
    }

    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
        super.basicMoveBy(n, n2);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
        this.layout();
    }

    private void drawBorder(Graphics graphics) {
        super.draw(graphics);
        Rectangle rectangle = this.displayBox();
        Figure figure = this.figureAt(0);
        Rectangle rectangle2 = figure.displayBox();
        graphics.setColor(Color.gray);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle2.height + 2, rectangle.x + rectangle.width, rectangle.y + rectangle2.height + 2);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle2.height + 3, rectangle.x + rectangle.width, rectangle.y + rectangle2.height + 3);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        graphics.setColor(Color.gray);
        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void draw(Graphics graphics) {
        this.drawBorder(graphics);
        super.draw(graphics);
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList();
        list.add(new NullHandle(this, RelativeLocator.northWest()));
        list.add(new NullHandle(this, RelativeLocator.northEast()));
        list.add(new NullHandle(this, RelativeLocator.southWest()));
        list.add(new NullHandle(this, RelativeLocator.southEast()));
        list.add(new ConnectionHandle(this, RelativeLocator.east(), new PertDependency()));
        return new HandleEnumerator(list);
    }

    private void initialize() {
        this.fPostTasks = CollectionsFactory.current().createList();
        this.fPreTasks = CollectionsFactory.current().createList();
        this.fDisplayBox = new Rectangle(0, 0, 0, 0);
        Font font = new Font("Helvetica", 0, 12);
        Font font2 = new Font("Helvetica", 1, 12);
        TextFigure textFigure = new TextFigure();
        textFigure.setFont(font2);
        textFigure.setText("Task");
        this.add(textFigure);
        NumberTextFigure numberTextFigure = new NumberTextFigure();
        numberTextFigure.setValue(0);
        numberTextFigure.setFont(font2);
        this.add(numberTextFigure);
        NumberTextFigure numberTextFigure2 = new NumberTextFigure();
        numberTextFigure2.setValue(0);
        numberTextFigure2.setFont(font);
        numberTextFigure2.setReadOnly(true);
        this.add(numberTextFigure2);
    }

    private void layout() {
        Point point = new Point(this.fDisplayBox.x, this.fDisplayBox.y);
        point.translate(3, 3);
        Dimension dimension = new Dimension(0, 0);
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            Dimension dimension2 = figure.size();
            Point point2 = new Point(point.x + dimension2.width, point.y + dimension2.height);
            figure.basicDisplayBox(point, point2);
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height;
            point.y += dimension2.height;
        }
        this.fDisplayBox.width = dimension.width + 6;
        this.fDisplayBox.height = dimension.height + 6;
    }

    private boolean needsLayout() {
        Dimension dimension = new Dimension(0, 0);
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            dimension.width = Math.max(dimension.width, figure.size().width);
        }
        int n = dimension.width + 6;
        return n != this.fDisplayBox.width;
    }

    public void update(FigureChangeEvent figureChangeEvent) {
        if (figureChangeEvent.getFigure() == this.figureAt(1)) {
            this.updateDurations();
        }
        if (this.needsLayout()) {
            this.layout();
            this.changed();
        }
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.update(figureChangeEvent);
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        this.update(figureChangeEvent);
    }

    public void notifyPostTasks() {
        Iterator iterator = this.fPostTasks.iterator();
        while (iterator.hasNext()) {
            ((PertFigure)iterator.next()).updateDurations();
        }
    }

    public void updateDurations() {
        int n = this.start() + this.duration();
        if (n != this.end()) {
            this.setEnd(n);
            this.notifyPostTasks();
        }
    }

    public boolean hasCycle(Figure figure) {
        if (figure == this) {
            return true;
        }
        Iterator iterator = this.fPreTasks.iterator();
        while (iterator.hasNext()) {
            if (!((PertFigure)iterator.next()).hasCycle(figure)) continue;
            return true;
        }
        return false;
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
        this.writeTasks(storableOutput, this.fPreTasks);
        this.writeTasks(storableOutput, this.fPostTasks);
    }

    public void writeTasks(StorableOutput storableOutput, List list) {
        storableOutput.writeInt(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            storableOutput.writeStorable((Storable)iterator.next());
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
        this.layout();
        this.fPreTasks = this.readTasks(storableInput);
        this.fPostTasks = this.readTasks(storableInput);
    }

    public Insets connectionInsets() {
        Rectangle rectangle = this.fDisplayBox;
        int n = rectangle.width / 2;
        int n2 = rectangle.height / 2;
        return new Insets(n2, n, n2, n);
    }

    public List readTasks(StorableInput storableInput) throws IOException {
        int n = storableInput.readInt();
        List list = CollectionsFactory.current().createList(n);
        for (int i = 0; i < n; ++i) {
            list.add(storableInput.readStorable());
        }
        return list;
    }
}

