/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.jeuclid.DOMBuilder;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.layout.GraphicsObject;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutInfoImpl;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.LayoutableDocument;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEuclidView
implements AbstractView,
LayoutView,
EventListener {
    private final LayoutableDocument document;
    private final Map<Node, LayoutInfo> layoutMap;
    private final LayoutContext context;
    private final Graphics2D graphics;

    public JEuclidView(Node node, LayoutContext layoutContext, Graphics2D graphics2D) {
        this.document = node instanceof LayoutableDocument ? (LayoutableDocument)node : DOMBuilder.getInstance().createJeuclidDom(node, true, true);
        this.graphics = graphics2D;
        this.context = layoutContext;
        this.layoutMap = new HashMap<Node, LayoutInfo>();
    }

    @Override
    public DocumentView getDocument() {
        return this.document;
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        this.layout();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        if (((Boolean)this.context.getParameter(Parameter.ANTIALIAS)).booleanValue()) {
            renderingHints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        renderingHints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE));
        renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graphics2D.setRenderingHints(renderingHints);
        boolean bl = (Boolean)this.context.getParameter(Parameter.DEBUG);
        this.drawNode(this.document, graphics2D, f, f2, bl);
    }

    private void drawNode(LayoutableNode layoutableNode, Graphics2D graphics2D, float f, float f2, boolean bl) {
        LayoutInfo layoutInfo = this.getInfo(layoutableNode);
        if (bl) {
            float f3 = f;
            float f4 = f + layoutInfo.getWidth(LayoutStage.STAGE2);
            float f5 = f2 - layoutInfo.getAscentHeight(LayoutStage.STAGE2);
            float f6 = f2 + layoutInfo.getDescentHeight(LayoutStage.STAGE2);
            graphics2D.setColor(Color.BLUE);
            graphics2D.draw(new Line2D.Float(f3, f5, f4, f5));
            graphics2D.draw(new Line2D.Float(f3, f5, f3, f6));
            graphics2D.draw(new Line2D.Float(f4, f5, f4, f6));
            graphics2D.draw(new Line2D.Float(f3, f6, f4, f6));
            graphics2D.setColor(Color.RED);
            graphics2D.draw(new Line2D.Float(f3, f2, f4, f2));
        }
        for (GraphicsObject graphicsObject : layoutInfo.getGraphicObjects()) {
            graphicsObject.paint(f, f2, graphics2D);
        }
        for (LayoutableNode layoutableNode2 : layoutableNode.getChildrenToDraw()) {
            LayoutInfo layoutInfo2 = this.getInfo(layoutableNode2);
            this.drawNode(layoutableNode2, graphics2D, f + layoutInfo2.getPosX(LayoutStage.STAGE2), f2 + layoutInfo2.getPosY(LayoutStage.STAGE2), bl);
        }
    }

    private LayoutInfo layout() {
        return this.layout(this.document, LayoutStage.STAGE2, this.context);
    }

    private LayoutInfo layout(LayoutableNode layoutableNode, LayoutStage layoutStage, LayoutContext layoutContext) {
        Object object;
        LayoutInfo layoutInfo = this.getInfo(layoutableNode);
        if (layoutableNode instanceof EventTarget) {
            object = (EventTarget)((Object)layoutableNode);
            object.addEventListener("DOMSubtreeModified", this, false);
            object.addEventListener("MOEvent", this, false);
        }
        if (LayoutStage.NONE.equals((Object)layoutInfo.getLayoutStage())) {
            object = LayoutStage.STAGE2;
            int n = 0;
            for (LayoutableNode layoutableNode2 : layoutableNode.getChildrenToLayout()) {
                LayoutInfo layoutInfo2 = this.layout(layoutableNode2, LayoutStage.STAGE1, layoutableNode.getChildLayoutContext(n, layoutContext));
                ++n;
                if (!LayoutStage.STAGE1.equals((Object)layoutInfo2.getLayoutStage())) continue;
                object = LayoutStage.STAGE1;
            }
            layoutableNode.layoutStage1(this, layoutInfo, (LayoutStage)((Object)object), layoutContext);
        }
        if (LayoutStage.STAGE1.equals((Object)layoutInfo.getLayoutStage()) && LayoutStage.STAGE2.equals((Object)layoutStage)) {
            int n = 0;
            for (LayoutableNode layoutableNode3 : layoutableNode.getChildrenToLayout()) {
                this.layout(layoutableNode3, LayoutStage.STAGE2, layoutableNode.getChildLayoutContext(n, layoutContext));
                ++n;
            }
            layoutableNode.layoutStage2(this, layoutInfo, layoutContext);
        }
        return layoutInfo;
    }

    @Override
    public LayoutInfo getInfo(LayoutableNode layoutableNode) {
        if (layoutableNode == null) {
            return null;
        }
        LayoutInfo layoutInfo = this.layoutMap.get(layoutableNode);
        if (layoutInfo == null) {
            layoutInfo = new LayoutInfoImpl();
            this.layoutMap.put(layoutableNode, layoutInfo);
        }
        return layoutInfo;
    }

    public float getWidth() {
        LayoutInfo layoutInfo = this.layout();
        return layoutInfo.getWidth(LayoutStage.STAGE2);
    }

    public float getAscentHeight() {
        LayoutInfo layoutInfo = this.layout();
        return layoutInfo.getAscentHeight(LayoutStage.STAGE2);
    }

    public float getDescentHeight() {
        LayoutInfo layoutInfo = this.layout();
        return layoutInfo.getDescentHeight(LayoutStage.STAGE2);
    }

    @Override
    public Graphics2D getGraphics() {
        return this.graphics;
    }

    @Override
    public void handleEvent(Event event) {
        EventTarget eventTarget = event.getCurrentTarget();
        if (eventTarget instanceof LayoutableNode) {
            LayoutableNode layoutableNode = (LayoutableNode)((Object)eventTarget);
            LayoutInfo layoutInfo = this.getInfo(layoutableNode);
            layoutInfo.setLayoutStage(LayoutStage.NONE);
        }
    }

    public List<NodeRect> getNodesAt(float f, float f2, float f3, float f4) {
        this.layout();
        LinkedList<NodeRect> linkedList = new LinkedList<NodeRect>();
        this.getNodesAtRec(f, f2, f3, f4, this.document, linkedList);
        return linkedList;
    }

    private void getNodesAtRec(float f, float f2, float f3, float f4, Node node, List<NodeRect> list) {
        float f5;
        LayoutStage layoutStage;
        LayoutInfo layoutInfo;
        float f6;
        Rectangle2D.Float float_;
        if (node instanceof LayoutableNode && (float_ = new Rectangle2D.Float(f6 = (layoutInfo = this.layoutMap.get(node)).getPosX(layoutStage = layoutInfo.getLayoutStage()) + f3, f5 = layoutInfo.getPosY(layoutStage) + f4 - layoutInfo.getAscentHeight(layoutStage), layoutInfo.getWidth(layoutStage), layoutInfo.getAscentHeight(layoutStage) + layoutInfo.getDescentHeight(layoutStage))).contains(f, f2)) {
            list.add(new NodeRect(node, float_));
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.getNodesAtRec(f, f2, f6, f5 + layoutInfo.getAscentHeight(layoutStage), nodeList.item(i), list);
            }
        }
    }

    public Rectangle2D getRect(float f, float f2, LayoutableNode layoutableNode) {
        Rectangle2D.Float float_;
        this.layout();
        LayoutInfo layoutInfo = this.layoutMap.get(layoutableNode);
        if (layoutInfo == null) {
            float_ = null;
        } else {
            LayoutableNode layoutableNode2 = layoutableNode;
            float f3 = layoutInfo.getPosX(LayoutStage.STAGE2) + f;
            float f4 = layoutInfo.getPosY(LayoutStage.STAGE2) + f2 - layoutInfo.getAscentHeight(LayoutStage.STAGE2);
            while (layoutableNode2.getParentNode() instanceof LayoutableNode) {
                layoutableNode2 = (LayoutableNode)layoutableNode2.getParentNode();
                LayoutInfo layoutInfo2 = this.layoutMap.get(layoutableNode2);
                f3 += layoutInfo2.getPosX(LayoutStage.STAGE2);
                f4 += layoutInfo2.getPosY(LayoutStage.STAGE2);
            }
            float_ = new Rectangle2D.Float(f3, f4, layoutInfo.getWidth(LayoutStage.STAGE2), layoutInfo.getAscentHeight(LayoutStage.STAGE2) + layoutInfo.getDescentHeight(LayoutStage.STAGE2));
        }
        return float_;
    }

    public static final class NodeRect {
        private final Node node;
        private final Rectangle2D rect;

        private NodeRect(Node node, Rectangle2D rectangle2D) {
            this.node = node;
            this.rect = rectangle2D;
        }

        public Node getNode() {
            return this.node;
        }

        public Rectangle2D getRect() {
            return this.rect;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.node).append('/').append(this.rect);
            return stringBuilder.toString();
        }
    }
}

