/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg4.es;

import java.nio.ByteBuffer;
import org.jcodec.codecs.mpeg4.es.DescriptorFactory;
import org.jcodec.codecs.mpeg4.es.NodeDescriptor;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.NIOUtils;

public abstract class Descriptor {
    private int tag;
    private int size;
    private static DescriptorFactory factory = new DescriptorFactory();

    public Descriptor(int tag) {
        this(tag, 0);
    }

    public Descriptor(int tag, int size) {
        this.tag = tag;
        this.size = size;
    }

    public void write(ByteBuffer out) {
        ByteBuffer fork = out.duplicate();
        NIOUtils.skip(out, 5);
        this.doWrite(out);
        int length = out.position() - fork.position() - 5;
        fork.put((byte)this.tag);
        JCodecUtil.writeBER32(fork, length);
    }

    protected abstract void doWrite(ByteBuffer var1);

    public static Descriptor read(ByteBuffer input) {
        Descriptor descriptor;
        if (input.remaining() < 2) {
            return null;
        }
        int tag = input.get() & 0xFF;
        int size = JCodecUtil.readBER32(input);
        Class<? extends Descriptor> cls = factory.byTag(tag);
        try {
            descriptor = cls.getConstructor(Integer.TYPE, Integer.TYPE).newInstance(tag, size);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        descriptor.parse(NIOUtils.read(input, size));
        return descriptor;
    }

    protected abstract void parse(ByteBuffer var1);

    public static <T> T find(Descriptor es, Class<T> class1, int tag) {
        if (es.getTag() == tag) {
            return (T)es;
        }
        if (es instanceof NodeDescriptor) {
            for (Descriptor descriptor : ((NodeDescriptor)es).getChildren()) {
                T res = Descriptor.find(descriptor, class1, tag);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private int getTag() {
        return this.tag;
    }
}

