/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.containers.mp4.boxes.FullBox;
import org.jcodec.containers.mp4.boxes.Header;

public class SyncSamplesBox
extends FullBox {
    private int[] syncSamples;

    public static String fourcc() {
        return "stss";
    }

    public SyncSamplesBox() {
        super(new Header(SyncSamplesBox.fourcc()));
    }

    public SyncSamplesBox(int[] array) {
        this();
        this.syncSamples = array;
    }

    public SyncSamplesBox(Header header) {
        super(header);
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        int len = input.getInt();
        this.syncSamples = new int[len];
        for (int i = 0; i < len; ++i) {
            this.syncSamples[i] = input.getInt();
        }
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.syncSamples.length);
        for (int i = 0; i < this.syncSamples.length; ++i) {
            out.putInt(this.syncSamples[i]);
        }
    }

    public int[] getSyncSamples() {
        return this.syncSamples;
    }
}

