/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.movtool.streaming.MovieSegment;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;

public abstract class VirtualMovie {
    public MovieSegment[] chunks;
    public MovieSegment headerChunk;
    protected long size;
    protected VirtualTrack[] tracks;

    public VirtualMovie(VirtualTrack ... tracks) throws IOException {
        this.tracks = tracks;
    }

    protected void muxTracks() throws IOException {
        ArrayList<MovieSegment> chch = new ArrayList<MovieSegment>();
        VirtualPacket[] heads = new VirtualPacket[this.tracks.length];
        VirtualPacket[] tails = new VirtualPacket[this.tracks.length];
        int curChunk = 1;
        while (true) {
            int min = -1;
            for (int i = 0; i < heads.length; ++i) {
                if (heads[i] == null) {
                    heads[i] = this.tracks[i].nextPacket();
                    if (heads[i] == null) continue;
                }
                min = min == -1 || heads[i].getPts() < heads[min].getPts() ? i : min;
            }
            if (min == -1) break;
            chch.add(this.packetChunk(this.tracks[min], heads[min], curChunk, min, this.size));
            if (heads[min].getDataLen() >= 0) {
                this.size += (long)heads[min].getDataLen();
            } else {
                System.err.println("WARN: Negative frame data len!!!");
            }
            tails[min] = heads[min];
            heads[min] = this.tracks[min].nextPacket();
            ++curChunk;
        }
        this.headerChunk = this.headerChunk(chch, this.tracks, this.size);
        this.size += (long)this.headerChunk.getDataLen();
        this.chunks = chch.toArray(new MovieSegment[0]);
    }

    protected abstract MovieSegment packetChunk(VirtualTrack var1, VirtualPacket var2, int var3, int var4, long var5);

    protected abstract MovieSegment headerChunk(List<MovieSegment> var1, VirtualTrack[] var2, long var3) throws IOException;

    public void close() throws IOException {
        for (VirtualTrack virtualTrack : this.tracks) {
            virtualTrack.close();
        }
    }

    public MovieSegment getPacketAt(long position) throws IOException {
        if (position >= 0L && position < (long)this.headerChunk.getDataLen()) {
            return this.headerChunk;
        }
        for (int i = 0; i < this.chunks.length - 1; ++i) {
            if (this.chunks[i + 1].getPos() <= position) continue;
            return this.chunks[i];
        }
        if (position < this.size) {
            return this.chunks[this.chunks.length - 1];
        }
        return null;
    }

    public MovieSegment getPacketByNo(int no) {
        if (no > this.chunks.length) {
            return null;
        }
        if (no == 0) {
            return this.headerChunk;
        }
        return this.chunks[no - 1];
    }

    public long size() {
        return this.size;
    }
}

