/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Contended;
import sun.misc.Unsafe;

@Contended
public class ForkJoinPool
extends AbstractExecutorService {
    static final int SMASK = 65535;
    static final int MAX_CAP = Short.MAX_VALUE;
    static final int EVENMASK = 65534;
    static final int SQMASK = 126;
    static final int SCANNING = 1;
    static final int INACTIVE = Integer.MIN_VALUE;
    static final int SS_SEQ = 65536;
    static final int MODE_MASK = -65536;
    static final int LIFO_QUEUE = 0;
    static final int FIFO_QUEUE = 65536;
    static final int SHARED_QUEUE = Integer.MIN_VALUE;
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    static final int commonParallelism;
    private static int commonMaxSpares;
    private static int poolNumberSequence;
    private static final long IDLE_TIMEOUT = 2000000000L;
    private static final long TIMEOUT_SLOP = 20000000L;
    private static final int DEFAULT_COMMON_MAX_SPARES = 256;
    private static final int SPINS = 0;
    private static final int SEED_INCREMENT = -1640531527;
    private static final long SP_MASK = 0xFFFFFFFFL;
    private static final long UC_MASK = -4294967296L;
    private static final int AC_SHIFT = 48;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final int TC_SHIFT = 32;
    private static final long TC_UNIT = 0x100000000L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long ADD_WORKER = 0x800000000000L;
    private static final int RSLOCK = 1;
    private static final int RSIGNAL = 2;
    private static final int STARTED = 4;
    private static final int STOP = 0x20000000;
    private static final int TERMINATED = 0x40000000;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    volatile long ctl;
    volatile int runState;
    final int config;
    int indexSeed;
    volatile WorkQueue[] workQueues;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final String workerNamePrefix;
    volatile AtomicLong stealCounter;
    private static final Unsafe U;
    private static final int ABASE;
    private static final int ASHIFT;
    private static final long CTL;
    private static final long RUNSTATE;
    private static final long STEALCOUNTER;
    private static final long PARKBLOCKER;
    private static final long QTOP;
    private static final long QLOCK;
    private static final long QSCANSTATE;
    private static final long QPARKER;
    private static final long QCURRENTSTEAL;
    private static final long QCURRENTJOIN;

    private static void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(modifyThreadPermission);
        }
    }

    private static final synchronized int nextPoolId() {
        return ++poolNumberSequence;
    }

    private int lockRunState() {
        int n = this.runState;
        return (n & 1) != 0 || !U.compareAndSwapInt(this, RUNSTATE, n, n |= 1) ? this.awaitRunStateLock() : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int awaitRunStateLock() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (true) {
            block13: {
                AtomicLong atomicLong;
                int n3;
                if (((n3 = this.runState) & 1) == 0) {
                    int n4 = n3 | 1;
                    if (!U.compareAndSwapInt(this, RUNSTATE, n3, n4)) continue;
                    if (!bl) return n4;
                    try {
                        Thread.currentThread().interrupt();
                        return n4;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return n4;
                }
                if (n2 == 0) {
                    n2 = ThreadLocalRandom.nextSecondarySeed();
                    continue;
                }
                if (n > 0) {
                    n2 ^= n2 << 6;
                    n2 ^= n2 >>> 21;
                    if ((n2 ^= n2 << 7) < 0) continue;
                    --n;
                    continue;
                }
                if ((n3 & 4) == 0 || (atomicLong = this.stealCounter) == null) {
                    Thread.yield();
                    continue;
                }
                if (!U.compareAndSwapInt(this, RUNSTATE, n3, n3 | 2)) continue;
                AtomicLong atomicLong2 = atomicLong;
                synchronized (atomicLong2) {
                    if ((this.runState & 2) != 0) {
                        try {
                            atomicLong.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (!(Thread.currentThread() instanceof ForkJoinWorkerThread)) {
                                bl = true;
                            }
                            break block13;
                        }
                    }
                    atomicLong.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockRunState(int n, int n2) {
        if (!U.compareAndSwapInt(this, RUNSTATE, n, n2)) {
            AtomicLong atomicLong = this.stealCounter;
            this.runState = n2;
            if (atomicLong != null) {
                AtomicLong atomicLong2 = atomicLong;
                synchronized (atomicLong2) {
                    atomicLong.notifyAll();
                }
            }
        }
    }

    private boolean createWorker() {
        ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory = this.factory;
        Throwable throwable = null;
        ForkJoinWorkerThread forkJoinWorkerThread = null;
        try {
            if (forkJoinWorkerThreadFactory != null && (forkJoinWorkerThread = forkJoinWorkerThreadFactory.newThread(this)) != null) {
                forkJoinWorkerThread.start();
                return true;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        this.deregisterWorker(forkJoinWorkerThread, throwable);
        return false;
    }

    private void tryAddWorker(long l) {
        boolean bl = false;
        do {
            long l2 = 0xFFFF000000000000L & l + 0x1000000000000L | 0xFFFF00000000L & l + 0x100000000L;
            if (this.ctl != l) continue;
            int n = this.lockRunState();
            int n2 = n & 0x20000000;
            if (n2 == 0) {
                bl = U.compareAndSwapLong(this, CTL, l, l2);
            }
            this.unlockRunState(n, n & 0xFFFFFFFE);
            if (n2 != 0) break;
            if (!bl) continue;
            this.createWorker();
            break;
        } while (((l = this.ctl) & 0x800000000000L) != 0L && (int)l == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WorkQueue registerWorker(ForkJoinWorkerThread forkJoinWorkerThread) {
        forkJoinWorkerThread.setDaemon(true);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.ueh;
        if (uncaughtExceptionHandler != null) {
            forkJoinWorkerThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
        WorkQueue workQueue = new WorkQueue(this, forkJoinWorkerThread);
        int n = 0;
        int n2 = this.config & 0xFFFF0000;
        int n3 = this.lockRunState();
        try {
            int n4;
            WorkQueue[] workQueueArray = this.workQueues;
            if (this.workQueues != null && (n4 = workQueueArray.length) > 0) {
                int n5 = this.indexSeed += -1640531527;
                int n6 = n4 - 1;
                n = (n5 << 1 | 1) & n6;
                if (workQueueArray[n] != null) {
                    int n7;
                    int n8 = 0;
                    int n9 = n7 = n4 <= 4 ? 2 : (n4 >>> 1 & 0xFFFE) + 2;
                    while (workQueueArray[n = n + n7 & n6] != null) {
                        if (++n8 < n4) continue;
                        this.workQueues = workQueueArray = Arrays.copyOf(workQueueArray, n4 <<= 1);
                        n6 = n4 - 1;
                        n8 = 0;
                    }
                }
                workQueue.hint = n5;
                workQueue.config = n | n2;
                workQueue.scanState = n;
                workQueueArray[n] = workQueue;
            }
        }
        finally {
            this.unlockRunState(n3, n3 & 0xFFFFFFFE);
        }
        forkJoinWorkerThread.setName(this.workerNamePrefix.concat(Integer.toString(n >>> 1)));
        return workQueue;
    }

    final void deregisterWorker(ForkJoinWorkerThread forkJoinWorkerThread, Throwable throwable) {
        long l;
        WorkQueue workQueue = null;
        if (forkJoinWorkerThread != null && (workQueue = forkJoinWorkerThread.workQueue) != null) {
            int n = workQueue.config & 0xFFFF;
            int n2 = this.lockRunState();
            WorkQueue[] workQueueArray = this.workQueues;
            if (this.workQueues != null && workQueueArray.length > n && workQueueArray[n] == workQueue) {
                workQueueArray[n] = null;
            }
            this.unlockRunState(n2, n2 & 0xFFFFFFFE);
        }
        while (!U.compareAndSwapLong(this, CTL, l = this.ctl, 0xFFFF000000000000L & l - 0x1000000000000L | 0xFFFF00000000L & l - 0x100000000L | 0xFFFFFFFFL & l)) {
        }
        if (workQueue != null) {
            workQueue.qlock = -1;
            workQueue.transferStealCount(this);
            workQueue.cancelAll();
        }
        while (!this.tryTerminate(false, false) && workQueue != null && workQueue.array != null && (this.runState & 0x20000000) == 0) {
            int n;
            WorkQueue[] workQueueArray = this.workQueues;
            if (this.workQueues == null || (n = workQueueArray.length - 1) < 0) break;
            l = this.ctl;
            int n3 = (int)l;
            if (n3 != 0) {
                if (!this.tryRelease(l, workQueueArray[n3 & n], 0x1000000000000L)) continue;
                break;
            }
            if (throwable == null || (l & 0x800000000000L) == 0L) break;
            this.tryAddWorker(l);
            break;
        }
        if (throwable == null) {
            ForkJoinTask.helpExpungeStaleExceptions();
        } else {
            ForkJoinTask.rethrow(throwable);
        }
    }

    final void signalWork(WorkQueue[] workQueueArray, WorkQueue workQueue) {
        long l;
        while ((l = this.ctl) < 0L) {
            WorkQueue workQueue2;
            int n;
            int n2 = (int)l;
            if (n2 == 0) {
                if ((l & 0x800000000000L) == 0L) break;
                this.tryAddWorker(l);
                break;
            }
            if (workQueueArray == null || workQueueArray.length <= (n = n2 & 0xFFFF) || (workQueue2 = workQueueArray[n]) == null) break;
            int n3 = n2 + 65536 & Integer.MAX_VALUE;
            int n4 = n2 - workQueue2.scanState;
            long l2 = 0xFFFFFFFF00000000L & l + 0x1000000000000L | 0xFFFFFFFFL & (long)workQueue2.stackPred;
            if (n4 == 0 && U.compareAndSwapLong(this, CTL, l, l2)) {
                workQueue2.scanState = n3;
                Thread thread = workQueue2.parker;
                if (thread == null) break;
                U.unpark(thread);
                break;
            }
            if (workQueue == null || workQueue.base != workQueue.top) continue;
            break;
        }
    }

    private boolean tryRelease(long l, WorkQueue workQueue, long l2) {
        long l3;
        int n = (int)l;
        int n2 = n + 65536 & Integer.MAX_VALUE;
        if (workQueue != null && workQueue.scanState == n && U.compareAndSwapLong(this, CTL, l, l3 = 0xFFFFFFFF00000000L & l + l2 | 0xFFFFFFFFL & (long)workQueue.stackPred)) {
            workQueue.scanState = n2;
            Thread thread = workQueue.parker;
            if (thread != null) {
                U.unpark(thread);
            }
            return true;
        }
        return false;
    }

    final void runWorker(WorkQueue workQueue) {
        int n;
        workQueue.growArray();
        int n2 = workQueue.hint;
        int n3 = n = n2 == 0 ? 1 : n2;
        while (true) {
            ForkJoinTask<?> forkJoinTask;
            if ((forkJoinTask = this.scan(workQueue, n)) != null) {
                workQueue.runTask(forkJoinTask);
            } else if (!this.awaitWork(workQueue, n)) break;
            n ^= n << 13;
            n ^= n >>> 17;
            n ^= n << 5;
        }
    }

    private ForkJoinTask<?> scan(WorkQueue workQueue, int n) {
        int n2;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null && (n2 = workQueueArray.length - 1) > 0 && workQueue != null) {
            int n3;
            int n4 = workQueue.scanState;
            int n5 = n3 = n & n2;
            int n6 = 0;
            int n7 = 0;
            while (true) {
                long l;
                WorkQueue workQueue2;
                if ((workQueue2 = workQueueArray[n5]) != null) {
                    int n8 = workQueue2.base;
                    int n9 = n8 - workQueue2.top;
                    if (n9 < 0) {
                        ForkJoinTask<?>[] forkJoinTaskArray = workQueue2.array;
                        if (workQueue2.array != null) {
                            long l2 = ((forkJoinTaskArray.length - 1 & n8) << ASHIFT) + ABASE;
                            ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, l2);
                            if (forkJoinTask != null && workQueue2.base == n8) {
                                if (n4 >= 0) {
                                    if (U.compareAndSwapObject(forkJoinTaskArray, l2, forkJoinTask, null)) {
                                        workQueue2.base = n8 + 1;
                                        if (n9 < -1) {
                                            this.signalWork(workQueueArray, workQueue2);
                                        }
                                        return forkJoinTask;
                                    }
                                } else if (n6 == 0 && workQueue.scanState < 0) {
                                    l = this.ctl;
                                    this.tryRelease(l, workQueueArray[n2 & (int)l], 0x1000000000000L);
                                }
                            }
                            if (n4 < 0) {
                                n4 = workQueue.scanState;
                            }
                            n ^= n << 1;
                            n ^= n >>> 3;
                            n ^= n << 10;
                            n3 = n5 = n & n2;
                            n7 = 0;
                            n6 = 0;
                            continue;
                        }
                    }
                    n7 += n8;
                }
                if ((n5 = n5 + 1 & n2) != n3) continue;
                if ((n4 >= 0 || n4 == (n4 = workQueue.scanState)) && n6 == (n6 = n7)) {
                    if (n4 < 0 || workQueue.qlock < 0) break;
                    int n10 = n4 | Integer.MIN_VALUE;
                    l = this.ctl;
                    long l3 = 0xFFFFFFFFL & (long)n10 | 0xFFFFFFFF00000000L & l - 0x1000000000000L;
                    workQueue.stackPred = (int)l;
                    U.putInt((Object)workQueue, QSCANSTATE, n10);
                    if (U.compareAndSwapLong(this, CTL, l, l3)) {
                        n4 = n10;
                    } else {
                        workQueue.scanState = n4;
                    }
                }
                n7 = 0;
            }
        }
        return null;
    }

    private boolean awaitWork(WorkQueue workQueue, int n) {
        int n2;
        if (workQueue == null || workQueue.qlock < 0) {
            return false;
        }
        int n3 = workQueue.stackPred;
        int n4 = 0;
        while ((n2 = workQueue.scanState) < 0) {
            long l;
            long l2;
            long l3;
            if (n4 > 0) {
                WorkQueue workQueue2;
                int n5;
                n ^= n << 6;
                n ^= n >>> 21;
                if ((n ^= n << 7) < 0 || --n4 != 0 || n3 == 0) continue;
                WorkQueue[] workQueueArray = this.workQueues;
                if (this.workQueues == null || (n5 = n3 & 0xFFFF) >= workQueueArray.length || (workQueue2 = workQueueArray[n5]) == null || workQueue2.parker != null && workQueue2.scanState < 0) continue;
                n4 = 0;
                continue;
            }
            if (workQueue.qlock < 0) {
                return false;
            }
            if (Thread.interrupted()) continue;
            long l4 = this.ctl;
            int n6 = (int)(l4 >> 48) + (this.config & 0xFFFF);
            if (n6 <= 0 && this.tryTerminate(false, false) || (this.runState & 0x20000000) != 0) {
                return false;
            }
            if (n6 <= 0 && n2 == (int)l4) {
                l3 = 0xFFFFFFFF00000000L & l4 + 0x1000000000000L | 0xFFFFFFFFL & (long)n3;
                short s = (short)(l4 >>> 32);
                if (s > 2 && U.compareAndSwapLong(this, CTL, l4, l3)) {
                    return false;
                }
                l2 = 2000000000L * (long)(s >= 0 ? 1 : 1 - s);
                l = System.nanoTime() + l2 - 20000000L;
            } else {
                l = 0L;
                l2 = 0L;
                l3 = 0L;
            }
            Thread thread = Thread.currentThread();
            U.putObject((Object)thread, PARKBLOCKER, (Object)this);
            workQueue.parker = thread;
            if (workQueue.scanState < 0 && this.ctl == l4) {
                U.park(false, l2);
            }
            U.putOrderedObject(workQueue, QPARKER, null);
            U.putObject((Object)thread, PARKBLOCKER, null);
            if (workQueue.scanState >= 0) break;
            if (l2 == 0L || this.ctl != l4 || l - System.nanoTime() > 0L || !U.compareAndSwapLong(this, CTL, l4, l3)) continue;
            return false;
        }
        return true;
    }

    final int helpComplete(WorkQueue workQueue, CountedCompleter<?> countedCompleter, int n) {
        int n2;
        int n3 = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null && (n2 = workQueueArray.length - 1) >= 0 && countedCompleter != null && workQueue != null) {
            int n4 = workQueue.config;
            int n5 = workQueue.hint ^ workQueue.top;
            int n6 = n5 & n2;
            int n7 = 1;
            int n8 = n6;
            int n9 = 0;
            int n10 = 0;
            while ((n3 = countedCompleter.status) >= 0) {
                CountedCompleter<?> countedCompleter2;
                if (n7 == 1 && (countedCompleter2 = workQueue.popCC(countedCompleter, n4)) != null) {
                    countedCompleter2.doExec();
                    if (n != 0 && --n == 0) break;
                    n6 = n8;
                    n10 = 0;
                    n9 = 0;
                    continue;
                }
                WorkQueue workQueue2 = workQueueArray[n8];
                if (workQueue2 == null) {
                    n7 = 0;
                } else {
                    n7 = workQueue2.pollAndExecCC(countedCompleter);
                    if (n7 < 0) {
                        n10 += n7;
                    }
                }
                if (n7 > 0) {
                    if (n7 == 1 && n != 0 && --n == 0) break;
                    n5 ^= n5 << 13;
                    n5 ^= n5 >>> 17;
                    n5 ^= n5 << 5;
                    n6 = n8 = n5 & n2;
                    n10 = 0;
                    n9 = 0;
                    continue;
                }
                if ((n8 = n8 + 1 & n2) != n6) continue;
                if (n9 == (n9 = n10)) break;
                n10 = 0;
            }
        }
        return n3;
    }

    private void helpStealer(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        block9: {
            int n;
            int n2;
            WorkQueue[] workQueueArray = this.workQueues;
            int n3 = 0;
            if (workQueueArray == null || (n2 = workQueueArray.length - 1) < 0 || workQueue == null || forkJoinTask == null) break block9;
            block0: do {
                n = 0;
                WorkQueue workQueue2 = workQueue;
                ForkJoinTask<?> forkJoinTask2 = forkJoinTask;
                block1: while (forkJoinTask2.status >= 0) {
                    int n4 = workQueue2.hint | 1;
                    for (int i = 0; i <= n2; i += 2) {
                        int n5 = n4 + i & n2;
                        WorkQueue workQueue3 = workQueueArray[n5];
                        if (workQueue3 == null) continue;
                        if (workQueue3.currentSteal != forkJoinTask2) {
                            n += workQueue3.base;
                            continue;
                        }
                        workQueue2.hint = n5;
                        while (true) {
                            ForkJoinTask<?>[] forkJoinTaskArray;
                            block11: {
                                ForkJoinTask<?> forkJoinTask3;
                                block10: {
                                    i = workQueue3.base;
                                    n += i;
                                    forkJoinTask3 = workQueue3.currentJoin;
                                    if (forkJoinTask2.status < 0 || workQueue2.currentJoin != forkJoinTask2 || workQueue3.currentSteal != forkJoinTask2) continue block0;
                                    if (i - workQueue3.top >= 0) break block10;
                                    forkJoinTaskArray = workQueue3.array;
                                    if (workQueue3.array != null) break block11;
                                }
                                if ((forkJoinTask2 = forkJoinTask3) == null) continue block0;
                                workQueue2 = workQueue3;
                                continue block1;
                            }
                            int n6 = ((forkJoinTaskArray.length - 1 & i) << ASHIFT) + ABASE;
                            ForkJoinTask<?> forkJoinTask4 = (ForkJoinTask<?>)U.getObjectVolatile(forkJoinTaskArray, n6);
                            if (workQueue3.base != i) continue;
                            if (forkJoinTask4 == null) continue block0;
                            if (!U.compareAndSwapObject(forkJoinTaskArray, n6, forkJoinTask4, null)) continue;
                            workQueue3.base = i + 1;
                            ForkJoinTask<?> forkJoinTask5 = workQueue.currentSteal;
                            int n7 = workQueue.top;
                            do {
                                U.putOrderedObject(workQueue, QCURRENTSTEAL, forkJoinTask4);
                                forkJoinTask4.doExec();
                            } while (forkJoinTask.status >= 0 && workQueue.top != n7 && (forkJoinTask4 = workQueue.pop()) != null);
                            U.putOrderedObject(workQueue, QCURRENTSTEAL, forkJoinTask5);
                            if (workQueue.base != workQueue.top) break;
                        }
                        return;
                    }
                }
            } while (forkJoinTask.status >= 0 && n3 != (n3 = n));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryCompensate(WorkQueue workQueue) {
        int n;
        if (workQueue == null) return false;
        if (workQueue.qlock < 0) return false;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues == null) return false;
        int n2 = workQueueArray.length - 1;
        if (n2 <= 0) return false;
        int n3 = this.config & 0xFFFF;
        if (n3 == 0) {
            return false;
        }
        long l = this.ctl;
        int n4 = (int)l;
        if (n4 != 0) {
            return this.tryRelease(l, workQueueArray[n4 & n2], 0L);
        }
        int n5 = (int)(l >> 48) + n3;
        int n6 = (short)(l >> 32) + n3;
        int n7 = 0;
        for (n = 0; n <= n2; ++n) {
            WorkQueue workQueue2 = workQueueArray[(n << 1 | 1) & n2];
            if (workQueue2 == null) continue;
            if ((workQueue2.scanState & 1) != 0) break;
            ++n7;
        }
        if (n7 != n6 << 1) return false;
        if (this.ctl != l) {
            return false;
        }
        if (n6 >= n3 && n5 > 1 && workQueue.isEmpty()) {
            long l2 = 0xFFFF000000000000L & l - 0x1000000000000L | 0xFFFFFFFFFFFFL & l;
            return U.compareAndSwapLong(this, CTL, l, l2);
        }
        if (n6 >= Short.MAX_VALUE) throw new RejectedExecutionException("Thread limit exceeded replacing blocked worker");
        if (this == common && n6 >= n3 + commonMaxSpares) {
            throw new RejectedExecutionException("Thread limit exceeded replacing blocked worker");
        }
        n = 0;
        long l3 = 0xFFFF000000000000L & l | 0xFFFF00000000L & l + 0x100000000L;
        int n8 = this.lockRunState();
        if ((n8 & 0x20000000) == 0) {
            n = U.compareAndSwapLong(this, CTL, l, l3) ? 1 : 0;
        }
        this.unlockRunState(n8, n8 & 0xFFFFFFFE);
        if (n == 0) return false;
        if (!this.createWorker()) return false;
        return true;
    }

    final int awaitJoin(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask, long l) {
        int n = 0;
        if (forkJoinTask != null && workQueue != null) {
            CountedCompleter countedCompleter;
            ForkJoinTask<?> forkJoinTask2 = workQueue.currentJoin;
            U.putOrderedObject(workQueue, QCURRENTJOIN, forkJoinTask);
            CountedCompleter countedCompleter2 = countedCompleter = forkJoinTask instanceof CountedCompleter ? (CountedCompleter)forkJoinTask : null;
            while ((n = forkJoinTask.status) >= 0) {
                long l2;
                if (countedCompleter != null) {
                    this.helpComplete(workQueue, countedCompleter, 0);
                } else if (workQueue.base == workQueue.top || workQueue.tryRemoveAndExec(forkJoinTask)) {
                    this.helpStealer(workQueue, forkJoinTask);
                }
                n = forkJoinTask.status;
                if (n < 0) break;
                if (l == 0L) {
                    l2 = 0L;
                } else {
                    long l3 = l - System.nanoTime();
                    if (l3 <= 0L) break;
                    l2 = TimeUnit.NANOSECONDS.toMillis(l3);
                    if (l2 <= 0L) {
                        l2 = 1L;
                    }
                }
                if (!this.tryCompensate(workQueue)) continue;
                forkJoinTask.internalWait(l2);
                U.getAndAddLong(this, CTL, 0x1000000000000L);
            }
            U.putOrderedObject(workQueue, QCURRENTJOIN, forkJoinTask2);
        }
        return n;
    }

    private WorkQueue findNonEmptyStealQueue() {
        int n;
        int n2 = ThreadLocalRandom.nextSecondarySeed();
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null && (n = workQueueArray.length - 1) >= 0) {
            int n3;
            int n4 = n3 = n2 & n;
            int n5 = 0;
            int n6 = 0;
            while (true) {
                WorkQueue workQueue;
                if ((workQueue = workQueueArray[n4]) != null) {
                    int n7 = workQueue.base;
                    if (n7 - workQueue.top < 0) {
                        return workQueue;
                    }
                    n6 += n7;
                }
                if ((n4 = n4 + 1 & n) != n3) continue;
                if (n5 == (n5 = n6)) break;
                n6 = 0;
            }
        }
        return null;
    }

    final void helpQuiescePool(WorkQueue workQueue) {
        ForkJoinTask<?> forkJoinTask = workQueue.currentSteal;
        boolean bl = true;
        while (true) {
            long l;
            workQueue.execLocalTasks();
            WorkQueue workQueue2 = this.findNonEmptyStealQueue();
            if (workQueue2 != null) {
                ForkJoinTask<?> forkJoinTask2;
                int n;
                if (!bl) {
                    bl = true;
                    U.getAndAddLong(this, CTL, 0x1000000000000L);
                }
                if ((n = workQueue2.base) - workQueue2.top >= 0 || (forkJoinTask2 = workQueue2.pollAt(n)) == null) continue;
                U.putOrderedObject(workQueue, QCURRENTSTEAL, forkJoinTask2);
                forkJoinTask2.doExec();
                if (++workQueue.nsteals >= 0) continue;
                workQueue.transferStealCount(this);
                continue;
            }
            if (bl) {
                l = this.ctl;
                long l2 = 0xFFFF000000000000L & l - 0x1000000000000L | 0xFFFFFFFFFFFFL & l;
                if ((int)(l2 >> 48) + (this.config & 0xFFFF) > 0) {
                    if (!U.compareAndSwapLong(this, CTL, l, l2)) continue;
                    bl = false;
                    continue;
                }
                break;
            }
            l = this.ctl;
            if ((int)(l >> 48) + (this.config & 0xFFFF) <= 0 && U.compareAndSwapLong(this, CTL, l, l + 0x1000000000000L)) break;
        }
        U.putOrderedObject(workQueue, QCURRENTSTEAL, forkJoinTask);
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue workQueue) {
        ForkJoinTask<?> forkJoinTask;
        WorkQueue workQueue2;
        int n;
        do {
            if ((forkJoinTask = workQueue.nextLocalTask()) != null) {
                return forkJoinTask;
            }
            workQueue2 = this.findNonEmptyStealQueue();
            if (workQueue2 != null) continue;
            return null;
        } while ((n = workQueue2.base) - workQueue2.top >= 0 || (forkJoinTask = workQueue2.pollAt(n)) == null);
        return forkJoinTask;
    }

    static int getSurplusQueuedTaskCount() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            ForkJoinPool forkJoinPool = forkJoinWorkerThread.pool;
            int n = forkJoinPool.config & 0xFFFF;
            WorkQueue workQueue = forkJoinWorkerThread.workQueue;
            int n2 = workQueue.top - workQueue.base;
            int n3 = (int)(forkJoinPool.ctl >> 48) + n;
            return n2 - (n3 > (n >>>= 1) ? 0 : (n3 > (n >>>= 1) ? 1 : (n3 > (n >>>= 1) ? 2 : (n3 > (n >>>= 1) ? 4 : 8))));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean tryTerminate(boolean var1_1, boolean var2_2) {
        if (this == ForkJoinPool.common) {
            return false;
        }
        var3_3 = this.runState;
        if (var3_3 >= 0) {
            if (!var2_2) {
                return false;
            }
            var3_3 = this.lockRunState();
            this.unlockRunState(var3_3, var3_3 & -2 | -2147483648);
        }
        if ((var3_3 & 0x20000000) == 0) {
            if (!var1_1) {
                var4_4 = 0L;
                do {
                    if ((int)((var12_12 = this.ctl) >> 48) + (this.config & 65535) > 0) {
                        return false;
                    }
                    var6_6 = this.workQueues;
                    if (this.workQueues == null || (var8_8 = var6_6.length - 1) <= 0) break;
                    for (var14_13 = 0; var14_13 <= var8_8; ++var14_13) {
                        var7_7 /* !! */  = var6_6[var14_13];
                        if (var7_7 /* !! */  == null) continue;
                        var9_10 = var7_7 /* !! */ .base;
                        if (var9_10 != var7_7 /* !! */ .top || var7_7 /* !! */ .scanState >= 0 || var7_7 /* !! */ .currentSteal != null) {
                            var10_15 = this.ctl;
                            this.tryRelease(var10_15, var6_6[var8_8 & (int)var10_15], 0x1000000000000L);
                            return false;
                        }
                        var12_12 += (long)var9_10;
                        if ((var14_13 & 1) != 0) continue;
                        var7_7 /* !! */ .qlock = -1;
                    }
                } while (var4_4 != (var4_4 = var12_12));
            }
            if ((this.runState & 0x20000000) == 0) {
                var3_3 = this.lockRunState();
                this.unlockRunState(var3_3, var3_3 & -2 | 0x20000000);
            }
        }
        var4_5 = 0;
        var5_17 = 0L;
        block7: while (true) {
            block25: {
                block24: {
                    if ((short)((var11_18 = this.ctl) >>> 32) + (this.config & 65535) <= 0) break block24;
                    var7_7 /* !! */  = this.workQueues;
                    if (this.workQueues != null && (var10_16 = var7_7 /* !! */ .length - 1) > 0) break block25;
                }
                if ((this.runState & 0x40000000) != 0) break;
                var3_3 = this.lockRunState();
                this.unlockRunState(var3_3, var3_3 & -2 | 0x40000000);
                var13_19 = this;
                synchronized (var13_19) {
                    this.notifyAll();
                    break;
                }
            }
            for (var13_20 = 0; var13_20 <= var10_16; ++var13_20) {
                var8_9 = var7_7 /* !! */ [var13_20];
                if (var8_9 == null) continue;
                var11_18 += (long)var8_9.base;
                var8_9.qlock = -1;
                if (var4_5 <= 0) continue;
                var8_9.cancelAll();
                if (var4_5 <= 1 || (var9_11 = var8_9.owner) == null) continue;
                if (!var9_11.isInterrupted()) {
                    try {
                        var9_11.interrupt();
                    }
                    catch (Throwable var14_14) {
                        // empty catch block
                    }
                }
                if (var8_9.scanState >= 0) continue;
                ForkJoinPool.U.unpark(var9_11);
            }
            if (var11_18 != var5_17) {
                var5_17 = var11_18;
                var4_5 = 0;
                continue;
            }
            if (var4_5 > 3 && var4_5 > var10_16) break;
            if (++var4_5 <= 1) continue;
            var15_22 = 0;
            while (true) {
                if (var15_22++ <= var10_16 && (var16_24 = (int)(var13_21 = this.ctl)) != 0) ** break;
                continue block7;
                this.tryRelease(var13_21, var7_7 /* !! */ [var16_24 & var10_16], 0x1000000000000L);
            }
            break;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void externalSubmit(ForkJoinTask<?> var1_1) {
        var2_2 = ThreadLocalRandom.getProbe();
        if (var2_2 == 0) {
            ThreadLocalRandom.localInit();
            var2_2 = ThreadLocalRandom.getProbe();
        }
        while (true) {
            var8_8 = false;
            var5_5 = this.runState;
            if (var5_5 < 0) {
                this.tryTerminate(false, false);
                throw new RejectedExecutionException();
            }
            if ((var5_5 & 4) == 0) ** GOTO lbl-1000
            var3_3 = this.workQueues;
            if (this.workQueues == null || (var6_6 = var3_3.length - 1) < 0) lbl-1000:
            // 2 sources

            {
                var9_9 = 0;
                var5_5 = this.lockRunState();
                try {
                    if ((var5_5 & 4) != 0) ** GOTO lbl73
                    ForkJoinPool.U.compareAndSwapObject(this, ForkJoinPool.STEALCOUNTER, null, new AtomicLong());
                    var10_11 = this.config & 65535;
                    var11_12 = var10_11 > 1 ? var10_11 - 1 : 1;
                    var11_12 |= var11_12 >>> 1;
                    var11_12 |= var11_12 >>> 2;
                    var11_12 |= var11_12 >>> 4;
                    var11_12 |= var11_12 >>> 8;
                    var11_12 |= var11_12 >>> 16;
                    var11_12 = var11_12 + 1 << 1;
                    this.workQueues = new WorkQueue[var11_12];
                    var9_9 = 4;
                }
                finally {
                    this.unlockRunState(var5_5, var5_5 & -2 | var9_9);
                }
            } else {
                var7_7 = var2_2 & var6_6 & 126;
                var4_4 = var3_3[var7_7];
                if (var4_4 != null) {
                    if (var4_4.qlock == 0 && ForkJoinPool.U.compareAndSwapInt(var4_4, ForkJoinPool.QLOCK, 0, 1)) {
                        var9_10 = var4_4.array;
                        var10_11 = var4_4.top;
                        var11_12 = 0;
                        try {
                            if (var9_10 != null && var9_10.length > var10_11 + 1 - var4_4.base || (var9_10 = var4_4.growArray()) != null) {
                                var12_13 = ((var9_10.length - 1 & var10_11) << ForkJoinPool.ASHIFT) + ForkJoinPool.ABASE;
                                ForkJoinPool.U.putOrderedObject(var9_10, var12_13, var1_1);
                                ForkJoinPool.U.putOrderedInt(var4_4, ForkJoinPool.QTOP, var10_11 + 1);
                                var11_12 = 1;
                            }
                        }
                        finally {
                            ForkJoinPool.U.compareAndSwapInt(var4_4, ForkJoinPool.QLOCK, 1, 0);
                        }
                        if (var11_12 != 0) {
                            this.signalWork(var3_3, var4_4);
                            return;
                        }
                    }
                    var8_8 = true;
                } else {
                    var5_5 = this.runState;
                    if ((var5_5 & 1) == 0) {
                        var4_4 = new WorkQueue(this, null);
                        var4_4.hint = var2_2;
                        var4_4.config = var7_7 | -2147483648;
                        var4_4.scanState = -2147483648;
                        var5_5 = this.lockRunState();
                        if (var5_5 > 0) {
                            var3_3 = this.workQueues;
                            if (this.workQueues != null && var7_7 < var3_3.length && var3_3[var7_7] == null) {
                                var3_3[var7_7] = var4_4;
                            }
                        }
                        this.unlockRunState(var5_5, var5_5 & -2);
                    } else {
                        var8_8 = true;
                    }
                }
            }
lbl73:
            // 5 sources

            if (!var8_8) continue;
            var2_2 = ThreadLocalRandom.advanceProbe(var2_2);
        }
    }

    final void externalPush(ForkJoinTask<?> forkJoinTask) {
        WorkQueue workQueue;
        int n;
        int n2 = ThreadLocalRandom.getProbe();
        int n3 = this.runState;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null && (n = workQueueArray.length - 1) >= 0 && (workQueue = workQueueArray[n & n2 & 0x7E]) != null && n2 != 0 && n3 > 0 && U.compareAndSwapInt(workQueue, QLOCK, 0, 1)) {
            int n4;
            int n5;
            int n6;
            ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
            if (workQueue.array != null && (n6 = forkJoinTaskArray.length - 1) > (n5 = (n4 = workQueue.top) - workQueue.base)) {
                int n7 = ((n6 & n4) << ASHIFT) + ABASE;
                U.putOrderedObject(forkJoinTaskArray, n7, forkJoinTask);
                U.putOrderedInt(workQueue, QTOP, n4 + 1);
                U.putIntVolatile(workQueue, QLOCK, 0);
                if (n5 <= 1) {
                    this.signalWork(workQueueArray, workQueue);
                }
                return;
            }
            U.compareAndSwapInt(workQueue, QLOCK, 1, 0);
        }
        this.externalSubmit(forkJoinTask);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WorkQueue commonSubmitterQueue() {
        ForkJoinPool forkJoinPool = common;
        int n = ThreadLocalRandom.getProbe();
        if (forkJoinPool == null) return null;
        WorkQueue[] workQueueArray = forkJoinPool.workQueues;
        if (forkJoinPool.workQueues == null) return null;
        int n2 = workQueueArray.length - 1;
        if (n2 < 0) return null;
        WorkQueue workQueue = workQueueArray[n2 & n & 0x7E];
        return workQueue;
    }

    final boolean tryExternalUnpush(ForkJoinTask<?> forkJoinTask) {
        WorkQueue workQueue;
        int n;
        int n2 = ThreadLocalRandom.getProbe();
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null && (n = workQueueArray.length - 1) >= 0 && (workQueue = workQueueArray[n & n2 & 0x7E]) != null) {
            int n3;
            ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
            if (workQueue.array != null && (n3 = workQueue.top) != workQueue.base) {
                long l = ((forkJoinTaskArray.length - 1 & n3 - 1) << ASHIFT) + ABASE;
                if (U.compareAndSwapInt(workQueue, QLOCK, 0, 1)) {
                    if (workQueue.top == n3 && workQueue.array == forkJoinTaskArray && U.getObject(forkJoinTaskArray, l) == forkJoinTask && U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) {
                        U.putOrderedInt(workQueue, QTOP, n3 - 1);
                        U.putOrderedInt(workQueue, QLOCK, 0);
                        return true;
                    }
                    U.compareAndSwapInt(workQueue, QLOCK, 1, 0);
                }
            }
        }
        return false;
    }

    final int externalHelpComplete(CountedCompleter<?> countedCompleter, int n) {
        int n2;
        int n3 = ThreadLocalRandom.getProbe();
        WorkQueue[] workQueueArray = this.workQueues;
        return this.workQueues == null || (n2 = workQueueArray.length) == 0 ? 0 : this.helpComplete(workQueueArray[n2 - 1 & n3 & 0x7E], countedCompleter, n);
    }

    public ForkJoinPool() {
        this(Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors()), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n) {
        this(n, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean bl) {
        this(ForkJoinPool.checkParallelism(n), ForkJoinPool.checkFactory(forkJoinWorkerThreadFactory), uncaughtExceptionHandler, bl ? 65536 : 0, "ForkJoinPool-" + ForkJoinPool.nextPoolId() + "-worker-");
        ForkJoinPool.checkPermission();
    }

    private static int checkParallelism(int n) {
        if (n <= 0 || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    private static ForkJoinWorkerThreadFactory checkFactory(ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory) {
        if (forkJoinWorkerThreadFactory == null) {
            throw new NullPointerException();
        }
        return forkJoinWorkerThreadFactory;
    }

    private ForkJoinPool(int n, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, int n2, String string) {
        this.workerNamePrefix = string;
        this.factory = forkJoinWorkerThreadFactory;
        this.ueh = uncaughtExceptionHandler;
        this.config = n & 0xFFFF | n2;
        long l = -n;
        this.ctl = l << 48 & 0xFFFF000000000000L | l << 32 & 0xFFFF00000000L;
    }

    public static ForkJoinPool commonPool() {
        return common;
    }

    public <T> T invoke(ForkJoinTask<T> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.externalPush(forkJoinTask);
        return forkJoinTask.join();
    }

    public void execute(ForkJoinTask<?> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.externalPush(forkJoinTask);
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask)((Object)runnable) : new ForkJoinTask.RunnableExecuteAction(runnable);
        this.externalPush(forkJoinTask);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.externalPush(forkJoinTask);
        return forkJoinTask;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> callable) {
        ForkJoinTask.AdaptedCallable<T> adaptedCallable = new ForkJoinTask.AdaptedCallable<T>(callable);
        this.externalPush(adaptedCallable);
        return adaptedCallable;
    }

    public <T> ForkJoinTask<T> submit(Runnable runnable, T t) {
        ForkJoinTask.AdaptedRunnable<T> adaptedRunnable = new ForkJoinTask.AdaptedRunnable<T>(runnable, t);
        this.externalPush(adaptedRunnable);
        return adaptedRunnable;
    }

    public ForkJoinTask<?> submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask)((Object)runnable) : new ForkJoinTask.AdaptedRunnableAction(runnable);
        this.externalPush(forkJoinTask);
        return forkJoinTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        ArrayList<Future<T>> arrayList;
        block7: {
            int n;
            int n2;
            ArrayList<Future<T>> arrayList2 = new ArrayList<Future<T>>(collection.size());
            boolean bl = false;
            try {
                for (Callable<T> callable : collection) {
                    ForkJoinTask.AdaptedCallable<T> adaptedCallable = new ForkJoinTask.AdaptedCallable<T>(callable);
                    arrayList2.add(adaptedCallable);
                    this.externalPush(adaptedCallable);
                }
                n2 = arrayList2.size();
                for (int i = 0; i < n2; ++i) {
                    ((ForkJoinTask)arrayList2.get(i)).quietlyJoin();
                }
                bl = true;
                arrayList = arrayList2;
                if (bl) break block7;
                n = arrayList2.size();
            }
            catch (Throwable throwable) {
                if (!bl) {
                    int n3 = arrayList2.size();
                    for (int i = 0; i < n3; ++i) {
                        ((Future)arrayList2.get(i)).cancel(false);
                    }
                }
                throw throwable;
            }
            for (n2 = 0; n2 < n; ++n2) {
                arrayList2.get(n2).cancel(false);
            }
        }
        return arrayList;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        int n = this.config & 0xFFFF;
        return n > 0 ? n : 1;
    }

    public static int getCommonPoolParallelism() {
        return commonParallelism;
    }

    public int getPoolSize() {
        return (this.config & 0xFFFF) + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return (this.config & 0x10000) != 0;
    }

    public int getRunningThreadCount() {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null || !workQueue.isApparentlyUnblocked()) continue;
                ++n;
            }
        }
        return n;
    }

    public int getActiveThreadCount() {
        int n = (this.config & 0xFFFF) + (int)(this.ctl >> 48);
        return n <= 0 ? 0 : n;
    }

    public boolean isQuiescent() {
        return (this.config & 0xFFFF) + (int)(this.ctl >> 48) <= 0;
    }

    public long getStealCount() {
        AtomicLong atomicLong = this.stealCounter;
        long l = atomicLong == null ? 0L : atomicLong.get();
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                l += (long)workQueue.nsteals;
            }
        }
        return l;
    }

    public long getQueuedTaskCount() {
        long l = 0L;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                l += (long)workQueue.queueSize();
            }
        }
        return l;
    }

    public int getQueuedSubmissionCount() {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                n += workQueue.queueSize();
            }
        }
        return n;
    }

    public boolean hasQueuedSubmissions() {
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null || workQueue.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; i += 2) {
                ForkJoinTask<?> forkJoinTask;
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null || (forkJoinTask = workQueue.poll()) == null) continue;
                return forkJoinTask;
            }
        }
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> collection) {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; ++i) {
                ForkJoinTask<?> forkJoinTask;
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                while ((forkJoinTask = workQueue.poll()) != null) {
                    collection.add(forkJoinTask);
                    ++n;
                }
            }
        }
        return n;
    }

    public String toString() {
        int n;
        int n2;
        int n3;
        long l = 0L;
        long l2 = 0L;
        int n4 = 0;
        AtomicLong atomicLong = this.stealCounter;
        long l3 = atomicLong == null ? 0L : atomicLong.get();
        long l4 = this.ctl;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (n3 = 0; n3 < workQueueArray.length; ++n3) {
                WorkQueue workQueue = workQueueArray[n3];
                if (workQueue == null) continue;
                n2 = workQueue.queueSize();
                if ((n3 & 1) == 0) {
                    l2 += (long)n2;
                    continue;
                }
                l += (long)n2;
                l3 += (long)workQueue.nsteals;
                if (!workQueue.isApparentlyUnblocked()) continue;
                ++n4;
            }
        }
        n3 = this.config & 0xFFFF;
        n2 = n3 + (short)(l4 >>> 32);
        int n5 = n3 + (int)(l4 >> 48);
        if (n5 < 0) {
            n5 = 0;
        }
        String string = ((n = this.runState) & 0x40000000) != 0 ? "Terminated" : ((n & 0x20000000) != 0 ? "Terminating" : ((n & Integer.MIN_VALUE) != 0 ? "Shutting down" : "Running"));
        return super.toString() + "[" + string + ", parallelism = " + n3 + ", size = " + n2 + ", active = " + n5 + ", running = " + n4 + ", steals = " + l3 + ", tasks = " + l + ", submissions = " + l2 + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return (this.runState & 0x40000000) != 0;
    }

    public boolean isTerminating() {
        int n = this.runState;
        return (n & 0x20000000) != 0 && (n & 0x40000000) == 0;
    }

    @Override
    public boolean isShutdown() {
        return (this.runState & Integer.MIN_VALUE) != 0;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this == common) {
            this.awaitQuiescence(l, timeUnit);
            return false;
        }
        long l2 = timeUnit.toNanos(l);
        if (this.isTerminated()) {
            return true;
        }
        if (l2 <= 0L) {
            return false;
        }
        long l3 = System.nanoTime() + l2;
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            while (true) {
                if (this.isTerminated()) {
                    return true;
                }
                if (l2 <= 0L) {
                    return false;
                }
                long l4 = TimeUnit.NANOSECONDS.toMillis(l2);
                this.wait(l4 > 0L ? l4 : 1L);
                l2 = l3 - System.nanoTime();
            }
        }
    }

    public boolean awaitQuiescence(long l, TimeUnit timeUnit) {
        long l2 = timeUnit.toNanos(l);
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            if (forkJoinWorkerThread.pool == this) {
                this.helpQuiescePool(forkJoinWorkerThread.workQueue);
                return true;
            }
        }
        long l3 = System.nanoTime();
        int n = 0;
        boolean bl = true;
        block0: while (!this.isQuiescent()) {
            int n2;
            WorkQueue[] workQueueArray = this.workQueues;
            if (this.workQueues == null || (n2 = workQueueArray.length - 1) < 0) break;
            if (!bl) {
                if (System.nanoTime() - l3 > l2) {
                    return false;
                }
                Thread.yield();
            }
            bl = false;
            for (int i = n2 + 1 << 2; i >= 0; --i) {
                int n3;
                WorkQueue workQueue;
                int n4;
                if ((n4 = n++ & n2) > n2 || n4 < 0 || (workQueue = workQueueArray[n4]) == null || (n3 = workQueue.base) - workQueue.top >= 0) continue;
                bl = true;
                ForkJoinTask<?> forkJoinTask = workQueue.pollAt(n3);
                if (forkJoinTask == null) continue block0;
                forkJoinTask.doExec();
                continue block0;
            }
        }
        return true;
    }

    static void quiesceCommonPool() {
        common.awaitQuiescence(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void managedBlock(ManagedBlocker managedBlocker) throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            ForkJoinPool forkJoinPool = forkJoinWorkerThread.pool;
            if (forkJoinPool != null) {
                WorkQueue workQueue = forkJoinWorkerThread.workQueue;
                while (!managedBlocker.isReleasable()) {
                    if (!forkJoinPool.tryCompensate(workQueue)) continue;
                    try {
                        while (!managedBlocker.isReleasable() && !managedBlocker.block()) {
                        }
                        return;
                    }
                    finally {
                        U.getAndAddLong(forkJoinPool, CTL, 0x1000000000000L);
                    }
                }
                return;
            }
        }
        while (!managedBlocker.isReleasable() && !managedBlocker.block()) {
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, t);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ForkJoinTask.AdaptedCallable<T>(callable);
    }

    private static ForkJoinPool makeCommonPool() {
        int n = -1;
        ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory = null;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
        try {
            String string = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
            String string2 = System.getProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
            String string3 = System.getProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if (string2 != null) {
                forkJoinWorkerThreadFactory = (ForkJoinWorkerThreadFactory)ClassLoader.getSystemClassLoader().loadClass(string2).newInstance();
            }
            if (string3 != null) {
                uncaughtExceptionHandler = (Thread.UncaughtExceptionHandler)ClassLoader.getSystemClassLoader().loadClass(string3).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (forkJoinWorkerThreadFactory == null) {
            forkJoinWorkerThreadFactory = System.getSecurityManager() == null ? defaultForkJoinWorkerThreadFactory : new InnocuousForkJoinWorkerThreadFactory();
        }
        if (n < 0 && (n = Runtime.getRuntime().availableProcessors() - 1) <= 0) {
            n = 1;
        }
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        }
        return new ForkJoinPool(n, forkJoinWorkerThreadFactory, uncaughtExceptionHandler, 0, "ForkJoinPool.commonPool-worker-");
    }

    static {
        try {
            U = Unsafe.getUnsafe();
            Class<ForkJoinPool> clazz = ForkJoinPool.class;
            CTL = U.objectFieldOffset(clazz.getDeclaredField("ctl"));
            RUNSTATE = U.objectFieldOffset(clazz.getDeclaredField("runState"));
            STEALCOUNTER = U.objectFieldOffset(clazz.getDeclaredField("stealCounter"));
            Class<Thread> clazz2 = Thread.class;
            PARKBLOCKER = U.objectFieldOffset(clazz2.getDeclaredField("parkBlocker"));
            Class<WorkQueue> clazz3 = WorkQueue.class;
            QTOP = U.objectFieldOffset(clazz3.getDeclaredField("top"));
            QLOCK = U.objectFieldOffset(clazz3.getDeclaredField("qlock"));
            QSCANSTATE = U.objectFieldOffset(clazz3.getDeclaredField("scanState"));
            QPARKER = U.objectFieldOffset(clazz3.getDeclaredField("parker"));
            QCURRENTSTEAL = U.objectFieldOffset(clazz3.getDeclaredField("currentSteal"));
            QCURRENTJOIN = U.objectFieldOffset(clazz3.getDeclaredField("currentJoin"));
            Class<ForkJoinTask[]> clazz4 = ForkJoinTask[].class;
            ABASE = U.arrayBaseOffset(clazz4);
            int n = U.arrayIndexScale(clazz4);
            if ((n & n - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        commonMaxSpares = 256;
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        modifyThreadPermission = new RuntimePermission("modifyThread");
        common = AccessController.doPrivileged(new PrivilegedAction<ForkJoinPool>(){

            @Override
            public ForkJoinPool run() {
                return ForkJoinPool.makeCommonPool();
            }
        });
        int n = ForkJoinPool.common.config & 0xFFFF;
        commonParallelism = n > 0 ? n : 1;
    }

    static final class InnocuousForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private static final AccessControlContext innocuousAcc;

        InnocuousForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(final ForkJoinPool forkJoinPool) {
            return (ForkJoinWorkerThread.InnocuousForkJoinWorkerThread)AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    return new ForkJoinWorkerThread.InnocuousForkJoinWorkerThread(forkJoinPool);
                }
            }, innocuousAcc);
        }

        static {
            Permissions permissions = new Permissions();
            permissions.add(modifyThreadPermission);
            permissions.add(new RuntimePermission("enableContextClassLoaderOverride"));
            permissions.add(new RuntimePermission("modifyThreadGroup"));
            innocuousAcc = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    @Contended
    static final class WorkQueue {
        static final int INITIAL_QUEUE_CAPACITY = 8192;
        static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
        volatile int scanState;
        int stackPred;
        int nsteals;
        int hint;
        int config;
        volatile int qlock;
        volatile int base;
        int top;
        ForkJoinTask<?>[] array;
        final ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        volatile Thread parker;
        volatile ForkJoinTask<?> currentJoin;
        volatile ForkJoinTask<?> currentSteal;
        private static final Unsafe U;
        private static final int ABASE;
        private static final int ASHIFT;
        private static final long QTOP;
        private static final long QLOCK;
        private static final long QCURRENTSTEAL;

        WorkQueue(ForkJoinPool forkJoinPool, ForkJoinWorkerThread forkJoinWorkerThread) {
            this.pool = forkJoinPool;
            this.owner = forkJoinWorkerThread;
            this.top = 4096;
            this.base = 4096;
        }

        final int getPoolIndex() {
            return (this.config & 0xFFFF) >>> 1;
        }

        final int queueSize() {
            int n = this.base - this.top;
            return n >= 0 ? 0 : -n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isEmpty() {
            int n = this.top;
            int n2 = this.base - n;
            if (n2 >= 0) return true;
            if (n2 != -1) return false;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array == null) return true;
            int n3 = forkJoinTaskArray.length - 1;
            if (n3 < 0) return true;
            if (U.getObject(forkJoinTaskArray, (long)((n3 & n - 1) << ASHIFT) + (long)ABASE) != null) return false;
            return true;
        }

        final void push(ForkJoinTask<?> forkJoinTask) {
            int n = this.base;
            int n2 = this.top;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null) {
                int n3 = forkJoinTaskArray.length - 1;
                U.putOrderedObject(forkJoinTaskArray, ((n3 & n2) << ASHIFT) + ABASE, forkJoinTask);
                U.putOrderedInt(this, QTOP, n2 + 1);
                int n4 = n2 - n;
                if (n4 <= 1) {
                    ForkJoinPool forkJoinPool = this.pool;
                    if (forkJoinPool != null) {
                        forkJoinPool.signalWork(forkJoinPool.workQueues, this);
                    }
                } else if (n4 >= n3) {
                    this.growArray();
                }
            }
        }

        final ForkJoinTask<?>[] growArray() {
            int n;
            int n2;
            int n3;
            int n4;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            int n5 = n4 = forkJoinTaskArray != null ? forkJoinTaskArray.length << 1 : 8192;
            if (n4 > 0x4000000) {
                throw new RejectedExecutionException("Queue capacity exceeded");
            }
            this.array = new ForkJoinTask[n4];
            ForkJoinTask[] forkJoinTaskArray2 = this.array;
            if (forkJoinTaskArray != null && (n3 = forkJoinTaskArray.length - 1) >= 0 && (n2 = this.top) - (n = this.base) > 0) {
                int n6 = n4 - 1;
                do {
                    int n7 = ((n & n3) << ASHIFT) + ABASE;
                    int n8 = ((n & n6) << ASHIFT) + ABASE;
                    ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n7);
                    if (forkJoinTask == null || !U.compareAndSwapObject(forkJoinTaskArray, n7, forkJoinTask, null)) continue;
                    U.putObjectVolatile(forkJoinTaskArray2, n8, forkJoinTask);
                } while (++n != n2);
            }
            return forkJoinTaskArray2;
        }

        final ForkJoinTask<?> pop() {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (n = forkJoinTaskArray.length - 1) >= 0) {
                long l;
                ForkJoinTask forkJoinTask;
                int n2;
                while ((n2 = this.top - 1) - this.base >= 0 && (forkJoinTask = (ForkJoinTask)U.getObject(forkJoinTaskArray, l = (long)(((n & n2) << ASHIFT) + ABASE))) != null) {
                    if (!U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) continue;
                    U.putOrderedInt(this, QTOP, n2);
                    return forkJoinTask;
                }
            }
            return null;
        }

        final ForkJoinTask<?> pollAt(int n) {
            int n2;
            ForkJoinTask forkJoinTask;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE)) != null && this.base == n && U.compareAndSwapObject(forkJoinTaskArray, n2, forkJoinTask, null)) {
                this.base = n + 1;
                return forkJoinTask;
            }
            return null;
        }

        final ForkJoinTask<?> poll() {
            int n;
            while ((n = this.base) - this.top < 0) {
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                if (this.array == null) break;
                int n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE;
                ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n2);
                if (this.base != n) continue;
                if (forkJoinTask != null) {
                    if (!U.compareAndSwapObject(forkJoinTaskArray, n2, forkJoinTask, null)) continue;
                    this.base = n + 1;
                    return forkJoinTask;
                }
                if (n + 1 != this.top) continue;
                break;
            }
            return null;
        }

        final ForkJoinTask<?> nextLocalTask() {
            return (this.config & 0x10000) == 0 ? this.pop() : this.poll();
        }

        final ForkJoinTask<?> peek() {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (forkJoinTaskArray == null || (n = forkJoinTaskArray.length - 1) < 0) {
                return null;
            }
            int n2 = (this.config & 0x10000) == 0 ? this.top - 1 : this.base;
            int n3 = ((n2 & n) << ASHIFT) + ABASE;
            return (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n3);
        }

        final boolean tryUnpush(ForkJoinTask<?> forkJoinTask) {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (n = this.top) != this.base && U.compareAndSwapObject(forkJoinTaskArray, ((forkJoinTaskArray.length - 1 & --n) << ASHIFT) + ABASE, forkJoinTask, null)) {
                U.putOrderedInt(this, QTOP, n);
                return true;
            }
            return false;
        }

        final void cancelAll() {
            ForkJoinTask<?> forkJoinTask = this.currentJoin;
            if (forkJoinTask != null) {
                this.currentJoin = null;
                ForkJoinTask.cancelIgnoringExceptions(forkJoinTask);
            }
            if ((forkJoinTask = this.currentSteal) != null) {
                this.currentSteal = null;
                ForkJoinTask.cancelIgnoringExceptions(forkJoinTask);
            }
            while ((forkJoinTask = this.poll()) != null) {
                ForkJoinTask.cancelIgnoringExceptions(forkJoinTask);
            }
        }

        final void pollAndExecAll() {
            ForkJoinTask<?> forkJoinTask;
            while ((forkJoinTask = this.poll()) != null) {
                forkJoinTask.doExec();
            }
        }

        final void execLocalTasks() {
            int n;
            int n2 = this.base;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            int n3 = this.top - 1;
            if (n2 - n3 <= 0 && forkJoinTaskArray != null && (n = forkJoinTaskArray.length - 1) >= 0) {
                if ((this.config & 0x10000) == 0) {
                    ForkJoinTask forkJoinTask;
                    while ((forkJoinTask = (ForkJoinTask)U.getAndSetObject(forkJoinTaskArray, ((n & n3) << ASHIFT) + ABASE, null)) != null) {
                        U.putOrderedInt(this, QTOP, n3);
                        forkJoinTask.doExec();
                        n3 = this.top - 1;
                        if (this.base - n3 <= 0) continue;
                        break;
                    }
                } else {
                    this.pollAndExecAll();
                }
            }
        }

        final void runTask(ForkJoinTask<?> forkJoinTask) {
            if (forkJoinTask != null) {
                this.scanState &= 0xFFFFFFFE;
                this.currentSteal = forkJoinTask;
                this.currentSteal.doExec();
                U.putOrderedObject(this, QCURRENTSTEAL, null);
                this.execLocalTasks();
                ForkJoinWorkerThread forkJoinWorkerThread = this.owner;
                if (++this.nsteals < 0) {
                    this.transferStealCount(this.pool);
                }
                this.scanState |= 1;
                if (forkJoinWorkerThread != null) {
                    forkJoinWorkerThread.afterTopLevelExec();
                }
            }
        }

        final void transferStealCount(ForkJoinPool forkJoinPool) {
            AtomicLong atomicLong;
            if (forkJoinPool != null && (atomicLong = forkJoinPool.stealCounter) != null) {
                int n = this.nsteals;
                this.nsteals = 0;
                atomicLong.getAndAdd(n < 0 ? Integer.MAX_VALUE : n);
            }
        }

        final boolean tryRemoveAndExec(ForkJoinTask<?> forkJoinTask) {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (n = forkJoinTaskArray.length - 1) >= 0 && forkJoinTask != null) {
                int n2;
                int n3;
                int n4;
                while ((n4 = (n3 = this.top) - (n2 = this.base)) > 0) {
                    block12: {
                        do {
                            long l;
                            ForkJoinTask forkJoinTask2;
                            if ((forkJoinTask2 = (ForkJoinTask)U.getObject(forkJoinTaskArray, l = (long)(((--n3 & n) << ASHIFT) + ABASE))) == null) {
                                return n3 + 1 == this.top;
                            }
                            if (forkJoinTask2 == forkJoinTask) {
                                boolean bl = false;
                                if (n3 + 1 == this.top) {
                                    if (U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) {
                                        U.putOrderedInt(this, QTOP, n3);
                                        bl = true;
                                    }
                                } else if (this.base == n2) {
                                    bl = U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, new EmptyTask());
                                }
                                if (bl) {
                                    forkJoinTask.doExec();
                                }
                            } else {
                                if (forkJoinTask2.status >= 0 || n3 + 1 != this.top) continue;
                                if (U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask2, null)) {
                                    U.putOrderedInt(this, QTOP, n3);
                                }
                            }
                            break block12;
                        } while (--n4 != 0);
                        return false;
                    }
                    if (forkJoinTask.status >= 0) continue;
                    return false;
                }
            }
            return true;
        }

        final CountedCompleter<?> popCC(CountedCompleter<?> countedCompleter, int n) {
            block5: {
                long l;
                Object object;
                int n2 = this.top;
                if (this.base - n2 >= 0) break block5;
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                if (this.array != null && (object = U.getObjectVolatile(forkJoinTaskArray, l = (long)(((forkJoinTaskArray.length - 1 & n2 - 1) << ASHIFT) + ABASE))) != null && object instanceof CountedCompleter) {
                    CountedCompleter<?> countedCompleter2;
                    CountedCompleter<?> countedCompleter3 = countedCompleter2 = (CountedCompleter<?>)object;
                    do {
                        if (countedCompleter3 != countedCompleter) continue;
                        if (n < 0) {
                            if (!U.compareAndSwapInt(this, QLOCK, 0, 1)) break;
                            if (this.top == n2 && this.array == forkJoinTaskArray && U.compareAndSwapObject(forkJoinTaskArray, l, countedCompleter2, null)) {
                                U.putOrderedInt(this, QTOP, n2 - 1);
                                U.putOrderedInt(this, QLOCK, 0);
                                return countedCompleter2;
                            }
                            U.compareAndSwapInt(this, QLOCK, 1, 0);
                            break;
                        }
                        if (U.compareAndSwapObject(forkJoinTaskArray, l, countedCompleter2, null)) {
                            U.putOrderedInt(this, QTOP, n2 - 1);
                            return countedCompleter2;
                        }
                        break;
                    } while ((countedCompleter3 = countedCompleter3.completer) != null);
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final int pollAndExecCC(CountedCompleter<?> countedCompleter) {
            CountedCompleter<?> countedCompleter2;
            int n = this.base;
            if (n - this.top >= 0) return n | Integer.MIN_VALUE;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array == null) {
                return n | Integer.MIN_VALUE;
            }
            long l = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE;
            Object object = U.getObjectVolatile(forkJoinTaskArray, l);
            if (object == null) {
                return 2;
            }
            if (!(object instanceof CountedCompleter)) {
                return -1;
            }
            CountedCompleter<?> countedCompleter3 = countedCompleter2 = (CountedCompleter<?>)object;
            do {
                if (countedCompleter3 != countedCompleter) continue;
                if (this.base != n) return 2;
                if (!U.compareAndSwapObject(forkJoinTaskArray, l, countedCompleter2, null)) return 2;
                this.base = n + 1;
                countedCompleter2.doExec();
                return 1;
            } while ((countedCompleter3 = countedCompleter3.completer) != null);
            return -1;
        }

        final boolean isApparentlyUnblocked() {
            Thread.State state;
            ForkJoinWorkerThread forkJoinWorkerThread;
            return this.scanState >= 0 && (forkJoinWorkerThread = this.owner) != null && (state = forkJoinWorkerThread.getState()) != Thread.State.BLOCKED && state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING;
        }

        static {
            try {
                U = Unsafe.getUnsafe();
                Class<WorkQueue> clazz = WorkQueue.class;
                Class<ForkJoinTask[]> clazz2 = ForkJoinTask[].class;
                QTOP = U.objectFieldOffset(clazz.getDeclaredField("top"));
                QLOCK = U.objectFieldOffset(clazz.getDeclaredField("qlock"));
                QCURRENTSTEAL = U.objectFieldOffset(clazz.getDeclaredField("currentSteal"));
                ABASE = U.arrayBaseOffset(clazz2);
                int n = U.arrayIndexScale(clazz2);
                if ((n & n - 1) != 0) {
                    throw new Error("data type scale not a power of two");
                }
                ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }

    static final class EmptyTask
    extends ForkJoinTask<Void> {
        private static final long serialVersionUID = -7721805057305804111L;

        EmptyTask() {
            this.status = -268435456;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }

        @Override
        public final boolean exec() {
            return true;
        }
    }

    static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
            return new ForkJoinWorkerThread(forkJoinPool, true);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

