/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix.eigenvalues;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.Vector;
import ch.akuhn.matrix.eigenvalues.AllEigenvalues;
import ch.akuhn.matrix.eigenvalues.FewEigenvalues;

public class Eigenvalues {
    public double[] value;
    public Vector[] vector;
    protected int n;
    protected int nev;

    public Eigenvalues(int n) {
        this.n = n;
        this.nev = n;
    }

    public static Eigenvalues of(Matrix A) {
        if (A.columnCount() == 0) {
            Eigenvalues eigen = new Eigenvalues(0);
            eigen.value = new double[0];
            eigen.vector = new Vector[0];
            return eigen;
        }
        if (A.columnCount() == 1) {
            Eigenvalues eigen = new Eigenvalues(0);
            eigen.value = new double[]{A.get(0, 0)};
            eigen.vector = new Vector[]{Vector.from(1.0)};
            return eigen;
        }
        if (A.columnCount() < 10) {
            return new AllEigenvalues(A);
        }
        return FewEigenvalues.of(A);
    }

    public Eigenvalues largest(int nev) {
        this.nev = nev;
        return this;
    }

    public Eigenvalues run() {
        return this;
    }

    public int getN() {
        return this.n;
    }
}

