/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.point;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.point.PointList;

public class PointListConnections {
    List<int[]> connections = new ArrayList<int[]>();

    public PointListConnections() {
    }

    public PointListConnections(PointList pl, List<Line2d> lines) {
        for (Line2d line : lines) {
            int i1 = pl.points.indexOf(line.begin);
            int i2 = pl.points.indexOf(line.end);
            this.connections.add(new int[]{i1, i2});
        }
    }

    public void addConnection(int from, int to) {
        if (from == to) {
            return;
        }
        this.connections.add(new int[]{from, to});
    }

    public void addConnection(PointList pl, Point2d from, Point2d to) {
        this.addConnection(pl.points.indexOf(from), pl.points.indexOf(to));
    }

    public void addConnection(PointList pl, Line2d line) {
        this.addConnection(pl.points.indexOf(line.begin), pl.points.indexOf(line.end));
    }

    public Point2d[] getConnections(Point2d pt, PointList pl) {
        int[] conns = this.getConnections(pl.points.indexOf(pt));
        Point2d[] pts = new Point2d[conns.length];
        for (int i = 0; i < conns.length; ++i) {
            pts[i] = pl.points.get(conns[i]);
        }
        return pts;
    }

    public int[] getConnections(int id) {
        TIntArrayList conns = new TIntArrayList();
        for (int[] c : this.connections) {
            if (c[0] == id) {
                conns.add(c[1]);
            }
            if (c[1] != id) continue;
            conns.add(c[0]);
        }
        return conns.toArray();
    }

    public Line2d calculateNormalLine(Point2d pt, PointList pointList, float scale) {
        Point2dImpl normal = this.calculateNormal(pointList.points.indexOf(pt), pointList);
        if (normal == null) {
            return null;
        }
        float nx = normal.x;
        float ny = normal.y;
        Point2dImpl start = new Point2dImpl(nx * scale + pt.getX(), ny * scale + pt.getY());
        Point2dImpl end = new Point2dImpl(-(nx * scale) + pt.getX(), -(ny * scale) + pt.getY());
        return new Line2d(start, end);
    }

    public Line2d calculateNormalLine(int idx, PointList pointList, float scale) {
        return this.calculateNormalLine(pointList.points.get(idx), pointList, scale);
    }

    public Point2dImpl calculateNormal(Point2d pt, PointList pointList) {
        return this.calculateNormal(pointList.points.indexOf(pt), pointList);
    }

    public Point2dImpl calculateNormal(int id, PointList pointList) {
        int[] conns = this.getConnections(id);
        if (conns.length == 1) {
            Point2d p0 = pointList.points.get(id);
            Point2d p1 = pointList.points.get(conns[0]);
            Line2d line = new Line2d(p0, p1);
            Line2d normal = line.getNormal();
            return normal.toUnitVector();
        }
        if (conns.length == 2) {
            Point2d p0 = pointList.points.get(id);
            Point2d p1 = pointList.points.get(conns[0]);
            Point2d p2 = pointList.points.get(conns[1]);
            Line2d line1 = new Line2d(p0, p1);
            Line2d normal1 = line1.getNormal();
            Line2d line2 = new Line2d(p0, p2);
            Line2d normal2 = line2.getNormal();
            Point2dImpl n1 = normal1.toUnitVector();
            Point2dImpl n2 = normal2.toUnitVector();
            double dx = n1.x - n2.x;
            double dy = n1.y - n2.y;
            double norm = Math.sqrt(dx * dx + dy * dy);
            return new Point2dImpl((float)(dx /= norm), (float)(dy /= norm));
        }
        Point2d p0 = pointList.points.get(id);
        Line2d line = new Line2d(p0.getX() - 1.0f, p0.getY(), p0.getX() + 1.0f, p0.getY());
        return line.toUnitVector();
    }

    public List<Line2d> getLines(PointList pointList) {
        ArrayList<Line2d> lines = new ArrayList<Line2d>(this.connections.size());
        for (int[] conn : this.connections) {
            lines.add(new Line2d(pointList.points.get(conn[0]), pointList.points.get(conn[1])));
        }
        return lines;
    }
}

