/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape;

import Jama.Matrix;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.RotatedRectangle;
import org.openimaj.math.geometry.shape.Shape;

public class Circle
implements Shape {
    protected Point2d centre;
    protected float radius;

    public Circle(float x, float y, float radius) {
        this(new Point2dImpl(x, y), radius);
    }

    public Circle(Point2d centre, float radius) {
        this.centre = centre;
        this.radius = radius;
    }

    public Circle(Circle c) {
        this.centre = c.centre;
        this.radius = c.radius;
    }

    @Override
    public boolean isInside(Point2d point) {
        double dy;
        double dx = this.centre.getX() - point.getX();
        double dist = Math.sqrt(dx * dx + (dy = (double)(this.centre.getY() - point.getY())) * dy);
        return dist <= (double)this.radius;
    }

    @Override
    public Rectangle calculateRegularBoundingBox() {
        int x = Math.round(this.centre.getX() - this.radius);
        int y = Math.round(this.centre.getY() - this.radius);
        int r = Math.round(this.radius * 2.0f);
        return new Rectangle(x, y, r, r);
    }

    @Override
    public void translate(float x, float y) {
        this.centre.setX(this.centre.getX() + x);
        this.centre.setY(this.centre.getY() + y);
    }

    @Override
    public void scale(float sc) {
        this.radius *= sc;
        this.centre.setX(this.centre.getX() * sc);
        this.centre.setY(this.centre.getY() * sc);
    }

    @Override
    public void scale(Point2d centre, float sc) {
        this.translate(-centre.getX(), -centre.getY());
        this.scale(sc);
        this.translate(centre.getX(), centre.getY());
    }

    @Override
    public void scaleCentroid(float sc) {
        this.radius *= sc;
    }

    @Override
    public Point2d calculateCentroid() {
        return this.centre;
    }

    @Override
    public double calculateArea() {
        return Math.PI * (double)this.radius * (double)this.radius;
    }

    @Override
    public double minX() {
        return Math.round(this.centre.getX() - this.radius);
    }

    @Override
    public double minY() {
        return Math.round(this.centre.getY() - this.radius);
    }

    @Override
    public double maxX() {
        return Math.round(this.centre.getX() + this.radius);
    }

    @Override
    public double maxY() {
        return Math.round(this.centre.getY() + this.radius);
    }

    @Override
    public double getWidth() {
        return Math.round(2.0f * this.radius);
    }

    @Override
    public double getHeight() {
        return Math.round(2.0f * this.radius);
    }

    @Override
    public Shape transform(Matrix transform) {
        return this.asPolygon().transform(transform);
    }

    @Override
    public Polygon asPolygon() {
        int i;
        Polygon poly = new Polygon();
        Point2dImpl[] v = new Point2dImpl[360];
        for (i = 0; i < 90; ++i) {
            double theta = Math.toRadians(i);
            float xx = (float)((double)this.radius * Math.cos(theta));
            float yy = (float)((double)this.radius * Math.sin(theta));
            v[i] = new Point2dImpl(xx, yy);
            v[i + 90] = new Point2dImpl(-yy, xx);
            v[i + 180] = new Point2dImpl(-xx, -yy);
            v[i + 270] = new Point2dImpl(yy, -xx);
        }
        for (i = 0; i < 360; ++i) {
            poly.points.add(v[i]);
        }
        poly.translate(this.centre.getX(), this.centre.getY());
        return poly;
    }

    public void setX(float x) {
        this.centre.setX(x);
    }

    public void setY(float y) {
        this.centre.setY(y);
    }

    public void setRadius(float r) {
        this.radius = r;
    }

    public float getX() {
        return this.centre.getX();
    }

    public float getY() {
        return this.centre.getY();
    }

    public float getRadius() {
        return this.radius;
    }

    @Override
    public double intersectionArea(Shape that) {
        return this.intersectionArea(that, 100);
    }

    public String toString() {
        return String.format("Circle (%f, %f, %f)", Float.valueOf(this.centre.getX()), Float.valueOf(this.centre.getY()), Float.valueOf(this.radius));
    }

    @Override
    public double intersectionArea(Shape that, int nStepsPerDimention) {
        Rectangle overlapping = this.calculateRegularBoundingBox().overlapping(that.calculateRegularBoundingBox());
        if (overlapping == null) {
            return 0.0;
        }
        double intersection = 0.0;
        double step = (double)Math.max(overlapping.width, overlapping.height) / (double)nStepsPerDimention;
        double nReads = 0.0;
        float x = overlapping.x;
        while (x < overlapping.x + overlapping.width) {
            float y = overlapping.y;
            while (y < overlapping.y + overlapping.height) {
                boolean insideThis = this.isInside(new Point2dImpl(x, y));
                boolean insideThat = that.isInside(new Point2dImpl(x, y));
                nReads += 1.0;
                if (insideThis && insideThat) {
                    intersection += 1.0;
                }
                y = (float)((double)y + step);
            }
            x = (float)((double)x + step);
        }
        return intersection / nReads * (double)(overlapping.width * overlapping.height);
    }

    @Override
    public Circle clone() {
        return new Circle(this.centre.copy(), this.radius);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Circle)) {
            return false;
        }
        Circle that = (Circle)obj;
        return that.centre.equals(this.centre) && that.radius == this.radius;
    }

    @Override
    public double calculatePerimeter() {
        return Math.PI * 2 * (double)this.radius;
    }

    @Override
    public RotatedRectangle minimumBoundingRectangle() {
        return new RotatedRectangle(this.calculateRegularBoundingBox(), 0.0f);
    }

    @Override
    public boolean isConvex() {
        return true;
    }
}

