/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util.jh;

import com.github.sarxos.webcam.util.ImageUtils;
import com.github.sarxos.webcam.util.jh.JHFilter;
import java.awt.image.BufferedImage;

public class JHNormalizeFilter
extends JHFilter {
    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        int i;
        int c;
        int y;
        int x;
        int w = src.getWidth();
        int h = src.getHeight();
        int max = 1;
        for (x = 0; x < w; ++x) {
            for (y = 0; y < h; ++y) {
                int b;
                int g;
                int r;
                c = src.getRGB(x, y);
                int a = ImageUtils.clamp(c >> 24 & 0xFF);
                i = a << 24 | (r = ImageUtils.clamp(c >> 16 & 0xFF)) << 16 | (g = ImageUtils.clamp(c >> 8 & 0xFF)) << 8 | (b = ImageUtils.clamp(c & 0xFF));
                if (i <= max) continue;
                max = i;
            }
        }
        for (x = 0; x < w; ++x) {
            for (y = 0; y < h; ++y) {
                c = src.getRGB(x, y);
                i = c * 256 / max;
                dest.setRGB(x, y, i);
            }
        }
        return dest;
    }
}

